/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jpos.util.PopupListener;

public class PopupHelper {
    static Dictionary dictionary = new Hashtable();
    static MouseListener popupMouseListener = new MouseAdapter(){

        void tryPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            Component component = mouseEvent.getComponent();
            Object[] objectArray = (Object[])dictionary.get(component);
            if (objectArray == null) {
                return;
            }
            JPopupMenu jPopupMenu = (JPopupMenu)objectArray[0];
            PopupListener popupListener = (PopupListener)objectArray[1];
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            boolean bl = true;
            if (popupListener != null) {
                bl = popupListener.startPopup(n, n2);
            }
            if (bl) {
                jPopupMenu.show(component, n - 20, n2 - 10);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }
    };

    public static void setPopup(JComponent jComponent, JPopupMenu jPopupMenu) {
        PopupHelper.setPopup(jComponent, jPopupMenu, null);
    }

    public static void setPopup(JComponent jComponent, JPopupMenu jPopupMenu, PopupListener popupListener) {
        Object[] objectArray = new Object[]{jPopupMenu, popupListener};
        dictionary.put(jComponent, objectArray);
        jComponent.addMouseListener(popupMouseListener);
    }

    public static void removePopup(JComponent jComponent) {
        dictionary.remove(jComponent);
    }
}

