/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.scanner;

import com.jpos.scanner.ScanEventPool;
import com.jpos.scanner.ScanEventQueueElem;

class ScanEventQueue
extends Thread {
    private ScanEventQueueElem seqeHead;
    private ScanEventQueueElem seqeTail;
    private ScanEventPool ses;
    protected int iNumEvents;
    protected int iDataEvents;
    protected int iErrorEvents;
    protected boolean bStopThread;
    protected boolean bEnabled;
    protected boolean bDataEventEnabled;
    protected boolean bFreezeEvents;

    protected ScanEventQueue(ScanEventPool eventPool) {
        this.ses = eventPool;
        this.seqeHead = null;
        this.seqeTail = null;
        this.iNumEvents = 0;
        this.iDataEvents = 0;
        this.iErrorEvents = 0;
        this.bStopThread = true;
        this.bEnabled = false;
        this.bDataEventEnabled = false;
        this.bFreezeEvents = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            try {
                int i = 5000;
                while (!this.bStopThread) {
                    this.wait(i);
                    if (!this.bStopThread) {
                        ScanEventQueueElem localScanEventQueueEntry;
                        int j = 5000;
                        if (this.bFreezeEvents || (localScanEventQueueEntry = this.seqeHead) == null || !this.bDataEventEnabled && localScanEventQueueEntry.iEventType == 0) continue;
                        this.removeHead();
                        if (localScanEventQueueEntry.iEventType == 0) {
                            this.bDataEventEnabled = false;
                        }
                        this.ses.handleScanEvent(localScanEventQueueEntry);
                        localScanEventQueueEntry = null;
                        if (this.bFreezeEvents || !this.bDataEventEnabled || this.seqeHead == null) continue;
                        boolean bl = true;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException localInterruptedException) {
                localInterruptedException.getMessage();
            }
            catch (Exception localException) {
                localException.getMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTail(ScanEventQueueElem seqElem) {
        if (seqElem == null) {
            return;
        }
        if (seqElem.iEventType == 0) {
            if (!this.bEnabled) {
                return;
            }
            this.ses.receiveScanData();
        }
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            seqElem.seqeNext = null;
            if (this.seqeTail == null) {
                this.seqeHead = seqElem;
                seqElem.seqePrev = null;
            } else {
                seqElem.seqePrev = this.seqeTail;
                this.seqeTail.seqeNext = seqElem;
            }
            this.seqeTail = seqElem;
            ++this.iNumEvents;
            if (seqElem.iEventType == 0) {
                ++this.iDataEvents;
            } else if (seqElem.iEventType == 2) {
                ++this.iErrorEvents;
            }
            if (!this.bFreezeEvents) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScanEventQueueElem removeHead() {
        ScanEventQueueElem localScanEventQueueEntry;
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            localScanEventQueueEntry = this.seqeHead;
            if (localScanEventQueueEntry != null) {
                this.seqeHead = localScanEventQueueEntry.seqeNext;
                localScanEventQueueEntry.seqeNext = null;
                if (this.seqeHead == null) {
                    this.seqeTail = null;
                } else {
                    this.seqeHead.seqePrev = null;
                }
                --this.iNumEvents;
                if (localScanEventQueueEntry.iEventType == 0) {
                    --this.iDataEvents;
                } else if (localScanEventQueueEntry.iEventType == 2) {
                    --this.iErrorEvents;
                }
            }
        }
        return localScanEventQueueEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Clear() {
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            while (this.removeHead() != null) {
            }
        }
    }
}

