/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.Biometrics;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class BiometricsPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -3504677363114146010L;
    protected MainButtonPanel mainButtonPanel;
    private Biometrics biometrics = new Biometrics();
    private String defaultLogicalName = "defaultbiometrics";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public BiometricsPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        JLabel label = new JLabel("Not yet implemented.");
        label.setAlignmentX(0.5f);
        statusPanel.add(label);
        statusPanel.add(Box.createHorizontalGlue());
        subPanel.add(statusPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("Biometrics received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.biometrics.addStatusUpdateListener((StatusUpdateListener)this);
                this.biometrics.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.biometrics.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.biometrics.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.biometrics.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.biometrics.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.biometrics.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.biometrics.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.biometrics.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.biometrics.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.biometrics.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.biometrics.getCapPowerReporting() == 2 ? "Advanced" : (this.biometrics.getCapPowerReporting() == 1 ? "Standard" : "None"));
                msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.biometrics.getCapStatisticsReporting();
                msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.biometrics.getCapUpdateStatistics();
                msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.biometrics.getCapCompareFirmwareVersion();
                msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.biometrics.getCapUpdateFirmware();
                msg = String.valueOf(msg) + "\n AgorithmList: " + this.biometrics.getAlgorithmList();
                msg = String.valueOf(msg) + "\n CapPrematchData: " + this.biometrics.getCapPrematchData();
                msg = String.valueOf(msg) + "\n CapRawSensorData: " + this.biometrics.getCapRawSensorData();
                msg = String.valueOf(msg) + "\n CapRealTimeData: " + this.biometrics.getCapRealTimeData();
                msg = String.valueOf(msg) + "\n CapSensorColor: " + this.getCapSensorColorString(this.biometrics.getSensorColor());
                msg = String.valueOf(msg) + "\n CapSensorOrientation: " + this.getCapSensorOrientationString(this.biometrics.getCapSensorOrientation());
                msg = String.valueOf(msg) + "\n CapSensorType: " + this.getCapSensorTypeString(this.biometrics.getCapSensorType());
                msg = String.valueOf(msg) + "\n CapTemplateAdaptation: " + this.biometrics.getCapTemplateAdaptation();
                msg = String.valueOf(msg) + "\n SensorBPP: " + new Integer(this.biometrics.getSensorBPP()).toString();
                msg = String.valueOf(msg) + "\n SensorHeight: " + new Integer(this.biometrics.getSensorHeight()).toString();
                msg = String.valueOf(msg) + "\n SensorWidth: " + new Integer(this.biometrics.getSensorWidth()).toString();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.biometrics);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.biometrics);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.biometrics.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.biometrics.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("BiometricsPanel: MethodListener: JposException");
        }
    }

    String getCapSensorColorString(int cap) {
        String retval = "";
        if ((cap & 1) > 0) {
            retval = String.valueOf(retval) + "Bi-tonal ( B/W ), ";
        }
        if ((cap & 2) > 0) {
            retval = String.valueOf(retval) + "Gray scale, ";
        }
        if ((cap & 4) > 0) {
            retval = String.valueOf(retval) + "16 Colors, ";
        }
        if ((cap & 8) > 0) {
            retval = String.valueOf(retval) + "256 Colors, ";
        }
        if ((cap & 0x10) > 0) {
            retval = String.valueOf(retval) + "Full colors, ";
        }
        return retval;
    }

    String getCapSensorOrientationString(int cap) {
        String retval;
        switch (cap) {
            case 1: {
                retval = "0 deg.";
                break;
            }
            case 2: {
                retval = "90 deg.";
                break;
            }
            case 4: {
                retval = "180 deg.";
                break;
            }
            case 8: {
                retval = "270 deg.";
                break;
            }
            default: {
                retval = "Driver returned ivalid response";
            }
        }
        return retval;
    }

    String getCapSensorTypeString(int cap) {
        String retval = "";
        if ((cap & 1) > 0) {
            retval = String.valueOf(retval) + "Facial Features/Topography, ";
        }
        if ((cap & 2) > 0) {
            retval = String.valueOf(retval) + "Voice, ";
        }
        if ((cap & 4) > 0) {
            retval = String.valueOf(retval) + "Fingerprint, ";
        }
        if ((cap & 8) > 0) {
            retval = String.valueOf(retval) + "Iris, ";
        }
        if ((cap & 0x10) > 0) {
            retval = String.valueOf(retval) + "Retina, ";
        }
        if ((cap & 0x20) > 0) {
            retval = String.valueOf(retval) + "Hand Geometry, ";
        }
        if ((cap & 0x40) > 0) {
            retval = String.valueOf(retval) + "Signature, ";
        }
        if ((cap & 0x80) > 0) {
            retval = String.valueOf(retval) + "Keystrokes, ";
        }
        if ((cap & 0x100) > 0) {
            retval = String.valueOf(retval) + "Lip Movement, ";
        }
        if ((cap & 0x200) > 0) {
            retval = String.valueOf(retval) + "Face Image, ";
        }
        if ((cap & 0x400) > 0) {
            retval = String.valueOf(retval) + "Hand Image, ";
        }
        if ((cap & 0x800) > 0) {
            retval = String.valueOf(retval) + "Gait/Stride, ";
        }
        if ((cap & 0x1000) > 0) {
            retval = String.valueOf(retval) + "Password, ";
        }
        return retval;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == BiometricsPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        BiometricsPanel.this.biometrics.setDeviceEnabled(false);
                    } else {
                        BiometricsPanel.this.biometrics.setDeviceEnabled(true);
                    }
                } else if (source == BiometricsPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        BiometricsPanel.this.biometrics.setFreezeEvents(false);
                    } else {
                        BiometricsPanel.this.biometrics.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("BiometricsPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (BiometricsPanel.this.biometrics != null) {
                BiometricsPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(BiometricsPanel.this.biometrics.getState()));
            }
        }
    }
}

