/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.ElectronicJournal;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class ElectronicJournalPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -3504677263114136010L;
    protected MainButtonPanel mainButtonPanel;
    private ElectronicJournal electronicJournal = new ElectronicJournal();
    private String defaultLogicalName = "defaultElectronicJournal";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public ElectronicJournalPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        JLabel label = new JLabel("Not yet implemented.");
        label.setAlignmentX(0.5f);
        statusPanel.add(label);
        statusPanel.add(Box.createHorizontalGlue());
        subPanel.add(statusPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("ElectronicJournal received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.electronicJournal.addStatusUpdateListener((StatusUpdateListener)this);
                this.electronicJournal.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.electronicJournal.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.electronicJournal.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.electronicJournal.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.electronicJournal.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.electronicJournal.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.electronicJournal.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.electronicJournal.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.electronicJournal.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.electronicJournal.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.electronicJournal.getCapPowerReporting() == 2 ? "Advanced" : (this.electronicJournal.getCapPowerReporting() == 1 ? "Standard" : "None"));
                msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.electronicJournal.getCapStatisticsReporting();
                msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.electronicJournal.getCapUpdateStatistics();
                msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.electronicJournal.getCapCompareFirmwareVersion();
                msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.electronicJournal.getCapUpdateFirmware();
                msg = String.valueOf(msg) + "\nCapAddMarker: " + this.electronicJournal.getCapAddMarker();
                msg = String.valueOf(msg) + "\nCapErasableMedium: " + this.electronicJournal.getCapErasableMedium();
                msg = String.valueOf(msg) + "\nCapInitializeMedium: " + this.electronicJournal.getCapInitializeMedium();
                msg = String.valueOf(msg) + "\nCapMediumIsAvailable: " + this.electronicJournal.getCapMediumIsAvailable();
                msg = String.valueOf(msg) + "\nCapPrintContent: " + this.electronicJournal.getCapPrintContent();
                msg = String.valueOf(msg) + "\nCapPrintContentFile: " + this.electronicJournal.getCapPrintContentFile();
                msg = String.valueOf(msg) + "\nCapRetrieveCurrentMarker: " + this.electronicJournal.getCapRetrieveCurrentMarker();
                msg = String.valueOf(msg) + "\nCapRetrieveMarker: " + this.electronicJournal.getCapRetrieveMarker();
                msg = String.valueOf(msg) + "\nCapRetrieveMarkerByDateTime: " + this.electronicJournal.getCapRetrieveMarkerByDateTime();
                msg = String.valueOf(msg) + "\nCapRetrieveMarkersDateTime: " + this.electronicJournal.getCapRetrieveMarkersDateTime();
                msg = String.valueOf(msg) + "\nCapStation: " + this.getCapStationString(this.electronicJournal.getCapStation());
                msg = String.valueOf(msg) + "\nCapStorageEnabled: " + this.electronicJournal.getCapStorageEnabled();
                msg = String.valueOf(msg) + "\nCapSuspendPrintContent: " + this.electronicJournal.getCapSuspendPrintContent();
                msg = String.valueOf(msg) + "\nCapSuspendQueryContent: " + this.electronicJournal.getCapSuspendQueryContent();
                msg = String.valueOf(msg) + "\nCapWaterMark: " + this.electronicJournal.getCapWaterMark();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.electronicJournal);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.electronicJournal);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.electronicJournal.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.electronicJournal.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("BiometricsPanel: MethodListener: JposException");
        }
    }

    String getCapStationString(int cap) {
        String retval = "";
        if ((cap & 1) > 0) {
            retval = String.valueOf(retval) + "Receipt, ";
        }
        if ((cap & 2) > 0) {
            retval = String.valueOf(retval) + "Slip, ";
        }
        if ((cap & 4) > 0) {
            retval = String.valueOf(retval) + "Journal, ";
        }
        return retval;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == ElectronicJournalPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        ElectronicJournalPanel.this.electronicJournal.setDeviceEnabled(false);
                    } else {
                        ElectronicJournalPanel.this.electronicJournal.setDeviceEnabled(true);
                    }
                } else if (source == ElectronicJournalPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        ElectronicJournalPanel.this.electronicJournal.setFreezeEvents(false);
                    } else {
                        ElectronicJournalPanel.this.electronicJournal.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("BiometricsPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (ElectronicJournalPanel.this.electronicJournal != null) {
                ElectronicJournalPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(ElectronicJournalPanel.this.electronicJournal.getState()));
            }
        }
    }
}

