/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jpos.HardTotals;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class HardTotalsPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -3416954127723228837L;
    protected MainButtonPanel mainButtonPanel;
    private HardTotals hardTotals;
    private String defaultLogicalName = "defaultHardTotals";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JTextArea results;
    boolean hardTotalsOpened = false;
    private HardTotalsListener htListen;
    private JButton htReadButton = new JButton("Read");
    private JButton htWriteButton = new JButton("Write");
    private JButton htClaimFileButton = new JButton("Claim File");
    private JButton htReleaseFileButton = new JButton("Release File");
    private JButton htSetAllButton = new JButton("Set All");
    private JButton htValidateDataButton = new JButton("Validate Data");
    private JButton htRecalculateButton = new JButton("Recalculate");
    private JButton htCreateButton = new JButton("Create");
    private JButton htFindButton = new JButton("Find");
    private JButton htFindByIndexButton = new JButton("Find by Index");
    private JButton htDeleteButton = new JButton("Delete");
    private JButton htRenameButton = new JButton("Rename");
    private JButton htBeginTransButton = new JButton("Begin Trans");
    private JButton htCommitTransButton = new JButton("Commit Trans");
    private JButton htRollbackButton = new JButton("Rollback");
    private JButton clearResultsButton = new JButton("Clear Results");
    private JTextField htCursorSet = new JTextField(5);
    private JTextField htTextOut = new JTextField(5);
    private JTextField htFile = new JTextField(5);
    private JCheckBox htErrorDetect = new JCheckBox("CapErrorDetection", false);
    private JCheckBox htSingleFile = new JCheckBox("CapSingleFile", false);
    private JCheckBox htTransactions = new JCheckBox("CapTransactions", false);
    private JCheckBox htTransactionsInProgress = new JCheckBox("Transactions in Progress", false);
    private JTextField htFreeData = new JTextField(10);
    private JTextField htTotalsSize = new JTextField(10);
    private JTextField htNumberOfFiles = new JTextField(10);
    private JTextField htByteArraySize = new JTextField(10);
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    protected int hTotalsFile;
    protected boolean update;
    protected int handle;
    protected int offset;
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;

    public HardTotalsPanel() {
        this.hardTotals = new HardTotals();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        this.htListen = new HardTotalsListener();
        JPanel hardTotalsPanel = new JPanel();
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(0);
        hardTotalsPanel.setLayout(fl);
        JPanel hardTotalsROPanel = new JPanel();
        hardTotalsROPanel.setLayout(new GridLayout(5, 2));
        hardTotalsROPanel.setBorder(new TitledBorder("Read-Only Properties"));
        hardTotalsROPanel.add(this.htErrorDetect);
        hardTotalsROPanel.add(this.htSingleFile);
        hardTotalsROPanel.add(this.htTransactions);
        hardTotalsROPanel.add(this.htTransactionsInProgress);
        JLabel htlabel1 = new JLabel("Free Data");
        JLabel htlabel2 = new JLabel("Totals Size");
        JLabel htlabel3 = new JLabel("Number Of Files");
        hardTotalsROPanel.add(htlabel1);
        hardTotalsROPanel.add(this.htFreeData);
        hardTotalsROPanel.add(htlabel2);
        hardTotalsROPanel.add(this.htTotalsSize);
        hardTotalsROPanel.add(htlabel3);
        hardTotalsROPanel.add(this.htNumberOfFiles);
        this.htFreeData.setEnabled(false);
        this.htTotalsSize.setEnabled(false);
        this.htNumberOfFiles.setEnabled(false);
        this.htErrorDetect.setEnabled(false);
        this.htTransactions.setEnabled(false);
        this.htTransactionsInProgress.setEnabled(false);
        this.htSingleFile.setEnabled(false);
        JPanel htCursorPanel = new JPanel();
        htCursorPanel.setLayout(new GridLayout(4, 2));
        htCursorPanel.setBorder(new TitledBorder("File/Cursor"));
        htCursorPanel.add(new JLabel("Current File Handle"));
        htCursorPanel.add(this.htFile);
        this.htFile.setToolTipText("enter integer");
        htCursorPanel.add(new JLabel("Offset for next method"));
        htCursorPanel.add(this.htCursorSet);
        this.htCursorSet.setToolTipText("enter < 0 - (ByteArraySize-1) >");
        htCursorPanel.add(new JLabel("Text for next method"));
        htCursorPanel.add(this.htTextOut);
        this.htTextOut.setToolTipText("enter any text, strings or integers");
        htCursorPanel.add(new JLabel("Byte Array Size"));
        htCursorPanel.add(this.htByteArraySize);
        this.htByteArraySize.setToolTipText("enter integer > 400, will be set to 400 by default");
        JPanel htIOPanel = new JPanel();
        htIOPanel.setLayout(new GridLayout(3, 8, 7, 7));
        htIOPanel.setBorder(new TitledBorder("Specific Methods"));
        htIOPanel.add(this.htReadButton);
        htIOPanel.add(this.htWriteButton);
        htIOPanel.add(this.htCreateButton);
        this.htCreateButton.setActionCommand("nohandle");
        htIOPanel.add(this.htClaimFileButton);
        htIOPanel.add(this.htReleaseFileButton);
        htIOPanel.add(this.htSetAllButton);
        htIOPanel.add(this.htValidateDataButton);
        htIOPanel.add(this.htRecalculateButton);
        htIOPanel.add(this.htFindButton);
        this.htFindButton.setActionCommand("nohandle");
        htIOPanel.add(this.htFindByIndexButton);
        htIOPanel.add(this.htDeleteButton);
        this.htDeleteButton.setActionCommand("nohandle");
        htIOPanel.add(this.htRenameButton);
        htIOPanel.add(this.htBeginTransButton);
        this.htBeginTransButton.setActionCommand("nohandle");
        htIOPanel.add(this.htCommitTransButton);
        this.htCommitTransButton.setActionCommand("nohandle");
        htIOPanel.add(this.htRollbackButton);
        this.htRollbackButton.setActionCommand("nohandle");
        hardTotalsPanel.add(hardTotalsROPanel);
        hardTotalsPanel.add(htCursorPanel);
        hardTotalsPanel.add(htIOPanel);
        this.htReadButton.addActionListener(this.htListen);
        this.htReadButton.setToolTipText("Read a series of bytes");
        this.htWriteButton.addActionListener(this.htListen);
        this.htWriteButton.setToolTipText("Write a series of bytes");
        this.htClaimFileButton.addActionListener(this.htListen);
        this.htClaimFileButton.setToolTipText("Claim a specific file");
        this.htReleaseFileButton.addActionListener(this.htListen);
        this.htReleaseFileButton.setToolTipText("Release access to a file");
        this.htSetAllButton.addActionListener(this.htListen);
        this.htSetAllButton.setToolTipText("Set all data in totals file to a value ");
        this.htValidateDataButton.addActionListener(this.htListen);
        this.htValidateDataButton.setToolTipText("Validate data in totals file");
        this.htRecalculateButton.addActionListener(this.htListen);
        this.htRecalculateButton.setToolTipText("Recalculate validation data in totals file");
        this.htCreateButton.addActionListener(this.htListen);
        this.htCreateButton.setToolTipText("Create a totals file ");
        this.htFindButton.addActionListener(this.htListen);
        this.htFindButton.setToolTipText("Find totals file by name");
        this.htFindByIndexButton.addActionListener(this.htListen);
        this.htFindByIndexButton.setToolTipText("Enumerate all files in Hard Totals area");
        this.htDeleteButton.addActionListener(this.htListen);
        this.htDeleteButton.setToolTipText("Delete a totals file by name");
        this.htRenameButton.addActionListener(this.htListen);
        this.htRenameButton.setToolTipText("Rename an existing totals file");
        this.htBeginTransButton.addActionListener(this.htListen);
        this.htBeginTransButton.setToolTipText("Marks beginning of a transaction");
        this.htCommitTransButton.addActionListener(this.htListen);
        this.htCommitTransButton.setToolTipText("Ends the current transaction,and saves the updated data");
        this.htRollbackButton.addActionListener(this.htListen);
        this.htRollbackButton.setToolTipText("Ends the current transaction,and discards the updates");
        JPanel resultsPanel = new JPanel();
        this.results = new JTextArea();
        this.results.setFont(new Font("arialnarrow", 1, 10));
        this.results.setLineWrap(true);
        this.results.setWrapStyleWord(true);
        this.results.setEditable(false);
        JScrollPane resultsScrollPane = new JScrollPane(this.results);
        resultsScrollPane.setVerticalScrollBarPolicy(22);
        resultsScrollPane.setPreferredSize(new Dimension(300, 100));
        resultsScrollPane.setBorder(BorderFactory.createTitledBorder("Results"));
        resultsPanel.add(resultsScrollPane);
        resultsPanel.add(this.clearResultsButton);
        mainPanel.add(hardTotalsROPanel);
        mainPanel.add(htCursorPanel);
        mainPanel.add(htIOPanel);
        mainPanel.add(resultsPanel);
        this.clearResultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HardTotalsPanel.this.results.setText("");
            }
        });
        return mainPanel;
    }

    protected void setHandleTotalsFile(int htf) {
        this.hTotalsFile = htf;
    }

    protected int getHandleTotalsFile() {
        return this.hTotalsFile;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("HardTotals received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.hardTotals.addStatusUpdateListener((StatusUpdateListener)this);
                this.hardTotals.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.hardTotals.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.hardTotals.claim(1000);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.hardTotals.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.hardTotals.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.hardTotals.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.hardTotals.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.hardTotals.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.hardTotals.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.hardTotals.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.hardTotals.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.hardTotals.getCapPowerReporting() == 2 ? "Advanced" : (this.hardTotals.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.hardTotals.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.hardTotals.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.hardTotals.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.hardTotals.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapErrorDetection: " + this.hardTotals.getCapErrorDetection();
                msg = String.valueOf(msg) + "\nCapSingleFile: " + this.hardTotals.getCapSingleFile();
                msg = String.valueOf(msg) + "\nCapTransactions: " + this.hardTotals.getCapTransactions();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.hardTotals.addStatusUpdateListener((StatusUpdateListener)this);
                this.hardTotals.open(logicalName);
                this.hardTotals.claim(1000);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.hardTotals.setDeviceEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.hardTotals);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.hardTotals);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.hardTotals.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.hardTotals.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("HardTotalsPanel: MethodListener: JposException");
        }
    }

    private class HardTotalsListener
    implements ActionListener {
        HardTotalsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean update = false;
            boolean handlevalid = true;
            Object obj = e.getSource();
            int handle = 0;
            HardTotalsPanel.this.results.append("\nin HardTotalsListener method\n");
            try {
                handle = new Integer(HardTotalsPanel.this.htFile.getText());
            }
            catch (Exception exc) {
                handlevalid = false;
            }
            try {
                if (e.getActionCommand().equals("nohandle")) {
                    int[] nhandle;
                    if (obj == HardTotalsPanel.this.htRollbackButton) {
                        HardTotalsPanel.this.hardTotals.rollback();
                        HardTotalsPanel.this.results.append("Rollback successful\n");
                    }
                    if (obj == HardTotalsPanel.this.htCommitTransButton) {
                        HardTotalsPanel.this.hardTotals.commitTrans();
                        HardTotalsPanel.this.results.append("Commit Transaction successful\n");
                    }
                    if (obj == HardTotalsPanel.this.htBeginTransButton) {
                        HardTotalsPanel.this.hardTotals.beginTrans();
                        HardTotalsPanel.this.results.append("Begin Transaction successful\n");
                    }
                    if (obj == HardTotalsPanel.this.htDeleteButton) {
                        HardTotalsPanel.this.hardTotals.delete(HardTotalsPanel.this.htTextOut.getText());
                        update = true;
                        HardTotalsPanel.this.results.append("Delete successful\n");
                    }
                    if (obj == HardTotalsPanel.this.htFindButton) {
                        nhandle = new int[1];
                        int[] nsize = new int[1];
                        HardTotalsPanel.this.hardTotals.find(HardTotalsPanel.this.htTextOut.getText(), nhandle, nsize);
                        HardTotalsPanel.this.results.append("Found " + HardTotalsPanel.this.htTextOut.getText() + " handle = " + String.valueOf(nhandle[0]) + " and size = " + String.valueOf(nsize[0]) + "\n");
                    }
                    if (obj == HardTotalsPanel.this.htCreateButton) {
                        nhandle = new int[1];
                        int arraySize = new Integer(HardTotalsPanel.this.htByteArraySize.getText());
                        System.out.println(arraySize);
                        if (arraySize > 400) {
                            HardTotalsPanel.this.hardTotals.create(HardTotalsPanel.this.htTextOut.getText(), nhandle, arraySize, HardTotalsPanel.this.htErrorDetect.isSelected());
                            HardTotalsPanel.this.htFile.setText(String.valueOf(nhandle[0]));
                            update = true;
                            HardTotalsPanel.this.results.append("Create successful\n");
                        } else {
                            HardTotalsPanel.this.hardTotals.create(HardTotalsPanel.this.htTextOut.getText(), nhandle, 400, HardTotalsPanel.this.htErrorDetect.isSelected());
                            HardTotalsPanel.this.htFile.setText(String.valueOf(nhandle[0]));
                            update = true;
                            HardTotalsPanel.this.results.append("Create successful\n");
                        }
                    }
                } else if (!handlevalid) {
                    HardTotalsPanel.this.results.append("Handle not a valid number *** !true ***\n");
                } else {
                    if (obj == HardTotalsPanel.this.htSetAllButton) {
                        String x = HardTotalsPanel.this.htTextOut.getText();
                        byte temp = x.equals("") ? (byte)0 : (byte)x.charAt(0);
                        HardTotalsPanel.this.hardTotals.setAll(handle, temp);
                        HardTotalsPanel.this.results.append("SetAll successful\n");
                        System.out.println("Pressed Set All Button!");
                    }
                    if (obj == HardTotalsPanel.this.htRecalculateButton) {
                        HardTotalsPanel.this.hardTotals.recalculateValidationData(handle);
                        HardTotalsPanel.this.results.append("Recalculate successful\n");
                        System.out.println("Pressed Recalculate Data Button!");
                    }
                    if (obj == HardTotalsPanel.this.htValidateDataButton) {
                        HardTotalsPanel.this.hardTotals.validateData(handle);
                        HardTotalsPanel.this.results.append("ValidateData successful\n");
                        System.out.println("Pressed Validate Data Button");
                    }
                    if (obj == HardTotalsPanel.this.htReleaseFileButton) {
                        HardTotalsPanel.this.hardTotals.releaseFile(handle);
                        HardTotalsPanel.this.results.append("Release File successful\n");
                        System.out.println("Pressed Release File Button!");
                    }
                    if (obj == HardTotalsPanel.this.htClaimFileButton) {
                        HardTotalsPanel.this.hardTotals.claimFile(handle, 200);
                        HardTotalsPanel.this.results.append("ClaimFile successful\n");
                        System.out.println("Pressed Claim File Button!");
                    }
                    if (obj == HardTotalsPanel.this.htRenameButton) {
                        HardTotalsPanel.this.hardTotals.rename(handle, HardTotalsPanel.this.htTextOut.getText());
                        HardTotalsPanel.this.results.append("Rename successful\n");
                        System.out.println("Pressed Rename Button!");
                    }
                    if (obj == HardTotalsPanel.this.htFindByIndexButton) {
                        String[] data = new String[1];
                        HardTotalsPanel.this.hardTotals.findByIndex(handle, data);
                        HardTotalsPanel.this.results.append("Found index " + String.valueOf(handle) + " name = \"" + data[0] + "\"\n");
                    }
                    if (obj == HardTotalsPanel.this.htWriteButton || obj == HardTotalsPanel.this.htReadButton) {
                        int offset = 0;
                        try {
                            offset = new Integer(HardTotalsPanel.this.htCursorSet.getText());
                        }
                        catch (Exception rwexc) {
                            HardTotalsPanel.this.results.append("Offset for next method is not a valid number\n");
                            handlevalid = false;
                        }
                        if (handlevalid) {
                            if (obj == HardTotalsPanel.this.htWriteButton) {
                                byte[] outs = HardTotalsPanel.this.htTextOut.getText().getBytes();
                                HardTotalsPanel.this.hardTotals.write(handle, outs, offset, outs.length);
                                HardTotalsPanel.this.results.append("Write successful\n");
                            }
                            if (obj == HardTotalsPanel.this.htReadButton) {
                                try {
                                    int len = new Integer(HardTotalsPanel.this.htTextOut.getText());
                                    byte[] data = new byte[len];
                                    HardTotalsPanel.this.hardTotals.read(handle, data, offset, len);
                                    HardTotalsPanel.this.results.append("read \"" + new String(data));
                                    HardTotalsPanel.this.results.append("\"  \n");
                                }
                                catch (NumberFormatException nfe) {
                                    HardTotalsPanel.this.results.append("Text for next method is not a valid size for read\n");
                                }
                            }
                        }
                    }
                }
                if (update) {
                    HardTotalsPanel.this.htTotalsSize.setText(String.valueOf(HardTotalsPanel.this.hardTotals.getTotalsSize()));
                    HardTotalsPanel.this.htFreeData.setText(String.valueOf(HardTotalsPanel.this.hardTotals.getFreeData()));
                    HardTotalsPanel.this.htNumberOfFiles.setText(String.valueOf(HardTotalsPanel.this.hardTotals.getNumberOfFiles()));
                    HardTotalsPanel.this.htErrorDetect.setSelected(HardTotalsPanel.this.hardTotals.getCapErrorDetection());
                    HardTotalsPanel.this.htSingleFile.setSelected(HardTotalsPanel.this.hardTotals.getCapSingleFile());
                    HardTotalsPanel.this.htTransactions.setSelected(HardTotalsPanel.this.hardTotals.getCapTransactions());
                    HardTotalsPanel.this.htTransactionsInProgress.setSelected(HardTotalsPanel.this.hardTotals.getTransactionInProgress());
                }
            }
            catch (JposException ex) {
                System.err.println("Jpos exception " + (Object)((Object)ex));
                HardTotalsPanel.this.results.append("STOP THAT!!!!!!!");
                HardTotalsPanel.this.results.append("Stop going straight to JposException");
            }
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == HardTotalsPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        HardTotalsPanel.this.hardTotals.setDeviceEnabled(false);
                    } else {
                        HardTotalsPanel.this.hardTotals.setDeviceEnabled(true);
                    }
                } else if (source == HardTotalsPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        HardTotalsPanel.this.hardTotals.setFreezeEvents(false);
                    } else {
                        HardTotalsPanel.this.hardTotals.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("HardTotalsPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (HardTotalsPanel.this.hardTotals != null) {
                HardTotalsPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(HardTotalsPanel.this.hardTotals.getState()));
            }
        }
    }
}

