/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.JposException;
import jpos.Keylock;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class KeylockPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -4978509274426826670L;
    protected MainButtonPanel mainButtonPanel;
    private Keylock keylock = new Keylock();
    private String defaultLogicalName = "defaultKeylock";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JLabel numPosLabel;
    private JLabel currentPosLabel;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;

    public KeylockPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        JLabel label = new JLabel("Number of positions: ");
        label.setAlignmentX(1.0f);
        Font f = label.getFont();
        Font newf = new Font(f.getName(), 1, 20);
        label.setFont(newf);
        labelPanel.add(label);
        label = new JLabel("Current position: ");
        label.setAlignmentX(1.0f);
        label.setFont(newf);
        labelPanel.add(label);
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BoxLayout(valuePanel, 1));
        this.numPosLabel = new JLabel(" ");
        this.numPosLabel.setAlignmentX(0.0f);
        this.currentPosLabel = new JLabel(" ");
        this.currentPosLabel.setAlignmentX(0.0f);
        this.numPosLabel.setFont(newf);
        this.currentPosLabel.setFont(newf);
        valuePanel.add(this.numPosLabel);
        valuePanel.add(this.currentPosLabel);
        statusPanel.add(labelPanel);
        statusPanel.add(valuePanel);
        subPanel.add(statusPanel);
        subPanel.add(Box.createHorizontalGlue());
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        this.refreshKeyPos();
    }

    private void refreshKeyPos() {
        try {
            String label = "";
            switch (this.keylock.getKeyPosition()) {
                case 1: {
                    label = " ( LOCK )";
                    break;
                }
                case 2: {
                    label = " ( NORM )";
                    break;
                }
                case 3: {
                    label = " ( SUPR )";
                }
            }
            this.currentPosLabel.setText(String.valueOf(Integer.toString(this.keylock.getKeyPosition())) + label);
        }
        catch (JposException e) {
            JOptionPane.showMessageDialog(null, "Exception in getKeyPosition(): " + e.getMessage(), "Failed", 0);
            System.err.println("Jpos exception " + (Object)((Object)e));
        }
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.keylock.addStatusUpdateListener((StatusUpdateListener)this);
                this.keylock.open(logicalName);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.numPosLabel.setText(Integer.toString(this.keylock.getPositionCount()));
                int version = this.keylock.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.keylock.claim(0);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.keylock.release();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.keylock.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
                this.numPosLabel.setText(" ");
                this.currentPosLabel.setText(" ");
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.keylock.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.keylock.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.keylock.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.keylock.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.keylock.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.keylock.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.keylock.getCapPowerReporting() == 2 ? "Advanced" : (this.keylock.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.keylock.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.keylock.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.keylock.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.keylock.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        }
        if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.keylock.addStatusUpdateListener((StatusUpdateListener)this);
                this.keylock.open(logicalName);
                this.keylock.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.keylock.setDeviceEnabled(true);
                this.numPosLabel.setText(Integer.toString(this.keylock.getPositionCount()));
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.keylock);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.keylock);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            if (this.keylock.getState() != 1) {
                this.deviceEnabledCB.setSelected(this.keylock.getDeviceEnabled());
                this.freezeEventsCB.setSelected(this.keylock.getFreezeEvents());
            }
        }
        catch (JposException je) {
            System.err.println("KeylockPanel: MethodListener: JposException");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == KeylockPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        KeylockPanel.this.keylock.setDeviceEnabled(false);
                    } else {
                        KeylockPanel.this.keylock.setDeviceEnabled(true);
                        KeylockPanel.this.refreshKeyPos();
                    }
                } else if (source == KeylockPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        KeylockPanel.this.keylock.setFreezeEvents(false);
                    } else {
                        KeylockPanel.this.keylock.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("KeylockPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (KeylockPanel.this.keylock != null) {
                KeylockPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(KeylockPanel.this.keylock.getState()));
            }
        }
    }
}

