/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpos.JposException;
import jpos.LineDisplay;

public class LineDisplayPanel
extends Component {
    private static final long serialVersionUID = -7597165738110136547L;
    protected MainButtonPanel mainButtonPanel;
    private LineDisplay lineDisplay;
    private String defaultLogicalName = "defaultLineDisplay";
    private JTextField lineDisplayData;
    private JTextField windowVPRow;
    private JTextField windowVPCol;
    private JTextField windowVPHeight;
    private JTextField windowVPWidth;
    private JTextField windowWHeight;
    private JTextField windowWWidth;
    private JLabel brLabel;
    private JTextField brVal;
    private JButton blinkRateButton;
    private JComboBox rowCombo;
    private JComboBox columnCombo;
    private JComboBox attrCombo;
    private JComboBox descCombo;
    private JButton descOnButton;
    private JButton descOffButton;
    private JButton descClearButton;
    private JList windowList;
    private DefaultListModel windowListModel;
    private JButton displayTextAtButton;
    private JButton displayTextButton;
    private JButton clearTextButton;
    private JButton moveCursorButton;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JLabel label;
    private JButton addWindowButton;
    private JButton delWindowButton;
    private JButton setCurrentWindowButton;
    private JButton refreshWindowButton;
    private JButton shiftUpButton;
    private JButton shiftDownButton;
    private JButton shiftRightButton;
    private JButton shiftLeftButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private JSlider brightnessSlider;
    private MethodListener methodListener = new MethodListener();
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;

    public LineDisplayPanel() {
        this.lineDisplay = new LineDisplay();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this.methodListener, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        subPanel.setMinimumSize(new Dimension(Short.MAX_VALUE, 370));
        subPanel.setPreferredSize(new Dimension(Short.MAX_VALUE, 370));
        subPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 400));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel lineDisplayOutputPanel = new JPanel();
        lineDisplayOutputPanel.setLayout(new BoxLayout(lineDisplayOutputPanel, 1));
        lineDisplayOutputPanel.setAlignmentY(0.0f);
        lineDisplayOutputPanel.setMinimumSize(new Dimension(600, 370));
        lineDisplayOutputPanel.setPreferredSize(new Dimension(600, 370));
        lineDisplayOutputPanel.setMaximumSize(new Dimension(600, 370));
        JPanel topRowPanel = new JPanel();
        topRowPanel.setLayout(new BoxLayout(topRowPanel, 0));
        JPanel bottomRowPanel = new JPanel();
        bottomRowPanel.setLayout(new BoxLayout(bottomRowPanel, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        DisplayTextPanel dtp = new DisplayTextPanel();
        tabbedPane.addTab("Display Text", null, dtp.make(), "DisplayText");
        WindowManagementPanel wmp = new WindowManagementPanel();
        tabbedPane.addTab("Window Control", null, wmp.make(), "WindowControl");
        MiscControlPanel mcp = new MiscControlPanel();
        tabbedPane.addTab("Misc Controls", null, mcp.make(), "MiscCtrl");
        topRowPanel.add(tabbedPane);
        topRowPanel.setAlignmentY(0.0f);
        lineDisplayOutputPanel.add(topRowPanel);
        lineDisplayOutputPanel.add(bottomRowPanel);
        subPanel.add(lineDisplayOutputPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    private void updateRowColumn() throws JposException {
        int rows = this.lineDisplay.getRows();
        int cols = this.lineDisplay.getColumns();
        this.rowCombo.removeAllItems();
        this.columnCombo.removeAllItems();
        int i = 0;
        while (i < rows) {
            this.rowCombo.addItem(new Integer(i));
            ++i;
        }
        i = 0;
        while (i < cols) {
            this.columnCombo.addItem(new Integer(i));
            ++i;
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            int val = ((JSlider)ev.getSource()).getValue();
            try {
                LineDisplayPanel.this.lineDisplay.setDeviceBrightness(val);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in setDeviceBrightness\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        }
    }

    class MethodListener
    implements ActionListener {
        MethodListener() {
        }

        private boolean DoOpen() {
            String logicalName = LineDisplayPanel.this.mainButtonPanel.getLogicalName();
            try {
                if (logicalName.equals("")) {
                    logicalName = LineDisplayPanel.this.defaultLogicalName;
                }
                LineDisplayPanel.this.lineDisplay.open(logicalName);
                LineDisplayPanel.this.mainButtonPanel.currentStatus.setText("Open");
                LineDisplayPanel.this.mainButtonPanel.logicalNameTextField.setEnabled(false);
                LineDisplayPanel.this.deviceEnabledCB.setEnabled(false);
                LineDisplayPanel.this.freezeEventsCB.setEnabled(true);
                LineDisplayPanel.this.updateRowColumn();
                LineDisplayPanel.this.rowCombo.setEnabled(true);
                LineDisplayPanel.this.columnCombo.setEnabled(true);
                LineDisplayPanel.this.attrCombo.removeAllItems();
                LineDisplayPanel.this.attrCombo.addItem(new String("Normal"));
                int capBlink = LineDisplayPanel.this.lineDisplay.getCapBlink();
                int capReverse = LineDisplayPanel.this.lineDisplay.getCapReverse();
                if (capBlink > 0) {
                    LineDisplayPanel.this.attrCombo.addItem(new String("Blink"));
                }
                if (capReverse > 0) {
                    LineDisplayPanel.this.attrCombo.addItem(new String("Reverse"));
                }
                if (capBlink > 0 && capReverse > 0) {
                    LineDisplayPanel.this.attrCombo.addItem(new String("Blink & Reverse"));
                }
                if (LineDisplayPanel.this.lineDisplay.getCapBlinkRate()) {
                    LineDisplayPanel.this.blinkRateButton.setEnabled(true);
                    LineDisplayPanel.this.brVal.setEnabled(true);
                    LineDisplayPanel.this.brLabel.setText("Blink Rate (" + Integer.toString(LineDisplayPanel.this.lineDisplay.getBlinkRate()) + ")");
                }
                LineDisplayPanel.this.brightnessSlider.setEnabled(LineDisplayPanel.this.lineDisplay.getCapBrightness());
                LineDisplayPanel.this.moveCursorButton.setEnabled(true);
                LineDisplayPanel.this.setCurrentWindowButton.setEnabled(true);
                int version = LineDisplayPanel.this.lineDisplay.getDeviceServiceVersion();
                if (version >= 1009000) {
                    LineDisplayPanel.this.ver_19_complient = true;
                    LineDisplayPanel.this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    LineDisplayPanel.this.ver_18_complient = true;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + e);
                return false;
            }
            return true;
        }

        private boolean DoClaim() {
            String logicalName = LineDisplayPanel.this.mainButtonPanel.getLogicalName();
            try {
                LineDisplayPanel.this.lineDisplay.claim(0);
                LineDisplayPanel.this.mainButtonPanel.currentStatus.setText("Claimed");
                LineDisplayPanel.this.displayTextAtButton.setEnabled(true);
                LineDisplayPanel.this.displayTextButton.setEnabled(true);
                LineDisplayPanel.this.lineDisplayData.setEnabled(true);
                LineDisplayPanel.this.clearTextButton.setEnabled(true);
                LineDisplayPanel.this.deviceEnabledCB.setEnabled(true);
                LineDisplayPanel.this.freezeEventsCB.setEnabled(true);
                LineDisplayPanel.this.addWindowButton.setEnabled(true);
                LineDisplayPanel.this.delWindowButton.setEnabled(true);
                LineDisplayPanel.this.refreshWindowButton.setEnabled(true);
                LineDisplayPanel.this.attrCombo.setEnabled(true);
                LineDisplayPanel.this.attrCombo.setSelectedIndex(0);
                if (LineDisplayPanel.this.lineDisplay.getCapDescriptors()) {
                    int desc = LineDisplayPanel.this.lineDisplay.getColumns();
                    LineDisplayPanel.this.descCombo.removeAllItems();
                    int i = 0;
                    while (i < desc) {
                        LineDisplayPanel.this.descCombo.addItem(new Integer(i));
                        ++i;
                    }
                    LineDisplayPanel.this.descCombo.setEnabled(true);
                    LineDisplayPanel.this.descOnButton.setEnabled(true);
                    LineDisplayPanel.this.descOffButton.setEnabled(true);
                    LineDisplayPanel.this.descClearButton.setEnabled(true);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + e);
                return false;
            }
            return true;
        }

        public boolean DoEnabled(boolean enable) {
            String logicalName = LineDisplayPanel.this.mainButtonPanel.getLogicalName();
            try {
                LineDisplayPanel.this.lineDisplay.setDeviceEnabled(enable);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to enable \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent ae) {
            block129: {
                JDialog dlg;
                LineDisplayPanel.this.mainButtonPanel.action(ae);
                String logicalName = LineDisplayPanel.this.mainButtonPanel.getLogicalName();
                if (ae.getActionCommand().equals("open")) {
                    this.DoOpen();
                } else if (ae.getActionCommand().equals("claim")) {
                    this.DoClaim();
                } else if (ae.getActionCommand().equals("release")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.release();
                        LineDisplayPanel.this.mainButtonPanel.currentStatus.setText("Released");
                        LineDisplayPanel.this.lineDisplayData.setEnabled(false);
                        LineDisplayPanel.this.displayTextAtButton.setEnabled(false);
                        LineDisplayPanel.this.displayTextButton.setEnabled(false);
                        LineDisplayPanel.this.clearTextButton.setEnabled(false);
                        LineDisplayPanel.this.deviceEnabledCB.setEnabled(false);
                        LineDisplayPanel.this.addWindowButton.setEnabled(false);
                        LineDisplayPanel.this.delWindowButton.setEnabled(false);
                        LineDisplayPanel.this.refreshWindowButton.setEnabled(false);
                        LineDisplayPanel.this.attrCombo.setEnabled(false);
                        LineDisplayPanel.this.descCombo.setEnabled(false);
                        LineDisplayPanel.this.descOnButton.setEnabled(false);
                        LineDisplayPanel.this.descOffButton.setEnabled(false);
                        LineDisplayPanel.this.descClearButton.setEnabled(false);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + e);
                    }
                }
                if (ae.getActionCommand().equals("close")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.close();
                        LineDisplayPanel.this.mainButtonPanel.currentStatus.setText("Closed");
                        LineDisplayPanel.this.lineDisplayData.setEnabled(false);
                        LineDisplayPanel.this.moveCursorButton.setEnabled(false);
                        LineDisplayPanel.this.displayTextAtButton.setEnabled(false);
                        LineDisplayPanel.this.displayTextButton.setEnabled(false);
                        LineDisplayPanel.this.clearTextButton.setEnabled(false);
                        LineDisplayPanel.this.deviceEnabledCB.setEnabled(false);
                        LineDisplayPanel.this.rowCombo.setEnabled(false);
                        LineDisplayPanel.this.columnCombo.setEnabled(false);
                        LineDisplayPanel.this.attrCombo.setEnabled(false);
                        LineDisplayPanel.this.mainButtonPanel.logicalNameTextField.setEnabled(true);
                        LineDisplayPanel.this.freezeEventsCB.setEnabled(false);
                        LineDisplayPanel.this.brightnessSlider.setEnabled(false);
                        LineDisplayPanel.this.blinkRateButton.setEnabled(false);
                        LineDisplayPanel.this.addWindowButton.setEnabled(false);
                        LineDisplayPanel.this.delWindowButton.setEnabled(false);
                        LineDisplayPanel.this.refreshWindowButton.setEnabled(false);
                        LineDisplayPanel.this.setCurrentWindowButton.setEnabled(false);
                        LineDisplayPanel.this.brVal.setEnabled(false);
                        LineDisplayPanel.this.brLabel.setText("Blink Rate");
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + e);
                    }
                }
                if (ae.getActionCommand().equals("displayTextAt")) {
                    try {
                        int attr = ((String)LineDisplayPanel.this.attrCombo.getSelectedItem()).equals("Blink") ? 1 : (((String)LineDisplayPanel.this.attrCombo.getSelectedItem()).equals("Reverse") ? 2 : (((String)LineDisplayPanel.this.attrCombo.getSelectedItem()).equals("Blink & Reverse") ? 3 : 0));
                        LineDisplayPanel.this.lineDisplay.displayTextAt(((Integer)LineDisplayPanel.this.rowCombo.getSelectedItem()).intValue(), ((Integer)LineDisplayPanel.this.columnCombo.getSelectedItem()).intValue(), LineDisplayPanel.this.lineDisplayData.getText(), attr);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in displayTextAt\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("displayText")) {
                    try {
                        int attr = ((String)LineDisplayPanel.this.attrCombo.getSelectedItem()).equals("Blink") ? 1 : (((String)LineDisplayPanel.this.attrCombo.getSelectedItem()).equals("Reverse") ? 2 : (((String)LineDisplayPanel.this.attrCombo.getSelectedItem()).equals("Blink & Reverse") ? 3 : 0));
                        LineDisplayPanel.this.lineDisplay.displayText(LineDisplayPanel.this.lineDisplayData.getText(), attr);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in displayText\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("info")) {
                    try {
                        String ver = new Integer(LineDisplayPanel.this.lineDisplay.getDeviceServiceVersion()).toString();
                        String msg = "Service Description: " + LineDisplayPanel.this.lineDisplay.getDeviceServiceDescription();
                        msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                        ver = new Integer(LineDisplayPanel.this.lineDisplay.getDeviceControlVersion()).toString();
                        msg = String.valueOf(msg) + "\n\nControl Description: " + LineDisplayPanel.this.lineDisplay.getDeviceControlDescription();
                        msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                        msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + LineDisplayPanel.this.lineDisplay.getPhysicalDeviceName();
                        msg = String.valueOf(msg) + "\nPhysical Device Description: " + LineDisplayPanel.this.lineDisplay.getPhysicalDeviceDescription();
                        msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                        msg = String.valueOf(msg) + "\nCapPowerReporting: " + (LineDisplayPanel.this.lineDisplay.getCapPowerReporting() == 2 ? "Advanced" : (LineDisplayPanel.this.lineDisplay.getCapPowerReporting() == 1 ? "Standard" : "None"));
                        if (LineDisplayPanel.this.ver_18_complient) {
                            msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + LineDisplayPanel.this.lineDisplay.getCapStatisticsReporting();
                            msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + LineDisplayPanel.this.lineDisplay.getCapUpdateStatistics();
                        } else {
                            msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                            msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                        }
                        if (LineDisplayPanel.this.ver_19_complient) {
                            msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + LineDisplayPanel.this.lineDisplay.getCapCompareFirmwareVersion();
                            msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + LineDisplayPanel.this.lineDisplay.getCapUpdateFirmware();
                        } else {
                            msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                            msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                        }
                        msg = String.valueOf(msg) + "\nCapBitmap: " + LineDisplayPanel.this.lineDisplay.getCapBitmap();
                        int blink = LineDisplayPanel.this.lineDisplay.getCapBlink();
                        msg = String.valueOf(msg) + "\nCapBlink: " + (blink == 2 ? "DISP_CB_BLINK_EACH" : (blink == 1 ? "DISP_CB_BLINKALL" : "DISP_CB_NOBLINK"));
                        msg = String.valueOf(msg) + "\nCapBlinkRate: " + LineDisplayPanel.this.lineDisplay.getCapBlinkRate();
                        msg = String.valueOf(msg) + "\nCapBrightness: " + LineDisplayPanel.this.lineDisplay.getCapBrightness();
                        msg = String.valueOf(msg) + "\nCapCharacterSet: ";
                        int charSet = LineDisplayPanel.this.lineDisplay.getCapCharacterSet();
                        switch (charSet) {
                            case 0: {
                                msg = String.valueOf(msg) + "DISP_CCS_NUMERIC";
                                break;
                            }
                            case 1: {
                                msg = String.valueOf(msg) + "DISP_CCS_ALPHA";
                                break;
                            }
                            case 998: {
                                msg = String.valueOf(msg) + "DISP_CCS_ASCII";
                                break;
                            }
                            case 10: {
                                msg = String.valueOf(msg) + "DISP_CCS_KANA";
                                break;
                            }
                            case 11: {
                                msg = String.valueOf(msg) + "DISP_CCS_KANJI";
                                break;
                            }
                            case 997: {
                                msg = String.valueOf(msg) + "DISP_CCS_UNICODE";
                            }
                        }
                        msg = String.valueOf(msg) + "\nCapCursorType: ";
                        int cursorType = LineDisplayPanel.this.lineDisplay.getCapCursorType();
                        if (cursorType == 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_NONE ";
                        }
                        if ((cursorType & 1) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_FIXED ";
                        }
                        if ((cursorType & 2) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_BLOCK ";
                        }
                        if ((cursorType & 4) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_HALFBLOCK ";
                        }
                        if ((cursorType & 8) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_UNDERLINE ";
                        }
                        if ((cursorType & 0x10) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_REVERSE ";
                        }
                        if ((cursorType & 0x20) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_OTHER ";
                        }
                        if ((cursorType & 1) > 0) {
                            msg = String.valueOf(msg) + "DISP_CCT_FIXED ";
                        }
                        msg = String.valueOf(msg) + "\nCapCustomGlyph: " + LineDisplayPanel.this.lineDisplay.getCapCustomGlyph();
                        msg = String.valueOf(msg) + "\nCapDescriptors: " + LineDisplayPanel.this.lineDisplay.getCapDescriptors();
                        msg = String.valueOf(msg) + "\nCapHMarquee: " + LineDisplayPanel.this.lineDisplay.getCapHMarquee();
                        msg = String.valueOf(msg) + "\nCapICharWait: " + LineDisplayPanel.this.lineDisplay.getCapICharWait();
                        msg = String.valueOf(msg) + "\nCapMapCharacterSet: " + LineDisplayPanel.this.lineDisplay.getCapMapCharacterSet();
                        msg = String.valueOf(msg) + "\nCapReadBack: ";
                        int readback = LineDisplayPanel.this.lineDisplay.getCapReadBack();
                        switch (readback) {
                            case 0: {
                                msg = String.valueOf(msg) + "DISP_CRB_NONE";
                                break;
                            }
                            case 1: {
                                msg = String.valueOf(msg) + "DISP_CRB_SINGLE";
                            }
                        }
                        msg = String.valueOf(msg) + "\nCapReverse: ";
                        int reverse = LineDisplayPanel.this.lineDisplay.getCapReverse();
                        switch (reverse) {
                            case 0: {
                                msg = String.valueOf(msg) + "DISP_CR_NONE";
                                break;
                            }
                            case 1: {
                                msg = String.valueOf(msg) + "DISP_CR_REVERSEALL";
                                break;
                            }
                            case 2: {
                                msg = String.valueOf(msg) + "DISP_CR_REVERSEEACH";
                            }
                        }
                        msg = String.valueOf(msg) + "\nCapScreenMode: " + LineDisplayPanel.this.lineDisplay.getCapScreenMode();
                        msg = String.valueOf(msg) + "\nCapVMarquee: " + LineDisplayPanel.this.lineDisplay.getCapVMarquee();
                        JOptionPane.showMessageDialog(null, msg, "Info", 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("clearText")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.clearText();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in clearText\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Add Window")) {
                    try {
                        int vr = Integer.parseInt(LineDisplayPanel.this.windowVPRow.getText());
                        int vc = Integer.parseInt(LineDisplayPanel.this.windowVPCol.getText());
                        int vh = Integer.parseInt(LineDisplayPanel.this.windowVPHeight.getText());
                        int vw = Integer.parseInt(LineDisplayPanel.this.windowVPWidth.getText());
                        int wh = Integer.parseInt(LineDisplayPanel.this.windowWHeight.getText());
                        int ww = Integer.parseInt(LineDisplayPanel.this.windowWWidth.getText());
                        LineDisplayPanel.this.lineDisplay.createWindow(vr, vc, vh, vw, wh, ww);
                        int curWin = LineDisplayPanel.this.lineDisplay.getCurrentWindow();
                        LineDisplayPanel.this.windowListModel.addElement(new String(Integer.toString(curWin)));
                        LineDisplayPanel.this.updateRowColumn();
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, "You must fill in all fields with valid numbers", "Error", 0);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Add Window\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Del Window")) {
                    try {
                        int curWin = LineDisplayPanel.this.lineDisplay.getCurrentWindow();
                        LineDisplayPanel.this.lineDisplay.destroyWindow();
                        int i = 0;
                        while (i < LineDisplayPanel.this.windowListModel.getSize()) {
                            if (((String)LineDisplayPanel.this.windowListModel.get(i)).equalsIgnoreCase(Integer.toString(curWin))) {
                                LineDisplayPanel.this.windowListModel.remove(i);
                            }
                            ++i;
                        }
                        LineDisplayPanel.this.updateRowColumn();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Del Window\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Set Cur Window")) {
                    try {
                        int index = LineDisplayPanel.this.windowList.getSelectedIndex();
                        if (index == -1) {
                            JOptionPane.showMessageDialog(null, "Please select the window from the list first.", "Error", 0);
                            break block129;
                        }
                        int selectedWin = Integer.parseInt((String)LineDisplayPanel.this.windowListModel.get(index));
                        LineDisplayPanel.this.lineDisplay.setCurrentWindow(selectedWin);
                        LineDisplayPanel.this.updateRowColumn();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in Set Cur Window\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Shift Up")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.scrollText(1, 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in scrollText\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Shift Down")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.scrollText(2, 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in scrollText\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Shift Right")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.scrollText(4, 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in scrollText\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Shift Left")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.scrollText(3, 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in scrollText\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("blinkRate")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.setBlinkRate(Integer.parseInt(LineDisplayPanel.this.brVal.getText()));
                        LineDisplayPanel.this.brLabel.setText("Blink Rate (" + Integer.toString(LineDisplayPanel.this.lineDisplay.getBlinkRate()) + ")");
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, "You must enter a valid number", "Error", 0);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in setBlinkRate\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("moveCursor")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.setCursorRow(((Integer)LineDisplayPanel.this.rowCombo.getSelectedItem()).intValue());
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in setCursorRow\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                    try {
                        LineDisplayPanel.this.lineDisplay.setCursorColumn(((Integer)LineDisplayPanel.this.columnCombo.getSelectedItem()).intValue());
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in setCursorColumn\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("Refresh Window")) {
                    try {
                        int index = LineDisplayPanel.this.windowList.getSelectedIndex();
                        if (index == -1) {
                            JOptionPane.showMessageDialog(null, "Please select the window to refresh from the list first.", "Error", 0);
                            break block129;
                        }
                        int selectedWin = Integer.parseInt((String)LineDisplayPanel.this.windowListModel.get(index));
                        LineDisplayPanel.this.lineDisplay.refreshWindow(selectedWin);
                        LineDisplayPanel.this.updateRowColumn();
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in setCursorRow\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("descOn")) {
                    try {
                        int descNum = (Integer)LineDisplayPanel.this.descCombo.getSelectedItem();
                        LineDisplayPanel.this.lineDisplay.setDescriptor(descNum, 1);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in setDescriptor\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("descOff")) {
                    try {
                        int descNum = (Integer)LineDisplayPanel.this.descCombo.getSelectedItem();
                        LineDisplayPanel.this.lineDisplay.setDescriptor(descNum, 0);
                    }
                    catch (JposException e) {
                        JOptionPane.showMessageDialog(null, "Exception in setDescriptor\nException: " + e.getMessage(), "Exception", 0);
                        System.err.println("Jpos exception " + (Object)((Object)e));
                    }
                } else if (ae.getActionCommand().equals("descClear")) {
                    try {
                        LineDisplayPanel.this.lineDisplay.clearDescriptors();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Failed to clear descriptors\nException: " + e.getMessage(), "Failed", 0);
                        System.err.println("Jpos exception " + e);
                    }
                } else if (ae.getActionCommand().equals("oce")) {
                    if (this.DoOpen() && this.DoClaim()) {
                        this.DoEnabled(true);
                    }
                } else if (ae.getActionCommand().equals("stats")) {
                    try {
                        dlg = new StatisticsDialog(LineDisplayPanel.this.lineDisplay);
                        dlg.setVisible(true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                    }
                } else if (ae.getActionCommand().equals("firmware")) {
                    try {
                        dlg = new FirmwareUpdateDlg(LineDisplayPanel.this.lineDisplay);
                        dlg.setVisible(true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                    }
                }
            }
            try {
                if (LineDisplayPanel.this.deviceEnabledCB.isEnabled()) {
                    LineDisplayPanel.this.deviceEnabledCB.setSelected(LineDisplayPanel.this.lineDisplay.getDeviceEnabled());
                }
                if (LineDisplayPanel.this.freezeEventsCB.isEnabled()) {
                    LineDisplayPanel.this.freezeEventsCB.setSelected(LineDisplayPanel.this.lineDisplay.getFreezeEvents());
                }
            }
            catch (JposException je) {
                System.err.println("LineDisplayPanel: MethodListener: JposException");
            }
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == LineDisplayPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        LineDisplayPanel.this.lineDisplay.setDeviceEnabled(false);
                    } else {
                        LineDisplayPanel.this.lineDisplay.setDeviceEnabled(true);
                    }
                } else if (source == LineDisplayPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        LineDisplayPanel.this.lineDisplay.setFreezeEvents(false);
                    } else {
                        LineDisplayPanel.this.lineDisplay.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("LineDisplayPanel: CheckBoxListener: Jpos Exception" + source);
            }
        }
    }

    class WindowManagementPanel
    extends Component {
        private static final long serialVersionUID = 6595899267624438905L;

        WindowManagementPanel() {
        }

        public Component make() {
            JPanel windowButtonPanel = new JPanel();
            windowButtonPanel.setAlignmentX(0.5f);
            windowButtonPanel.setLayout(new BoxLayout(windowButtonPanel, 1));
            windowButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
            LineDisplayPanel.this.addWindowButton = new JButton("Add Window");
            LineDisplayPanel.this.addWindowButton.setActionCommand("Add Window");
            LineDisplayPanel.this.addWindowButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.addWindowButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.delWindowButton = new JButton("Del Cur Window");
            LineDisplayPanel.this.delWindowButton.setActionCommand("Del Window");
            LineDisplayPanel.this.delWindowButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.delWindowButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.setCurrentWindowButton = new JButton("Set Cur Window");
            LineDisplayPanel.this.setCurrentWindowButton.setActionCommand("Set Cur Window");
            LineDisplayPanel.this.setCurrentWindowButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.setCurrentWindowButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.refreshWindowButton = new JButton("Refresh Window");
            LineDisplayPanel.this.refreshWindowButton.setActionCommand("Refresh Window");
            LineDisplayPanel.this.refreshWindowButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.refreshWindowButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.addWindowButton.setEnabled(false);
            LineDisplayPanel.this.delWindowButton.setEnabled(false);
            LineDisplayPanel.this.setCurrentWindowButton.setEnabled(false);
            LineDisplayPanel.this.refreshWindowButton.setEnabled(false);
            windowButtonPanel.add(LineDisplayPanel.this.addWindowButton);
            windowButtonPanel.add(LineDisplayPanel.this.delWindowButton);
            windowButtonPanel.add(LineDisplayPanel.this.setCurrentWindowButton);
            windowButtonPanel.add(LineDisplayPanel.this.refreshWindowButton);
            JPanel windowArgPanel = new JPanel();
            JPanel windowArgLabelPanel = new JPanel();
            JPanel windowArgFieldPanel = new JPanel();
            windowArgLabelPanel.setLayout(new BoxLayout(windowArgLabelPanel, 1));
            windowArgLabelPanel.setAlignmentX(1.0f);
            windowArgLabelPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            LineDisplayPanel.this.label = new JLabel("Viewport Row");
            LineDisplayPanel.this.label.setAlignmentX(1.0f);
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(110, 17));
            LineDisplayPanel.this.label.setPreferredSize(new Dimension(110, 17));
            windowArgLabelPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.label = new JLabel("Viewport Col");
            LineDisplayPanel.this.label.setAlignmentX(1.0f);
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(110, 17));
            LineDisplayPanel.this.label.setPreferredSize(new Dimension(110, 17));
            windowArgLabelPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.label = new JLabel("Viewport Height");
            LineDisplayPanel.this.label.setAlignmentX(1.0f);
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(110, 17));
            LineDisplayPanel.this.label.setPreferredSize(new Dimension(110, 17));
            windowArgLabelPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.label = new JLabel("Viewport Width");
            LineDisplayPanel.this.label.setAlignmentX(1.0f);
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(110, 17));
            LineDisplayPanel.this.label.setPreferredSize(new Dimension(110, 17));
            windowArgLabelPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.label = new JLabel("Window Height");
            LineDisplayPanel.this.label.setAlignmentX(1.0f);
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(110, 17));
            LineDisplayPanel.this.label.setPreferredSize(new Dimension(110, 17));
            windowArgLabelPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.label = new JLabel("Window Width");
            LineDisplayPanel.this.label.setAlignmentX(1.0f);
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(110, 17));
            LineDisplayPanel.this.label.setPreferredSize(new Dimension(110, 17));
            windowArgLabelPanel.add(LineDisplayPanel.this.label);
            windowArgFieldPanel.setLayout(new BoxLayout(windowArgFieldPanel, 1));
            windowArgFieldPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            windowArgFieldPanel.setAlignmentX(0.0f);
            windowArgPanel.setLayout(new BoxLayout(windowArgPanel, 0));
            windowArgPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            LineDisplayPanel.this.windowVPRow = new JTextField();
            LineDisplayPanel.this.windowVPRow.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPRow.setPreferredSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPRow.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPCol = new JTextField();
            LineDisplayPanel.this.windowVPCol.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPCol.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPCol.setPreferredSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPHeight = new JTextField();
            LineDisplayPanel.this.windowVPHeight.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPHeight.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPHeight.setPreferredSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPWidth = new JTextField();
            LineDisplayPanel.this.windowVPWidth.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPWidth.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowVPWidth.setPreferredSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowWHeight = new JTextField();
            LineDisplayPanel.this.windowWHeight.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowWHeight.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowWHeight.setPreferredSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowWWidth = new JTextField();
            LineDisplayPanel.this.windowWWidth.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowWWidth.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.windowWWidth.setPreferredSize(new Dimension(50, 17));
            windowArgFieldPanel.add(LineDisplayPanel.this.windowVPRow);
            windowArgFieldPanel.add(LineDisplayPanel.this.windowVPCol);
            windowArgFieldPanel.add(LineDisplayPanel.this.windowVPHeight);
            windowArgFieldPanel.add(LineDisplayPanel.this.windowVPWidth);
            windowArgFieldPanel.add(LineDisplayPanel.this.windowWHeight);
            windowArgFieldPanel.add(LineDisplayPanel.this.windowWWidth);
            windowArgPanel.add(windowArgLabelPanel);
            windowArgPanel.add(windowArgFieldPanel);
            JPanel windowListPanel = new JPanel();
            windowListPanel.setLayout(new BoxLayout(windowListPanel, 1));
            windowListPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            LineDisplayPanel.this.label = new JLabel("Windows: ");
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(70, 17));
            LineDisplayPanel.this.label.setAlignmentX(0.5f);
            LineDisplayPanel.this.windowListModel = new DefaultListModel();
            LineDisplayPanel.this.windowListModel.addElement(new String("0"));
            LineDisplayPanel.this.windowList = new JList(LineDisplayPanel.this.windowListModel);
            LineDisplayPanel.this.windowList.setSelectionMode(1);
            LineDisplayPanel.this.windowList.setLayoutOrientation(0);
            LineDisplayPanel.this.windowList.setVisibleRowCount(7);
            JScrollPane windowScrollPane = new JScrollPane(LineDisplayPanel.this.windowList);
            windowScrollPane.setMinimumSize(new Dimension(80, 80));
            windowScrollPane.setPreferredSize(new Dimension(80, 80));
            windowScrollPane.setMaximumSize(new Dimension(80, 80));
            windowListPanel.add(LineDisplayPanel.this.label);
            windowListPanel.add(windowScrollPane);
            JPanel windowBoxPanel = new JPanel();
            windowBoxPanel.setAlignmentX(0.5f);
            windowBoxPanel.setLayout(new BoxLayout(windowBoxPanel, 0));
            windowBoxPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
            windowBoxPanel.setBorder(BorderFactory.createEtchedBorder());
            windowBoxPanel.add(windowButtonPanel);
            windowBoxPanel.add(windowArgPanel);
            windowBoxPanel.add(windowListPanel);
            return windowBoxPanel;
        }
    }

    class DisplayTextPanel
    extends Component {
        private static final long serialVersionUID = -8460617569432301745L;

        DisplayTextPanel() {
        }

        public Component make() {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            JPanel buttonRow2Panel = new JPanel();
            buttonRow2Panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            buttonRow2Panel.setLayout(new BoxLayout(buttonRow2Panel, 0));
            LineDisplayPanel.this.displayTextAtButton = new JButton("Dispay Text At");
            LineDisplayPanel.this.displayTextAtButton.setActionCommand("displayTextAt");
            LineDisplayPanel.this.displayTextAtButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.displayTextAtButton.setAlignmentX(0.0f);
            LineDisplayPanel.this.displayTextAtButton.setEnabled(false);
            buttonPanel.add(LineDisplayPanel.this.displayTextAtButton);
            LineDisplayPanel.this.displayTextButton = new JButton("Dispay Text");
            LineDisplayPanel.this.displayTextButton.setActionCommand("displayText");
            LineDisplayPanel.this.displayTextButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.displayTextButton.setAlignmentX(0.0f);
            LineDisplayPanel.this.displayTextButton.setEnabled(false);
            buttonPanel.add(LineDisplayPanel.this.displayTextButton);
            LineDisplayPanel.this.clearTextButton = new JButton("Clear Text");
            LineDisplayPanel.this.clearTextButton.setActionCommand("clearText");
            LineDisplayPanel.this.clearTextButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.clearTextButton.setAlignmentX(0.0f);
            LineDisplayPanel.this.clearTextButton.setEnabled(false);
            buttonPanel.add(LineDisplayPanel.this.clearTextButton);
            JPanel rowPanel = new JPanel();
            rowPanel.setLayout(new BoxLayout(rowPanel, 0));
            LineDisplayPanel.this.label = new JLabel("Row: ");
            rowPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.rowCombo = new JComboBox();
            LineDisplayPanel.this.rowCombo.setAlignmentX(1.0f);
            LineDisplayPanel.this.rowCombo.setMaximumSize(new Dimension(50, 30));
            rowPanel.add(LineDisplayPanel.this.rowCombo);
            JPanel columnPanel = new JPanel();
            columnPanel.setLayout(new BoxLayout(columnPanel, 0));
            LineDisplayPanel.this.label = new JLabel("Column: ");
            columnPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.columnCombo = new JComboBox();
            LineDisplayPanel.this.columnCombo.setMaximumSize(new Dimension(50, 30));
            LineDisplayPanel.this.columnCombo.setAlignmentX(1.0f);
            columnPanel.add(LineDisplayPanel.this.columnCombo);
            JPanel attrPanel = new JPanel();
            attrPanel.setLayout(new BoxLayout(attrPanel, 0));
            LineDisplayPanel.this.label = new JLabel("Attribute: ");
            attrPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.attrCombo = new JComboBox();
            LineDisplayPanel.this.attrCombo.setMaximumSize(new Dimension(80, 30));
            LineDisplayPanel.this.attrCombo.setAlignmentX(1.0f);
            attrPanel.add(LineDisplayPanel.this.attrCombo);
            LineDisplayPanel.this.rowCombo.setEnabled(false);
            LineDisplayPanel.this.columnCombo.setEnabled(false);
            LineDisplayPanel.this.attrCombo.setEnabled(false);
            JPanel argPanel = new JPanel();
            argPanel.setAlignmentX(0.0f);
            argPanel.setLayout(new BoxLayout(argPanel, 1));
            argPanel.add(rowPanel);
            argPanel.add(columnPanel);
            argPanel.add(attrPanel);
            JPanel textControlPanel = new JPanel();
            textControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            textControlPanel.setLayout(new BoxLayout(textControlPanel, 0));
            textControlPanel.add(argPanel);
            LineDisplayPanel.this.moveCursorButton = new JButton("Move Cursor");
            LineDisplayPanel.this.moveCursorButton.setActionCommand("moveCursor");
            LineDisplayPanel.this.moveCursorButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.moveCursorButton.setAlignmentX(0.0f);
            LineDisplayPanel.this.moveCursorButton.setEnabled(false);
            buttonRow2Panel.add(LineDisplayPanel.this.moveCursorButton);
            JPanel displayTextPanel = new JPanel();
            displayTextPanel.setLayout(new BoxLayout(displayTextPanel, 1));
            displayTextPanel.add(buttonPanel);
            displayTextPanel.add(buttonRow2Panel);
            LineDisplayPanel.this.label = new JLabel("Send to line display: ");
            LineDisplayPanel.this.label.setAlignmentX(0.0f);
            displayTextPanel.add(LineDisplayPanel.this.label);
            LineDisplayPanel.this.lineDisplayData = new JTextField(30);
            LineDisplayPanel.this.lineDisplayData.setMinimumSize(new Dimension(300, 20));
            LineDisplayPanel.this.lineDisplayData.setMaximumSize(new Dimension(300, 20));
            LineDisplayPanel.this.lineDisplayData.setPreferredSize(new Dimension(300, 20));
            LineDisplayPanel.this.lineDisplayData.setEnabled(false);
            displayTextPanel.add(LineDisplayPanel.this.lineDisplayData);
            textControlPanel.add(argPanel);
            textControlPanel.add(displayTextPanel);
            return textControlPanel;
        }
    }

    class MiscControlPanel
    extends Component {
        private static final long serialVersionUID = -6781522099126306328L;
        static /* synthetic */ Class class$0;

        MiscControlPanel() {
        }

        public Component make() {
            JPanel shiftPanel = new JPanel();
            shiftPanel.setLayout(new GridLayout(3, 3));
            shiftPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            shiftPanel.setPreferredSize(new Dimension(105, 105));
            shiftPanel.setMaximumSize(new Dimension(105, 105));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jpos.POStest.LineDisplayPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineDisplayPanel.this.shiftUpButton = new JButton(new ImageIcon(clazz.getResource("res/lineDisplayUpArrow.png")));
            LineDisplayPanel.this.shiftUpButton.setActionCommand("Shift Up");
            LineDisplayPanel.this.shiftUpButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.shiftUpButton.setPreferredSize(new Dimension(35, 35));
            LineDisplayPanel.this.shiftUpButton.setMaximumSize(new Dimension(35, 35));
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.jpos.POStest.LineDisplayPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineDisplayPanel.this.shiftDownButton = new JButton(new ImageIcon(clazz2.getResource("res/lineDisplayDownArrow.png")));
            LineDisplayPanel.this.shiftDownButton.setActionCommand("Shift Down");
            LineDisplayPanel.this.shiftDownButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.shiftDownButton.setPreferredSize(new Dimension(35, 35));
            LineDisplayPanel.this.shiftDownButton.setMaximumSize(new Dimension(35, 35));
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.jpos.POStest.LineDisplayPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineDisplayPanel.this.shiftRightButton = new JButton(new ImageIcon(clazz3.getResource("res/lineDisplayRightArrow.png")));
            LineDisplayPanel.this.shiftRightButton.setActionCommand("Shift Right");
            LineDisplayPanel.this.shiftRightButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.shiftRightButton.setPreferredSize(new Dimension(35, 35));
            LineDisplayPanel.this.shiftRightButton.setMaximumSize(new Dimension(35, 35));
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.jpos.POStest.LineDisplayPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineDisplayPanel.this.shiftLeftButton = new JButton(new ImageIcon(clazz4.getResource("res/lineDisplayLeftArrow.png")));
            LineDisplayPanel.this.shiftLeftButton.setActionCommand("Shift Left");
            LineDisplayPanel.this.shiftLeftButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.shiftLeftButton.setPreferredSize(new Dimension(35, 35));
            LineDisplayPanel.this.shiftLeftButton.setMaximumSize(new Dimension(35, 35));
            shiftPanel.add(Box.createHorizontalStrut(35));
            shiftPanel.add(LineDisplayPanel.this.shiftUpButton);
            shiftPanel.add(Box.createHorizontalStrut(35));
            shiftPanel.add(LineDisplayPanel.this.shiftLeftButton);
            shiftPanel.add(Box.createHorizontalStrut(35));
            shiftPanel.add(LineDisplayPanel.this.shiftRightButton);
            shiftPanel.add(Box.createHorizontalStrut(35));
            shiftPanel.add(LineDisplayPanel.this.shiftDownButton);
            shiftPanel.add(Box.createHorizontalStrut(35));
            JPanel shiftBoxPanel = new JPanel();
            shiftBoxPanel.setAlignmentX(0.0f);
            shiftBoxPanel.setLayout(new BoxLayout(shiftBoxPanel, 1));
            shiftBoxPanel.setBorder(BorderFactory.createEtchedBorder());
            LineDisplayPanel.this.label = new JLabel("Scroll Text");
            LineDisplayPanel.this.label.setMaximumSize(new Dimension(65, 17));
            LineDisplayPanel.this.label.setAlignmentX(0.5f);
            shiftBoxPanel.add(LineDisplayPanel.this.label);
            shiftBoxPanel.add(shiftPanel);
            SliderListener slideListener = new SliderListener();
            JPanel brightnessPanel = new JPanel();
            brightnessPanel.setAlignmentX(0.5f);
            brightnessPanel.setLayout(new BoxLayout(brightnessPanel, 1));
            brightnessPanel.setBorder(BorderFactory.createEtchedBorder());
            LineDisplayPanel.this.brightnessSlider = new JSlider(0, 100, 100);
            LineDisplayPanel.this.brightnessSlider.setAlignmentX(0.5f);
            LineDisplayPanel.this.brightnessSlider.setPreferredSize(new Dimension(75, 20));
            LineDisplayPanel.this.brightnessSlider.setMaximumSize(new Dimension(75, 20));
            LineDisplayPanel.this.brightnessSlider.addChangeListener(slideListener);
            LineDisplayPanel.this.brightnessSlider.setEnabled(false);
            LineDisplayPanel.this.label = new JLabel("Device Brightness");
            LineDisplayPanel.this.label.setAlignmentX(0.5f);
            brightnessPanel.add(LineDisplayPanel.this.label);
            brightnessPanel.add(LineDisplayPanel.this.brightnessSlider);
            JPanel miscGridPanel = new JPanel();
            miscGridPanel.setLayout(new BoxLayout(miscGridPanel, 0));
            miscGridPanel.setAlignmentX(0.5f);
            miscGridPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            JPanel blinkRatePanel = new JPanel();
            blinkRatePanel.setAlignmentX(0.5f);
            blinkRatePanel.setLayout(new BoxLayout(blinkRatePanel, 1));
            blinkRatePanel.setBorder(BorderFactory.createEtchedBorder());
            LineDisplayPanel.this.brLabel = new JLabel("Blink Rate");
            LineDisplayPanel.this.brLabel.setAlignmentX(0.5f);
            LineDisplayPanel.this.brVal = new JTextField();
            LineDisplayPanel.this.brVal.setMaximumSize(new Dimension(50, 17));
            LineDisplayPanel.this.brVal.setPreferredSize(new Dimension(50, 17));
            LineDisplayPanel.this.brVal.setMinimumSize(new Dimension(50, 17));
            LineDisplayPanel.this.blinkRateButton = new JButton("Set Blink Rate");
            LineDisplayPanel.this.blinkRateButton.setActionCommand("blinkRate");
            LineDisplayPanel.this.blinkRateButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.blinkRateButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.blinkRateButton.setEnabled(false);
            LineDisplayPanel.this.brVal.setEnabled(false);
            blinkRatePanel.add(LineDisplayPanel.this.brLabel);
            blinkRatePanel.add(LineDisplayPanel.this.brVal);
            blinkRatePanel.add(LineDisplayPanel.this.blinkRateButton);
            JPanel descriptorsPanel = new JPanel();
            descriptorsPanel.setAlignmentX(0.5f);
            descriptorsPanel.setLayout(new BoxLayout(descriptorsPanel, 1));
            descriptorsPanel.setBorder(BorderFactory.createEtchedBorder());
            LineDisplayPanel.this.label = new JLabel("Descriptors");
            LineDisplayPanel.this.label.setAlignmentX(0.5f);
            LineDisplayPanel.this.descCombo = new JComboBox();
            LineDisplayPanel.this.descCombo.setMaximumSize(new Dimension(50, 30));
            LineDisplayPanel.this.descCombo.setAlignmentX(0.5f);
            LineDisplayPanel.this.descOnButton = new JButton("On");
            LineDisplayPanel.this.descOnButton.setActionCommand("descOn");
            LineDisplayPanel.this.descOnButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.descOnButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.descOffButton = new JButton("Off");
            LineDisplayPanel.this.descOffButton.setActionCommand("descOff");
            LineDisplayPanel.this.descOffButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.descOffButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.descClearButton = new JButton("Clear All");
            LineDisplayPanel.this.descClearButton.setActionCommand("descClear");
            LineDisplayPanel.this.descClearButton.addActionListener(LineDisplayPanel.this.methodListener);
            LineDisplayPanel.this.descClearButton.setAlignmentX(0.5f);
            LineDisplayPanel.this.descCombo.setEnabled(false);
            LineDisplayPanel.this.descOnButton.setEnabled(false);
            LineDisplayPanel.this.descOffButton.setEnabled(false);
            LineDisplayPanel.this.descClearButton.setEnabled(false);
            descriptorsPanel.add(LineDisplayPanel.this.label);
            descriptorsPanel.add(LineDisplayPanel.this.descCombo);
            descriptorsPanel.add(LineDisplayPanel.this.descOnButton);
            descriptorsPanel.add(LineDisplayPanel.this.descOffButton);
            descriptorsPanel.add(LineDisplayPanel.this.descClearButton);
            miscGridPanel.add(shiftBoxPanel);
            miscGridPanel.add(brightnessPanel);
            miscGridPanel.add(blinkRatePanel);
            miscGridPanel.add(descriptorsPanel);
            return miscGridPanel;
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (LineDisplayPanel.this.lineDisplay != null) {
                LineDisplayPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(LineDisplayPanel.this.lineDisplay.getState()));
            }
        }
    }
}

