/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpos.JposException;
import jpos.MICR;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class MICRPanel
extends Component
implements ActionListener {
    private static final long serialVersionUID = -5786054917462102074L;
    protected MainButtonPanel mainButtonPanel;
    private MICR micr = null;
    private String defaultLogicalName = "defaultMICR";
    String rawData = new String("");
    String accountNumber = new String("");
    String bankNumber = new String("");
    String serialNumber = new String("");
    boolean autoDisable;
    boolean dataEventEnabled;
    boolean deviceEnabled;
    boolean freezeEvents;
    protected JTextField accountNumberTextField;
    protected JTextField amountTextField;
    protected JTextField bankNumberTextField;
    protected JTextField checkTypeTextField;
    protected JTextField countryCodeTextField;
    protected JTextField epcTextField;
    protected JTextField rawDataTextField;
    protected JTextField serialNumberTextField;
    protected JTextField transitNumberTextField;
    private JCheckBox autoDisableCB;
    private JCheckBox dataEventEnabledCB;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    boolean updateDevice = true;
    private JButton beginInsertionButton;
    private JButton endInsertionButton;
    private JButton beginRemovalButton;
    private JButton endRemovalButton;
    private JButton clearFieldsButton;
    private JButton refreshFieldsButton;
    private JButton clearInputButton;
    private JButton clearInputPropertiesButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    Runnable doUpdateGUI;
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;
    private EventListener listener = new EventListener();

    public void doGetFields() {
        try {
            this.rawData = this.micr.getRawData();
            this.accountNumber = this.micr.getAccountNumber();
            this.bankNumber = this.micr.getBankNumber();
            this.serialNumber = this.micr.getSerialNumber();
            this.autoDisable = this.micr.getAutoDisable();
            this.dataEventEnabled = this.micr.getDataEventEnabled();
            this.deviceEnabled = this.micr.getDeviceEnabled();
            this.freezeEvents = this.micr.getFreezeEvents();
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "doGetFields() caught a JposException: " + je.getMessage(), "Exception", 0);
        }
        this.updateDevice = false;
        try {
            SwingUtilities.invokeLater(this.doUpdateGUI);
        }
        catch (Exception e) {
            System.err.println("InvokeLater exception.");
        }
        this.updateDevice = true;
    }

    public MICRPanel() {
        this.micr = new MICR();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        this.beginInsertionButton = new JButton("Begin Insertion");
        this.beginInsertionButton.setActionCommand("beginInsertion");
        this.beginInsertionButton.addActionListener(this);
        this.beginInsertionButton.setEnabled(false);
        buttonPanel.add(this.beginInsertionButton);
        this.endInsertionButton = new JButton("End Insertion");
        this.endInsertionButton.setActionCommand("endInsertion");
        this.endInsertionButton.addActionListener(this);
        this.endInsertionButton.setEnabled(false);
        buttonPanel.add(this.endInsertionButton);
        this.beginRemovalButton = new JButton("Begin Removal");
        this.beginRemovalButton.setActionCommand("beginRemoval");
        this.beginRemovalButton.addActionListener(this);
        this.beginRemovalButton.setEnabled(false);
        buttonPanel.add(this.beginRemovalButton);
        this.endRemovalButton = new JButton("End Removal");
        this.endRemovalButton.setActionCommand("endRemoval");
        this.endRemovalButton.addActionListener(this);
        this.endRemovalButton.setEnabled(false);
        buttonPanel.add(this.endRemovalButton);
        this.clearFieldsButton = new JButton("Clear Fields");
        this.clearFieldsButton.setToolTipText("clears input fields");
        this.clearFieldsButton.setActionCommand("clearFields");
        this.clearFieldsButton.addActionListener(this);
        this.clearFieldsButton.setEnabled(true);
        this.refreshFieldsButton = new JButton("Refresh Fields");
        this.refreshFieldsButton.setToolTipText("Refresh input fields");
        this.refreshFieldsButton.setActionCommand("refreshFields");
        this.refreshFieldsButton.addActionListener(this);
        this.refreshFieldsButton.setEnabled(true);
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.autoDisableCB = new JCheckBox("Auto disable");
        Font f = this.autoDisableCB.getFont();
        Font newf = new Font(f.getName(), 0, f.getSize());
        this.autoDisableCB.setFont(newf);
        propPanel.add(this.autoDisableCB);
        this.dataEventEnabledCB = new JCheckBox("Data event enabled");
        this.dataEventEnabledCB.setFont(newf);
        propPanel.add(this.dataEventEnabledCB);
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        this.deviceEnabledCB.setFont(newf);
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        this.freezeEventsCB.setFont(newf);
        propPanel.add(this.freezeEventsCB);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        this.clearInputPropertiesButton = new JButton("Clear Input Properties");
        this.clearInputPropertiesButton.setActionCommand("clearInputProperties");
        this.clearInputPropertiesButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(this.clearInputPropertiesButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.autoDisableCB.setEnabled(true);
        this.dataEventEnabledCB.setEnabled(true);
        this.deviceEnabledCB.setEnabled(true);
        this.freezeEventsCB.setEnabled(true);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.autoDisableCB.addItemListener(cbListener);
        this.dataEventEnabledCB.addItemListener(cbListener);
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        JLabel label = new JLabel("Account number:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Amount:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Bank number:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Check type:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Country code:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("EPC:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Raw data:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Serial number:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        label = new JLabel("Transit number:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        labelPanel.add(label);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        labelPanel.add(Box.createVerticalGlue());
        subPanel.add(labelPanel);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        this.accountNumberTextField = new JTextField();
        this.accountNumberTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.accountNumberTextField);
        this.amountTextField = new JTextField();
        this.amountTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.amountTextField);
        this.bankNumberTextField = new JTextField();
        this.bankNumberTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.bankNumberTextField);
        this.checkTypeTextField = new JTextField();
        this.checkTypeTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.checkTypeTextField);
        this.countryCodeTextField = new JTextField();
        this.countryCodeTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.countryCodeTextField);
        this.epcTextField = new JTextField();
        this.epcTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.epcTextField);
        this.rawDataTextField = new JTextField();
        this.rawDataTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.rawDataTextField);
        this.serialNumberTextField = new JTextField();
        this.serialNumberTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.serialNumberTextField);
        this.transitNumberTextField = new JTextField();
        this.transitNumberTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        fieldPanel.add(this.transitNumberTextField);
        JPanel buttonBox = new JPanel();
        buttonBox.setLayout(new BoxLayout(buttonBox, 0));
        buttonBox.add(this.refreshFieldsButton);
        buttonBox.add(this.clearFieldsButton);
        fieldPanel.add(buttonBox);
        fieldPanel.add(Box.createVerticalGlue());
        subPanel.add(fieldPanel);
        subPanel.add(Box.createHorizontalGlue());
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        this.doUpdateGUI = new Runnable(){

            public void run() {
                MICRPanel.this.updateGUI();
            }
        };
        return mainPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.micr.open(logicalName);
                this.micr.addDataListener((DataListener)this.listener);
                this.micr.addErrorListener((ErrorListener)this.listener);
                this.micr.addStatusUpdateListener((StatusUpdateListener)this.listener);
                int version = this.micr.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.micr.claim(0);
                this.beginInsertionButton.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.micr.release();
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.micr.close();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("beginInsertion")) {
            try {
                this.micr.beginInsertion(-1);
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(true);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in beginInsertion: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("endInsertion")) {
            try {
                this.micr.endInsertion();
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(true);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in endInsertion: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("beginRemoval")) {
            try {
                this.micr.beginRemoval(-1);
                this.beginInsertionButton.setEnabled(false);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in beginRemoval: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("endRemoval")) {
            try {
                this.micr.endRemoval();
                this.beginInsertionButton.setEnabled(true);
                this.endInsertionButton.setEnabled(false);
                this.beginRemovalButton.setEnabled(false);
                this.endRemovalButton.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in endRemoval: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.micr.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.micr.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.micr.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.micr.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.micr.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.micr.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.micr.getCapPowerReporting() == 2 ? "Advanced" : (this.micr.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.micr.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.micr.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.micr.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.micr.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapValidationDevice: " + this.micr.getCapValidationDevice();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.micr.open(logicalName);
                this.micr.addDataListener((DataListener)this.listener);
                this.micr.addErrorListener((ErrorListener)this.listener);
                this.micr.addStatusUpdateListener((StatusUpdateListener)this.listener);
                this.micr.claim(0);
                this.beginInsertionButton.setEnabled(true);
                this.deviceEnabledCB.setEnabled(true);
                this.dataEventEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.micr.setDeviceEnabled(true);
                this.micr.setDataEventEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.micr);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.micr);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.micr.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("clearInputProperties")) {
            try {
                this.micr.clearInputProperties();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInputProperties threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("clearFields")) {
            this.accountNumber = "";
            this.bankNumber = "";
            this.rawData = "";
            this.serialNumber = "";
            this.accountNumberTextField.setText(new String(this.accountNumber));
            this.amountTextField.setText("");
            this.bankNumberTextField.setText(new String(this.bankNumber));
            this.checkTypeTextField.setText("");
            this.countryCodeTextField.setText("");
            this.epcTextField.setText("");
            this.rawDataTextField.setText(new String(this.rawData));
            this.serialNumberTextField.setText(new String(this.serialNumber));
            this.transitNumberTextField.setText("");
        } else if (ae.getActionCommand().equals("refreshFields")) {
            this.doGetFields();
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        try {
            if (this.micr.getState() != 1) {
                this.updateDevice = false;
                this.autoDisableCB.setSelected(this.micr.getAutoDisable());
                this.dataEventEnabledCB.setSelected(this.micr.getDataEventEnabled());
                if (this.micr.getClaimed()) {
                    this.deviceEnabledCB.setSelected(this.micr.getDeviceEnabled());
                }
                this.freezeEventsCB.setSelected(this.micr.getFreezeEvents());
                this.updateDevice = true;
            }
        }
        catch (JposException je) {
            System.err.println("MICRPanel: MethodListener: JposException");
        }
    }

    public void updateGUI() {
        this.rawDataTextField.setText(new String(this.rawData));
        this.accountNumberTextField.setText(new String(this.accountNumber));
        this.bankNumberTextField.setText(new String(this.bankNumber));
        this.serialNumberTextField.setText(new String(this.serialNumber));
        this.autoDisableCB.setSelected(this.autoDisable);
        this.dataEventEnabledCB.setSelected(this.dataEventEnabled);
        this.deviceEnabledCB.setSelected(this.deviceEnabled);
        this.freezeEventsCB.setSelected(this.freezeEvents);
    }

    private class EventListener
    implements StatusUpdateListener,
    DirectIOListener,
    ErrorListener,
    DataListener {
        EventListener() {
        }

        public void statusUpdateOccurred(StatusUpdateEvent sue) {
            JOptionPane.showMessageDialog(null, "Status Update Event: " + sue, "SUE", 1);
        }

        public void directIOOccurred(DirectIOEvent dioe) {
            JOptionPane.showMessageDialog(null, "Direct I/O Event: " + dioe.getEventNumber() + "returned data ='" + Integer.toString(dioe.getData()), "Direct I/O Event", 1);
        }

        public void errorOccurred(ErrorEvent ee) {
            String msg = "Unknown Extended Error: ";
            int errorcode = ee.getErrorCode();
            if (errorcode == 114) {
                int exterr = ee.getErrorCodeExtended();
                msg = String.valueOf(msg) + Integer.toString(exterr);
                switch (exterr) {
                    case 203: {
                        msg = "Bad Data";
                        break;
                    }
                    case 204: {
                        msg = "No Data";
                        break;
                    }
                    case 205: {
                        msg = "Bad Size";
                        break;
                    }
                    case 206: {
                        msg = "Paper Jam";
                        break;
                    }
                    case 207: {
                        msg = "Check digit verification failed";
                        break;
                    }
                    case 208: {
                        msg = "Cover Open";
                        break;
                    }
                    case 201: {
                        msg = "No Check";
                        break;
                    }
                    case 202: {
                        msg = "Check Present";
                    }
                }
            } else {
                msg = Integer.toString(errorcode);
            }
            JOptionPane.showMessageDialog(null, "Error Event: " + msg, "Error Event", 0);
        }

        public void dataOccurred(DataEvent dataEvent) {
            MICRPanel.this.doGetFields();
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (MICRPanel.this.updateDevice) {
                block23: {
                    ItemSelectable source = e.getItemSelectable();
                    if (source == MICRPanel.this.autoDisableCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MICRPanel.this.micr.setAutoDisable(false);
                                break block23;
                            }
                            MICRPanel.this.micr.setAutoDisable(true);
                        }
                        catch (JposException je) {
                            System.err.println("MICRPanel: CheckBoxListener: autoDisable Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == MICRPanel.this.dataEventEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MICRPanel.this.micr.setDataEventEnabled(false);
                                break block23;
                            }
                            MICRPanel.this.micr.setDataEventEnabled(true);
                        }
                        catch (JposException je) {
                            System.err.println("MICRPanel: CheckBoxListener: dataEventEnable Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == MICRPanel.this.deviceEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MICRPanel.this.micr.setDeviceEnabled(false);
                                break block23;
                            }
                            MICRPanel.this.micr.setDeviceEnabled(true);
                        }
                        catch (JposException je) {
                            System.err.println("MICRPanel: CheckBoxListener: deviceEnable Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == MICRPanel.this.freezeEventsCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                MICRPanel.this.micr.setFreezeEvents(false);
                            } else {
                                MICRPanel.this.micr.setFreezeEvents(true);
                            }
                        }
                        catch (JposException je) {
                            System.err.println("MICRPanel: CheckBoxListener: freezeEvents Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    }
                }
                try {
                    MICRPanel.this.updateDevice = false;
                    MICRPanel.this.autoDisableCB.setSelected(MICRPanel.this.micr.getAutoDisable());
                    MICRPanel.this.dataEventEnabledCB.setSelected(MICRPanel.this.micr.getDataEventEnabled());
                    MICRPanel.this.deviceEnabledCB.setSelected(MICRPanel.this.micr.getDeviceEnabled());
                    MICRPanel.this.freezeEventsCB.setSelected(MICRPanel.this.micr.getFreezeEvents());
                    MICRPanel.this.updateDevice = true;
                }
                catch (JposException je) {
                    System.err.println("MICRPanel: CheckBoxListener method received JposException: " + (Object)((Object)je));
                }
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (MICRPanel.this.micr != null) {
                MICRPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(MICRPanel.this.micr.getState()));
            }
        }
    }
}

