/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.JposException;
import jpos.POSKeyboard;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class POSKeyboardPanel
extends Component
implements StatusUpdateListener,
ActionListener,
DataListener {
    private static final long serialVersionUID = -8923742982697493857L;
    protected MainButtonPanel mainButtonPanel;
    private POSKeyboard posKeyboard = new POSKeyboard();
    private String defaultLogicalName = "defaultPOSKeyboard";
    private JLabel keyLabel;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JCheckBox dataEventEnableCB;
    private JCheckBox autoDisableCB;
    private JCheckBox keyUpEvents;
    private JButton clearInputButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public POSKeyboardPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.autoDisableCB = new JCheckBox("Auto Disable");
        propPanel.add(this.autoDisableCB);
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.dataEventEnableCB = new JCheckBox("Data Events Enabled");
        propPanel.add(this.dataEventEnableCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        this.keyUpEvents = new JCheckBox("Generate Key Up Events");
        propPanel.add(this.keyUpEvents);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        this.keyUpEvents.setEnabled(false);
        this.autoDisableCB.setEnabled(false);
        this.dataEventEnableCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        this.keyUpEvents.addItemListener(cbListener);
        this.dataEventEnableCB.addItemListener(cbListener);
        this.autoDisableCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BoxLayout(valuePanel, 1));
        this.keyLabel = new JLabel(" ");
        this.keyLabel.setAlignmentX(0.5f);
        Font f = this.keyLabel.getFont();
        Font newf = new Font(f.getName(), 1, 20);
        this.keyLabel.setFont(newf);
        JLabel label = new JLabel("    Press a POS key.    ");
        label.setAlignmentX(0.5f);
        label.setFont(newf);
        valuePanel.add(label);
        valuePanel.add(this.keyLabel);
        statusPanel.add(Box.createRigidArea(new Dimension(150, 5)));
        statusPanel.add(valuePanel);
        subPanel.add(statusPanel);
        subPanel.add(Box.createHorizontalGlue());
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        JOptionPane.showMessageDialog(null, "POSKeyboard got a Status Update Event: " + sue, "SUE", 1);
    }

    public void dataOccurred(DataEvent de) {
        try {
            String type = this.posKeyboard.getPOSKeyEventType() == 1 ? " Pressed " : " Released ";
            this.keyLabel.setText("POS key " + Integer.toString(this.posKeyboard.getPOSKeyData()) + type);
            this.updateGUI();
        }
        catch (JposException e) {
            JOptionPane.showMessageDialog(null, "Exception in getKeyPosition(): " + e.getMessage(), "Failed", 0);
            System.err.println("Jpos exception " + (Object)((Object)e));
        }
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.posKeyboard.addStatusUpdateListener((StatusUpdateListener)this);
                this.posKeyboard.addDataListener((DataListener)this);
                this.posKeyboard.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                this.dataEventEnableCB.setEnabled(true);
                this.autoDisableCB.setEnabled(true);
                this.keyUpEvents.setEnabled(this.posKeyboard.getCapKeyUp());
                int version = this.posKeyboard.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.posKeyboard.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.posKeyboard.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.posKeyboard.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
                this.dataEventEnableCB.setEnabled(false);
                this.keyUpEvents.setEnabled(false);
                this.autoDisableCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.posKeyboard.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.posKeyboard.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.posKeyboard.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.posKeyboard.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.posKeyboard.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.posKeyboard.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.posKeyboard.getCapPowerReporting() == 2 ? "Advanced" : (this.posKeyboard.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.posKeyboard.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.posKeyboard.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.posKeyboard.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.posKeyboard.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapKeyUp: " + this.posKeyboard.getCapKeyUp();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.posKeyboard.addStatusUpdateListener((StatusUpdateListener)this);
                this.posKeyboard.addDataListener((DataListener)this);
                this.posKeyboard.open(logicalName);
                this.posKeyboard.claim(1000);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.dataEventEnableCB.setEnabled(true);
                this.autoDisableCB.setEnabled(true);
                this.keyUpEvents.setEnabled(this.posKeyboard.getCapKeyUp());
                this.posKeyboard.setDeviceEnabled(true);
                this.posKeyboard.setDataEventEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.posKeyboard);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.posKeyboard);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.posKeyboard.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        if (this.posKeyboard.getState() != 1) {
            this.updateGUI();
        }
    }

    private void updateGUI() {
        try {
            this.deviceEnabledCB.setSelected(this.posKeyboard.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.posKeyboard.getFreezeEvents());
            this.keyUpEvents.setSelected(this.posKeyboard.getEventTypes() == 2);
            this.dataEventEnableCB.setSelected(this.posKeyboard.getDataEventEnabled());
            this.autoDisableCB.setSelected(this.posKeyboard.getAutoDisable());
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "Exception in updateGUI\nException: " + je.getMessage(), "Exception", 0);
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == POSKeyboardPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        POSKeyboardPanel.this.posKeyboard.setDeviceEnabled(false);
                    } else {
                        POSKeyboardPanel.this.posKeyboard.setDeviceEnabled(true);
                    }
                } else if (source == POSKeyboardPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        POSKeyboardPanel.this.posKeyboard.setFreezeEvents(false);
                    } else {
                        POSKeyboardPanel.this.posKeyboard.setFreezeEvents(true);
                    }
                } else if (source == POSKeyboardPanel.this.keyUpEvents) {
                    if (e.getStateChange() == 2) {
                        POSKeyboardPanel.this.posKeyboard.setEventTypes(1);
                    } else {
                        POSKeyboardPanel.this.posKeyboard.setEventTypes(2);
                    }
                } else if (source == POSKeyboardPanel.this.dataEventEnableCB) {
                    if (e.getStateChange() == 2) {
                        POSKeyboardPanel.this.posKeyboard.setDataEventEnabled(false);
                    } else {
                        POSKeyboardPanel.this.posKeyboard.setDataEventEnabled(true);
                    }
                } else if (source == POSKeyboardPanel.this.autoDisableCB) {
                    if (e.getStateChange() == 2) {
                        POSKeyboardPanel.this.posKeyboard.setAutoDisable(false);
                    } else {
                        POSKeyboardPanel.this.posKeyboard.setAutoDisable(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("POSKeyboardPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (POSKeyboardPanel.this.posKeyboard != null) {
                POSKeyboardPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(POSKeyboardPanel.this.posKeyboard.getState()));
            }
        }
    }
}

