/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.JposException;
import jpos.POSPower;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class POSPowerPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = 7596025584100439465L;
    protected MainButtonPanel mainButtonPanel;
    private POSPower posPower = new POSPower();
    private String defaultLogicalName = "defaultPOSPower";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;

    public POSPowerPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        JLabel label = new JLabel("Not yet implemented.");
        label.setAlignmentX(0.5f);
        statusPanel.add(label);
        statusPanel.add(Box.createHorizontalGlue());
        subPanel.add(statusPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("POSPower received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.posPower.addStatusUpdateListener((StatusUpdateListener)this);
                this.posPower.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.posPower.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.posPower.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.posPower.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.posPower.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.posPower.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.posPower.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.posPower.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.posPower.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.posPower.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.posPower.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.posPower.getCapPowerReporting() == 2 ? "Advanced" : (this.posPower.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.posPower.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.posPower.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.posPower.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.posPower.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapFanAlarm: " + this.posPower.getCapFanAlarm();
                msg = String.valueOf(msg) + "\nCapHeatAlarm: " + this.posPower.getCapHeatAlarm();
                msg = String.valueOf(msg) + "\nCapQuickCharge: " + this.posPower.getCapQuickCharge();
                msg = String.valueOf(msg) + "\nCapShutdownPOS: " + this.posPower.getCapShutdownPOS();
                msg = String.valueOf(msg) + "\nCapUPSChargeState: " + this.posPower.getCapUPSChargeState();
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.posPower);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.posPower);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.posPower.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.posPower.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("POSPowerPanel: MethodListener: JposException");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == POSPowerPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        POSPowerPanel.this.posPower.setDeviceEnabled(false);
                    } else {
                        POSPowerPanel.this.posPower.setDeviceEnabled(true);
                    }
                } else if (source == POSPowerPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        POSPowerPanel.this.posPower.setFreezeEvents(false);
                    } else {
                        POSPowerPanel.this.posPower.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("POSPowerPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (POSPowerPanel.this.posPower != null) {
                POSPowerPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(POSPowerPanel.this.posPower.getState()));
            }
        }
    }
}

