/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import jpos.JposException;
import jpos.POSPrinter;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class POSPrinterPanel
extends Component {
    private static final long serialVersionUID = -2637467572297349614L;
    protected MainButtonPanel mainButtonPanel;
    private POSPrinter posPrinter;
    private String defaultLogicalName = "defaultPOSPrinter";
    private JTextArea posPrinterOutputArea;
    private JButton printNormalButton;
    private JButton printImmediateButton;
    private JButton printBarCodeButton;
    private JButton cutPaperButton;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JCheckBox asyncCB;
    private JCheckBox idleCB;
    private JButton letterQualityButton;
    private JComboBox mapModeCombo;
    private JComboBox rotationCombo;
    private JButton beginInsertionButton;
    private JButton endInsertionButton;
    private JButton beginRemovalButton;
    private JButton endRemovalButton;
    private JButton addESCButton;
    private JButton topLogoButton;
    private JButton bottomLogoButton;
    private JButton validateDataButton;
    private JComboBox symbologyCombo;
    private JTextField barCodeHeight;
    private JTextField barCodeWidth;
    private JTextField barCodeData;
    private JComboBox barCodeAlignmentCombo;
    private JComboBox barCodeTextCombo;
    private JButton rotateBarcodeButton;
    private JFileChooser bitmapFileChooser;
    private JTextField bitmapFileName;
    private JButton bitmapBrowse;
    private JButton printBitmapButton;
    private JComboBox bitmapWidth;
    private JComboBox bitmapAlign;
    private JButton setBitmapButton;
    private JComboBox bitmapNumberCombo;
    private JButton rotateBitmapButton;
    private JLabel pageModeArea;
    private JLabel pageModeDescriptor;
    private JTextField pageModeHorizontalPos;
    private JTextField pageModeVerticalPos;
    private JTextField pageModePrintArea;
    private JComboBox pageModeDirectionCombo;
    private JComboBox pageModeStationCombo;
    private JComboBox pageModeControlCombo;
    private JTextArea messages;
    private JScrollPane scrollPane;
    private JButton clearPrintAreadButton;
    private JButton pageModePrintButton;
    private JButton pageModeUpdatePropButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private boolean ver_17_complient = false;
    private int station;
    boolean deviceEnabled;
    boolean freezeEvents;
    boolean updateDevice = true;
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;
    private EventListener eventListener = new EventListener();
    StrVal[] bcSymbologies = new StrVal[]{new StrVal("UPC-A", 101), new StrVal("UPC-A SUP", 111), new StrVal("UPC-E", 102), new StrVal("UPC-E SUP", 112), new StrVal("UPC-D1", 113), new StrVal("UPC-D2", 114), new StrVal("UPC-D3", 115), new StrVal("UPC-D4", 116), new StrVal("UPC-D5", 117), new StrVal("EAN 8 / JAN 8", 103), new StrVal("EAN 8 SUP", 118), new StrVal("EAN 13 / JAN 13", 104), new StrVal("EAN 13 SUP", 119), new StrVal("EAN 128", 120), new StrVal("2 of 5", 105), new StrVal("Int. 2 of 5", 106), new StrVal("Codabar", 107), new StrVal("Code 39", 108), new StrVal("Code 93", 109), new StrVal("Code 128", 110), new StrVal("OCR \"A\"", 121), new StrVal("OCR \"B\"", 122), new StrVal("PDF 417", 201), new StrVal("MAXICODE", 202)};
    StrVal[] bcAlignments = new StrVal[]{new StrVal("Left", -1), new StrVal("Center", -2), new StrVal("Right", -3)};
    StrVal[] bcTextPos = new StrVal[]{new StrVal("None", -11), new StrVal("Above", -12), new StrVal("Below", -13)};
    StrVal[] bitmapWidths = new StrVal[]{new StrVal("One pixel per printer dot", -11)};
    StrVal[] bitmapAlignments = new StrVal[]{new StrVal("Left", -1), new StrVal("Center", -2), new StrVal("Right", -3)};
    StrVal[] rotationValues = new StrVal[]{new StrVal("No Rotation", 1), new StrVal("Rotate Right 90", 257), new StrVal("Rotate Left 90", 258), new StrVal("Rotate 180", 259)};
    StrVal[] mapModeValues = new StrVal[]{new StrVal("Dots", 1), new StrVal("Metric", 4), new StrVal("English", 3), new StrVal("Twips", 2)};
    StrVal[] pmDirections = new StrVal[]{new StrVal("Left to Right", 1), new StrVal("Bottom to Top", 2), new StrVal("Right to Left", 3), new StrVal("Top to Bottom", 4)};
    StrVal[] pmStations = new StrVal[]{new StrVal("None", 0), new StrVal("Reciept", 2), new StrVal("Slip", 4)};
    StrVal[] pmpCommands = new StrVal[]{new StrVal("Enter Page Mode", 1), new StrVal("Print and Save Canvas", 2), new StrVal("Print and Destroy Canvas", 3), new StrVal("Clear Page and Exit Page Mode", 4)};
    MethodListener methodListener = new MethodListener();

    private String getSUEMessage(int code) {
        String value = "Unknown";
        switch (code) {
            case 11: {
                value = "Cover Open";
                break;
            }
            case 12: {
                value = "Cover OK";
                break;
            }
            case 21: {
                value = "Journal Paper Empty";
                break;
            }
            case 22: {
                value = "Journal Paper Near Empty";
                break;
            }
            case 23: {
                value = "Journal Papey OK";
                break;
            }
            case 24: {
                value = "Receipt Paper Empty";
                break;
            }
            case 25: {
                value = "Receipt Paper Near Empty";
                break;
            }
            case 26: {
                value = "Receipt Paper OK";
                break;
            }
            case 27: {
                value = "Slip Paper Empty";
                break;
            }
            case 28: {
                value = "Slip Paper Near Empty";
                break;
            }
            case 29: {
                value = "Slip Paper OK";
                break;
            }
            case 1001: {
                value = "Printer Idle";
                break;
            }
            case 41: {
                value = "Journal Cartridge Empty";
                break;
            }
            case 43: {
                value = "Journal Head Cleaning Started";
                break;
            }
            case 42: {
                value = "Journal Cartridge Near Empty";
                break;
            }
            case 44: {
                value = "Journal Cartridge OK";
                break;
            }
            case 45: {
                value = "Receipt Cartridge Empty";
                break;
            }
            case 47: {
                value = "Receipt Head Cleaning Started";
                break;
            }
            case 46: {
                value = "Receipt Cartridge Near Empty";
                break;
            }
            case 48: {
                value = "Receipt Cartridge OK";
                break;
            }
            case 49: {
                value = "Slip Cartridge Empty";
                break;
            }
            case 51: {
                value = "Slip Head Cleaning Started";
                break;
            }
            case 50: {
                value = "Slip Cartridge Near Empty";
                break;
            }
            case 52: {
                value = "Slip Cartridge OK";
            }
        }
        return value;
    }

    public POSPrinterPanel() {
        this.posPrinter = new POSPrinter();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this.methodListener, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        JPanel devicePanel = new JPanel();
        devicePanel.setLayout(new BoxLayout(devicePanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        this.asyncCB = new JCheckBox("Asynchronus Mode");
        propPanel.add(this.asyncCB);
        this.idleCB = new JCheckBox("Flag when idle");
        propPanel.add(this.idleCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        this.asyncCB.addItemListener(cbListener);
        this.idleCB.addItemListener(cbListener);
        StationListener stationListener = new StationListener();
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        JLabel label = new JLabel("Station: ");
        radioPanel.add(label);
        JRadioButton rButton = new JRadioButton("Receipt");
        rButton.setActionCommand("receipt");
        rButton.addActionListener(stationListener);
        rButton.setSelected(true);
        JRadioButton jButton = new JRadioButton("Journal");
        jButton.setActionCommand("journal");
        jButton.addActionListener(stationListener);
        JRadioButton sButton = new JRadioButton("Slip");
        sButton.setActionCommand("slip");
        sButton.addActionListener(stationListener);
        this.station = 2;
        ButtonGroup group = new ButtonGroup();
        group.add(rButton);
        group.add(jButton);
        group.add(sButton);
        radioPanel.add(rButton);
        radioPanel.add(jButton);
        radioPanel.add(sButton);
        this.rotationCombo = new JComboBox<StrVal>(this.rotationValues);
        this.rotationCombo.setMaximumSize(new Dimension(180, 20));
        this.rotationCombo.setPreferredSize(new Dimension(180, 20));
        this.rotationCombo.setActionCommand("rotationCombo");
        this.rotationCombo.addActionListener(this.methodListener);
        radioPanel.add(Box.createHorizontalGlue());
        radioPanel.add(this.rotationCombo);
        this.mapModeCombo = new JComboBox<StrVal>(this.mapModeValues);
        this.mapModeCombo.setMaximumSize(new Dimension(100, 20));
        this.mapModeCombo.setPreferredSize(new Dimension(100, 20));
        this.mapModeCombo.setActionCommand("mapModeCombo");
        this.mapModeCombo.addActionListener(this.methodListener);
        label = new JLabel("Map Mode: ");
        radioPanel.add(Box.createHorizontalGlue());
        radioPanel.add(label);
        radioPanel.add(this.mapModeCombo);
        JTabbedPane tabbedPane = new JTabbedPane();
        GeneralPrintingPanel gpp = new GeneralPrintingPanel();
        tabbedPane.addTab("General Printing", null, gpp.make(), "General Printing");
        BarcodePanel bcp = new BarcodePanel();
        tabbedPane.addTab("Barcode", null, bcp.make(), "Barcode");
        BitmapPanel bmp = new BitmapPanel();
        tabbedPane.addTab("Bitmap", null, bmp.make(), "Bitmap");
        PageModePanel pmp = new PageModePanel();
        tabbedPane.addTab("Page Mode", null, pmp.make(), "Pagemode");
        this.messages = new JTextArea(5, 5);
        this.messages.setLineWrap(true);
        this.messages.setWrapStyleWord(true);
        this.messages.setEditable(false);
        this.scrollPane = new JScrollPane(this.messages);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        devicePanel.add(radioPanel);
        devicePanel.add(tabbedPane);
        label = new JLabel("Device Messages:");
        label.setAlignmentX(0.0f);
        devicePanel.add(label);
        devicePanel.add(this.scrollPane);
        subPanel.add(devicePanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    private void updateMessages(String msg) {
        this.messages.append(String.valueOf(msg) + "\n");
        this.scrollPane.getVerticalScrollBar().setValue(this.messages.getHeight() - this.messages.getVisibleRect().height);
    }

    private void doUpdatePageModeProps() throws JposException {
        String str = "";
        this.pageModeArea.setText(this.posPrinter.getPageModeArea());
        int num = this.posPrinter.getPageModeDescriptor();
        if ((num & 2) > 0) {
            str = String.valueOf(str) + "Barcode ";
        }
        if ((num & 8) > 0) {
            str = String.valueOf(str) + "Barcode_Rotate ";
        }
        if ((num & 1) > 0) {
            str = String.valueOf(str) + "Bitmap ";
        }
        if ((num & 4) > 0) {
            str = String.valueOf(str) + "Bitmap_Rotate ";
        }
        if ((num & 0x10) > 0) {
            str = String.valueOf(str) + "Opaque ";
        }
        this.pageModeDescriptor.setText(str);
        this.pageModeHorizontalPos.setText(Integer.toString(this.posPrinter.getPageModeHorizontalPosition()));
        this.pageModeVerticalPos.setText(Integer.toString(this.posPrinter.getPageModeVerticalPosition()));
        this.pageModePrintArea.setText(this.posPrinter.getPageModePrintArea());
        this.pageModeDirectionCombo.setSelectedIndex(this.getComboBoxIndex(this.pageModeDirectionCombo, this.posPrinter.getPageModePrintDirection()));
        this.pageModeStationCombo.setSelectedIndex(this.getComboBoxIndex(this.pageModeStationCombo, this.posPrinter.getPageModeStation()));
    }

    public static String getCharSetName(int id) {
        String value = "Unknown";
        switch (id) {
            case 1: {
                value = "PTR_CCS_ALPHA";
                break;
            }
            case 998: {
                value = "PTR_CCS_ASCII";
                break;
            }
            case 10: {
                value = "PTR_CCS_KANA";
                break;
            }
            case 11: {
                value = "PTR_CCS_KANJI";
                break;
            }
            case 997: {
                value = "PTR_CCS_UNICODE";
            }
        }
        return value;
    }

    public static String getCartridgeSensorName(int id) {
        String value = "";
        if ((id & 1) > 0) {
            value = String.valueOf(value) + "PTR_CART_REMOVED | ";
        }
        if ((id & 2) > 0) {
            value = String.valueOf(value) + "PTR_CART_EMPTY | ";
        }
        if ((id & 8) > 0) {
            value = String.valueOf(value) + "PTR_CART_CLEANING | ";
        }
        if ((id & 4) > 0) {
            value = String.valueOf(value) + "PTR_CART_NEAREND";
        }
        if (id == 0) {
            value = "No cartridge sensing.";
        }
        return value;
    }

    public static String getColorName(int id) {
        String value = "";
        if ((id & 1) > 0) {
            value = String.valueOf(value) + "PTR_COLOR_PRIMARY";
        }
        if ((id & 2) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CUSTOM1";
        }
        if ((id & 4) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CUSTOM2";
        }
        if ((id & 8) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CUSTOM3";
        }
        if ((id & 0x10) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CUSTOM4";
        }
        if ((id & 0x20) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CUSTOM5";
        }
        if ((id & 0x40) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CUSTOM6";
        }
        if ((id & 0x100) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_CYAN";
        }
        if ((id & 0x200) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_MAGENTA";
        }
        if ((id & 0x400) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_YELLOW";
        }
        if ((id & Integer.MIN_VALUE) > 0) {
            value = String.valueOf(value) + " | PTR_COLOR_FULL";
        }
        return value;
    }

    public static String getMarkFeedName(int id) {
        String value = "";
        if ((id & 1) > 0) {
            value = String.valueOf(value) + "PTR_MF_TO_TAKEUP | ";
        }
        if ((id & 2) > 0) {
            value = String.valueOf(value) + "PTR_MF_TO_CUTTER | ";
        }
        if ((id & 4) > 0) {
            value = String.valueOf(value) + "PTR_MF_TO_CURRENT_TOF | ";
        }
        if ((id & 8) > 0) {
            value = String.valueOf(value) + "PTR_MF_TO_NEXT_TOF";
        }
        if (id == 0) {
            value = "Paper handling not supported";
        }
        return value;
    }

    public void errorDialog(JposException je, String call) {
        if (je.getErrorCode() == 114) {
            String msg = "Unknown Extended Error";
            switch (je.getErrorCodeExtended()) {
                case 201: {
                    msg = "Cover Open";
                    break;
                }
                case 202: {
                    msg = "Journal Paper Empty";
                    break;
                }
                case 203: {
                    msg = "Reciept Papaer Empty";
                    break;
                }
                case 204: {
                    msg = "Slip Paper Empty";
                    break;
                }
                case 205: {
                    msg = "Form Present";
                    break;
                }
                case 206: {
                    msg = "Bitmap Too Big";
                    break;
                }
                case 207: {
                    msg = "Bad Image Format";
                    break;
                }
                case 208: {
                    msg = "Journal Cartridge Removed";
                    break;
                }
                case 209: {
                    msg = "Journal Cartridge Empty";
                    break;
                }
                case 210: {
                    msg = "Journal Head Cleaning";
                    break;
                }
                case 211: {
                    msg = "Reciept Cartridge Removed";
                    break;
                }
                case 212: {
                    msg = "Reciept Cartridge Empty";
                    break;
                }
                case 213: {
                    msg = "Reciept Head Cleaning";
                    break;
                }
                case 214: {
                    msg = "Slip Cartridge Removed";
                    break;
                }
                case 215: {
                    msg = "Slip Cartridge Empty";
                    break;
                }
                case 216: {
                    msg = "Slip Head Cleaning";
                }
            }
            JOptionPane.showMessageDialog(null, "Extended error in " + call + ": " + msg, "Exception", 0);
        } else {
            JOptionPane.showMessageDialog(null, "Exception in " + call + ": " + je.getMessage(), "Exception", 0);
        }
    }

    private int getComboBoxIndex(JComboBox box, int strValValue) {
        int i = 0;
        while (i < box.getItemCount()) {
            try {
                if (((StrVal)box.getItemAt((int)i)).value == strValValue) {
                    return i;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return -1;
    }

    private class EventListener
    implements StatusUpdateListener,
    OutputCompleteListener,
    DirectIOListener,
    ErrorListener {
        EventListener() {
        }

        public void statusUpdateOccurred(StatusUpdateEvent sue) {
            POSPrinterPanel.this.updateMessages("SUE: " + POSPrinterPanel.this.getSUEMessage(sue.getStatus()));
        }

        public void directIOOccurred(DirectIOEvent dioe) {
            POSPrinterPanel.this.updateMessages("Dir I/O:  Direct I/O Event " + dioe.getEventNumber() + "returned data ='" + Integer.toString(dioe.getData()));
        }

        public void outputCompleteOccurred(OutputCompleteEvent oce) {
            POSPrinterPanel.this.updateMessages("OCE: Output Event" + oce.getOutputID() + " compleated");
        }

        public void errorOccurred(ErrorEvent ee) {
            POSPrinterPanel.this.updateMessages("Error: Error Event" + ee);
        }
    }

    private class StrVal {
        int value;
        String name;

        public StrVal(String n, int v) {
            this.value = v;
            this.name = n;
        }

        public String toString() {
            return this.name;
        }
    }

    class MethodListener
    implements ActionListener {
        MethodListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            POSPrinterPanel.this.mainButtonPanel.action(ae);
            String logicalName = POSPrinterPanel.this.mainButtonPanel.getLogicalName();
            if (ae.getActionCommand().equals("open")) {
                try {
                    if (logicalName.equals("")) {
                        logicalName = POSPrinterPanel.this.defaultLogicalName;
                    }
                    POSPrinterPanel.this.posPrinter.open(logicalName);
                    POSPrinterPanel.this.posPrinter.addStatusUpdateListener((StatusUpdateListener)POSPrinterPanel.this.eventListener);
                    POSPrinterPanel.this.posPrinter.addOutputCompleteListener((OutputCompleteListener)POSPrinterPanel.this.eventListener);
                    POSPrinterPanel.this.posPrinter.addErrorListener((ErrorListener)POSPrinterPanel.this.eventListener);
                    POSPrinterPanel.this.posPrinter.addDirectIOListener((DirectIOListener)POSPrinterPanel.this.eventListener);
                    POSPrinterPanel.this.mapModeCombo.setSelectedIndex(0);
                    int version = POSPrinterPanel.this.posPrinter.getDeviceServiceVersion();
                    if (version >= 1009000) {
                        POSPrinterPanel.this.ver_19_complient = true;
                        POSPrinterPanel.this.ver_18_complient = true;
                        POSPrinterPanel.this.ver_17_complient = true;
                    }
                    if (version >= 1008000) {
                        POSPrinterPanel.this.ver_18_complient = true;
                        POSPrinterPanel.this.ver_17_complient = true;
                    }
                    if (version >= 1007000) {
                        POSPrinterPanel.this.ver_17_complient = true;
                    }
                    if (POSPrinterPanel.this.ver_19_complient) {
                        POSPrinterPanel.this.doUpdatePageModeProps();
                    }
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            } else if (ae.getActionCommand().equals("claim")) {
                try {
                    POSPrinterPanel.this.posPrinter.claim(0);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            } else if (ae.getActionCommand().equals("release")) {
                try {
                    POSPrinterPanel.this.posPrinter.release();
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            } else if (ae.getActionCommand().equals("close")) {
                try {
                    POSPrinterPanel.this.posPrinter.close();
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            } else if (ae.getActionCommand().equals("printNormal")) {
                try {
                    String text = POSPrinterPanel.this.posPrinterOutputArea.getText();
                    POSPrinterPanel.this.posPrinter.printNormal(POSPrinterPanel.this.station, text);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in printNormal(): " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("cutPaper")) {
                try {
                    POSPrinterPanel.this.posPrinter.cutPaper(90);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in cutPaper(): " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("printBarCode")) {
                try {
                    int index = POSPrinterPanel.this.symbologyCombo.getSelectedIndex();
                    int symbology = ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).symbologyCombo.getItemAt((int)index)).value;
                    int height = Integer.parseInt(POSPrinterPanel.this.barCodeHeight.getText());
                    int width = Integer.parseInt(POSPrinterPanel.this.barCodeWidth.getText());
                    index = POSPrinterPanel.this.barCodeAlignmentCombo.getSelectedIndex();
                    int alignment = index == -1 ? Integer.parseInt((String)POSPrinterPanel.this.barCodeAlignmentCombo.getSelectedItem()) : ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).barCodeAlignmentCombo.getSelectedItem()).value;
                    index = POSPrinterPanel.this.barCodeTextCombo.getSelectedIndex();
                    int textPos = ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).barCodeTextCombo.getItemAt((int)index)).value;
                    POSPrinterPanel.this.posPrinter.printBarCode(POSPrinterPanel.this.station, POSPrinterPanel.this.barCodeData.getText(), symbology, height, width, alignment, textPos);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Make sure your barcode width & height are valid numbers", "Number Format Exception", 0);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in printBarCode(): " + e.getMessage(), "Exception", 0);
                }
            } else if (ae.getActionCommand().equals("info")) {
                try {
                    JFrame infoFrame = new JFrame("POStest");
                    infoFrame.setSize(700, 500);
                    JPanel mainPanel = new JPanel();
                    mainPanel.setLayout(new BoxLayout(mainPanel, 1));
                    JTabbedPane tabbedPane = new JTabbedPane();
                    JPanel generalInfo = new JPanel();
                    JPanel genCaps = new JPanel();
                    JPanel jrnCaps = new JPanel();
                    JPanel recCaps = new JPanel();
                    JPanel slpCaps = new JPanel();
                    generalInfo.setLayout(new BoxLayout(generalInfo, 1));
                    generalInfo.add(Box.createRigidArea(new Dimension(5, 10)));
                    String ver = new Integer(POSPrinterPanel.this.posPrinter.getDeviceServiceVersion()).toString();
                    generalInfo.add(new JLabel("Service Description: " + POSPrinterPanel.this.posPrinter.getDeviceServiceDescription()));
                    generalInfo.add(new JLabel("Service Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7))));
                    generalInfo.add(Box.createRigidArea(new Dimension(5, 10)));
                    ver = new Integer(POSPrinterPanel.this.posPrinter.getDeviceControlVersion()).toString();
                    generalInfo.add(new JLabel("Control Description: " + POSPrinterPanel.this.posPrinter.getDeviceControlDescription()));
                    generalInfo.add(new JLabel("Control Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7))));
                    generalInfo.add(Box.createRigidArea(new Dimension(5, 10)));
                    generalInfo.add(new JLabel("Physical Device Name: " + POSPrinterPanel.this.posPrinter.getPhysicalDeviceName()));
                    generalInfo.add(new JLabel("Physical Device Description: " + POSPrinterPanel.this.posPrinter.getPhysicalDeviceDescription()));
                    genCaps.setLayout(new BoxLayout(genCaps, 1));
                    genCaps.add(Box.createRigidArea(new Dimension(5, 10)));
                    genCaps.add(new JLabel("CapPowerReporting: " + (POSPrinterPanel.this.posPrinter.getCapPowerReporting() == 2 ? "Advanced" : (POSPrinterPanel.this.posPrinter.getCapPowerReporting() == 1 ? "Standard" : "None"))));
                    if (POSPrinterPanel.this.ver_18_complient) {
                        genCaps.add(new JLabel("CapStatisticsReporting: " + POSPrinterPanel.this.posPrinter.getCapStatisticsReporting()));
                        genCaps.add(new JLabel("CapUpdateStatistics: " + POSPrinterPanel.this.posPrinter.getCapUpdateStatistics()));
                    } else {
                        genCaps.add(new JLabel("CapStatisticsReporting: Service Object is not 1.8 complient"));
                        genCaps.add(new JLabel("CapUpdateStatistics: Service Object is not 1.8 complient"));
                    }
                    if (POSPrinterPanel.this.ver_19_complient) {
                        genCaps.add(new JLabel("CapCompareFirmwareVersion: " + POSPrinterPanel.this.posPrinter.getCapCompareFirmwareVersion()));
                        genCaps.add(new JLabel("CapUpdateFirmware: " + POSPrinterPanel.this.posPrinter.getCapUpdateFirmware()));
                    } else {
                        genCaps.add(new JLabel("CapCompareFirmwareVersion: Service Object is not 1.8 complient"));
                        genCaps.add(new JLabel("CapUpdateFirmware: Service Object is not 1.8 complient"));
                    }
                    genCaps.add(new JLabel("CapCharacterSet: " + POSPrinterPanel.getCharSetName(POSPrinterPanel.this.posPrinter.getCapCharacterSet())));
                    genCaps.add(new JLabel("CapConcurrentJrnRec: " + POSPrinterPanel.this.posPrinter.getCapConcurrentJrnRec()));
                    genCaps.add(new JLabel("CapConcurrentJrnSlp: " + POSPrinterPanel.this.posPrinter.getCapConcurrentJrnSlp()));
                    genCaps.add(new JLabel("CapConcurrentRecSlp: " + POSPrinterPanel.this.posPrinter.getCapConcurrentRecSlp()));
                    if (POSPrinterPanel.this.ver_19_complient) {
                        genCaps.add(new JLabel("CapConcurentPageMode: " + POSPrinterPanel.this.posPrinter.getCapConcurrentPageMode()));
                    } else {
                        genCaps.add(new JLabel("CapConcurentPageMode: Service Object is not 1.9 complient"));
                    }
                    genCaps.add(new JLabel("CapCoverSensor: " + POSPrinterPanel.this.posPrinter.getCapCoverSensor()));
                    if (POSPrinterPanel.this.ver_17_complient) {
                        genCaps.add(new JLabel("CapMapCharacterSet: " + POSPrinterPanel.this.posPrinter.getCapMapCharacterSet()));
                    } else {
                        genCaps.add(new JLabel("CapMapCharacterSet: Service Object is not 1.8 complient"));
                    }
                    genCaps.add(new JLabel("CapTransaction: " + POSPrinterPanel.this.posPrinter.getCapMapCharacterSet()));
                    jrnCaps.setLayout(new BoxLayout(jrnCaps, 1));
                    jrnCaps.add(Box.createRigidArea(new Dimension(5, 10)));
                    jrnCaps.add(new JLabel("CapJrnPresent: " + POSPrinterPanel.this.posPrinter.getCapJrnPresent()));
                    jrnCaps.add(new JLabel("CapJrn2Color: " + POSPrinterPanel.this.posPrinter.getCapJrn2Color()));
                    jrnCaps.add(new JLabel("CapJrnBold: " + POSPrinterPanel.this.posPrinter.getCapJrnBold()));
                    jrnCaps.add(new JLabel("CapJrnDhigh: " + POSPrinterPanel.this.posPrinter.getCapJrnDhigh()));
                    jrnCaps.add(new JLabel("CapJrnDwide: " + POSPrinterPanel.this.posPrinter.getCapJrnDwide()));
                    jrnCaps.add(new JLabel("CapJrnDwideDhigh: " + POSPrinterPanel.this.posPrinter.getCapJrnDwideDhigh()));
                    jrnCaps.add(new JLabel("CapJrnEmptySensor: " + POSPrinterPanel.this.posPrinter.getCapJrnEmptySensor()));
                    jrnCaps.add(new JLabel("CapJrnItalic: " + POSPrinterPanel.this.posPrinter.getCapJrnItalic()));
                    jrnCaps.add(new JLabel("CapJrnNearEndSensor: " + POSPrinterPanel.this.posPrinter.getCapJrnNearEndSensor()));
                    jrnCaps.add(new JLabel("CapJrnUnderline: " + POSPrinterPanel.this.posPrinter.getCapJrnUnderline()));
                    jrnCaps.add(new JLabel("CapJrnCartridgeSensor: " + POSPrinterPanel.getCartridgeSensorName(POSPrinterPanel.this.posPrinter.getCapJrnCartridgeSensor())));
                    jrnCaps.add(new JLabel("CapJrnColor: " + POSPrinterPanel.getColorName(POSPrinterPanel.this.posPrinter.getCapJrnColor())));
                    recCaps.setLayout(new BoxLayout(recCaps, 1));
                    recCaps.add(Box.createRigidArea(new Dimension(5, 10)));
                    recCaps.add(new JLabel("CapRecPresent: " + POSPrinterPanel.this.posPrinter.getCapRecPresent()));
                    recCaps.add(new JLabel("CapRec2Color: " + POSPrinterPanel.this.posPrinter.getCapRec2Color()));
                    recCaps.add(new JLabel("CapRecBarCode: " + POSPrinterPanel.this.posPrinter.getCapRecBarCode()));
                    recCaps.add(new JLabel("CapRecBitmap: " + POSPrinterPanel.this.posPrinter.getCapRecBitmap()));
                    recCaps.add(new JLabel("CapRecBold: " + POSPrinterPanel.this.posPrinter.getCapRecBold()));
                    recCaps.add(new JLabel("CapRecDhigh: " + POSPrinterPanel.this.posPrinter.getCapRecDhigh()));
                    recCaps.add(new JLabel("CapRecDwide: " + POSPrinterPanel.this.posPrinter.getCapRecDwide()));
                    recCaps.add(new JLabel("CapRecDwideDhigh: " + POSPrinterPanel.this.posPrinter.getCapRecDwideDhigh()));
                    recCaps.add(new JLabel("CapRecEmptySensor: " + POSPrinterPanel.this.posPrinter.getCapRecEmptySensor()));
                    recCaps.add(new JLabel("CapRecItalic: " + POSPrinterPanel.this.posPrinter.getCapRecItalic()));
                    recCaps.add(new JLabel("CapRecLeft90: " + POSPrinterPanel.this.posPrinter.getCapRecLeft90()));
                    recCaps.add(new JLabel("CapRecNearEndSensor: " + POSPrinterPanel.this.posPrinter.getCapRecNearEndSensor()));
                    recCaps.add(new JLabel("CapRecPapercut: " + POSPrinterPanel.this.posPrinter.getCapRecPapercut()));
                    recCaps.add(new JLabel("CapRecRight90: " + POSPrinterPanel.this.posPrinter.getCapRecRight90()));
                    recCaps.add(new JLabel("CapRecRotate180: " + POSPrinterPanel.this.posPrinter.getCapRecRotate180()));
                    recCaps.add(new JLabel("CapRecStamp: " + POSPrinterPanel.this.posPrinter.getCapRecStamp()));
                    recCaps.add(new JLabel("CapRecUnderline: " + POSPrinterPanel.this.posPrinter.getCapRecUnderline()));
                    recCaps.add(new JLabel("CapRecCartridgeSensor: " + POSPrinterPanel.getCartridgeSensorName(POSPrinterPanel.this.posPrinter.getCapRecCartridgeSensor())));
                    recCaps.add(new JLabel("CapRecColor: " + POSPrinterPanel.getColorName(POSPrinterPanel.this.posPrinter.getCapRecColor())));
                    recCaps.add(new JLabel("CapRecMarkFeed: " + POSPrinterPanel.getMarkFeedName(POSPrinterPanel.this.posPrinter.getCapRecMarkFeed())));
                    if (POSPrinterPanel.this.ver_19_complient) {
                        recCaps.add(new JLabel("CapRecPageMode: " + POSPrinterPanel.this.posPrinter.getCapRecPageMode()));
                    } else {
                        recCaps.add(new JLabel("CapRecPageMode: Service Object is not 1.9 complient"));
                    }
                    slpCaps.setLayout(new BoxLayout(slpCaps, 1));
                    slpCaps.add(Box.createRigidArea(new Dimension(5, 10)));
                    slpCaps.add(new JLabel("CapSlpPresent: " + POSPrinterPanel.this.posPrinter.getCapSlpPresent()));
                    slpCaps.add(new JLabel("CapSlp2Color: " + POSPrinterPanel.this.posPrinter.getCapSlp2Color()));
                    slpCaps.add(new JLabel("CapSlpBarCode: " + POSPrinterPanel.this.posPrinter.getCapSlpBarCode()));
                    slpCaps.add(new JLabel("CapSlpBitmap: " + POSPrinterPanel.this.posPrinter.getCapSlpBitmap()));
                    slpCaps.add(new JLabel("CapSlpBold: " + POSPrinterPanel.this.posPrinter.getCapSlpBold()));
                    slpCaps.add(new JLabel("CapSlpDhigh: " + POSPrinterPanel.this.posPrinter.getCapSlpDhigh()));
                    slpCaps.add(new JLabel("CapSlpDwide: " + POSPrinterPanel.this.posPrinter.getCapSlpDwide()));
                    slpCaps.add(new JLabel("CapSlpDwideDhigh: " + POSPrinterPanel.this.posPrinter.getCapSlpDwideDhigh()));
                    slpCaps.add(new JLabel("CapSlpEmptySensor: " + POSPrinterPanel.this.posPrinter.getCapSlpEmptySensor()));
                    slpCaps.add(new JLabel("CapSlpItalic: " + POSPrinterPanel.this.posPrinter.getCapSlpItalic()));
                    slpCaps.add(new JLabel("CapSlpLeft90: " + POSPrinterPanel.this.posPrinter.getCapSlpLeft90()));
                    slpCaps.add(new JLabel("CapSlpNearEndSensor: " + POSPrinterPanel.this.posPrinter.getCapSlpNearEndSensor()));
                    slpCaps.add(new JLabel("CapSlpRight90: " + POSPrinterPanel.this.posPrinter.getCapSlpRight90()));
                    slpCaps.add(new JLabel("CapSlpRotate180: " + POSPrinterPanel.this.posPrinter.getCapSlpRotate180()));
                    slpCaps.add(new JLabel("CapSlpUnderline: " + POSPrinterPanel.this.posPrinter.getCapSlpUnderline()));
                    slpCaps.add(new JLabel("CapSlpBothSidesPrint: " + POSPrinterPanel.this.posPrinter.getCapSlpBothSidesPrint()));
                    slpCaps.add(new JLabel("CapSlpCartridgeSensor: " + POSPrinterPanel.getCartridgeSensorName(POSPrinterPanel.this.posPrinter.getCapSlpCartridgeSensor())));
                    slpCaps.add(new JLabel("CapSlpColor: " + POSPrinterPanel.getColorName(POSPrinterPanel.this.posPrinter.getCapSlpColor())));
                    if (POSPrinterPanel.this.ver_19_complient) {
                        slpCaps.add(new JLabel("CapSlpPageMode: " + POSPrinterPanel.this.posPrinter.getCapSlpPageMode()));
                    } else {
                        slpCaps.add(new JLabel("CapSlpPageMode: Service Object is not 1.9 complient"));
                    }
                    tabbedPane.addTab("General Info", null, generalInfo, "GeneralInfo");
                    tabbedPane.addTab("General Capabilities", null, genCaps, "GeneralCapabilities");
                    tabbedPane.addTab("Journal Capabilities", null, jrnCaps, "JournalCapabilities");
                    tabbedPane.addTab("Receipt Capabilities", null, recCaps, "ReceiptCapabilities");
                    tabbedPane.addTab("Slip Capabilities", null, slpCaps, "SlipCapabilities");
                    JButton okButton = new JButton("Close");
                    okButton.setAlignmentX(0.5f);
                    okButton.addActionListener(new ActionListener(this, infoFrame){
                        final /* synthetic */ MethodListener this$1;
                        private final /* synthetic */ JFrame val$infoFrame;
                        {
                            this.this$1 = methodListener;
                            this.val$infoFrame = jFrame;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            this.val$infoFrame.setVisible(false);
                        }
                    });
                    mainPanel.add(tabbedPane);
                    mainPanel.add(Box.createRigidArea(new Dimension(5, 10)));
                    mainPanel.add(okButton);
                    mainPanel.add(Box.createRigidArea(new Dimension(5, 10)));
                    infoFrame.getContentPane().add(mainPanel);
                    infoFrame.setVisible(true);
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            } else if (ae.getActionCommand().equals("bitmapBrowse")) {
                try {
                    int retVal = POSPrinterPanel.this.bitmapFileChooser.showOpenDialog(null);
                    if (retVal == 0) {
                        POSPrinterPanel.this.bitmapFileName.setText(POSPrinterPanel.this.bitmapFileChooser.getSelectedFile().toURL().toString());
                    }
                }
                catch (Exception retVal) {}
            } else if (ae.getActionCommand().equals("printBitmap")) {
                try {
                    String filename = POSPrinterPanel.this.bitmapFileName.getText();
                    int index = POSPrinterPanel.this.bitmapWidth.getSelectedIndex();
                    int width = index == -1 ? Integer.parseInt((String)POSPrinterPanel.this.bitmapWidth.getSelectedItem()) : ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).bitmapWidth.getSelectedItem()).value;
                    index = POSPrinterPanel.this.bitmapAlign.getSelectedIndex();
                    int alignment = index == -1 ? Integer.parseInt((String)POSPrinterPanel.this.bitmapAlign.getSelectedItem()) : ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).bitmapAlign.getSelectedItem()).value;
                    POSPrinterPanel.this.posPrinter.printBitmap(POSPrinterPanel.this.station, filename, width, alignment);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "printBitmap");
                }
            } else if (ae.getActionCommand().equals("beginInsertion")) {
                try {
                    POSPrinterPanel.this.posPrinter.beginInsertion(-1);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "beginInsertion");
                }
            } else if (ae.getActionCommand().equals("endInsertion")) {
                try {
                    POSPrinterPanel.this.posPrinter.endInsertion();
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "endInsertion");
                }
            } else if (ae.getActionCommand().equals("beginRemoval")) {
                try {
                    POSPrinterPanel.this.posPrinter.beginRemoval(-1);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "beginRemoval");
                }
            } else if (ae.getActionCommand().equals("endRemoval")) {
                try {
                    POSPrinterPanel.this.posPrinter.endRemoval();
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "endRemoval");
                }
            } else if (ae.getActionCommand().equals("printImmediate")) {
                try {
                    POSPrinterPanel.this.posPrinter.printImmediate(POSPrinterPanel.this.station, POSPrinterPanel.this.posPrinterOutputArea.getText());
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "printImmediate");
                }
            } else if (ae.getActionCommand().equals("setBitmap")) {
                try {
                    String filename = POSPrinterPanel.this.bitmapFileName.getText();
                    int index = POSPrinterPanel.this.bitmapWidth.getSelectedIndex();
                    int number = Integer.parseInt((String)POSPrinterPanel.this.bitmapNumberCombo.getSelectedItem());
                    int width = index == -1 ? Integer.parseInt((String)POSPrinterPanel.this.bitmapWidth.getSelectedItem()) : ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).bitmapWidth.getSelectedItem()).value;
                    index = POSPrinterPanel.this.bitmapAlign.getSelectedIndex();
                    int alignment = index == -1 ? Integer.parseInt((String)POSPrinterPanel.this.bitmapAlign.getSelectedItem()) : ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).bitmapAlign.getSelectedItem()).value;
                    POSPrinterPanel.this.posPrinter.setBitmap(number, POSPrinterPanel.this.station, filename, width, alignment);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "setBitmap");
                }
            } else if (ae.getActionCommand().equals("addESC")) {
                byte[] str = new byte[]{27, 124};
                POSPrinterPanel.this.posPrinterOutputArea.append(new String(str));
            } else if (ae.getActionCommand().equals("topLogo")) {
                try {
                    POSPrinterPanel.this.posPrinter.setLogo(1, POSPrinterPanel.this.posPrinterOutputArea.getText());
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "setLogo");
                }
            } else if (ae.getActionCommand().equals("bottomLogo")) {
                try {
                    POSPrinterPanel.this.posPrinter.setLogo(2, POSPrinterPanel.this.posPrinterOutputArea.getText());
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "setLogo");
                }
            } else if (ae.getActionCommand().equals("validateData")) {
                try {
                    POSPrinterPanel.this.posPrinter.validateData(POSPrinterPanel.this.station, POSPrinterPanel.this.posPrinterOutputArea.getText());
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "validateData");
                }
            } else if (ae.getActionCommand().equals("rotationCombo")) {
                try {
                    int value = ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).rotationCombo.getSelectedItem()).value;
                    POSPrinterPanel.this.posPrinter.rotatePrint(POSPrinterPanel.this.station, value);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "rotatePrint");
                }
            } else if (ae.getActionCommand().equals("rotateBarcode")) {
                try {
                    int value = ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).rotationCombo.getSelectedItem()).value;
                    POSPrinterPanel.this.posPrinter.rotatePrint(POSPrinterPanel.this.station, value | 0x1000);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "rotatePrint");
                }
            } else if (ae.getActionCommand().equals("mapModeCombo")) {
                try {
                    int value = ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).mapModeCombo.getSelectedItem()).value;
                    POSPrinterPanel.this.posPrinter.setMapMode(value);
                    if (POSPrinterPanel.this.ver_19_complient) {
                        POSPrinterPanel.this.doUpdatePageModeProps();
                    }
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "setMapMode");
                }
            } else if (ae.getActionCommand().equals("rotateBitmap")) {
                try {
                    int value = ((StrVal)((POSPrinterPanel)POSPrinterPanel.this).rotationCombo.getSelectedItem()).value;
                    POSPrinterPanel.this.posPrinter.rotatePrint(POSPrinterPanel.this.station, value | 0x2000);
                }
                catch (JposException e) {
                    POSPrinterPanel.this.errorDialog(e, "rotatePrint");
                }
            } else if (ae.getActionCommand().equals("stats")) {
                try {
                    StatisticsDialog dlg = new StatisticsDialog(POSPrinterPanel.this.posPrinter);
                    dlg.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("firmware")) {
                try {
                    FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(POSPrinterPanel.this.posPrinter);
                    dlg.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("letterQuality")) {
                try {
                    if (POSPrinterPanel.this.station == 2) {
                        POSPrinterPanel.this.posPrinter.setRecLetterQuality(!POSPrinterPanel.this.posPrinter.getRecLetterQuality());
                        POSPrinterPanel.this.updateMessages("set RecLetterQuality to " + POSPrinterPanel.this.posPrinter.getRecLetterQuality());
                    } else if (POSPrinterPanel.this.station == 4) {
                        POSPrinterPanel.this.posPrinter.setSlpLetterQuality(!POSPrinterPanel.this.posPrinter.getSlpLetterQuality());
                        POSPrinterPanel.this.updateMessages("set SlpLetterQuality to " + POSPrinterPanel.this.posPrinter.getSlpLetterQuality());
                    }
                    if (POSPrinterPanel.this.station == 1) {
                        POSPrinterPanel.this.posPrinter.setJrnLetterQuality(!POSPrinterPanel.this.posPrinter.getJrnLetterQuality());
                        POSPrinterPanel.this.updateMessages("set JrnLetterQuality to " + POSPrinterPanel.this.posPrinter.getJrnLetterQuality());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("pageModeUpdateProp")) {
                try {
                    if (POSPrinterPanel.this.posPrinter.getPageModeStation() != 0) {
                        POSPrinterPanel.this.posPrinter.setPageModeHorizontalPosition(Integer.parseInt(POSPrinterPanel.this.pageModeHorizontalPos.getText()));
                        POSPrinterPanel.this.posPrinter.setPageModePrintArea(POSPrinterPanel.this.pageModePrintArea.getText());
                        POSPrinterPanel.this.posPrinter.setPageModePrintDirection(((StrVal)((POSPrinterPanel)POSPrinterPanel.this).pageModeDirectionCombo.getSelectedItem()).value);
                        POSPrinterPanel.this.posPrinter.setPageModeVerticalPosition(Integer.parseInt(POSPrinterPanel.this.pageModeVerticalPos.getText()));
                    }
                    POSPrinterPanel.this.doUpdatePageModeProps();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("clearPrintArea")) {
                try {
                    POSPrinterPanel.this.posPrinter.clearPrintArea();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("pageModePrint")) {
                try {
                    POSPrinterPanel.this.posPrinter.pageModePrint(((StrVal)((POSPrinterPanel)POSPrinterPanel.this).pageModeControlCombo.getSelectedItem()).value);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            } else if (ae.getActionCommand().equals("pageModeStationCombo")) {
                try {
                    POSPrinterPanel.this.posPrinter.setPageModeStation(((StrVal)((POSPrinterPanel)POSPrinterPanel.this).pageModeStationCombo.getSelectedItem()).value);
                    POSPrinterPanel.this.doUpdatePageModeProps();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            }
            try {
                if (POSPrinterPanel.this.posPrinter.getState() != 1) {
                    POSPrinterPanel.this.updateDevice = false;
                    if (POSPrinterPanel.this.posPrinter.getClaimed()) {
                        POSPrinterPanel.this.deviceEnabledCB.setSelected(POSPrinterPanel.this.posPrinter.getDeviceEnabled());
                    }
                    POSPrinterPanel.this.freezeEventsCB.setSelected(POSPrinterPanel.this.posPrinter.getFreezeEvents());
                    POSPrinterPanel.this.asyncCB.setSelected(POSPrinterPanel.this.posPrinter.getAsyncMode());
                    POSPrinterPanel.this.updateDevice = true;
                }
            }
            catch (JposException je) {
                System.err.println("POSPrinterPanel: ActionPerformedmethod received JposException: " + (Object)((Object)je));
            }
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            block21: {
                if (POSPrinterPanel.this.updateDevice) {
                    ItemSelectable source = e.getItemSelectable();
                    if (source == POSPrinterPanel.this.deviceEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                POSPrinterPanel.this.posPrinter.setDeviceEnabled(false);
                                break block21;
                            }
                            POSPrinterPanel.this.posPrinter.setDeviceEnabled(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "Exception in setDeviceEnabled: " + je.getMessage(), "Exception", 0);
                        }
                    } else if (source == POSPrinterPanel.this.freezeEventsCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                POSPrinterPanel.this.posPrinter.setFreezeEvents(false);
                                break block21;
                            }
                            POSPrinterPanel.this.posPrinter.setFreezeEvents(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "Exception in setFreezeEvents: " + je.getMessage(), "Exception", 0);
                        }
                    } else if (source == POSPrinterPanel.this.asyncCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                POSPrinterPanel.this.posPrinter.setAsyncMode(false);
                                break block21;
                            }
                            POSPrinterPanel.this.posPrinter.setAsyncMode(true);
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "Exception in setAsyncMode: " + je.getMessage(), "Exception", 0);
                        }
                    } else if (source == POSPrinterPanel.this.idleCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                POSPrinterPanel.this.posPrinter.setFlagWhenIdle(false);
                            } else {
                                POSPrinterPanel.this.posPrinter.setFlagWhenIdle(true);
                            }
                        }
                        catch (JposException je) {
                            JOptionPane.showMessageDialog(null, "Exception in setFlagWhenIdle: " + je.getMessage(), "Exception", 0);
                        }
                    }
                }
            }
        }
    }

    class StationListener
    implements ActionListener {
        StationListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("receipt")) {
                POSPrinterPanel.this.station = 2;
            }
            if (e.getActionCommand().equals("journal")) {
                POSPrinterPanel.this.station = 1;
            }
            if (e.getActionCommand().equals("slip")) {
                POSPrinterPanel.this.station = 4;
            }
        }
    }

    class BarcodePanel
    extends Component {
        private static final long serialVersionUID = 5645979411019493408L;

        BarcodePanel() {
        }

        public Component make() {
            JPanel mainBox = new JPanel();
            mainBox.setLayout(new BoxLayout(mainBox, 0));
            JPanel labelBox = new JPanel();
            labelBox.setLayout(new BoxLayout(labelBox, 1));
            JLabel label = new JLabel("Height: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(110, 20));
            label.setPreferredSize(new Dimension(110, 20));
            labelBox.add(label);
            label = new JLabel("Width: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(110, 20));
            label.setPreferredSize(new Dimension(110, 20));
            labelBox.add(label);
            label = new JLabel("Symbology: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(110, 20));
            label.setPreferredSize(new Dimension(110, 20));
            labelBox.add(label);
            label = new JLabel("Alignment: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(110, 20));
            label.setPreferredSize(new Dimension(110, 20));
            labelBox.add(label);
            label = new JLabel("Text Position: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(110, 20));
            label.setPreferredSize(new Dimension(110, 20));
            labelBox.add(label);
            label = new JLabel("Barcode Data: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(110, 20));
            label.setPreferredSize(new Dimension(110, 20));
            labelBox.add(label);
            JPanel valuesBox = new JPanel();
            valuesBox.setLayout(new BoxLayout(valuesBox, 1));
            POSPrinterPanel.this.barCodeHeight = new JTextField(5);
            POSPrinterPanel.this.barCodeHeight.setAlignmentX(0.0f);
            POSPrinterPanel.this.barCodeHeight.setMaximumSize(new Dimension(80, 20));
            POSPrinterPanel.this.barCodeHeight.setPreferredSize(new Dimension(80, 20));
            POSPrinterPanel.this.barCodeWidth = new JTextField(5);
            POSPrinterPanel.this.barCodeWidth.setAlignmentX(0.0f);
            POSPrinterPanel.this.barCodeWidth.setMaximumSize(new Dimension(80, 20));
            POSPrinterPanel.this.barCodeWidth.setPreferredSize(new Dimension(80, 20));
            POSPrinterPanel.this.barCodeAlignmentCombo = new JComboBox<StrVal>(POSPrinterPanel.this.bcAlignments);
            POSPrinterPanel.this.barCodeAlignmentCombo.setAlignmentX(0.0f);
            POSPrinterPanel.this.barCodeAlignmentCombo.setMaximumSize(new Dimension(110, 20));
            POSPrinterPanel.this.barCodeAlignmentCombo.setPreferredSize(new Dimension(110, 20));
            POSPrinterPanel.this.barCodeAlignmentCombo.setEditable(true);
            POSPrinterPanel.this.barCodeTextCombo = new JComboBox<StrVal>(POSPrinterPanel.this.bcTextPos);
            POSPrinterPanel.this.barCodeTextCombo.setAlignmentX(0.0f);
            POSPrinterPanel.this.barCodeTextCombo.setMaximumSize(new Dimension(110, 20));
            POSPrinterPanel.this.barCodeTextCombo.setPreferredSize(new Dimension(110, 20));
            POSPrinterPanel.this.symbologyCombo = new JComboBox<StrVal>(POSPrinterPanel.this.bcSymbologies);
            POSPrinterPanel.this.symbologyCombo.setAlignmentX(0.0f);
            POSPrinterPanel.this.symbologyCombo.setMaximumSize(new Dimension(110, 20));
            POSPrinterPanel.this.symbologyCombo.setPreferredSize(new Dimension(110, 20));
            POSPrinterPanel.this.barCodeData = new JTextField();
            POSPrinterPanel.this.barCodeData.setAlignmentX(0.0f);
            POSPrinterPanel.this.barCodeData.setMaximumSize(new Dimension(150, 20));
            POSPrinterPanel.this.barCodeData.setPreferredSize(new Dimension(150, 20));
            valuesBox.add(POSPrinterPanel.this.barCodeHeight);
            valuesBox.add(POSPrinterPanel.this.barCodeWidth);
            valuesBox.add(POSPrinterPanel.this.symbologyCombo);
            valuesBox.add(POSPrinterPanel.this.barCodeAlignmentCombo);
            valuesBox.add(POSPrinterPanel.this.barCodeTextCombo);
            valuesBox.add(POSPrinterPanel.this.barCodeData);
            JPanel buttonsBox = new JPanel();
            buttonsBox.setLayout(new BoxLayout(buttonsBox, 1));
            POSPrinterPanel.this.printBarCodeButton = new JButton("Print Bar Code");
            POSPrinterPanel.this.printBarCodeButton.setActionCommand("printBarCode");
            POSPrinterPanel.this.printBarCodeButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonsBox.add(POSPrinterPanel.this.printBarCodeButton);
            POSPrinterPanel.this.rotateBarcodeButton = new JButton("Start Barcode Rotation");
            POSPrinterPanel.this.rotateBarcodeButton.setActionCommand("rotateBarcode");
            POSPrinterPanel.this.rotateBarcodeButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonsBox.add(POSPrinterPanel.this.rotateBarcodeButton);
            mainBox.add(Box.createHorizontalStrut(10));
            mainBox.add(labelBox);
            mainBox.add(valuesBox);
            mainBox.add(Box.createHorizontalStrut(30));
            mainBox.add(buttonsBox);
            return mainBox;
        }
    }

    class GeneralPrintingPanel
    extends Component {
        private static final long serialVersionUID = 1884297964571344712L;

        GeneralPrintingPanel() {
        }

        public Component make() {
            JPanel mainBox = new JPanel();
            mainBox.setLayout(new BoxLayout(mainBox, 0));
            JPanel insertionButtonPanel = new JPanel();
            insertionButtonPanel.setLayout(new BoxLayout(insertionButtonPanel, 1));
            POSPrinterPanel.this.beginInsertionButton = new JButton("Begin Insertion");
            POSPrinterPanel.this.beginInsertionButton.setActionCommand("beginInsertion");
            POSPrinterPanel.this.beginInsertionButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.endInsertionButton = new JButton("End Insertion");
            POSPrinterPanel.this.endInsertionButton.setActionCommand("endInsertion");
            POSPrinterPanel.this.endInsertionButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.beginRemovalButton = new JButton("Begin Removal");
            POSPrinterPanel.this.beginRemovalButton.setActionCommand("beginRemoval");
            POSPrinterPanel.this.beginRemovalButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.endRemovalButton = new JButton("End Removal");
            POSPrinterPanel.this.endRemovalButton.setActionCommand("endRemoval");
            POSPrinterPanel.this.endRemovalButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.addESCButton = new JButton("Add Escape Seq.");
            POSPrinterPanel.this.addESCButton.setActionCommand("addESC");
            POSPrinterPanel.this.addESCButton.addActionListener(POSPrinterPanel.this.methodListener);
            insertionButtonPanel.add(POSPrinterPanel.this.beginInsertionButton);
            insertionButtonPanel.add(POSPrinterPanel.this.endInsertionButton);
            insertionButtonPanel.add(POSPrinterPanel.this.beginRemovalButton);
            insertionButtonPanel.add(POSPrinterPanel.this.endRemovalButton);
            insertionButtonPanel.add(Box.createVerticalStrut(10));
            insertionButtonPanel.add(POSPrinterPanel.this.addESCButton);
            JPanel buttonRow1Panel = new JPanel();
            buttonRow1Panel.setLayout(new BoxLayout(buttonRow1Panel, 1));
            POSPrinterPanel.this.topLogoButton = new JButton("Set Top Logo");
            POSPrinterPanel.this.topLogoButton.setActionCommand("topLogo");
            POSPrinterPanel.this.topLogoButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.bottomLogoButton = new JButton("Set Bottom Logo");
            POSPrinterPanel.this.bottomLogoButton.setActionCommand("bottomLogo");
            POSPrinterPanel.this.bottomLogoButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.cutPaperButton = new JButton("Cut Paper");
            POSPrinterPanel.this.cutPaperButton.setActionCommand("cutPaper");
            POSPrinterPanel.this.cutPaperButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonRow1Panel.add(POSPrinterPanel.this.topLogoButton);
            buttonRow1Panel.add(POSPrinterPanel.this.bottomLogoButton);
            buttonRow1Panel.add(POSPrinterPanel.this.cutPaperButton);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            POSPrinterPanel.this.printNormalButton = new JButton("Print Normal");
            POSPrinterPanel.this.printNormalButton.setActionCommand("printNormal");
            POSPrinterPanel.this.printNormalButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonPanel.add(POSPrinterPanel.this.printNormalButton);
            POSPrinterPanel.this.printImmediateButton = new JButton("Print Immediate");
            POSPrinterPanel.this.printImmediateButton.setActionCommand("printImmediate");
            POSPrinterPanel.this.printImmediateButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonPanel.add(POSPrinterPanel.this.printImmediateButton);
            POSPrinterPanel.this.validateDataButton = new JButton("Validate Data");
            POSPrinterPanel.this.validateDataButton.setActionCommand("validateData");
            POSPrinterPanel.this.validateDataButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonPanel.add(POSPrinterPanel.this.validateDataButton);
            POSPrinterPanel.this.letterQualityButton = new JButton("Letter Quality");
            POSPrinterPanel.this.letterQualityButton.setActionCommand("letterQuality");
            POSPrinterPanel.this.letterQualityButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonPanel.add(POSPrinterPanel.this.letterQualityButton);
            JPanel printerOutputPanel = new JPanel();
            printerOutputPanel.setLayout(new BoxLayout(printerOutputPanel, 1));
            JLabel label = new JLabel("Send to printer: ");
            label.setAlignmentX(0.5f);
            printerOutputPanel.add(label);
            POSPrinterPanel.this.posPrinterOutputArea = new JTextArea(10, 10);
            JScrollPane scrollPane = new JScrollPane(POSPrinterPanel.this.posPrinterOutputArea);
            printerOutputPanel.add(scrollPane);
            mainBox.add(printerOutputPanel);
            mainBox.add(Box.createHorizontalStrut(5));
            mainBox.add(insertionButtonPanel);
            mainBox.add(Box.createHorizontalStrut(5));
            mainBox.add(buttonRow1Panel);
            mainBox.add(Box.createHorizontalStrut(5));
            mainBox.add(buttonPanel);
            return mainBox;
        }
    }

    class BitmapPanel
    extends Component {
        private static final long serialVersionUID = -8849851459571094770L;

        BitmapPanel() {
        }

        public Component make() {
            JPanel mainBox = new JPanel();
            mainBox.setLayout(new BoxLayout(mainBox, 0));
            JPanel browserPanel = new JPanel();
            browserPanel.setLayout(new BoxLayout(browserPanel, 1));
            JPanel browserValuePanel = new JPanel();
            browserValuePanel.setLayout(new BoxLayout(browserValuePanel, 0));
            JPanel argumentPanel = new JPanel();
            argumentPanel.setLayout(new BoxLayout(argumentPanel, 1));
            JLabel label = new JLabel("Image to Print:");
            label.setAlignmentX(0.5f);
            browserPanel.add(label);
            browserPanel.add(Box.createRigidArea(new Dimension(0, 0)));
            POSPrinterPanel.this.bitmapFileName = new JTextField();
            POSPrinterPanel.this.bitmapFileName.setAlignmentX(0.0f);
            POSPrinterPanel.this.bitmapFileName.setMaximumSize(new Dimension(180, 20));
            POSPrinterPanel.this.bitmapFileName.setPreferredSize(new Dimension(180, 20));
            POSPrinterPanel.this.bitmapBrowse = new JButton("Browse");
            POSPrinterPanel.this.bitmapFileChooser = new JFileChooser();
            ImageFilter filter = new ImageFilter();
            POSPrinterPanel.this.bitmapBrowse.setActionCommand("bitmapBrowse");
            POSPrinterPanel.this.bitmapBrowse.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.bitmapFileChooser.addChoosableFileFilter(filter);
            browserValuePanel.add(POSPrinterPanel.this.bitmapFileName);
            browserValuePanel.add(POSPrinterPanel.this.bitmapBrowse);
            browserPanel.add(browserValuePanel);
            label = new JLabel("Bitmap Width");
            label.setAlignmentX(0.5f);
            argumentPanel.add(label);
            POSPrinterPanel.this.bitmapWidth = new JComboBox<StrVal>(POSPrinterPanel.this.bitmapWidths);
            POSPrinterPanel.this.bitmapWidth.setMaximumSize(new Dimension(180, 20));
            POSPrinterPanel.this.bitmapWidth.setPreferredSize(new Dimension(180, 20));
            argumentPanel.add(POSPrinterPanel.this.bitmapWidth);
            label = new JLabel("Bitmap Alignment");
            label.setAlignmentX(0.5f);
            argumentPanel.add(label);
            POSPrinterPanel.this.bitmapAlign = new JComboBox<StrVal>(POSPrinterPanel.this.bitmapAlignments);
            POSPrinterPanel.this.bitmapAlign.setMaximumSize(new Dimension(180, 20));
            POSPrinterPanel.this.bitmapAlign.setPreferredSize(new Dimension(180, 20));
            argumentPanel.add(POSPrinterPanel.this.bitmapAlign);
            label = new JLabel("Bitmap Number (setBitmap)");
            label.setAlignmentX(0.5f);
            argumentPanel.add(label);
            String[] values = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            POSPrinterPanel.this.bitmapNumberCombo = new JComboBox<String>(values);
            POSPrinterPanel.this.bitmapNumberCombo.setMaximumSize(new Dimension(180, 20));
            POSPrinterPanel.this.bitmapNumberCombo.setPreferredSize(new Dimension(180, 20));
            argumentPanel.add(POSPrinterPanel.this.bitmapNumberCombo);
            POSPrinterPanel.this.bitmapNumberCombo.setEditable(true);
            POSPrinterPanel.this.bitmapWidth.setEditable(true);
            POSPrinterPanel.this.bitmapAlign.setEditable(true);
            JPanel buttonsBox = new JPanel();
            buttonsBox.setLayout(new BoxLayout(buttonsBox, 1));
            POSPrinterPanel.this.setBitmapButton = new JButton("Set Bitmap");
            POSPrinterPanel.this.setBitmapButton.setActionCommand("setBitmap");
            POSPrinterPanel.this.setBitmapButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.printBitmapButton = new JButton("Print Bitmap");
            POSPrinterPanel.this.printBitmapButton.setActionCommand("printBitmap");
            POSPrinterPanel.this.printBitmapButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.rotateBitmapButton = new JButton("Start Bitmap Rotation");
            POSPrinterPanel.this.rotateBitmapButton.setActionCommand("rotateBitmap");
            POSPrinterPanel.this.rotateBitmapButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonsBox.add(POSPrinterPanel.this.printBitmapButton);
            buttonsBox.add(POSPrinterPanel.this.setBitmapButton);
            buttonsBox.add(POSPrinterPanel.this.rotateBitmapButton);
            mainBox.add(Box.createHorizontalStrut(10));
            mainBox.add(browserPanel);
            mainBox.add(Box.createHorizontalGlue());
            mainBox.add(argumentPanel);
            mainBox.add(Box.createHorizontalStrut(10));
            mainBox.add(buttonsBox);
            mainBox.add(Box.createHorizontalStrut(10));
            return mainBox;
        }

        private class ImageFilter
        extends FileFilter {
            ImageFilter() {
            }

            private String getExtension(File file) {
                String ext = null;
                String s = file.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equals("tiff") || extension.equals("tif") || extension.equals("gif") || extension.equals("jpeg") || extension.equals("jpg") || extension.equals("png") || extension.equals("bmp");
                }
                return false;
            }

            public String getDescription() {
                return "Images";
            }
        }
    }

    class PageModePanel
    extends Component {
        private static final long serialVersionUID = -1932749969082747610L;

        PageModePanel() {
        }

        public Component make() {
            JPanel mainBox = new JPanel();
            mainBox.setLayout(new BoxLayout(mainBox, 1));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            JPanel labelBox = new JPanel();
            labelBox.setLayout(new BoxLayout(labelBox, 1));
            JPanel controlBox = new JPanel();
            controlBox.setLayout(new BoxLayout(controlBox, 0));
            JLabel label = new JLabel("Page Mode Area: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            label = new JLabel("Page Mode Descriptor: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            label = new JLabel("Page Mode Horizonal Position: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            label = new JLabel("Page Mode Vertical Position: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            label = new JLabel("Page Mode Print Area: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            label = new JLabel("Page Mode Print Direction: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            label = new JLabel("Page Mode Station: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(180, 20));
            label.setPreferredSize(new Dimension(180, 20));
            labelBox.add(label);
            JPanel valuesBox = new JPanel();
            valuesBox.setLayout(new BoxLayout(valuesBox, 1));
            POSPrinterPanel.this.pageModeArea = new JLabel();
            POSPrinterPanel.this.pageModeArea.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeArea.setMaximumSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModeArea.setPreferredSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModeDescriptor = new JLabel();
            POSPrinterPanel.this.pageModeDescriptor.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeDescriptor.setMaximumSize(new Dimension(500, 20));
            POSPrinterPanel.this.pageModeDescriptor.setPreferredSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModeHorizontalPos = new JTextField();
            POSPrinterPanel.this.pageModeHorizontalPos.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeHorizontalPos.setMaximumSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModeHorizontalPos.setPreferredSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModeVerticalPos = new JTextField();
            POSPrinterPanel.this.pageModeVerticalPos.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeVerticalPos.setMaximumSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModeVerticalPos.setPreferredSize(new Dimension(80, 20));
            POSPrinterPanel.this.pageModePrintArea = new JTextField();
            POSPrinterPanel.this.pageModePrintArea.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModePrintArea.setMaximumSize(new Dimension(150, 20));
            POSPrinterPanel.this.pageModePrintArea.setPreferredSize(new Dimension(150, 20));
            POSPrinterPanel.this.pageModeDirectionCombo = new JComboBox<StrVal>(POSPrinterPanel.this.pmDirections);
            POSPrinterPanel.this.pageModeDirectionCombo.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeDirectionCombo.setMaximumSize(new Dimension(110, 20));
            POSPrinterPanel.this.pageModeDirectionCombo.setPreferredSize(new Dimension(110, 20));
            POSPrinterPanel.this.pageModeDirectionCombo.setEditable(false);
            POSPrinterPanel.this.pageModeStationCombo = new JComboBox<StrVal>(POSPrinterPanel.this.pmStations);
            POSPrinterPanel.this.pageModeStationCombo.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeStationCombo.setMaximumSize(new Dimension(110, 20));
            POSPrinterPanel.this.pageModeStationCombo.setPreferredSize(new Dimension(110, 20));
            POSPrinterPanel.this.pageModeStationCombo.setEditable(false);
            POSPrinterPanel.this.pageModeStationCombo.setActionCommand("pageModeStationCombo");
            POSPrinterPanel.this.pageModeStationCombo.addActionListener(POSPrinterPanel.this.methodListener);
            valuesBox.add(POSPrinterPanel.this.pageModeArea);
            valuesBox.add(POSPrinterPanel.this.pageModeDescriptor);
            valuesBox.add(POSPrinterPanel.this.pageModeHorizontalPos);
            valuesBox.add(POSPrinterPanel.this.pageModeVerticalPos);
            valuesBox.add(POSPrinterPanel.this.pageModePrintArea);
            valuesBox.add(POSPrinterPanel.this.pageModeDirectionCombo);
            valuesBox.add(POSPrinterPanel.this.pageModeStationCombo);
            JPanel buttonsBox = new JPanel();
            buttonsBox.setLayout(new BoxLayout(buttonsBox, 1));
            POSPrinterPanel.this.clearPrintAreadButton = new JButton("Clear Print Area");
            POSPrinterPanel.this.clearPrintAreadButton.setActionCommand("clearPrintArea");
            POSPrinterPanel.this.clearPrintAreadButton.addActionListener(POSPrinterPanel.this.methodListener);
            POSPrinterPanel.this.pageModeUpdatePropButton = new JButton("Update Properties");
            POSPrinterPanel.this.pageModeUpdatePropButton.setActionCommand("pageModeUpdateProp");
            POSPrinterPanel.this.pageModeUpdatePropButton.addActionListener(POSPrinterPanel.this.methodListener);
            buttonsBox.add(POSPrinterPanel.this.clearPrintAreadButton);
            buttonsBox.add(POSPrinterPanel.this.pageModeUpdatePropButton);
            POSPrinterPanel.this.pageModeControlCombo = new JComboBox<StrVal>(POSPrinterPanel.this.pmpCommands);
            POSPrinterPanel.this.pageModeControlCombo.setAlignmentX(0.0f);
            POSPrinterPanel.this.pageModeControlCombo.setMaximumSize(new Dimension(200, 20));
            POSPrinterPanel.this.pageModeControlCombo.setPreferredSize(new Dimension(200, 20));
            POSPrinterPanel.this.pageModeControlCombo.setEditable(true);
            label = new JLabel("Page Mode Command: ");
            label.setAlignmentX(1.0f);
            label.setMaximumSize(new Dimension(150, 20));
            label.setPreferredSize(new Dimension(150, 20));
            POSPrinterPanel.this.pageModePrintButton = new JButton("Send Page Mode Command");
            POSPrinterPanel.this.pageModePrintButton.setActionCommand("pageModePrint");
            POSPrinterPanel.this.pageModePrintButton.addActionListener(POSPrinterPanel.this.methodListener);
            controlBox.add(Box.createHorizontalStrut(10));
            controlBox.add(label);
            controlBox.add(POSPrinterPanel.this.pageModeControlCombo);
            controlBox.add(Box.createHorizontalStrut(10));
            controlBox.add(POSPrinterPanel.this.pageModePrintButton);
            controlBox.add(Box.createHorizontalStrut(10));
            controlBox.setBorder(LineBorder.createBlackLineBorder());
            JPanel Row1 = new JPanel();
            Row1.setLayout(new BoxLayout(Row1, 0));
            Row1.add(Box.createHorizontalStrut(10));
            Row1.add(labelBox);
            Row1.add(valuesBox);
            Row1.add(Box.createHorizontalStrut(30));
            Row1.add(buttonsBox);
            Row1.add(Box.createHorizontalStrut(10));
            mainBox.add(Row1);
            mainBox.add(controlBox);
            return mainBox;
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (POSPrinterPanel.this.posPrinter != null) {
                POSPrinterPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(POSPrinterPanel.this.posPrinter.getState()));
            }
        }
    }
}

