/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpos.JposException;
import jpos.PointCardRW;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class PointCardRWPanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -947486026292872625L;
    protected MainButtonPanel mainButtonPanel;
    private PointCardRW pointCardRW = new PointCardRW();
    private String defaultLogicalName = "defaultPointCardRW";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private Timer updateStatusTimer = new Timer(true);
    StatusTimerUpdateTask updateStatusTask = new StatusTimerUpdateTask();

    public PointCardRWPanel() {
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        JLabel label = new JLabel("Not yet implemented.");
        label.setAlignmentX(0.5f);
        statusPanel.add(label);
        statusPanel.add(Box.createHorizontalGlue());
        subPanel.add(statusPanel);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("PointCardRW received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.pointCardRW.addStatusUpdateListener((StatusUpdateListener)this);
                this.pointCardRW.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.pointCardRW.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.pointCardRW.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.pointCardRW.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.pointCardRW.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.pointCardRW.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.pointCardRW.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.pointCardRW.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.pointCardRW.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.pointCardRW.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.pointCardRW.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.pointCardRW.getCapPowerReporting() == 2 ? "Advanced" : (this.pointCardRW.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.pointCardRW.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.pointCardRW.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.pointCardRW.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.pointCardRW.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapBold: " + this.pointCardRW.getCapBold();
                msg = String.valueOf(msg) + "\nCapCardEntranceSensor: " + this.pointCardRW.getCapCardEntranceSensor();
                msg = String.valueOf(msg) + "\nCapCharacterSet: ";
                int charset = this.pointCardRW.getCapCharacterSet();
                switch (charset) {
                    case 1: {
                        msg = String.valueOf(msg) + "PCRW_CCS_ALPHA";
                        break;
                    }
                    case 998: {
                        msg = String.valueOf(msg) + "PCRW_CCS_ASCII";
                        break;
                    }
                    case 10: {
                        msg = String.valueOf(msg) + "PCRW_CCS_KANA";
                        break;
                    }
                    case 11: {
                        msg = String.valueOf(msg) + "PCRW_CCS_KANJI";
                        break;
                    }
                    case 997: {
                        msg = String.valueOf(msg) + "PCRW_CCS_UNICODE";
                    }
                }
                msg = String.valueOf(msg) + "\nCapCleanCard: " + this.pointCardRW.getCapCleanCard();
                msg = String.valueOf(msg) + "\nCapClearPrint: " + this.pointCardRW.getCapClearPrint();
                msg = String.valueOf(msg) + "\nCapDhigh: " + this.pointCardRW.getCapDhigh();
                msg = String.valueOf(msg) + "\nCapDwide: " + this.pointCardRW.getCapDwide();
                msg = String.valueOf(msg) + "\nCapDwideDhigh: " + this.pointCardRW.getCapDwideDhigh();
                msg = String.valueOf(msg) + "\nCapItalic: " + this.pointCardRW.getCapItalic();
                msg = String.valueOf(msg) + "\nCapLeft90: " + this.pointCardRW.getCapLeft90();
                msg = String.valueOf(msg) + "\nCapMapCharacterSet: " + this.pointCardRW.getCapMapCharacterSet();
                msg = String.valueOf(msg) + "\nCapPrint: " + this.pointCardRW.getCapPrint();
                msg = String.valueOf(msg) + "\nCapPrintMode: " + this.pointCardRW.getCapPrintMode();
                msg = String.valueOf(msg) + "\nCapRight90: " + this.pointCardRW.getCapRight90();
                msg = String.valueOf(msg) + "\nCapRotate180: " + this.pointCardRW.getCapRotate180();
                msg = String.valueOf(msg) + "\nCapTracksToRead: ";
                int tracks = this.pointCardRW.getCapTracksToRead();
                if ((tracks & 1) > 0) {
                    msg = String.valueOf(msg) + "Track1 | ";
                }
                if ((tracks & 2) > 0) {
                    msg = String.valueOf(msg) + "Track2 | ";
                }
                if ((tracks & 4) > 0) {
                    msg = String.valueOf(msg) + "Track3 | ";
                }
                if ((tracks & 8) > 0) {
                    msg = String.valueOf(msg) + "Track4 | ";
                }
                if ((tracks & 0x10) > 0) {
                    msg = String.valueOf(msg) + "Track5 | ";
                }
                if ((tracks & 0x20) > 0) {
                    msg = String.valueOf(msg) + "Track6";
                }
                msg = String.valueOf(msg) + "\nCapTracksToWrite: ";
                tracks = this.pointCardRW.getCapTracksToWrite();
                if ((tracks & 1) > 0) {
                    msg = String.valueOf(msg) + "Track1 | ";
                }
                if ((tracks & 2) > 0) {
                    msg = String.valueOf(msg) + "Track2 | ";
                }
                if ((tracks & 4) > 0) {
                    msg = String.valueOf(msg) + "Track3 | ";
                }
                if ((tracks & 8) > 0) {
                    msg = String.valueOf(msg) + "Track4 | ";
                }
                if ((tracks & 0x10) > 0) {
                    msg = String.valueOf(msg) + "Track5 | ";
                }
                if ((tracks & 0x20) > 0) {
                    msg = String.valueOf(msg) + "Track6";
                }
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.pointCardRW);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.pointCardRW);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        }
        try {
            this.deviceEnabledCB.setSelected(this.pointCardRW.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.pointCardRW.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("PointCardRWPanel: MethodListener: JposException");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == PointCardRWPanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        PointCardRWPanel.this.pointCardRW.setDeviceEnabled(false);
                    } else {
                        PointCardRWPanel.this.pointCardRW.setDeviceEnabled(true);
                    }
                } else if (source == PointCardRWPanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        PointCardRWPanel.this.pointCardRW.setFreezeEvents(false);
                    } else {
                        PointCardRWPanel.this.pointCardRW.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("PointCardRWPanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (PointCardRWPanel.this.pointCardRW != null) {
                PointCardRWPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(PointCardRWPanel.this.pointCardRW.getState()));
            }
        }
    }
}

