/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jpos.JposException;
import jpos.Scale;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class ScalePanel
extends Component
implements StatusUpdateListener,
ActionListener {
    private static final long serialVersionUID = -4174319101156849494L;
    protected MainButtonPanel mainButtonPanel;
    private Scale scale;
    private String defaultLogicalName = "defaultScale";
    private String logicalName = "";
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    boolean scaleOpened = false;
    private JButton scaleReadWeightButton = new JButton("Read Weight");
    private JTextField scaleCurrWeight = new JTextField(10);
    private JCheckBox scaleCap = new JCheckBox("Cap Display");
    private JLabel weightUnitsb = new JLabel("Weight Units");
    private JTextField weightUnits = new JTextField(12);
    private JLabel maxWeightb = new JLabel("Maximum Weight");
    private JTextField maxWeight = new JTextField(10);
    private JButton scaleDisplayTextButton = new JButton("Display Text");
    private JButton scaleZeroScaleButton = new JButton("Zero Scale");
    private JButton clearInputButton;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;

    public ScalePanel() {
        this.scale = new Scale();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        mainPanel.add(buttonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        propPanel.add(this.freezeEventsCB);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.deviceEnabledCB.setEnabled(false);
        this.freezeEventsCB.setEnabled(false);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new FlowLayout());
        JPanel scalemethods = new JPanel();
        scalemethods.setLayout(new GridLayout(3, 2, 3, 4));
        scalemethods.setBorder(new TitledBorder("Method"));
        scalemethods.add(this.scaleReadWeightButton);
        this.scaleReadWeightButton.setToolTipText("Read Weight on Scale");
        scalemethods.add(this.scaleCurrWeight);
        this.scaleCurrWeight.setToolTipText("Displays Weight in lbs");
        scalemethods.add(this.scaleDisplayTextButton);
        this.scaleDisplayTextButton.setToolTipText("Display String of Data");
        scalemethods.add(this.scaleZeroScaleButton);
        this.scaleZeroScaleButton.setToolTipText("Zero Out Scale");
        scalePanel.add(scalemethods);
        JPanel scaleprops = new JPanel();
        scaleprops.setLayout(new GridLayout(3, 2, 3, 4));
        scaleprops.setBorder(new TitledBorder("Read-Only Properties"));
        scalePanel.add(scaleprops);
        scaleprops.add(this.scaleCap);
        scaleprops.add(new JLabel(" "));
        scaleprops.add(this.maxWeightb);
        scaleprops.add(this.maxWeight);
        scaleprops.add(this.weightUnitsb);
        scaleprops.add(this.weightUnits);
        JScrollPane scaleScroll = new JScrollPane();
        scaleScroll.setViewportView(scalePanel);
        this.scaleReadWeightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int[] weight = new int[1];
                    ScalePanel.this.scale.readWeight(weight, 3000);
                    ScalePanel.this.scaleCurrWeight.setText(String.valueOf(weight[0]));
                    System.out.println("Read Weight Button pressed!\n");
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ScalePanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            }
        });
        this.scaleDisplayTextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    String text = "";
                    ScalePanel.this.scale.displayText(text);
                    System.out.println("Display Text Button pressed!\n");
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ScalePanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            }
        });
        this.scaleZeroScaleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ScalePanel.this.scale.zeroScale();
                    System.out.println("Zero Scale Button pressed!\n");
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Failed to open \"" + ScalePanel.this.logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                    System.err.println("Jpos exception " + (Object)((Object)e));
                }
            }
        });
        subPanel.add(scalePanel);
        return mainPanel;
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        System.out.println("Scale received status update event.");
    }

    public void actionPerformed(ActionEvent ae) {
        this.mainButtonPanel.action(ae);
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.scale.addStatusUpdateListener((StatusUpdateListener)this);
                this.scale.open(logicalName);
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
                int version = this.scale.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.scale.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.scale.release();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.scale.close();
                this.deviceEnabledCB.setEnabled(false);
                this.freezeEventsCB.setEnabled(false);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.scale.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.scale.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.scale.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.scale.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.scale.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.scale.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.scale.getCapPowerReporting() == 2 ? "Advanced" : (this.scale.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.scale.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.scale.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.scale.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.scale.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                msg = String.valueOf(msg) + "\nCapDisplay: " + this.scale.getCapDisplay();
                msg = String.valueOf(msg) + "\nCapDisplayText: " + this.scale.getCapDisplayText();
                msg = String.valueOf(msg) + "\nCapPriceCalculating: " + this.scale.getCapPriceCalculating();
                msg = String.valueOf(msg) + "\nCapTareWeight: " + this.scale.getCapTareWeight();
                msg = String.valueOf(msg) + "\nCapZeroScale: " + this.scale.getCapZeroScale();
                msg = this.ver_19_complient ? String.valueOf(msg) + "\nCapStatusUpdate: " + this.scale.getCapStatusUpdate() : String.valueOf(msg) + "\nCapStatusUpdate: Service Object is not 1.9 complient";
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.scale.addStatusUpdateListener((StatusUpdateListener)this);
                this.scale.open(logicalName);
                this.scale.claim(0);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.scale.setDeviceEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.scale);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.scale);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.scale.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        try {
            this.deviceEnabledCB.setSelected(this.scale.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.scale.getFreezeEvents());
        }
        catch (JposException je) {
            System.err.println("ScalePanel: MethodListener: JposException");
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            try {
                if (source == ScalePanel.this.deviceEnabledCB) {
                    if (e.getStateChange() == 2) {
                        ScalePanel.this.scale.setDeviceEnabled(false);
                    } else {
                        ScalePanel.this.scale.setDeviceEnabled(true);
                    }
                } else if (source == ScalePanel.this.freezeEventsCB) {
                    if (e.getStateChange() == 2) {
                        ScalePanel.this.scale.setFreezeEvents(false);
                    } else {
                        ScalePanel.this.scale.setFreezeEvents(true);
                    }
                }
            }
            catch (JposException je) {
                System.err.println("ScalePanel: CheckBoxListener: Jpos Exception" + e);
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (ScalePanel.this.scale != null) {
                ScalePanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(ScalePanel.this.scale.getState()));
            }
        }
    }
}

