/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import com.jpos.POStest.FirmwareUpdateDlg;
import com.jpos.POStest.MainButtonPanel;
import com.jpos.POStest.StatisticsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpos.JposException;
import jpos.Scanner;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;

public class ScannerPanel
extends Component
implements DataListener,
ErrorListener,
ActionListener {
    private static final long serialVersionUID = -18803538624903477L;
    protected MainButtonPanel mainButtonPanel;
    private Scanner scanner = null;
    private String defaultLogicalName = "defaultScanner";
    byte[] scanData = new byte[0];
    byte[] scanDataLabel = new byte[0];
    int scanDataType = -1;
    boolean autoDisable;
    boolean dataEventEnabled;
    boolean deviceEnabled;
    boolean freezeEvents;
    boolean decodeData;
    boolean updateDevice = true;
    private boolean ver_19_complient = false;
    private boolean ver_18_complient = false;
    private JTextField scanDataTypeTextField;
    private JTextArea scanDataTextArea;
    private JScrollPane scanDataTextAreaScrollPane;
    private JTextArea scanDataLabelTextArea;
    private JScrollPane scanDataLabelScrollPane;
    private JCheckBox autoDisableCB;
    private JCheckBox dataEventEnabledCB;
    private JCheckBox deviceEnabledCB;
    private JCheckBox freezeEventsCB;
    private JCheckBox decodeDataCB;
    private JButton clearFieldsButton;
    private JButton refreshFieldsButton;
    private JLabel dataCountLabel;
    private Timer updateDatacountTimer;
    DataCountTimerUpdateTask updateDataCountTask;
    private JButton clearInputButton;
    private JButton clearInputPropertiesButton;
    Runnable doUpdateGUI;
    private Timer updateStatusTimer;
    StatusTimerUpdateTask updateStatusTask;

    public ScannerPanel() {
        this.scanner = new Scanner();
        this.updateStatusTimer = new Timer(true);
        this.updateStatusTask = new StatusTimerUpdateTask();
        this.updateStatusTimer.schedule((TimerTask)this.updateStatusTask, 200L, 200L);
    }

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.mainButtonPanel = new MainButtonPanel(this, this.defaultLogicalName);
        mainPanel.add(this.mainButtonPanel);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new BoxLayout(propPanel, 1));
        this.autoDisableCB = new JCheckBox("Auto disable");
        Font f = this.autoDisableCB.getFont();
        Font newf = new Font(f.getName(), 0, f.getSize());
        this.autoDisableCB.setFont(newf);
        propPanel.add(this.autoDisableCB);
        this.dataEventEnabledCB = new JCheckBox("Data event enabled");
        this.dataEventEnabledCB.setFont(newf);
        propPanel.add(this.dataEventEnabledCB);
        this.deviceEnabledCB = new JCheckBox("Device enabled");
        this.deviceEnabledCB.setFont(newf);
        propPanel.add(this.deviceEnabledCB);
        this.freezeEventsCB = new JCheckBox("Freeze events");
        this.freezeEventsCB.setFont(newf);
        propPanel.add(this.freezeEventsCB);
        this.decodeDataCB = new JCheckBox("Decode data");
        this.decodeDataCB.setFont(newf);
        propPanel.add(this.decodeDataCB);
        this.clearInputButton = new JButton("Clear Input");
        this.clearInputButton.setActionCommand("clearInput");
        this.clearInputButton.addActionListener(this);
        this.clearInputPropertiesButton = new JButton("Clear Input Properties");
        this.clearInputPropertiesButton.setActionCommand("clearInputProperties");
        this.clearInputPropertiesButton.addActionListener(this);
        propPanel.add(this.clearInputButton);
        propPanel.add(this.clearInputPropertiesButton);
        propPanel.add(Box.createVerticalGlue());
        subPanel.add(propPanel);
        this.autoDisableCB.setEnabled(true);
        this.dataEventEnabledCB.setEnabled(true);
        this.deviceEnabledCB.setEnabled(true);
        this.freezeEventsCB.setEnabled(true);
        this.decodeDataCB.setEnabled(true);
        CheckBoxListener cbListener = new CheckBoxListener();
        this.autoDisableCB.addItemListener(cbListener);
        this.dataEventEnabledCB.addItemListener(cbListener);
        this.deviceEnabledCB.addItemListener(cbListener);
        this.freezeEventsCB.addItemListener(cbListener);
        this.decodeDataCB.addItemListener(cbListener);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        JPanel scanDataPanel = new JPanel();
        scanDataPanel.setLayout(new BoxLayout(scanDataPanel, 0));
        JPanel scanDataTypePanel = new JPanel();
        scanDataTypePanel.setLayout(new BoxLayout(scanDataTypePanel, 0));
        JPanel scanDataLabelPanel = new JPanel();
        scanDataLabelPanel.setLayout(new BoxLayout(scanDataLabelPanel, 0));
        JPanel clearFieldsPanel = new JPanel();
        clearFieldsPanel.setLayout(new BoxLayout(clearFieldsPanel, 0));
        labelPanel.add(scanDataPanel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        labelPanel.add(scanDataTypePanel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        labelPanel.add(scanDataLabelPanel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        labelPanel.add(clearFieldsPanel);
        labelPanel.add(Box.createVerticalGlue());
        subPanel.add(labelPanel);
        JLabel label = new JLabel("Scan Data: ");
        label.setPreferredSize(new Dimension(130, 25));
        this.scanDataTextArea = new JTextArea(5, 5);
        this.scanDataTextArea.setLineWrap(false);
        this.scanDataTextArea.setWrapStyleWord(false);
        this.scanDataTextArea.setEditable(false);
        this.scanDataTextAreaScrollPane = new JScrollPane(this.scanDataTextArea);
        this.scanDataTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.scanDataTextAreaScrollPane.setHorizontalScrollBarPolicy(30);
        this.scanDataTextAreaScrollPane.setPreferredSize(new Dimension(300, 100));
        this.scanDataTextAreaScrollPane.setMaximumSize(new Dimension(300, 100));
        this.scanDataTextAreaScrollPane.setAlignmentX(0.0f);
        scanDataPanel.add(label);
        scanDataPanel.add(this.scanDataTextAreaScrollPane);
        scanDataPanel.add(Box.createHorizontalGlue());
        label = new JLabel("Scan Data Type: ");
        label.setPreferredSize(new Dimension(130, 25));
        this.scanDataTypeTextField = new JTextField(30);
        this.scanDataTypeTextField.setMaximumSize(new Dimension(60, 25));
        this.scanDataTypeTextField.setPreferredSize(new Dimension(60, 25));
        this.scanDataTypeTextField.setEditable(false);
        scanDataTypePanel.add(label);
        scanDataTypePanel.add(this.scanDataTypeTextField);
        scanDataTypePanel.add(Box.createHorizontalGlue());
        label = new JLabel("Scan Data Label: ");
        label.setPreferredSize(new Dimension(130, 25));
        this.scanDataLabelTextArea = new JTextArea(5, 5);
        this.scanDataLabelTextArea.setLineWrap(false);
        this.scanDataLabelTextArea.setWrapStyleWord(false);
        this.scanDataLabelTextArea.setEditable(false);
        this.scanDataLabelScrollPane = new JScrollPane(this.scanDataLabelTextArea);
        this.scanDataLabelScrollPane.setVerticalScrollBarPolicy(20);
        this.scanDataLabelScrollPane.setHorizontalScrollBarPolicy(30);
        this.scanDataLabelScrollPane.setPreferredSize(new Dimension(300, 100));
        this.scanDataLabelScrollPane.setMaximumSize(new Dimension(300, 100));
        scanDataLabelPanel.add(label);
        scanDataLabelPanel.add(this.scanDataLabelScrollPane);
        scanDataLabelPanel.add(Box.createHorizontalGlue());
        this.dataCountLabel = new JLabel("Data Count: ");
        this.dataCountLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        label.setPreferredSize(new Dimension(130, 25));
        this.clearFieldsButton = new JButton("Clear Fields");
        this.clearFieldsButton.setActionCommand("clearFields");
        this.clearFieldsButton.addActionListener(this);
        this.refreshFieldsButton = new JButton("Refresh Fields");
        this.refreshFieldsButton.setActionCommand("refreshFields");
        this.refreshFieldsButton.addActionListener(this);
        clearFieldsPanel.add(this.dataCountLabel);
        clearFieldsPanel.add(this.clearFieldsButton);
        clearFieldsPanel.add(this.refreshFieldsButton);
        clearFieldsPanel.add(Box.createHorizontalGlue());
        mainPanel.add(subPanel);
        mainPanel.add(Box.createVerticalGlue());
        this.doUpdateGUI = new Runnable(){

            public void run() {
                ScannerPanel.this.updateGUI();
            }
        };
        return mainPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        String logicalName = this.mainButtonPanel.getLogicalName();
        if (ae.getActionCommand().equals("open")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.scanner.open(logicalName);
                this.scanner.addErrorListener((ErrorListener)this);
                this.scanner.addDataListener((DataListener)this);
                int version = this.scanner.getDeviceServiceVersion();
                if (version >= 1009000) {
                    this.ver_19_complient = true;
                    this.ver_18_complient = true;
                }
                if (version >= 1008000) {
                    this.ver_18_complient = true;
                }
                this.updateDatacountTimer = new Timer(true);
                this.updateDataCountTask = new DataCountTimerUpdateTask();
                this.updateDatacountTimer.schedule((TimerTask)this.updateDataCountTask, 200L, 200L);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to open \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception on open " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("claim")) {
            try {
                this.scanner.claim(0);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception on claim " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("release")) {
            try {
                this.scanner.release();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to release \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception on release " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("close")) {
            try {
                this.scanner.close();
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to close \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception on close" + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("info")) {
            try {
                String ver = new Integer(this.scanner.getDeviceServiceVersion()).toString();
                String msg = "Service Description: " + this.scanner.getDeviceServiceDescription();
                msg = String.valueOf(msg) + "\nService Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                ver = new Integer(this.scanner.getDeviceControlVersion()).toString();
                msg = String.valueOf(msg) + "\n\nControl Description: " + this.scanner.getDeviceControlDescription();
                msg = String.valueOf(msg) + "\nControl Version: v" + new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(4, 7));
                msg = String.valueOf(msg) + "\n\nPhysical Device Name: " + this.scanner.getPhysicalDeviceName();
                msg = String.valueOf(msg) + "\nPhysical Device Description: " + this.scanner.getPhysicalDeviceDescription();
                msg = String.valueOf(msg) + "\n\nProperties:\n------------------------";
                msg = String.valueOf(msg) + "\nCapPowerReporting: " + (this.scanner.getCapPowerReporting() == 2 ? "Advanced" : (this.scanner.getCapPowerReporting() == 1 ? "Standard" : "None"));
                if (this.ver_18_complient) {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: " + this.scanner.getCapStatisticsReporting();
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: " + this.scanner.getCapUpdateStatistics();
                } else {
                    msg = String.valueOf(msg) + "\nCapStatisticsReporting: Service Object is not 1.8 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateStatistics: Service Object is not 1.8 complient";
                }
                if (this.ver_19_complient) {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: " + this.scanner.getCapCompareFirmwareVersion();
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: " + this.scanner.getCapUpdateFirmware();
                } else {
                    msg = String.valueOf(msg) + "\nCapCompareFirmwareVersion: Service Object is not 1.9 complient";
                    msg = String.valueOf(msg) + "\nCapUpdateFirmware: Service Object is not 1.9 complient";
                }
                JOptionPane.showMessageDialog(null, msg, "Info", 1);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Exception in Info\nException: " + e.getMessage(), "Exception", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("oce")) {
            try {
                if (logicalName.equals("")) {
                    logicalName = this.defaultLogicalName;
                }
                this.scanner.open(logicalName);
                this.scanner.addErrorListener((ErrorListener)this);
                this.scanner.addDataListener((DataListener)this);
                this.scanner.claim(1000);
                this.deviceEnabledCB.setEnabled(true);
                this.freezeEventsCB.setEnabled(true);
                this.scanner.setDeviceEnabled(true);
                this.scanner.setDataEventEnabled(true);
            }
            catch (JposException e) {
                JOptionPane.showMessageDialog(null, "Failed to claim \"" + logicalName + "\"\nException: " + e.getMessage(), "Failed", 0);
                System.err.println("Jpos exception " + (Object)((Object)e));
            }
        } else if (ae.getActionCommand().equals("stats")) {
            try {
                StatisticsDialog dlg = new StatisticsDialog(this.scanner);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("firmware")) {
            try {
                FirmwareUpdateDlg dlg = new FirmwareUpdateDlg(this.scanner);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
            }
        } else if (ae.getActionCommand().equals("exit")) {
            if (this.scanner.getState() != 1) {
                try {
                    this.scanner.close();
                }
                catch (JposException e) {
                    JOptionPane.showMessageDialog(null, "Exception: " + e.getMessage(), "Failed", 0);
                }
            }
        } else if (ae.getActionCommand().equals("clearFields")) {
            this.scanData = new byte[0];
            this.scanDataLabel = new byte[0];
            this.scanDataType = -1;
            this.scanDataTextArea.setText("");
            this.scanDataLabelTextArea.setText("");
            this.scanDataTypeTextField.setText("");
        } else if (ae.getActionCommand().equals("refreshFields")) {
            this.doDataUpdate();
        } else if (ae.getActionCommand().equals("clearInput")) {
            try {
                this.scanner.clearInput();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInput threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else if (ae.getActionCommand().equals("clearInputProperties")) {
            try {
                this.scanner.clearInputProperties();
            }
            catch (JposException je) {
                JOptionPane.showMessageDialog(null, "clearInputProperties threw a JposException: " + je.getMessage(), "Exception", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Action event recieved, someone forgot to implement something.", "Error", 0);
        }
        if (this.scanner.getState() != 1) {
            this.updateGUI();
        }
        this.mainButtonPanel.action(ae);
    }

    public static String getBarcodeTypeName(int code) {
        String val = "Unknown";
        switch (code) {
            case 101: {
                val = "UPC-A";
                break;
            }
            case 102: {
                val = " UPC-E";
                break;
            }
            case 103: {
                val = "JAN 8 / EAN 8";
                break;
            }
            case 104: {
                val = "JAN 13 / EAN 13";
                break;
            }
            case 105: {
                val = "2 of 5";
                break;
            }
            case 106: {
                val = "Interleaved 2 of 5";
                break;
            }
            case 107: {
                val = "Codabar";
                break;
            }
            case 108: {
                val = "Code 39";
                break;
            }
            case 109: {
                val = "Code 93";
                break;
            }
            case 110: {
                val = "Code 128";
                break;
            }
            case 111: {
                val = " UPC-A with Supplemental";
                break;
            }
            case 112: {
                val = "UPC-E with Supplemental";
                break;
            }
            case 113: {
                val = "UPC-D1";
                break;
            }
            case 114: {
                val = "UPC-D2";
                break;
            }
            case 115: {
                val = "UPC-D3";
                break;
            }
            case 116: {
                val = "UPC-D4";
                break;
            }
            case 117: {
                val = "UPC-D5";
                break;
            }
            case 118: {
                val = "EAN-8 with Supplemental";
                break;
            }
            case 119: {
                val = "EAN-13 with Supplemental";
                break;
            }
            case 120: {
                val = "EAN-128";
                break;
            }
            case 121: {
                val = "OCR \"A\"";
                break;
            }
            case 122: {
                val = "OCR \"B\"";
                break;
            }
            case 201: {
                val = "PDF 417";
                break;
            }
            case 202: {
                val = "MAXICODE";
                break;
            }
            case 501: {
                val = "Other";
            }
        }
        return val;
    }

    public void dataOccurred(DataEvent de) {
        this.doDataUpdate();
    }

    public void doDataUpdate() {
        try {
            this.scanData = this.scanner.getScanData();
            this.scanDataLabel = this.scanner.getScanDataLabel();
            this.scanDataType = this.scanner.getScanDataType();
            this.autoDisable = this.scanner.getAutoDisable();
            this.dataEventEnabled = this.scanner.getDataEventEnabled();
            this.deviceEnabled = this.scanner.getDeviceEnabled();
            this.freezeEvents = this.scanner.getFreezeEvents();
            this.decodeData = this.scanner.getDecodeData();
        }
        catch (JposException je) {
            JOptionPane.showMessageDialog(null, "Exception in doDataUpdate(): " + je.getMessage(), "Failed", 0);
        }
        this.updateDevice = false;
        try {
            SwingUtilities.invokeLater(this.doUpdateGUI);
        }
        catch (Exception e) {
            System.err.println("InvokeLater exception.");
        }
        this.updateDevice = true;
    }

    public void errorOccurred(ErrorEvent ee) {
        System.out.println("Error Occurred");
    }

    public void updateGUI() {
        this.scanDataTextArea.setText(new String(this.scanData));
        this.scanDataLabelTextArea.setText(new String(this.scanDataLabel));
        if (this.scanDataType == -1) {
            this.scanDataTypeTextField.setText("");
        } else {
            this.scanDataTypeTextField.setText(String.valueOf(Integer.toString(this.scanDataType)) + " (" + ScannerPanel.getBarcodeTypeName(this.scanDataType) + ")");
        }
        try {
            this.updateDevice = false;
            this.autoDisableCB.setSelected(this.scanner.getAutoDisable());
            this.dataEventEnabledCB.setSelected(this.scanner.getDataEventEnabled());
            this.deviceEnabledCB.setSelected(this.scanner.getDeviceEnabled());
            this.freezeEventsCB.setSelected(this.scanner.getFreezeEvents());
            this.decodeDataCB.setSelected(this.scanner.getDecodeData());
            this.updateDevice = true;
        }
        catch (JposException je) {
            System.err.println("ScannerPanel: updateGUI method received JposException: " + (Object)((Object)je));
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (ScannerPanel.this.updateDevice) {
                block26: {
                    ItemSelectable source = e.getItemSelectable();
                    if (source == ScannerPanel.this.autoDisableCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                ScannerPanel.this.scanner.setAutoDisable(false);
                                break block26;
                            }
                            ScannerPanel.this.scanner.setAutoDisable(true);
                        }
                        catch (JposException je) {
                            System.err.println("ScannerPanel: CheckBoxListener: Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == ScannerPanel.this.dataEventEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                ScannerPanel.this.scanner.setDataEventEnabled(false);
                                break block26;
                            }
                            ScannerPanel.this.scanner.setDataEventEnabled(true);
                        }
                        catch (JposException je) {
                            System.err.println("ScannerPanel: CheckBoxListener: Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == ScannerPanel.this.deviceEnabledCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                ScannerPanel.this.scanner.setDeviceEnabled(false);
                                break block26;
                            }
                            ScannerPanel.this.scanner.setDeviceEnabled(true);
                        }
                        catch (JposException je) {
                            System.err.println("ScannerPanel: CheckBoxListener: Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == ScannerPanel.this.freezeEventsCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                ScannerPanel.this.scanner.setFreezeEvents(false);
                                break block26;
                            }
                            ScannerPanel.this.scanner.setFreezeEvents(true);
                        }
                        catch (JposException je) {
                            System.err.println("ScannerPanel: CheckBoxListener: Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    } else if (source == ScannerPanel.this.decodeDataCB) {
                        try {
                            if (e.getStateChange() == 2) {
                                ScannerPanel.this.scanner.setDecodeData(false);
                            } else {
                                ScannerPanel.this.scanner.setDecodeData(true);
                            }
                        }
                        catch (JposException je) {
                            System.err.println("ScannerPanel: CheckBoxListener: Jpos Exception: " + (Object)((Object)je) + "\nSource: " + source);
                        }
                    }
                }
                ScannerPanel.this.updateGUI();
            }
        }
    }

    private class StatusTimerUpdateTask
    extends TimerTask {
        StatusTimerUpdateTask() {
        }

        public void run() {
            if (ScannerPanel.this.scanner != null) {
                ScannerPanel.this.mainButtonPanel.currentStatus.setText(MainButtonPanel.getStatusString(ScannerPanel.this.scanner.getState()));
            }
        }
    }

    private class DataCountTimerUpdateTask
    extends TimerTask {
        DataCountTimerUpdateTask() {
        }

        public void run() {
            try {
                ScannerPanel.this.dataCountLabel.setText("Data Count: " + Integer.toString(ScannerPanel.this.scanner.getDataCount()));
            }
            catch (JposException e) {
                System.out.println("Failed to retrieve the data count:\n" + e.getMessage());
            }
        }
    }
}

