/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.CATControl110;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.CATService110;
import jpos.services.CATService14;
import jpos.services.CATService15;
import jpos.services.CATService16;
import jpos.services.CATService17;
import jpos.services.CATService18;
import jpos.services.CATService19;
import jpos.services.EventCallbacks;

public class CAT
extends BaseJposControl
implements CATControl110,
JposConst {
    protected CATService14 service14;
    protected CATService15 service15;
    protected CATService16 service16;
    protected CATService17 service17;
    protected CATService18 service18;
    protected CATService19 service19;
    protected CATService110 service110;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector outputCompleteListeners;
    protected Vector statusUpdateListeners;

    public CAT() {
        this.deviceControlDescription = "JavaPOS CAT Device Control";
        this.deviceControlVersion = 1010000;
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.outputCompleteListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapAdditionalSecurityInformation() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapAdditionalSecurityInformation();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapAuthorizeCompletion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapAuthorizeCompletion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapAuthorizePreSales() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapAuthorizePreSales();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapAuthorizeRefund() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapAuthorizeRefund();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapAuthorizeVoid() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapAuthorizeVoid();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapAuthorizeVoidPreSales() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapAuthorizeVoidPreSales();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCenterResultCode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapCenterResultCode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCheckCard() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapCheckCard();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapDailyLog() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapDailyLog();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapInstallments() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapInstallments();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapPaymentDetail() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapPaymentDetail();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapTaxOthers() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapTaxOthers();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapTransactionNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapTransactionNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapTrainingMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCapTrainingMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCashDeposit() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCashDeposit();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapLockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapLockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapLogStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapLogStatus();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUnlockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUnlockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getAccountNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getAccountNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getAdditionalSecurityInformation() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getAdditionalSecurityInformation();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAdditionalSecurityInformation(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.setAdditionalSecurityInformation(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getApprovalCode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getApprovalCode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getAsyncMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getAsyncMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAsyncMode(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.setAsyncMode(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getCardCompanyID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCardCompanyID();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getCenterResultCode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getCenterResultCode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getDailyLog() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getDailyLog();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPaymentCondition() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getPaymentCondition();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getPaymentDetail() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getPaymentDetail();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getSequenceNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getSequenceNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getSlipNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getSlipNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getTrainingMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getTrainingMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setTrainingMode(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.setTrainingMode(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getTransactionNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getTransactionNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getTransactionType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service14.getTransactionType();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPaymentMedia() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1005000) {
            throw new JposException(104, "Device Service is not 1.5.0 compliant.");
        }
        try {
            return this.service15.getPaymentMedia();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPaymentMedia(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1005000) {
            throw new JposException(104, "Device Service is not 1.5.0 compliant.");
        }
        try {
            this.service15.setPaymentMedia(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getBalance() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getBalance();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getLogStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getLogStatus();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getSettledAmount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getSettledAmount();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void accessDailyLog(int n, int n2, int n3) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.accessDailyLog(n, n2, n3);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void authorizeCompletion(int n, long l, long l2, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.authorizeCompletion(n, l, l2, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void authorizePreSales(int n, long l, long l2, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.authorizePreSales(n, l, l2, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void authorizeRefund(int n, long l, long l2, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.authorizeRefund(n, l, l2, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void authorizeSales(int n, long l, long l2, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.authorizeSales(n, l, l2, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void authorizeVoid(int n, long l, long l2, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.authorizeVoid(n, l, l2, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void authorizeVoidPreSales(int n, long l, long l2, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.authorizeVoidPreSales(n, l, l2, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void checkCard(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.checkCard(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearOutput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service14.clearOutput();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void cashDeposit(int n, long l, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.cashDeposit(n, l, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void lockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.lockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void unlockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.unlockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new CATCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
        } else {
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (CATService14)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService14 interface", exception);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (CATService15)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService15 interface", exception);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (CATService16)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService16 interface", exception);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (CATService17)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService17 interface", exception);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (CATService18)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService18 interface", exception);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (CATService19)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService19 interface", exception);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (CATService110)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CATService110 interface", exception);
                }
            }
        }
    }

    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    public void addErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(errorListener);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(errorListener);
        }
    }

    public void addOutputCompleteListener(OutputCompleteListener outputCompleteListener) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(outputCompleteListener);
        }
    }

    public void removeOutputCompleteListener(OutputCompleteListener outputCompleteListener) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(outputCompleteListener);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class CATCallbacks
    implements EventCallbacks {
        protected CATCallbacks() {
        }

        public BaseControl getEventSource() {
            return CAT.this;
        }

        public void fireDataEvent(DataEvent dataEvent) {
        }

        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = CAT.this.directIOListeners;
            synchronized (vector) {
                int n = 0;
                while (n < CAT.this.directIOListeners.size()) {
                    ((DirectIOListener)CAT.this.directIOListeners.elementAt(n)).directIOOccurred(directIOEvent);
                    ++n;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent errorEvent) {
            Vector vector = CAT.this.errorListeners;
            synchronized (vector) {
                int n = 0;
                while (n < CAT.this.errorListeners.size()) {
                    ((ErrorListener)CAT.this.errorListeners.elementAt(n)).errorOccurred(errorEvent);
                    ++n;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
            Vector vector = CAT.this.outputCompleteListeners;
            synchronized (vector) {
                int n = 0;
                while (n < CAT.this.outputCompleteListeners.size()) {
                    ((OutputCompleteListener)CAT.this.outputCompleteListeners.elementAt(n)).outputCompleteOccurred(outputCompleteEvent);
                    ++n;
                }
            }
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = CAT.this.statusUpdateListeners;
            synchronized (vector) {
                int n = 0;
                while (n < CAT.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)CAT.this.statusUpdateListeners.elementAt(n)).statusUpdateOccurred(statusUpdateEvent);
                    ++n;
                }
            }
        }
    }
}

