/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Point;
import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.SignatureCaptureControl110;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.SignatureCaptureService110;
import jpos.services.SignatureCaptureService12;
import jpos.services.SignatureCaptureService13;
import jpos.services.SignatureCaptureService14;
import jpos.services.SignatureCaptureService15;
import jpos.services.SignatureCaptureService16;
import jpos.services.SignatureCaptureService17;
import jpos.services.SignatureCaptureService18;
import jpos.services.SignatureCaptureService19;

public class SignatureCapture
extends BaseJposControl
implements SignatureCaptureControl110,
JposConst {
    protected SignatureCaptureService12 service12;
    protected SignatureCaptureService13 service13;
    protected SignatureCaptureService14 service14;
    protected SignatureCaptureService15 service15;
    protected SignatureCaptureService16 service16;
    protected SignatureCaptureService17 service17;
    protected SignatureCaptureService18 service18;
    protected SignatureCaptureService19 service19;
    protected SignatureCaptureService110 service110;
    protected Vector dataListeners;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector statusUpdateListeners;

    public SignatureCapture() {
        this.deviceControlDescription = "JavaPOS SignatureCapture Device Control";
        this.deviceControlVersion = 1010000;
        this.dataListeners = new Vector();
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapDisplay() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapDisplay();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapRealTimeData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapRealTimeData();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUserTerminated() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapUserTerminated();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getAutoDisable() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getAutoDisable();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAutoDisable(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setAutoDisable(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDataCount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataCount();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataEventEnabled();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDataEventEnabled(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMaximumX() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMaximumX();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMaximumY() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMaximumY();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public Point[] getPointArray() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getPointArray();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public byte[] getRawData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getRawData();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getRealTimeDataEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getRealTimeDataEnabled();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setRealTimeDataEnabled(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setRealTimeDataEnabled(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void beginCapture(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.beginCapture(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearInput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearInput();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void endCapture() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.endCapture();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearInputProperties() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            this.service110.clearInputProperties();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new SignatureCaptureCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (SignatureCaptureService12)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService12 interface", exception);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (SignatureCaptureService13)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService13 interface", exception);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (SignatureCaptureService14)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService14 interface", exception);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (SignatureCaptureService15)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService15 interface", exception);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (SignatureCaptureService16)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService16 interface", exception);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (SignatureCaptureService17)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService17 interface", exception);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (SignatureCaptureService18)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService18 interface", exception);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (SignatureCaptureService19)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService19 interface", exception);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (SignatureCaptureService110)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement SignatureCaptureService110 interface", exception);
                }
            }
        }
    }

    public void addDataListener(DataListener dataListener) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(dataListener);
        }
    }

    public void removeDataListener(DataListener dataListener) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(dataListener);
        }
    }

    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    public void addErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(errorListener);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(errorListener);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class SignatureCaptureCallbacks
    implements EventCallbacks {
        protected SignatureCaptureCallbacks() {
        }

        public BaseControl getEventSource() {
            return SignatureCapture.this;
        }

        public void fireDataEvent(DataEvent dataEvent) {
            Vector vector = SignatureCapture.this.dataListeners;
            synchronized (vector) {
                int n = 0;
                while (n < SignatureCapture.this.dataListeners.size()) {
                    ((DataListener)SignatureCapture.this.dataListeners.elementAt(n)).dataOccurred(dataEvent);
                    ++n;
                }
            }
        }

        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = SignatureCapture.this.directIOListeners;
            synchronized (vector) {
                int n = 0;
                while (n < SignatureCapture.this.directIOListeners.size()) {
                    ((DirectIOListener)SignatureCapture.this.directIOListeners.elementAt(n)).directIOOccurred(directIOEvent);
                    ++n;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent errorEvent) {
            Vector vector = SignatureCapture.this.errorListeners;
            synchronized (vector) {
                int n = 0;
                while (n < SignatureCapture.this.errorListeners.size()) {
                    ((ErrorListener)SignatureCapture.this.errorListeners.elementAt(n)).errorOccurred(errorEvent);
                    ++n;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = SignatureCapture.this.statusUpdateListeners;
            synchronized (vector) {
                int n = 0;
                while (n < SignatureCapture.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)SignatureCapture.this.statusUpdateListeners.elementAt(n)).statusUpdateOccurred(statusUpdateEvent);
                    ++n;
                }
            }
        }
    }
}

