/*******************************************************************************************
 *                                                                                         *
 *                                 uBase-III	                                           *
 *                                                                                         *
 *       Copy Right 2002-2003,LandStanding Co.,Ltd.NewLand Group. All Right Reserved.      *
 *                                                                                         *
 *                                                                                         *
 *******************************************************************************************/
 /*******************************************************************************************
 *
 *	FILE:
 *		rapi.h
 *	Logs:
 *		2002.4.23		Created by wwd.
 *
 ********************************************************************************************/

#ifndef ___RAPI1_H___
#define ___RAPI1_H___

/*********************************************************************************************
*	include files 
*********************************************************************************************/
//#define RUN_IN_ARM
#define CPP_INCLUDE
#ifdef CPP_INCLUDE
//#include "..\filesys_t.h"
//extern "C"{
#endif

#ifdef __cplusplus
extern"C"{
#endif

/*********************************************************************************************
*	global referenced macro defines & type defines
*********************************************************************************************/
#define NLS_RAPIVERSION					100
#define NLS_MAXFILELEN					100

#define NLS_COMM_ERROR					101
#define NLS_READFILE_ERROR					102
#define NLS_WRITEFILE_ERROR					103
#define	NLS_USER_CANCEL					104
#define NLS_OTHER_ERROR					105



//RETURN RESULT
#define NLS_SUCCESS						1
#define NLS_FAIL						0

#ifdef RUN_IN_ARM
#define TRUE							1
#define FALSE							0


typedef int				HRESULT;
typedef void*			HANDLE;
typedef void*			LPVOID;
typedef const void*		LPCVOID;
typedef unsigned short	WORD;
typedef unsigned int	DWORD;
typedef int				BOOL;
typedef DWORD*			LPDWORD;
#endif

typedef DWORD			OID;
typedef OID				*POID;
typedef DWORD			PROPID;
typedef PROPID			*PPROPID;

/****************************************************************/
/*system function struct*/
typedef struct _UOSVERSIONINFO{
	DWORD dwMajorVersion;
	DWORD dwMinorVersion;
	DWORD dwBuildNumber;
} UOSVERSIONINFO, *LPUOSVERSIONINFO;

typedef struct _UMEMORYSTATUS{
    DWORD dwTotalPhys;
    DWORD dwAvailPhys;
	DWORD dwTop;
} UMEMORYSTATUS, *LPUMEMORYSTATUS;

typedef struct _USYSTEM_POWER_STATUS{
	BYTE ACLineStatus;
	BYTE BatteryFlag;
	BYTE BatteryLifePercent;
	BYTE Reserved1;
	DWORD BatteryLifeTime;
	DWORD BatteryFullLifeTime;
	BYTE Reserved2;
	BYTE BackupBatteryFlag;
	BYTE BackupBatteryLifePercent;
	BYTE Reserved3;
	DWORD BackupBatteryLifeTime;
	DWORD BackupBatteryFullLifeTime;
} USYSTEM_POWER_STATUS, *LPUSYSTEM_POWER_STATUS;

typedef struct _USTORE_INFORMATION{
	DWORD dwStoreSize;
	DWORD dwFreeSize;
} USTORE_INFORMATION, *LPUSTORE_INFORMATION;

typedef struct _USYSTEM_INFO{
	char  szDeviceType[64];
	DWORD dwDeviceManufactorySerial;
	DWORD dwDeviceProduceYear;
	DWORD dwDeviceProduceMonth;
	DWORD dwDeviceProduceDay;
} USYSTEM_INFO, *LPUSYSTEM_INFO;
/*****************************************************************/
/*file function struct*/

typedef struct _UFIND_DATA{
	DWORD    dwFileAttributes;
	time_t ftCreationTime;
	time_t ftLastAccessTime;
	time_t ftLastWriteTime;
	DWORD nFileSize;
	char     cFileName[NLS_MAXFILELEN];
} UFIND_DATA, *LPUFIND_DATA, **LPLPUFIND_DATA;
/*****************************************************************/
/*database function struct*/
typedef struct _USORTORDERSPEC{
	PROPID  propid;
	DWORD     dwFlags;
} USORTORDERSPEC;

typedef struct  _NLS_GUID{
	DWORD Data1;
	DWORD Data2;
	DWORD Data3;
	DWORD Data4;
} NLS_GUID, *LPNLS_GUID;

#define NLS_DB_MAXDBASENAMELEN  32
#define NLS_DB_MAXSORTORDER     4
typedef struct _DBASEINFO{
	DWORD   dwFlags;
	WCHAR   szDbaseName[NLS_DB_MAXDBASENAMELEN];
	DWORD   dwDbaseType;
	WORD    wNumRecords;
	WORD    wNumSortOrder;
	DWORD   dwSize;
	FILETIME ftLastModified;
	USORTORDERSPEC rgSortSpecs[NLS_DB_MAXSORTORDER];
} DBASEINFO;

typedef struct _FILEINFO{
	DWORD   dwAttributes;
	OID   oidParent;
	WCHAR   szFileName[MAX_PATH];
	FILETIME ftLastChanged;
	DWORD   dwLength;
} FILEINFO;

typedef struct _RECORDINFO{
	OID  oidParent;
} RECORDINFO;

typedef struct _DIRINFO{
    DWORD   dwAttributes;
    OID   oidParent;
    WCHAR   szDirName[MAX_PATH];
} DIRINFO;

typedef struct _OIDINFO{
	WORD  wObjType;
	WORD  wPad;
	union{
		FILEINFO   infFile;
		DIRINFO    infDirectory;
		DBASEINFO  infDatabase;
		RECORDINFO infRecord;
	};
} OIDINFO;

typedef struct _NLS_BLOB{
    DWORD       dwCount;
    LPBYTE      lpb;
} NLS_BLOB;

typedef union _VALUNION{
    short           iVal;
    USHORT          uiVal;
    long            lVal;
    ULONG           ulVal;
    FILETIME        filetime;
    LPWSTR          lpwstr;
    NLS_BLOB            blob;
    BOOL            boolVal;
    double          dblVal;
} VALUNION;

typedef struct _PROPVAL{
	PROPID    propid;
	WORD        wLenData;
	WORD        wFlags;
	VALUNION  val;
} PROPVAL, *PPROPVAL;

typedef struct _NOTIFYREQUEST{
    DWORD dwSize;
    HWND  hwnd;
    DWORD dwFlags;
    HANDLE hHeap;
	DWORD  dwParam;
} NOTIFYREQUEST;
typedef NOTIFYREQUEST *PNOTIFYREQUEST;

/********************************************************************************************/
typedef struct _rpc_funint{							//@ܺ
	/*system function 5*/
	void	(*_GetVersion)(void*, int&);			//@0
	void	(*_GlobalMemoryStatus)(void*, int&);	//@1
	void	(*_GetSystemPowerStatus)(void*, int&);	//@2
	void	(*_GetStoreInformation)(void*, int&);	//@3
	void	(*_GetSystemInfo)(void*, int&);			//@4
	/*file function 19*/							
	void	(*_FindFirstFile)(void*, int&);			//@5
	void	(*_FindNextFile)(void*, int&);			//@6
	void	(*_FindClose)(void*, int&);				//@7
	void	(*_GetFileAttributes)(void*, int&);		//@8
	void	(*_SetFileAttributes)(void*, int&);		//@9
	void	(*_CreateFile)(void*, int&);			//@10
	void	(*_OpenFile)(void*, int&);				//@11
	void	(*_ReadFile)(void*, int&);				//@12
	void	(*_WriteFile)(void*, int&);				//@13
	void	(*_CloseFile)(void*, int&);				//@14
	void	(*_SetFilePointer)(void*, int&);		//@15
	void	(*_SetEndOfFile)(void*, int&);			//@16
	void	(*_CreateDirectory)(void*, int&);		//@17
	void	(*_RemoveDirectory)(void*, int&);		//@18
	void	(*_DeleteFile)(void*, int&);			//@19
	void	(*_GetFileSize)(void*, int&);			//@20
	void	(*_GetFileTime)(void*, int&);			//@21
	void	(*_SetFileTime)(void*, int&);			//@22
	void	(*_SetFilePosToPre)(void *, int&);		//@23	
	/*another function*/
	void    (*_Ring)(void *, int&);

	/*database function*///
//	void	(*_CreateDatabase)(void*, int&);
//	void	(*_CreateDatabaseEx)(void*, int&);
//	void	(*_DeleteDatabase)(void*, int&);
//	void	(*_DeleteDatabaseEx)(void*, int&);
//	void	(*_DeleteRecord)(void*, int&);
//	void	(*_FindFirstDatabase)(void*, int&);
//	void	(*_FindFirstDatabaseEx)(void*, int&);
//	void	(*_FindNextDatabase)(void*, int&);
//	void	(*_FindNextDatabaseEx)(void*, int&);
//	void	(*_OidGetInfo)(void*, int&);
//	void	(*_OidGetInfoEx)(void*, int&);
//	void	(*_OpenDatabase)(void*, int&);
//	void	(*_OpenDatabaseEx)(void*, int&);
//	void	(*_ReadRecordProps)(void*, int&);
//	void	(*_ReadRecordPropsEx)(void*, int&);
//	void	(*_WriteRecordProps)(void*, int&);
//	void	(*_WriteRecordPropsEx)(void*, int&);
//	void	(*_SeekDatabase)(void*, int&);
//	void	(*_SetDatabaseInfo)(void*, int&);
//	void	(*_SetDatabaseInfoEx)(void*, int&);
//	void	(*_FlushDBVol)(void*, int&);
//	void	(*_FindAllDatabases)(void*, int&);
} RPC_FUNINT;

/*********************************************************************************************
*	global referenced variables
*********************************************************************************************/

/*********************************************************************************************
*	global function prototype
*********************************************************************************************/
/*common function 3*/
HRESULT	WINAPI NLS_RapiInit				(int nPort, int nRate,BOOL bCompress = 1);
HRESULT	WINAPI NLS_RapiUninit				(void);
BOOL	WINAPI NLS_SetBaudrate				(int nBaudrate/*in*/);
/*system function 5*/
BOOL	WINAPI NLS_GetVersion				(LPUOSVERSIONINFO lpVersionInformation/*out*/);
BOOL	WINAPI NLS_GlobalMemoryStatus		(LPUMEMORYSTATUS lpmst/*out*/);
BOOL	WINAPI NLS_GetSystemPowerStatus	(LPUSYSTEM_POWER_STATUS pstatus/*out*/);
BOOL	WINAPI NLS_GetStoreInformation		(LPUSTORE_INFORMATION lpsi/*out*/, int nDriver/*in*/);
BOOL	WINAPI NLS_GetSystemInfo			(LPUSYSTEM_INFO lpSystemInfo/*out*/);
/*file function 21*/
HANDLE	WINAPI NLS_FindFirstFile			(LPCSTR lpFileName/*in*/, LPUFIND_DATA lpFindFileData/*out*/);
BOOL	WINAPI NLS_FindNextFile			(HANDLE hFindFile/*in*/, LPUFIND_DATA lpFindFileData/*out*/);
BOOL	WINAPI NLS_FindClose				(HANDLE hFindFile/*in*/);
DWORD	WINAPI NLS_GetFileAttributes		(LPCSTR lpFileName/*in*/);
BOOL	WINAPI NLS_SetFileAttributes		(LPCSTR lpFileName/*in*/, DWORD dwFileAttributes/*in*/);
HANDLE	WINAPI NLS_CreateFile				(LPCSTR lpFileName/*in*/, DWORD dwFlagsAndAttributes/*in*/);
HANDLE	WINAPI NLS_OpenFile				(LPCSTR lpFileName/*in*/, DWORD dwOpenMode/*in*/);
BOOL	WINAPI NLS_ReadFile				(HANDLE hFile/*in*/, LPVOID lpBuffer/*out*/, DWORD nNumberOfBytesToRead/*in*/, LPDWORD lpNumberOfBytesRead/*out*/);
BOOL	WINAPI NLS_WriteFile				(HANDLE hFile/*in*/, LPCVOID lpBuffer/*in*/, DWORD nNumberOfBytesToWrite/*in*/, LPDWORD lpNumberOfBytesWritten/*out*/);
BOOL	WINAPI NLS_CloseFile				(HANDLE hFile/*in*/);
DWORD	WINAPI NLS_SetFilePointer			(HANDLE hFile/*in*/, int nDistanceToMove/*in*/,  DWORD dwMoveMethod/*in*/);
BOOL	WINAPI NLS_SetEndOfFile			(HANDLE hFile/*in*/);
BOOL	WINAPI NLS_CreateDirectory			(LPCSTR lpPathName/*in*/);
BOOL	WINAPI NLS_RemoveDirectory			(LPCSTR lpPathName/*in*/);
BOOL	WINAPI NLS_MoveFile				(LPCSTR lpExistingFileName/*in*/, LPCSTR lpNewFileName/*in*/);
BOOL	WINAPI NLS_CopyFile				(LPCSTR lpExistingFileName/*in*/, LPCSTR lpNewFileName/*in*/, BOOL bFailIfExists/*in*/);
BOOL	WINAPI NLS_DeleteFile				(LPCSTR lpFileName/*in*/);
DWORD	WINAPI NLS_GetFileSize				(HANDLE hFile/*in*/);
BOOL	WINAPI NLS_GetFileTime				(HANDLE hFile/*in*/, clock_t* lpCreationTime/*out*/, clock_t* lpLastAccessTime/*out*/, clock_t* lpLastWriteTime/*out*/);
BOOL	WINAPI NLS_SetFileTime				(HANDLE hFile/*in*/, const clock_t *lpCreationTime/*in*/, const clock_t *lpLastAccessTime/*in*/, const clock_t *lpLastWriteTime/*in*/);
BOOL  WINAPI NLS_CopyFileEx				(LPCSTR lpExistingFileName/*in*/, LPCSTR lpNewFileName/*in*/, LPTHREAD_START_ROUTINE lpProgressRoutine/*in*/, LPVOID lpData/*in/out*/, LPBOOL pbCancel/*in*/, DWORD dwCopyFlags/*in*/);
BOOL WINAPI NLS_SetFilePosToPre			(HANDLE hFile/*in*/, int nPackageMark/*in*/, int *nFilePrePos/*out*/);


//file function for wchar
HANDLE	WINAPI NLS_FindFirstFileW			(LPCWSTR lpFileName/*in*/, LPUFIND_DATA lpFindFileData/*out*/);
DWORD	WINAPI NLS_GetFileAttributesW		(LPCWSTR lpFileName/*in*/);
BOOL	WINAPI NLS_SetFileAttributesW		(LPCWSTR lpFileName/*in*/, DWORD dwFileAttributes/*in*/);
HANDLE	WINAPI NLS_CreateFileW				(LPCWSTR lpFileName/*in*/, DWORD dwFlagsAndAttributes/*in*/);
HANDLE	WINAPI NLS_OpenFileW				(LPCWSTR lpFileName/*in*/, DWORD dwOpenMode/*in*/);
BOOL	WINAPI NLS_CreateDirectoryW			(LPCWSTR lpPathName/*in*/);
BOOL	WINAPI NLS_RemoveDirectoryW			(LPCWSTR lpPathName/*in*/);
BOOL	WINAPI NLS_MoveFileW				(LPCWSTR lpExistingFileName/*in*/, LPCWSTR lpNewFileName/*in*/);
BOOL	WINAPI NLS_CopyFileW				(LPCWSTR lpExistingFileName/*in*/, LPCWSTR lpNewFileName/*in*/, BOOL bFailIfExists/*in*/);
BOOL	WINAPI NLS_DeleteFileW				(LPCWSTR lpFileName/*in*/);
BOOL  WINAPI NLS_CopyFileExW				(LPCWSTR lpExistingFileName/*in*/, LPCWSTR lpNewFileName/*in*/, LPTHREAD_START_ROUTINE lpProgressRoutine/*in*/, LPVOID lpData/*in/out*/, LPBOOL pbCancel/*in*/, DWORD dwCopyFlags/*in*/);



/*another function*/
BOOL WINAPI NLS_Ring					(LPCWSTR lpMusicChar);

/*another function for wchar*/
 BOOL WINAPI NLS_RingW					(LPCWSTR lpMusicChar);
/*database function ?*/
//DWORD  ServerThread(LPVOID lpParameter);
//DWORD  CopyProc(LPVOID lpData);

#ifdef __cplusplus
} //extern"C"{
#endif

#ifdef CPP_INCLUDE
//}
#endif

#endif
