@echo off

@echo off
setlocal enabledelayedexpansion

set infile=%~1
set infile=./libs/sample.avi

ffprobe -v fatal -show_error -show_format -show_streams -i "%infile%">"info.txt" 2>nul

set isvideo=0
for /f "usebackq tokens=1,2 delims==" %%i in ("info.txt") do (
	if /i "%%i" == "codec_type" if /i "%%j" == "video" set isvideo=1
    if /i "%%i" == "codec_type" if /i "%%j" == "audio" set isvideo=2
	if /i "%%i" == "[format]" set isvideo=3
	
	if "!isvideo!" == "1" (
    if /i "%%i" == "coded_width"       set coded_width=%%j
	if /i "%%i" == "coded_height"      set coded_height=%%j
    if /i "%%i" == "width"             set width=%%j
	if /i "%%i" == "height"            set height=%%j

    if /i "%%i" == "duration"          set duration=%%j
    if /i "%%i" == "nb_frames"         set nb_frames=%%j
    if /i "%%i" == "avg_frame_rate"    set avg_frame_rate=%%j
    if /i "%%i" == "r_frame_rate"      set r_frame_rate=%%j
	)
	if "!isvideo!" == "3" (
		if /i "!duration!" == "n/a" (
			if /i "%%i" == "duration"  set duration=%%j
	)))
del "info.txt" 2>nul
if /i "%r_frame_rate%" == "N/A" set r_frame_rate=30000/1001
set /p a=%%{pts:hms} - %%{eif:t*%r_frame_rate%:d:0}/%nb_frames%<nul>%cd%/libs/FFPlay_display_pts.txt

if /i "%duration%" == "N/A" set duration=1000000

set duration=%duration:.=%
if "%duration:~0,1%" == "0" set duration=%duration:~1%
call :bstotime %duration:~0,-3%
set duration=%ret_time::=\:%

::-cpuflags atom 
:: 
set mcd=%cd%
set mcd=%mcd:\=/%
set mcd=%mcd::=\:%

ffplay -hide_banner -i "%infile%" -vf delogo=960-330:540-60:330:60,drawtext='fontfile=%mcd%/libs/LED_font.ttf:x=(w-tw)/2:y=h-th-6:fontsize=30:fontcolor=#f0f0f0:shadowcolor=#303030:shadowx=1:shadowy=1:rate=1:expansion=normal:start_number=0:borderw=0:bordercolor=#303030:box=0:boxcolor=#303030@0.2:textfile=%mcd%/libs/FFPlay_display_pts.txt',drawtext='fontfile=%mcd%/libs/LED_font.ttf:x=10:y=10:fontsize=30:fontcolor=#f0f0f0:shadowcolor=#303030:shadowx=1:shadowy=1:rate=1:expansion=normal:start_number=0:borderw=0:bordercolor=#303030:box=0:boxcolor=#303030@0.2:text="%duration%"' -loop 0
exit/b

::----------------------------------:bstotime--------------------------------
:bstotime
set /a inbsec=%~1
set /a sec=%inbsec%/1000
set /a msec=%inbsec%-%sec%*1000
set /a min=%sec%/60
set /a sec=%sec%-%min%*60
set /a hour=%min%/60
set /a min=%min%-%hour%*60
if %hour% leq 9 (set hour=0%hour%)
if %min%  leq 9 (set min=0%min%)
if %sec%  leq 9 (set sec=0%sec%)
if %msec%  leq 9 (set msec=00%msec%) else (
if %msec%  leq 99 (set msec=0%msec%))
set ret_time=%hour%:%min%:%sec%.%msec%
if "%ret_time:~0,3%" == "00:" set ret_time=%ret_time:~3%
if "%ret_time:~0,3%" == "00:" set ret_time=%ret_time:~3%
if "%ret_time:~0,3%" == "00." set ret_time=%ret_time:00.=0.%
if "%ret_time:~0,1%" == "0" if not "%ret_time:~1,1%" == "." set ret_time=%ret_time:~1%
exit /b