/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Callback;
import java.util.Vector;

public class TableResult
implements Callback {
    public int ncolumns;
    public int nrows;
    public String[] column;
    public String[] types;
    public Vector rows;
    public int maxrows = 0;
    public boolean atmaxrows;

    public TableResult() {
        this.clear();
    }

    public TableResult(int n) {
        this.maxrows = n;
        this.clear();
    }

    public void clear() {
        this.column = new String[0];
        this.types = null;
        this.rows = new Vector();
        this.nrows = 0;
        this.ncolumns = 0;
        this.atmaxrows = false;
    }

    public void columns(String[] stringArray) {
        this.column = stringArray;
        this.ncolumns = this.column.length;
    }

    public void types(String[] stringArray) {
        this.types = stringArray;
    }

    public boolean newrow(String[] stringArray) {
        if (stringArray != null) {
            if (this.maxrows > 0 && this.nrows >= this.maxrows) {
                this.atmaxrows = true;
                return true;
            }
            this.rows.addElement(stringArray);
            ++this.nrows;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.ncolumns; ++n) {
            stringBuffer.append(this.column[n] == null ? "NULL" : this.column[n]);
            stringBuffer.append('|');
        }
        stringBuffer.append('\n');
        for (n = 0; n < this.nrows; ++n) {
            String[] stringArray = (String[])this.rows.elementAt(n);
            for (int i = 0; i < this.ncolumns; ++i) {
                stringBuffer.append(stringArray[i] == null ? "NULL" : stringArray[i]);
                stringBuffer.append('|');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

