/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl.accessor;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import ognl.MethodFailedException;
import ognl.ObjectMethodAccessor;
import ognl.OgnlContext;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public class XWorkMethodAccessor
extends ObjectMethodAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(XWorkMethodAccessor.class);
    @Deprecated
    public static final String DENY_METHOD_EXECUTION = "xwork.MethodAccessor.denyMethodExecution";
    @Deprecated
    public static final String DENY_INDEXED_ACCESS_EXECUTION = "xwork.IndexedPropertyAccessor.denyMethodExecution";

    public Object callMethod(Map context, Object object, String string, Object[] objects) throws MethodFailedException {
        boolean e;
        Boolean exec;
        if (objects.length == 1 && context instanceof OgnlContext) {
            try {
                PropertyDescriptor descriptor;
                Class<?> propertyType;
                OgnlContext ogContext = (OgnlContext)context;
                if (OgnlRuntime.hasSetProperty(ogContext, object, string) && Collection.class.isAssignableFrom(propertyType = (descriptor = OgnlRuntime.getPropertyDescriptor(object.getClass(), string)).getPropertyType())) {
                    Object propVal = OgnlRuntime.getProperty(ogContext, object, string);
                    PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(Collection.class);
                    ReflectionContextState.setGettingByKeyProperty(ogContext, true);
                    return accessor.getProperty(ogContext, propVal, objects[0]);
                }
            }
            catch (Exception oe) {
                LOG.error("An unexpected exception occurred", oe, new String[0]);
            }
        }
        if (objects.length == 2 && string.startsWith("set") || objects.length == 1 && string.startsWith("get")) {
            boolean e2;
            exec = (Boolean)context.get(DENY_INDEXED_ACCESS_EXECUTION);
            boolean bl = e2 = exec == null ? false : exec;
            if (!e2) {
                return this.callMethodWithDebugInfo(context, object, string, objects);
            }
        }
        boolean bl = e = (exec = (Boolean)context.get(DENY_METHOD_EXECUTION)) == null ? false : exec;
        if (!e) {
            return this.callMethodWithDebugInfo(context, object, string, objects);
        }
        return null;
    }

    private Object callMethodWithDebugInfo(Map context, Object object, String methodName, Object[] objects) throws MethodFailedException {
        try {
            return super.callMethod(context, object, methodName, objects);
        }
        catch (MethodFailedException e) {
            if (LOG.isDebugEnabled() && !(e.getReason() instanceof NoSuchMethodException)) {
                String s = "Error calling method through OGNL: object: [#0] method: [#1] args: [#2]";
                LOG.debug(s, e.getReason(), object.toString(), methodName, Arrays.toString(objects));
            }
            throw e;
        }
    }

    public Object callStaticMethod(Map context, Class aClass, String string, Object[] objects) throws MethodFailedException {
        boolean e;
        Boolean exec = (Boolean)context.get(DENY_METHOD_EXECUTION);
        boolean bl = e = exec == null ? false : exec;
        if (!e) {
            return this.callStaticMethodWithDebugInfo(context, aClass, string, objects);
        }
        return null;
    }

    private Object callStaticMethodWithDebugInfo(Map context, Class aClass, String methodName, Object[] objects) throws MethodFailedException {
        try {
            return super.callStaticMethod(context, aClass, methodName, objects);
        }
        catch (MethodFailedException e) {
            if (LOG.isDebugEnabled() && !(e.getReason() instanceof NoSuchMethodException)) {
                String s = "Error calling method through OGNL, class: [#0] method: [#1] args: [#2]";
                LOG.debug(s, e.getReason(), aClass.getName(), methodName, Arrays.toString(objects));
            }
            throw e;
        }
    }
}

