(function () {
    var formatDtt = (fmt,date) => {
        var o = {
            "M+" : date.getMonth()+1,                 //月份
            "d+" : date.getDate(),                    //日
            "h+" : date.getHours(),                   //小时
            "m+" : date.getMinutes(),                 //分
            "s+" : date.getSeconds(),                 //秒
            "q+" : Math.floor((date.getMonth()+3)/3), //季度
            "S"  : date.getMilliseconds()             //毫秒
        };
        if(/(y+)/.test(fmt))
            fmt=fmt.replace(RegExp.$1, (date.getFullYear()+"").substr(4 - RegExp.$1.length));
        for(var k in o)
            if(new RegExp("("+ k +")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
        return fmt;
    }
    var gui = require('nw.gui')
    var win = gui.Window.get()

    var baseUrl = "https://api.xxpie.com",//"https://int2.xxpie.com",//
        albumlistUrl = baseUrl + "/api/ps/task/getShootingTaskList",//"/api/photographer/home/getShootingTasks",//
        searchByCodeUrl = baseUrl + "/api/ps/task/queryRetouchShootingTaskByCode";

    var token = localStorage.getItem('token')

    var pageSize = 50000;
    var app = new Vue({
        el: "#root",
        data: {
            albums: [],
            currentSelectAlbum: '',
            searchCode: '',
            currentPage: 1,
            totalAlbumsCount: 0,
            choosedAlbums: [],
        },
        watch: {
            currentPage: (val) => {
                app.loadAlbums()
            }
        },
        methods: {
            closeWindow : function () {win.close()},
            minifyWindow : function () {win.minimize()},
            loadAlbums: () => {
                if (app.searchCode.length == 6){
                    app.search()
                }else {
                    console.log("加载相册列表")
                    axios.get(albumlistUrl, {
                        params: {
                            'currentPage': app.currentPage,
                            'pageSize': pageSize,
                            'token': token
                        }
                    }).then((res) => {
                        if (res.status === 200){
                            data = res.data
                            app.totalAlbumsCount = data.count
                            allIds = global.albums.map(it => {return it.id})
                            if (app.currentPage == 1){
                                app.albums = []
                                //todo 过滤已经加入工作区的相册
                                data.result.sort((i, j) => {
                                    return i.date_time < j.date_time ? 1 : -1
                                }).forEach(it => {
                                    if (!allIds.includes(it.id)){
                                        it.choosen = false
                                        app.albums.push(it)
                                    }
                                })
                            }else {
                                app.albums = app.albums.concat(data.result)
                            }
                        }
                    }).catch((err) => {
                        // alert(err)
                        if (err.response && err.response.status === 403){
                            //token失效
                            global.emitter.emit('tokenInvalid')
                            win.close()
                        }else {
                            //网络错误，等着用户点击吧
                        }
                    })
                }
            },
            maxifyWindow : function () {
                // if (win.height > 680) {
                //     win.restore()
                // }else {
                //     win.maximize()
                // }
            },
            refresh: () => {
                app.loadAlbums()
            },
            select: (index, album) => {
                if (!album.choosen){//点击事件先发生
                    console.log("选中了" + album.name)
                    if (!app.choosedAlbums.includes(album)){
                        app.choosedAlbums.push(album)
                        app.currentSelectAlbum = album;
                    }
                }else {
                    //取消选中
                    console.log("取消选中" + album.name)
                    if (app.choosedAlbums.includes(album)){
                        i = app.choosedAlbums.indexOf(album)
                        app.choosedAlbums.splice(i, 1)
                        if (app.choosedAlbums.length === 0){
                            app.currentSelectAlbum = '';
                        }
                    }
                }
            },
            search: () => {
                if (app.searchCode.length === 0){
                    app.refresh()
                    return
                }
                axios.get(searchByCodeUrl, {
                    params: {
                        'code': app.searchCode,
                        'token': token,
                    }
                }).then((res) => {
                    if (res.status === 200){
                        if (res.data.shoot_task_id){
                            app.albums = [{
                                id: res.data.shoot_task_id,
                                name: res.data.task_name,
                                date_time: res.data.plan_shoot_time,
                                invitation_code: res.data.invitation_code,
                            }]
                        }else {
                            app.albums = []
                        }
                    }else {
                        app.albums = []
                    }
                }).catch((err) => {
                    if (err.response && err.response.status === 403){
                        //token失效
                        global.emitter.emit('tokenInvalid')
                        win.close()
                    }else {
                        //网络错误，等着用户点击吧
                    }
                })
            },
            cancel: () => {win.close()},
            confirm: () => {
                //确认选中, 发送事件给mainWindow, 关闭窗口
                global.emitter.emit('choosedAlbum', app.choosedAlbums)
                win.close()
            },
            formatDtt: formatDtt
        },
    })
    app.loadAlbums()
})()