(function () {
    var baseUrl = "https://api.xxpie.com",//"https://int2.xxpie.com",//
        getCodeUrl = "/api/photographer/mine/sendSMSVerificationCode",
        loginUrl = "/api/photographer/mine/signInV4";
    var gui = require('nw.gui')
    console.log(gui)
    var win = gui.Window.get()
    var mobile = localStorage.getItem('mobile_number')
    var mobileRegex = /^1\d{10}$/
    if (!mobileRegex.test(mobile))
        mobile = ''
    var token = localStorage.getItem('token')
    if (token && token.length > 0){
        //验证token
        gui.Window.open('./main.html', {
            position: "center",
            width: 1390,
            height: 700,
            min_width: 1390,
            min_height: 700,
            // frame: false,
        }, function (newWin) {
            console.log('new window loaded')
            win.close()
        });
    }
    var app = new Vue({
        el: '#root',
        data: {
            mobile: mobile ? mobile : '',
            timeout: '获取验证码',
            timeoutTime: 60,
            code: '',
            errMsg: '',
            tip : '',
        },
        methods: {
            closeWindow : function () {win.close()},
            getVcode: function () {
                app.errMsg = '';
                if (this.timeout === '获取验证码') {
                    app.timeoutTime = 60;
                    myTimer = setInterval(function () {
                        app.timeoutTime--;
                        app.timeout = app.timeoutTime + '秒后重试';
                        if (app.timeoutTime == 0) {
                            clearInterval(myTimer)
                            app.timeout = "获取验证码";
                            app.timeoutTime = 60;
                        }
                    }, 1000)
                    app.tip = '正在发送...';
                    axios.post(baseUrl + getCodeUrl, {
                        mobile: app.mobile,
                        district: '+86',
                        type: 'PHOTOGRAPHER_SIGN_IN',
                    }).then(function (res) {
                        console.log("验证码已发送")
                        app.tip = '验证码已发送';
                        window.setTimeout(() => {
                            app.tip = ''
                        }, 1000)
                    }).catch(function (err) {
                        app.tip = '验证码发送失败';
                        window.setTimeout(() => {
                            app.tip = ''
                        }, 1000)
                        app.errMsg = ("发送验证码失败" + err.response) ? (", 错误代码: " + err.response.status) : ""
                    })
                }
            },
            login: function () {
                //校验密码
                app.errMsg = '';
                if (app.mobile == '' || app.code == '') {
                    app.errMsg = "手机号和验证码不能为空！"
                    return
                }
                if (app.code.length < 4 ){
                    app.errMsg = "验证码最少为4位！"
                    return
                }
                axios.post(baseUrl + loginUrl, {
                    username: this.mobile,
                    verificationCode: this.code,
                })
                    .then(function (response) {
                        if (response.status === 200) {
                            //登录成功
                            user = response.data;
                            //保存token
                            localStorage.setItem('icon_photo_key', user.icon_photo_key)
                            localStorage.setItem('icon_photo_url', user.icon_photo_url)
                            localStorage.setItem('mobile_number', user.mobile_number)
                            localStorage.setItem('nick_name', user.nick_name)
                            localStorage.setItem('sys_user_id', user.sys_user_id)
                            localStorage.setItem('token', user.token)
                            gui.Window.open('./main.html', {
                                position: "center",
                                width: 1390,
                                height: 700,
                                min_width: 1390,
                                min_height: 700,
                                // frame: false,
                            }, function (newWin) {
                                console.log('new window loaded')
                                win.close()
                            });
                        } else {
                            code = ''
                            app.errMsg = "验证码错误，请核对后重新输入"
                        }
                    })
                    .catch(function (error) {
                        code = ''
                        app.errMsg = '验证码错误，请核对后重新输入'
                    })
            }
        }
    })
})()