(function () {
    var baseUrl = "https://api.xxpie.com",//"https://int2.xxpie.com",//
        getOriginPhotosUrl = baseUrl + '/api/photographer/home/getShootingTaskPhotos',
        // getRetouchPhotosUrl = baseUrl + '/api/console/task/getPhotoVersionGroupByPhotographer',
        getRetouchPhotosUrl = baseUrl + '/api/ps/task/getTaskPhotoVersions',
        getPhotosUrl = getOriginPhotosUrl,
        getQiqiuTokenUrl = baseUrl + "/api/ps/mine/getQiNiuUploadToken",
        uploadPhotoUrl = baseUrl + "/api/console/task/addPhotoVersion2ShootingTask",
        uploadOriginPhotoUrl = baseUrl + '/api/console/task/addPhoto2ShootingTask',
        getSubAlbumsUrl = baseUrl + "/api/photographer/home/getShootingTaskSubs",
        joinTaskUrl = baseUrl + '/api/photographer/home/joinTaskByInvitationCode'

    var TABLE_UPLOADRECORD = 'upload_record';
    var TABLE_CHOOSENALBUM = 'choosen_album';

    var gui = require('nw.gui')
    var path = require('path')
    var fs = require('fs')
    var os = require('os')
    var childprocess = require('child_process')
    var http = require('https')
    var win = gui.Window.get()
    var dpath = localStorage.getItem('downloadpath')
    var upath = localStorage.getItem('uploadpath')
    var downloadpath = dpath ? dpath : path.join(gui.App.dataPath, 'xxpie_download')
    var uploadpath = upath ? upath : path.join(gui.App.dataPath, 'xxpie_upload')
    var shouldShowGuide = !localStorage.getItem('displayedGuidev2.0.0') === true

    var splashStepListener = () => {
        app.splashStep++
        if (app.splashStep === 4){
            app.album.showDownloadPanel = false
        }
        if (app.splashStep === 5){
            app.album.showDownloadPanel = true
        }
        if (app.splashStep > 6){
            app.quitGuide()
        }
    }

    // win.showDevTools()

    class Event {
        constructor(type, exec) {
            this.type = type
            this.exec = exec
        }
    }

    var DOWNLOADSTATUS = {
        WAITTING: 1,
        DOWNLOADING: 2,
        DOWNLOADED: 3,
        FAIL: 4,
    }
    var DOWNLOAD_PHOTOS_FILTER = {
        ALL: 5,
        DOWNLOADED: 3,
        WAIT: 1,
        FAILED: 4,
    }
    var UPLOADSTATUS = {
        WAITTING: 1,
        UPLOADING: 2,
        UPLOADED : 3,
        FAIL: 4,
    }

    class DownloadPhoto {
        constructor(p){
            this.id = p ? p.photo_id : ''
            this.file_name = p ? p.file_name : ''
            this.file_size = p ? p.file_size : ''
            this.upload_time = p ? p.upload_time : ''
            //所属子相册
            this.subtask_id = p ? p.shoot_task_sub_id : ''
            this.subtask_name = ''

            //所属相册
            this.task_id = p ? p.shoot_task_id : ''
            this.task_name = ''

            //下载相关
            this.thumbnail = p ? p.thumbnail : ''
            this.origin = p ? p.origin : ''
            this.subpath = ''
            this.path = ''
            this.process = 0
            this.failureCount = 0

            this.status = DOWNLOADSTATUS.WAITTING

            //checked表示选中， choosen表示选中后按下了下载已选
            this.choosen = false
            this.checked = false
        }
    }

    class UploadPhoto {
        constructor(photo){
            this.id = photo ? photo.id : ''
            this.albumid = photo ? photo.albumid : ''
            this.name = photo ? photo.name : ''
            this.localpath = photo ? photo.localpath : ''
            this.subpath = photo ? photo.subPath : ''
            this.size = photo ? photo.size : 0
            this.create_time = photo ? photo.create_time : 0
            this.status = photo ? photo.status : UPLOADSTATUS.WAITTING
            this.hash = photo ? photo.hash : ''
            this.key = photo ? photo.key : ''

            this.subscription = ''
            this.process = photo ? photo.progress : 0
            this.subtask_id = photo ? photo.subtask_id : ''
            this.subtask_name = photo ? photo.subtask_name : ''
            this.failCount = 0

            this.checked = photo ? photo.checked : false
            this.choosen = photo ? photo.choosen : false

            this.thumbnail = photo && photo.thumbnail ? photo.thumbnail : ''
        }
    }

    class SubAlbum {
        constructor(subdata){
            this.id = subdata ? subdata.shoot_task_sub_id : "5c1c73987ad8b61638d1bb03"
            this.name = subdata ? subdata.task_sub_name : "图片"
            this.photo_count = subdata ? subdata.photo_count : 0
            this.seq = subdata ? subdata.seq : 0

            this.download = true
            this.upload = true
        }
    }

    class Album {
        constructor(data) {
            this.id = data ? data.id : ''
            this.ownedBy = data && data.ownedBy ? data.ownedBy : user.sys_user_id
            this.name = data ? data.name : ''
            this.subAlbums = data && data.subAlbums ? data.subAlbums : []
            this.usedSpace = data ? data.usedSpace : 0
            this.date_time = data ? data.date_time : ''
            this.cover_photo_url = data ? data.cover_photo_url : ''
            this.create_by = data ? data.create_by : ''
            this.originPhotos = []
            this.retouchPhotos = []
            this.uploadFiles = []
            this.invitation_code = data && data.invitation_code ? data.invitation_code : ''

            this.downloadFrom = data && data.downloadFrom ? data.downloadFrom : DOWNLOAD_FROM_ORIGIN
            this.uploadTo = data && data.uploadTo ? data.uploadTo : DOWNLOAD_FROM_RETOUCH
            this.autoDownload = data && data.autoDownload ? data.autoDownload : false
            this.autoUpload = data && data.autoUpload ? data.autoUpload : false

            this.downloadedCount = 0
            this.downloadFailCount = 0
            this.uploadedCount = 0
            this.uploadFailCount = 0
            this.downloadingStatus = data && data.downloadingStatus ? data.downloadingStatus : '检测中'
            // UI设置
            this.showDownloadPanel = data && data.showDownloadPanel ? data.showDownloadPanel : true
            this.downloadPhotosFilter = data && data.downloadPhotosFilter ? data.downloadPhotosFilter : DOWNLOAD_PHOTOS_FILTER.ALL
            this.uploadPhotosFilter = data && data.uploadPhotosFilter ? data.uploadPhotosFilter : DOWNLOAD_PHOTOS_FILTER.ALL
            this.editMode = data && data.editMode ? data.editMode : false

            this.downloadAllSub = data && data.downloadAllSub ? data.downloadAllSub : true
            this.uploadAllSub = data && data.uploadAllSub ? data.uploadAllSub : true

            //切换原片已修片、子相册、下载/上传状态时重新筛选
            this.filteredDownloadPhotos = []
            this.filteredUploadPhotos = []

            this.autoDeleteUploadedFile = data && data.autoDeleteUploadedFile ? data.autoDeleteUploadedFile : false

            this.readedDBrecords = false
            this.uploading = false
        }

        updateDownloadFilter(param) {
            if (param.downloadFrom) {
                //修改了来源
                this.downloadFrom = param.downloadFrom

                if (this.downloadFrom === DOWNLOAD_FROM_RETOUCH){
                    var taskDownloadPath = path.join(app.downloadpath, this.name)
                    var taskDRpath = path.join(taskDownloadPath, '已修片')
                    if (!fs.existsSync(taskDRpath)) {
                        fs.mkdirSync(taskDRpath)
                    }
                }
            }
            if (param.subalbum) {
                //修改了过滤的子相册
                this.downloadAllSub = this.isDownloadAllSub()
            }

            if (param.downloadPhotosFilter) {
                this.downloadPhotosFilter = param.downloadPhotosFilter
            }

            this.updateRecord()
            this.updateDownloadFilteredPhotos()
        }

        updateUploadFilter(param) {
            if (param.uploadTo) {
                this.uploadTo = param.uploadTo
            }

            if (param.subalbum) {
                this.subAlbums.forEach(album => {
                    if (param.subalbum.id === album.id) {
                        //
                        album.upload = true
                    } else {
                        album.upload = false
                    }
                })
                this.uploadAllSub = false
            }

            if (param.uploadAllSub) {
                this.uploadAllSub = true
                this.subAlbums.forEach((sub) => {
                    sub.upload = true
                })
            }

            this.updateRecord()
            this.updateUploadFilteredPhotos()

        }

        updateRecord() {
            updateALbumRecord(this)
        }

        updateDownloadFilteredPhotos() {
            var choosedSubIds = this.getDownloadSubs().map((sub) => {
                return sub.id
            })
            this.downloadedCount = 0
            this.filteredDownloadPhotos = this.getAlbumPhotos().filter((photo) => {
                var includes = choosedSubIds.includes(photo.subtask_id)
                if (includes && photo.status === DOWNLOADSTATUS.DOWNLOADED) {
                    this.downloadedCount++
                }
                var result = includes && (this.downloadPhotosFilter === DOWNLOAD_PHOTOS_FILTER.ALL || this.downloadPhotosFilter === photo.status) //下载状态
                return result
            })
        }

        updateUploadFilteredPhotos() {
            var choosedSubIds = this.getDownloadSubs().map((sub) => {
                return sub.id
            })
            this.uploadedCount = 0
            this.filteredUploadPhotos = this.uploadFiles.filter(photo => {
                var includes = choosedSubIds.includes(photo.subtask_id)
                if (includes && photo.status === UPLOADSTATUS.UPLOADED) {
                    this.uploadedCount++
                }
                var result = includes && (this.uploadPhotosFilter === DOWNLOAD_PHOTOS_FILTER.ALL || this.uploadPhotosFilter === photo.status) //下载状态
                return result
            })
        }

        getAlbumPhotos() {
            return this.downloadFrom === DOWNLOAD_FROM_ORIGIN ? this.originPhotos : this.retouchPhotos
        }

        getWorkPhotos() {
            var choosedSubIds = this.getDownloadSubs().map((sub) => {
                return sub.id
            })
            return this.getAlbumPhotos().filter(photo => {
                return choosedSubIds.includes(photo.subtask_id)
            })
        }

        getFirstWaitPhoto() {
            if (this.autoDownload) {
                //自动下载模式下
                for (var photo of this.getWorkPhotos()) {
                    if (photo.status === DOWNLOADSTATUS.WAITTING) {
                        return photo
                    }
                }
                return ''
            } else {
                for (var photo of this.getWorkPhotos()) {
                    if (photo.choosen && photo.status === DOWNLOADSTATUS.WAITTING) {
                        return photo
                    }
                }
                return ''
            }
        }

        getChoosenPhotos() {
            return this.getAlbumPhotos().filter((photo) => {
                return photo.choosen
            })
        }

        isDownloadAllSub() {
            return this.getDownloadSubs().length === this.subAlbums.length
        }

        isUploadAllSub() {
            return this.getUploadSubs().length === this.subAlbums.length
        }

        getDownloadSubs() {
            return this.subAlbums.filter((sub) => {
                return sub.download
            })
        }

        getUploadSubs() {
            return this.subAlbums.filter((sub) => {
                return sub.upload
            })
        }

        toggleSelectDownloadAllSub(ev) {
            if (this.isDownloadAllSub()) {
                this.subAlbums.forEach((sub) => {
                    sub.download = false
                })
            } else {
                this.subAlbums.forEach((sub) => {
                    sub.download = true
                })
            }
            this.updateDownloadFilteredPhotos()
            this.updateRecord()
        }

        cancelChooseAll() {
            this.filteredDownloadPhotos.forEach(photo => {
                photo.checked = false
            })
            this.editMode = false
        }

        cancelChooseUploadAll() {
            this.filteredUploadPhotos.forEach(photo => {
                photo.checked = false
            })
            this.editMode = false
        }

        uploadChecked() {
            this.filteredUploadPhotos.forEach(photo => {
                if (photo.checked) {
                    if (photo.status === UPLOADSTATUS.FAIL){
                        //上传失败的可以重新下载
                        photo.status = UPLOADSTATUS.WAITTING
                        photo.failCount = 0
                    }
                    photo.choosen = true
                }
            })
            this.editMode = false
        }

        chooseChecked() {
            this.filteredDownloadPhotos.forEach(photo => {
                if (photo.checked) {
                    if (photo.status === DOWNLOADSTATUS.FAIL){
                        //失败的也可以重新下载
                        photo.status = DOWNLOADSTATUS.WAITTING
                        photo.failureCount = 0
                    }
                    photo.choosen = true
                }
            })
            this.editMode = false
        }

        async initAlbumPhotos() {
            var taskDownloadPath = path.join(app.downloadpath, this.name)
            if (!fs.existsSync(taskDownloadPath)) {
                fs.mkdirSync(taskDownloadPath)
            }
            var taskUploadPath = path.join(app.uploadpath, this.name)
            if (!fs.existsSync(taskUploadPath)) {
                fs.mkdirSync(taskUploadPath)
            }

            if (this.downloadFrom === DOWNLOAD_FROM_ORIGIN){
                var taskDOpath = path.join(taskDownloadPath, '原片')
                if (!fs.existsSync(taskDOpath)) {
                    fs.mkdirSync(taskDOpath)
                }
            }else {
                var taskDRpath = path.join(taskDownloadPath, '已修片')
                if (!fs.existsSync(taskDRpath)) {
                    fs.mkdirSync(taskDRpath)
                }
            }


            //获取子相册结构，保存到album中
            await this.updateSubAlbums()

            this.originPhotos.splice(0)
            this.retouchPhotos.splice(0)
            this.uploadFiles.splice(0)

            this.getUploadRecord()

            await this.checkNewPhotos()

            console.log('initAlbumPhotos end')
        }

        getWorkUploadFiles() {
            if (this.uploadAllSub) {
                return this.uploadFiles
            } else {
                //获取当前选中的子相册id
                var id = ''
                this.subAlbums.forEach(sub => {
                    if (sub.upload) {
                        id = sub.id
                    }
                })
                //筛选子相册下的待上传照片
                return this.uploadFiles.filter(it => {
                    return it.subtask_id === id
                })
            }
        }

        getUploadRecord() {
            var transaction = mydb.transaction(TABLE_UPLOADRECORD, 'readwrite');
            transaction.oncomplete = function (event) {
            };
            transaction.onerror = function (event) {
            };
            transaction.onabort = function (event) {
            };
            var objStore = transaction.objectStore(TABLE_UPLOADRECORD);
            var index = objStore.index('albumid')
            var request = index.openCursor(IDBKeyRange.only(this.id));
            this.readedDBrecords = false
            request.onsuccess = (e) => {
                // alert(e.target.result.name +  e.target.result.age + e.target.result.email);
                console.info(e.target.result)
                var cursor = e.target.result
                if (cursor) {
                    var photo = new UploadPhoto(cursor.value)
                    this.uploadFiles.push(photo)
                    this.uploadedCount++
                    cursor.continue()
                }
                this.readedDBrecords = true
            }
            request.onerror = function (e) {
                console.error(e)
            }
        }

        /**
         * 一次最多读取一百张
         */
        parseUploadFiles() {
            var realPath = path.join(app.uploadpath, this.name)
            var fileNames = fs.readdirSync(realPath)  //所有子相册目录名

            //已读的和数据库中的
            var readedFileNames = this.uploadFiles.map(it => {
                return it.name
            })
            var maxCount = 100
            fileNames.forEach(fileName => {
                var curFileFullpath = path.join(realPath, fileName)
                var stat = fs.statSync(curFileFullpath)

                if (!stat.isDirectory()) {//如果是直接放在相册目录下的照片，上传到默认子相册
                    var nameLowercase = fileName.toLowerCase()
                    if ((nameLowercase.endsWith('.jpg') || nameLowercase.endsWith('.jpeg') || nameLowercase.endsWith('png'))
                        && !readedFileNames.includes(fileName)) {
                        //
                        if (stat.size > 0) {
                            var file = new UploadPhoto()
                            file.name = fileName
                            file.albumid = this.id
                            file.size = stat.size
                            file.localpath = curFileFullpath
                            file.subtask_id = this.getFirstSub().id
                            file.subpath = realPath
                            this.uploadFiles.push(file)
                            maxCount--
                        }
                    }
                } else {
                    //子相册, 名称必须对应，不对应的不处理
                    var subId = this.getSubIdByName(fileName)
                    if (subId.length > 0) {
                        var subFileNames = fs.readdirSync(curFileFullpath)
                        //一次最多读取一百张，防止列表太卡
                        var tempFiles = []
                        for (var i = 0; i < subFileNames.length; i++) {
                            var subFileName = subFileNames[i]
                            var nameLowercase = subFileName.toLowerCase()
                            //只检查文件名以jpg/jpeg/png后缀的
                            if ((nameLowercase.endsWith('.jpg') || nameLowercase.endsWith('.jpeg') || nameLowercase.endsWith('png'))
                                && !readedFileNames.includes(subFileName)) {
                                //
                                var curPath = path.join(curFileFullpath, subFileName)
                                stat = fs.statSync(curPath)
                                if (stat.size > 0) {
                                    var file = new UploadPhoto()
                                    file.name = subFileName
                                    file.albumid = this.id
                                    file.size = stat.size
                                    file.subtask_id = subId
                                    file.localpath = curPath
                                    file.subpath = curFileFullpath
                                    tempFiles.push(file)
                                    maxCount--
                                }
                                if (maxCount <= 0) {
                                    break
                                }
                            }
                        }
                        if (maxCount < 100){
                            //延迟一秒钟上传，防止照片未导出完毕
                            global.setTimeout(() => {
                                var readedFileNamesIme = this.uploadFiles.map(it => {return it.name})
                                tempFiles.forEach(fi => {
                                    if (!readedFileNamesIme.includes(fi.name)){
                                        this.uploadFiles.push(fi)
                                    }
                                })
                                this.updateUploadFilteredPhotos()
                            }, 2000)
                        }
                    } else {
                        Promise.resolve(this.updateSubAlbums())
                            .then(() => {
                                console.log('更新了子相册')
                                //更新了子相册，看看还有没有这个，如果还没有，就拉倒

                            })
                    }
                }
            })
        }

        hasPhotoToUpload() {
            if (this.readedDBrecords && !this.uploading) {
                if (this.autoUpload) {
                    for (var photo of this.getWorkUploadFiles()) {
                        if (photo.status === UPLOADSTATUS.WAITTING) {
                            return true
                        }
                    }
                    return false
                } else {
                    for (var photo of this.getWorkUploadFiles()) {
                        if (photo.choosen && photo.status === UPLOADSTATUS.WAITTING) {
                            return true
                        }
                    }
                    return false
                }
            }else {
                return false
            }
        }

        hasPhotoToDownload() {
            if (this.autoDownload) {
                //自动下载模式下
                for (var photo of this.getWorkPhotos()) {
                    if (photo.status === DOWNLOADSTATUS.WAITTING) {
                        return true
                    }
                }
                return false
            } else {
                var photos = this.getWorkPhotos()
                for (var photo of photos) {
                    if (photo.choosen && photo.status === DOWNLOADSTATUS.WAITTING) {
                        return true
                    }
                }
                return false
            }
        }

        getSubNameById(id) {
            for (var sub of this.subAlbums) {
                if (sub.id === id) {
                    return sub.name
                }
            }
            return ""
        }

        getFirstSub(){
            return this.subAlbums.sort((a,b) => {return a.seq - b.seq})[0]
        }

        getSubIdByName(name) {
            for (var sub of this.subAlbums) {
                if (sub.name === name) {
                    return sub.id
                }
            }
            return ""
        }

        /**
         * 递归
         */
        download() {
            this.downloadingStatus = '下载中'
            var photo = this.getFirstWaitPhoto()
            if (photo.status === DOWNLOADSTATUS.DOWNLOADING) {
                return
            }

            //目录创建
            var taskPath = path.join(app.downloadpath, this.name)
            if (!fs.existsSync(taskPath)) fs.mkdirSync(taskPath)
            var versionPath = path.join(taskPath, this.downloadFrom === DOWNLOAD_FROM_ORIGIN ? '原片' : '已修片')
            if (!fs.existsSync(versionPath)) fs.mkdirSync(versionPath)

            //检查子相册
            if (!photo.subtask_id || photo.subtask_id.length === 0) {
                photo.status = DOWNLOADSTATUS.FAIL
                this.downloadFailCount++
                console.log('此照片无子相册ID')
                global.setTimeout(looper, 1000)
                return
            }
            photo.subName = this.getSubNameById(photo.subtask_id)
            if (photo.subName.length > 0) {
                var subPath = path.join(versionPath, photo.subName)
                if (!fs.existsSync(subPath)) fs.mkdirSync(subPath)
                var photoPath = path.join(subPath, photo.file_name)
                photo.status = DOWNLOADSTATUS.DOWNLOADING
                app.download(photo.origin, photoPath, (err, result) => {
                    photo.status = DOWNLOADSTATUS.WAITTING
                    if (err) { //下载失败
                        console.log("下载失败回调: " + err)
                        photo.failureCount++
                        if (photo.failureCount <= 3) {
                            console.log(photo.file_name + ' 下载失败 ' + photo.failureCount + '，重新下载')
                        } else {
                            //失败次数过多，跳过
                            console.log(photo.file_name + ' 下载失败 ' + photo.failureCount + '，跳过')
                            // alert(photo.file_name + '下载失败次数过多, 跳过, 重启应用方可再次下载')
                            photo.status = DOWNLOADSTATUS.FAIL
                            this.downloadFailCount++
                        }
                    } else {
                        console.log(photo.file_name + ' 下载完毕')
                        photo.subpath = subPath
                        photo.localpath = photoPath
                        photo.status = DOWNLOADSTATUS.DOWNLOADED
                        this.downloadedCount++
                    }
                    global.setTimeout(looper, 1000)
                })
            } else {
                //需要重新获取子相册列表
                var e = new Event(UPDATESUBALBUM, async () => {
                    //更新子相册列表
                    await this.updateSubAlbums()
                })
                eventQueue.push(e)
                global.setTimeout(looper, 1000)
            }

        }

        /*需要在两个地方调用，1. 重新选择了相册；2、重新选择了下载来源*/
        parseDiskFiles() {
            //解析已下载照片
            var downPath = path.join(path.join(app.downloadpath, this.name), this.downloadFrom === DOWNLOAD_FROM_ORIGIN ? '原片' : '已修片')
            var files = fs.readdirSync(downPath)
            var allFileNames = this.getAlbumPhotos().map(it => {
                return it.file_name
            })
            files.forEach(file => {
                //是否是子相册
                var curFilePath = path.join(downPath, file)
                var stat = fs.statSync(curFilePath)
                //仅检查子相册下的
                if (stat.isDirectory()) {
                    //子相册
                    var childFiles = fs.readdirSync(curFilePath)
                    childFiles.forEach(childFile => {
                        //判断子相册名称是否与文件夹名称相符
                        var i = allFileNames.indexOf(childFile)
                        if (i >= 0) {
                            var photo = this.getAlbumPhotos()[i]
                            if (this.getSubNameById(photo.subtask_id) === file) {
                                var realPath = path.join(curFilePath, childFile)
                                var childStat = fs.statSync(realPath)
                                //校验完整性
                                if (childStat && childStat.size === photo.file_size) {
                                    photo.localpath = path.join(downPath, file)
                                    photo.status = DOWNLOADSTATUS.DOWNLOADED
                                    this.downloadedCount++
                                } else {
                                    //文件不完整，说明下载失败了 删除
                                    fs.unlinkSync(realPath)
                                }
                            }
                        }
                    })
                }
            })
        }

        async updateSubAlbums() {
            var res = await axios.get(getSubAlbumsUrl, {
                params: {
                    shoot_task_id: this.id,
                    token: user.token
                }
            })
            if (res.status === 200) {
                var allSubIds = this.subAlbums.map(sub => {
                    return sub.id
                })
                res.data.forEach(subdata => {
                    subdata.task_sub_name = subdata.task_sub_name.replace(/[\/:*?"<>|]/g, '')
                    subdata.task_sub_name = subdata.task_sub_name.replace('\n', ' ')
                    if (!allSubIds.includes(subdata.shoot_task_sub_id)) {
                        var subAlbum = new SubAlbum(subdata)
                        this.subAlbums.push(subAlbum)
                    }
                })
            } else {
                alert('子相册照片获取失败, 请重新选择')
            }

            this.subAlbums.forEach(sub => {
                //创建子相册文件夹
                sub.name = unescape(escape(sub.name).replace(/%00/g, ''))
                var taskUploadPath = path.join(app.uploadpath, this.name)
                var subUploadPath = path.join(taskUploadPath, sub.name)
                if (!fs.existsSync(subUploadPath)) fs.mkdirSync(subUploadPath)
            })
        }

        /**
         *
         */
        async checkNewPhotos() {
            try {
                var url = this.downloadFrom === DOWNLOAD_FROM_ORIGIN ? getPhotosUrl : getRetouchPhotosUrl
                var photos = this.downloadFrom === DOWNLOAD_FROM_ORIGIN ? this.originPhotos : this.retouchPhotos
                var curLength = photos.length
                var res = await axios.get(url, {
                    params: {
                        taskId: this.id,
                        currentPage: curLength > 0 ? 2 : 1,
                        pageSize: curLength > 0 ? curLength : 10000,
                        token: user.token,
                    }
                })
                console.log("checkNewPhotos res: " + res)
                if (res.status === 200) {
                    if (res.data.photos.length > 0) {
                        res.data.photos.forEach(photo => {
                            var p = new DownloadPhoto(photo)
                            photos.push(p)
                        })
                        var allSubIds = this.subAlbums.map(it => {return it.id})
                        photos.forEach(file => {
                            if (!file.file_name && file.photo_key) {
                                file.file_name = file.photo_key.toLowerCase().replace('.jpg', '') + '.jpg'
                            }
                            //检查子相册是否存在
                            if (!allSubIds.includes(file.subtask_id)){
                                //需要刷新子相册
                                Promise.resolve(this.updateSubAlbums()).then(() => {
                                    console.log('新照片属于新的子相册，子相册列表已刷新')
                                    this.updateDownloadFilteredPhotos()
                                })
                            }
                        })
                        if (curLength === 0) {
                            this.parseDiskFiles()
                        }
                        this.updateDownloadFilteredPhotos()
                        console.log(this.name + ' 任务新照片已获取, count: ' + res.data.count)
                    } else {
                        //还没有新照片
                        app.downloadingStatus = '检测中'
                    }
                } else {
                    alert('相册照片获取失败, 请重新选择, 错误代码: ' + res.status)
                }
            } catch (err) {
                if (err.response && err.response.status === 403) {
                    //token失效
                    needLogin()
                } else {
                    //可能 502
                    // global.setTimeout(looper, eventTimeInterval)
                    showToast('检测失败: code[795] ' + (err && err.message))
                }
            }
        }

        upload(file, token) {
            var config = {useCdnDomain: true}
            var putExtra = {fname: file.name}
            var fileData = fs.readFileSync(file.localpath)
            this.uploading = true
            //读取exif信息
            readExifDate(fileData, (exifData)=>{
                //生成key
                var album = this
                //key生成使用子相册名称或相册名称+文件名, 防止重复
                var key = `${file.subtask_id ? file.subtask_id : album.id}_${file.name}`
                var observable = qiniu.upload(new Blob([fileData]), key, token, putExtra, config)
                var observer = {
                    next(res) {
                        file.progress = res.total.loaded
                    },
                    error(err) {
                        file.failCount++
                        if (file.failCount > 3){
                            file.status = UPLOADSTATUS.FAIL
                            album.uploadFailCount++
                        }
                        album.uploading = false
                    },
                    complete(res) {
                        //上传到服务器
                        var params = {
                            token: user.token,
                            taskId: album.id,
                            name: file.name,
                            size: file.size,
                            hash: res.hash,
                            key: res.key,
                        }
                        if (file.subtask_id) {
                            params.shoot_task_sub_id = file.subtask_id
                        }

                        //绑定原片ID
                        if (album.uploadTo === DOWNLOAD_FROM_RETOUCH){
                            for(var oriPhoto of album.originPhotos){
                                if (oriPhoto.file_name.toLowerCase() === file.name.toLowerCase()){
                                    params.photo_id = oriPhoto.id
                                    break
                                }
                            }
                        }

                        //获取拍摄事件
                        if (exifData.exif && exifData.exif.DateTimeOriginal){
                            var timeMillisStr = exifData.exif.DateTimeOriginal.replace(':', '-').replace(':', '-')
                            var timeMillis = new Date(timeMillisStr).getTime()
                            params.shootTime = timeMillis
                        }

                        var url = album.uploadTo === DOWNLOAD_FROM_ORIGIN ? uploadOriginPhotoUrl : uploadPhotoUrl
                        axios.post(url, params).then(res => {
                            album.uploading = false
                            file.status = UPLOADSTATUS.UPLOADED
                            album.uploadedCount++
                            file.id = album.id + '-' + file.name
                            file.thumbnail = res.data.url_thumbnail
                            if (album.autoDeleteUploadedFile) {
                                //自动删除原文件
                                fs.unlinkSync(file.localpath)
                                // var index = album.uploadFiles.indexOf(file)
                                // album.uploadFiles.splice(index, 1)
                            }
                            insertUploadRecord(file)
                        }).catch(err => {
                            //上传成功，报告服务器失败
                            file.failCount++
                            if (file.failCount > 3){
                                file.status = UPLOADSTATUS.FAIL
                                album.uploadFailCount++
                                showToast('上传失败: code[874] ' + (err && err.message))
                            }
                            album.uploading = false
                            console.log('上传成功，提交到xxpie服务器失败')
                        })
                    },
                }
                file.subscription = observable.subscribe(observer)
            })
        }

        getFirstWaitingUploadFile(){
            var activeSubId = ''
            for (var sub of this.subAlbums){
                if (sub.upload){
                    activeSubId = sub.id
                    break
                }
            }
            if (this.autoUpload){
                for (var photo of this.uploadFiles){
                    if ((this.uploadAllSub || photo.subtask_id === activeSubId) && photo.status === UPLOADSTATUS.WAITTING)
                        return photo
                }
                return ''
            }else {
                for (var photo of this.uploadFiles){
                    if (photo.choosen && (this.uploadAllSub || photo.subtask_id === activeSubId) && photo.status === UPLOADSTATUS.WAITTING)
                        return photo
                }
                return ''
            }
        }

        startUpload() {
            var readyFile = this.getFirstWaitingUploadFile()
            if (readyFile) {
                axios.get(getQiqiuTokenUrl, {
                    params: {token: user.token}
                }).then(res => {
                    console.log('上传： ' + readyFile.name)
                    this.upload(readyFile, res.data.token)
                }).catch(err => {
                    console.error('获取七牛token失败' + err)
                    showToast('上传失败: code[918] ' + (err && err.message))
                })
            }
        }
    }

    var dbName = 'xxpiepc'
    var CHANGEALBUM = 1,
        CHANGEFROM = 2,
        CHANGEMODE = 3,
        UPDATESUBALBUM = 4,

        AUTO_UPLOAD = 0,

        AUTO_DOWNLOAD = 0,

        DOWNLOAD_FROM_ORIGIN = 1,
        DOWNLOAD_FROM_RETOUCH = 2

    var avatar = "./static/pic_head_100.png"
    var userAvatarUrl = localStorage.getItem('icon_photo_url')
    if (userAvatarUrl && userAvatarUrl.length > 0 && 'null' !== userAvatarUrl) {
        avatar = userAvatarUrl
    }
    var user = {
        avatar: avatar,
        token: localStorage.getItem('token'),
        sys_user_id: localStorage.getItem('sys_user_id'),
        name: localStorage.getItem('nick_name')
    };

    //创建目录
    //目录可能创建失败，而且有可能是外置移动硬盘，如果该路径不存在，直接恢复默认的
    if (!fs.existsSync(downloadpath)) {
        try{
            fs.mkdirSync(downloadpath)
        }catch (err){
            downloadpath = path.join(gui.App.dataPath, 'xxpie_download')
            localStorage.setItem('downloadpath', downloadpath)
        }
    }
    if (!fs.existsSync(uploadpath)) {
        try {
            fs.mkdirSync(uploadpath)
        }catch (err){
            uploadpath = path.join(gui.App.dataPath, 'xxpie_upload')
            localStorage.setItem('uploadpath', uploadpath)
        }

    }
    var needLogin = () => {
        localStorage.removeItem('token')
        gui.Window.open('./index.html', {
            "position": "center",
            "width": 286,
            "height": 354,
            "resizable": false,
            "icon": "static/ic_desktop_start3.png",
            "id": "login",
        }, () => {
            win.close()
        });
    }

    var eventQueue = []
    var eventTimeInterval = 1000 //怠速1000, 下载速10

    var downloadVars = {
        downloadFrom: DOWNLOAD_FROM_ORIGIN,
        downloadMode: AUTO_DOWNLOAD,
    }

    var app = new Vue({
        el: '#root',
        data: {
            user: user,
            albums: [],
            album: '',
            loading: false,
            system: os.type,
            downloadpath: downloadpath, //这里的path不包含任务名称和来源(原片还是已修片),使用时要先join任务名称和来源
            uploadpath: uploadpath, //这里的path不包含任务名称和来源，使用时要先join任务名称和来源

            DOWNLOADSTATUS: DOWNLOADSTATUS,
            UPLOADSTATUS: UPLOADSTATUS,
            DOWNLOAD_PHOTOS_FILTER: DOWNLOAD_PHOTOS_FILTER,

            DOWNLOAD_FROM_ORIGIN: DOWNLOAD_FROM_ORIGIN,
            DOWNLOAD_FROM_RETOUCH: DOWNLOAD_FROM_RETOUCH,

            uploadMode: AUTO_UPLOAD,
            uploadModeTxt: '自动上传',

            showDownloadSrcSelector: false,
            showDownloadSubSelector: false,
            showDownloadPhotosFilter: false,
            showUploadModeSelector: false,
            showUserinfoDialog: false,
            showContactDialog: false,
            needManualDownloadCount: 0,
            downloadingStatus: '下载中',
            shouldShowGuid: shouldShowGuide,
            splashStep: 1,
            toast: '',
            toastId: '',
            hideToastTimeout: ()=> {
                app.toast = ''
                app.toastId = ''
            },

            showSelectorEventListener: () => {
                app.showDownloadSubSelector = false
                app.showDownloadSrcSelector = false
                app.showUploadModeSelector = false
                app.showDownloadPhotosFilter = false
                app.showUserinfoDialog = false
                app.showContactDialog = false
                window.removeEventListener('click', app.showSelectorEventListener)
            },
        },
        watch: {
            downloadpath: (path) => {
                console.log('downloadpath changed: ' + path)
            },

            showDownloadSrcSelector: (val) => {
                if (val) {
                    window.addEventListener('click', app.showSelectorEventListener)
                }
            },
            showDownloadPhotosFilter: (val) => {
                if (val) {
                    window.addEventListener('click', app.showSelectorEventListener)
                }
            },
            showDownloadSubSelector: (val) => {
                if (val) {
                    window.addEventListener('click', app.showSelectorEventListener)
                }
            },
            showUploadModeSelector: (val) => {
                if (val) {
                    window.addEventListener('click', app.showSelectorEventListener)
                }
            },
            showUserinfoDialog: (val) => {
                if (val) {
                    window.addEventListener('click', app.showSelectorEventListener)
                }
            },
            showContactDialog: (val) => {
                if (val) {
                    window.addEventListener('click', app.showSelectorEventListener)
                }
            },
        },
        methods: {
            chooseAlbum: function () {
                global.albums = app.albums
                //打开选择相册窗口
                gui.Window.open('./albumlist.html', {
                    position: "center",
                    width: 736,
                    height: 580,
                    min_width: 736,
                    min_height: 580,
                    max_width: 736,
                    // frame: false,
                    id: 'albumlist'
                }, function (newWin) {
                    console.log('new window loaded')
                });
            },
            showTip: (type, tip) => {
                // type: 1 下载提示 2 上传提示
                // alert('设置下载目录用来存放所有同步下载的相册照片。')
                var height = 131;
                if (type === 1) {
                    global.tip = {
                        title: '下载目录',
                        msg: '应用将自动在此文件夹下创建以相册和子相册名称命名的文件夹，无须自行创建。仅需设置一次，路径将自动保存。',
                        showCancel: false,
                        confirmText: '好',
                    }
                    height = 165
                } else if (type === 2) {
                    global.tip = {
                        title: '上传目录',
                        msg: '选择相册后，应用将在此文件夹下自动创建以相册和子相册名称命名的文件夹，将待上传照片拷贝至子相册文件夹下，即可开始上传。仅需设置一次，应用将自动保存。',
                        showCancel: false,
                        confirmText: '好',
                    }
                    height = 165
                } else if (type === 3) {
                    global.tip = tip
                }
                if (tip.height){
                    height = tip.height
                }
                gui.Window.open('./tipwindow.html', {
                    position: "center",
                    width: 420,
                    height: height,
                    min_width: 420,
                    min_height: height,
                    max_width: 420,
                    max_height: height,
                    id: 'tip'
                });
            },

            changeDownloadPath: (p) => {
                if (p !== app.uploadpath) {
                    if (app.albums.length > 0) {
                        var e = new Event(CHANGEFROM, async () => {
                            app.downloadpath = p
                            //更新albums和downloadedPhotos
                            for (var cAlbum of app.albums) {
                                var taskDownloadPath = path.join(app.downloadpath, cAlbum.name)
                                if (!fs.existsSync(taskDownloadPath)) {
                                    fs.mkdirSync(taskDownloadPath)
                                }

                                var taskDOpath = path.join(taskDownloadPath, '原片')
                                if (downloadVars.downloadFrom === DOWNLOAD_FROM_ORIGIN) {
                                    if (!fs.existsSync(taskDOpath)) {
                                        fs.mkdirSync(taskDOpath)
                                    }
                                } else {
                                    var taskDRpath = path.join(taskDownloadPath, '已修片')
                                    if (!fs.existsSync(taskDRpath)) {
                                        fs.mkdirSync(taskDRpath)
                                    }
                                }

                                await cAlbum.initAlbumPhotos()
                            }
                        })
                        eventQueue.push(e)
                    } else {
                        app.downloadpath = p
                    }
                } else {
                    app.showTip(3, {
                        title: '',
                        msg: '下载目录和上传目录相同, 请重新选择',
                        showCancel: false,
                        confirmText: '好',
                    })
                }
            },
            changeUploadPath: (p) => {
                if (p !== app.downloadpath) {
                    //如果已经选择了任务，初始化任务目录
                    if (app.album.id) {
                        var e = new Event(CHANGEFROM, async () => {
                            app.uploadpath = p

                            //更新albums和downloadedPhotos
                            for (var cAlbum of app.albums) {
                                var taskUploadPath = path.join(app.uploadpath, cAlbum.name)
                                if (!fs.existsSync(taskUploadPath)) {
                                    fs.mkdirSync(taskUploadPath)
                                }
                                await cAlbum.initAlbumPhotos()
                            }
                        })
                        eventQueue.push(e)
                    }else {
                        app.uploadpath = p
                    }
                } else {
                    app.showTip(3, {
                        title: '',
                        msg: '下载目录和上传目录相同, 请重新选择',
                        showCancel: false,
                        confirmText: '好',
                    })
                }
            },
            openPath: (p) => {
                //当前任务名称
                if (os.type == 'Darwin') {
                    if (app.album.name) {
                        if (p == app.downloadpath) { //下载路径
                            if (app.album.downloadFrom === DOWNLOAD_FROM_ORIGIN) {
                                downloadOriginPath = path.join(path.join(p, app.album.name), '原片')
                                childprocess.exec('open "' + downloadOriginPath + '"')
                            } else {
                                downloadRetouchPath = path.join(path.join(p, app.album.name), '已修片')
                                childprocess.exec('open "' + downloadRetouchPath + '"')
                            }
                        }else { //上传路径
                            uploadPath = path.join(p, app.album.name)
                            childprocess.exec('open "' + uploadPath + '"')
                        }
                    } else {
                        childprocess.exec('open "' + p + '"')
                    }
                } else if (os.type == 'Windows_NT') {
                    if (app.album.name) {
                        if (p == app.downloadpath) { //下载路径
                            if (app.album.downloadFrom === DOWNLOAD_FROM_ORIGIN) {
                                downloadOriginPath = path.join(path.join(p, app.album.name), '原片')
                                childprocess.exec('explorer.exe "' + downloadOriginPath + '"')
                            } else {
                                downloadRetouchPath = path.join(path.join(p, app.album.name), '已修片')
                                childprocess.exec('explorer.exe "' + downloadRetouchPath + '"')
                            }
                        }else {
                            uploadPath = path.join(p, app.album.name)
                            childprocess.exec('explorer.exe "' + uploadPath + '"')
                        }
                    } else {
                        childprocess.exec('explorer.exe "' + p + '"')
                    }
                } else {
                    alert("未识别的系统类型, 请联系客服人员获得帮助: 微信: xxpie_service; 系统类型: " + os.type)
                }
            },
            logout: () => {
                localStorage.removeItem('icon_photo_key')
                localStorage.removeItem('icon_photo_url')
                localStorage.removeItem('mobile_number')
                localStorage.removeItem('nick_name')
                localStorage.removeItem('sys_user_id')
                needLogin()
            },
            download: (url, localPath, subCallback) => {
                console.log('开始下载' + localPath)
                var errOccur = false
                var file = ''
                var request = http.get(url, response => {
                    console.log('收到回复' + localPath + " status: " + response.statusCode)
                    file = fs.createWriteStream(localPath);
                    response.pipe(file);
                    response.on('error', () => {
                        console.log('下载失败: response pipe err')
                        errOccur = true
                        // fs.unlinkSync(localPath)
                        subCallback('response pipe err')
                    })

                    file.on('finish', function () {
                        console.log('下载完毕: file finish' + errOccur)
                        if (!errOccur) {
                            subCallback()
                        }else{
                            // fs.unlinkSync(localPath)
                        }
                    })
                    file.on('error', err => {
                        console.log('下载失败: file write err')
                        errOccur = true
                        // fs.unlinkSync(localPath)
                        subCallback(err.message)
                    })
                }, (err) => {
                    console.log('下载失败: http get err')
                    errOccur = true
                    subCallback(err.message)
                    // fs.unlinkSync(localPath)
                    subCallback(err.message)
                });
                console.log('set timeout ==> 2000')
                request.setTimeout(2000, () => {
                    console.log('下载失败: request time out')
                    // fs.unlinkSync(localPath)
                    if (file){
                        try {file.closeSync()}
                        catch (err){console.log(err.message)}
                    }
                    if (!errOccur){
                        errOccur = true
                        subCallback('timeout')
                    }
                })
                request.on('error', err => {
                    console.log('下载失败: request err')
                    // fs.unlinkSync(localPath)
                    if (file){
                        try {file.closeSync()}
                        catch (err){console.log(err.message)}
                    }
                    if (!errOccur){
                        errOccur = true
                        subCallback(err.message)
                    }
                })
                request.end()
                console.log('start request')
            },
            /*
            如何保存下载进度？
            1. 再次进入应用时，无法判断任务相册中的照片是原片还是精修片，需要再分一层目录(原片、已修片)，此时可读取已下载，对比得到下载进度
            2. localStorage保存，不可取，无法得知目录真实状态,因为无法区分原片和已修片
             */
            manualDownload: () => {
                var e = new Event(CHANGEMODE, async () => {
                    app.needManualDownloadCount += app.manualDownloadCount
                })
                eventQueue.push(e)
            },
            autoDownload: () => {
                //如果文件夹内有照片, 提示用户会清空原有照片
            },
            parseSize: (size) => {
                var result = 0.0
                if(size < 1024){
                    result = size.toFixed(2) + 'B'
                }else if(size < 1024 * 1024)
                    result = (size / 1024).toFixed(2) + 'KB'
                else if(size < 1024 * 1024 * 1024)
                    result = (size / (1024 * 1024)).toFixed(2) + 'MB'
                else if(size < 1024 * 1024 * 1024 * 1024)
                    result = (size / (1024 * 1024 * 1024 * 1024)).toFixed(2) + 'GB'
                else
                    result = size + 'B';
                return result
            },
            openImage: (photo) => {
                if (app.album.editMode){
                    photo.checked = true
                }else if (photo.subpath) {
                    if (os.type == 'Darwin') {
                        childprocess.exec('open ' + photo.subpath)
                    } else if (os.type == 'Windows_NT') {
                        //直接打开文件会被360拦截，统一改为打开目录
                        childprocess.exec('explorer.exe ' + photo.subpath)
                    } else {
                        console.log('未知系统类型, 请联系客服提供帮助 os type: ' + os.type)
                    }
                }
            },
            openImageInFinder: (photo) => {

            },
            quit: (index, album) => {
                //确认结束任务？
                app.showTip(3, {
                    title: '退出任务提示',
                    msg: '退出任务后，该相册正在下载和上传的文件将会停止，是否确认结束？',
                    showCancel: true,
                    confirmText: '确定',
                    confirmCallback: ()=>{
                        //确认结束
                        console.log('结束任务: ' + index + '  ' + album.id)
                        app.albums.splice(index, 1)
                        if (app.album == album){
                            if (app.albums.length > 0){
                                app.album = app.albums[0]
                            }else {
                                app.album = ''
                            }
                        }
                        //删除数据库记录
                        removeAlbumRecord(album.id)
                    }
                })
            },
            openSetting: () => {
                gui.Window.open('./setting.html', {
                    position: "center",
                    width: 420,
                    height: 241,
                    min_width: 420,
                    min_height: 241,
                    max_width: 420,
                    max_height: 241,
                    id: 'setting'
                }, function (newWin) {
                    console.log('new window loaded')
                });
            },
            quitGuide: () => {
                //关闭引导页
                window.removeEventListener('click', splashStepListener)
                app.shouldShowGuid = false

                localStorage.setItem('displayedGuidev2.0.0', true)

                app.showTip(3, {
                    title: '提示',
                    msg: '由于本应用下载及上传需操作大量文件, 可能会被安全卫士或WindowsDefender误报并拦截, 请您在发生此情况时选择允许本助手执行操作, 感谢您的理解',
                    showCancel: false,
                    confirmText: '好',
                    height: 165,
                })
            },
        }
    })

    var readExifDate = (data, callback) => {
        // return exif
        // EXIF.getData(new Blob(data), function () {
        //     EXIF.getAllTags()
        // })
        ExifImage.ExifImage(data, (err, exifData)=> {
            if (err){
                console.log('Error: ' + err.message);
                callback({})
            }
            else{
                // console.log(exifData);
                callback(exifData)
            }

        })
    }

    const EventEmitter = require('events');

    const myEmitter = new EventEmitter();

    var showToast = (t) => {
        if (app.toastId){
            global.clearTimeout(app.toastId)
            app.toast = t
            app.toastId = global.setTimeout(app.hideToastTimeout, 2000)
        }else {
            app.toast = t
            app.toastId = global.setTimeout(app.hideToastTimeout, 2000)
        }
    }

    myEmitter.on('choosedAlbum', (albums) => {
        choosenAlbumIds = app.albums.map(it => {return it.id})
        albums = albums.filter(it => {return !choosenAlbumIds.includes(it.id)})
        var changeAlbumEvent = new Event(CHANGEALBUM, async () => {
            albums.forEach((album) => {
                album.name = album.name.replace(/[\/:*?"<>|]/g, '')
                album.name = album.name.replace('\n', '')
                album.downloadFrom = DOWNLOAD_FROM_ORIGIN

                //初始化albums的默认设置： 子相册列表->全部子相册原片照片->初始化
                //存储到数据库
                var albumObject = new Album(album)
                insertALbumRecord(albumObject)

                //加入参与上传
                var uploadParam = {
                    token: user.token,
                    invitationCode: albumObject.invitation_code,
                }

                //相册准备完毕
                var loaded = ()=> {
                    console.log('相册已初始化, 添加到列表中')
                    // getUploadRecord(app.album.id)
                    app.albums.push(albumObject)
                    if (!app.album) {
                        app.album = albumObject
                    }

                    if (app.shouldShowGuid) {
                        app.splashStep = 2
                        window.addEventListener('click', splashStepListener)
                    }
                }

                var futu = Promise.resolve(albumObject.initAlbumPhotos())
                if (album.create_by !== user.sys_user_id){
                    futu = futu.then(axios.post(joinTaskUrl, uploadParam))
                }
                futu.then((res) => { loaded() })
                    .catch(err => {
                        if (err && err.response &&  err.response.data && err.response.data.code === 1005){
                            loaded()
                        }else {
                            console.error(err)
                            showToast('相册初始化失败: code[1485] ' + (err && err.message))
                        }
                    })
            })
            console.log('choosen albums size: ' + albums.length);
        })
        eventQueue.push(changeAlbumEvent)
    });

    myEmitter.on('changeDownloadPath', (path) => {
        app.changeDownloadPath(path)
    })

    myEmitter.on('changeUploadPath', (path) => {
        app.changeUploadPath(path)
    })

    //接收其他页面token失效事件
    myEmitter.on('tokenInvalid', () => {
        needLogin()
    })

    //1、打开或创建数据库
    //1.0版本 保存上传记录
    //2.0版本 保存已选相册记录
    request=window.indexedDB.open('xxpiepc','2.0');//参数为：数据库名和版本号；数据库存在，则打开它；否则创建。

    var insertUploadRecord = (record) => {
        var transaction = window.mydb.transaction(TABLE_UPLOADRECORD, 'readwrite')
        var objectStore = transaction.objectStore(TABLE_UPLOADRECORD, 'readwrite')
        var newRecord = record
        newRecord.subscription = ''
        newRecord.checked = false
        newRecord.choosen = false
        var r = objectStore.add(newRecord)
        r.onsuccess = (e) => {
            // alert("成功插入数据，id=" + e.target.result);
            console.info(e.target.result)
        }
        r.onerror = (e) => {
            console.error('插入上传记录失败: ' + e)
        }
    }

    var insertALbumRecord = (record) => {
        var newAlbum = new Album(record)
        newAlbum.originPhotos = []
        newAlbum.retouchPhotos = []
        newAlbum.filteredDownloadPhotos = []
        newAlbum.filteredUploadPhotos = []
        newAlbum.uploadFiles = []
        newAlbum.subAlbums = []

        var transaction = window.mydb.transaction(TABLE_CHOOSENALBUM, 'readwrite')
        var objectStore = transaction.objectStore(TABLE_CHOOSENALBUM, 'readwrite')
        var r = objectStore.add(newAlbum)
        r.onsuccess = (e) => {
            // alert("成功插入数据，id=" + e.target.result);
            console.info(e.target.result)
        }
    }

    var updateALbumRecord = (album) => {
        var newAlbum = new Album(album)
        newAlbum.originPhotos = []
        newAlbum.retouchPhotos = []
        newAlbum.filteredDownloadPhotos = []
        newAlbum.filteredUploadPhotos = []
        newAlbum.uploadFiles = []
        newAlbum.subAlbums = []

        var request = mydb.transaction(TABLE_CHOOSENALBUM, 'readwrite')
            .objectStore(TABLE_CHOOSENALBUM)
            .put(newAlbum)

        request.onsuccess = function(e){
            console.info('数据库记录更新成功：' + album)
        }
        request.onerror = function (e) {
            console.error('数据库记录更新失败: ' + album)
        }
    }

    var removeAlbumRecord = (id) => {
        var transaction = mydb.transaction(TABLE_CHOOSENALBUM,'readwrite');
        transaction.oncomplete = function(event) {};
        transaction.onerror = function(event) {};
        transaction.onabort = function(event){};
        var objStore = transaction.objectStore(TABLE_CHOOSENALBUM);
        var request = objStore.delete(id);
        request.onsuccess = function(e){
            console.info(e.target.result)
        }
        request.onerror = function (e) {
            console.error(e)
        }
    }
    /**
     * 保存已选择相册
     */
    var getAllAlbumRecord = () => {
        var transaction = mydb.transaction(TABLE_CHOOSENALBUM,'readwrite');
        transaction.oncomplete = function(event) {};
        transaction.onerror = function(event) {};
        transaction.onabort = function(event){};
        var objStore = transaction.objectStore(TABLE_CHOOSENALBUM);
        var request = objStore.openCursor();
        readedDBrecords = false
        request.onsuccess = function(e){
            // alert(e.target.result.name +  e.target.result.age + e.target.result.email);
            console.info(e.target.result)
            cursor = e.target.result
            if(cursor){
                //解析出Album
                var albumObject = new Album(cursor.value)
                console.log('检测出的album ownedBy: ' + albumObject.ownedBy + '  当前用户：' + user.sys_user_id)
                if (albumObject.ownedBy === user.sys_user_id) {
                    Promise.resolve(albumObject.initAlbumPhotos()).then(() => {
                        //此相册已初始化
                        console.log('相册已初始化, 添加到列表中')
                        // getUploadRecord(app.album.id)
                        app.albums.push(albumObject)
                        if (!app.album)
                            app.album = albumObject
                    })
                }
                cursor.continue()
            }
            readedDBrecords = true
        }
        request.onerror = function (e) {
            console.error(e)
        }
    }

    //2、指定操作成功的处理函数(可以获得对象存储空间信息)
    request.onsuccess=function(event){
        window.mydb=request.result;
        mydb = window.mydb
        //var len = mydb.objectStoreNames.length;                 //对象存储空间名的个数
        //var  name=mydb.objectStoreNames[i];                     //对象存储空间名

        getAllAlbumRecord()

        //todo 解析已上传照片
        // if (app.album.id){
        //     getUploadRecord(app.album.id)
        // }
    };
    request.onupgradeneeded = function(event) {
        mydb = event.target.result;
        if(!mydb.objectStoreNames.contains(TABLE_UPLOADRECORD)) {                   //判断对象存储空间名称是否已经存在
            var objectStore = mydb.createObjectStore(TABLE_UPLOADRECORD, {keyPath: "id"});//指定keyPath选项为id（即主键为id）
            //对象存储空间students的列email上创建一个唯一索引email,可以创建多个索引。
            objectStore.createIndex("albumid",                                //索引名
                "albumid",                                //创建索引的列（即keyPath,索引属性字段名）
                { unique: false });                      //索引选项(索引属性值是否唯一:true or false)
        }
        if (!mydb.objectStoreNames.contains(TABLE_CHOOSENALBUM)){
            var objectStore = mydb.createObjectStore(TABLE_CHOOSENALBUM, {keyPath: 'id'});
            objectStore.createIndex('id','id', {unique: false});
        }
    };

    global.emitter = myEmitter

    var loopUpload = () => {
        if (!app.album){return}
        if (app.album.hasPhotoToUpload()){
            app.album.startUpload()
        }else {
            app.album.parseUploadFiles()

            var otherAlbums = app.albums.filter(photo => {return photo != app.album})
            otherAlbums.forEach(alb =>{
                if (alb.hasPhotoToUpload()){
                    alb.startUpload()
                }else {
                    alb.parseUploadFiles()
                }
            })
        }
    }

    //优先下载当前选中的，没有可下载的照片时下载其他相册的照片，都要检测新照片
    var loopDownload = () => {
        if (app.album && app.album.subAlbums.length > 0) {
            if (app.album.hasPhotoToDownload()) {
                //异步执行
                app.album.download()
            } else {
                app.album.downloadingStatus = '检测中'
                Promise.resolve(app.album.checkNewPhotos())
                    .then(() => {
                        console.log(app.album.name + ' 检测新照片结束')
                        //如果还有其他相册待处理，这里就不等了
                        if (app.albums.length > 1) {
                            //其他相册统一判断，有要下载的就下载
                            var hasDownload = false
                            var otherAlbums = app.albums.filter(photo => {return photo != app.album})
                            for (var item of otherAlbums) {
                                if (item.hasPhotoToDownload()) {
                                    //其他相册有照片要下载
                                    item.download()
                                    hasDownload = true
                                    break
                                }
                            }
                            if (!hasDownload){
                                //全部没有待下载, 意味着没有递归
                                Promise.all(otherAlbums.map(alb => {return alb.checkNewPhotos()}))
                                    .then(() => {
                                        console.log('其他相册检测新照片结束')
                                        global.setTimeout(looper, eventTimeInterval)
                                    })
                                    .catch((err) => {
                                        global.setTimeout(looper, eventTimeInterval)
                                    })
                            }
                        }else {
                            global.setTimeout(looper, eventTimeInterval)
                        }
                    })
                    .catch((err) => {
                        console.log(app.album.name + ' 检测新照片失败')
                        showToast('上传失败: code[1708] ' + (err && err.message))
                        global.setTimeout(looper, eventTimeInterval)
                    })
            }
        }else {
            global.setTimeout(looper, eventTimeInterval)
        }
    }

    //todo 获取数据库中的任务列表

    //开启事件执行
    var looper = () => {
        //处理事件
        /*
        切换相册
         */
        console.log('eventQueue length: ' + eventQueue.length)
        if (eventQueue.length > 0){
            var p = Promise.all(eventQueue.map(e => {return e.exec()}))
            p.then(loopDownload)
            p.catch((err) => {
                console.log('err occured')
                showToast('下载失败: code[1731] ' + (err && err.message))
                loopDownload()
            })
            eventQueue.splice(0)
        }else {
            loopDownload()
        }
        //解析待上传文件
        loopUpload()
    }
    global.setTimeout(looper, 1000)
})()