(function () {
    var currentVersionCode = 5
    var versionName = '2.0.3'
    var gui = require('nw.gui')
    var os = require('os')
    var path = require('path')
    var childprocess = require('child_process')
    var win = gui.Window.get()
    win.setAlwaysOnTop(true)

    var dpath = localStorage.getItem('downloadpath')
    var upath = localStorage.getItem('uploadpath')
    var odownloadpath = dpath ? dpath : path.join(gui.App.dataPath, 'xxpie_download')
    var ouploadpath = upath ? upath : path.join(gui.App.dataPath, 'xxpie_upload')

    var baseUrl = "https://api.xxpie.com",//"https://int2.xxpie.com",//
        checkVersionUrl = baseUrl + '/api/ps/mine/getPCPluginVersion'

    var app = new Vue({
        el: '#root',
        data: {
            page: 1,
            downloadpath: odownloadpath,
            uploadpath: ouploadpath,
            hasNewVersion: false,
            versionName: versionName,
            newVersionUrl: '',
            newVersionName: '',
        },
        methods: {
            checkVersion: ()=> {
                var platform = os.type == 'Darwin' ? 'PC_MAC' : 'PC_WIN'
                axios.get(checkVersionUrl,  {
                    params: {platform: platform}
                }).then((res)=> {
                    /*
                    version_name
                    version_code
                    version_url
                     */
                    if (res.status === 200 && res.data.version_code > currentVersionCode){
                        //有更新
                        app.newVersionUrl = res.data.version_url
                        app.newVersionName = res.data.version_name
                        app.hasNewVersion = true
                    }else {
                        app.hasNewVersion = false
                    }
                }).catch(()=> {
                    app.hasNewVersion = false
                })
            },
            changeDownloadPath: (event) => {
                if (event && event.target && event.target.files && event.target.files.length > 0){
                    p = event.target.files[0].path
                    if (p != app.uploadpath){
                        app.downloadpath = p
                    }else {
                        app.showTip(3, {
                            title: '',
                            msg: '下载目录和上传目录相同, 请重新选择',
                            showCancel: false,
                            confirmText: '好',
                        })
                    }
                }
            },
            cancelDownloadPath: () => {
                app.downloadpath = odownloadpath
                win.close()
            },
            cancelUploadPath: () => {
                app.uploadpath = ouploadpath
                win.close()
            },
            confirmDownloadPath: () => {
                if (app.downloadpath !== odownloadpath) {
                    localStorage.setItem('downloadpath', app.downloadpath)
                    //通知main window
                    global.emitter.emit('changeDownloadPath', app.downloadpath)
                    odownloadpath = app.downloadpath
                }
                win.close()
            },
            changeUploadPath: (event) => {
                p = event.target.files[0].path
                if (event && event.target && event.target.files && event.target.files.length > 0){
                    p = event.target.files[0].path
                    if (p != app.downloadpath){
                        app.uploadpath = p
                    }else {
                        app.showTip(3, {
                            title: '',
                            msg: '下载目录和上传目录相同, 请重新选择',
                            showCancel: false,
                            confirmText: '好',
                        })
                    }
                }
            },
            confirmUploadPath: () => {
                if (app.uploadpath !== ouploadpath){
                    localStorage.setItem('uploadpath', app.uploadpath)
                    //通知main window
                    global.emitter.emit('changeUploadPath', app.uploadpath)
                    ouploadpath = app.uploadpath
                }
                win.close()
            },
            downloadNewVersion: ()=> {
                //下载新版
                if (app.newVersionUrl){
                    //如何自动安装

                }
            },
            openPath: (p) => {
                if (os.type == 'Darwin') {
                    childprocess.exec('open "' + p + '"')
                } else if (os.type == 'Windows_NT') {
                    childprocess.exec('explorer.exe "' + p + '"')
                } else {
                    alert("未识别的系统类型, 请联系客服人员获得帮助: 微信: xxpie_service; 系统类型: " + os.type)
                }
            },
            showTip: (type, tip) => {
                // type: 1 下载提示 2 上传提示
                // alert('设置下载目录用来存放所有同步下载的相册照片。')
                var height = 131;
                if (type === 1) {
                    global.tip = {
                        title: '下载目录',
                        msg: '应用将自动在此文件夹下创建以相册和子相册名称命名的文件夹，无须自行创建。仅需设置一次，路径将自动保存。',
                        showCancel: false,
                        confirmText: '好',
                    }
                    height = 165
                } else if (type === 2) {
                    global.tip = {
                        title: '上传目录',
                        msg: '选择相册后，应用将在此文件夹下自动创建以相册和子相册名称命名的文件夹，将待上传照片拷贝至子相册文件夹下，即可开始上传。仅需设置一次，应用将自动保存。',
                        showCancel: false,
                        confirmText: '好',
                    }
                    height = 165
                } else if (type === 3) {
                    global.tip = tip
                }
                gui.Window.open('./tipwindow.html', {
                    position: "center",
                    width: 420,
                    height: height,
                    min_width: 420,
                    min_height: height,
                    max_width: 420,
                    max_height: height,
                    id: 'tip'
                });
            },
            openInBrowser: ()=> {
                gui.Shell.openExternal("https://www.xxpie.com/downloads.html?page=downloadPCAssistant.html");
            }
        }
    })
    app.checkVersion()
})()