[CREATE TABLE]
CREATE TABLE ca_ctr
(
	centerno	VARCHAR(20) NOT NULL,
	ctname	VARCHAR(64),
	lsign		SMALLINT,
	cttype	VARCHAR(4),
	iszy		SMALLINT,
	zybm		VARCHAR(20),
	allrate	DECIMAL(18,8)
);
CREATE TABLE ca_item
(
	itemcode	VARCHAR(20) NOT NULL,
	itemname	VARCHAR(64),
	lsign		SMALLINT,
	itemtype	VARCHAR(4),
	wlbm		VARCHAR(20),
	aord		SMALLINT,
	forv		SMALLINT,
	abc_type	VARCHAR(4),
	callno	VARCHAR(4),
	msable	SMALLINT,
	qtyadd	SMALLINT,
	munit		VARCHAR(4),
	nunit		VARCHAR(4),
	ismain	SMALLINT,
	lvtype	VARCHAR(4),
	lvnum		SMALLINT,
	planpri	DECIMAL(18,8),
	opri		DECIMAL(18,8),
	actno		VARCHAR(20),
	oactno	VARCHAR(20),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_uet
(
	id		   INTEGER NOT NULL,
	callno	VARCHAR(4),
	allname	VARCHAR(64),
	isign		SMALLINT,
	allnote	VARCHAR(64)
);
CREATE TABLE ca_uer
(
	centerno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	callno	VARCHAR(4)
);
CREATE TABLE ca_obj
(
	objectno	VARCHAR(20) NOT NULL,
	obname	VARCHAR(64),
	obtype	VARCHAR(4),
	lsign		SMALLINT,
	itemno	VARCHAR(20),
	subname	VARCHAR(40),
	munit		VARCHAR(4),
	nunit		VARCHAR(4),
	mallno	VARCHAR(4),
	allrate	DECIMAL(18,8),
	badrate	DECIMAL(18,8),
	salepri	DECIMAL(18,8),
	qtytotal	DECIMAL(18,8),
	amototal	DECIMAL(18,8),
	sfixcost	DECIMAL(18,8),
	ufixcost	DECIMAL(18,8),
	uvarcost	DECIMAL(18,8),
	uothcost	DECIMAL(18,8),
	itemcode	VARCHAR(20),
	flowno   VARCHAR(20),
	actno		VARCHAR(20),
	oactno	VARCHAR(20),
	obnote	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_flow
(
	flowno	VARCHAR(20) NOT NULL,
	centerno	VARCHAR(20) NOT NULL,
	flowname	VARCHAR(64),
	ispri		SMALLINT,
	icourse	SMALLINT,
	descr		VARCHAR(64)
);
CREATE TABLE ca_mdl
(
	flowno	VARCHAR(20) NOT NULL,
	objectno	VARCHAR(20) NOT NULL,
	centerno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	icourse	SMALLINT,
	mallper	DECIMAL(18,8),
	mallrate	DECIMAL(18,8),
	mallamo	DECIMAL(18,8),
	mdqua		DECIMAL(18,8),
	mdamo		DECIMAL(18,8),
	adqua		DECIMAL(18,8),
	adamo		DECIMAL(18,8),	
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_bth
(
	id		   INTEGER NOT NULL,
	batchno	VARCHAR(20),
	fcode		VARCHAR(20),
	ue_code	VARCHAR(20),
	batype	VARCHAR(4),
	deptno	VARCHAR(20),
	objectno	VARCHAR(20),
	flowno	VARCHAR(20),
	ca_mon	INTEGER,
	bdate		DATETIME YEAR TO FRACTION(5),
	edate		DATETIME YEAR TO FRACTION(5),
	tsign		SMALLINT,
	chksign	SMALLINT,
	comsign	SMALLINT,
	ord		VARCHAR(20),
	chm		VARCHAR(20),
	inm		VARCHAR(20),
	banote	VARCHAR(64),
	qty_plan	DECIMAL(18,8),
	qty_font	DECIMAL(18,8),
	amo_font	DECIMAL(18,8),
	qty_outp	DECIMAL(18,8),
	amo_outp	DECIMAL(18,8),
	amo_sale	DECIMAL(18,8),
	amo_stad	DECIMAL(18,8),
	qty_next	DECIMAL(18,8),
	amo_next	DECIMAL(18,8),
	qty_tra	DECIMAL(18,8),
	qty_trb	DECIMAL(18,8),
	qty_trc	DECIMAL(18,8),
	qty_trd	DECIMAL(18,8),
	qty_tre	DECIMAL(18,8),
	qty_trf	DECIMAL(18,8),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_mtx
(
	batchno	VARCHAR(20) NOT NULL,
	centerno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	deptno	VARCHAR(20),
	ue_code	VARCHAR(20),
	objectno	VARCHAR(20),
	ca_mon	INTEGER,
	aord		SMALLINT,
	msunit	VARCHAR(4),
	icourse	SMALLINT,
	qty_plan	DECIMAL(18,8),
	amo_plan	DECIMAL(18,8),
	qty_font	DECIMAL(18,8),
	amo_font	DECIMAL(18,8),
	per_font	DECIMAL(18,8),
	qty_cur	DECIMAL(18,8),
	amo_cur	DECIMAL(18,8),
	qty_outp	DECIMAL(18,8),
	amo_outp	DECIMAL(18,8),
	qty_next	DECIMAL(18,8),
	amo_next	DECIMAL(18,8),
	per_next	DECIMAL(18,8),
	allper   DECIMAL(18,8),
	dec_rpa	DECIMAL(18,8),
	dec_rpb	DECIMAL(18,8),
	dec_rpc	DECIMAL(18,8),
	dec_rpd	DECIMAL(18,8),
	dec_rpe	DECIMAL(18,8),
	dec_rpf	DECIMAL(18,8),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_jbt
(
	jobno		VARCHAR(4) NOT NULL,
	jobname	VARCHAR(64),
	abc_type	VARCHAR(4),
	msunit	VARCHAR(4),
	jotype	SMALLINT,
	descr		VARCHAR(64)
);
CREATE TABLE ca_rtn
(
	centerno	VARCHAR(20) NOT NULL,
	objectno	VARCHAR(20) NOT NULL,
	jobno		VARCHAR(4) NOT NULL,
	ra_qua	DECIMAL(18,8)
);
CREATE TABLE ca_jbq
(
	centerno	VARCHAR(20) NOT NULL,
	batchno	VARCHAR(20) NOT NULL,
	jobno		VARCHAR(4)  NOT NULL,
	deptno	VARCHAR(20),
	objectno	VARCHAR(20),
	ca_mon	INTEGER,
	qty_rat	DECIMAL(18,8),
	qty_rea	DECIMAL(18,8)
);
CREATE TABLE ca_jbb
(
	id		   INTEGER NOT NULL,
	billno	VARCHAR(20),
	jobno		VARCHAR(4),
	deptno	VARCHAR(20),
	ca_mon	INTEGER,
	chksign	SMALLINT,
	bdate		DATETIME YEAR TO FRACTION(5),
	edate		DATETIME YEAR TO FRACTION(5),
	inm		VARCHAR(20),
	chm		VARCHAR(20),
	zybm		VARCHAR(20),
	centerno	VARCHAR(20),
	batchno	VARCHAR(20),
	objectno	VARCHAR(20),
	qty		DECIMAL(18,8),
	unitcon	DECIMAL(18,8),
	totalqty	DECIMAL(18,8),
	js_numa	DECIMAL(18,8),
	js_numb	DECIMAL(18,8),
	js_numc	DECIMAL(18,8),
	jsnote	VARCHAR(64),
	js_infoa	VARCHAR(64),
	js_infob	VARCHAR(64),
	js_infoc	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_dsf
(
	id			INTEGER NOT NULL,
	systp		SMALLINT,
	gettype	VARCHAR(4),
	centerno	VARCHAR(20),
	itemcode	VARCHAR(20),
	objectno	VARCHAR(20),
	callno	VARCHAR(4),
	allrate	DECIMAL(18,8),
	cacsign	SMALLINT
);
CREATE TABLE ca_dsrd
(
	id			INTEGER  NOT NULL,
	icourse	SMALLINT NOT NULL,
	cactp		VARCHAR(4),
	lbracket	VARCHAR(12),
	listid	VARCHAR(12),
	matchtp	VARCHAR(4),
	rbracket	VARCHAR(12),
	svalue	VARCHAR(64)
);
CREATE TABLE ca_expb
(
	id			INTEGER NOT NULL,
	billno	VARCHAR(20),
	extype	VARCHAR(4),
	itemtype	VARCHAR(4),
	jobno		VARCHAR(4),
	origno	VARCHAR(20),
	chksign	SMALLINT,
	ca_mon	INTEGER,
	rdate		DATETIME YEAR TO FRACTION(5),
	whno		VARCHAR(20),
	deptno	VARCHAR(20),
	centerno	VARCHAR(20),
	objectno	VARCHAR(20),
	batchno	VARCHAR(20),
	chm		VARCHAR(20),
	inm		VARCHAR(20),
	iscacu	SMALLINT,
	sysmake	SMALLINT,
	t_dept	VARCHAR(20),
	t_center	VARCHAR(20),
	t_item	VARCHAR(20),
	t_itemno	VARCHAR(20),
	ranks		CHAR(2),
	t_object	VARCHAR(20),
	t_batch	VARCHAR(20),
	pri		DECIMAL(18,8),
	qua		DECIMAL(18,8),
	amo		DECIMAL(18,8),
	exnote	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_rd
(
	id			INTEGER NOT NULL,
	billno	VARCHAR(20),
	extype	VARCHAR(4),
	itemtype	VARCHAR(4),
	ca_mon	INTEGER,
	orgino	VARCHAR(20),
	deptno	VARCHAR(20),
	centerno	VARCHAR(20),
	itemcode	VARCHAR(20),
	msunit	VARCHAR(4),
	objectno	VARCHAR(20),
	batchno	VARCHAR(20),
	rdate		DATETIME YEAR TO FRACTION(5),
	qty		DECIMAL(18,8),
	amo		DECIMAL(18,8),
	iscacu	SMALLINT,
	renote	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_mdc
(
	id			INTEGER NOT NULL,
	whid		VARCHAR(20),
	objectno	VARCHAR(20),
	itemcode	VARCHAR(20),
	itemno	VARCHAR(20),
	ca_mon	INTEGER,
	ranks		CHAR(2),
	msunit	VARCHAR(4),
	qty_font	DECIMAL(18,8),
	amo_font	DECIMAL(18,8),
	qty_pur	DECIMAL(18,8),
	amo_pur	DECIMAL(18,8),
	qty_pro	DECIMAL(18,8),
	amo_pro	DECIMAL(18,8),
	chnote	VARCHAR(64)
);
CREATE TABLE ca_anm
(
	centerno	VARCHAR(20) NOT NULL,
	batchno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	callno	VARCHAR(4)  NOT NULL,
	objectno	VARCHAR(20),
	ca_mon	INTEGER,
	qty_base	DECIMAL(18,8)
);
CREATE TABLE ca_aexp
(
	id			INTEGER NOT NULL,
	centerno	VARCHAR(20),
	itemcode	VARCHAR(20),
	ca_mon	INTEGER,
	callno	VARCHAR(4),
	msunit	VARCHAR(4),
	isturn	SMALLINT,
	isall		SMALLINT,
	qty_add	DECIMAL(18,8),
	qty_all	DECIMAL(18,8),
	amo_all	DECIMAL(18,8)
);
CREATE TABLE ca_prop
(
	id			INTEGER NOT NULL,
	p01		INTEGER,
	p02		INTEGER,
	p03		INTEGER,
	p04		INTEGER,
	p05		INTEGER,
	p06		INTEGER,
	p07		INTEGER,
	p08		INTEGER,
	p09		INTEGER,
	p10		INTEGER,
	p11		INTEGER,
	p12		INTEGER
);
CREATE TABLE ca_uch
(
	funit		VARCHAR(4) NOT NULL,
	nunit		VARCHAR(4) NOT NULL,
	relat		DECIMAL(18,8),
	msnote		VARCHAR(64)
);
CREATE TABLE ca_cdf
(
	id				VARCHAR(4) NOT NULL,
	sfname		VARCHAR(64),
	sftype		VARCHAR(4),
	maxcla		INTEGER,
	maxlen		INTEGER,
	sinlen		INTEGER,
	ismanu		SMALLINT
);
CREATE TABLE ca_cdrd
(
	id			VARCHAR(4) NOT NULL,
	cla		INTEGER NOT NULL,
	len		INTEGER,
	val		VARCHAR(20),
	constr	VARCHAR(20),
	de_int1 	INTEGER,
	de_int2  INTEGER,
  	de_str1	VARCHAR(12),
  	de_str2 	VARCHAR(64)
);
CREATE TABLE ca_abctp
(
 	abc_type	VARCHAR(4) NOT NULL,
  	descr		VARCHAR(64),
  	de_str1 	VARCHAR(12),
  	de_str2 	VARCHAR(12),
  	de_str3 	VARCHAR(64)
);
CREATE TABLE ca_ma
(
	mallno	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64)
);
CREATE TABLE ca_obtp
(
	obtype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64)
);
CREATE TABLE ca_batp
(
	batype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64)
);
CREATE TABLE ca_extp
(
	extype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
   isadd		SMALLINT,
	isamo		SMALLINT,
	de_str	VARCHAR(64)
);
CREATE TABLE ca_itp
(
	itemtype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64)
);
CREATE TABLE ca_unit
(
	unitno	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
	defstr	VARCHAR(20),
	ismain	SMALLINT
);
CREATE TABLE cb_qx
(
	 xm  		VARCHAR(20) NOT NULL ,		
	 mm  		VARCHAR(254),					
	 bm  		VARCHAR(20),				
	 cno 		VARCHAR(20),
	 q0  		SMALLINT,
    q1  		SMALLINT,
	 q1_1	 	SMALLINT, 
	 q1_2  	SMALLINT,
	 q1_3  	SMALLINT,    
	 q1_4  	SMALLINT,
	 q1_5  	SMALLINT,
	 q1_6  	SMALLINT,					
	 q1_7  	SMALLINT,					
	 q1_8  	SMALLINT,					
	 q1_9  	SMALLINT,					
	 q1_a 	SMALLINT,					
	 q1_b  	SMALLINT,					 
	 q1_c  	SMALLINT,					
	 q1_d  	SMALLINT,               
	 q1_e  	SMALLINT,					
	 q1_f  	SMALLINT,	 
	 q1_g  	SMALLINT,               
	 q1_h  	SMALLINT,					
	 q1_i  	SMALLINT,					
	 q2    	SMALLINT,					
	 q2_1  	SMALLINT, 
	 q2_2  	SMALLINT,
	 q2_3  	SMALLINT,    
	 q2_4  	SMALLINT,
	 q2_5  	SMALLINT,
	 q2_6  	SMALLINT,					
	 q2_7  	SMALLINT,
	 q2_8  	SMALLINT,
	 q3    	SMALLINT,					
	 q3_1  	SMALLINT, 
	 q3_2  	SMALLINT,
	 q3_3  	SMALLINT,    
	 q3_4  	SMALLINT,
	 q3_5  	SMALLINT,
	 q3_6  	SMALLINT,					
	 q3_7  	SMALLINT,					
	 q3_8  	SMALLINT,					
	 q3_9  	SMALLINT,
	 q3_a  	SMALLINT,
	 q3_b  	SMALLINT,					
	 q3_c  	SMALLINT,	
	 q4    	SMALLINT,					
	 q4_1  	SMALLINT, 
	 q4_2  	SMALLINT,
	 q4_3  	SMALLINT,    
	 q4_4  	SMALLINT,
	 q4_5  	SMALLINT,
	 q4_6  	SMALLINT,
	 q5    	SMALLINT,
	 q5_1  	SMALLINT, 
	 q5_2  	SMALLINT,
	 q5_3  	SMALLINT,    
	 q5_4  	SMALLINT,
	 q5_5  	SMALLINT,
	 q5_6 	SMALLINT,					
	 q5_7  	SMALLINT,					
	 q5_8  	SMALLINT,					
	 q5_9  	SMALLINT,
	 q5_a  	SMALLINT,					
	 q5_b  	SMALLINT,					 
	 q5_c 	SMALLINT,					
	 q5_d  	SMALLINT,
	 q6    	SMALLINT,
    q7		SMALLINT,
	 q7_1  	SMALLINT, 
	 q7_2  	SMALLINT,
	 q7_3  	SMALLINT,    
	 q7_4  	SMALLINT
);

CREATE TABLE cb_pz
(
	 id	  	 INTEGER NOT NULL ,		
	 jzbz	  	 SMALLINT,
	 csign  	 SMALLINT,
	 pzrq   	 DATETIME YEAR TO FRACTION(5),
	 pzlx   	 VARCHAR(1),
    pzh    	 VARCHAR(4),
	 fj	  	 SMALLINT,
	 zy     	 VARCHAR(30),
    kmdm	  	 VARCHAR(20),
	 bmry	  	 VARCHAR(12),
	 jord	  	 SMALLINT,
	 j	  		 DECIMAL(18,8),
	 d	  		 DECIMAL(18,8),
    shy	  	 VARCHAR(12),
    zdy	  	 VARCHAR(12),
	 czy	  	 VARCHAR(12),
    shbz   	 SMALLINT,
    sl     	 DECIMAL(18,8),
    dj     	 DECIMAL(18,8),
    proj   	 VARCHAR(20),
    amoform	 VARCHAR(248),
    qtyform	 VARCHAR(248),
	 scode	 VARCHAR(4),
    ca_mon 	 INTEGER,  
    zphjsdjh VARCHAR(20),
    wbje     DECIMAL(18,8),
    hl       DECIMAL(18,8),
    dqh      VARCHAR(4),
    gg       VARCHAR(14),
    dwdm     VARCHAR(4),
    lxr      VARCHAR(12),
    jsr      VARCHAR(12)							
);

CREATE TABLE ca_def
(
	id			INTEGER NOT NULL,
	title		VARCHAR(64),
	def		VARCHAR(128),
	def_int1	INTEGER,
	def_int2	INTEGER,
	def_str1	VARCHAR(64),
	def_date	DATETIME YEAR TO FRACTION(5)
);

DROP INDEX ca_ctr.ctrid;
DROP INDEX ca_item.itemid;
DROP INDEX ca_uet.uetid;
DROP INDEX ca_uer.uerid;
DROP INDEX ca_obj.objid;
DROP INDEX ca_flow.flowid;
DROP INDEX ca_mdl.mdlid;
DROP INDEX ca_bth.bthid;
DROP INDEX ca_mtx.mtxid;
DROP INDEX ca_jbt.jbtid;
DROP INDEX ca_rtn.rtnid;
DROP INDEX ca_jbq.jbqid;
DROP INDEX ca_jbb.jbbid;
DROP INDEX ca_dsf.dsfid;
DROP INDEX ca_dsrd.dsrdid;
DROP INDEX ca_expb.expbid;
DROP INDEX ca_rd.rdid;
DROP INDEX ca_mdc.mdcid;
DROP INDEX ca_anm.anmid;
DROP INDEX ca_aexp.aexpid;
DROP INDEX ca_prop.propid;
DROP INDEX ca_uch.uchid;
DROP INDEX ca_cdf.cdfid;
DROP INDEX ca_cdrd.cdrdid;
DROP INDEX ca_abctp.abctpid;
DROP INDEX ca_ma.maid;
DROP INDEX ca_obtp.obtpid;
DROP INDEX ca_batp.batpid;
DROP INDEX ca_extp.extpid;
DROP INDEX ca_itp.itpid;
DROP INDEX ca_unit.unitid;
DROP INDEX cb_qx.qxid;
DROP INDEX cb_pz.pzid;
DROP INDEX ca_def.defid;

CREATE UNIQUE INDEX ctrid  ON ca_ctr  (centerno);
CREATE UNIQUE INDEX itemid ON ca_item (itemcode);
CREATE UNIQUE INDEX uetid  ON ca_uet  (id);
CREATE UNIQUE INDEX uerid 	ON ca_uer  (centerno,itemcode);
CREATE UNIQUE INDEX objid 	ON ca_obj  (objectno);
CREATE UNIQUE INDEX flowid ON ca_flow  (flowno,centerno);
CREATE UNIQUE INDEX mdlid  ON ca_mdl   (flowno,objectno,centerno,itemcode);
CREATE UNIQUE INDEX bthid 	ON ca_bth   (id);
CREATE UNIQUE INDEX mtxid 	ON ca_mtx   (batchno,centerno,itemcode);
CREATE UNIQUE INDEX jbtid 	ON ca_jbt   (jobno);
CREATE UNIQUE INDEX rtnid 	ON ca_rtn   (centerno,objectno,jobno);
CREATE UNIQUE INDEX jbqid  ON ca_jbq   (centerno,batchno,jobno);
CREATE UNIQUE INDEX jbbid 	ON ca_jbb   (id);
CREATE UNIQUE INDEX dsfid  ON ca_dsf   (id)  ;
CREATE UNIQUE INDEX dsrdid	ON ca_dsrd (id,icourse);
CREATE UNIQUE INDEX expbid	ON  ca_expb	(id);
CREATE UNIQUE INDEX rdid	ON  ca_rd	(id);
CREATE UNIQUE INDEX mdcid	ON  ca_mdc	(id);
CREATE UNIQUE INDEX anmid	ON  ca_anm	(centerno,batchno,itemcode,callno);
CREATE UNIQUE INDEX aexpid	ON  ca_aexp	(id);
CREATE UNIQUE INDEX propid	ON  ca_prop	(id);
CREATE UNIQUE INDEX uchid	ON  ca_uch	(funit,nunit);
CREATE UNIQUE INDEX cdfid	ON  ca_cdf	(id);
CREATE UNIQUE INDEX cdrdid	ON  ca_cdrd	(id,cla);
CREATE UNIQUE INDEX abctpid   ON  ca_abctp   (abc_type);
CREATE UNIQUE INDEX maid	ON  ca_ma	(mallno);
CREATE UNIQUE INDEX obtpid	ON  ca_obtp	(obtype);
CREATE UNIQUE INDEX batpid	ON  ca_batp	(batype);
CREATE UNIQUE INDEX extpid	ON  ca_extp	(extype);
CREATE UNIQUE INDEX itpid	ON ca_itp (itemtype);
CREATE UNIQUE INDEX unitid	ON  ca_unit	(unitno);
CREATE UNIQUE INDEX qxid	 ON  cb_qx (xm);
CREATE UNIQUE INDEX pzid	 ON cb_pz (id);
CREATE UNIQUE INDEX defid	ON ca_def (id);

[CREATE INDEX]
DROP INDEX ca_bth.idx001;
DROP INDEX ca_bth.idx002;

DROP INDEX ca_mtx.idx005;

DROP INDEX ca_jbb.idx010;

DROP INDEX ca_expb.idx015;
DROP INDEX ca_expb.idx016;
DROP INDEX ca_expb.idx017;
DROP INDEX ca_expb.idx018;

DROP INDEX ca_rd.idx020;
DROP INDEX ca_rd.idx021;
DROP INDEX ca_rd.idx022;
DROP INDEX ca_rd.idx023;

DROP INDEX ca_aexp.idx030;

DROP INDEX cb_pz.idx035;

CREATE INDEX idx001 ON ca_bth(batchno);
CREATE INDEX idx002 ON ca_bth(ca_mon,ue_code,objectno);

CREATE INDEX idx005 ON ca_mtx(ca_mon,ue_code,objectno,itemcode);

CREATE INDEX idx010 ON ca_jbb(ca_mon,billno,jobno);

CREATE INDEX idx015 ON ca_expb(ca_mon,billno);
CREATE INDEX idx016 ON ca_expb(ca_mon,extype,billno);
CREATE INDEX idx017 ON ca_expb(ca_mon,t_object,t_center,t_item);
CREATE INDEX idx018 ON ca_expb(ca_mon,t_batch,t_center,t_item);

CREATE INDEX idx020 ON ca_rd(ca_mon,billno);
CREATE INDEX idx021 ON ca_rd(ca_mon,extype,billno);
CREATE INDEX idx022 ON ca_rd(ca_mon,objectno,centerno,itemcode);
CREATE INDEX idx023 ON ca_rd(ca_mon,batchno,centerno,itemcode);

CREATE INDEX idx030 ON ca_aexp(ca_mon,centerno,itemcode,callno);

CREATE INDEX idx035 ON cb_pz(ca_mon,pzh);

