[CREATE TABLE]
CREATE TABLE ca_ctr
(
	centerno	VARCHAR(20) NOT NULL,
	ctname	VARCHAR(64),
	lsign		SMALLINT,
	cttype	VARCHAR(4),
	iszy		SMALLINT,
	zybm		VARCHAR(20),
	allrate	DOUBLE,	
	Primary key (centerno)
);
CREATE TABLE ca_item
(
	itemcode	VARCHAR(20) NOT NULL,
	itemname	VARCHAR(64),
	lsign		SMALLINT,
	itemtype	VARCHAR(4),
	wlbm		VARCHAR(20),
	aord		SMALLINT,
	forv		SMALLINT,
	abc_type	VARCHAR(4),
	callno	VARCHAR(4),
	msable	SMALLINT,
	qtyadd	SMALLINT,
	munit		VARCHAR(4),
	nunit		VARCHAR(4),
	ismain	SMALLINT,
	lvtype	VARCHAR(4),
	lvnum		SMALLINT,
	planpri	DOUBLE,
	opri		DOUBLE,
	actno		VARCHAR(20),
	oactno	VARCHAR(20),
	de_int	INTEGER,
	de_str	VARCHAR(64),
	Primary key (itemcode)
);
CREATE TABLE ca_uet
(
	id		   INTEGER NOT NULL,
	callno	VARCHAR(4),
	allname	VARCHAR(64),
	isign		SMALLINT,
	allnote	VARCHAR(64),	
	PRIMARY KEY (id)
);
CREATE TABLE ca_uer
(
	centerno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	callno	VARCHAR(4),
	PRIMARY KEY (centerno,itemcode)
);
CREATE TABLE ca_obj
(
	objectno	VARCHAR(20) NOT NULL,
	obname	VARCHAR(64),
	obtype	VARCHAR(4),
	lsign		SMALLINT,
	itemno	VARCHAR(20),
	subname	VARCHAR(40),
	munit		VARCHAR(4),
	nunit		VARCHAR(4),
	mallno	VARCHAR(4),
	allrate	DOUBLE,
	badrate	DOUBLE,
	salepri	DOUBLE,
	qtytotal	DOUBLE,
	amototal	DOUBLE,
	sfixcost	DOUBLE,
	ufixcost	DOUBLE,
	uvarcost	DOUBLE,
	uothcost	DOUBLE,
	itemcode	VARCHAR(20),
	flowno   VARCHAR(20),
	actno		VARCHAR(20),
	oactno	VARCHAR(20),
	obnote	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64),
	PRIMARY KEY (objectno)
);
CREATE TABLE ca_flow
(
	flowno	VARCHAR(20) NOT NULL,
	centerno	VARCHAR(20) NOT NULL,
	flowname	VARCHAR(64),
	ispri		SMALLINT,
	icourse	SMALLINT,
	descr		VARCHAR(64),	
	PRIMARY KEY (flowno,centerno)
);
CREATE TABLE ca_mdl
(
	flowno	VARCHAR(20) NOT NULL,
	objectno	VARCHAR(20) NOT NULL,
	centerno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	icourse	SMALLINT,
	mallper	DOUBLE,
	mallrate	DOUBLE,
	mallamo	DOUBLE,
	mdqua		DOUBLE,
	mdamo		DOUBLE,
	adqua		DOUBLE,
	adamo		DOUBLE,	
	de_int	INTEGER,
	de_str	VARCHAR(64),
	PRIMARY KEY (flowno,objectno,centerno,itemcode)
);
CREATE TABLE ca_bth
(
	id		   INTEGER NOT NULL,
	batchno	VARCHAR(20),
	fcode		VARCHAR(20),
	ue_code	VARCHAR(20),
	batype	VARCHAR(4),
	deptno	VARCHAR(20),
	objectno	VARCHAR(20),
	flowno	VARCHAR(20),
	ca_mon	INTEGER,
	bDATE		DATE,
	eDATE		DATE,
	tsign		SMALLINT,
	chksign	SMALLINT,
	comsign	SMALLINT,
	ord		VARCHAR(20),
	chm		VARCHAR(20),
	inm		VARCHAR(20),
	banote	VARCHAR(64),
	qty_plan	DOUBLE,
	qty_font	DOUBLE,
	amo_font	DOUBLE,
	qty_outp	DOUBLE,
	amo_outp	DOUBLE,
	amo_sale	DOUBLE,
	amo_stad	DOUBLE,
	qty_next	DOUBLE,
	amo_next	DOUBLE,
	qty_tra	DOUBLE,
	qty_trb	DOUBLE,
	qty_trc	DOUBLE,
	qty_trd	DOUBLE,
	qty_tre	DOUBLE,
	qty_trf	DOUBLE,
	de_int	INTEGER,
	de_str	VARCHAR(64),
	Primary key (id)
);
CREATE TABLE ca_mtx
(
	batchno	VARCHAR(20) NOT NULL,
	centerno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	deptno	VARCHAR(20),
	ue_code	VARCHAR(20),
	objectno	VARCHAR(20),
	ca_mon	INTEGER,
	aord		SMALLINT,
	msunit	VARCHAR(4),
	icourse	SMALLINT,
	qty_plan	DOUBLE,
	amo_plan	DOUBLE,
	qty_font	DOUBLE,
	amo_font	DOUBLE,
	per_font	DOUBLE,
	qty_cur	DOUBLE,
	amo_cur	DOUBLE,
	qty_outp	DOUBLE,
	amo_outp	DOUBLE,
	qty_next	DOUBLE,
	amo_next	DOUBLE,
	per_next	DOUBLE,
	allper   DOUBLE,
	dec_rpa	DOUBLE,
	dec_rpb	DOUBLE,
	dec_rpc	DOUBLE,
	dec_rpd	DOUBLE,
	dec_rpe	DOUBLE,
	dec_rpf	DOUBLE,
	de_int	INTEGER,
	de_str	VARCHAR(64),
	Primary key (batchno,centerno,itemcode)
);
CREATE TABLE ca_jbt
(
	jobno		VARCHAR(4) NOT NULL,
	jobname	VARCHAR(64),
	abc_type	VARCHAR(4),
	msunit	VARCHAR(4),
	jotype	SMALLINT,
	descr		VARCHAR(64),	
	Primary key (jobno)
);
CREATE TABLE ca_rtn
(
	centerno	VARCHAR(20) NOT NULL,
	objectno	VARCHAR(20) NOT NULL,
	jobno		VARCHAR(4) NOT NULL,
	ra_qua	DOUBLE,
	Primary key (centerno,objectno,jobno)
);
CREATE TABLE ca_jbq
(
	centerno	VARCHAR(20) NOT NULL,
	batchno	VARCHAR(20) NOT NULL,
	jobno		VARCHAR(4)  NOT NULL,
	deptno	VARCHAR(20),
	objectno	VARCHAR(20),
	ca_mon	INTEGER,
	qty_rat	DOUBLE,
	qty_rea	DOUBLE,
	Primary key (centerno,batchno,jobno)
);
CREATE TABLE ca_jbb
(
	id		   INTEGER NOT NULL,
	billno	VARCHAR(20),
	jobno		VARCHAR(4),
	deptno	VARCHAR(20),
	ca_mon	INTEGER,
	chksign	SMALLINT,
	bDATE		DATE,
	eDATE		DATE,
	inm		VARCHAR(20),
	chm		VARCHAR(20),
	zybm		VARCHAR(20),
	centerno	VARCHAR(20),
	batchno	VARCHAR(20),
	objectno	VARCHAR(20),
	qty		DOUBLE,
	unitcon	DOUBLE,
	totalqty	DOUBLE,
	js_numa	DOUBLE,
	js_numb	DOUBLE,
	js_numc	DOUBLE,
	jsnote	VARCHAR(64),
	js_infoa	VARCHAR(64),
	js_infob	VARCHAR(64),
	js_infoc	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64),
	Primary key (id)
);
CREATE TABLE ca_dsf
(
	id			INTEGER NOT NULL,
	systp		SMALLINT,
	gettype	VARCHAR(4),
	centerno	VARCHAR(20),
	itemcode	VARCHAR(20),
	objectno	VARCHAR(20),
	callno	VARCHAR(4),
	allrate	DOUBLE,
	cacsign	SMALLINT,
	Primary key (id)
);
CREATE TABLE ca_dsrd
(
	id			INTEGER NOT NULL,
	icourse	SMALLINT NOT NULL,
	cactp		VARCHAR(4),
	lbracket	VARCHAR(12),
	listid	VARCHAR(12),
	matchtp	VARCHAR(4),
	rbracket	VARCHAR(12),
	svalue	VARCHAR(64),
	Primary key (id,icourse)
);
CREATE TABLE ca_expb
(
	id			INTEGER NOT NULL,
	billno	VARCHAR(20),
	extype	VARCHAR(4),
	itemtype	VARCHAR(4),
	jobno		VARCHAR(4),
	origno	VARCHAR(20),
	chksign	SMALLINT,
	ca_mon	INTEGER,
	rDATE		DATE,
	whno		VARCHAR(20),
	deptno	VARCHAR(20),
	centerno	VARCHAR(20),
	objectno	VARCHAR(20),
	batchno	VARCHAR(20),
	chm		VARCHAR(20),
	inm		VARCHAR(20),
	iscacu	SMALLINT,
	sysmake	SMALLINT,
	t_dept	VARCHAR(20),
	t_center	VARCHAR(20),
	t_item	VARCHAR(20),
	t_itemno	VARCHAR(20),
	ranks		char(2),
	t_object	VARCHAR(20),
	t_batch	VARCHAR(20),
	pri		DOUBLE,
	qua		DOUBLE,
	amo		DOUBLE,
	exnote	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64),
	Primary key (id)
);
CREATE TABLE ca_rd
(
	id			INTEGER NOT NULL,
	billno	VARCHAR(20),
	extype	VARCHAR(4),
	itemtype	VARCHAR(4),
	ca_mon	INTEGER,
	orgino	VARCHAR(20),
	deptno	VARCHAR(20),
	centerno	VARCHAR(20),
	itemcode	VARCHAR(20),
	msunit	VARCHAR(4),
	objectno	VARCHAR(20),
	batchno	VARCHAR(20),
	rDATE		DATE,
	qty		DOUBLE,
	amo		DOUBLE,
	iscacu	SMALLINT,
	renote	VARCHAR(64),
	de_int	INTEGER,
	de_str	VARCHAR(64),
	Primary key (id)
);
CREATE TABLE ca_mdc
(
	id			INTEGER NOT NULL,
	whid		VARCHAR(20),
	objectno	VARCHAR(20),
	itemcode	VARCHAR(20),
	itemno	VARCHAR(20),
	ca_mon	INTEGER,
	ranks		char(2),
	msunit	VARCHAR(4),
	qty_font	DOUBLE,
	amo_font	DOUBLE,
	qty_pur	DOUBLE,
	amo_pur	DOUBLE,
	qty_pro	DOUBLE,
	amo_pro	DOUBLE,
	chnote	VARCHAR(64),	
	Primary key (id)
);
CREATE TABLE ca_anm
(
	centerno	VARCHAR(20) NOT NULL,
	batchno	VARCHAR(20) NOT NULL,
	itemcode	VARCHAR(20) NOT NULL,
	callno	VARCHAR(4)  NOT NULL,
	objectno	VARCHAR(20),
	ca_mon	INTEGER,
	qty_base	DOUBLE,
	Primary key (centerno,batchno,itemcode,callno)
);
CREATE TABLE ca_aexp
(
	id			INTEGER NOT NULL,
	centerno	VARCHAR(20),
	itemcode	VARCHAR(20),
	ca_mon	INTEGER,
	callno	VARCHAR(4),
	msunit	VARCHAR(4),
	isturn	SMALLINT,
	isall		SMALLINT,
	qty_add	DOUBLE,
	qty_all	DOUBLE,
	amo_all	DOUBLE,
	Primary key (id)
);
CREATE TABLE ca_prop
(
	id			INTEGER NOT NULL,
	p01		INTEGER,
	p02		INTEGER,
	p03		INTEGER,
	p04		INTEGER,
	p05		INTEGER,
	p06		INTEGER,
	p07		INTEGER,
	p08		INTEGER,
	p09		INTEGER,
	p10		INTEGER,
	p11		INTEGER,
	p12		INTEGER,	
	Primary key (id)
);
CREATE TABLE ca_uch
(
	funit		VARCHAR(4) NOT NULL,
	nunit		VARCHAR(4) NOT NULL,
	relat		DOUBLE,
	msnote		VARCHAR(64),
	Primary key (funit,nunit)
);
CREATE TABLE ca_cdf
(
	id				VARCHAR(4) NOT NULL,
	sfname		VARCHAR(64),
	sftype		VARCHAR(4),
	maxcla		INTEGER,
	maxlen		INTEGER,
	sinlen		INTEGER,
	ismanu		SMALLINT,
	Primary key (id)
);
CREATE TABLE ca_cdrd
(
	id			VARCHAR(4) NOT NULL,
	cla		INTEGER NOT NULL,
	len		INTEGER,
	val		VARCHAR(20),
	constr	VARCHAR(20),
	de_int1 	INTEGER,
	de_int2  INTEGER,
  	de_str1	VARCHAR(12),
  	de_str2 	VARCHAR(64),
	Primary key (id,cla)
);
CREATE TABLE ca_abctp
(
 	abc_type	VARCHAR(4) NOT NULL,
  	descr		VARCHAR(64),
  	de_str1 	VARCHAR(12),
  	de_str2 	VARCHAR(12),
  	de_str3 	VARCHAR(64),
   Primary key (abc_type)
);
CREATE TABLE ca_ma
(
	mallno	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
	Primary key (mallno)
);
CREATE TABLE ca_obtp
(
	obtype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
	Primary key (obtype)
);
CREATE TABLE ca_batp
(
	batype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
	Primary key (batype)
);
CREATE TABLE ca_extp
(
	extype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
   isadd		SMALLINT,
	isamo		SMALLINT,
	de_str	VARCHAR(64),
	Primary key (extype)
);
CREATE TABLE ca_itp
(
	itemtype	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
	Primary key (itemtype)
);
CREATE TABLE ca_unit
(
	unitno	VARCHAR(4) NOT NULL,
	descr		VARCHAR(64),
	defstr	VARCHAR(20),
	ismain	SMALLINT,
	Primary key (unitno)
);
CREATE TABLE cb_qx
(
	 xm  		VARCHAR(20) NOT NULL ,		
	 mm  		VARCHAR(254),					
	 bm  		VARCHAR(20),				
	 cno 		VARCHAR(20),
	 q0  		SMALLINT,
    q1  		SMALLINT,
	 q1_1	 	SMALLINT, 
	 q1_2  	SMALLINT,
	 q1_3  	SMALLINT,    
	 q1_4  	SMALLINT,
	 q1_5  	SMALLINT,
	 q1_6  	SMALLINT,					
	 q1_7  	SMALLINT,					
	 q1_8  	SMALLINT,					
	 q1_9  	SMALLINT,					
	 q1_a 	SMALLINT,					
	 q1_b  	SMALLINT,					 
	 q1_c  	SMALLINT,					
	 q1_d  	SMALLINT,               
	 q1_e  	SMALLINT,					
	 q1_f  	SMALLINT,	 
	 q1_g  	SMALLINT,               
	 q1_h  	SMALLINT,					
	 q1_i  	SMALLINT,					
	 q2    	SMALLINT,					
	 q2_1  	SMALLINT, 
	 q2_2  	SMALLINT,
	 q2_3  	SMALLINT,    
	 q2_4  	SMALLINT,
	 q2_5  	SMALLINT,
	 q2_6  	SMALLINT,					
	 q2_7  	SMALLINT,
	 q2_8  	SMALLINT,
	 q3    	SMALLINT,					
	 q3_1  	SMALLINT, 
	 q3_2  	SMALLINT,
	 q3_3  	SMALLINT,    
	 q3_4  	SMALLINT,
	 q3_5  	SMALLINT,
	 q3_6  	SMALLINT,					
	 q3_7  	SMALLINT,					
	 q3_8  	SMALLINT,					
	 q3_9  	SMALLINT,
	 q3_a  	SMALLINT,
	 q3_b  	SMALLINT,					
	 q3_c  	SMALLINT,	
	 q4    	SMALLINT,					
	 q4_1  	SMALLINT, 
	 q4_2  	SMALLINT,
	 q4_3  	SMALLINT,    
	 q4_4  	SMALLINT,
	 q4_5  	SMALLINT,
	 q4_6  	SMALLINT,
	 q5    	SMALLINT,
	 q5_1  	SMALLINT, 
	 q5_2  	SMALLINT,
	 q5_3  	SMALLINT,    
	 q5_4  	SMALLINT,
	 q5_5  	SMALLINT,
	 q5_6 	SMALLINT,					
	 q5_7  	SMALLINT,					
	 q5_8  	SMALLINT,					
	 q5_9  	SMALLINT,
	 q5_a  	SMALLINT,					
	 q5_b  	SMALLINT,					 
	 q5_c 	SMALLINT,					
	 q5_d  	SMALLINT,
	 q6    	SMALLINT,
    q7		SMALLINT,
	 q7_1  	SMALLINT, 
	 q7_2  	SMALLINT,
	 q7_3  	SMALLINT,    
	 q7_4  	SMALLINT,	
	 PRIMARY KEY (xm)
);

CREATE TABLE cb_pz
(
	 id	  	 INTEGER NOT NULL ,		
	 jzbz	  	 SMALLINT,
	 csign  	 SMALLINT,
	 pzrq   	 DATE,
	 pzlx   	 VARCHAR(1),
    pzh    	 VARCHAR(4),
	 fj	  	 SMALLINT,
	 zy     	 VARCHAR(30),
    kmdm	  	 VARCHAR(20),
	 bmry	  	 VARCHAR(12),
	 jord	  	 SMALLINT,
	 j	  		 DOUBLE,
	 d	  		 DOUBLE,
    shy	  	 VARCHAR(12),
    zdy	  	 VARCHAR(12),
	 czy	  	 VARCHAR(12),
    shbz   	 SMALLINT,
    sl     	 DOUBLE,
    dj     	 DOUBLE,
    proj   	 VARCHAR(20),
    amoform	 VARCHAR(248),
    qtyform	 VARCHAR(248),
	 scode	 VARCHAR(4),
    ca_mon 	 INTEGER,	
    zphjsdjh VARCHAR(20),
    wbje     DOUBLE,
    hl       DOUBLE,
    dqh      VARCHAR(4),
    gg       VARCHAR(14),
    dwdm     VARCHAR(4),
    lxr      VARCHAR(12),
    jsr      VARCHAR(12),									
	 PRIMARY KEY (id)
);

CREATE TABLE ca_def
(
	id			INTEGER NOT NULL,
	title		VARCHAR(64),
	def		VARCHAR(128),
	def_int1	INTEGER,
	def_int2	INTEGER,
	def_str1	VARCHAR(64),
	def_DATE	DATE,
	Primary key (id)
);

[CREATE INDEX]
DROP INDEX idx001;
DROP INDEX idx002;

DROP INDEX idx005;

DROP INDEX idx010;

DROP INDEX idx015;
DROP INDEX idx016;
DROP INDEX idx017;
DROP INDEX idx018;

DROP INDEX idx020;
DROP INDEX idx021;
DROP INDEX idx022;
DROP INDEX idx023;

DROP INDEX idx030;

DROP INDEX idx035;

CREATE INDEX idx001 ON ca_bth(batchno);
CREATE INDEX idx002 ON ca_bth(ca_mon,ue_code,objectno);

CREATE INDEX idx005 ON ca_mtx(ca_mon,ue_code,objectno,itemcode);

CREATE INDEX idx010 ON ca_jbb(ca_mon,billno,jobno);

CREATE INDEX idx015 ON ca_expb(ca_mon,billno);
CREATE INDEX idx016 ON ca_expb(ca_mon,extype,billno);
CREATE INDEX idx017 ON ca_expb(ca_mon,t_object,t_center,t_item);
CREATE INDEX idx018 ON ca_expb(ca_mon,t_batch,t_center,t_item);

CREATE INDEX idx020 ON ca_rd(ca_mon,billno);
CREATE INDEX idx021 ON ca_rd(ca_mon,extype,billno);
CREATE INDEX idx022 ON ca_rd(ca_mon,objectno,centerno,itemcode);
CREATE INDEX idx023 ON ca_rd(ca_mon,batchno,centerno,itemcode);


CREATE INDEX idx030 ON ca_aexp(ca_mon,centerno,itemcode,callno);

CREATE INDEX idx035 ON cb_pz(ca_mon,pzh);
           