[CREATE TABLE]
CREATE TABLE CA_CTR
(
	CENTERNO	VARCHAR2(20) NOT NULL,
	CTNAME	VARCHAR2(64),
	LSIGN		NUMBER(3,0),
	CTTYPE	VARCHAR2(4),
	ISZY		NUMBER(3,0),
	ZYBM		VARCHAR2(20),
	ALLRATE	NUMBER(18,8)
);
CREATE TABLE CA_ITEM
(
	ITEMCODE	VARCHAR2(20) NOT NULL,
	ITEMNAME	VARCHAR2(64),
	LSIGN		NUMBER(3,0),
	ITEMTYPE	VARCHAR2(4),
	WLBM		VARCHAR2(20),
	AORD		NUMBER(3,0),
	FORV		NUMBER(3,0),
	ABC_TYPE	VARCHAR2(4),
	CALLNO	VARCHAR2(4),
	MSABLE	NUMBER(3,0),
	QTYADD	NUMBER(3,0),
	MUNIT		VARCHAR2(4),
	NUNIT		VARCHAR2(4),
	ISMAIN	NUMBER(3,0),
	LVTYPE	VARCHAR2(4),
	LVNUM		NUMBER(3,0),
	PLANPRI	NUMBER(18,8),
	OPRI		NUMBER(18,8),
	ACTNO		VARCHAR2(20),
	OACTNO	VARCHAR2(20),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_UET
(
	ID		   NUMBER(10,0) NOT NULL,
	CALLNO	VARCHAR2(4),
	ALLNAME	VARCHAR2(64),
	ISIGN		NUMBER(3,0),
	ALLNOTE	VARCHAR2(64)
);
CREATE TABLE CA_UER
(
	CENTERNO	VARCHAR2(20) NOT NULL,
	ITEMCODE	VARCHAR2(20) NOT NULL,
	CALLNO	VARCHAR2(4)
);
CREATE TABLE CA_OBJ
(
	OBJECTNO	VARCHAR2(20) NOT NULL,
	OBNAME	VARCHAR2(64),
	OBTYPE	VARCHAR2(4),
	LSIGN		NUMBER(3,0),
	ITEMNO	VARCHAR2(20),
	SUBNAME	VARCHAR2(40),
	MUNIT		VARCHAR2(4),
	NUNIT		VARCHAR2(4),
	MALLNO	VARCHAR2(4),
	ALLRATE	NUMBER(18,8),
	BADRATE	NUMBER(18,8),
	SALEPRI	NUMBER(18,8),
	QTYTOTAL	NUMBER(18,8),
	AMOTOTAL	NUMBER(18,8),
	SFIXCOST	NUMBER(18,8),
	UFIXCOST	NUMBER(18,8),
	UVARCOST	NUMBER(18,8),
	UOTHCOST	NUMBER(18,8),
	ITEMCODE	VARCHAR2(20),
	FLOWNO   VARCHAR2(20),
	ACTNO		VARCHAR2(20),
	OACTNO	VARCHAR2(20),
	OBNOTE	VARCHAR2(64),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_FLOW
(
	FLOWNO	VARCHAR2(20) NOT NULL,
	CENTERNO	VARCHAR2(20) NOT NULL,
	FLOWNAME	VARCHAR2(64),
	ISPRI		NUMBER(3,0),
	ICOURSE	NUMBER(3,0),
	DESCR		VARCHAR2(64)
);
CREATE TABLE CA_MDL
(
	FLOWNO	VARCHAR2(20) NOT NULL,
	OBJECTNO	VARCHAR2(20) NOT NULL,
	CENTERNO	VARCHAR2(20) NOT NULL,
	ITEMCODE	VARCHAR2(20) NOT NULL,
	ICOURSE	NUMBER(3,0),
	MALLPER	NUMBER(18,8),
	MALLRATE	NUMBER(18,8),
	MALLAMO	NUMBER(18,8),
	MDQUA		NUMBER(18,8),
	MDAMO		NUMBER(18,8),
	ADQUA		NUMBER(18,8),
	ADAMO		NUMBER(18,8),	
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_BTH
(
	ID		   NUMBER(10,0) NOT NULL,
	BATCHNO	VARCHAR2(20),
	FCODE		VARCHAR2(20),
	UE_CODE	VARCHAR2(20),
	BATYPE	VARCHAR2(4),
	DEPTNO	VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	FLOWNO	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	BDATE		DATE,
	EDATE		DATE,
	TSIGN		NUMBER(3,0),
	CHKSIGN	NUMBER(3,0),
	COMSIGN	NUMBER(3,0),
	ORD		VARCHAR2(20),
	CHM		VARCHAR2(20),
	INM		VARCHAR2(20),
	BANOTE	VARCHAR2(64),
	QTY_PLAN	NUMBER(18,8),
	QTY_FONT	NUMBER(18,8),
	AMO_FONT	NUMBER(18,8),
	QTY_OUTP	NUMBER(18,8),
	AMO_OUTP	NUMBER(18,8),
	AMO_SALE	NUMBER(18,8),
	AMO_STAD	NUMBER(18,8),
	QTY_NEXT	NUMBER(18,8),
	AMO_NEXT	NUMBER(18,8),
	QTY_TRA	NUMBER(18,8),
	QTY_TRB	NUMBER(18,8),
	QTY_TRC	NUMBER(18,8),
	QTY_TRD	NUMBER(18,8),
	QTY_TRE	NUMBER(18,8),
	QTY_TRF	NUMBER(18,8),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_MTX
(
	BATCHNO	VARCHAR2(20) NOT NULL,
	CENTERNO	VARCHAR2(20) NOT NULL,
	ITEMCODE	VARCHAR2(20) NOT NULL,
	DEPTNO	VARCHAR2(20),
	UE_CODE	VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	AORD		NUMBER(3,0),
	MSUNIT	VARCHAR2(4),
	ICOURSE	NUMBER(3,0),
	QTY_PLAN	NUMBER(18,8),
	AMO_PLAN	NUMBER(18,8),
	QTY_FONT	NUMBER(18,8),
	AMO_FONT	NUMBER(18,8),
	PER_FONT	NUMBER(18,8),
	QTY_CUR	NUMBER(18,8),
	AMO_CUR	NUMBER(18,8),
	QTY_OUTP	NUMBER(18,8),
	AMO_OUTP	NUMBER(18,8),
	QTY_NEXT	NUMBER(18,8),
	AMO_NEXT	NUMBER(18,8),
	PER_NEXT	NUMBER(18,8),
	ALLPER   NUMBER(18,8),
	DEC_RPA	NUMBER(18,8),
	DEC_RPB	NUMBER(18,8),
	DEC_RPC	NUMBER(18,8),
	DEC_RPD	NUMBER(18,8),
	DEC_RPE	NUMBER(18,8),
	DEC_RPF	NUMBER(18,8),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_JBT
(
	JOBNO		VARCHAR2(4) NOT NULL,
	JOBNAME	VARCHAR2(64),
	ABC_TYPE	VARCHAR2(4),
	MSUNIT	VARCHAR2(4),
	JOTYPE	NUMBER(3,0),
	DESCR		VARCHAR2(64)
);
CREATE TABLE CA_RTN
(
	CENTERNO	VARCHAR2(20) NOT NULL,
	OBJECTNO	VARCHAR2(20) NOT NULL,
	JOBNO		VARCHAR2(4) NOT NULL,
	RA_QUA	NUMBER(18,8)
);
CREATE TABLE CA_JBQ
(
	CENTERNO	VARCHAR2(20) NOT NULL,
	BATCHNO	VARCHAR2(20) NOT NULL,
	JOBNO		VARCHAR2(4)  NOT NULL,
	DEPTNO	VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	QTY_RAT	NUMBER(18,8),
	QTY_REA	NUMBER(18,8)
);
CREATE TABLE CA_JBB
(
	ID		   NUMBER(10,0) NOT NULL,
	BILLNO	VARCHAR2(20),
	JOBNO		VARCHAR2(4),
	DEPTNO	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	CHKSIGN	NUMBER(3,0),
	BDATE		DATE,
	EDATE		DATE,
	INM		VARCHAR2(20),
	CHM		VARCHAR2(20),
	ZYBM		VARCHAR2(20),
	CENTERNO	VARCHAR2(20),
	BATCHNO	VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	QTY		NUMBER(18,8),
	UNITCON	NUMBER(18,8),
	TOTALQTY	NUMBER(18,8),
	JS_NUMA	NUMBER(18,8),
	JS_NUMB	NUMBER(18,8),
	JS_NUMC	NUMBER(18,8),
	JSNOTE	VARCHAR2(64),
	JS_INFOA	VARCHAR2(64),
	JS_INFOB	VARCHAR2(64),
	JS_INFOC	VARCHAR2(64),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_DSF
(
	ID			NUMBER(10,0) NOT NULL,
	SYSTP		NUMBER(3,0),
	GETTYPE	VARCHAR2(4),
	CENTERNO	VARCHAR2(20),
	ITEMCODE	VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	CALLNO	VARCHAR2(4),
	ALLRATE	NUMBER(18,8),
	CACSIGN	NUMBER(3,0)
);
CREATE TABLE CA_DSRD
(
	ID			NUMBER(10,0) NOT NULL,
	ICOURSE	NUMBER(3,0) NOT NULL,
	CACTP		VARCHAR2(4),
	LBRACKET	VARCHAR2(12),
	LISTID	VARCHAR2(12),
	MATCHTP	VARCHAR2(4),
	RBRACKET	VARCHAR2(12),
	SVALUE	VARCHAR2(64)
);
CREATE TABLE CA_EXPB
(
	ID			NUMBER(10,0) NOT NULL,
	BILLNO	VARCHAR2(20),
	EXTYPE	VARCHAR2(4),
	ITEMTYPE	VARCHAR2(4),
	JOBNO		VARCHAR2(4),
	ORIGNO	VARCHAR2(20),
	CHKSIGN	NUMBER(3,0),
	CA_MON	NUMBER(10,0),
	RDATE		DATE,
	WHNO		VARCHAR2(20),
	DEPTNO	VARCHAR2(20),
	CENTERNO	VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	BATCHNO	VARCHAR2(20),
	CHM		VARCHAR2(20),
	INM		VARCHAR2(20),
	ISCACU	NUMBER(3,0),
	SYSMAKE	NUMBER(3,0),
	T_DEPT	VARCHAR2(20),
	T_CENTER	VARCHAR2(20),
	T_ITEM	VARCHAR2(20),
	T_ITEMNO	VARCHAR2(20),
	RANKS		VARCHAR2(2),
	T_OBJECT	VARCHAR2(20),
	T_BATCH	VARCHAR2(20),
	PRI		NUMBER(18,8),
	QUA		NUMBER(18,8),
	AMO		NUMBER(18,8),
	EXNOTE	VARCHAR2(64),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_RD
(
	ID			NUMBER(10,0) NOT NULL,
	BILLNO	VARCHAR2(20),
	EXTYPE	VARCHAR2(4),
	ITEMTYPE	VARCHAR2(4),
	CA_MON	NUMBER(10,0),
	ORGINO	VARCHAR2(20),
	DEPTNO	VARCHAR2(20),
	CENTERNO	VARCHAR2(20),
	ITEMCODE	VARCHAR2(20),
	MSUNIT	VARCHAR2(4),
	OBJECTNO	VARCHAR2(20),
	BATCHNO	VARCHAR2(20),
	RDATE		DATE,
	QTY		NUMBER(18,8),
	AMO		NUMBER(18,8),
	ISCACU	NUMBER(3,0),
	RENOTE	VARCHAR2(64),
	DE_INT	NUMBER(10,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_MDC
(
	ID			NUMBER(10,0) NOT NULL,
	WHID		VARCHAR2(20),
	OBJECTNO	VARCHAR2(20),
	ITEMCODE	VARCHAR2(20),
	ITEMNO	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	RANKS		VARCHAR2(2),
	MSUNIT	VARCHAR2(4),
	QTY_FONT	NUMBER(18,8),
	AMO_FONT	NUMBER(18,8),
	QTY_PUR	NUMBER(18,8),
	AMO_PUR	NUMBER(18,8),
	QTY_PRO	NUMBER(18,8),
	AMO_PRO	NUMBER(18,8),
	CHNOTE	VARCHAR2(64)
);
CREATE TABLE CA_ANM
(
	CENTERNO	VARCHAR2(20) NOT NULL,
	BATCHNO	VARCHAR2(20) NOT NULL,
	ITEMCODE	VARCHAR2(20) NOT NULL,
	CALLNO	VARCHAR2(4)  NOT NULL,
	OBJECTNO	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	QTY_BASE	NUMBER(18,8)
);
CREATE TABLE CA_AEXP
(
	ID			NUMBER(10,0) NOT NULL,
	CENTERNO	VARCHAR2(20),
	ITEMCODE	VARCHAR2(20),
	CA_MON	NUMBER(10,0),
	CALLNO	VARCHAR2(4),
	MSUNIT	VARCHAR2(4),
	ISTURN	NUMBER(3,0),
	ISALL		NUMBER(3,0),
	QTY_ADD	NUMBER(18,8),
	QTY_ALL	NUMBER(18,8),
	AMO_ALL	NUMBER(18,8)
);
CREATE TABLE CA_PROP
(
	ID			NUMBER(10,0) NOT NULL,
	P01		NUMBER(10,0),
	P02		NUMBER(10,0),
	P03		NUMBER(10,0),
	P04		NUMBER(10,0),
	P05		NUMBER(10,0),
	P06		NUMBER(10,0),
	P07		NUMBER(10,0),
	P08		NUMBER(10,0),
	P09		NUMBER(10,0),
	P10		NUMBER(10,0),
	P11		NUMBER(10,0),
	P12		NUMBER(10,0)	
);
CREATE TABLE CA_UCH
(
	FUNIT		VARCHAR2(4) NOT NULL,
	NUNIT		VARCHAR2(4) NOT NULL,
	RELAT		NUMBER(18,8),
	MSNOTE	VARCHAR2(64)
);
CREATE TABLE CA_CDF
(
	ID				VARCHAR2(4) NOT NULL,
	SFNAME		VARCHAR2(64),
	SFTYPE		VARCHAR2(4),
	MAXCLA		NUMBER(10,0),
	MAXLEN		NUMBER(10,0),
	SINLEN		NUMBER(10,0),
	ISMANU		NUMBER(3,0)
);
CREATE TABLE CA_CDRD
(
	ID			VARCHAR2(4) NOT NULL,
	CLA		NUMBER(10,0) NOT NULL,
	LEN		NUMBER(10,0),
	VAL		VARCHAR2(20),
	CONSTR	VARCHAR2(20),
	DE_INT1 	NUMBER(10,0),
	DE_INT2  NUMBER(10,0),
  	DE_STR1	VARCHAR2(12),
  	DE_STR2 	VARCHAR2(64)
);

CREATE TABLE CA_ABCTP
(
 	ABC_TYPE	VARCHAR2(4) NOT NULL,
  	DESCR		VARCHAR2(64),
  	DE_STR1 	VARCHAR2(12),
  	DE_STR2 	VARCHAR2(12),
  	DE_STR3 	VARCHAR2(64)
);
CREATE TABLE CA_MA
(
	MALLNO	VARCHAR2(4) NOT NULL,
	DESCR		VARCHAR2(64)
);
CREATE TABLE CA_OBTP
(
	OBTYPE	VARCHAR2(4) NOT NULL,
	DESCR		VARCHAR2(64)
);
CREATE TABLE CA_BATP
(
	BATYPE	VARCHAR2(4) NOT NULL,
	DESCR		VARCHAR2(64)
);
CREATE TABLE CA_EXTP
(
	EXTYPE	VARCHAR2(4) NOT NULL,
	DESCR		VARCHAR2(64),
   ISADD		NUMBER(3,0),
	ISAMO		NUMBER(3,0),
	DE_STR	VARCHAR2(64)
);
CREATE TABLE CA_ITP
(
	ITEMTYPE	VARCHAR2(4) NOT NULL,
	DESCR		VARCHAR2(64)
);
CREATE TABLE CA_UNIT
(
	UNITNO	VARCHAR2(4) NOT NULL,
	DESCR		VARCHAR2(64),
	DEFSTR	VARCHAR2(20),
	ISMAIN	NUMBER(3,0)
);
CREATE TABLE CB_QX
(
	 XM  		VARCHAR2(20) NOT NULL ,		
	 MM  		VARCHAR2(254),					
	 BM  		VARCHAR2(20),				
	 CNO 		VARCHAR2(20),
	 Q0  		NUMBER(3,0),
    Q1  		NUMBER(3,0),
	 Q1_1	 	NUMBER(3,0), 
	 Q1_2  	NUMBER(3,0),
	 Q1_3  	NUMBER(3,0),    
	 Q1_4  	NUMBER(3,0),
	 Q1_5  	NUMBER(3,0),
	 Q1_6  	NUMBER(3,0),					
	 Q1_7  	NUMBER(3,0),					
	 Q1_8  	NUMBER(3,0),					
	 Q1_9  	NUMBER(3,0),					
	 Q1_A 	NUMBER(3,0),					
	 Q1_B  	NUMBER(3,0),					 
	 Q1_C  	NUMBER(3,0),					
	 Q1_D  	NUMBER(3,0),               
	 Q1_E  	NUMBER(3,0),					
	 Q1_F  	NUMBER(3,0),	 
	 Q1_G  	NUMBER(3,0),               
	 Q1_H  	NUMBER(3,0),					
	 Q1_I  	NUMBER(3,0),					
	 Q2    	NUMBER(3,0),					
	 Q2_1  	NUMBER(3,0), 
	 Q2_2  	NUMBER(3,0),
	 Q2_3  	NUMBER(3,0),    
	 Q2_4  	NUMBER(3,0),
	 Q2_5  	NUMBER(3,0),
	 Q2_6  	NUMBER(3,0),					
	 Q2_7  	NUMBER(3,0),
	 Q2_8  	NUMBER(3,0),
	 Q3    	NUMBER(3,0),					
	 Q3_1  	NUMBER(3,0), 
	 Q3_2  	NUMBER(3,0),
	 Q3_3  	NUMBER(3,0),    
	 Q3_4  	NUMBER(3,0),
	 Q3_5  	NUMBER(3,0),
	 Q3_6  	NUMBER(3,0),					
	 Q3_7  	NUMBER(3,0),					
	 Q3_8  	NUMBER(3,0),					
	 Q3_9  	NUMBER(3,0),
	 Q3_A  	NUMBER(3,0),
	 Q3_B  	NUMBER(3,0),					
	 Q3_C  	NUMBER(3,0),	
	 Q4    	NUMBER(3,0),					
	 Q4_1  	NUMBER(3,0), 
	 Q4_2  	NUMBER(3,0),
	 Q4_3  	NUMBER(3,0),    
	 Q4_4  	NUMBER(3,0),
	 Q4_5  	NUMBER(3,0),
	 Q4_6  	NUMBER(3,0),
	 Q5    	NUMBER(3,0),
	 Q5_1  	NUMBER(3,0), 
	 Q5_2  	NUMBER(3,0),
	 Q5_3  	NUMBER(3,0),    
	 Q5_4  	NUMBER(3,0),
	 Q5_5  	NUMBER(3,0),
	 Q5_6 	NUMBER(3,0),					
	 Q5_7  	NUMBER(3,0),					
	 Q5_8  	NUMBER(3,0),					
	 Q5_9  	NUMBER(3,0),
	 Q5_A  	NUMBER(3,0),					
	 Q5_B  	NUMBER(3,0),					 
	 Q5_C 	NUMBER(3,0),					
	 Q5_D  	NUMBER(3,0),
	 Q6    	NUMBER(3,0),
    Q7		NUMBER(3,0),
	 Q7_1  	NUMBER(3,0), 
	 Q7_2  	NUMBER(3,0),
	 Q7_3  	NUMBER(3,0),    
	 Q7_4  	NUMBER(3,0)	
);

CREATE TABLE CB_PZ
(
	 ID	  	 NUMBER(10,0) NOT NULL ,		
	 JZBZ	  	 NUMBER(3,0),
	 CSIGN  	 NUMBER(3,0),
	 PZRQ   	 DATE,
	 PZLX   	 VARCHAR2(1),
    PZH    	 VARCHAR2(4),
	 FJ	  	 NUMBER(3,0),
	 ZY     	 VARCHAR2(30),
    KMDM	  	 VARCHAR2(20),
	 BMRY	  	 VARCHAR2(12),
	 JORD	  	 NUMBER(3,0),
	 J	  		 NUMBER(18,8),
	 D	  		 NUMBER(18,8),
    SHY	  	 VARCHAR2(12),
    ZDY	  	 VARCHAR2(12),
	 CZY	  	 VARCHAR2(12),
    SHBZ   	 NUMBER(3,0),
    SL     	 NUMBER(18,8),
    DJ     	 NUMBER(18,8),
    PROJ   	 VARCHAR2(20),
    AMOFORM	 VARCHAR2(248),
    QTYFORM	 VARCHAR2(248),
	 SCODE	 VARCHAR2(4),
    CA_MON 	 NUMBER(10,0),
    ZPHJSDJH VARCHAR2(20),
    WBJE     NUMBER(18,8),
    HL       NUMBER(18,8),
    DQH      VARCHAR2(4),
    GG       VARCHAR2(14),
    DWDM     VARCHAR2(4),
    LXR      VARCHAR2(12),
    JSR      VARCHAR2(12)	
);

CREATE TABLE CA_DEF
(
	ID			NUMBER(10,0) NOT NULL,
	TITLE		VARCHAR2(64),
	DEF		VARCHAR2(128),
	DEF_INT1	NUMBER(10,0),
	DEF_INT2	NUMBER(10,0),
	DEF_STR1	VARCHAR2(64),
	DEF_DATE	DATE
);
ALTER TABLE CA_CTR    ADD ( CONSTRAINT  ID_CA_CTR     PRIMARY KEY (CENTERNO));
ALTER TABLE CA_ITEM   ADD ( CONSTRAINT  ID_CA_ITEM 	PRIMARY KEY (ITEMCODE));
ALTER TABLE CA_UET    ADD ( CONSTRAINT  ID_CA_UET 	   PRIMARY KEY (ID));
ALTER TABLE CA_UER    ADD ( CONSTRAINT  ID_CA_UER  	PRIMARY KEY (CENTERNO,ITEMCODE));
ALTER TABLE CA_OBJ    ADD ( CONSTRAINT  ID_CA_OBJ  	PRIMARY KEY (OBJECTNO));
ALTER TABLE CA_FLOW   ADD ( CONSTRAINT  ID_CA_FLOW 	PRIMARY KEY (FLOWNO,CENTERNO));
ALTER TABLE CA_MDL    ADD ( CONSTRAINT  ID_CA_MDL  	PRIMARY KEY (FLOWNO,OBJECTNO,CENTERNO,ITEMCODE));
ALTER TABLE CA_BTH    ADD ( CONSTRAINT  ID_CA_BTH   	PRIMARY KEY (ID));
ALTER TABLE CA_MTX    ADD ( CONSTRAINT  ID_CA_MTX    	PRIMARY KEY (BATCHNO,CENTERNO,ITEMCODE));
ALTER TABLE CA_JBT    ADD ( CONSTRAINT  ID_CA_JBT     PRIMARY KEY (JOBNO));
ALTER TABLE CA_RTN    ADD ( CONSTRAINT  ID_CA_RTN  	PRIMARY KEY (CENTERNO,OBJECTNO,JOBNO));
ALTER TABLE CA_JBQ    ADD ( CONSTRAINT  ID_CA_JBQ   	PRIMARY KEY (CENTERNO,BATCHNO,JOBNO));
ALTER TABLE CA_JBB    ADD ( CONSTRAINT  ID_CA_JBB   	PRIMARY KEY (ID));
ALTER TABLE CA_DSF    ADD ( CONSTRAINT  ID_CA_DSF   	PRIMARY KEY (ID));
ALTER TABLE CA_DSRD	 ADD ( CONSTRAINT  ID_CA_DSRD    PRIMARY KEY (ID,ICOURSE));
ALTER TABLE CA_EXPB   ADD ( CONSTRAINT  ID_CA_EXPB 	PRIMARY KEY (ID));
ALTER TABLE CA_RD     ADD ( CONSTRAINT  ID_CA_RD   	PRIMARY KEY (ID));
ALTER TABLE CA_MDC    ADD ( CONSTRAINT  ID_CA_MDC  	PRIMARY KEY (ID));
ALTER TABLE CA_ANM    ADD ( CONSTRAINT  ID_CA_ANM  	PRIMARY KEY (CENTERNO,BATCHNO,ITEMCODE,CALLNO));
ALTER TABLE CA_AEXP   ADD ( CONSTRAINT  ID_CA_AEXP   	PRIMARY KEY (ID));
ALTER TABLE CA_PROP   ADD ( CONSTRAINT  ID_CA_PROP 	PRIMARY KEY (ID));
ALTER TABLE CA_UCH    ADD ( CONSTRAINT  ID_CA_UCH  	PRIMARY KEY (FUNIT,NUNIT));
ALTER TABLE CA_CDF    ADD ( CONSTRAINT  ID_CA_CDF  	PRIMARY KEY (ID));
ALTER TABLE CA_CDRD   ADD ( CONSTRAINT  ID_CA_CDRD 	PRIMARY KEY (ID,CLA));
ALTER TABLE CA_ABCTP  ADD ( CONSTRAINT  ID_CA_ABCTP   PRIMARY KEY (ABC_TYPE));
ALTER TABLE CA_MA     ADD ( CONSTRAINT  ID_CA_MA   	PRIMARY KEY (MALLNO));
ALTER TABLE CA_OBTP   ADD ( CONSTRAINT  ID_CA_OBTP  	PRIMARY KEY (OBTYPE));
ALTER TABLE CA_BATP   ADD ( CONSTRAINT  ID_CA_BATP 	PRIMARY KEY (BATYPE));
ALTER TABLE CA_EXTP   ADD ( CONSTRAINT  ID_CA_EXTP 	PRIMARY KEY (EXTYPE));
ALTER TABLE CA_ITP    ADD ( CONSTRAINT  ID_CA_ITP  	PRIMARY KEY (ITEMTYPE));
ALTER TABLE CA_UNIT   ADD ( CONSTRAINT  ID_CA_UNIT 	PRIMARY KEY (UNITNO));
ALTER TABLE CB_QX     ADD ( CONSTRAINT  ID_CB_QX      PRIMARY KEY (XM));
ALTER TABLE CB_PZ     ADD ( CONSTRAINT	 ID_CB_PZ      PRIMARY KEY (ID));
ALTER TABLE CA_DEF    ADD ( CONSTRAINT  ID_CA_DEF   	PRIMARY KEY (ID));
[CREATE INDEX]
DROP INDEX IDX001;
DROP INDEX IDX002;

DROP INDEX IDX005;

DROP INDEX IDX010;

DROP INDEX IDX015;
DROP INDEX IDX016;
DROP INDEX IDX017;
DROP INDEX IDX018;

DROP INDEX IDX020;
DROP INDEX IDX021;
DROP INDEX IDX022;
DROP INDEX IDX023;

DROP INDEX IDX030;
DROP INDEX IDX035;

CREATE INDEX IDX001 ON CA_BTH(BATCHNO DESC);
CREATE INDEX IDX002 ON CA_BTH(CA_MON DESC,UE_CODE,OBJECTNO);

CREATE INDEX IDX005 ON CA_MTX(CA_MON DESC,UE_CODE,OBJECTNO,ITEMCODE);

CREATE INDEX IDX010 ON CA_JBB(CA_MON DESC,BILLNO,JOBNO);

CREATE INDEX IDX015 ON CA_EXPB(CA_MON DESC,BILLNO);
CREATE INDEX IDX016 ON CA_EXPB(CA_MON DESC,EXTYPE,BILLNO);
CREATE INDEX IDX017 ON CA_EXPB(CA_MON DESC,T_OBJECT,T_CENTER,T_ITEM);
CREATE INDEX IDX018 ON CA_EXPB(CA_MON DESC,T_BATCH DESC,T_CENTER,T_ITEM);

CREATE INDEX IDX020 ON CA_RD(CA_MON DESC,BILLNO);
CREATE INDEX IDX021 ON CA_RD(CA_MON DESC,EXTYPE,BILLNO);
CREATE INDEX IDX022 ON CA_RD(CA_MON DESC,OBJECTNO,CENTERNO,ITEMCODE);
CREATE INDEX IDX023 ON CA_RD(CA_MON DESC,BATCHNO DESC,CENTERNO,ITEMCODE);

CREATE INDEX IDX030 ON CA_AEXP(CA_MON DESC,CENTERNO,ITEMCODE,CALLNO);

CREATE INDEX IDX035 ON CB_PZ(CA_MON DESC,PZH);
           
