[CREATE TABLE]
CREATE TABLE ca_ctr
(
	centerno	varchar(20) NOT NULL,
	ctname	varchar(64) NULL,
	lsign		tinyint NULL,
	cttype	varchar(4) NULL,
	iszy		tinyint NULL,
	zybm		varchar(20) NULL,
	allrate	float NULL,	
	CONSTRAINT ca_ctrid Primary key NONCLUSTERED(centerno)
);
CREATE TABLE ca_item
(
	itemcode	varchar(20) NOT NULL,
	itemname	varchar(64) NULL,
	lsign		tinyint NULL,
	itemtype	varchar(4) NULL,
	wlbm		varchar(20) NULL,
	aord		tinyint NULL,
	forv		tinyint NULL,
	abc_type	varchar(4) NULL,
	callno	varchar(4) NULL,
	msable	tinyint NULL,
	qtyadd	tinyint NULL,
	munit		varchar(4) NULL,
	nunit		varchar(4) NULL,
	ismain	tinyint NULL,
	lvtype	varchar(4) NULL,
	lvnum		tinyint NULL,
	planpri	float NULL,
	opri		float NULL,
	actno		varchar(20) NULL,
	oactno	varchar(20) NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_itemid Primary key NONCLUSTERED (itemcode)
);
CREATE TABLE ca_uet
(
	id		   int NOT NULL,
	callno	varchar(4) NULL,
	allname	varchar(64) NULL,
	isign		tinyint NULL,
	allnote	varchar(64) NULL,	
	CONSTRAINT ca_uetid PRIMARY KEY NONCLUSTERED (id)
);
CREATE TABLE ca_uer
(
	centerno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	callno	varchar(4) NULL,
	CONSTRAINT ca_uerid PRIMARY KEY NONCLUSTERED (centerno,itemcode)
);
CREATE TABLE ca_obj
(
	objectno	varchar(20) NOT NULL,
	obname	varchar(64) NULL,
	obtype	varchar(4) NULL,
	lsign		tinyint NULL,
	itemno	varchar(20) NULL,
	subname	varchar(40) NULL,
	munit		varchar(4) NULL,
	nunit		varchar(4) NULL,
	mallno	varchar(4) NULL,
	allrate	float NULL,
	badrate	float NULL,
	salepri	float NULL,
	qtytotal	float NULL,
	amototal	float NULL,
	sfixcost	float NULL,
	ufixcost	float NULL,
	uvarcost	float NULL,
	uothcost	float NULL,
	itemcode	varchar(20) NULL,
	flowno   varchar(20) NULL,
	actno		varchar(20) NULL,
	oactno	varchar(20) NULL,
	obnote	varchar(64) NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_objid  PRIMARY KEY NONCLUSTERED (objectno)
);
CREATE TABLE ca_flow
(
	flowno	varchar(20) NOT NULL,
	centerno	varchar(20) NOT NULL,
	flowname	varchar(64) NULL,
	ispri		tinyint NULL,
	icourse	tinyint NULL,
	descr		varchar(64) NULL,	
	CONSTRAINT ca_flowid PRIMARY KEY NONCLUSTERED (flowno,centerno)
);
CREATE TABLE ca_mdl
(
	flowno	varchar(20) NOT NULL,
	objectno	varchar(20) NOT NULL,
	centerno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	icourse	tinyint NULL,
	mallper	float NULL,
	mallrate	float NULL,
	mallamo	float NULL,
	mdqua		float NULL,
	mdamo		float NULL,
	adqua		float NULL,
	adamo		float NULL,	
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_mdlid PRIMARY KEY NONCLUSTERED (flowno,objectno,centerno,itemcode)
);
CREATE TABLE ca_bth
(
	id		   int NOT NULL,
	batchno	varchar(20) NULL,
	fcode		varchar(20) NULL,
	ue_code	varchar(20) NULL,
	batype	varchar(4) NULL,
	deptno	varchar(20) NULL,
	objectno	varchar(20) NULL,
	flowno	varchar(20) NULL,
	ca_mon	int NULL,
	bdate		smalldatetime NULL,
	edate		smalldatetime NULL,
	tsign		tinyint NULL,
	chksign	tinyint NULL,
	comsign	tinyint NULL,
	ord		varchar(20) NULL,
	chm		varchar(20) NULL,
	inm		varchar(20) NULL,
	banote	varchar(64) NULL,
	qty_plan	float NULL,
	qty_font	float NULL,
	amo_font	float NULL,
	qty_outp	float NULL,
	amo_outp	float NULL,
	amo_sale	float NULL,
	amo_stad	float NULL,
	qty_next	float NULL,
	amo_next	float NULL,
	qty_tra	float NULL,
	qty_trb	float NULL,
	qty_trc	float NULL,
	qty_trd	float NULL,
	qty_tre	float NULL,
	qty_trf	float NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_bthid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_mtx
(
	batchno	varchar(20) NOT NULL,
	centerno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	deptno	varchar(20) NULL,
	ue_code	varchar(20) NULL,
	objectno	varchar(20) NULL,
	ca_mon	int NULL,
	aord		tinyint NULL,
	msunit	varchar(4) NULL,
	icourse	tinyint NULL,
	qty_plan	float NULL,
	amo_plan	float NULL,
	qty_font	float NULL,
	amo_font	float NULL,
	per_font	float NULL,
	qty_cur	float NULL,
	amo_cur	float NULL,
	qty_outp	float NULL,
	amo_outp	float NULL,
	qty_next	float NULL,
	amo_next	float NULL,
	per_next	float NULL,
	allper   float NULL,
	dec_rpa	float NULL,
	dec_rpb	float NULL,
	dec_rpc	float NULL,
	dec_rpd	float NULL,
	dec_rpe	float NULL,
	dec_rpf	float NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_mtxid Primary key NONCLUSTERED (batchno,centerno,itemcode)
);
CREATE TABLE ca_jbt
(
	jobno		varchar(4) NOT NULL,
	jobname	varchar(64) NULL,
	abc_type	varchar(4) NULL,
	msunit	varchar(4) NULL,
	jotype	tinyint NULL,
	descr		varchar(64) NULL,	
	CONSTRAINT ca_jbtid Primary key NONCLUSTERED (jobno)
);
CREATE TABLE ca_rtn
(
	centerno	varchar(20) NOT NULL,
	objectno	varchar(20) NOT NULL,
	jobno		varchar(4) NOT NULL,
	ra_qua	float NULL,
	CONSTRAINT ca_rtnid Primary key NONCLUSTERED (centerno,objectno,jobno)
);
CREATE TABLE ca_jbq
(
	centerno	varchar(20) NOT NULL,
	batchno	varchar(20) NOT NULL,
	jobno		varchar(4)  NOT NULL,
	deptno	varchar(20) NULL,
	objectno	varchar(20) NULL,
	ca_mon	int NULL,
	qty_rat	float NULL,
	qty_rea	float NULL,
	CONSTRAINT ca_jbqid Primary key NONCLUSTERED (centerno,batchno,jobno)
);
CREATE TABLE ca_jbb
(
	id		   int NOT NULL,
	billno	varchar(20) NULL,
	jobno		varchar(4) NULL,
	deptno	varchar(20) NULL,
	ca_mon	int NULL,
	chksign	tinyint NULL,
	bdate		smalldatetime NULL,
	edate		smalldatetime NULL,
	inm		varchar(20) NULL,
	chm		varchar(20) NULL,
	zybm		varchar(20) NULL,
	centerno	varchar(20) NULL,
	batchno	varchar(20) NULL,
	objectno	varchar(20) NULL,
	qty		float NULL,
	unitcon	float NULL,
	totalqty	float NULL,
	js_numa	float NULL,
	js_numb	float NULL,
	js_numc	float NULL,
	jsnote	varchar(64) NULL,
	js_infoa	varchar(64) NULL,
	js_infob	varchar(64) NULL,
	js_infoc	varchar(64) NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_jbbid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_dsf
(
	id			int NOT NULL,
	systp		tinyint NULL,
	gettype	varchar(4) NULL,
	centerno	varchar(20) NULL,
	itemcode	varchar(20) NULL,
	objectno	varchar(20) NULL,
	callno	varchar(4) NULL,
	allrate	float NULL,
	cacsign	tinyint NULL,
	CONSTRAINT ca_dsfid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_dsrd
(
	id			int NOT NULL,
	icourse	tinyint NOT NULL,
	cactp		varchar(4) NULL,
	lbracket	varchar(12) NULL,
	listid	varchar(12) NULL,
	matchtp	varchar(4) NULL,
	rbracket	varchar(12) NULL,
	svalue	varchar(64) NULL,
	CONSTRAINT ca_dsrdid Primary key NONCLUSTERED (id,icourse)
);
CREATE TABLE ca_expb
(
	id			int NOT NULL,
	billno	varchar(20) NULL,
	extype	varchar(4) NULL,
	itemtype	varchar(4) NULL,
	jobno		varchar(4) NULL,
	origno	varchar(20) NULL,
	chksign	tinyint NULL,
	ca_mon	int NULL,
	rdate		smalldatetime NULL,
	whno		varchar(20) NULL,
	deptno	varchar(20) NULL,
	centerno	varchar(20) NULL,
	objectno	varchar(20) NULL,
	batchno	varchar(20) NULL,
	chm		varchar(20) NULL,
	inm		varchar(20) NULL,
	iscacu	tinyint NULL,
	sysmake	tinyint NULL,
	t_dept	varchar(20) NULL,
	t_center	varchar(20) NULL,
	t_item	varchar(20) NULL,
	t_itemno	varchar(20) NULL,
	ranks		char(2) NULL,
	t_object	varchar(20) NULL,
	t_batch	varchar(20) NULL,
	pri		float NULL,
	qua		float NULL,
	amo		float NULL,
	exnote	varchar(64) NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_expbid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_rd
(
	id			int NOT NULL,
	billno	varchar(20) NULL,
	extype	varchar(4) NULL,
	itemtype	varchar(4) NULL,
	ca_mon	int NULL,
	orgino	varchar(20) NULL,
	deptno	varchar(20) NULL,
	centerno	varchar(20) NULL,
	itemcode	varchar(20) NULL,
	msunit	varchar(4) NULL,
	objectno	varchar(20) NULL,
	batchno	varchar(20) NULL,
	rdate		smalldatetime NULL,
	qty		float NULL,
	amo		float NULL,
	iscacu	tinyint NULL,
	renote	varchar(64) NULL,
	de_int	int NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_rdid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_mdc
(
	id			int NOT NULL,
	whid		varchar(20) NULL,
	objectno	varchar(20) NULL,
	itemcode	varchar(20) NULL,
	itemno	varchar(20) NULL,
	ca_mon	int NULL,
	ranks		char(2) NULL,
	msunit	varchar(4) NULL,
	qty_font	float NULL,
	amo_font	float NULL,
	qty_pur	float NULL,
	amo_pur	float NULL,
	qty_pro	float NULL,
	amo_pro	float NULL,
	chnote	varchar(64) NULL,	
	CONSTRAINT ca_mdcid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_anm
(
	centerno	varchar(20) NOT NULL,
	batchno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	callno	varchar(4)  NOT NULL,
	objectno	varchar(20) NULL,
	ca_mon	int NULL,
	qty_base	float NULL,
	CONSTRAINT ca_anmid Primary key NONCLUSTERED (centerno,batchno,itemcode,callno)
);
CREATE TABLE ca_aexp
(
	id			int NOT NULL,
	centerno	varchar(20) NULL,
	itemcode	varchar(20) NULL,
	ca_mon	int NULL,
	callno	varchar(4) NULL,
	msunit	varchar(4) NULL,
	isturn	tinyint NULL,
	isall		tinyint NULL,
	qty_add	float NULL,
	qty_all	float NULL,
	amo_all	float NULL,
	CONSTRAINT ca_aexpid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_prop
(
	id			int NOT NULL,
	p01		int NULL,
	p02		int NULL,
	p03		int NULL,
	p04		int NULL,
	p05		int NULL,
	p06		int NULL,
	p07		int NULL,
	p08		int NULL,
	p09		int NULL,
	p10		int NULL,
	p11		int NULL,
	p12		int NULL,	
	CONSTRAINT ca_prop Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_uch
(
	funit		varchar(4) NOT NULL,
	nunit		varchar(4) NOT NULL,
	relat		float NULL,
	msnote		varchar(64) NULL,
	CONSTRAINT ca_uchid Primary key NONCLUSTERED (funit ,nunit)
);
CREATE TABLE ca_cdf
(
	id				varchar(4) NOT NULL,
	sfname		varchar(64) NULL,
	sftype		varchar(4) NULL,
	maxcla		int NULL,
	maxlen		int NULL,
	sinlen		int NULL,
	ismanu		tinyint NULL,
	CONSTRAINT ca_cdfid Primary key NONCLUSTERED (id)
);
CREATE TABLE ca_cdrd
(
	id			varchar(4) NOT NULL,
	cla		int NOT NULL,
	len		int NULL,
	val		varchar(20) NULL,
	constr	varchar(20) NULL,
	de_int1 	int NULL,
	de_int2  int NULL,
  	de_str1	varchar(12) NULL,
  	de_str2 	varchar(64) NULL,
	CONSTRAINT ca_cdrdif Primary key NONCLUSTERED (id,cla)
);
CREATE TABLE ca_abctp
(
 	abc_type	varchar(4) NOT NULL,
  	descr		varchar(64) NULL,
  	de_str1 	varchar(12) NULL,
  	de_str2 	varchar(12) NULL,
  	de_str3 	varchar(64) NULL,
   CONSTRAINT ca_abctpid Primary key NONCLUSTERED (abc_type)
);
CREATE TABLE ca_ma
(
	mallno	varchar(4) NOT NULL,
	descr		varchar(64) NULL,
	CONSTRAINT ca_maid Primary key NONCLUSTERED (mallno)
);
CREATE TABLE ca_obtp
(
	obtype	varchar(4) NOT NULL,
	descr		varchar(64) NULL,
	CONSTRAINT ca_obtpid Primary key NONCLUSTERED (obtype)
);
CREATE TABLE ca_batp
(
	batype	varchar(4) NOT NULL,
	descr		varchar(64) NULL,
	CONSTRAINT ca_batpid Primary key NONCLUSTERED (batype)
);
CREATE TABLE ca_extp
(
	extype	varchar(4) NOT NULL,
	descr		varchar(64) NULL,
   isadd		tinyint NULL,
	isamo		tinyint NULL,
	de_str	varchar(64) NULL,
	CONSTRAINT ca_extpid Primary key NONCLUSTERED (extype)
);
CREATE TABLE ca_itp
(
	itemtype	varchar(4) NOT NULL,
	descr		varchar(64) NULL,
	CONSTRAINT ca_itpid Primary key NONCLUSTERED (itemtype)
);
CREATE TABLE ca_unit
(
	unitno	varchar(4) NOT NULL,
	descr		varchar(64) NULL,
	defstr	varchar(20) NULL,
	ismain	tinyint NULL,
	CONSTRAINT ca_unitid Primary key NONCLUSTERED (unitno)
);
CREATE TABLE cb_qx
(
	 xm  		varchar(20) NOT NULL ,		
	 mm  		varchar(254) NULL,					
	 bm  		varchar(20) NULL,				
	 cno 		varchar(20) NULL,
	 q0  		tinyint NULL,
    q1  		tinyint NULL,
	 q1_1	 	tinyint NULL, 
	 q1_2  	tinyint NULL,
	 q1_3  	tinyint NULL,    
	 q1_4  	tinyint NULL,
	 q1_5  	tinyint NULL,
	 q1_6  	tinyint NULL,					
	 q1_7  	tinyint NULL,					
	 q1_8  	tinyint NULL,					
	 q1_9  	tinyint NULL,					
	 q1_a 	tinyint NULL,					
	 q1_b  	tinyint NULL,					 
	 q1_c  	tinyint NULL,					
	 q1_d  	tinyint NULL,               
	 q1_e  	tinyint NULL,					
	 q1_f  	tinyint NULL,	 
	 q1_g  	tinyint NULL,               
	 q1_h  	tinyint NULL,					
	 q1_i  	tinyint NULL,					
	 q2    	tinyint NULL,					
	 q2_1  	tinyint NULL, 
	 q2_2  	tinyint NULL,
	 q2_3  	tinyint NULL,    
	 q2_4  	tinyint NULL,
	 q2_5  	tinyint NULL,
	 q2_6  	tinyint NULL,					
	 q2_7  	tinyint NULL,
	 q2_8  	tinyint NULL,
	 q3    	tinyint NULL,					
	 q3_1  	tinyint NULL, 
	 q3_2  	tinyint NULL,
	 q3_3  	tinyint NULL,    
	 q3_4  	tinyint NULL,
	 q3_5  	tinyint NULL,
	 q3_6  	tinyint NULL,					
	 q3_7  	tinyint NULL,					
	 q3_8  	tinyint NULL,					
	 q3_9  	tinyint NULL,
	 q3_a  	tinyint NULL,
	 q3_b  	tinyint NULL,					
	 q3_c  	tinyint NULL,	
	 q4    	tinyint NULL,					
	 q4_1  	tinyint NULL, 
	 q4_2  	tinyint NULL,
	 q4_3  	tinyint NULL,    
	 q4_4  	tinyint NULL,
	 q4_5  	tinyint NULL,
	 q4_6  	tinyint NULL,
	 q5    	tinyint NULL,
	 q5_1  	tinyint NULL, 
	 q5_2  	tinyint NULL,
	 q5_3  	tinyint NULL,    
	 q5_4  	tinyint NULL,
	 q5_5  	tinyint NULL,
	 q5_6 	tinyint NULL,					
	 q5_7  	tinyint NULL,					
	 q5_8  	tinyint NULL,					
	 q5_9  	tinyint NULL,
	 q5_a  	tinyint NULL,					
	 q5_b  	tinyint NULL,					 
	 q5_c 	tinyint NULL,					
	 q5_d  	tinyint NULL,
	 q6    	tinyint NULL,
    q7		tinyint NULL,
	 q7_1  	tinyint NULL, 
	 q7_2  	tinyint NULL,
	 q7_3  	tinyint NULL,    
	 q7_4  	tinyint NULL,	
	CONSTRAINT cb_qxid  PRIMARY KEY NONCLUSTERED (xm)
);

CREATE TABLE cb_pz
(
	 id	  	 int NOT NULL ,		
	 jzbz	  	 tinyint NULL,
	 csign  	 tinyint NULL,
	 pzrq   	 smalldatetime NULL,
	 pzlx   	 varchar(1) NULL,
    pzh    	 varchar(4) NULL,
	 fj	  	 tinyint NULL,
	 zy     	 varchar(30) NULL,
    kmdm	  	 varchar(20) NULL,
	 bmry	  	 varchar(12) NULL,
	 jord	  	 tinyint NULL,
	 j	  		 float NULL,
	 d	  		 float NULL,
    shy	  	 varchar(12) NULL,
    zdy	  	 varchar(12) NULL,
	 czy	  	 varchar(12) NULL,
    shbz   	 tinyint NULL,
    sl     	 float NULL,
    dj     	 float NULL,
    proj   	 varchar(20) NULL,
    amoform	 varchar(248) NULL,
    qtyform	 varchar(248) NULL,
	 scode	 varchar(4) NULL,
    ca_mon 	 int NULL,						
    zphjsdjh varchar(20) NULL,
    wbje     float NULL,
    hl       float NULL,
    dqh      varchar(4) NULL,
    gg       varchar(14) NULL,
    dwdm     varchar(4) NULL,
    lxr      varchar(12) NULL,
    jsr      varchar(12) NULL,	
	 CONSTRAINT cb_pzid PRIMARY KEY NONCLUSTERED (id)
);

CREATE TABLE ca_def
(
	id			int NOT NULL,
	title		varchar(64) NULL,
	def		varchar(128) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_str1	varchar(64) NULL,
	def_date	smalldatetime NULL,
	CONSTRAINT ca_defid Primary key NONCLUSTERED (id)
);

[CREATE INDEX]
DROP INDEX ca_bth.idx001;
DROP INDEX ca_bth.idx002;

DROP INDEX ca_mtx.idx005;

DROP INDEX ca_jbb.idx010;

DROP INDEX ca_expb.idx015;
DROP INDEX ca_expb.idx016;
DROP INDEX ca_expb.idx017;
DROP INDEX ca_expb.idx018;

DROP INDEX ca_rd.idx020;
DROP INDEX ca_rd.idx021;
DROP INDEX ca_rd.idx022;
DROP INDEX ca_rd.idx023;

DROP INDEX ca_aexp.idx030;

DROP INDEX cb_pz.idx035;

CREATE INDEX idx001 ON dbo.ca_bth(batchno);
CREATE INDEX idx002 ON dbo.ca_bth(ca_mon,ue_code,objectno);

CREATE INDEX idx005 ON dbo.ca_mtx(ca_mon,ue_code,objectno,itemcode);

CREATE INDEX idx010 ON dbo.ca_jbb(ca_mon,billno,jobno);

CREATE INDEX idx015 ON dbo.ca_expb(ca_mon,billno);
CREATE INDEX idx016 ON dbo.ca_expb(ca_mon,extype,billno);
CREATE INDEX idx017 ON dbo.ca_expb(ca_mon,t_object,t_center,t_item);
CREATE INDEX idx018 ON dbo.ca_expb(ca_mon,t_batch,t_center,t_item);

CREATE INDEX idx020 ON dbo.ca_rd(ca_mon,billno);
CREATE INDEX idx021 ON dbo.ca_rd(ca_mon,extype,billno);
CREATE INDEX idx022 ON dbo.ca_rd(ca_mon,objectno,centerno,itemcode);
CREATE INDEX idx023 ON dbo.ca_rd(ca_mon,batchno,centerno,itemcode);


CREATE INDEX idx030 ON dbo.ca_aexp(ca_mon,centerno,itemcode,callno);

CREATE INDEX idx035 ON dbo.cb_pz(ca_mon,pzh);
           

