[CREATE TABLE]

DROP VIEW "KC_MXHZ";

DROP VIEW "KC_CS";

CREATE TABLE "KC_FLAG"
(	ID		NUMBER(6,0) NOT NULL,
	TM		VARCHAR2(8),
	NOTE	VARCHAR2(20)
);

CREATE TABLE "KC_DEF"
(	ID			NUMBER(6,0) NOT NULL,
	TITLE		VARCHAR2(30),
	DEF		VARCHAR2(100)
);

CREATE TABLE "KC_CHLB"
(	DM		NUMBER(2,0) NOT NULL,
	MC		VARCHAR2(12),
	BZ		VARCHAR2(1)
);

CREATE TABLE "KC_YT"
(	DM		VARCHAR2(4) NOT NULL,
	MC		VARCHAR2(12),
	BZ		VARCHAR2(1),
	ROUTE VARCHAR2(128),
	MULTIPLE NUMBER(18,6)
);

CREATE TABLE "KC_LY"
(	DM		VARCHAR2(4) NOT NULL,
	MC		VARCHAR2(12),
	BZ		VARCHAR2(1),
	ROUTE VARCHAR2(128),
	MULTIPLE NUMBER(18,6)
);

CREATE TABLE "KC_JSFS"
(	DM		NUMBER(2,0) NOT NULL,
	JSFS	VARCHAR2(12)
);

CREATE TABLE "KC_CK"
(	DM		CHAR(2) NOT NULL,
	MC		VARCHAR2(12),
   PROP		  NUMBER(6,0),
   PRIO		  VARCHAR2(2),
   DEF_NUM1	  NUMBER(6,0),
   DEF_STR1	  VARCHAR2(8)
);

CREATE TABLE "KC_KW"
(	CKDM	VARCHAR2(2)	NOT NULL,
	DM		VARCHAR2(30) NOT NULL,
	MC		VARCHAR2(50)
);

CREATE TABLE "KC_BM"
(	DM		VARCHAR2(8) NOT NULL,
	MC		VARCHAR2(16),
   DEF_STR1 VARCHAR2(8),
   DEF_STR2 VARCHAR2(30) 
);

CREATE TABLE "KC_FF"
(	ID		NUMBER(2,0) NOT NULL,
	MC		VARCHAR2(16) 
);

CREATE TABLE "KC_XESET"
(	ID		VARCHAR2(6) NOT NULL,
	NUM	NUMBER(3,0) NOT NULL,
	NUMS	VARCHAR2(30),
	SMON	VARCHAR2(2),
	PZH	VARCHAR2(4),
	CKPZH 	VARCHAR2(6),
	DM	VARCHAR2(20),
	YTDM	VARCHAR2(4),
	BMDM	VARCHAR2(8),
	DFKM	VARCHAR2(20),
	CKDM	VARCHAR2(2),
	DT	DATE,
	ZY	VARCHAR2(60),
	SL	NUMBER(18,6),
	USED	NUMBER(18,6),
   	DEF_NUM1	NUMBER(18,6),
   	DEF_NUM2	NUMBER(18,6),
   	DEF_NUM3	NUMBER(18,6),
	DEF_NUM4	NUMBER(18,6),
	DEF_STR1	VARCHAR2(30),
	DEF_STR2	VARCHAR2(30),
	DEF_STR3	VARCHAR2(30),
	DEF_DATE1	DATE,
	DEF_DATE2	DATE,
	DEF_INT1	NUMBER(8,0),
	DEF_INT2	NUMBER(8,0)
);

CREATE TABLE "KC_CKQX"
(	XM		 VARCHAR2(8) NOT NULL,
	CKQX	 CHAR(2)	NOT NULL	
);

CREATE TABLE "KC_QX"
(	XM 	 VARCHAR2(8) NOT NULL,
	MM 	 VARCHAR2(254),
	BM 	 VARCHAR2(14),
	Q0 	 NUMBER(1,0),
	Q1 	 NUMBER(1,0),
	Q2 	 NUMBER(1,0),
	Q3 	 NUMBER(1,0),
	Q4 	 NUMBER(1,0),
	Q5		 NUMBER(1,0),
	Q6 	 NUMBER(1,0),
	Q7 	 NUMBER(1,0),
	Q8 	 NUMBER(1,0),
	Q9 	 NUMBER(1,0),
	Q10 	 NUMBER(1,0),
	Q11 	 NUMBER(1,0),
	Q12 	 NUMBER(1,0),
	Q13 	 NUMBER(1,0),
	Q14	 NUMBER(1,0),
	Q15 	 NUMBER(1,0),
	Q16 	 NUMBER(1,0) 
);

CREATE TABLE "KC_PZ"
(	ID		NUMBER(6,0) NOT NULL,
	SPP	VARCHAR2(7),
	JZBZ	NUMBER(1,0),
	PZRQ	DATE,
	PZLX	CHAR(1),
	PZH	VARCHAR2(4),
	CKPZH VARCHAR2(6),
	FJ		NUMBER(5,0),
	ZY		VARCHAR2(60),
	KMDM	VARCHAR2(20),
	J		NUMBER(18,2),
	D		NUMBER(18,2),
	ZPHJSDJH VARCHAR2(20),
	SHY	VARCHAR2(8),
	ZDY	VARCHAR2(8),
	CZY	VARCHAR2(8),
	SHBZ	NUMBER(1,0),
	WBJE	NUMBER(18,2),
	HL		NUMBER(18,2),
	DQH	VARCHAR2(4),
	GG		VARCHAR2(14),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DWDM	VARCHAR2(4),
	LXR	VARCHAR2(8),
	JSR	VARCHAR2(8),
	BMRY	VARCHAR2(8),
	ID1	NUMBER(6,0),
	ID2	NUMBER(6,0)
);

CREATE TABLE "KC_MX"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX01"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX02"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX03"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX04"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX05"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX06"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX07"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX08"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX09"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX10"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(8,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(12,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX11"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_MX12"
(	ID		VARCHAR2(6) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	DM		VARCHAR2(20),
	SL		NUMBER(18,6),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	MAYUSE	NUMBER(18,6),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	XE_PZH	VARCHAR2(4),
	XE_CKPZH	VARCHAR2(6),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16),
  USEMONY     NUMBER(18,2),
 	SALEPRC		NUMBER(18,6),
 	DEF_NUM1		NUMBER(18,6),
 	MXID			NUMBER(12,0),
  CG_HEAD  	VARCHAR2(20),
  XS_HEAD  	NUMBER(8,0),
  SYEAR   		VARCHAR2(4),
 	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_JZBZ"
(	ID		NUMBER(2,0) NOT NULL,
	VER	NUMBER(2,0),
	INITED	NUMBER(2,0),
	LEN1	NUMBER(2,0),
	LEN2	NUMBER(2,0),
	LEN3	NUMBER(2,0),
	LEN4	NUMBER(2,0),
	LEN5	NUMBER(2,0),
	LEN6	NUMBER(2,0),
	LEN7	NUMBER(2,0),
	LEN8	NUMBER(2,0),
	MON1 NUMBER(1,0),
	MON2 NUMBER(1,0),
	MON3 NUMBER(1,0),
	MON4 NUMBER(1,0),
	MON5 NUMBER(1,0),
	MON6 NUMBER(1,0),
	MON7 NUMBER(1,0),
	MON8 NUMBER(1,0),
	MON9 NUMBER(1,0),
	MON10 NUMBER(1,0),
	MON11 NUMBER(1,0),
	MON12 NUMBER(1,0),
	DAT1 NUMBER(18,6),
	DAT2 NUMBER(18,6),
	DAT3 NUMBER(18,6),
	DAT4 NUMBER(18,6),
	DAT5 NUMBER(18,6),
	STR1 VARCHAR2(30),
	STR2 VARCHAR2(30),
	STR3 VARCHAR2(30),
	STR4 VARCHAR2(30),
	STR5 VARCHAR2(30),
 	DEF_INT1	NUMBER(8,0),
 	DEF_INT2	NUMBER(8,0),
	DEF_INT3	NUMBER(8,0),
	DEF_INT4	NUMBER(8,0),
 	DEF_INT5	NUMBER(8,0),
 	DEF_STR1	VARCHAR2(30),
 	DEF_STR2	VARCHAR2(30),
 	DEF_STR3	VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE
);

CREATE TABLE "KC_DM"
(	CKDM	CHAR(2) NOT NULL,
	DM		VARCHAR2(20) NOT NULL,
	MC		VARCHAR2(50),
	ISLB	NUMBER(1,0),
	CHLB	NUMBER(2,0),
	FFID	NUMBER(2,0),
	DW		VARCHAR2(6),
	GG		VARCHAR2(50),
	TXM	VARCHAR2(30),
	KMDM	VARCHAR2(20),
	CGKMDM	VARCHAR2(20),
	MAXSL	NUMBER(18,6),
	MINSL NUMBER(18,6),
	NCJCSL	NUMBER(18,6),
	SLJSL NUMBER(18,6),
	FLJSL	NUMBER(18,6),
	NCYE	NUMBER(18,2),
	NCYE_J	NUMBER(18,2),
	DJ		NUMBER(18,6),
	DJ_J	NUMBER(18,6),
	JJE	NUMBER(18,2),
	JJE_J	NUMBER(18,2),
	DJE	NUMBER(18,2),
	DJE_J NUMBER(18,2),
	SSL1 NUMBER(18,6),
	SSL2 NUMBER(18,6),
	SSL3 NUMBER(18,6),
	SSL4 NUMBER(18,6),
	SSL5 NUMBER(18,6),
	SSL6 NUMBER(18,6),
	SSL7 NUMBER(18,6),
	SSL8 NUMBER(18,6),
	SSL9 NUMBER(18,6),
	SSL10 NUMBER(18,6),
	SSL11 NUMBER(18,6),
	SSL12 NUMBER(18,6),
	FSL1 NUMBER(18,6),
	FSL2 NUMBER(18,6),
	FSL3 NUMBER(18,6),
	FSL4 NUMBER(18,6),
	FSL5 NUMBER(18,6),
	FSL6 NUMBER(18,6),
	FSL7 NUMBER(18,6),
	FSL8 NUMBER(18,6),
	FSL9 NUMBER(18,6),
	FSL10 NUMBER(18,6),
	FSL11 NUMBER(18,6),
	FSL12 NUMBER(18,6),
	JJE1 NUMBER(18,2),
	JJE2 NUMBER(18,2),
	JJE3 NUMBER(18,2),
	JJE4 NUMBER(18,2),
	JJE5 NUMBER(18,2),
	JJE6 NUMBER(18,2),
	JJE7 NUMBER(18,2),
	JJE8 NUMBER(18,2),
	JJE9 NUMBER(18,2),
	JJE10 NUMBER(18,2),
	JJE11 NUMBER(18,2),
	JJE12 NUMBER(18,2),
	JJE_J1 NUMBER(18,2),
	JJE_J2 NUMBER(18,2),
	JJE_J3 NUMBER(18,2),
	JJE_J4 NUMBER(18,2),
	JJE_J5 NUMBER(18,2),
	JJE_J6 NUMBER(18,2),
	JJE_J7 NUMBER(18,2),
	JJE_J8 NUMBER(18,2),
	JJE_J9 NUMBER(18,2),
	JJE_J10 NUMBER(18,2),
	JJE_J11 NUMBER(18,2),
	JJE_J12 NUMBER(18,2),
	DJE1		NUMBER(18,2),
	DJE2		NUMBER(18,2),
	DJE3		NUMBER(18,2),
	DJE4		NUMBER(18,2),
	DJE5		NUMBER(18,2),
	DJE6		NUMBER(18,2),
	DJE7	 	NUMBER(18,2),
	DJE8		NUMBER(18,2),
	DJE9		NUMBER(18,2),
	DJE10		NUMBER(18,2),
	DJE11		NUMBER(18,2),
	DJE12		NUMBER(18,2),
	DJE_J1	NUMBER(18,2),
	DJE_J2	NUMBER(18,2),
	DJE_J3	NUMBER(18,2),
	DJE_J4	NUMBER(18,2),
	DJE_J5	NUMBER(18,2),
	DJE_J6	NUMBER(18,2),
	DJE_J7	NUMBER(18,2),
	DJE_J8	NUMBER(18,2),
	DJE_J9	NUMBER(18,2),
	DJE_J10	NUMBER(18,2),
	DJE_J11	NUMBER(18,2),
	DJE_J12	NUMBER(18,2),
	DJ0 	NUMBER(18,6),
	DJ1 	NUMBER(18,6),
	DJ2 	NUMBER(18,6),
	DJ3 	NUMBER(18,6),
	DJ4 	NUMBER(18,6),
	DJ5 	NUMBER(18,6),
	DJ6 	NUMBER(18,6),
	DJ7 	NUMBER(18,6),
	DJ8	NUMBER(18,6),
	DJ9 	NUMBER(18,6),
	DJ10	NUMBER(18,6),
	DJ11 	NUMBER(18,6),
	DJ12 	NUMBER(18,6),
	TSL1 	NUMBER(18,6),
	TSL2	NUMBER(18,6),
	XS_KM		VARCHAR2(20),
	XS_NCYE	NUMBER(18,2),
	XS_DJ		NUMBER(18,6),
	XS_DJE	NUMBER(18,6),
	XS_DJE1	NUMBER(18,6),
	XS_DJE2	NUMBER(18,6),
	XS_DJE3	NUMBER(18,6),
	XS_DJE4	NUMBER(18,6),
	XS_DJE5	NUMBER(18,6),
	XS_DJE6	NUMBER(18,6),
	XS_DJE7	NUMBER(18,6),
	XS_DJE8	NUMBER(18,6),
	XS_DJE9	NUMBER(18,6),
	XS_DJE10	NUMBER(18,6),
	XS_DJE11	NUMBER(18,6),
	XS_DJE12	NUMBER(18,6),
	XSCBKMDM VARCHAR2(20),
	SCCBKMDM VARCHAR2(20),
   DEF_NUM1	NUMBER(18,6),
   DEF_NUM2	NUMBER(18,6),
   DEF_NUM3	NUMBER(18,6),
   DEF_NUM4	NUMBER(18,6),
   DEF_NUM5	NUMBER(18,6),
   DEF_STR1	VARCHAR2(30),
   DEF_STR2	VARCHAR2(30),
   DEF_DATE1	DATE,
   DEF_DATE2	DATE,
   DEF_INT1  NUMBER(8,0),
   DEF_INT2  NUMBER(8,0)
);

CREATE TABLE "KC_DJ"
(	SMON	VARCHAR2(2) NOT NULL,
	PZLX	CHAR(1) NOT NULL,
	PZH	VARCHAR(4) NOT NULL,
	CKPZH VARCHAR2(6),
	PZRQ	DATE,
	HTH	VARCHAR2(20),
	FPH	VARCHAR2(20),
	DQH	VARCHAR2(4),
	DWDM	VARCHAR2(4),
	JSFS	NUMBER(2,0),
	DFKM	VARCHAR2(20),
	BMDM	VARCHAR2(8),
	CKDM	CHAR(2),
	LYDM	VARCHAR2(4),
	YTDM	VARCHAR2(4),
	LRY	VARCHAR2(8),
	LRY2	VARCHAR2(8),
	YSY	VARCHAR2(8),
	SHY	VARCHAR2(8),
	JZY	VARCHAR2(8),
	JSR	VARCHAR2(8),
	YSBZ	NUMBER(1,0),
	SHBZ	NUMBER(1,0),
	JZBZ	NUMBER(1,0),
	YK_PZH	VARCHAR2(20),
	NOTE	VARCHAR2(60),
	XE_NUM	NUMBER(3,0),
	XE_PZH	VARCHAR2(4),
	ZFBZ	NUMBER(2,0),
	ZPZH	NUMBER(6,0),
   DEF_STR1	VARCHAR2(30),
   DEF_STR2	VARCHAR2(30),
   DEF_STR3	VARCHAR2(30),
   DEF_STR4	VARCHAR2(30),
   DEF_NUM1	NUMBER(18,6),
   DEF_NUM2	NUMBER(18,6),
   DEF_INT1	NUMBER(8,0),
   DEF_INT2	NUMBER(8,0),
   DEF_DATE1	DATE,
   DEF_DATE2	DATE
);

CREATE TABLE "KC_AUTO"
(	ID		NUMBER(6,0) NOT NULL,
	NUM	NUMBER(3,0),
	JHD	NUMBER(2,0),
	KMDM	VARCHAR2(20),
	CONTAIN	NUMBER(2,0),
	ZY		VARCHAR2(30),
	PZLX	CHAR(1),
	FORM	VARCHAR2(80)
);

CREATE TABLE "KC_PYPK"
(	ID		NUMBER(6,0)	NOT NULL,
	CKDM	CHAR(2),
	DM		VARCHAR2(20),
	KH		VARCHAR2(30),
	SMON	VARCHAR2(2),
	PZLX	CHAR(1),
	PZH	VARCHAR2(4),
	RQ		DATE,
	SL		NUMBER(18,6),
	JE		NUMBER(18,2),
	PH		VARCHAR2(20),
	KW		VARCHAR2(30),
	SLBAK	NUMBER(18,6),	
	JEBAK	NUMBER(18,2),
	SSL	NUMBER(18,6),
	SJE	NUMBER(18,2),
	FSL	NUMBER(18,6),	
	FJE	NUMBER(18,2),
	NOTE	VARCHAR2(80), 
	SBZBAK	VARCHAR2(30),
	IYKBZ NUMBER(2,0),
	BZ 	NUMBER(4,0),
	IBZBAK	NUMBER(2,0)
);

CREATE TABLE "KC_BMYT"
(	ID		NUMBER(6,0) NOT NULL,
	BMDM	VARCHAR2(8),
	YTDM	VARCHAR2(4),
	BZ		VARCHAR2(30)
);

CREATE TABLE "KC_PHYXQ"
(	ID		NUMBER(6,0)	NOT NULL,
 	CKDM	VARCHAR2(2),
	KW		VARCHAR2(30),
	PH		VARCHAR2(20),
	DM 	VARCHAR2(20),
	LRRQ	DATE,
	YXQ	DATE,
	NCSL	NUMBER(18,6),
	SSL	NUMBER(18,6),
	FSL	NUMBER(18,6),
	SL		NUMBER(18,6),
	JE		NUMBER(18,2),
	BQ		VARCHAR2(60),
	SBZ	VARCHAR2(50),
	IBZ 	NUMBER(1,0),
	IBZ2	NUMBER(1,0),
   DEF_DATE1	DATE,
   DEF_DATE2	DATE,
   DEF_DATE3	DATE,
   DEF_NUM1	NUMBER(18,6),
   DEF_NUM2	NUMBER(18,6),
   DEF_NUM3	NUMBER(18,6),
   DEF_NUM4	NUMBER(18,6),
   DEF_STR1	VARCHAR2(30),
   DEF_STR2	VARCHAR2(30)
);

CREATE TABLE "KC_MX00"
(	ID		VARCHAR2(6) NOT NULL,
	SYEAR	VARCHAR2(4) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH	VARCHAR2(6) ,
	PZRQ	DATE ,
	DM		VARCHAR2(20) ,
	PH		VARCHAR2(20) ,
	KW		VARCHAR2(30)	,
	SL		NUMBER(18,6),
	MAYUSE NUMBER(18,6),
	SL_YCX NUMBER(18,6) ,
	DJ		NUMBER(18,6) ,
	DJ_J	NUMBER(18,6) ,
	JE		NUMBER(18,2),
	JE_J	NUMBER(18,2),
	YZF	NUMBER(18,2),
	USEMONY NUMBER(18,2),
	JE_YCX  NUMBER(18,2),
	JZBZ	NUMBER(1,0),
	STATUS	VARCHAR2(4),
	BZ		VARCHAR2(60),
	FHH	VARCHAR2(16) ,
	XE_CKPZH VARCHAR2(6),
	DEF_NUM2		NUMBER(18,6),
 	DEF_NUM3		NUMBER(18,6),
 	DEF_NUM4		NUMBER(18,6),
 	DEF_NUM5		NUMBER(18,6),
 	DEF_STR1		VARCHAR2(30),
 	DEF_STR2		VARCHAR2(30),
 	DEF_STR3		VARCHAR2(30),
 	DEF_DATE1	DATE,
 	DEF_DATE2	DATE,
 	DEF_INT1		NUMBER(8,0),
 	DEF_INT2		NUMBER(8,0)
);

CREATE TABLE "KC_DJ00"
(	SYEAR	VARCHAR2(4) NOT NULL,
	SMON	VARCHAR2(2) NOT NULL,
	PZLX	VARCHAR2(1) NOT NULL,
	PZH	VARCHAR2(4) NOT NULL,
	CKPZH	VARCHAR2(6) ,
	PZRQ	DATE,
	HTH	VARCHAR2(20),
	FPH	VARCHAR2(20),
	DQH	VARCHAR2(4),
	DWDM	VARCHAR2(4),
	JSFS	NUMBER(2,0) ,
	DFKM	VARCHAR2(20) ,
	BMDM	VARCHAR2(8) ,
	CKDM	VARCHAR2(2),
	LYDM	VARCHAR2(4),
	YTDM	VARCHAR2(4) ,
	LRY	VARCHAR2(8) ,
	LRY2	VARCHAR2(8) ,
	YSY	VARCHAR2(8) ,
	SHY	VARCHAR2(8) ,
	JZY	VARCHAR2(8) ,
	JSR	VARCHAR2(8) ,
	YSBZ	NUMBER(1,0) ,
	SHBZ	NUMBER(1,0),
	JZBZ	NUMBER(1,0),
	NOTE	VARCHAR2(60) ,
	YK_PZH	VARCHAR2(20),
	STATUS	VARCHAR2(4) ,
	XE_CKPZH	VARCHAR2(6) ,
	ZFBZ		NUMBER(2,0),
	ZPZH		NUMBER(6,0)
);

CREATE TABLE "KC_JT"
(	SMON		VARCHAR2(2)		NOT NULL,
	DM			VARCHAR2(20)	NOT NULL,
	JE			NUMBER(18,2),
	SL			NUMBER(18,6),
	MPRICE	NUMBER(18,6),
	CELL_JT	NUMBER(18,6),
	CELL_JT_YU	NUMBER(18,6),
	JT_YU		NUMBER(18,6),
	DEF_NUM1	NUMBER(18,6),
	DEF_NUM2	NUMBER(18,6),
	DEF_INT1	NUMBER(8,0),
	DEF_INT2	NUMBER(8,0)
);

CREATE TABLE	"KC_REP"
(	REPNO		VARCHAR2(4) NOT NULL,
	REPNAME		VARCHAR2(30),
	FILLINPSN	VARCHAR2(10),
	FILLINDATE	DATE,
	REPOWNER	VARCHAR2(30),
	DEF_NUM1	NUMBER(18,6),
   	DEF_NUM2	NUMBER(18,6),
   	DEF_NUM3	NUMBER(18,6),
	DEF_NUM4	NUMBER(18,6),
	DEF_STR1	VARCHAR2(30),
	DEF_STR2	VARCHAR2(30),
	DEF_STR3	VARCHAR2(30),
	DEF_DATE1	DATE,
	DEF_DATE2	DATE,
	DEF_INT1	NUMBER(8,0),
	DEF_INT2	NUMBER(8,0)
);

CREATE TABLE "KC_REP_DESIGN"
(	REPNO		VARCHAR2(4) NOT NULL,
	REPID		NUMBER(8,0) NOT NULL,
	IDTYPE		VARCHAR2(2),
	CONTENT 	VARCHAR2(60),
	REPFLG		VARCHAR2(1),
	DESCRIBE	VARCHAR2(60),
	LYYT		VARCHAR2(1),
	DEF_NUM1	NUMBER(18,6),
   	DEF_NUM2	NUMBER(18,6),
   	DEF_NUM3	NUMBER(18,6),
	DEF_NUM4	NUMBER(18,6),
	DEF_STR1	VARCHAR2(30),
	DEF_STR2	VARCHAR2(30),
	DEF_STR3	VARCHAR2(30),
	DEF_DATE1	DATE,
	DEF_DATE2	DATE,
	DEF_INT1	NUMBER(8,0),
	DEF_INT2	NUMBER(8,0)
);

CREATE TABLE "KC_REPQX"
(	
   	XM       VARCHAR2(8)  Not Null,
	REPNO	 VARCHAR2(4) NOT NULL,
	DEF_NUM1	NUMBER(18,6),
   	DEF_NUM2	NUMBER(18,6),
   	DEF_NUM3	NUMBER(18,6),
	DEF_NUM4	NUMBER(18,6),
	DEF_STR1	VARCHAR2(30),
	DEF_STR2	VARCHAR2(30),
	DEF_STR3	VARCHAR2(30),
	DEF_DATE1	DATE,
	DEF_DATE2	DATE,
	DEF_INT1	NUMBER(8,0),
	DEF_INT2	NUMBER(8,0)
);

CREATE VIEW "KC_MXHZ" AS 
 (
 SELECT * FROM KC_MX01 UNION  
 SELECT * FROM KC_MX02 UNION  
 SELECT * FROM KC_MX03 UNION  
 SELECT * FROM KC_MX04 UNION  
 SELECT * FROM KC_MX05 UNION  
 SELECT * FROM KC_MX06 UNION  
 SELECT * FROM KC_MX07 UNION  
 SELECT * FROM KC_MX08 UNION  
 SELECT * FROM KC_MX09 UNION  
 SELECT * FROM KC_MX10 UNION  
 SELECT * FROM KC_MX11 UNION  
 SELECT * FROM KC_MX12  
);

CREATE VIEW "KC_CS" AS  
 (
 SELECT KC_DM.CKDM AS CKDM,
 	KC_DM.DM AS DM,
 	KC_DM.CHLB AS CHLB,
 	KC_DM.GG AS GG,
 	(KC_DM.NCJCSL + KC_DM.SLJSL - KC_DM.FLJSL) AS DMNCSL,
	(KC_DM.NCYE + KC_DM.JJE - KC_DM.DJE) AS DMNCYE,
	(KC_DM.NCYE_J + KC_DM.JJE_J - KC_DM.DJE_J) AS DMNCYE_J,
	KC_PHYXQ.KW AS KW,
	KC_PHYXQ.PH AS PH,
	KC_PHYXQ.NCSL AS NCSL  
 FROM KC_DM,KC_PHYXQ  
 WHERE ((KC_DM.CKDM = KC_PHYXQ.CKDM(+)) AND (KC_DM.DM = KC_PHYXQ.DM(+))) AND KC_DM.CKDM <> '00' AND KC_DM.ISLB = 0 
 );


ALTER TABLE "KC_REP"		ADD ( CONSTRAINT KC_REP_PK 		PRIMARY KEY ("REPNO"));
ALTER TABLE "KC_REP_DESIGN"	ADD ( CONSTRAINT KC_REPDESIGN_PK	PRIMARY KEY ("REPNO","ID"));
ALTER TABLE "KC_REPQX"	ADD ( CONSTRAINT KC_REPQX_PK	PRIMARY KEY ("XM","REPNO"));
ALTER TABLE "KC_JT"		ADD ( CONSTRAINT KC_JT_PK 		PRIMARY KEY ("SMON","DM"));
ALTER TABLE "KC_AUTO"	ADD ( CONSTRAINT KC_AUTO_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_BM"		ADD ( CONSTRAINT KC_BM_PK		PRIMARY KEY ("DM"));
ALTER TABLE "KC_BMYT"	ADD ( CONSTRAINT KC_BMYT_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_CHLB"	ADD ( CONSTRAINT KC_CHLB_PK	PRIMARY KEY ("DM"));
ALTER TABLE "KC_CK"		ADD ( CONSTRAINT KC_CK_PK		PRIMARY KEY ("DM"));
ALTER TABLE "KC_CKQX"	ADD ( CONSTRAINT KC_CKQX_PK	PRIMARY KEY ("XM","CKQX"));
ALTER TABLE "KC_DEF"		ADD ( CONSTRAINT KC_DEF_PK		PRIMARY KEY ("ID"));
ALTER TABLE "KC_DJ"		ADD ( CONSTRAINT KC_DJ_PK		PRIMARY KEY ("SMON","PZLX","PZH"));
ALTER TABLE "KC_DJ00"		ADD ( CONSTRAINT KC_DJ00_PK		PRIMARY KEY ("SYEAR","SMON","PZLX","PZH"));
ALTER TABLE "KC_DM"		ADD ( CONSTRAINT KC_DM_PK		PRIMARY KEY ("CKDM","DM"));
ALTER TABLE "KC_FF"		ADD ( CONSTRAINT KC_FF_PK		PRIMARY KEY ("ID"));
ALTER TABLE "KC_FLAG"	ADD ( CONSTRAINT KC_FLAG_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_JSFS"	ADD ( CONSTRAINT KC_JSFS_PK	PRIMARY KEY ("DM"));
ALTER TABLE "KC_JZBZ"	ADD ( CONSTRAINT KC_JZBZ_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_KW"		ADD ( CONSTRAINT KC_KW_PK		PRIMARY KEY ("CKDM","DM"));
ALTER TABLE "KC_LY"		ADD ( CONSTRAINT KC_LY_PK		PRIMARY KEY ("DM"));
ALTER TABLE "KC_MX"		ADD ( CONSTRAINT KC_MX_PK		PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX00"		ADD ( CONSTRAINT KC_MX00_PK		PRIMARY KEY ("ID","SYEAR","SMON"));
ALTER TABLE "KC_MX01"	ADD ( CONSTRAINT KC_MX01_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX02"	ADD ( CONSTRAINT KC_MX02_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX03"	ADD ( CONSTRAINT KC_MX03_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX04"	ADD ( CONSTRAINT KC_MX04_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX05"	ADD ( CONSTRAINT KC_MX05_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX06"	ADD ( CONSTRAINT KC_MX06_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX07"	ADD ( CONSTRAINT KC_MX07_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX08"	ADD ( CONSTRAINT KC_MX08_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX09"	ADD ( CONSTRAINT KC_MX09_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX10"	ADD ( CONSTRAINT KC_MX10_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX11"	ADD ( CONSTRAINT KC_MX11_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_MX12"	ADD ( CONSTRAINT KC_MX12_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_PHYXQ"	ADD ( CONSTRAINT KC_PHYXQ_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_PYPK"	ADD ( CONSTRAINT KC_PYPK_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_PZ"		ADD ( CONSTRAINT KC_PZ_PK		PRIMARY KEY ("ID"));
ALTER TABLE "KC_QX"		ADD ( CONSTRAINT KC_QX_PK		PRIMARY KEY ("XM"));
ALTER TABLE "KC_XESET"	ADD ( CONSTRAINT KC_XESE_PK	PRIMARY KEY ("ID"));
ALTER TABLE "KC_YT"		ADD ( CONSTRAINT KC_YT_PK		PRIMARY KEY ("DM"));
ALTER TABLE "KC_JT"		ADD ( CONSTRAINT KC_JT_PK     PRIMARY KEY ("SMON","DM");
[CREATE INDEX]
DROP INDEX "KC_AUTO_IDX";
DROP INDEX "KC_AUTO_NUM";
DROP INDEX "KC_BM_IDX";
DROP INDEX "KC_BMYT_IDX";
DROP INDEX "KC_BMYT_BM";
DROP INDEX "KC_BMYT_YT";
DROP INDEX "KC_CHLB_IDX";
DROP INDEX "KC_CHLB_MC";
DROP INDEX "KC_CK_IDX";
DROP INDEX "KC_CK_MC";
DROP INDEX "KC_CKQX_IDX";
DROP INDEX "KC_CKQX_XM";
DROP INDEX "KC_CKQX_CK";
DROP INDEX "KC_DEF_IDX";
DROP INDEX "KC_DJ_IDX";
DROP INDEX "KC_DJ_BZ";
DROP INDEX "KC_DJ_WLDW";
DROP INDEX "KC_DJ_HTFP";
DROP INDEX "KC_DJ_CK";
DROP INDEX "KC_DJ_BM";
DROP INDEX "KC_DJ_LYYT";
DROP INDEX "KC_DJ_ZPZH";
DROP INDEX "KC_DJ00_IDX";
DROP INDEX "KC_DJ00_CK";
DROP INDEX "KC_DJ00_ZPZH";
DROP INDEX "KC_DM_IDX";
DROP INDEX "KC_DM_CK";
DROP INDEX "KC_DM_DM";
DROP INDEX "KC_DM_ISLB";
DROP INDEX "KC_DM_CHLB";
DROP INDEX "KC_DM_FFID";
DROP INDEX "KC_DM_OLDDM";
DROP INDEX "KC_FF_IDX";
DROP INDEX "KC_FLAG_IDX";
DROP INDEX "KC_JSFS_IDX";
DROP INDEX "KC_JZBZ_IDX";
DROP INDEX "KC_KW_IDX";
DROP INDEX "KC_KW_CK";
DROP INDEX "KC_KW_DM";
DROP INDEX "KC_LY_IDX";
DROP INDEX "KC_MX_IDX";
DROP INDEX "KC_MX_X";
DROP INDEX "KC_MX_DM";
DROP INDEX "KC_MX_CKPZH";
DROP INDEX "KC_MX_JK";
DROP INDEX "KC_MX_PHKW";
DROP INDEX "KC_MX00_IDX";
DROP INDEX "KC_MX00_X";
DROP INDEX "KC_MX00_DM";
DROP INDEX "KC_MX01_IDX";
DROP INDEX "KC_MX01_X";
DROP INDEX "KC_MX01_DM";
DROP INDEX "KC_MX01_CKPZH";
DROP INDEX "KC_MX01_JK";
DROP INDEX "KC_MX01_PHKW";
DROP INDEX "KC_MX02_IDX";
DROP INDEX "KC_MX02_X";
DROP INDEX "KC_MX02_DM";
DROP INDEX "KC_MX02_CKPZH";
DROP INDEX "KC_MX02_JK";
DROP INDEX "KC_MX02_PHKW";
DROP INDEX "KC_MX03_IDX";
DROP INDEX "KC_MX03_X";
DROP INDEX "KC_MX03_DM";
DROP INDEX "KC_MX03_CKPZH";
DROP INDEX "KC_MX03_JK";
DROP INDEX "KC_MX03_PHKW";
DROP INDEX "KC_MX04_IDX";
DROP INDEX "KC_MX04_X";
DROP INDEX "KC_MX04_DM";
DROP INDEX "KC_MX04_CKPZH";
DROP INDEX "KC_MX04_JK";
DROP INDEX "KC_MX04_PHKW";
DROP INDEX "KC_MX05_IDX";
DROP INDEX "KC_MX05_X";
DROP INDEX "KC_MX05_DM";
DROP INDEX "KC_MX05_CKPZH";
DROP INDEX "KC_MX05_JK";
DROP INDEX "KC_MX05_PHKW";
DROP INDEX "KC_MX06_IDX";
DROP INDEX "KC_MX06_X";
DROP INDEX "KC_MX06_DM";
DROP INDEX "KC_MX06_CKPZH";
DROP INDEX "KC_MX06_JK";
DROP INDEX "KC_MX06_PHKW";
DROP INDEX "KC_MX07_IDX";
DROP INDEX "KC_MX07_X";
DROP INDEX "KC_MX07_DM";
DROP INDEX "KC_MX07_CKPZH";
DROP INDEX "KC_MX07_JK";
DROP INDEX "KC_MX07_PHKW";
DROP INDEX "KC_MX08_IDX";
DROP INDEX "KC_MX08_X";
DROP INDEX "KC_MX08_DM";
DROP INDEX "KC_MX08_CKPZH";
DROP INDEX "KC_MX08_JK";
DROP INDEX "KC_MX08_PHKW";
DROP INDEX "KC_MX09_IDX";
DROP INDEX "KC_MX09_X";
DROP INDEX "KC_MX09_DM";
DROP INDEX "KC_MX09_CKPZH";
DROP INDEX "KC_MX09_JK";
DROP INDEX "KC_MX09_PHKW";
DROP INDEX "KC_MX10_IDX";
DROP INDEX "KC_MX10_X";
DROP INDEX "KC_MX10_DM";
DROP INDEX "KC_MX10_CKPZH";
DROP INDEX "KC_MX10_JK";
DROP INDEX "KC_MX10_PHKW";
DROP INDEX "KC_MX11_IDX";
DROP INDEX "KC_MX11_X";
DROP INDEX "KC_MX11_DM";
DROP INDEX "KC_MX11_CKPZH";
DROP INDEX "KC_MX11_JK";
DROP INDEX "KC_MX11_PHKW";
DROP INDEX "KC_MX12_IDX";
DROP INDEX "KC_MX12_X";
DROP INDEX "KC_MX12_DM";
DROP INDEX "KC_MX12_CKPZH";
DROP INDEX "KC_MX12_JK";
DROP INDEX "KC_MX12_PHKW";
DROP INDEX "KC_PHYXQ_IDX";
DROP INDEX "KC_PHYXQ_CKDM";
DROP INDEX "KC_PHYXQ_DM";
DROP INDEX "KC_PHYXQ_KWPH";
DROP INDEX "KC_PHYXQ_IBZ";
DROP INDEX "KC_PYIDX_IDX";
DROP INDEX "KC_PYIDX_CKKH";
DROP INDEX "KC_PYIDX_PZH";
DROP INDEX "KC_PYIDX_DM";
DROP INDEX "KC_PYIDX_BZ";
DROP INDEX "KC_PZ_IDX";
DROP INDEX "KC_PZ_ZWPZH";
DROP INDEX "KC_PZ_PZH";
DROP INDEX "KC_QX_IDX";
DROP INDEX "KC_XESET_IDX";
DROP INDEX "KC_XESET_XE";
DROP INDEX "KC_XESET_PLD";
DROP INDEX "KC_XESET_NUM";
DROP INDEX "KC_YT_IDX";
DROP INDEX "KC_JT_DM";

CREATE INDEX "KC_AUTO_IDX" ON "KC_AUTO"("ID");
CREATE INDEX "KC_AUTO_NUM" ON "KC_AUTO"("NUM");
CREATE  INDEX "KC_BM_IDX" ON "KC_BM"("DM");
CREATE  INDEX "KC_BMYT_IDX" ON "KC_BMYT"("ID");
CREATE INDEX "KC_BMYT_BM" ON "KC_BMYT"("BMDM");
CREATE INDEX "KC_BMYT_YT" ON "KC_BMYT"("YTDM");
CREATE  INDEX "KC_CHLB_IDX" ON "KC_CHLB"("DM");
CREATE INDEX "KC_CHLB_MC" ON "KC_CHLB"("MC");
CREATE  INDEX "KC_CK_IDX" ON "KC_CK"("DM");
CREATE INDEX "KC_CK_MC" ON "KC_CK"("MC");
CREATE  INDEX "KC_CKQX_IDX" ON "KC_CKQX"("XM","CKQX");
CREATE INDEX "KC_CKQX_XM" ON "KC_CKQX"("XM");
CREATE INDEX "KC_CKQX_CK" ON "KC_CKQX"("CKQX");
CREATE  INDEX "KC_DEF_IDX" ON "KC_DEF"("ID");
CREATE  INDEX "KC_DJ_IDX" ON "KC_DJ"("SMON","PZLX","PZH");
CREATE INDEX "KC_DJ_YSBZ" ON "KC_DJ"("YSBZ","SHBZ","JZBZ");
CREATE INDEX "KC_DJ_WLDW" ON "KC_DJ"("DQH","DWDM");
CREATE INDEX "KC_DJ_HTFP" ON "KC_DJ"("HTH","FPH");
CREATE INDEX "KC_DJ_CK" ON "KC_DJ"("CKDM","CKPZH");
CREATE INDEX "KC_DJ_BM" ON "KC_DJ"("BMDM");
CREATE INDEX "KC_DJ_LYYT" ON "KC_DJ"("LYDM","YTDM"); 
CREATE INDEX "KC_DJ_ZPZH" ON "KC_DJ"("ZPZH");
CREATE  INDEX "KC_DJ00_IDX" ON "KC_DJ00"("SYEAR","SMON","PZLX","PZH");
CREATE INDEX "KC_DJ00_CK" ON "KC_DJ00"("CKDM");
CREATE INDEX "KC_DJ00_ZPZH" ON "KC_DJ00"("ZPZH");
CREATE  INDEX "KC_DM_IDX" ON "KC_DM"("CKDM","DM");
CREATE INDEX "KC_DM_CK" ON "KC_DM"("CKDM");
CREATE INDEX "KC_DM_DM" ON "KC_DM"("DM");
CREATE INDEX "KC_DM_ISLB" ON "KC_DM"("ISLB");
CREATE INDEX "KC_DM_CHLB" ON "KC_DM"("CHLB");
CREATE INDEX "KC_DM_FFID" ON "KC_DM"("FFID");
CREATE INDEX "KC_DM_OLDDM" ON "KC_DM"("DEF_STR1");
CREATE  INDEX "KC_FF_IDX" ON "KC_FF"("ID");
CREATE  INDEX "KC_FLAG_IDX" ON "KC_FLAG"("ID");
CREATE  INDEX "KC_JSFS_IDX" ON "KC_JSFS"("DM");
CREATE  INDEX "KC_JZBZ_IDX" ON "KC_JZBZ"("ID");
CREATE  INDEX "KC_KW_IDX" ON "KC_KW"("CKDM","DM");
CREATE INDEX "KC_KW_CK" ON "KC_KW"("CKDM");
CREATE INDEX "KC_KW_DM" ON "KC_KW"("DM");
CREATE  INDEX "KC_LY_IDX" ON "KC_LY"("DM");
CREATE  INDEX "KC_MX_IDX" ON "KC_MX"("ID");
CREATE INDEX "KC_MX_X" ON "KC_MX"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX_DM" ON "KC_MX"("DM");
CREATE INDEX "KC_MX_CKPZH" ON "KC_MX"("CKPZH");
CREATE INDEX "KC_MX_JK" ON "KC_MX"("FHH","MXID");
CREATE INDEX "KC_MX_PHKW" ON "KC_MX"("KW","PH");
CREATE  INDEX "KC_MX00_IDX" ON "KC_MX00"("ID","SYEAR","SMON");
CREATE INDEX "KC_MX00_X" ON "KC_MX00"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX00_DM" ON "KC_MX00"("DM");
CREATE  INDEX "KC_MX01_IDX" ON "KC_MX01"("ID");
CREATE INDEX "KC_MX01_X" ON "KC_MX01"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX01_DM" ON "KC_MX01"("DM");
CREATE INDEX "KC_MX01_CKPZH" ON "KC_MX01"("CKPZH");
CREATE INDEX "KC_MX01_JK" ON "KC_MX01"("FHH","MXID");
CREATE INDEX "KC_MX01_PHKW" ON "KC_MX01"("KW","PH");
CREATE  INDEX "KC_MX02_IDX" ON "KC_MX02"("ID");
CREATE INDEX "KC_MX02_X" ON "KC_MX02"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX02_DM" ON "KC_MX02"("DM");
CREATE INDEX "KC_MX02_CKPZH" ON "KC_MX02"("CKPZH");
CREATE INDEX "KC_MX02_JK" ON "KC_MX02"("FHH","MXID");
CREATE INDEX "KC_MX02_PHKW" ON "KC_MX02"("KW","PH");
CREATE  INDEX "KC_MX03_IDX" ON "KC_MX03"("ID");
CREATE INDEX "KC_MX03_X" ON "KC_MX03"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX03_DM" ON "KC_MX03"("DM");
CREATE INDEX "KC_MX03_CKPZH" ON "KC_MX03"("CKPZH");
CREATE INDEX "KC_MX03_JK" ON "KC_MX03"("FHH","MXID");
CREATE INDEX "KC_MX03_PHKW" ON "KC_MX03"("KW","PH");
CREATE  INDEX "KC_MX04_IDX" ON "KC_MX04"("ID");
CREATE INDEX "KC_MX04_X" ON "KC_MX04"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX04_DM" ON "KC_MX04"("DM");
CREATE INDEX "KC_MX04_CKPZH" ON "KC_MX04"("CKPZH");
CREATE INDEX "KC_MX04_JK" ON "KC_MX04"("FHH","MXID");
CREATE INDEX "KC_MX04_PHKW" ON "KC_MX04"("KW","PH");
CREATE  INDEX "KC_MX05_IDX" ON "KC_MX05"("ID");
CREATE INDEX "KC_MX05_X" ON "KC_MX05"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX05_DM" ON "KC_MX05"("DM");
CREATE INDEX "KC_MX05_CKPZH" ON "KC_MX05"("CKPZH");
CREATE INDEX "KC_MX05_JK" ON "KC_MX05"("FHH","MXID");
CREATE INDEX "KC_MX05_PHKW" ON "KC_MX05"("KW","PH");
CREATE  INDEX "KC_MX06_IDX" ON "KC_MX06"("ID");
CREATE INDEX "KC_MX06_X" ON "KC_MX06"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX06_DM" ON "KC_MX06"("DM");
CREATE INDEX "KC_MX06_CKPZH" ON "KC_MX06"("CKPZH");
CREATE INDEX "KC_MX06_JK" ON "KC_MX06"("FHH","MXID");
CREATE INDEX "KC_MX06_PHKW" ON "KC_MX06"("KW","PH");
CREATE  INDEX "KC_MX07_IDX" ON "KC_MX07"("ID");
CREATE INDEX "KC_MX07_X" ON "KC_MX07"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX07_DM" ON "KC_MX07"("DM");
CREATE INDEX "KC_MX07_CKPZH" ON "KC_MX07"("CKPZH");
CREATE INDEX "KC_MX07_JK" ON "KC_MX07"("FHH","MXID");
CREATE INDEX "KC_MX07_PHKW" ON "KC_MX07"("KW","PH");
CREATE  INDEX "KC_MX08_IDX" ON "KC_MX08"("ID");
CREATE INDEX "KC_MX08_X" ON "KC_MX08"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX08_DM" ON "KC_MX08"("DM");
CREATE INDEX "KC_MX08_CKPZH" ON "KC_MX08"("CKPZH");
CREATE INDEX "KC_MX08_JK" ON "KC_MX08"("FHH","MXID");
CREATE INDEX "KC_MX08_PHKW" ON "KC_MX08"("KW","PH");
CREATE  INDEX "KC_MX09_IDX" ON "KC_MX09"("ID");
CREATE INDEX "KC_MX09_X" ON "KC_MX09"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX09_DM" ON "KC_MX09"("DM");
CREATE INDEX "KC_MX09_CKPZH" ON "KC_MX09"("CKPZH");
CREATE INDEX "KC_MX09_JK" ON "KC_MX09"("FHH","MXID");
CREATE INDEX "KC_MX09_PHKW" ON "KC_MX09"("KW","PH");
CREATE  INDEX "KC_MX10_IDX" ON "KC_MX10"("ID");
CREATE INDEX "KC_MX10_X" ON "KC_MX10"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX10_DM" ON "KC_MX10"("DM");
CREATE INDEX "KC_MX10_CKPZH" ON "KC_MX10"("CKPZH");
CREATE INDEX "KC_MX10_JK" ON "KC_MX10"("FHH","MXID");
CREATE INDEX "KC_MX10_PHKW" ON "KC_MX10"("KW","PH");
CREATE  INDEX "KC_MX11_IDX" ON "KC_MX11"("ID");
CREATE INDEX "KC_MX11_X" ON "KC_MX11"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX11_DM" ON "KC_MX11"("DM");
CREATE INDEX "KC_MX11_CKPZH" ON "KC_MX11"("CKPZH");
CREATE INDEX "KC_MX11_JK" ON "KC_MX11"("FHH","MXID");
CREATE INDEX "KC_MX11_PHKW" ON "KC_MX11"("KW","PH");
CREATE  INDEX "KC_MX12_IDX" ON "KC_MX12"("ID");
CREATE INDEX "KC_MX12_X" ON "KC_MX12"("SMON","PZLX","PZH");
CREATE INDEX "KC_MX12_DM" ON "KC_MX12"("DM");
CREATE INDEX "KC_MX12_CKPZH" ON "KC_MX12"("CKPZH");
CREATE INDEX "KC_MX12_JK" ON "KC_MX12"("FHH","MXID");
CREATE INDEX "KC_MX12_PHKW" ON "KC_MX12"("KW","PH");
CREATE  INDEX "KC_PHYXQ_IDX" ON "KC_PHYXQ"("ID");
CREATE INDEX "KC_PHYXQ_CKDM" ON "KC_PHYXQ"("CKDM");
CREATE INDEX "KC_PHYXQ_DM" ON "KC_PHYXQ"("DM");
CREATE INDEX "KC_PHYXQ_KWPH" ON "KC_PHYXQ"("KW","PH");
CREATE INDEX "KC_PHYXQ_IBZ" ON "KC_PHYXQ"("IBZ");
CREATE  INDEX "KC_PYIDX_IDX" ON "KC_PYIDX"("ID");
CREATE INDEX "KC_PYIDX_CKKH" ON "KC_PYIDX"("CKDM","KH");
CREATE INDEX "KC_PYIDX_PZH" ON "KC_PYIDX"("SMON","PZH","PZLX");
CREATE INDEX "KC_PYIDX_DM" ON "KC_PYIDX"("DM");
CREATE INDEX "KC_PYIDX_BZ" ON "KC_PYIDX"("IBZBAK","BZ","IYKBZ");
CREATE  INDEX "KC_PZ_IDX" ON "KC_PZ"("ID");
CREATE INDEX "KC_PZ_ZWPZH" ON "KC_PZ"("SPP");
CREATE INDEX "KC_PZ_PZH" ON "KC_PZ"("PZH");
CREATE  INDEX "KC_QX_IDX" ON "KC_QX"("XM");
CREATE  INDEX "KC_XESET_IDX" ON "KC_XESET"("ID");
CREATE INDEX "KC_XESET_XE" ON "KC_XESET"("DM","SMON","BMDM","CKDM");
CREATE INDEX "KC_XESET_PLD" ON "KC_XESET"("DM","CKDM");
CREATE INDEX "KC_XESET_NUM" ON "KC_XESET"("NUM","NUMS");
CREATE  INDEX "KC_YT_IDX" ON "KC_YT"("DM");
CREATE  INDEX "KC_JT_DM" ON "KC_JT"("DM");
