[CREATE TABLE]

DROP VIEW kc_mxhz;

DROP VIEW kc_cs;

CREATE TABLE dbo.kc_flag
(	id		smallint NOT NULL,
	tm		varchar(8) NULL,
	note	varchar(20) NULL,
	CONSTRAINT kc_flag_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_def
(	id		integer NOT NULL,
	title	varchar(30) NULL,
	def	varchar(100) NULL,
	CONSTRAINT kc_def_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_chlb
(	dm		smallint NOT NULL,
	mc		varchar(12) NULL,
	bz		varchar(1) NULL,
	CONSTRAINT kc_chlb_pk Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.kc_yt
(	dm		varchar(4) NOT NULL,
	mc		varchar(12) NULL,
	bz		varchar(1) NULL,
	route varchar(128) NULL,
	multiple numeric(18,6) NULL,
	CONSTRAINT kc_yt_pk Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.kc_ly
(	dm		varchar(4) NOT NULL,
	mc		varchar(12) NULL,
	bz		varchar(1) NULL,
	route varchar(128) NULL,
	multiple numeric(18,6) NULL,
	CONSTRAINT kc_ly_pk Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.kc_jsfs
(	dm		smallint NOT NULL,
	jsfs	varchar(12) NULL,
	CONSTRAINT kc_jsfs_pk Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.kc_ck
(	dm		char(2) NOT NULL,
	mc		varchar(12) NULL,
   prop		  smallint NULL,
   prio		  varchar(2) NULL,
   def_num1	  integer NULL,
   def_str1	  varchar(8) NULL,
	CONSTRAINT kc_ck_pk Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.kc_kw
(	ckdm	char(2) NOT NULL,
	dm		varchar(30) NOT NULL,
	mc		varchar(50) NULL,
	CONSTRAINT kc_kw_pk Primary KEY NONCLUSTERED (ckdm,dm)
);

CREATE TABLE dbo.kc_bm
(	dm varchar(8) NOT NULL,
	mc varchar(16) NULL,
   def_str1   varchar(8) NULL,
   def_str2   varchar(30) NULL,
	CONSTRAINT kc_bm_pk Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.kc_ff
(	id smallint NOT NULL,
	mc varchar(16) NULL,
	CONSTRAINT kc_ff_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_xeset
(	id		varchar(6) NOT NULL,
	num		integer NOT NULL,
	nums		varchar(30) NULL,	
	smon		varchar(2) NULL,
	pzh		varchar(4) NULL,
	ckpzh 		varchar(6) NULL,
	dm		varchar(20)	NULL,
	ytdm		varchar(4) NULL,
	bmdm		varchar(8) NULL,
	dfkm		varchar(20) NULL,
	ckdm		varchar(2) NULL,
	dt		smalldatetime NULL,
	zy		varchar(30) NULL,
	sl		numeric(18,6) NULL,
	used		numeric(18,6) NULL,
   	def_num1	numeric(18,6) NULL,
   	def_num2	numeric(18,6) NULL,
   	def_num3	numeric(18,6) NULL,
   	def_num4	numeric(18,6) NULL,
   	def_str1	varchar(30) NULL,
   	def_str2	varchar(30) NULL,
   	def_str3	varchar(30) NULL,
   	def_date1	smalldatetime NULL,
   	def_date2	smalldatetime NULL,
   	def_int1	integer NULL,
   	def_int2	integer NULL,
	CONSTRAINT kc_xeset_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_ckqx
(	xm		varchar(8) NOT NULL,
	ckqx	char(2) NOT NULL,
	CONSTRAINT kc_ckqx_pk Primary KEY NONCLUSTERED (xm,ckqx)
);

CREATE TABLE dbo.kc_qx
(	xm varchar(8) NOT NULL,
	mm varchar(254) NULL,
	bm varchar(14) NULL,
	q0 smallint NULL,
	q1 smallint NULL,
	q2 smallint NULL,
	q3 smallint NULL,
	q4 smallint NULL,
	q5 smallint NULL,
	q6 smallint NULL,
	q7 smallint NULL,
	q8 smallint NULL,
	q9 smallint NULL,
	q10 smallint NULL,
	q11 smallint NULL,
	q12 smallint NULL,
	q13 smallint NULL,
	q14 smallint NULL,
	q15 smallint NULL,
	q16 smallint	NULL,
	CONSTRAINT kc_qx_pk Primary KEY NONCLUSTERED (xm)
);

CREATE TABLE dbo.kc_pz
(	id			integer	NOT NULL,
	spp		varchar(7) NULL,
	jzbz		smallint NULL,
	pzrq		smalldatetime NULL,
	pzlx		char(1) NULL,
	pzh		varchar(4) NULL,
	ckpzh		varchar(6) NULL,
	fj			smallint NULL,
	zy			varchar(60) NULL,
	kmdm		varchar(20) NULL,
	j			numeric(18,2) NULL,
	d			numeric(18,2) NULL,
	zphjsdjh	varchar(20) NULL,
	shy		varchar(8) NULL,
	zdy		varchar(8) NULL,
	czy		varchar(8) NULL,
	shbz		smallint NULL,
	wbje		numeric(18,2) NULL,
	hl			numeric(18,2) NULL,
	dqh		varchar(4) NULL,
	gg			varchar(14) NULL,
	sl			numeric(18,6) NULL,
	dj			numeric(18,6) NULL,
	dwdm		varchar(4) NULL,
	lxr		varchar(8) NULL,
	jsr		varchar(8) NULL,
	bmry		varchar(8) NULL,
	id1		integer NULL,
	id2		integer NULL,
	CONSTRAINT kc_pz_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx01
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx01_pk Primary KEY NONCLUSTERED (id)
);


CREATE TABLE dbo.kc_mx02
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx02_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx03
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx03_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx04
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx04_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx05
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx05_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx06
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx06_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx07
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx07_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx08
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx08_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx09
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx09_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx10
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx10_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx11
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx11_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx12
(	id		varchar(6) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	sl		numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	jzbz	smallint NULL,
	mayuse	numeric(18,6) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	xe_pzh	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	bz			varchar(60) NULL,
	fhh		varchar(16) NULL,
   usemony     numeric(18,2) NULL,
  	saleprc		numeric(18,6) NULL,
 	def_num1		numeric(18,6) NULL,
 	mxid			integer NULL,
   cg_head  	varchar(20) NULL,
   xs_head  	integer NULL,
   syear   		varchar(4) NULL,
  	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx12_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_jzbz
(	id		smallint NOT NULL,
	ver	integer NULL,
	inited smallint NULL,
	len1	smallint NULL,
	len2	smallint NULL,
	len3 	smallint NULL,
	len4 	smallint NULL,
	len5 	smallint NULL,
	len6 	smallint NULL,
	len7 	smallint NULL,
	len8 	smallint NULL,
	mon1	smallint NULL,
	mon2 	smallint NULL,
	mon3 	smallint NULL,
	mon4	smallint NULL,
	mon5	smallint NULL,
	mon6	smallint NULL,
	mon7	smallint NULL,
	mon8	smallint NULL,
	mon9	smallint NULL,
	mon10 smallint NULL,
	mon11 smallint NULL,
	mon12 smallint NULL,
	dat1	money NULL,
	dat2	money NULL,
	dat3	money NULL,
	dat4	money NULL,
	dat5	money NULL,
	str1	varchar(30) NULL,
	str2	varchar(30) NULL,
	str3	varchar(30) NULL,
	str4	varchar(30) NULL,
	str5	varchar(30) NULL,
 	def_int1	integer NULL,
 	def_int2	integer NULL,
 	def_int3	integer NULL,
 	def_int4	integer NULL,
 	def_int5	integer NULL,
 	def_str1	varchar(30) NULL,
 	def_str2	varchar(30) NULL,
	def_str3	varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
	CONSTRAINT kc_jzbz_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_dm
(	ckdm	char(2) NOT NULL,
	dm		varchar(20) NOT NULL,
	mc		varchar(50) NULL,
	islb	smallint NULL,
	chlb	smallint NULL,
	ffid	smallint NULL,
	dw		varchar(6) NULL,
	gg		varchar(50) NULL,
	txm	varchar(30) NULL,
	kmdm	varchar(20) NULL,
	cgkmdm	varchar(20) NULL,
	maxsl		numeric(18,6) NULL,
	minsl		numeric(18,6) NULL,
	ncjcsl	numeric(18,6) NULL,
	sljsl		numeric(18,6) NULL,
	fljsl		numeric(18,6) NULL,
	ncye		numeric(18,2) NULL,
	ncye_j	numeric(18,2) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	jje	numeric(18,2) NULL,
	jje_j numeric(18,2) NULL,
	dje	numeric(18,2) NULL,
	dje_j	numeric(18,2) NULL,
	ssl1	numeric(18,6) NULL,
	ssl2	numeric(18,6) NULL,
	ssl3	numeric(18,6) NULL,
	ssl4	numeric(18,6) NULL,
	ssl5	numeric(18,6) NULL,
	ssl6	numeric(18,6) NULL,
	ssl7	numeric(18,6) NULL,
	ssl8	numeric(18,6) NULL,
	ssl9	numeric(18,6) NULL,
	ssl10	numeric(18,6) NULL,
	ssl11 numeric(18,6) NULL,
	ssl12 numeric(18,6) NULL,
	fsl1 numeric(18,6) NULL,
	fsl2 numeric(18,6) NULL,
	fsl3 numeric(18,6) NULL,
	fsl4 numeric(18,6) NULL,
	fsl5 numeric(18,6) NULL,
	fsl6 numeric(18,6) NULL,
	fsl7 numeric(18,6) NULL,
	fsl8 numeric(18,6) NULL,
	fsl9 numeric(18,6) NULL,
	fsl10 numeric(18,6) NULL,
	fsl11 numeric(18,6) NULL,
	fsl12 numeric(18,6) NULL,
	jje1 numeric(18,2) NULL,
	jje2 numeric(18,2) NULL,
	jje3 numeric(18,2) NULL,
	jje4 numeric(18,2) NULL,
	jje5 numeric(18,2) NULL,
	jje6 numeric(18,2) NULL,
	jje7 numeric(18,2) NULL,
	jje8 numeric(18,2) NULL,
	jje9 numeric(18,2) NULL,
	jje10 numeric(18,2) NULL,
	jje11 numeric(18,2) NULL,
	jje12 numeric(18,2) NULL,
	jje_j1 numeric(18,2) NULL,
	jje_j2 numeric(18,2) NULL,
	jje_j3 numeric(18,2) NULL,
	jje_j4 numeric(18,2) NULL,
	jje_j5 numeric(18,2) NULL,
	jje_j6 numeric(18,2) NULL,
	jje_j7 numeric(18,2) NULL,
	jje_j8 numeric(18,2) NULL,
	jje_j9 numeric(18,2) NULL,
	jje_j10 numeric(18,2) NULL,
	jje_j11 numeric(18,2) NULL,
	jje_j12 numeric(18,2) NULL,
	dje1 numeric(18,2) NULL,
	dje2 numeric(18,2) NULL,
	dje3 numeric(18,2) NULL,
	dje4 numeric(18,2) NULL,
	dje5 numeric(18,2) NULL,
	dje6 numeric(18,2) NULL,
	dje7 numeric(18,2) NULL,
	dje8 numeric(18,2) NULL,
	dje9 numeric(18,2) NULL,
	dje10 numeric(18,2) NULL,
	dje11 numeric(18,2) NULL,
	dje12 numeric(18,2) NULL,
	dje_j1 numeric(18,2) NULL,
	dje_j2 numeric(18,2) NULL,
	dje_j3 numeric(18,2) NULL,
	dje_j4 numeric(18,2) NULL,
	dje_j5 numeric(18,2) NULL,
	dje_j6 numeric(18,2) NULL,
	dje_j7 numeric(18,2) NULL,
	dje_j8 numeric(18,2) NULL,
	dje_j9 numeric(18,2) NULL,
	dje_j10 numeric(18,2) NULL,
	dje_j11 numeric(18,2) NULL,
	dje_j12 numeric(18,2) NULL,
	dj0 numeric(18,6) NULL,
	dj1 numeric(18,6) NULL,
	dj2 numeric(18,6) NULL,
	dj3 numeric(18,6) NULL,
	dj4 numeric(18,6) NULL,
	dj5 numeric(18,6) NULL,
	dj6 numeric(18,6) NULL,
	dj7 numeric(18,6) NULL,
	dj8 numeric(18,6) NULL,
	dj9 numeric(18,6) NULL,
	dj10 numeric(18,6) NULL,
	dj11 numeric(18,6) NULL,
	dj12 numeric(18,6) NULL,
	tsl1 numeric(18,6) NULL,
	tsl2 numeric(18,6) NULL,
	xs_km		varchar(20) NULL,
	xs_ncye	numeric(18,2) NULL,
   xs_dj    numeric(18,6) NULL,
  xs_dje  numeric(18,6) NULL,
  xs_dje1 numeric(18,6) NULL,
  xs_dje2 numeric(18,6) NULL,
  xs_dje3 numeric(18,6) NULL,
  xs_dje4 numeric(18,6) NULL,
  xs_dje5 numeric(18,6) NULL,
  xs_dje6 numeric(18,6) NULL,
  xs_dje7 numeric(18,6) NULL,
  xs_dje8 numeric(18,6) NULL,
  xs_dje9 numeric(18,6) NULL,
  xs_dje10 numeric(18,6) NULL,
  xs_dje11 numeric(18,6) NULL,
  xs_dje12 numeric(18,6) NULL,
  xscbkmdm	varchar(20) NULL,
  sccbkmdm	varchar(20) NULL,
  def_num1	numeric(18,6) NULL,
  def_num2	numeric(18,6) NULL,
  def_num3	numeric(18,6) NULL,
  def_num4	numeric(18,6) NULL,
  def_num5	numeric(18,6) NULL,
  def_str1	varchar(30) NULL,
  def_str2	varchar(30) NULL,
  def_date1	smalldatetime NULL,
  def_date2	smalldatetime NULL,
  def_int1  integer NULL,
  def_int2  integer NULL,
  CONSTRAINT kc_dm_pk Primary KEY NONCLUSTERED (ckdm,dm)
);

CREATE TABLE dbo.kc_dj
(	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	hth	varchar(20) NULL,
	fph	varchar(20) NULL,
	dqh	varchar(4) NULL,
	dwdm	varchar(4) NULL,
	jsfs	smallint NULL,
	dfkm	varchar(20) NULL,
	bmdm	varchar(8) NULL,
	ckdm	char(2) NULL,
	lydm	varchar(4) NULL,
	ytdm	varchar(4) NULL,
	lry	varchar(8) NULL,
	lry2	varchar(8) NULL,
	ysy	varchar(8) NULL,
	shy	varchar(8) NULL,
	jzy	varchar(8) NULL,
	jsr	varchar(8) NULL,
	ysbz	smallint NULL,
	shbz	smallint NULL,
	jzbz	smallint NULL,
	note	varchar(60) NULL,
	yk_pzh	varchar(20)	NULL,
	xe_num	smallint NULL,
	xe_pzh	varchar(4) NULL,
	zfbz		smallint NULL,
	zpzh		integer NULL,
   def_str1	varchar(30) NULL,
   def_str2	varchar(30) NULL,
   def_str3	varchar(30) NULL,
   def_str4	varchar(30) NULL,
   def_num1	numeric(18,6) NULL,
   def_num2	numeric(18,6) NULL,
   def_int1	integer NULL,
   def_int2	integer NULL,
   def_date1	smalldatetime NULL,
   def_date2	smalldatetime NULL,
	CONSTRAINT kc_dj_pk Primary KEY NONCLUSTERED (smon,pzlx,pzh)
);

CREATE TABLE dbo.kc_auto
(	id		integer NOT NULL,
	num	smallint NULL,
	jhd	smallint NULL,
	kmdm	varchar(20) NULL,
	contain	smallint NULL,
	zy		varchar(30) NULL,
	pzlx	varchar(1) NULL,
	form	varchar(80) NULL,
	CONSTRAINT kc_auto_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_pypk
(	id		integer NOT NULL,
	ckdm	char(2) NULL,
	dm		varchar(20)	NULL,
	kh		varchar(30),
	smon	varchar(2) NULL,
	pzlx	varchar(1) NULL,
	pzh	varchar(4) NULL,	
	rq		smalldatetime NULL, 
	sl		numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30) NULL,
	slbak	numeric(18,6) NULL,
	jebak	numeric(18,2) NULL,
	ssl	numeric(18,6) NULL,
	sje	numeric(18,2) NULL,
	fsl	numeric(18,6) NULL,
	fje	numeric(18,2) NULL,
	note	varchar(80) NULL, 
	sbzbak	varchar(30) NULL,
	iykbz	smallint	NULL,	
	bz		smallint NULL,
	ibzbak	smallint	NULL,	
	CONSTRAINT kc_pypk_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_bmyt
(	id		integer NOT NULL,	
	bmdm	varchar(8) NULL,
	ytdm	varchar(4) NULL,
	bz		varchar(30) NULL,
	CONSTRAINT kc_bmyt_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_phyxq
( 	id		integer NOT NULL,
	ckdm	char(2) NULL,
	kw		varchar(30) NULL,
	ph		varchar(20)	NULL,
	dm 	varchar(20)	NULL,
	lrrq	smalldatetime NULL,
	yxq	smalldatetime NULL,
	ncsl	numeric(18,6) NULL,
	ssl 	numeric(18,6) NULL,
	fsl	numeric(18,6) NULL,
	sl		numeric(18,6)	NULL,
	je		numeric(18,2) NULL,
	bq		varchar(60)	NULL,
	sbz	varchar(50)	NULL,
	ibz 	smallint	NULL,
	ibz2	smallint NULL,
   def_date1	smalldatetime NULL,
   def_date2	smalldatetime NULL,
   def_date3	smalldatetime NULL,
   def_num1	numeric(18,6) NULL,
   def_num2	numeric(18,6) NULL,
   def_num3	numeric(18,6) NULL,
   def_num4	numeric(18,6) NULL,
   def_str1	varchar(30) NULL,
   def_str2	varchar(30) NULL,
	CONSTRAINT kc_phyxq_pk Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.kc_mx00
(	id		varchar(6) NOT NULL,
	syear	varchar(4) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	dm		varchar(20) NULL,
	ph		varchar(20) NULL,
	kw		varchar(30)	NULL,
	sl		numeric(18,6) NULL,
	mayuse numeric(18,6) NULL,
	sl_ycx numeric(18,6) NULL,
	dj		numeric(18,6) NULL,
	dj_j	numeric(18,6) NULL,
	je		numeric(18,2) NULL,
	je_j	numeric(18,2) NULL,
	yzf	numeric(18,2) NULL,
	usemony numeric(18,2) NULL,
	je_ycx  numeric(18,2) NULL,
	jzbz	smallint NULL,
	status	varchar(4) NULL,
	bz		varchar(60) NULL,
	fhh	varchar(16) NULL,
	xe_ckpzh varchar(6) NULL,
	def_num2		numeric(18,6) NULL,
  	def_num3		numeric(18,6) NULL,
 	def_num4		numeric(18,6) NULL,
 	def_num5		numeric(18,6) NULL,
 	def_str1		varchar(30) NULL,
 	def_str2		varchar(30) NULL,
 	def_str3		varchar(30) NULL,
 	def_date1	smalldatetime NULL,
 	def_date2	smalldatetime NULL,
 	def_int1		integer NULL,
 	def_int2		integer NULL,
	CONSTRAINT kc_mx00_pk Primary KEY NONCLUSTERED (id,syear,smon)
);

CREATE TABLE dbo.kc_dj00
(	syear	varchar(4) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) NULL,
	pzrq	smalldatetime NULL,
	hth	varchar(20) NULL,
	fph	varchar(20) NULL,
	dqh	varchar(4) NULL,
	dwdm	varchar(4) NULL,
	jsfs	smallint NULL,
	dfkm	varchar(20) NULL,
	bmdm	varchar(8) NULL,
	ckdm	varchar(2) NULL,
	lydm	varchar(4) NULL,
	ytdm	varchar(4) NULL,
	lry	varchar(8) NULL,
	lry2	varchar(8) NULL,
	ysy	varchar(8) NULL,
	shy	varchar(8) NULL,
	jzy	varchar(8) NULL,
	jsr	varchar(8) NULL,
	ysbz	smallint NULL,
	shbz	smallint NULL,
	jzbz	smallint NULL,
	note	varchar(60) NULL,
	yk_pzh	varchar(20)	NULL,
	status	varchar(4) NULL,
	xe_ckpzh	varchar(6) NULL,
	zfbz		smallint NULL,
	zpzh		integer NULL,
	CONSTRAINT kc_dj00_pk Primary KEY NONCLUSTERED (syear,smon,pzlx,pzh)
);

CREATE TABLE dbo.kc_jt
(	smon		varchar(2)		NOT NULL,
	dm			varchar(20)		NOT NULL,
	je			numeric(18,2)	NULL,
	sl			numeric(18,6)	NULL,
	mprice	numeric(18,6)	NULL,
	cell_jt	numeric(18,6)	NULL,
	cell_jt_yu	numeric(18,6)	NULL,
	jt_yu		numeric(18,6)	NULL,
	def_num1	numeric(18,6)	NULL,
	def_num2 numeric(18,6)	NULL,
	def_int1	integer	NULL,
	def_int2	integer	NULL,
	CONSTRAINT	kc_jt_pk Primary	KEY NONCLUSTERED (smon,dm)
);

CREATE TABLE 	dbo.kc_jt
(	smon		varchar(2)		NOT NULL,
	dm			varchar(20)		NOT NULL,
	je			numeric(18,2)	NULL,
	sl			numeric(18,6)	NULL,
	mprice	numeric(18,6)	NULL,
	cell_jt	numeric(18,6)	NULL,
	cell_jt_yu	numeric(18,6)	NULL,
	jt_yu		numeric(18,6)	NULL,
	def_num1	numeric(18,6)	NULL,
	def_num2 numeric(18,6)	NULL,
	def_int1	integer	NULL,
	def_int2	integer	NULL,
	CONSTRAINT	kc_jt_pk Primary	KEY NONCLUSTERED (smon,dm)
);

CREATE TABLE dbo.kc_rep
(	repno		char(4) NOT NULL,
	repname		varchar(30) NULL,
	fillinpsn	varchar(10) NULL,
	fillindate	smalldatetime NULL,
	repowner	varchar(30) NULL,
	def_num1	numeric(18,6) NULL,
   	def_num2	numeric(18,6) NULL,
   	def_num3	numeric(18,6) NULL,
   	def_num4	numeric(18,6) NULL,
   	def_str1	varchar(30) NULL,
   	def_str2	varchar(30) NULL,
   	def_str3	varchar(30) NULL,
   	def_date1	smalldatetime NULL,
   	def_date2	smalldatetime NULL,
   	def_int1	integer NULL,
   	def_int2	integer NULL,
	CONSTRAINT kc_rep_pk Primary KEY NONCLUSTERED (repno)
);

CREATE TABLE dbo.kc_rep_design
(	repno		char(4) NOT NULL,
	repid		integer NOT NULL,
	idtype		char(2) NULL,
	content 	varchar(60) NULL,
	repflg		char(1) NULL,
	describe	varchar(60) NULL,
	lyyt		char(1) NULL,
	def_num1	numeric(18,6) NULL,
   	def_num2	numeric(18,6) NULL,
   	def_num3	numeric(18,6) NULL,
   	def_num4	numeric(18,6) NULL,
   	def_str1	varchar(30) NULL,
   	def_str2	varchar(30) NULL,
   	def_str3	varchar(30) NULL,
   	def_date1	smalldatetime NULL,
   	def_date2	smalldatetime NULL,
   	def_int1	integer NULL,
   	def_int2	integer NULL,
	CONSTRAINT kc_repdesign_pk Primary KEY NONCLUSTERED (repno,repid)
);

CREATE TABLE dbo.kc_repqx
(	
   	xm       char(8)  Not Null,
	repno		char(4) NOT NULL,
	def_num1	numeric(18,6) NULL,
 	def_num2	numeric(18,6) NULL,
  	def_num3	numeric(18,6) NULL,
  	def_num4	numeric(18,6) NULL,
  	def_str1	varchar(30) NULL,
  	def_str2	varchar(30) NULL,
 	def_str3	varchar(30) NULL,
  	def_date1	smalldatetime NULL,
  	def_date2	smalldatetime NULL,
  	def_int1	integer NULL,
  	def_int2	integer NULL,
	CONSTRAINT kc_repqx_pk Primary KEY NONCLUSTERED (xm,repno)
);

create view dbo.kc_cs as 
 (
 select kc_dm.ckdm as ckdm,
 	kc_dm.dm as dm,
	kc_dm.chlb as chlb,
	kc_dm.gg as gg,
	(kc_dm.ncjcsl + kc_dm.sljsl - kc_dm.fljsl) as dmncsl,
	(kc_dm.ncye + kc_dm.jje - kc_dm.dje) as dmncye,
	(kc_dm.ncye_j + kc_dm.jje_j - kc_dm.dje_j) as dmncye_j,
	kc_phyxq.kw as kw,
	kc_phyxq.ph as ph,
	kc_phyxq.ncsl as ncsl 
 from	kc_dm left outer join kc_phyxq on (kc_dm.ckdm = kc_phyxq.ckdm and kc_dm.dm = kc_phyxq.dm) 
 where 	kc_dm.ckdm <> '00' and kc_dm.islb = 0
);

[CREATE INDEX]
DROP INDEX kc_auto.kc_auto_x;
DROP INDEX kc_auto.kc_auto_num;
DROP INDEX kc_bm.kc_bm_x;
DROP INDEX kc_bm.kc_bmyt_x;
DROP INDEX kc_bmyt.kc_bmyt_bm;
DROP INDEX kc_bmyt.kc_bmyt_yt;
DROP INDEX kc_chlb.kc_chlb_x;
DROP INDEX kc_chlb.kc_chlb_mc;
DROP INDEX kc_ck.kc_ck_x;
DROP INDEX kc_ck.kc_ck_mc;
DROP INDEX kc_ckqx.kc_ckqx_x;
DROP INDEX kc_ckqx.kc_ckqx_xm;
DROP INDEX kc_ckqx.kc_ckqx_ck;
DROP INDEX kc_def.kc_def_x;
DROP INDEX kc_dj.kc_dj_x;
DROP INDEX kc_dj.kc_dj_bz;
DROP INDEX kc_dj.kc_dj_wldw;
DROP INDEX kc_dj.kc_dj_htfp;
DROP INDEX kc_dj.kc_dj_ck;
DROP INDEX kc_dj.kc_dj_bm;
DROP INDEX kc_dj.kc_dj_lyyt;
DROP INDEX kc_dj.kc_dj_zpzh;
DROP INDEX kc_dj00.kc_dj00_x;
DROP INDEX kc_dj00.kc_dj00_ck;
DROP INDEX kc_dj00.kc_dj00_zpzh;
DROP INDEX kc_dm.kc_dm_x;
DROP INDEX kc_dm.kc_dm_ck;
DROP INDEX kc_dm.kc_dm_dm;
DROP INDEX kc_dm.kc_dm_islb;
DROP INDEX kc_dm.kc_dm_chlb;
DROP INDEX kc_dm.kc_dm_ffid;
DROP INDEX kc_dm.kc_dm_olddm;
DROP INDEX kc_ff.kc_ff_x;
DROP INDEX kc_flag.kc_flag_x;
DROP INDEX kc_jsfs.kc_jsfs_x;
DROP INDEX kc_jzbz.kc_jzbz_x;
DROP INDEX kc_kw.kc_kw_x;
DROP INDEX kc_kw.kc_kw_ck;
DROP INDEX kc_kw.kc_kw_dm;
DROP INDEX kc_ly.kc_ly_x;
DROP INDEX kc_mx.kc_mx_x;
DROP INDEX kc_mx.kc_mx_x;
DROP INDEX kc_mx.kc_mx_dm;
DROP INDEX kc_mx.kc_mx_ckpzh;
DROP INDEX kc_mx.kc_mx_jk;
DROP INDEX kc_mx.kc_mx_phkw;
DROP INDEX kc_mx00.kc_mx00_x;
DROP INDEX kc_mx00.kc_mx00_x;
DROP INDEX kc_mx00.kc_mx00_dm;
DROP INDEX kc_mx01.kc_mx01_x;
DROP INDEX kc_mx01.kc_mx01_x;
DROP INDEX kc_mx01.kc_mx01_dm;
DROP INDEX kc_mx01.kc_mx01_ckpzh;
DROP INDEX kc_mx01.kc_mx01_jk;
DROP INDEX kc_mx01.kc_mx01_phkw;
DROP INDEX kc_mx02.kc_mx02_x;
DROP INDEX kc_mx02.kc_mx02_x;
DROP INDEX kc_mx02.kc_mx02_dm;
DROP INDEX kc_mx02.kc_mx02_ckpzh;
DROP INDEX kc_mx02.kc_mx02_jk;
DROP INDEX kc_mx02.kc_mx02_phkw;
DROP INDEX kc_mx03.kc_mx03_x;
DROP INDEX kc_mx03.kc_mx03_x;
DROP INDEX kc_mx03.kc_mx03_dm;
DROP INDEX kc_mx03.kc_mx03_ckpzh;
DROP INDEX kc_mx03.kc_mx03_jk;
DROP INDEX kc_mx03.kc_mx03_phkw;
DROP INDEX kc_mx04.kc_mx04_x;
DROP INDEX kc_mx04.kc_mx04_x;
DROP INDEX kc_mx04.kc_mx04_dm;
DROP INDEX kc_mx04.kc_mx04_ckpzh;
DROP INDEX kc_mx04.kc_mx04_jk;
DROP INDEX kc_mx04.kc_mx04_phkw;
DROP INDEX kc_mx05.kc_mx05_x;
DROP INDEX kc_mx05.kc_mx05_x;
DROP INDEX kc_mx05.kc_mx05_dm;
DROP INDEX kc_mx05.kc_mx05_ckpzh;
DROP INDEX kc_mx05.kc_mx05_jk;
DROP INDEX kc_mx05.kc_mx05_phkw;
DROP INDEX kc_mx06_x;
DROP INDEX kc_mx06.kc_mx06_x;
DROP INDEX kc_mx06.kc_mx06_dm;
DROP INDEX kc_mx06.kc_mx06_ckpzh;
DROP INDEX kc_mx06.kc_mx06_jk;
DROP INDEX kc_mx06.kc_mx06_phkw;
DROP INDEX kc_mx07.kc_mx07_x;
DROP INDEX kc_mx07.kc_mx07_x;
DROP INDEX kc_mx07.kc_mx07_dm;
DROP INDEX kc_mx07.kc_mx07_ckpzh;
DROP INDEX kc_mx07.kc_mx07_jk;
DROP INDEX kc_mx07.kc_mx07_phkw;
DROP INDEX kc_mx08.kc_mx08_x;
DROP INDEX kc_mx08.kc_mx08_x;
DROP INDEX kc_mx08.kc_mx08_dm;
DROP INDEX kc_mx08.kc_mx08_ckpzh;
DROP INDEX kc_mx08.kc_mx08_jk;
DROP INDEX kc_mx08.kc_mx08_phkw;
DROP INDEX kc_mx09.kc_mx09_x;
DROP INDEX kc_mx09.kc_mx09_x;
DROP INDEX kc_mx09.kc_mx09_dm;
DROP INDEX kc_mx09.kc_mx09_ckpzh;
DROP INDEX kc_mx09.kc_mx09_jk;
DROP INDEX kc_mx09.kc_mx09_phkw;
DROP INDEX kc_mx10.kc_mx10_x;
DROP INDEX kc_mx10.kc_mx10_x;
DROP INDEX kc_mx10.kc_mx10_dm;
DROP INDEX kc_mx10.kc_mx10_ckpzh;
DROP INDEX kc_mx10.kc_mx10_jk;
DROP INDEX kc_mx10.kc_mx10_phkw;
DROP INDEX kc_mx11.kc_mx11_x;
DROP INDEX kc_mx11.kc_mx11_x;
DROP INDEX kc_mx11.kc_mx11_dm;
DROP INDEX kc_mx11.kc_mx11_ckpzh;
DROP INDEX kc_mx11.kc_mx11_jk;
DROP INDEX kc_mx11.kc_mx11_phkw;
DROP INDEX kc_mx12.kc_mx12_x;
DROP INDEX kc_mx12.kc_mx12_x;
DROP INDEX kc_mx12.kc_mx12_dm;
DROP INDEX kc_mx12.kc_mx12_ckpzh;
DROP INDEX kc_mx12.kc_mx12_jk;
DROP INDEX kc_mx12.kc_mx12_phkw;
DROP INDEX kc_phyxq.kc_phyxq_x;
DROP INDEX kc_phyxq.kc_phyxq_ckdm;
DROP INDEX kc_phyxq.kc_phyxq_dm;
DROP INDEX kc_phyxq.kc_phyxq_kwph;
DROP INDEX kc_phyxq.kc_phyxq_ibz;
DROP INDEX kc_pypk.kc_pypk_x;
DROP INDEX kc_pypk.kc_pypk_ckkh;
DROP INDEX kc_pypk.kc_pypk_pzh;
DROP INDEX kc_pypk.kc_pypk_dm;
DROP INDEX kc_pypk.kc_pypk_bz;
DROP INDEX kc_pz.kc_pz_x;
DROP INDEX kc_pz.kc_pz_zwpzh;
DROP INDEX kc_pz.kc_pz_pzh;
DROP INDEX kc_qx.kc_qx_x;
DROP INDEX kc_xeset.kc_xeset_x;
DROP INDEX kc_xeset.kc_xeset_xe;
DROP INDEX kc_xeset.kc_xeset_pld;
DROP INDEX kc_xeset.kc_xeset_num;
DROP INDEX kc_yt.kc_yt_x;
DROP INDEX kc_jt.kc_jt_x;
DROP INDEX kc_jt.kc_jt_dm;

CREATE UNIQUE INDEX kc_auto_x ON dbo.kc_auto(id);
CREATE INDEX kc_auto_num ON dbo.kc_auto(num);
CREATE UNIQUE INDEX kc_bm_x ON dbo.kc_bm(dm);
CREATE UNIQUE INDEX kc_bmyt_x ON dbo.kc_bmyt(id);
CREATE INDEX kc_bmyt_bm ON dbo.kc_bmyt(bmdm);
CREATE INDEX kc_bmyt_yt ON dbo.kc_bmyt(ytdm);
CREATE UNIQUE INDEX kc_chlb_x ON dbo.kc_chlb(dm);
CREATE INDEX kc_chlb_mc ON dbo.kc_chlb(mc);
CREATE UNIQUE INDEX kc_ck_x ON dbo.kc_ck(dm);
CREATE INDEX kc_ck_mc ON dbo.kc_ck(mc);
CREATE UNIQUE INDEX kc_ckqx_x ON dbo.kc_ckqx(xm,ckqx);
CREATE INDEX kc_ckqx_xm ON dbo.kc_ckqx(xm);
CREATE INDEX kc_ckqx_ck ON dbo.kc_ckqx(ckqx);
CREATE UNIQUE INDEX kc_def_x ON dbo.kc_def(id);
CREATE UNIQUE INDEX kc_dj_x ON dbo.kc_dj(smon,pzlx,pzh);
CREATE INDEX kc_dj_ysbz ON dbo.kc_dj(ysbz,shbz,jzbz);
CREATE INDEX kc_dj_wldw ON dbo.kc_dj(dqh,dwdm);
CREATE INDEX kc_dj_htfp ON dbo.kc_dj(hth,fph);
CREATE INDEX kc_dj_ck ON dbo.kc_dj(ckdm,ckpzh);
CREATE INDEX kc_dj_bm ON dbo.kc_dj(bmdm);
CREATE INDEX kc_dj_lyyt ON dbo.kc_dj(lydm,ytdm); 
CREATE INDEX kc_dj_zpzh ON dbo.kc_dj(zpzh);
CREATE UNIQUE INDEX kc_dj00_x ON dbo.kc_dj00(syear,smon,pzlx,pzh);
CREATE INDEX kc_dj00_ck ON dbo.kc_dj00(ckdm);
CREATE INDEX kc_dj00_zpzh ON dbo.kc_dj00(zpzh);
CREATE UNIQUE INDEX kc_dm_x ON dbo.kc_dm(ckdm,dm);
CREATE INDEX kc_dm_ck ON dbo.kc_dm(ckdm);
CREATE INDEX kc_dm_dm ON dbo.kc_dm(dm);
CREATE INDEX kc_dm_islb ON dbo.kc_dm(islb);
CREATE INDEX kc_dm_chlb ON dbo.kc_dm(chlb);
CREATE INDEX kc_dm_ffid ON dbo.kc_dm(ffid);
CREATE INDEX kc_dm_olddm ON dbo.kc_dm(def_str1);
CREATE UNIQUE INDEX kc_ff_x ON dbo.kc_ff(id);
CREATE UNIQUE INDEX kc_flag_x ON dbo.kc_flag(id);
CREATE UNIQUE INDEX kc_jsfs_x ON dbo.kc_jsfs(dm);
CREATE UNIQUE INDEX kc_jzbz_x ON dbo.kc_jzbz(id);
CREATE UNIQUE INDEX kc_kw_x ON dbo.kc_kw(ckdm,dm);
CREATE INDEX kc_kw_ck ON dbo.kc_kw(ckdm);
CREATE INDEX kc_kw_dm ON dbo.kc_kw(dm);
CREATE UNIQUE INDEX kc_ly_x ON dbo.kc_ly(dm);
CREATE UNIQUE INDEX kc_mx_x ON dbo.kc_mx(id);
CREATE INDEX kc_mx_x ON dbo.kc_mx(smon,pzlx,pzh);
CREATE INDEX kc_mx_dm ON dbo.kc_mx(dm);
CREATE INDEX kc_mx_ckpzh ON dbo.kc_mx(ckpzh);
CREATE INDEX kc_mx_jk ON dbo.kc_mx(fhh,mxid);
CREATE INDEX kc_mx_phkw ON dbo.kc_mx(kw,ph);
CREATE UNIQUE INDEX kc_mx00_x ON dbo.kc_mx00(id,syear,smon);
CREATE INDEX kc_mx00_x ON dbo.kc_mx00(smon,pzlx,pzh);
CREATE INDEX kc_mx00_dm ON dbo.kc_mx00(dm);
CREATE UNIQUE INDEX kc_mx01_x ON dbo.kc_mx01(id);
CREATE INDEX kc_mx01_x ON dbo.kc_mx01(smon,pzlx,pzh);
CREATE INDEX kc_mx01_dm ON dbo.kc_mx01(dm);
CREATE INDEX kc_mx01_ckpzh ON dbo.kc_mx01(ckpzh);
CREATE INDEX kc_mx01_jk ON dbo.kc_mx01(fhh,mxid);
CREATE INDEX kc_mx01_phkw ON dbo.kc_mx01(kw,ph);
CREATE UNIQUE INDEX kc_mx02_x ON dbo.kc_mx02(id);
CREATE INDEX kc_mx02_x ON dbo.kc_mx02(smon,pzlx,pzh);
CREATE INDEX kc_mx02_dm ON dbo.kc_mx02(dm);
CREATE INDEX kc_mx02_ckpzh ON dbo.kc_mx02(ckpzh);
CREATE INDEX kc_mx02_jk ON dbo.kc_mx02(fhh,mxid);
CREATE INDEX kc_mx02_phkw ON dbo.kc_mx02(kw,ph);
CREATE UNIQUE INDEX kc_mx03_x ON dbo.kc_mx03(id);
CREATE INDEX kc_mx03_x ON dbo.kc_mx03(smon,pzlx,pzh);
CREATE INDEX kc_mx03_dm ON dbo.kc_mx03(dm);
CREATE INDEX kc_mx03_ckpzh ON dbo.kc_mx03(ckpzh);
CREATE INDEX kc_mx03_jk ON dbo.kc_mx03(fhh,mxid);
CREATE INDEX kc_mx03_phkw ON dbo.kc_mx03(kw,ph);
CREATE UNIQUE INDEX kc_mx04_x ON dbo.kc_mx04(id);
CREATE INDEX kc_mx04_x ON dbo.kc_mx04(smon,pzlx,pzh);
CREATE INDEX kc_mx04_dm ON dbo.kc_mx04(dm);
CREATE INDEX kc_mx04_ckpzh ON dbo.kc_mx04(ckpzh);
CREATE INDEX kc_mx04_jk ON dbo.kc_mx04(fhh,mxid);
CREATE INDEX kc_mx04_phkw ON dbo.kc_mx04(kw,ph);
CREATE UNIQUE INDEX kc_mx05_x ON dbo.kc_mx05(id);
CREATE INDEX kc_mx05_x ON dbo.kc_mx05(smon,pzlx,pzh);
CREATE INDEX kc_mx05_dm ON dbo.kc_mx05(dm);
CREATE INDEX kc_mx05_ckpzh ON dbo.kc_mx05(ckpzh);
CREATE INDEX kc_mx05_jk ON dbo.kc_mx05(fhh,mxid);
CREATE INDEX kc_mx05_phkw ON dbo.kc_mx05(kw,ph);
CREATE UNIQUE INDEX kc_mx06_x ON dbo.kc_mx06(id);
CREATE INDEX kc_mx06_x ON dbo.kc_mx06(smon,pzlx,pzh);
CREATE INDEX kc_mx06_dm ON dbo.kc_mx06(dm);
CREATE INDEX kc_mx06_ckpzh ON dbo.kc_mx06(ckpzh);
CREATE INDEX kc_mx06_jk ON dbo.kc_mx06(fhh,mxid);
CREATE INDEX kc_mx06_phkw ON dbo.kc_mx06(kw,ph);
CREATE UNIQUE INDEX kc_mx07_x ON dbo.kc_mx07(id);
CREATE INDEX kc_mx07_x ON dbo.kc_mx07(smon,pzlx,pzh);
CREATE INDEX kc_mx07_dm ON dbo.kc_mx07(dm);
CREATE INDEX kc_mx07_ckpzh ON dbo.kc_mx07(ckpzh);
CREATE INDEX kc_mx07_jk ON dbo.kc_mx07(fhh,mxid);
CREATE INDEX kc_mx07_phkw ON dbo.kc_mx07(kw,ph);
CREATE UNIQUE INDEX kc_mx08_x ON dbo.kc_mx08(id);
CREATE INDEX kc_mx08_x ON dbo.kc_mx08(smon,pzlx,pzh);
CREATE INDEX kc_mx08_dm ON dbo.kc_mx08(dm);
CREATE INDEX kc_mx08_ckpzh ON dbo.kc_mx08(ckpzh);
CREATE INDEX kc_mx08_jk ON dbo.kc_mx08(fhh,mxid);
CREATE INDEX kc_mx08_phkw ON dbo.kc_mx08(kw,ph);
CREATE UNIQUE INDEX kc_mx09_x ON dbo.kc_mx09(id);
CREATE INDEX kc_mx09_x ON dbo.kc_mx09(smon,pzlx,pzh);
CREATE INDEX kc_mx09_dm ON dbo.kc_mx09(dm);
CREATE INDEX kc_mx09_ckpzh ON dbo.kc_mx09(ckpzh);
CREATE INDEX kc_mx09_jk ON dbo.kc_mx09(fhh,mxid);
CREATE INDEX kc_mx09_phkw ON dbo.kc_mx09(kw,ph);
CREATE UNIQUE INDEX kc_mx10_x ON dbo.kc_mx10(id);
CREATE INDEX kc_mx10_x ON dbo.kc_mx10(smon,pzlx,pzh);
CREATE INDEX kc_mx10_dm ON dbo.kc_mx10(dm);
CREATE INDEX kc_mx10_ckpzh ON dbo.kc_mx10(ckpzh);
CREATE INDEX kc_mx10_jk ON dbo.kc_mx10(fhh,mxid);
CREATE INDEX kc_mx10_phkw ON dbo.kc_mx10(kw,ph);
CREATE UNIQUE INDEX kc_mx11_x ON dbo.kc_mx11(id);
CREATE INDEX kc_mx11_x ON dbo.kc_mx11(smon,pzlx,pzh);
CREATE INDEX kc_mx11_dm ON dbo.kc_mx11(dm);
CREATE INDEX kc_mx11_ckpzh ON dbo.kc_mx11(ckpzh);
CREATE INDEX kc_mx11_jk ON dbo.kc_mx11(fhh,mxid);
CREATE INDEX kc_mx11_phkw ON dbo.kc_mx11(kw,ph);
CREATE UNIQUE INDEX kc_mx12_x ON dbo.kc_mx12(id);
CREATE INDEX kc_mx12_x ON dbo.kc_mx12(smon,pzlx,pzh);
CREATE INDEX kc_mx12_dm ON dbo.kc_mx12(dm);
CREATE INDEX kc_mx12_ckpzh ON dbo.kc_mx12(ckpzh);
CREATE INDEX kc_mx12_jk ON dbo.kc_mx12(fhh,mxid);
CREATE INDEX kc_mx12_phkw ON dbo.kc_mx12(kw,ph);
CREATE UNIQUE INDEX kc_phyxq_x ON dbo.kc_phyxq(id);
CREATE INDEX kc_phyxq_ckdm ON dbo.kc_phyxq(ckdm);
CREATE INDEX kc_phyxq_dm ON dbo.kc_phyxq(dm);
CREATE INDEX kc_phyxq_kwph ON dbo.kc_phyxq(kw,ph);
CREATE INDEX kc_phyxq_ibz ON dbo.kc_phyxq(ibz);
CREATE UNIQUE INDEX kc_pypk_x ON dbo.kc_pypk(id);
CREATE INDEX kc_pypk_ckkh ON dbo.kc_pypk(ckdm,kh);
CREATE INDEX kc_pypk_pzh ON dbo.kc_pypk(smon,pzh,pzlx);
CREATE INDEX kc_pypk_dm ON dbo.kc_pypk(dm);
CREATE INDEX kc_pypk_bz ON dbo.kc_pypk(ibzbak,bz,iykbz);
CREATE UNIQUE INDEX kc_pz_x ON dbo.kc_pz(id);
CREATE INDEX kc_pz_zwpzh ON dbo.kc_pz(spp);
CREATE INDEX kc_pz_pzh ON dbo.kc_pz(pzh);
CREATE UNIQUE INDEX kc_qx_x ON dbo.kc_qx(xm);
CREATE UNIQUE INDEX kc_xeset_x ON dbo.kc_xeset(id);
CREATE INDEX kc_xeset_xe ON dbo.kc_xeset(dm,smon,bmdm,ckdm);
CREATE INDEX kc_xeset_pld ON dbo.kc_xeset(dm,ckdm);
CREATE INDEX kc_xeset_num ON dbo.kc_xeset(num,nums);
CREATE UNIQUE INDEX kc_yt_x ON dbo.kc_yt(dm);
CREATE UNIQUE INDEX kc_jt_x ON dbo.kc_jt(smon,dm);
CREATE INDEX kc_jt_dm ON dbo.kc_jt(dm);