CREATE TABLE dbo.x_htcl (
	id        	int	NOT NULL	,
	jclass    	varchar(20)	NULL	,
CONSTRAINT htcl_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_ht (
	id        	int	NOT NULL	,
	kpr       	varchar(10)	NULL	,
	isstop    	tinyint	NULL	,
	xfdqmc    	varchar(10)	NULL	,
	htdm      	varchar(30)	NULL	,
	xfdq      	varchar(4)	NULL	,
	xfdm      	varchar(4)	NULL	,
	xfmc      	varchar(60)	NULL	,
	xfdz      	varchar(60)	NULL	,
	xffr      	varchar(10)	NULL	,
	xfdlr     	varchar(10)	NULL	,
	xfdh      	varchar(20)	NULL	,
	xfkhyh    	varchar(60)	NULL	,
	xfkhym    	varchar(10)	NULL	,
	xfzh      	varchar(30)	NULL	,
	xfyb      	varchar(10)	NULL	,
	xfsh      	varchar(30)	NULL	,
	gfdm      	varchar(4)	NULL	,
	gfmc      	varchar(60)	NULL	,
	gfdz      	varchar(60)	NULL	,
	gffr      	varchar(10)	NULL	,
	gfdlr     	varchar(14)	NULL	,
	gfdh      	varchar(20)	NULL	,
	gfkhyh    	varchar(60)	NULL	,
	gfkhym    	varchar(10)	NULL	,
	gfzh      	varchar(30)	NULL	,
	gfyb      	varchar(10)	NULL	,
	gfsh      	varchar(30)	NULL	,
	qddd      	varchar(30)	NULL	,
	qdrq      	smalldatetime	NULL	,
	bz        	varchar(254)	NULL	,
	sxrq      	smalldatetime	NULL	,
	zzrq      	smalldatetime	NULL	,
	zt        	tinyint	NULL	,
	jclass    	tinyint	NULL	,
	je        	numeric(16,4)	NULL	,
	skje      	numeric(16,4)	NULL	,
	wbje			numeric(16,4) NULL,
	wbfh			varchar(4) NULL,
	wbrate		numeric(16,4) NULL,
	zkje 			numeric(16,4) NULL,
	hxje 			numeric(16,4) NULL,
	bchx			numeric(16,4) NULL,
	hxbz			tinyint NULL,
	yearbz			varchar(4) NULL,
CONSTRAINT ht_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_hthw (
	id        	int	NOT NULL	,
	sk_je     	numeric(16,4)	NULL	,
	fh_sl     	numeric(18,6)	NULL	,
	htdm      	varchar(30)	NULL	,
	htcl      	smallint	NULL	,
	htid      	int	NULL	,
	rq        	smalldatetime	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwsl      	numeric(18,6)	NULL	,
	hwdj        numeric(16,6)   NULL    ,
	je        	numeric(16,4)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	sldw      	varchar(10)	NULL	,
	fp_sl     	numeric(18,6)	NULL	,
	fp_je     	numeric(16,4)	NULL	,
	xs_dje1     numeric(16,6)   NULL    ,
	xs_dje2     numeric(16,6)   NULL    ,
	xs_dje3     numeric(16,6)   NULL    ,
	xs_dje4     numeric(16,6)   NULL    ,
	zkl       	numeric(16,4)	NULL	,
	zke       	numeric(16,4)	NULL	,
	ckdm      	varchar(4)	NULL	,
	kmdm      	varchar(20)	NULL	,
	wbje        numeric(16,4) NULL,
	slu         numeric(16,4)   NULL,
	hsdj        numeric(16,6)   NULL,
	fh_je			numeric(16,4)	null,
	th_sl			numeric(18,6)	null,
	th_je			numeric(16,4)	null,
	ch_sl			numeric(18,6)	null,
	ch_je			numeric(16,4)	null,
	sk_sl			numeric(18,6)	null,
	yhxje     	numeric(16,4)	NULL	,
	bchxje    	numeric(16,4)	NULL	,
	yhxsl     	numeric(18,6)	NULL	,
	bchxsl    	numeric(18,6)	NULL	,
	ishx      	tinyint	NULL	,
CONSTRAINT hthw_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_htzk (
	htid      	int	NOT NULL	,
	rq        	smalldatetime	NULL	,
	je        	numeric(16,4)	NULL	,
	bz        	varchar(254)	NULL	,
	dt1       	smalldatetime	NULL	,
	dt2       	smalldatetime	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
CONSTRAINT htzk_x	Primary KEY NONCLUSTERED (htid)
);

CREATE TABLE dbo.x_fh (
	id        	int	NOT NULL	,
	wldw      	varchar(60)	NULL	,
	bmdm      	varchar(9)	NULL	,
	kpr       	varchar(10)	NULL	,
	zt        	smallint	NULL	,
	pwd       	varchar(10)	NULL	,
	thr       	varchar(10)	NULL	,
	ckdm      	char(2)	NULL	,
	startrq   	smalldatetime	NULL	,
	endrq     	smalldatetime	NULL	,
	dqh       	varchar(10)	NULL	,
	dqmc      	varchar(10)	NULL	,
	fph       	varchar(10)	NULL	,
	style     	smallint	NULL	,
	bz        	varchar(254)	NULL	,
	used      	smallint	NULL	,
	jcarry    	smallint	NULL	,
	user01    	varchar(20)	NULL	,
	pjh       	varchar(16)	NULL	,
	rq        	smalldatetime	NULL	,
	htdm      	varchar(30)	NULL	,
	jclass    	tinyint	NULL	,
	dwdm      	varchar(10)	NULL	,
	iskp			smallint	NULL	,
	je				numeric(16,4) NULL,
	zkje			numeric(16,4) NULL,
	hxje			numeric(16,4) NULL,
	bchx			numeric(16,4) NULL,
	hxbz			smallint NULL,
	lx				smallint NULL,
	iszf			smallint	NULL,
	htid			int	null,
        fromxj                 smallint null,
	yearbz			varchar(4) NULL,
CONSTRAINT fh_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_fhhw (
	id        	int	NOT NULL	,
	fhid      	int	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	sldw      	varchar(6)	NULL	,
	sl        	numeric(18,6)	NULL	,
	hwgg      	varchar(50)	NULL	,
	sfsl      	numeric(18,6)	NULL	,
	ckdm      	char(2)	NULL	,
	htdm      	varchar(30)	NULL	,
	kmdm      	varchar(20)	NULL	,
	dj          numeric(16,6)   NULL    ,
	xs_dj1      numeric(16,6)   NULL    ,
	xs_dj2      numeric(16,6)   NULL    ,
	xs_dj3      numeric(16,6)   NULL    ,
	xs_dj4      numeric(16,6)   NULL    ,
	ph        	varchar(40)	NULL	,
	yksl		numeric(18,6)		NUll	,
	ykje		numeric(16,4)		NULL	,
	zkl		numeric(16,4) 	NULL,
	zke		numeric(16,4) NULL,
	bz			varchar(254) NULL,
	slu		numeric(16,4)	NULL,
	hsdj     numeric(16,6)   NULL,
	fp_je		numeric(16,4)	null,
	fp_sl		numeric(18,6)	null,
	htid		int	null,
	th_sl		numeric(18,6)	null,
	th_je		numeric(16,6)	null,	
	yhxje     	numeric(16,4)	NULL	,
	bchxje    	numeric(16,4)	NULL	,
	yhxsl     	numeric(18,6)	NULL	,
	bchxsl    	numeric(18,6)	NULL	,
	ishx      	tinyint	NULL	,
CONSTRAINT fhhw_x	Primary KEY NONCLUSTERED (id)
);


CREATE TABLE dbo.x_fp (
	id        	int	NOT NULL	,
	fph       	varchar(16)	NULL	,
	rq        	smalldatetime	NULL	,
	bank      	varchar(60)	NULL	,
	zh        	varchar(30)	NULL	,
	sz        	varchar(8)	NULL	,
	se        	numeric(16,4)	NULL	,
	je        	numeric(16,4)	NULL	,
	jsfs      	tinyint	NULL	,
	jspjh     	varchar(10)	NULL	,
	kpr       	varchar(14)	NULL	,
	shr       	varchar(14)	NULL	,
	skr       	varchar(14)	NULL	,
	bz        	varchar(254)	NULL	,
	fptype    	smallint	NULL	,
	kmdm      	varchar(20)	NULL	,
	htdm      	varchar(30)	NULL	,
	iszf      	smallint	NULL	,
	emp       	varchar(14)	NULL	,
	zt        	tinyint	NULL	,
	jzr       	varchar(14)	NULL	,
	dqh       	varchar(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwdm      	varchar(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	dwtel     	varchar(20)	NULL	,
	dwzp      	varchar(10)	NULL	,
	dwkhh     	varchar(60)	NULL	,
	dwzh      	varchar(30)	NULL	,
	dwsh      	varchar(30)	NULL	,
	dwaddr    	varchar(60)	NULL	,
	htid      	int	NULL	,
	pzh       	varchar(10)	NULL	,
	pzrq      	smalldatetime	NULL	,
	ddfy      	numeric(16,4)	NULL	,
	ddjs      	int	NULL	,
	ddjsh     	varchar(10)	NULL	,
	iskp      	tinyint	NULL	,
	isok      	tinyint	NULL	,
	style     	tinyint	NULL	,
	fhd       	varchar(10)	NULL	,
	ischeck   	tinyint	NULL	,
	ishs      	tinyint	NULL	,
	hsje_s    	numeric(16,4)	NULL	,
	hxje 			numeric(16,4) NULL,
	bchx 			numeric(16,4) NULL,
	hxbz 			tinyint NULL,
	wbje			numeric(16,4) NULL,
	wbfh			varchar(4) NULL,
	wbrate		numeric(16,4) NULL,
	zkje			numeric(16,4) NULL,
	chfpyj		varchar(20) NULL,
	zzsfph		varchar(20) NULL,
	chje			numeric(16,4)	NULL,
	chse			numeric(16,4)	NULL,
	istransout      	tinyint	NULL	,
        fromxj                 smallint null,
	yearbz			varchar(4) NULL,
CONSTRAINT fp_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_fphw (
	id        	int	NOT NULL	,
	fpid      	int	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	sldw      	varchar(6)	NULL	,
	sl        	numeric(18,6)	NULL	,
   dj          numeric(16,6)   NULL    ,
	je        	numeric(16,4)	NULL	,
	se        	numeric(16,4)	NULL	,
	slu       	numeric(16,4)	NULL	,
	htid      	int	NULL	,
	htdm      	varchar(30)	NULL	,
	maoli     	numeric(16,4)	NULL	,
	yhxje     	numeric(16,4)	NULL	,
	bchxje    	numeric(16,4)	NULL	,
	yhxsl     	numeric(18,6)	NULL	,
	bchxsl    	numeric(18,6)	NULL	,
   xs_dje1     numeric(16,6)   NULL    ,
   xs_dje2     numeric(16,6)   NULL    ,
   xs_dje3     numeric(16,6)   NULL    ,
   xs_dje4     numeric(16,6)   NULL    ,
	ckdm      	varchar(4)	NULL	,
	kmdm      	varchar(20)	NULL	,
	ishx      	tinyint	NULL	,
	yksl			numeric(18,6)		NUll	,
	ykje			numeric(16,4)		NULL	,
	wbje			numeric(16,4) NULL,
	zkl			numeric(16,4) NULL,
	zke			numeric(16,4) NULL,
   hsdj        numeric(16,6)   NULL,
	chje			numeric(16,4)	NULL,
	chse			numeric(16,4)	NULL,
	chsl			numeric(18,6)	NULL,
	fh_sl			numeric(18,6)	null,
	fh_je			numeric(16,6)	null,
CONSTRAINT fphw_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_fpty (
	id int not null,
	fptype    	varchar(30)	NULL	,
	jrows     	int	NULL	,
	book      	int	NULL	,
	tpfile    	varchar(12)	NULL	,
	width     	numeric(16,4)	NULL	,
	height    	numeric(16,4)	NULL	,
	hmgrp     	numeric(16,4)	NULL	,
	limit     	numeric(16,4)	NULL	,
	hmnow     	varchar(16)	NULL	,
	hmlen     	int	NULL	,
	sl        	numeric(18,6)	NULL	,
	issp      	smallint	NULL	,
	hmstart		varchar(16)	NULL	,
	hmend			varchar(16)	NULL	,
	zfs			int	NULL,
	chs			int 	NULL,
	isend			smallint NULL,
CONSTRAINT fpty_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_fpzt (
	id        	tinyint	NOT NULL	,
	fpzt      	varchar(10)	NULL	,
CONSTRAINT fpzt_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_sk (
	id int not null,
	htdm      	varchar(30)	NULL	,
	dwdm      	varchar(10)	NULL	,
	wldw      	varchar(60)	NULL	,
	je        	numeric(16,4)	NULL	,
	jsfs      	int	NULL	,
	jspjh     	varchar(10)	NULL	,
	skr       	varchar(10)	NULL	,
	shr       	varchar(10)	NULL	,
	bz        	varchar(254)	NULL	,
	fkr       	varchar(10)	NULL	,
	yhxje     	numeric(16,4)	NULL	,
	ishx      	int	NULL	,
	fph       	varchar(20)	NULL	,
	je1       	numeric(16,4)	NULL	,
	je2       	numeric(16,4)	NULL	,
	je3       	numeric(16,4)	NULL	,
	je4       	numeric(16,4)	NULL	,
	je5       	numeric(16,4)	NULL	,
	je6       	numeric(16,4)	NULL	,
	je7       	numeric(16,4)	NULL	,
	je8       	numeric(16,4)	NULL	,
   je9       	numeric(16,4)	NULL	,
	je10       	numeric(16,4)	NULL	,
	je11       	numeric(16,4)	NULL	,
	je12       	numeric(16,4)	NULL	,
	je13       	numeric(16,4)	NULL	,
	je14       	numeric(16,4)	NULL	,
	je15       	numeric(16,4)	NULL	,
	conbh     	varchar(10)	NULL	,
	jhkm      	varchar(20)	NULL	,
	kmdm      	varchar(20)	NULL	,
	sl        	numeric(18,6)	NULL	,
	dj        	numeric(16,6)	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	zt        	smallint	NULL	,
	jclass    	smallint	NULL	,
	dqh       	varchar(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	emp       	varchar(14)	NULL	,
	ischeck   	tinyint	NULL	,
	zkl       	numeric(16,4)	NULL	,
	zke       	numeric(16,4)	NULL	,
	hxje      	numeric(16,4)	NULL	,
	pzh       	char(4)	NULL	,
	fhd       	char(20)	NULL	,
	ishs      	int	NULL	,
	hsje_s    	numeric(16,4)	NULL	,
	pjh       	varchar(16)	NULL	,
	rq        	smalldatetime	NULL	,
        shrq        	smalldatetime	NULL	,
	wbje			numeric(16,4) NULL,
	wbfh			varchar(4) NULL,
	wbrate		numeric(16,4) NULL,
   tkje        numeric(16,4) NULL,
   fromdd      smallint NULL,
   fromxj      smallint null,
CONSTRAINT sk_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_skcls (
	id        	smallint	NOT NULL	,
	jclass    	varchar(10)	NULL	,
CONSTRAINT skcls_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_skhx (
	htid	int NOT NULL,
	skid  int	NOT NULL	,
	fpid  int	NOT NULL	,
	hxje  numeric(16,4)	NULL	,
	bz    varchar(254)	NULL	,
	dt1   smalldatetime	NULL	,
	dt2   smalldatetime	NULL	,
	d1    numeric(16,4)	NULL	,
	d2    numeric(16,4)	NULL	,
	str1  varchar(40)	NULL	,
	str2  varchar(40)	NULL	,
CONSTRAINT skhx_x	Primary KEY NONCLUSTERED (htid,skid,fpid)
);

CREATE TABLE dbo.x_skhxmx (
	htid      	int	NOT NULL	,
	fpid      	int	NOT NULL	,
	hwdm      	varchar(20)	NOT NULL	,
	yhxje     	numeric(16,4)	NULL	,
	bchxje    	numeric(16,4)	NULL	,
	bz        	varchar(254)	NULL	,
	dt1       	smalldatetime	NULL	,
	dt2       	smalldatetime	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
CONSTRAINT skhxmx_x	Primary KEY NONCLUSTERED (htid,fpid,hwdm)
);

CREATE TABLE dbo.x_skpzmb (
	id        	int	NOT NULL	,
	zy        	varchar(40)	NULL	,
	kmdm      	varchar(20)	NULL	,
	j_d       	varchar(4)	NULL	,
	je        	varchar(40)	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	dt1       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
CONSTRAINT skpzmb_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_xsjh
(
	emp			varchar(20)	NOT NULL,
	islb			tinyint		NULL,
	ftbl			numeric(16,4)		NULL,
	njh			numeric(16,4)		NULL,
	nde			numeric(16,4)		NULL,
	jh1			numeric(16,4)		NULL,
	de1			numeric(16,4)		NULL,
	jh2			numeric(16,4)		NULL,
	de2			numeric(16,4)		NULL,
	jh3			numeric(16,4)		NULL,
	de3			numeric(16,4)		NULL,
	jh4			numeric(16,4)		NULL,
	de4			numeric(16,4)		NULL,
	jh5			numeric(16,4)		NULL,
	de5			numeric(16,4)		NULL,
	jh6			numeric(16,4)		NULL,
	de6			numeric(16,4)		NULL,
	jh7			numeric(16,4)		NULL,
	de7			numeric(16,4)		NULL,
	jh8			numeric(16,4)		NULL,
	de8			numeric(16,4)		NULL,
	jh9			numeric(16,4)		NULL,
	de9			numeric(16,4)		NULL,
	jh10			numeric(16,4)		NULL,
	de10			numeric(16,4)		NULL,
	jh11			numeric(16,4)		NULL,
	de11			numeric(16,4)		NULL,
	jh12			numeric(16,4)		NULL,
	de12			numeric(16,4)		NULL,
	CONSTRAINT xsjh_x	Primary KEY NONCLUSTERED (emp)
);
CREATE TABLE dbo.x_hwxsjh
(
	id				int		NOT NULL,
	emp			varchar(20)	NULL,
	hwdm			varchar(20)	NULL,
	hwgg			varchar(50)	NULL,
	jldw			varchar(6)	NULL,
	ftbl			numeric(16,4)		NULL,
	njh			numeric(16,4)		NULL,
	nde			numeric(18,6)		NULL,
	jh1			numeric(16,4)		NULL,
	de1			numeric(18,6)		NULL,
	jh2			numeric(16,4)		NULL,
	de2			numeric(18,6)		NULL,
	jh3			numeric(16,4)		NULL,
	de3			numeric(18,6)		NULL,
	jh4			numeric(16,4)		NULL,
	de4			numeric(18,6)		NULL,
	jh5			numeric(16,4)		NULL,
	de5			numeric(18,6)		NULL,
	jh6			numeric(16,4)		NULL,
	de6			numeric(18,6)		NULL,
	jh7			numeric(16,4)		NULL,
	de7			numeric(18,6)		NULL,
	jh8			numeric(16,4)		NULL,
	de8			numeric(18,6)		NULL,
	jh9			numeric(16,4)		NULL,
	de9			numeric(18,6)		NULL,
	jh10			numeric(16,4)		NULL,
	de10			numeric(18,6)		NULL,
	jh11			numeric(16,4)		NULL,
	de11			numeric(18,6)		NULL,
	jh12			numeric(16,4)		NULL,
	de12			numeric(18,6)		NULL,
	hwmc			varchar(50) NULL,
	CONSTRAINT hwxsjh_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_emp (
	id        	int	NOT NULL	,
	xsje1     	numeric(16,4)	NULL	,
	xsje2     	numeric(16,4)	NULL	,
	xsje3     	numeric(16,4)	NULL	,
	xsje4     	numeric(16,4)	NULL	,
	xsje5     	numeric(16,4)	NULL	,
	xsje6     	numeric(16,4)	NULL	,
	xsje7     	numeric(16,4)	NULL	,
	xsje8     	numeric(16,4)	NULL	,
	xsje9     	numeric(16,4)	NULL	,
	xsje10    	numeric(16,4)	NULL	,
	xsje11    	numeric(16,4)	NULL	,
	xsje12    	numeric(16,4)	NULL	,
	jtzz      	varchar(80)	NULL	,
	tel       	varchar(40)	NULL	,
	bz        	varchar(254)	NULL	,
	dt1       	smalldatetime	NULL	,
	dt2       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	str3      	varchar(40)	NULL	,
	str4      	varchar(40)	NULL	,
	code      	varchar(12)	NULL	,
	name      	varchar(30)	NULL	,
	ncye_j    	numeric(16,4)	NULL	,
	ncye_s    	numeric(16,4)	NULL	,
	xsje      	numeric(16,4)	NULL	,
	xssl      	numeric(18,6)	NULL	,
	xssl1     	numeric(18,6)	NULL	,
	xssl2     	numeric(18,6)	NULL	,
	xssl3     	numeric(18,6)	NULL	,
	xssl4     	numeric(18,6)	NULL	,
	xssl5     	numeric(18,6)	NULL	,
	xssl6     	numeric(18,6)	NULL	,
	xssl7     	numeric(18,6)	NULL	,
	xssl8     	numeric(18,6)	NULL	,
	xssl9     	numeric(18,6)	NULL	,
	xssl10    	numeric(18,6)	NULL	,
	xssl11    	numeric(18,6)	NULL	,
	xssl12    	numeric(18,6)	NULL	,
	isend     	varchar(10)	NULL	,
	xb        	tinyint	NULL	,
	age       	tinyint	NULL	,
	nation    	varchar(20)	NULL	,
	whcd      	varchar(20)	NULL	,
CONSTRAINT emp_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_emphw (
	id        	numeric(16,4)	   NOT NULL,
	empid     	numeric(16,4)	   NULl,
	hwcode    	varchar(20)	NULL	,
	hwname    	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	hwdw      	varchar(6)	NULL	,
	ncye_j    	numeric(16,4)	NULL	,
	ncye_s    	numeric(16,4)	NULL	,
	xsje      	numeric(16,4)	NULL	,
	xsje1     	numeric(16,4)	NULL	,
	xsje2     	numeric(16,4)	NULL	,
	xsje3     	numeric(16,4)	NULL	,
	xsje4     	numeric(16,4)	NULL	,
	xsje5     	numeric(16,4)	NULL	,
	xsje6     	numeric(16,4)	NULL	,
	xsje7     	numeric(16,4)	NULL	,
	xsje8     	numeric(16,4)	NULL	,
	xsje9     	numeric(16,4)	NULL	,
	xsje10    	numeric(16,4)	NULL	,
	xsje11    	numeric(16,4)	NULL	,
	xsje12    	numeric(16,4)	NULL	,
	xssl      	numeric(18,6)	NULL	,
	xssl1     	numeric(18,6)	NULL	,
	xssl2     	numeric(18,6)	NULL	,
	xssl3     	numeric(18,6)	NULL	,
	xssl4     	numeric(18,6)	NULL	,
	xssl5     	numeric(18,6)	NULL	,
	xssl6     	numeric(18,6)	NULL	,
	xssl7     	numeric(18,6)	NULL	,
	xssl8     	numeric(18,6)	NULL	,
	xssl9     	numeric(18,6)	NULL	,
	xssl10    	numeric(18,6)	NULL	,
	xssl11    	numeric(18,6)	NULL	,
	xssl12    	numeric(18,6)	NULL	,
CONSTRAINT emphw_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_empn (
	id        	int	NOT NULL	,
	mon       	int	NULL	,
	p_sl      	numeric(18,6)	NULL	,
	f_sl      	numeric(18,6)	NULL	,
	p_je      	numeric(16,4)	NULL	,
	f_je      	numeric(16,4)	NULL	,
CONSTRAINT empn_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_empdc (
	id        	int	NOT NULL	,
	use_      	int	NULL	,
	emp       	varchar(20)	NULL	,
	czy       	int	NULL	,
	czy_name  	varchar(20)	NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	dqmc      	varchar(20)	NULL	,
	dwmc      	varchar(60)	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	dt1       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
CONSTRAINT empdc_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.secuser (
	id        	numeric(16,4)	NOT NULL	,
	name      	varchar(10)	NULL	,
	pwd       	varchar(254)	NULL	,
	grant_    	tinyint	NULL	,
CONSTRAINT suser_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.secur (
	id        	int	NOT NULL	,
	userid    	int	NULL	,
	rightid   	int	NULL	,
CONSTRAINT secur_x Primary KEY NONCLUSTERED  (id)
);

CREATE TABLE dbo.secright (
	id        	numeric(16,4)	NOT NULL	,
	label     	int	NULL	,
	right_    	varchar(20)	NULL	,
	fun_text  	varchar(30)	NULL	,
	op        	varchar(10)	NULL	,
	op_text   	varchar(20)	NULL	,
CONSTRAINT sright_x Primary KEY NONCLUSTERED  (id)
);

CREATE TABLE dbo.xs_pz
(id	int	NOT NULL,
 jzbz tinyint NULL,
 pzrq smalldatetime NULL,
 pzlx char(1) NULL,
 pzh	char(4) NULL,
 fj	smallint NULL,
 zy	varchar(30) NULL,
 kmdm varchar(20) NULL,
 j		numeric(16,4) NULL,
 d		numeric(16,4) NULL,
 zphjsdjh varchar(5) NULL,
 shy	varchar(8) NULL,
 zdy	varchar(8) NULL,
 czy	varchar(8) NULL,
 shbz tinyint NULL,
 wbje numeric(16,4) NULL,
 hl	numeric(16,4) NULL,
 dqh	varchar(4) NULL,
 gg	varchar(30) NULL,
 sl	numeric(18,6) NULL,
 dj    numeric(16,6) NULL,
 dwdm varchar(4) NULL,
 lxr	varchar(8) NULL,
 jsr 	varchar(8) NULL,
 bmry varchar(8) NULL,
CONSTRAINT xspz_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.xs_info (
	jsection  	varchar(20)	NOT NULL	,
	jkey      	varchar(20)	NOT NULL	,
	jvalue    	varchar(128)	NULL	,
CONSTRAINT info_x	Primary KEY NONCLUSTERED (jsection,jkey)
);

CREATE TABLE dbo.x_bz (
	id        	numeric(16,4)	NOT NULL	,
	jtext     	varchar(254)	NULL	,
CONSTRAINT bz_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_xsfy (
	id        	int	NOT NULL	,
	pjh       	varchar(20)	NULL	,
	rq        	smalldatetime	NULL	,
	emp       	varchar(20)	NULL	,
	djr       	varchar(20)	NULL	,
	htdm      	varchar(20)	NULL	,
	dqh       	varchar(4)	NULL	,
	dwdm      	varchar(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwmc      	varchar(60)	NULL	,
	ckdm      	varchar(10)	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(10)	NULL	,
	dfry      	varchar(10)	NULL	,
	dd        	varchar(80)	NULL	,
	start_rq  	smalldatetime	NULL	,
	end_rq    	smalldatetime	NULL	,
	aim       	varchar(100)	NULL	,
	zsf       	numeric(16,4)	NULL	,
	jtf       	numeric(16,4)	NULL	,
	tzjtf     	numeric(16,4)	NULL	,
	ddjtf     	numeric(16,4)	NULL	,
	txf       	numeric(16,4)	NULL	,
	ysf       	numeric(16,4)	NULL	,
	zfy       	numeric(16,4)	NULL	,
	bz        	varchar(254)	NULL	,
	zt        	int	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	d3        	numeric(16,4)	NULL	,
	d4        	numeric(16,4)	NULL	,
	d5        	numeric(16,4)	NULL	,
	d6        	numeric(16,4)	NULL	,
	dt1       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
CONSTRAINT xsfy_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_jsfs (
	bh        	tinyint	NOT NULL	,
	jsfs      	varchar(10)	NULL	,
CONSTRAINT jsfs_x	Primary KEY NONCLUSTERED (bh)
);

CREATE TABLE dbo.x_hx (
	id        	int	NOT NULL	,
	hxh       	varchar(16)	NULL	,
	hxrq      	smalldatetime	NULL	,
	lry       	varchar(12)	NULL	,
	fph       	varchar(16)	NULL	,
	fprq      	smalldatetime	NULL	,
	fphwid    	int	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(60)	NULL	,
	hwgg			varchar(50) NULL,
	skh       	varchar(16)	NULL	,
	skrq      	smalldatetime	NULL	,
	emp       	varchar(16)	NULL	,
	dqh       	varchar(4)	NULL	,
	dwdm      	varchar(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	hxje      	numeric(16,4)	NULL	,
	hxsl      	numeric(18,6)	NULL	,
	jj_1      	numeric(16,4)	NULL	,
	jj_2      	numeric(16,4)	NULL	,
	jj_3      	numeric(16,4)	NULL	,
	zt        	int	NULL	,
CONSTRAINT hx_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_khyh (
	id        	int	NOT NULL	,
	yhdm			varchar(20) NULL,
	khyh      	varchar(60)	NULL	,
	zh        	varchar(30)	NULL	,
   kmdm			varchar(20) NULL,
CONSTRAINT khyh_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_level (
	id        	numeric(16,4)	NOT NULL	,
	itemid    	numeric(16,4)	NULL	,
	levelnum  	int	NULL	,
	levelbytes	int	NULL	,
CONSTRAINT level_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_lvbase (
	id        	numeric(16,4)	NOT NULL	,
	item      	varchar(30)	NULL	,
	maxbytes  	int	NULL	,
	maxlevel  	int	NULL	,
	jcomment  	varchar(120)	NULL	,
	item_lab  	varchar(10)	NULL	,
CONSTRAINT lvbase_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_wlys (
	emp       	varchar(14)	NOT NULL	,
	dqh       	varchar(4)	NOT NULL	,
	dwdm      	varchar(4)	NOT NULL	,
	dqmc      	varchar(10)	NULL	,
	dwmc      	varchar(60)	NULL	,
	ncysye    	numeric(16,4)	NULL	,
	ysje      	numeric(16,4)	NULL	,
	skje      	numeric(16,4)	NULL	,
	yhxje     	numeric(16,4)	NULL	,
	bchxje    	numeric(16,4)	NULL	,
 	ysfhje numeric(16,4)	NULL	,
	yshtje	numeric(16,4)	NULL	,
	def_num1 numeric(16,4)	NULL	,
	def_num2 numeric(16,4)	NULL	,
	def_int1 int	null,
	def_int2 int	null,
	def_str1 varchar(30)	NULL	,
	def_str2 varchar(30)	NULL	,
CONSTRAINT wlys_x	Primary KEY NONCLUSTERED (emp,dqh,dwdm)
);

CREATE TABLE dbo.x_wlysc (
	id        	int	NOT NULL	,
	dqh       	char(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwdm      	char(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	lastye    	numeric(16,4)	NULL	,
	ys        	numeric(16,4)	NULL	,
	sk        	numeric(16,4)	NULL	,
	mon       	smallint	NULL	,
	emp       	varchar(14)	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	htdm      	varchar(30)	NULL	,
CONSTRAINT wlysc_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_wlysd (
	id        	int	NOT NULL	,
	mon       	int	NULL	,
	ys        	numeric(16,4)	NULL	,
	sk        	numeric(16,4)	NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
CONSTRAINT wlysd_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_wlysdw (
	id        	int	NOT NULL	,
	dqh       	char(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwdm      	char(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	lastye    	numeric(16,4)	NULL	,
	ys        	numeric(16,4)	NULL	,
	sk        	numeric(16,4)	NULL	,
	mon       	smallint	NULL	,
	emp       	varchar(14)	NULL	,
	htdm      	varchar(30)	NULL	,
	zke       	numeric(16,4)	NULL	,
CONSTRAINT wlysdw_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_carry (
	id        	smallint	NOT NULL	,
	jcarry    	varchar(15)	NULL	,
CONSTRAINT carry_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_khxydj (
	id        	int	NOT NULL	,
	class_    	int	NULL	,
	dz1       	numeric(16,4)	NULL	,
	dz2       	numeric(16,4)	NULL	,
	xyts      	int	NULL	,
	scroe     	float(4)	NULL	,
	sxl       	float(4)	NULL	,
	bz        	varchar(254)	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	dt1       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
CONSTRAINT khxydj_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_khda (
	dqh       	char(4)	NOT NULL	,
	dwdm      	char(4)	NOT NULL	,
	qyxz      	varchar(30)	NULL	,
	zczj      	numeric(16,4)	NULL	,
	jzc       	numeric(16,4)	NULL	,
	zzc       	numeric(16,4)	NULL	,
	ssslyye   	numeric(16,4)	NULL	,
	sslyye    	numeric(16,4)	NULL	,
	slyye     	numeric(16,4)	NULL	,
	ssslyysr  	numeric(16,4)	NULL	,
	sslyysr   	numeric(16,4)	NULL	,
	slyysr    	numeric(16,4)	NULL	,
	slyskzzl  	numeric(16,4)	NULL	,
	emp       	int	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	dt1       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	fldm			smallint NULL,
	skkm			varchar(20) NULL,
	fptype		smallint NULL,
CONSTRAINT khda_x	Primary KEY NONCLUSTERED (dqh,dwdm)
);

CREATE TABLE dbo.x_xydj (
	id        	int	NOT NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	rq        	smalldatetime	NULL	,
	xydj      	int	NULL	,
	sxje      	numeric(16,4)	NULL	,
	hzfx      	numeric(16,4)	NULL	,
	ljyszkl   	numeric(16,4)	NULL	,
	d1        	numeric(16,4)	NULL	,
	d2        	numeric(16,4)	NULL	,
	dt1       	smalldatetime	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	fldm		smallint	NULL	,
	htje			numeric(16,4) NULL,
	fpje			numeric(16,4) NULL,
	fhje			numeric(16,4) NULL,
	skje 			numeric(16,4) NULL,
   qchtje			numeric(16,4) NULL,
	qcfpje			numeric(16,4) NULL,
	qcfhje			numeric(16,4) NULL,
	qcskje 			numeric(16,4) NULL,
CONSTRAINT xydj_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_xjzk (
	id        	int	NOT NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	hkts1     	int	NULL	,
	hkts2     	int	NULL	,
	zkl       	numeric(16,4)	NULL	,
CONSTRAINT xjzk_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_jjkx (
	id        	int	NOT NULL	,
	kxbh      	varchar(4)	NULL	,
	kxmc      	varchar(16)	NULL	,
	kxdesc    	varchar(255)	NULL	,
	kxsm      	varchar(255)	NULL	,
CONSTRAINT jjkx_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_dwdq (
	dqh       	varchar(4)	NOT NULL	,
	dqmc      	varchar(10)	NULL	,
CONSTRAINT dwdq_x	Primary KEY NONCLUSTERED (dqh)
);

CREATE TABLE dbo.x_dwtx (
	dqh       	char(4)	NOT NULL	,
	dqmc      	varchar(8)	NULL	,
	dwdm      	char(4)	NOT NULL	,
	dwmc      	varchar(60)	NULL	,
	addr      	varchar(60)	NULL	,
	zp        	varchar(6)	NULL	,
	tel       	varchar(20)	NULL	,
	fax       	varchar(20)	NULL	,
	frdb      	varchar(8)	NULL	,
	zh        	varchar(30)	NULL	,
	khh       	varchar(60)	NULL	,
	scbz      	tinyint	NULL	,
	nsrdjh    	varchar(30)	NULL	,
	pydm_     	varchar(10)	NULL	,
CONSTRAINT dwtx_x	Primary KEY NONCLUSTERED (dqh,dwdm)
);

CREATE TABLE dbo.x_ftdy	(
	id		int		NOT NULL,
	fpid		int		NULL	,
	thid		int		NULL	,
	mxid		int		NULL	,
	pjlx		tinyint		NULL	,
	hwdm		varchar(20)	NULL	,
	jldw		varchar(6)	NULL	,
	sl		numeric(18,6)		NULL	,
	je		numeric(16,4)		NULL	,
	sysl		numeric(18,6)		NULL	,
	syje		numeric(16,4)		NULL	,
	bz		char(1)		NULL	,
CONSTRAINT ftdy_x	Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_khfl	(
	fldm		smallint 	NOT NULL,
	flmc		varchar(20) 	NULL	,
	sftj		char(1) 	NULL	,
	tjxh		smallint 	NULL	,
	ms		varchar(100) 	NULL	,
CONSTRAINT khfl_x	Primary KEY NONCLUSTERED (fldm)
);

CREATE TABLE dbo.x_wb
(
dm varchar(4) NOT NULL,
mc varchar(20) NULL,
rate numeric(16,4) NULL,
CONSTRAINT wb_x Primary KEY NONCLUSTERED  (dm)
);

CREATE TABLE dbo.x_slzk
(
	id		int		NOT NULL,
	dqh	varchar(4)	NULL,
	dqmc	varchar(10)	NULL,
	dwdm	varchar(4)	NULL,
	dwmc	varchar(60)	NULL,
	hwdm	varchar(20)	NULL,
	hwmc	varchar(60)	NULL,
	sl		numeric(18,6)		NULL,	
	zkl	numeric(16,4)		NULL,
	style	smallint		NULL,
CONSTRAINT slzk_x Primary Key NONCLUSTERED(id)
);

CREATE TABLE dbo.x_skmx
 (
	id		int		NOT NULL,
	skid	int		NULL,	
	dddm	varchar(30)	NULL,
	pjh	varchar(30)	NULL,
	hxje	numeric(16,4)		NULL,
	rq		smalldatetime	NULL,
	chlje numeric(16,4)		NULL,
	bchxje numeric(16,4)	NULL,
CONSTRAINT skmx_x Primary Key NONCLUSTERED(id)
);

CREATE TABLE dbo.x_lsddcs 
(
	id		int		NOT NULL,
	lsddh	varchar(30)	NULL,
	emp   varchar(14)	NULL	,
	dqh   varchar(4)	NULL	,
	dwdm  varchar(4)	NULL	,
	dqmc  varchar(10)	NULL	,
	dwmc  varchar(60)	NULL	,
	ysje  numeric(16,4) NULL	,
	kpje  numeric(16,4) NULL	,
	skje  numeric(16,4) NULL	,
	hxje  numeric(16,4) NULL,
	bchx  numeric(16,4) NULL,
	hxbz tinyint NULL,
	fpje  numeric(16,4) NULL	,
	fhje  numeric(16,4) NULL	,
	ysfpje  numeric(16,4) NULL	,
	ysfhje  numeric(16,4) NULL	,
	yshtje  numeric(16,4) NULL	,
	htbz tinyint NULL,
	def_num1  numeric(16,4) NULL,
	def_num2  numeric(16,4) NULL,
	def_int1 integer NULL,
	def_int2 integer NULL,
	def_str1  varchar(30)	NULL	,
	def_str2  varchar(30)	NULL	,
CONSTRAINT lsddcs_x Primary Key NONCLUSTERED(id)
);

CREATE TABLE dbo.x_yjbb
(
	id			int NOT NULL,
	title		varchar(30) NULL,
	filetype	char(2) NULL,
	mon		tinyint NULL,
	bmdm		varchar(14) NULL,
	ownrtype	tinyint NULL,
	owner		varchar(14) NULL,
	fmt		image NULL,
	CONSTRAINT yjbb_x Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.x_temp
(
thdh		varchar(16)		NOT NULL,
fph		varchar(16)		NOT NULL,
hwdm		varchar(20)		NOT NULL,
mxid		integer			NULL,
sl			numeric(18,6)			NULL,
bz			tinyint			NULL,
lx			tinyint			NULL,
CONSTRAINT temp_x Primary Key NONCLUSTERED (thdh,fph,hwdm)
);

CREATE TABLE dbo.x_tempcp
(
id              integer   NOT NULL,
thdh		varchar(16)		NOT NULL,
fph		varchar(16)		NOT NULL,
hwdm		varchar(20)		NOT NULL,
mxid		integer			NULL,
sl			numeric(18,6)			NULL,
bz			tinyint			NULL,
lx			tinyint			NULL,
CONSTRAINT tempcp_x Primary Key NONCLUSTERED (thdh,fph,hwdm,id)
);

CREATE TABLE dbo.x_fpch(
	id int NOT NULL,
	hzfpid int NULL,
	hzfph varchar(16) NULL,
	lzfpid int NULL,
	lzfph varchar(16) NULL,
	hwdm varchar(20) NULL,
	sl  numeric(16,6) NULL,
	je numeric(16,4) NULL,
	se numeric(16,4) NULL,
CONSTRAINT fpch_x primary key NONCLUSTERED (id) );

CREATE TABLE x_qzhx (
	skid1 int NOT NULL,
	skid2 int NOT NULL,
	je numeric(16,4) NULL,
CONSTRAINT qzhx_x primary key NONCLUSTERED(skid1,skid2) );

CREATE TABLE x_dfcx (
	id int NOT NULL,
	skid int NULL,
	fpid int NULL,
	fphwid int NULL,
	je numeric(16,4) NULL,
	rq smalldatetime NULL,
CONSTRAINT dfcx_x PRIMARY KEY NONCLUSTERED(id)
);

CREATE TABLE x_disc(
	id		int	NOT NULL,
	dqh		char(4)	NULL,
	dqmc		varchar(8)	NULL,
	dwdm		char(4)	NULL,
	dwmc		varchar(60)	NULL,
	cg_date	smalldatetime	NULL,
	pre_disc	numeric(16,4)	NULL,
	cg_point	numeric(16,4)	NULL,
	cur_disc	numeric(16,4)	NULL,
	pf_flag	tinyint	NULL,
	marks		varchar(60) NULL,
CONSTRAINT disc_x primary key NONCLUSTERED(id)
);

DROP INDEX x_ht.x_ht_htdm;
DROP INDEX x_ht.x_ht_qdrq;
DROP INDEX x_ht.x_ht_dw;
DROP INDEX x_ht.x_ht_gfdlr;
CREATE INDEX x_ht_htdm ON dbo.x_ht(htdm);
CREATE INDEX x_ht_qdrq ON dbo.x_ht(qdrq);
CREATE INDEX x_ht_dw ON dbo.x_ht(xfdq,xfdm);
CREATE INDEX x_ht_gfdlr ON dbo.x_ht(gfdlr);

DROP INDEX x_hthw.x_hthw_htid;
DROP INDEX x_hthw.x_hthw_hwdm;
CREATE INDEX x_hthw_htid ON dbo.x_hthw(htid);
CREATE INDEX x_hthw_hwdm ON dbo.x_hthw(hwdm);

DROP INDEX x_fh.x_fh_rq;
DROP INDEX x_fh.x_fh_dw;
DROP INDEX x_fh.x_fh_bmdm;
DROP INDEX x_fh.x_fh_htdm;
CREATE INDEX x_fh_rq ON dbo.x_fh(rq);
CREATE INDEX x_fh_dw ON dbo.x_fh(dqh,dwdm);
CREATE INDEX x_fh_bmdm ON dbo.x_fh(bmdm);
CREATE INDEX x_fh_htdm ON dbo.x_fh(htdm);

DROP INDEX x_fhhw.x_fhhw_fhid;
DROP INDEX x_fhhw.x_fhhw_hwdm;
CREATE INDEX x_fhhw_fhid ON dbo.x_fhhw(fhid);
CREATE INDEX x_fhhw_hwdm ON dbo.x_fhhw(hwdm);

DROP INDEX x_fp.x_fp_rq;
DROP INDEX x_fp.x_fp_dw;
DROP INDEX x_fp.x_fp_emp;
DROP INDEX x_fp.x_fp_htdm;
CREATE INDEX x_fp_rq ON dbo.x_fp(rq);
CREATE INDEX x_fp_dw ON dbo.x_fp(dqh,dwdm);
CREATE INDEX x_fp_emp ON dbo.x_fp(emp);
CREATE INDEX x_fp_htdm ON dbo.x_fp(htdm);

DROP INDEX x_fphw.x_fphw_fpid;
DROP INDEX x_fphw.x_fphw_hwdm;
CREATE INDEX x_fphw_fpid ON dbo.x_fphw(fpid);
CREATE INDEX x_fphw_hwdm ON dbo.x_fphw(hwdm);

DROP INDEX x_sk.x_sk_pjh;
DROP INDEX x_sk.x_sk_dw;
DROP INDEX x_sk.x_sk_emp;
DROP INDEX x_sk.x_sk_rq;
CREATE INDEX x_sk_pjh ON dbo.x_sk(pjh);
CREATE INDEX x_sk_dw ON dbo.x_sk(dqh,dwdm);
CREATE INDEX x_sk_emp ON dbo.x_sk(emp);
CREATE INDEX x_sk_rq ON dbo.x_sk(rq);

DROP INDEX x_hx.x_hx_fph;
CREATE INDEX x_hx.x_hx_fph ON dbo.x_hx(fph);

DROP INDEX x_ftdy.x_ftdy_ft;
CREATE INDEX x_ftdy_ft ON dbo.x_ftdy(fpid,thid);

DROP INDEX x_skmx.x_skmx_pjh;
DROP INDEX x_skmx.x_skmx_skid;
DROP INDEX x_skmx.x_skmx_dddm;
CREATE INDEX x_skmx_pjh ON dbo.x_skmx(pjh);
CREATE INDEX x_skmx_skid ON dbo.x_skmx(skid);
CREATE INDEX x_skmx_dddm ON dbo.x_skmx(dddm);

DROP INDEX x_dfcx.x_dfcx_skid;
DROP INDEX x_dfcx.x_dfcx_fpid;
CREATE INDEX x_dfcx_skid ON x_dfcx(skid);
CREATE INDEX x_dfcx_fpid ON x_dfcx(fpid);

DROP INDEX x_disc.x_disc_dw;
DROP INDEX x_disc.x_disc_flag;
CREATE INDEX x_disc_dw ON x_disc (dqh,dwdm);
CREATE INDEX x_disc_flag ON x_disc (pf_flag);
