CREATE TABLE "X_HTCL"
(
 ID NUMBER(5,0) NOT NULL,
 JCLASS VARCHAR2(20)
);
ALTER TABLE "X_HTCL"	ADD ( CONSTRAINT htcl_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_HT"
(
 ID NUMBER(12,0) NOT NULL,
 KPR  VARCHAR2(10),
 ISSTOP NUMBER(2,0),
 XFDQMC VARCHAR2(10),
 HTDM VARCHAR2(30),
 XFDQ VARCHAR2(4),
 XFDM VARCHAR2(4),
 XFMC VARCHAR2(60),
 XFDZ VARCHAR2(60),
 XFFR VARCHAR2(10),
 XFDLR VARCHAR2(10),
 XFDH VARCHAR2(20),
 XFKHYH VARCHAR2(60),
 XFKHYM VARCHAR2(10),
 XFZH VARCHAR2(30),
 XFYB VARCHAR2(10),
 XFSH VARCHAR2(30),
 GFDM VARCHAR2(4),
 GFMC VARCHAR2(60),
 GFDZ VARCHAR2(60),
 GFFR VARCHAR2(10),
 GFDLR VARCHAR2(14),
 GFDH VARCHAR2(20),
 GFKHYH VARCHAR2(60),
 GFKHYM VARCHAR2(10),
 GFZH VARCHAR2(30),
 GFYB VARCHAR2(10),
 GFSH VARCHAR2(30),
 QDDD VARCHAR2(30),
 QDRQ DATE,
 BZ VARCHAR2(254),
 SXRQ DATE,
 ZZRQ DATE,
 ZT NUMBER(5,0),
 JCLASS NUMBER(5,0),
 JE NUMBER(16,4),
 SKJE NUMBER(16,4),
 WBJE NUMBER(16,4),
 WBFH VARCHAR2(4),
 WBRATE NUMBER(16,4),
 ZKJE NUMBER(16,4),
 HXJE NUMBER(16,4),
 BCHX NUMBER(16,4),
 HXBZ NUMBER(2,0),
 YEARBZ VARCHAR2(4)
);
ALTER TABLE "X_HT"		ADD ( CONSTRAINT ht_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_HTHW"
(
 ID NUMBER(12,0) NOT NULL,
 SK_JE NUMBER(16,4), 
 FH_SL NUMBER(18,6), 
 HTDM VARCHAR2(30),
 HTCL NUMBER(5,0),
 HTID NUMBER(12,0),
 RQ DATE,
 HWDM VARCHAR2(20),
 HWSL NUMBER(18,6),
 HWDJ NUMBER(16,6),
 JE NUMBER(16,4),
 HWMC VARCHAR2(50),
 HWGG VARCHAR2(50),
 SLDW VARCHAR2(10),
 FP_SL NUMBER(18,6),
 FP_JE NUMBER(16,4),
 XS_DJE1  NUMBER(16,6) ,
 XS_DJE2  NUMBER(16,6) ,
 XS_DJE3  NUMBER(16,6) ,
 XS_DJE4  NUMBER(16,6) ,
 ZKL  NUMBER(16,4) ,
 ZKE  NUMBER(16,4),
 CKDM  VARCHAR2(4),
 KMDM VARCHAR2(20),
 WBJE NUMBER(16,4),
 SLU	NUMBER(16,4),
 HSDJ	NUMBER(16,6),
 FH_JE	NUMBER(16,4),
 TH_SL	NUMBER(18,6),
 TH_JE	NUMBER(16,4),
 CH_SL	NUMBER(18,6),
 CH_JE	NUMBER(16,4),
 SK_SL	NUMBER(18,6),
 YHXJE NUMBER(16,4) ,
 BCHXJE NUMBER(16,4) ,
 YHXSL NUMBER(18,6) ,
 BCHXSL NUMBER(18,6) ,
 ISHX NUMBER(5,0)
);
ALTER TABLE "X_HTHW"		ADD ( CONSTRAINT hthw_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_HTZK"
(
 HTID  NUMBER(12,0) NOT NULL ,
 RQ    DATE ,
 JE    NUMBER(16,4),
 BZ    VARCHAR2(254) ,
 DT1   DATE   ,
 DT2   DATE  ,
 D1    NUMBER(16,4),
 D2    NUMBER(16,4),
 STR1  VARCHAR2(40) ,
 STR2 VARCHAR2(40)
);
ALTER TABLE "X_HTZK"		ADD ( CONSTRAINT htzk_x	PRIMARY KEY ("HTID"));

CREATE TABLE "X_FH"
(
 ID NUMBER(12,0) NOT NULL,
 WLDW VARCHAR2(60),
 BMDM VARCHAR2(9),
 KPR VARCHAR2(10),
 ZT NUMBER(5,0),
 PWD VARCHAR2(10),
 THR VARCHAR2(10),
 CKDM VARCHAR2(2),
 STARTRQ DATE,
 ENDRQ DATE,
 DQH VARCHAR2(10),
 DQMC VARCHAR2(10),
 FPH VARCHAR2(10),
 STYLE NUMBER(5,0),
 BZ VARCHAR2(254),
 USED NUMBER(5,0),
 JCARRY NUMBER(5,0),
 USER01  VARCHAR2(20),
 PJH VARCHAR2(16),
 RQ DATE,
 HTDM VARCHAR2(30),
 JCLASS NUMBER(5,0),
 DWDM VARCHAR2(10),
 ISKP NUMBER(5,0),
 JE NUMBER(16,4),
 ZKJE  NUMBER(16,4),
 HXJE  NUMBER(16,4),
 BCHX  NUMBER(16,4),
 HXBZ  NUMBER(2,0),
 LX	NUMBER(2,0),
 ISZF	NUMBER(2,0),
 FROMXJ NUMBER(5,0),
 HTID	NUMBER(12,0),
 YEARBZ VARCHAR2(4)
);
ALTER TABLE "X_FH"		ADD ( CONSTRAINT fh_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_FHHW"
(
 ID NUMBER(12,0) NOT NULL,
 FHID NUMBER(12,0),
 HWDM VARCHAR2(20),
 HWMC VARCHAR2(50),
 SLDW VARCHAR2(6),
 SL NUMBER(18,6),
 HWGG VARCHAR2(50),
 SFSL NUMBER(18,6),
 CKDM VARCHAR2(2),
 HTDM VARCHAR2(30),
 KMDM VARCHAR2(20),
 DJ NUMBER(16,6) ,
 XS_DJ1 NUMBER(16,6) ,
 XS_DJ2 NUMBER(16,6) ,
 XS_DJ3 NUMBER(16,6) ,
 XS_DJ4 NUMBER(16,6) ,
 PH    VARCHAR2(40),
 YKSL NUMBER(18,6),
 YKJE NUMBER(16,4),
 ZKL  NUMBER(16,4),
 ZKE  NUMBER(16,4),
 BZ	VARCHAR2(254),
 SLU	NUMBER(16,4),
 HSDJ	NUMBER(16,6),
 FP_JE	NUMBER(16,4),
 FP_SL	NUMBER(18,6),
 HTID		NUMBER(12,0),
 TH_SL	NUMBER(18,6),
 TH_JE	NUMBER(16,4),
 YHXJE NUMBER(16,4) ,
 BCHXJE NUMBER(16,4) ,
 YHXSL NUMBER(18,6) ,
 BCHXSL NUMBER(18,6) ,
 ISHX NUMBER(5,0)
);
ALTER TABLE "X_FHHW"		ADD ( CONSTRAINT fhhw_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_FP"
(
 ID NUMBER(12,0) NOT NULL,
 FPH VARCHAR2(16),
 RQ DATE,
 BANK VARCHAR2(60),
 ZH VARCHAR2(30),
 SZ VARCHAR2(8),
 SE NUMBER(16,4),
 JE NUMBER(16,4),
 JSFS NUMBER(5,0),
 JSPJH VARCHAR2(10),
 KPR VARCHAR2(14),
 SHR VARCHAR2(14),
 SKR VARCHAR2(14),
 BZ VARCHAR2(254),
 FPTYPE NUMBER(5,0),
 KMDM VARCHAR2(20),
 HTDM VARCHAR2(30),
 ISZF NUMBER(5,0),
 EMP VARCHAR2(14),
 ZT NUMBER(5,0),
 JZR VARCHAR2(14),
 DQH VARCHAR2(4),
 DQMC VARCHAR2(10),
 DWDM VARCHAR2(4),
 DWMC VARCHAR2(60),
 DWTEL VARCHAR2(20),
 DWZP VARCHAR2(10),
 DWKHH VARCHAR2(60),
 DWZH VARCHAR2(30),
 DWSH VARCHAR2(30),
 DWADDR VARCHAR2(60),
 HTID NUMBER(12,0),
 PZH VARCHAR2(10),
 PZRQ DATE,
 DDFY NUMBER(16,4),
 DDJS NUMBER(12,0),
 DDJSH VARCHAR2(10),
 ISKP NUMBER(5,0),
 ISOK NUMBER(5,0),
 STYLE NUMBER(5,0),
 FHD VARCHAR2(10),
 ISCHECK NUMBER(5,0),
 IsHS NUMBER(5,0),
 HSJE_S NUMBER(16,4),
 HXJE NUMBER(16,4),
 BCHX NUMBER(16,4), 
 HXBZ NUMBER(5,0),
 WBJE NUMBER(16,4),
 WBFH VARCHAR2(4),
 WBRATE NUMBER(16,4),
 ZKJE NUMBER(16,4),
 CHFPYJ VARCHAR2(20),
 ZZSFPH VARCHAR2(20),
 CHJE NUMBER(16,4),
 CHSE NUMBER(16,4),
 FROMXJ NUMBER(5,0),
 istransout NUMBER(5,0),
 YEARBZ VARCHAR2(4)
);
ALTER TABLE "X_FP"		ADD ( CONSTRAINT fp_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_FPHW"
(
 ID NUMBER(12,0) NOT NULL,
 FPID NUMBER(12,0),
 HWDM VARCHAR2(20),
 HWMC VARCHAR2(50),
 HWGG VARCHAR2(50),
 SLDW VARCHAR2(6),
 SL NUMBER(18,6),
 DJ NUMBER(16,6),
 JE NUMBER(16,4),
 SE NUMBER(16,4),
 SLU NUMBER(16,4),
 HTID NUMBER(12,0),
 HTDM VARCHAR2(30),
 MAOLI  NUMBER(16,4),
 YHXJE NUMBER(16,4) ,
 BCHXJE NUMBER(16,4) ,
 YHXSL NUMBER(18,6) ,
 BCHXSL NUMBER(18,6) ,
 XS_DJE1  NUMBER(16,6) ,
 XS_DJE2  NUMBER(16,6) ,
 XS_DJE3  NUMBER(16,6) ,
 XS_DJE4  NUMBER(16,6) ,
 CKDM  VARCHAR2(4),
 KMDM VARCHAR2(20),
 ISHX NUMBER(5,0),
 YKSL NUMBER(18,6),
 YKJE NUMBER(16,4),
 WBJE NUMBER(16,4),
 ZKL  NUMBER(16,4),
 ZKE  NUMBER(16,4),
 HSDJ	NUMBER(16,6),
 CHJE NUMBER(16,4),
 CHSE NUMBER(16,4),
 CHSL NUMBER(18,6),
 FH_JE	NUMBER(16,4),
 FH_SL	NUMBER(18,6)
);
ALTER TABLE "X_FPHW"		ADD ( CONSTRAINT fphw_x		PRIMARY KEY ("ID"));


CREATE TABLE "X_FPTY"
(
 ID NUMBER(10,0) NOT NULL,
 FPTYPE VARCHAR2(30),
 JROWS NUMBER(12,0),
 BOOK NUMBER(10,0) ,
 TPFILE VARCHAR2(12),
 WIDTH NUMBER(16,4),
 HEIGHT NUMBER(16,4),
 HMGRP NUMBER(16,4),
 LIMIT NUMBER(16,4),
 HMNOW VARCHAR2(16),
 HMLEN NUMBER(12,0),
 SL NUMBER(16,4),
 ISSP NUMBER(5,0),
 HMSTART VARCHAR2(16),
 HMEND VARCHAR2(16),
 ZFS	NUMBER(12,0),
 CHS	NUMBER(12,0),
 ISEND NUMBER(5,0)
);
ALTER TABLE "X_FPTY"		ADD ( CONSTRAINT fpty_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_FPZT"
(
 ID NUMBER(5,0) NOT NULL,
 FPZT VARCHAR2(10)
);
ALTER TABLE "X_FPZT"		ADD ( CONSTRAINT fpzt_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_SK"
(
 ID NUMBER(12,0) NOT NULL,
 HTDM VARCHAR2(30),
 DWDM VARCHAR2(10),
 WLDW VARCHAR2(60),
 JE NUMBER(16,4),
 JSFS NUMBER(12,0),
 JSPJH VARCHAR2(10),
 SKR VARCHAR2(10),
 SHR VARCHAR2(10),
 BZ VARCHAR2(254),
 FKR VARCHAR2(10),
 YHXJE NUMBER(16,4),
 ISHX NUMBER(5,0),
 FPH VARCHAR2(20),
 JE1  NUMBER(16,4),
 JE2  NUMBER(16,4),
 JE3  NUMBER(16,4),
 JE4  NUMBER(16,4),
 JE5  NUMBER(16,4),
 JE6  NUMBER(16,4),
 JE7  NUMBER(16,4),
 JE8  NUMBER(16,4),
 JE9  NUMBER(16,4),
 JE10  NUMBER(16,4),
 JE11  NUMBER(16,4),
 JE12  NUMBER(16,4),
 JE13  NUMBER(16,4),
 JE14  NUMBER(16,4),
 JE15  NUMBER(16,4),
 CONBH VARCHAR2(10),
 JHKM VARCHAR2(20),
 KMDM VARCHAR2(20),
 SL NUMBER(18,6),
 DJ NUMBER(16,6),
 HWDM VARCHAR2(12),
 HWMC VARCHAR2(30),
 HWGG VARCHAR2(30),
 ZT NUMBER(5,0),
 JCLASS NUMBER(5,0),
 DQH VARCHAR2(4),
 DQMC VARCHAR2(10),
 EMP VARCHAR2(14),
 ISCHECK NUMBER(5,0),
 ZKL   NUMBER(16,4),
 ZKE   NUMBER(16,4),
 HXJE  NUMBER(16,4),
 PZH VARCHAR2(4),
 FHD  VARCHAR2(20) ,
 ISHS NUMBER(5,0),
 HSJE_S NUMBER(16,4),
 PJH VARCHAR2(16),
 RQ DATE,
 SHRQ DATE,
 WBJE NUMBER(16,4),
 WBFH VARCHAR2(4),
 WBRATE NUMBER(16,4),
 TKJE NUMBER(16,4),
 FROMXJ NUMBER(5,0),
 FROMDD NUMBER(5,0)
);
ALTER TABLE "X_SK"		ADD ( CONSTRAINT sk_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_SKCLS"
(
 ID NUMBER(5,0) NOT NULL,
 JCLASS VARCHAR2(10)
);
ALTER TABLE "X_SKCLS"		ADD ( CONSTRAINT skxls_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_SKHX"
(
 HTID    NUMBER(12,0) NOT NULL,
 SKID    NUMBER(12,0) NOT NULL,
 FPID    NUMBER(12,0) NOT NULL,
 HXJE   NUMBER(16,4)  ,
 BZ      VARCHAR2(254)  ,
 DT1    DATE   ,
 DT2    DATE  ,
 D1     NUMBER(16,4) ,
 D2     NUMBER(16,4)  ,
 STR1  VARCHAR2(40) ,
 STR2 VARCHAR2(40)
);
ALTER TABLE "X_SKHX"		ADD ( CONSTRAINT skhx_x		PRIMARY KEY ("HTID","SKID","FPID"));

CREATE TABLE "X_SKHXMX"
(
 HTID  NUMBER(12,0) NOT NULL,
 FPID  NUMBER(12,0) NOT NULL,
 HWDM   VARCHAR2(20) NOT NULL,
 YHXJE   NUMBER(16,4) ,
 BCHXJE  NUMBER(16,4) ,
 BZ    VARCHAR2(254) ,
 DT1    DATE   ,
 DT2    DATE  ,
 D1     NUMBER(16,4) ,
 D2     NUMBER(16,4)  ,
 STR1  VARCHAR2(40) ,
 STR2 VARCHAR2(40)
);
ALTER TABLE "X_SKHXMX"		ADD ( CONSTRAINT skhxmx_x		PRIMARY KEY ("HTID","FPID","HWDM"));

CREATE TABLE "X_SKPZMB"
(
 ID		NUMBER(12,0) NOT NULL,
 ZY		VARCHAR2(40)	,
 KMDM		VARCHAR2(20)	,
 J_D		VARCHAR2(4)	,
 JE		VARCHAR2(40) ,
 D1      NUMBER(16,4)  , 
 D2      NUMBER(16,4)  ,
 DT1     DATE ,
 STR1    VARCHAR2(40) ,
 STR2    VARCHAR2(40)
);
ALTER TABLE "X_SKPZMB"		ADD ( CONSTRAINT skpzmb_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_XSJH"
(
	EMP		VARCHAR2(20) NOT NULL,
	ISLB		NUMBER(2,0)	,
	FTBL		NUMBER(16,4)	,
	NJH		NUMBER(16,4)	,
	NDE		NUMBER(16,4)	,
	JH1		NUMBER(16,4)	,
	DE1		NUMBER(16,4)	,
	JH2		NUMBER(16,4)	,
	DE2		NUMBER(16,4)	,
	JH3		NUMBER(16,4)	,
	DE3		NUMBER(16,4)	,
	JH4		NUMBER(16,4)	,
	DE4		NUMBER(16,4)	,
	JH5		NUMBER(16,4)	,
	DE5		NUMBER(16,4)	,
	JH6		NUMBER(16,4)	,
	DE6		NUMBER(16,4)	,
	JH7		NUMBER(16,4)	,
	DE7		NUMBER(16,4)	,
	JH8		NUMBER(16,4)	,
	DE8		NUMBER(16,4)	,
	JH9		NUMBER(16,4)	,
	DE9		NUMBER(16,4)	,
	JH10		NUMBER(16,4)	,
	DE10		NUMBER(16,4)	,
	JH11		NUMBER(16,4)	,
	DE11		NUMBER(16,4)	,
	JH12		NUMBER(16,4)	,
	DE12		NUMBER(16,4)	
);
ALTER TABLE "X_XSJH"		ADD ( CONSTRAINT xsjh_x		PRIMARY KEY ("EMP"));

CREATE TABLE "X_HWXSJH"
(
	ID			NUMBER(10,0) NOT NULL,
	EMP		VARCHAR2(20)	,
	HWDM		VARCHAR2(20)	,
	HWGG		VARCHAR2(50)	,
	JLDW		VARCHAR2(6)	,
	FTBL		NUMBER(16,4)	,
	NJH		NUMBER(16,4)	,
	NDE		NUMBER(18,6)	,
	JH1		NUMBER(16,4)	,
	DE1		NUMBER(18,6)	,
	JH2		NUMBER(16,4)	,
	DE2		NUMBER(18,6)	,
	JH3		NUMBER(16,4)	,
	DE3		NUMBER(18,6)	,
	JH4		NUMBER(16,4)	,
	DE4		NUMBER(18,6)	,
	JH5		NUMBER(16,4)	,
	DE5		NUMBER(18,6)	,
	JH6		NUMBER(16,4)	,
	DE6		NUMBER(18,6)	,
	JH7		NUMBER(16,4)	,
	DE7		NUMBER(18,6)	,
	JH8		NUMBER(16,4)	,
	DE8		NUMBER(18,6)	,
	JH9		NUMBER(16,4)	,
	DE9		NUMBER(18,6)	,
	JH10		NUMBER(16,4)	,
	DE10		NUMBER(18,6)	,
	JH11		NUMBER(16,4)	,
	DE11		NUMBER(18,6)	,
	JH12		NUMBER(16,4)	,
	DE12		NUMBER(18,6)	,
	HWMC		VARCHAR2(50) 	
);
ALTER TABLE "X_HWXSJH"		ADD ( CONSTRAINT hwxsjh_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_EMP"
(
 ID NUMBER(12,0) NOT NULL,
 XSJE1 NUMBER(16,4),
 XSJE2 NUMBER(16,4),
 XSJE3 NUMBER(16,4),
 XSJE4 NUMBER(16,4),
 XSJE5 NUMBER(16,4),
 XSJE6 NUMBER(16,4),
 XSJE7 NUMBER(16,4),
 XSJE8 NUMBER(16,4),
 XSJE9 NUMBER(16,4),
 XSJE10 NUMBER(16,4),
 XSJE11 NUMBER(16,4),
 XSJE12 NUMBER(16,4),
 JTZZ  VARCHAR2(80) ,
 TEL  VARCHAR2(40) ,
 BZ  VARCHAR2(254) ,
 DT1  DATE ,
 DT2  DATE ,
 STR1  VARCHAR2(40) ,
 STR2  VARCHAR2(40) ,
 STR3  VARCHAR2(40) , 
 STR4  VARCHAR2(40),
 CODE VARCHAR2(12),
 NAME VARCHAR2(30),
 NCYE_J NUMBER(16,4),
 NCYE_S NUMBER(16,4),
 XSJE NUMBER(16,4),
 XSSL NUMBER(18,6),
 XSSL1 NUMBER(18,6),
 XSSL2 NUMBER(18,6),
 XSSL3 NUMBER(18,6),
 XSSL4 NUMBER(18,6),
 XSSL5 NUMBER(18,6),
 XSSL6 NUMBER(18,6),
 XSSL7 NUMBER(18,6),
 XSSL8 NUMBER(18,6),
 XSSL9 NUMBER(18,6),
 XSSL10 NUMBER(18,6),
 XSSL11 NUMBER(18,6),
 XSSL12 NUMBER(18,6),
 ISEND  VARCHAR2(10),
 XB  NUMBER(5,0) ,
 AGE  NUMBER(5,0) ,
 NATION  VARCHAR2(20) ,
 WHCD  VARCHAR2(20)
 );
ALTER TABLE "X_EMP"		ADD ( CONSTRAINT emp_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_EMPHW"
(
 ID NUMBER(12,0) NOT NULL,
 EMPID NUMBER(12,0),
 HWCODE VARCHAR2(20),
 HWNAME VARCHAR2(50),
 HWGG VARCHAR2(50),
 HWDW VARCHAR2(6),
 NCYE_J NUMBER(16,4),
 NCYE_S NUMBER(16,4),
 XSJE NUMBER(16,4),
 XSJE1 NUMBER(16,4),
 XSJE2 NUMBER(16,4),
 XSJE3 NUMBER(16,4),
 XSJE4 NUMBER(16,4),
 XSJE5 NUMBER(16,4),
 XSJE6 NUMBER(16,4),
 XSJE7 NUMBER(16,4),
 XSJE8 NUMBER(16,4),
 XSJE9 NUMBER(16,4),
 XSJE10 NUMBER(16,4),
 XSJE11 NUMBER(16,4),
 XSJE12 NUMBER(16,4),
 XSSL NUMBER(18,6),
 XSSL1 NUMBER(18,6),
 XSSL2 NUMBER(18,6),
 XSSL3 NUMBER(18,6),
 XSSL4 NUMBER(18,6),
 XSSL5 NUMBER(18,6),
 XSSL6 NUMBER(18,6),
 XSSL7 NUMBER(18,6),
 XSSL8 NUMBER(18,6),
 XSSL9 NUMBER(18,6),
 XSSL10 NUMBER(18,6),
 XSSL11 NUMBER(18,6),
 XSSL12 NUMBER(18,6)
);
ALTER TABLE "X_EMPHW"		ADD ( CONSTRAINT emphw_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_EMPN"
(
 ID NUMBER(12,0) NOT NULL,
 MON NUMBER(5,0),
 P_SL NUMBER(18,6),
 F_SL NUMBER(18,6),
 P_JE NUMBER(16,4),
 F_JE NUMBER(16,4)
);
ALTER TABLE "X_EMPN"		ADD ( CONSTRAINT empn_x		PRIMARY KEY ("ID"));

CREATE TABLE  "X_EMPDC"
(
 ID		NUMBER(12,0) NOT NULL,
 USE_    NUMBER(12,0) , 
 EMP		VARCHAR2(20)    ,
 CZY     NUMBER(12,0)	,
 CZY_NAME  VARCHAR2(20)   ,
 DQH		VARCHAR2(4)  ,
 DWDM		VARCHAR2(4)	,
 DQMC    VARCHAR2(20)  ,
 DWMC    VARCHAR2(60)  ,
 D1      NUMBER(16,4)  , 
 D2      NUMBER(16,4)  , 
 DT1     DATE  , 
 STR1    VARCHAR2(40) ,
 STR2    VARCHAR2(40)
);
ALTER TABLE "X_EMPDC"		ADD ( CONSTRAINT empdc_x		PRIMARY KEY ("ID"));

CREATE TABLE "SECUSER"
(
 ID NUMBER(12,0) ,
 NAME VARCHAR2(10) NOT NULL,
 PWD VARCHAR2(254),
 GRANT_ NUMBER(5,0)
);
ALTER TABLE "SECUSER"		ADD ( CONSTRAINT suser_x		PRIMARY KEY ("NAME"));

CREATE TABLE "SECUR"
(
 ID NUMBER(12,0) NOT NULL,
 USERID NUMBER(12,0),
 RIGHTID NUMBER(12,0)
);
ALTER TABLE "SECUR"		ADD ( CONSTRAINT secur_x		PRIMARY KEY ("ID"));

CREATE TABLE "SECRIGHT"
(
ID NUMBER(12,0) NOT NULL,
LABEL NUMBER(12,0),
RIGHT_ VARCHAR2(20),
FUN_TEXT VARCHAR2(30),
OP VARCHAR2(10),
OP_TEXT VARCHAR2(20)
);
ALTER TABLE "SECRIGHT"		ADD ( CONSTRAINT secright_x		PRIMARY KEY ("ID"));

CREATE TABLE "XS_PZ"
(ID	NUMBER(6,0) NOT NULL,
 JZBZ NUMBER(1,0),
 PZRQ DATE,
 PZLX CHAR(1),
 PZH	CHAR(4),
 FJ	NUMBER(3,0),
 ZY	VARCHAR2(30),
 KMDM VARCHAR2(20),
 J		NUMBER(12,2),
 D		NUMBER(12,2),
 ZPHJSDJH VARCHAR2(5),
 SHY	VARCHAR2(8),
 ZDY	VARCHAR2(8),
 CZY	VARCHAR2(8),
 SHBZ NUMBER(1,0),
 WBJE NUMBER(10,2),
 HL	NUMBER(12,7),
 DQH	VARCHAR2(4),
 GG	VARCHAR2(30),
 SL	NUMBER(18,6),
 DJ	NUMBER(16,6),
 DWDM VARCHAR2(4),
 LXR	VARCHAR2(8),
 JSR 	VARCHAR2(8),
 BMRY VARCHAR2(8)
);
ALTER TABLE "XS_PZ"		ADD ( CONSTRAINT xspz_x		PRIMARY KEY ("ID"));

CREATE TABLE "XS_INFO"
(
 JSECTION VARCHAR2(20) NOT NULL,
 JKEY VARCHAR2(20) NOT NULL,
 JVALUE VARCHAR2(128)
);
ALTER TABLE "XS_INFO"		ADD ( CONSTRAINT info_x		PRIMARY KEY ("JSECTION","JKEY"));

CREATE TABLE "X_BZ"
(
 ID NUMBER(12,0) NOT NULL,
 JTEXT VARCHAR2(254)
);
ALTER TABLE "X_BZ"		ADD ( CONSTRAINT bz_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_XSFY"
( 
 ID      NUMBER(12,0)  NOT NULL,
 PJH     VARCHAR2(20)   ,
 EMP     VARCHAR2(20)   ,
 DJR     VARCHAR2(20)   ,
 RQ		DATE      ,
 HTDM    VARCHAR2(20)   ,
 DQH     VARCHAR2(4)    ,
 DWDM    VARCHAR2(4)    ,
 DQMC  	VARCHAR2(10) 	,
 DWMC  	VARCHAR2(60) 	,
 CKDM  	VARCHAR2(10) 	,
 HWDM    VARCHAR2(20)   ,
 HWMC  	VARCHAR2(10) 	,
 DFRY    VARCHAR2(10)   ,
 DD      VARCHAR2(80)   ,
 START_RQ DATE      ,
 END_RQ  DATE      ,
 AIM     VARCHAR2(100)  ,
 ZSF     NUMBER(16,4)  ,
 JTF		NUMBER(16,4)	,
 TZJTF   NUMBER(16,4)  ,
 DDJTF   NUMBER(16,4)  , 
 TXF     NUMBER(16,4)  ,
 YSF     NUMBER(16,4)  ,
 ZFY     NUMBER(16,4)  ,
 BZ      VARCHAR2(254)  ,
 ZT      NUMBER(12,0)  ,
 D1      NUMBER(16,4)  ,
 D2      NUMBER(16,4)  ,
 D3      NUMBER(16,4)  ,
 D4      NUMBER(16,4)  ,
 D5      NUMBER(16,4)  ,
 D6      NUMBER(16,4)  ,
 DT1     DATE  ,
 STR1    VARCHAR2(40) ,
 STR2    VARCHAR2(40)
);
ALTER TABLE "X_XSFY"		ADD ( CONSTRAINT xsfy_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_JSFS"
(
 BH NUMBER(5,0) NOT NULL,
 JSFS VARCHAR2(10)
);
ALTER TABLE "X_JSFS"		ADD ( CONSTRAINT jsfs_x		PRIMARY KEY ("BH"));

CREATE TABLE "X_HX"
 (
	ID        	NUMBER(12,0) NOT NULL,
	HXH       	VARCHAR2(16),
	HXRQ      	DATE	,
	LRY       	VARCHAR2(12),
	FPH       	VARCHAR2(16),
	FPRQ      	DATE,
	FPHWID    	NUMBER(12,0),
	HWDM      	VARCHAR2(20),
	HWMC      	VARCHAR2(60),
	HWGG			VARCHAR2(50),
	SKH       	VARCHAR2(16),
	SKRQ      	DATE,
	EMP       	VARCHAR2(16),
	DQH       	VARCHAR2(4),
	DWDM      	VARCHAR2(4),
	DWMC      	VARCHAR2(60),
	HXJE      	NUMBER(16,4),
	HXSL      	NUMBER(18,6),
	JJ_1      	NUMBER(16,4),
	JJ_2      	NUMBER(16,4),
	JJ_3      	NUMBER(16,4),
	ZT        	NUMBER(5,0)
);
ALTER TABLE "X_HX"		ADD ( CONSTRAINT hx_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_KHYH"
(
 ID NUMBER(12,0) NOT NULL,
 YHDM VARCHAR2(20),
 KHYH VARCHAR2(60),
 ZH VARCHAR2(30),
 KMDM VARCHAR2(20)
);
ALTER TABLE "X_KHYH"		ADD ( CONSTRAINT khyh_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_LEVEL"
(
 ID NUMBER(12,0) NOT NULL,
 ITEMID NUMBER(12,0),
 LEVELNUM NUMBER(12,0),
 LEVELBYTES NUMBER(12,0)
);
ALTER TABLE "X_LEVEL"		ADD ( CONSTRAINT level_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_LVBASE"
(
 ID NUMBER(12,0) NOT NULL,
 ITEM VARCHAR2(30),
 MAXBYTES NUMBER(12,0),
 MAXLEVEL NUMBER(12,0),
 JCOMMENT VARCHAR2(120),
 ITEM_LAB VARCHAR2(10)
);
ALTER TABLE "X_LVBASE"		ADD ( CONSTRAINT lvbase_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_WLYS"
(
 EMP VARCHAR2(14) NOT NULL,
 DQH VARCHAR2(4) NOT NULL,
 DWDM VARCHAR2(4) NOT NULL,
 DQMC VARCHAR2(10),
 DWMC VARCHAR2(60),
 NCYSYE NUMBER(16,4),
 YSJE NUMBER(16,4),
 SKJE NUMBER(16,4),
 YHXJE NUMBER(16,4) ,
 BCHXJE NUMBER(16,4),
 YSFHJE NUMBER(16,4),
 YSHTJE NUMBER(16,4),
 DEF_NUM1 NUMBER(16,4),
 DEF_NUM2 NUMBER(16,4),
 DEF_INT1 NUMBER(12,0),
 DEF_INT2 NUMBER(12,0),
 DEF_STR1 VARCHAR2(30),
 DEF_STR2 VARCHAR2(30)
);
ALTER TABLE "X_WLYS"		ADD ( CONSTRAINT wlys_x		PRIMARY KEY ("EMP","DQH","DWDM"));

CREATE TABLE "X_WLYSC"
(
 ID NUMBER(12,0) NOT NULL,
 DQH VARCHAR2(4),
 DQMC VARCHAR2(10),
 DWDM VARCHAR2(4),
 DWMC VARCHAR2(60),
 LASTYE NUMBER(16,4),
 YS NUMBER(16,4),
 SK NUMBER(16,4),
 MON NUMBER(5,0),
 EMP VARCHAR2(14),
 HWDM VARCHAR2(20),
 HWMC VARCHAR2(50),
 HWGG VARCHAR2(50),
 HTDM VARCHAR2(30)
);
ALTER TABLE "X_WLYSC"		ADD ( CONSTRAINT wlysc_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_WLYSD"
(
ID NUMBER(12,0) NOT NULL,
MON NUMBER(12,0),
YS NUMBER(16,4),
SK NUMBER(16,4),
DQH VARCHAR2(4),
DWDM VARCHAR2(4)
);
ALTER TABLE "X_WLYSD"		ADD ( CONSTRAINT wlysd_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_WLYSDW"
(
 ID NUMBER(12,0) NOT NULL,
 DQH VARCHAR2(4),
 DQMC VARCHAR2(10),
 DWDM VARCHAR2(4),
 DWMC VARCHAR2(60),
 LASTYE NUMBER(16,4),
 YS NUMBER(16,4),
 SK NUMBER(16,4),
 MON NUMBER(5,0),
 EMP VARCHAR2(14),
 HTDM VARCHAR2(30),
 ZKE  NUMBER(16,4)
);
ALTER TABLE "X_WLYSDW"		ADD ( CONSTRAINT wlysdw_x		PRIMARY KEY ("ID"));


CREATE TABLE "X_CARRY"
(
 ID NUMBER(5,0) NOT NULL,
 JCARRY VARCHAR2(15)
);
ALTER TABLE "X_CARRY"		ADD ( CONSTRAINT carry_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_KHXYDJ"
(
 ID   NUMBER(12,0)  NOT NULL,
 CLASS_   NUMBER(12,0)  ,
 DZ1      NUMBER(16,4)     ,
 DZ2      NUMBER(16,4)     , 
 XYTS     NUMBER(12,0)   ,
 SCROE    NUMBER(16,4)      ,
 SXL       NUMBER(16,4)    ,
 BZ       VARCHAR2(254) ,
 D1      NUMBER(16,4)  ,
 D2      NUMBER(16,4)  , 
 DT1      DATE  ,
 STR1      VARCHAR2(40) ,
 STR2      VARCHAR2(40)
);
ALTER TABLE "X_KHXYDJ"		ADD ( CONSTRAINT khxydj_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_KHDA"
(
 DQH	VARCHAR2(4)  NOT NULL, 
 DWDM VARCHAR2(4)   NOT NULL,
 QYXZ  VARCHAR2(30) ,
 ZCZJ   NUMBER(16,4)  ,
 JZC   NUMBER(16,4)   , 
 ZZC   NUMBER(16,4)   ,
 SSSLYYE  NUMBER(16,4)  ,
 SSLYYE  NUMBER(16,4)  ,
 SLYYE  NUMBER(16,4)  ,
 SSSLYYSR  NUMBER(16,4)  , 
 SSLYYSR  NUMBER(16,4)  , 
 SLYYSR  NUMBER(16,4)  , 
 SLYSKZZL   NUMBER(16,4)  ,
 EMP      NUMBER(12,0)    ,
 D1      NUMBER(16,4)  ,
 D2      NUMBER(16,4)  , 
 DT1      DATE  ,
 STR1      VARCHAR2(40) ,
 STR2      VARCHAR2(40),
 FLDM		NUMBER(5,0),
 SKKM VARCHAR2(20),
 FPTYPE NUMBER(5,0)
);
ALTER TABLE "X_KHDA"		ADD ( CONSTRAINT khda_x		PRIMARY KEY ("DQH","DWDM"));

CREATE TABLE "X_XYDJ"
(
 ID    NUMBER(12,0)   NOT NULL,
 DQH  VARCHAR2(4)  ,
 DWDM  VARCHAR2(4)  ,
 RQ    DATE ,
 XYDJ  NUMBER(12,0) ,
 SXJE    NUMBER(16,4)  ,
 HZFX    NUMBER(16,4)  , 
 LJYSZKL  NUMBER(16,4)  ,
 D1      NUMBER(16,4)  ,
 D2      NUMBER(16,4)  , 
 DT1      DATE  ,
 STR1      VARCHAR2(40) ,
 STR2      VARCHAR2(40),
 FLDM NUMBER(5,0),
 HTJE NUMBER(16,4),
 FPJE NUMBER(16,4),
 FHJE NUMBER(16,4),
 SKJE NUMBER(16,4),
 QCHTJE NUMBER(16,4),
 QCFPJE NUMBER(16,4),
 QCFHJE NUMBER(16,4),
 QCSKJE NUMBER(16,4)
);
ALTER TABLE "X_XYDJ"		ADD ( CONSTRAINT xydj_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_XJZK"
(
 ID NUMBER(12,0)  NOT NULL,
 DQH  VARCHAR2(4) ,
 DWDM VARCHAR2(4)  ,
 HKTS1  NUMBER(12,0) ,
 HKTS2  NUMBER(12,0) ,
 ZKL    NUMBER(16,4)
);
ALTER TABLE "X_XJZK"		ADD ( CONSTRAINT xjzk_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_JJKX"
 (
	ID        	NUMBER(12,0) NOT NULL,
	KXBH      	VARCHAR2(4),
	KXMC      	VARCHAR2(16),
	KXDESC    	VARCHAR2(255),
	KXSM      	VARCHAR2(255)
);
ALTER TABLE "X_JJKX"		ADD ( CONSTRAINT jjkx_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_DWDQ"
(
 DQH VARCHAR2(4) NOT NULL,
 DQMC VARCHAR2(10)
);
ALTER TABLE "X_DWDQ"		ADD ( CONSTRAINT dwdq_x		PRIMARY KEY ("DQH"));

CREATE TABLE "X_DWTX"
(
 DQH VARCHAR2(4) NOT NULL,
 DQMC VARCHAR2(8),
 DWDM VARCHAR2(4) NOT NULL,
 DWMC VARCHAR2(60),
 ADDR VARCHAR2(60),
 ZP VARCHAR2(6),
 TEL VARCHAR2(20),
 FAX VARCHAR2(20),
 FRDB VARCHAR2(8),
 ZH VARCHAR2(30),
 KHH VARCHAR2(60),
 SCBZ NUMBER(5,0),
 NSRDJH VARCHAR2(30),
 PYDM_ VARCHAR2(10)
);
ALTER TABLE "X_DWTX"		ADD ( CONSTRAINT dwtx_x		PRIMARY KEY ("DQH","DWDM"));

CREATE TABLE "X_FTDY"
(
	ID		NUMBER(12,0) NOT NULL,
	FPID	NUMBER(12,0),
	THID	NUMBER(12,0),
	MXID	NUMBER(12,0),
	PJLX	NUMBER(5,0),
	HWDM	VARCHAR2(20),
	JLDW	VARCHAR2(6),
	SL		NUMBER(18,6),
	JE		NUMBER(16,4),
	SYSL	NUMBER(18,6),
	SYJE	NUMBER(16,4),
	BZ		VARCHAR2(1)
);
ALTER TABLE "X_FTDY"	ADD ( CONSTRAINT ftdy_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_KHFL"
(
	FLDM		NUMBER(5,0) NOT NULL,
	FLMC		VARCHAR2(20),
	SFTJ		VARCHAR2(1),
	TJXH		NUMBER(5,0),
	MS		   VARCHAR2(100)
);
ALTER TABLE "X_KHFL"		ADD ( CONSTRAINT khfl_x		PRIMARY KEY ("FLDM"));

CREATE TABLE "X_WB"
(
 DM VARCHAR2(4) NOT NULL,
 MC VARCHAR2(20),
 RATE NUMBER(16,4)
);
ALTER TABLE "X_WB"	ADD ( CONSTRAINT wb_x		PRIMARY KEY ("DM"));

CREATE TABLE "X_SLZK"
(
	ID		NUMBER(10,0)	NOT NULL,
	DQH	VARCHAR2(4)	,
	DQMC	VARCHAR2(10)	,
	DWDM	VARCHAR2(4)	,
	DWMC	VARCHAR2(60)	,
	HWDM	VARCHAR2(20)	,
	HWMC	VARCHAR2(60)	,
	SL		NUMBER(18,6)	,	
	ZKL	NUMBER(16,4)	,
	STYLE	NUMBER(5,0)
);
ALTER TABLE "X_SLZK"	ADD ( CONSTRAINT slzk_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_SKMX"
 (
	ID		NUMBER(12,0)	NOT NULL,
	SKID	NUMBER(12,0)	,	
	DDDM	VARCHAR2(30)	,
	PJH	VARCHAR2(30)	,
	HXJE	NUMBER(16,4)	,
	RQ		DATE				,
	CHLJE	NUMBER(16,4)	,
	BCHXJE NUMBER(16,4)		
);
ALTER TABLE "X_SKMX"	ADD ( CONSTRAINT skmx_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_LSDDCS"
 (
	ID		NUMBER(12,0)	NOT NULL,
	LSDDH	VARCHAR2(30)	,
	EMP   VARCHAR2(14)	,
	DQH   VARCHAR2(4)	,
	DWDM  VARCHAR2(4)	,
	DQMC  VARCHAR2(10)	,
	DWMC  VARCHAR2(60)	,
	YSJE  NUMBER(16,4) ,
	KPJE  NUMBER(16,4) ,
	SKJE  NUMBER(16,4) ,
	HXJE  NUMBER(16,4) ,
	BCHX  NUMBER(16,4) ,
	HXBZ  NUMBER(2,0),
	FPJE  NUMBER(16,4) ,
	FHJE  NUMBER(16,4) ,
	YSFPJE  NUMBER(16,4) ,
	YSFHJE  NUMBER(16,4) ,
	YSHTJE  NUMBER(16,4) ,
	HTBZ  NUMBER(2,0),
	DEF_NUM1  NUMBER(16,4) ,
	DEF_NUM2  NUMBER(16,4) ,
	DEF_INT1  NUMBER(12,0),
	DEF_INT2  NUMBER(12,0),
	DEF_STR1  VARCHAR2(30)	,
	DEF_STR2  VARCHAR2(30)
);
ALTER TABLE "X_LSDDCS"	ADD ( CONSTRAINT lsddcs_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_YJBB"
(
	ID			NUMBER(6,0) NOT NULL,
	TITLE		VARCHAR2(30) ,
	FILETYPE	CHAR(2) ,
	MON		NUMBER(2,0),
	BMDM		VARCHAR2(14),
	OWNRTYPE NUMBER(2,0),
	OWNER		VARCHAR2(14),
	FMT		LONG RAW
);
ALTER TABLE "X_YJBB"	ADD ( CONSTRAINT yjbb_x		PRIMARY KEY ("ID"));

CREATE TABLE "X_TEMP"
(
THDH		VARCHAR2(16) NOT NULL,
FPH		VARCHAR2(16) NOT NULL,
HWDM		VARCHAR2(20) NOT NULL,
MXID		NUMBER(6,0)	,
SL			NUMBER(18,6),
BZ			NUMBER(2,0)	,
LX			NUMBER(2,0)		
);
ALTER TABLE "X_TEMP" ADD (CONSTRAINT temp_x PRIMARY KEY ("THDH","FPH","HWDM","MXID"));

CREATE TABLE "X_TEMPCP"
(
ID              NUMBER(12,0) NOT NULL,
THDH		VARCHAR2(16) NOT NULL,
FPH		VARCHAR2(16) NOT NULL,
HWDM		VARCHAR2(20) NOT NULL,
MXID		NUMBER(6,0)	,
SL			NUMBER(18,6),
BZ			NUMBER(2,0)	,
LX			NUMBER(2,0)		
);
ALTER TABLE "X_TEMPCP" ADD (CONSTRAINT tempcp_x PRIMARY KEY ("THDH","FPH","HWDM","ID"));

CREATE VIEW "X_FH_VIEW"
AS SELECT X_FH.ID,X_FH.PJH,X_FH.rq,X_FHHW.HWDM,X_FHHW.HWMC,X_FHHW.SL 
FROM X_FH,X_FHHW 
WHERE(X_FH.ID=X_FHHW.FHID) AND ((X_FH.ISZF=0));

CREATE TABLE "X_FPCH"
(
	ID NUMBER(12,0) NOT NULL,
	HZFPID NUMBER(12,0),
	HZFPH VARCHAR2(16),
	LZFPID NUMBER(12,0),
	LZFPH VARCHAR2(16),
	HWDM VARCHAR2(20),
	SL NUMBER(18,6),
	JE NUMBER(16,4),
	SE NUMBER(16,4)
);
ALTER TABLE "X_FPCH" ADD (CONSTRAINT fpch_x PRIMARY KEY("ID") );

CREATE TABLE "X_QZHX" (
	SKID1 NUMBER(12,0) NOT NULL,
	SKID2 NUMBER(12,0) NOT NULL,
	JE NUMBER(16,4)
);
ALTER TABLE "X_QZHX" ADD (CONSTRAINT qzhx_x PRIMARY KEY("SKID1","SKID2"));

CREATE TABLE "X_DFCX" (
	ID NUMBER(12,0) NOT NULL,
	SKID NUMBER(12,0),
	FPID NUMBER(12,0),
	FPHWID NUMBER(12,0),
	JE NUMBER(16,4),
	RQ DATE
);
ALTER TABLE "X_DFCX" ADD (CONSTRAINT dfcx_x PRIMARY KEY("ID"));

CREATE TABLE "X_DISC"(
	ID NUMBER(12,0) NOT NULL,
	DQH	VARCHAR2(4),
	DQMC VARCHAR2(8),
	DWDM VARCHAR2(4),
	DWMC VARCHAR2(60),
	CG_DATE DATE,
	PRE_DISC NUMBER(16,4),
	CG_POINT NUMBER(16,4),
	CUR_DISC NUMBER(16,4),
	PF_FLAG NUMBER(5,0),
	MARKS VARCHAR2(60)
);
ALTER TABLE "X_DISC" ADD (CONSTRAINT DISC_X PRIMARY KEY("ID"));


DROP INDEX "X_HT"."X_HT_HTDM";
DROP INDEX "X_HT"."X_HT_QDRQ";
DROP INDEX "X_HT"."X_HT_DW";
DROP INDEX "X_HT"."X_HT_GFDLR";
CREATE INDEX "X_HT_HTDM" ON "X_HT"("HTDM");
CREATE INDEX "X_HT_QDRQ" ON "X_HT"( "QDRQ" );
CREATE INDEX "X_HT_DW" ON "X_HT"("XFDQ","XFDM");
CREATE INDEX "X_HT_GFDLR" ON "X_HT"("GFDLR");

DROP INDEX "X_HTHW"."X_HTHW_HTID";
DROP INDEX "X_HTHW"."X_HTHW_HWDM";
CREATE INDEX "X_HTHW_HTID" ON "X_HTHW"("HTID");
CREATE INDEX "X_HTHW_HWDM"	ON "X_HTHW"("HWDM");

DROP INDEX "X_FH"."X_FH_RQ";
DROP INDEX "X_FH"."X_FH_DW";
DROP INDEX "X_FH"."X_FH_BMDM";
DROP INDEX "X_FH"."X_FH_HTDM";
CREATE INDEX "X_FH_RQ" ON "X_FH"("RQ");
CREATE INDEX "X_FH_DW" 	ON "X_FH"("DQH","DWDM");
CREATE INDEX "X_FH_BMDM" ON "X_FH"("BMDM");
CREATE INDEX "X_FH_HTDM" ON "X_FH"("HTDM");

DROP INDEX "X_FHHW"."X_FHHW_FHID";
DROP INDEX "X_FHHW"."X_FHHW_HWDM";
CREATE INDEX "X_FHHW_FHID" ON "X_FHHW"("FHID");
CREATE INDEX "X_FHHW_HWDM" ON "X_FHHW"("HWDM");

DROP INDEX "X_FP"."X_FP_RQ";
DROP INDEX "X_FP"."X_FP_DW";
DROP INDEX "X_FP"."X_FP_EMP";
DROP INDEX "X_FP"."X_FP_HTDM";
CREATE INDEX "X_FP_RQ" ON "X_FP"("RQ");
CREATE INDEX "X_FP_DW" ON "X_FP"("DQH","DWDM");
CREATE INDEX "X_FP_EMP" ON "X_FP"("EMP");
CREATE INDEX "X_FP_HTDM" ON "X_FP"("HTDM");

DROP INDEX "X_FPHW"."X_FPHW_FPID";
DROP INDEX "X_FPHW"."X_FPHW_HWDM";
CREATE INDEX "X_FPHW_FPID" ON "X_FPHW"("FPID");
CREATE INDEX "X_FPHW_HWDM"	ON "X_FPHW"("HWDM");

DROP INDEX "X_SK"."X_SK_PJH";
DROP INDEX "X_SK"."X_SK_DW";
DROP INDEX "X_SK"."X_SK_EMP";
DROP INDEX "X_SK"."X_SK_RQ";
CREATE INDEX "X_SK_PJH" ON "X_SK"("PJH");
CREATE INDEX "X_SK_DW" ON "X_SK"("DQH","DWDM");
CREATE INDEX "X_SK_EMP" ON "X_SK"("EMP");
CREATE INDEX "X_SK_RQ" ON "X_SK"("RQ");

DROP INDEX "X_HX"."X_HX_FPH";
CREATE INDEX "X_HX_FPH" ON "X_HX"("FPH");

DROP INDEX "X_FTDY"."X_FTDY_FT";
CREATE INDEX "X_FTDY_FT" ON "X_FTDY"("FPID","THID");

DROP INDEX "X_SKMX"."X_SKMX_PJH";
DROP INDEX "X_SKMX"."X_SKMX_SKID";
DROP INDEX "X_SKMX"."X_SKMX_DDDM";
CREATE INDEX "X_SKMX_PJH" ON "X_SKMX"("PJH");
CREATE INDEX "X_SKMX_SKID" ON "X_SKMX"("SKID");
CREATE INDEX "X_SKMX_DDDM" ON "X_SKMX"("DDDM");

DROP INDEX "X_DFCX"."X_DFCX_SKID";
DROP INDEX "X_DFCX"."X_DFCX_FPID";
CREATE INDEX "X_DFCX_SKID" ON "X_DFCX"("SKID");
CREATE INDEX "X_DFCX_FPID" ON "X_DFCX"("FPID");

DROP INDEX "X_DISC"."X_DISC_DW";
DROP INDEX "X_DISC"."X_DISC_FLAG";
CREATE INDEX "X_DISC_DW" ON "X_DISC" ("DQH","DWDM");
CREATE INDEX "X_DISC_FLAG" ON "X_DISC" ("PF_FLAG");
