[CREATE TABLE]
CREATE TABLE dbo.z_def
(
	id				int NOT NULL,
	title			varchar(30) NULL,
	def			varchar(100) NULL,
	CONSTRAINT defid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_tbls
(
	tblname		varchar(16) NOT NULL,
	means			varchar(60) NULL,
	dt				smalldatetime NULL,
	CONSTRAINT tblsid Primary KEY NONCLUSTERED (tblname)
);
CREATE TABLE dbo.anydw
(
	id				smallint NOT NULL,
	dwname		varchar(30) NULL,
	title1		varchar(30) NULL,
	title2		varchar(30) NULL,
	title3		varchar(30) NULL,
	dataobj		varchar(30) NULL,
	dwstyle		tinyint NULL,
	griddisp		tinyint NULL,
	detailhigh	smallint NULL,
	headerhigh	smallint NULL,
	footerhigh	smallint NULL,
	backcolor	int NULL,
	color1		int NULL,
	backcolor1	int NULL,
	y1				smallint NULL,
	font1			varchar(30) NULL,
	height1		smallint NULL,
	weight1		smallint NULL,
	color2		int NULL,
	backcolor2	int NULL,
	y2				smallint NULL,
	font2			varchar(30) NULL,
	height2		smallint NULL,
	weight2		smallint NULL,
	i1				int NULL,
	i2				int NULL,
	i3				int NULL,
	i4				int NULL,
	i5				int NULL,
	CONSTRAINT anydwid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.anyobj
(
	id				smallint NOT NULL,
	anydwid		smallint NULL,
	objtype		tinyint NULL,
	objsite		tinyint NULL,
	objname		varchar(30) NULL,
	objtext		varchar(30) NULL,
	width			smallint NULL,
	x1				smallint NULL,
	y1				smallint NULL,
	alignment1	tinyint NULL,
	backcolor1	int NULL,
	textcolor1	int NULL,
	font1			varchar(30) NULL,
	height1		smallint NULL,
	weight1		smallint NULL,
	y2				smallint NULL,
	alignment2	tinyint NULL,
	backcolor2	int NULL,
	textcolor2	int NULL,
	font2			varchar(30) NULL,
	height2		smallint NULL,
	weight2		smallint NULL,
	formatstr	varchar(20) NULL,
	CONSTRAINT anyobjid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_bill
(
	zph	varchar(20) NOT NULL,
	hxbz	tinyint NULL,
	bmry	varchar(8) NULL,
	xm		varchar(8) NULL,
	zy		varchar(60) NULL,
	dt1	smalldatetime NULL,
	dt2	smalldatetime NULL,
	je1	money	NULL,
	je2	money NULL,
	czy	varchar(8) NULL,
	zpbook	varchar(4) NULL,
	pzlx		varchar(4) NULL,
	pzh		varchar(6) NULL,
	dqh		varchar(4) NULL,
	dwdm		varchar(4) NULL,
	def_str1	varchar(64) NULL,
	def_str2	varchar(64) NULL,
	def_str3	varchar(64) NULL,
	def_str4	varchar(64) NULL,
	def_str5	varchar(64) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_int3	int NULL,
	def_int4	int NULL,
	def_int5	int NULL,
	CONSTRAINT z_billzph Primary KEY NONCLUSTERED (zph)
);
CREATE TABLE dbo.z_bank
(
	kmdm	varchar(20) NOT NULL,
	yefx	char(1) NULL,
	bmry	varchar(8) NULL,
	ncye	money NULL,
	js01	money NULL,
	js02	money NULL,
	js03	money NULL,
	js04	money NULL,
	js05	money NULL,
	js06	money NULL,
	js07	money NULL,
	js08	money NULL,
	js09	money NULL,
	js10	money NULL,
	js11	money NULL,
	js12	money NULL,
	lx01	money NULL,
	lx02	money NULL,
	lx03	money NULL,
	lx04	money NULL,
	lx05	money NULL,
	lx06	money NULL,
	lx07	money NULL,
	lx08	money NULL,
	lx09	money NULL,
	lx10	money NULL,
	lx11	money NULL,
	lx12	money NULL,
	ll1	float NULL,
	ll2	float NULL,
	dt1	smalldatetime NULL,
	dt2	smalldatetime NULL,
	mc	varchar(128) NULL,
	def_str1	varchar(128) NULL
);
CREATE TABLE dbo.bmhz
(
	dm		varchar(8) NOT NULL,
	kmdm	varchar(20) NOT NULL,
	jhd	varchar(1) NULL,
	ncye	money NULL,
	jlje	money NULL,
	dlje	money NULL,
	ncjcsl	float NULL,
	sljsl	float NULL,
	fljsl	float NULL,
	jfe01	money NULL,
	jfe02	money NULL,
	jfe03	money NULL,
	jfe04	money NULL,
	jfe05	money NULL,
	jfe06	money NULL,
	jfe07	money NULL,
	jfe08	money NULL,
	jfe09	money NULL,
	jfe10	money NULL,
	jfe11	money NULL,
	jfe12	money NULL,
	dfe01	money NULL,
	dfe02	money NULL,
	dfe03	money NULL,
	dfe04	money NULL,
	dfe05	money NULL,
	dfe06	money NULL,
	dfe07	money NULL,
	dfe08	money NULL,
	dfe09	money NULL,
	dfe10	money NULL,
	dfe11	money NULL,
	dfe12	money NULL,
	ssl01	float NULL,
	ssl02	float NULL,
	ssl03	float NULL,
	ssl04	float NULL,
	ssl05	float NULL,
	ssl06	float NULL,
	ssl07	float NULL,
	ssl08	float NULL,
	ssl09	float NULL,
	ssl10	float NULL,
	ssl11	float NULL,
	ssl12	float NULL,
	fsl01	float NULL,
	fsl02	float NULL,
	fsl03	float NULL,
	fsl04	float NULL,
	fsl05	float NULL,
	fsl06	float NULL,
	fsl07	float NULL,
	fsl08	float NULL,
	fsl09	float NULL,
	fsl10	float NULL,
	fsl11	float NULL,
	fsl12	float NULL,
	CONSTRAINT bmhzid Primary KEY NONCLUSTERED (dm,kmdm)
);
CREATE TABLE dbo.z_projkm
(
	id		int NOT NULL,
	dm		varchar(60)  NULL,
	kmdm	varchar(20)  NULL,
	CONSTRAINT z_projkmid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_qxkm
(
	id		smallint	NOT NULL,
	xm		varchar(8) NULL,
	kmdm	varchar(20) NULL,
	bmdm	varchar(8) NULL,
	xmdm	varchar(60) NULL,
	CONSTRAINT z_qxkmid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_proj
(
	id			varchar(6) NOT NULL,
	dm			varchar(60) NOT NULL,
	pzrq		smalldatetime NULL,
	pzlx		varchar(4) NULL,
	pzh		varchar(6) NULL,
	zy			varchar(60) NULL,
	kmdm		varchar(20) NULL,
	j			float NULL,
	d			float NULL,
	zphjsdjh	varchar(20) NULL,
	dqh		varchar(4) NULL,
	dwdm		varchar(4) NULL,
	gg			varchar(14) NULL,
	sl			float NULL,
	dj			float NULL,
	bmry		varchar(8) NULL,
	lxr		varchar(8) NULL,
	wbje		float NULL,
	hl			float NULL,
	jsr		varchar(8) NULL,
	htbh		varchar(20) NULL,
	htnum		tinyint NULL,
	CONSTRAINT z_projid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_items
(
	dm		varchar(60)	NOT NULL,
	mc		varchar(60) NULL ,
	style	tinyint NULL ,
	ts1	varchar(30) NULL,
	ts2	varchar(30) NULL,
	ts3	varchar(30) NULL,
	ts4	varchar(30) NULL,
	ts5	varchar(30) NULL,
	ts6	varchar(30) NULL,
	ts7	varchar(30) NULL,
	ts8	varchar(30) NULL,
	ts9	varchar(30) NULL,
	ts10	varchar(30) NULL,
	ts11	varchar(30) NULL,
	ts12	varchar(30) NULL,
	ts13	varchar(30) NULL,
	ts14	varchar(30) NULL,
	ts15	varchar(30) NULL,
	ts16	varchar(30) NULL,
	ts17	varchar(30) NULL,
	ts18	varchar(30) NULL,
	ts19	varchar(30) NULL,
	ts20	varchar(30) NULL,
	s1		varchar(30) NULL,
	s2		varchar(30) NULL,
	s3		varchar(30) NULL,
	s4		varchar(30) NULL,
	s5		varchar(30) NULL,
	s6		varchar(30) NULL,
	s7		varchar(30) NULL,
	s8		varchar(30) NULL,
	s9		varchar(30) NULL,
	s10	varchar(30) NULL,
	s11	varchar(30) NULL,
	s12	varchar(30) NULL,
	s13	varchar(30) NULL,
	s14	varchar(30) NULL,
	s15	varchar(30) NULL,
	s16	varchar(30) NULL,
	s17	varchar(30) NULL,
	s18	varchar(30) NULL,
	s19	varchar(30) NULL,
	s20	varchar(30) NULL,
	tn1	varchar(30) NULL,
	tn2	varchar(30) NULL,
	tn3	varchar(30) NULL,
	tn4	varchar(30) NULL,
	tn5	varchar(30) NULL,
	tn6	varchar(30) NULL,
	tn7	varchar(30) NULL,
	tn8	varchar(30) NULL,
	tn9	varchar(30) NULL,
	tn10	varchar(30) NULL,
	n1		money NULL,
	n2		money NULL,
	n3		money NULL,
	n4		money NULL,
	n5		money NULL,
	n6		money NULL,
	n7		money NULL,
	n8		money NULL,
	n9		money NULL,
	n10	money NULL,
	td1	varchar(30) NULL,
	td2	varchar(30) NULL,
	td3	varchar(30) NULL,
	td4	varchar(30) NULL,
	td5	varchar(30) NULL,
	d1		smalldatetime NULL,
	d2		smalldatetime NULL,
	d3		smalldatetime NULL,
	d4		smalldatetime NULL,
	d5		smalldatetime NULL,
	CONSTRAINT z_itemsdm Primary KEY NONCLUSTERED (dm)
);
CREATE TABLE dbo.z_gr
(
	dm			varchar(8) NOT NULL,
	bmry		varchar(8) NULL,
	xm			varchar(8) NULL,
	CONSTRAINT z_grdm Primary KEY NONCLUSTERED (dm)
);
CREATE TABLE dbo.z_source
(
	id			smallint NOT NULL,
	source_	tinyint NULL,
	descrpt_	varchar(30) NULL,
	pz_		tinyint NULL,
	tblname_	varchar(16) NULL,
	dbms_		varchar(30) NULL,
	userid_	varchar(30) NULL,
	password_	varchar(30) NULL,
	database_	varchar(30) NULL,
	srvname_	varchar(30) NULL,
	logid_	varchar(30) NULL,
	logpass_	varchar(30) NULL,
	dbparm_	varchar(30)	NULL,
	CONSTRAINT z_sourceid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_yspz
(
	id		int NOT NULL,
	pzrq	smalldatetime NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh	varchar(20) NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
   gg    varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	czy	varchar(8) NULL,
	bmry	varchar(8) NULL,
	proj	varchar(60) NULL,
	CONSTRAINT z_yspzid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pzmsg
(
	smonpzlx	varchar(6) NOT NULL,
	maxpzh	varchar(6) NULL,
	maxpzrq	smalldatetime NULL,
	CONSTRAINT z_pzmsgid Primary KEY CLUSTERED (smonpzlx)
);
CREATE TABLE dbo.z_prtmsg
(
	dwnum		char(3) NOT NULL,
	kmdm		varchar(20) NOT NULL,
	dqhdwdm	varchar(8) NOT NULL,
	startmon	tinyint NULL,
	reserve	smallint NULL,
	pages		smallint NULL,
	CONSTRAINT z_prtmsgid Primary KEY NONCLUSTERED (dwnum,kmdm,dqhdwdm)
);
CREATE TABLE dbo.z_bmry
(
	dm		varchar(8)	NOT NULL,
	xm		varchar(16)	NULL,
	CONSTRAINT z_bmrydm Primary KEY CLUSTERED (dm)
);
CREATE TABLE dbo.z_czrz
(
	id		int NOT NULL,
	dt		smalldatetime NULL,
	czy	varchar(8) NULL,
	tm1	char(5) NULL,
	tm2	char(5) NULL,
	init	tinyint NULL,
	lrpz	smallint NULL,
	sgpz	smallint NULL,
	shpz	tinyint NULL,
	jz		tinyint NULL,
	jiez	tinyint NULL,
	cx		tinyint NULL,
	bf		tinyint NULL,
	hf		tinyint NULL,
	dept	tinyint NULL,
	wl		tinyint NULL,
	yhdz	tinyint NULL,
	zdzz	tinyint NULL,
	CONSTRAINT z_czrzid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.dwtx
(
	dqh	char(4) NOT NULL,
	dqmc	varchar(8) NOT NULL,
	dwdm	char(4) NOT NULL,
	dwmc	varchar(60) NOT NULL,
	addr	varchar(60) NULL,
	zp		varchar(6) NULL,
	tel	varchar(20) NULL,
	fax	varchar(20) NULL,
	frdb	varchar(8) NULL,
	zh		varchar(30) NULL,
	khh	varchar(128) NULL,
	scbz	tinyint NULL,
	nsrdjh	varchar(30) NULL,
	pydm_	varchar(10) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_int3	int NULL,
	def_str1	varchar(60) NULL,
	def_str2	varchar(60) NULL,
	def_str3	varchar(60) NULL,
	CONSTRAINT dwtxid Primary KEY CLUSTERED (dqh,dwdm)
);
CREATE TABLE dbo.z_dwwl
(
	id		int NOT NULL,
	mon	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	char(4) NULL,
	pzh	char(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	j_hx	money NULL,
	d_hx	money NULL,
	wbje	money NULL,
	hl		float NULL,
	sl		float NULL,
	dj		float NULL,
	zphjsdjh	varchar(20) NULL,
	shy	varchar(22) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	dqh	varchar(4) NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	hxbz	tinyint NULL,
	bmry	varchar(8) NULL,
	fph	varchar(20) NULL,
	def_str1	varchar(40) NULL,
	def_int1	int NULL,
	def_num1	money NULL,
	CONSTRAINT z_dwwlid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_fb
(
	dm		char(1) NOT NULL,
	name	varchar(10) NULL,
	wbfh	varchar(4) NULL,
	def_str1	varchar(40) NULL,
	def_int1	int NULL,
	CONSTRAINT z_fbid Primary KEY NONCLUSTERED (dm)
);
CREATE TABLE dbo.z_grwl
(
	id		int NOT NULL,
	mon	smallint NULL,
	pzrq	smalldatetime NULL,
	pzlx	char(4) NULL,
	pzh	char(6) NULL,
	fj		smallint NULL,
	bm		varchar(8) NULL,
	xm		varchar(8) NULL,
	yw		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	j_hx	money NULL,
	d_hx	money NULL,
	wbje	money NULL,
	hl		float NULL,
	sl		float NULL,
	dj		float NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	hxbz	tinyint NULL,
	CONSTRAINT z_grwlid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.hz
(
	kmdm	varchar(20) NOT NULL,
	kmmc	varchar(40) NOT NULL,
	yefx	char(1) NULL,
	sf		tinyint NULL,
	jhd	char(1) NULL,
	ncye	money NULL,
	jlje	money NULL,
	dlje	money NULL,
	jfe01	money NULL,
	dfe01	money NULL,
	jfe02	money NULL,
	dfe02	money NULL,
	jfe03	money NULL,
	dfe03	money NULL,
	jfe04	money NULL,
	dfe04	money NULL,
	jfe05	money NULL,
	dfe05	money NULL,
	jfe06	money NULL,
	dfe06	money NULL,
	jfe07	money NULL,
	dfe07	money NULL,
	jfe08	money NULL,
	dfe08	money NULL,
	jfe09	money NULL,
	dfe09	money NULL,
	jfe10	money NULL,
	dfe10	money NULL,
	jfe11	money NULL,
	dfe11	money NULL,
	jfe12	money NULL,
	dfe12	money NULL,
	CONSTRAINT hzkmdm Primary KEY CLUSTERED (kmdm)
);
CREATE TABLE dbo.z_jzbz
(
	jjrq	smalldatetime NULL,
	zw_inited	tinyint NULL,
	yh_inited	tinyint NULL,
	field1	tinyint NOT NULL,
	field2	tinyint NULL,
	field3	tinyint NULL,
	field4	tinyint NULL,
	field5	tinyint NULL,
	field6	tinyint NULL,
	field7	tinyint NULL,
	field8	tinyint NULL,
	field9	tinyint NULL,
	field10	tinyint NULL,
	bmhsfs	tinyint NULL,
	yj01	smalldatetime NULL,
	yj02	smalldatetime NULL,
	yj03	smalldatetime NULL,
	yj04	smalldatetime NULL,
	yj05	smalldatetime NULL,
	yj06	smalldatetime NULL,
	yj07	smalldatetime NULL,
	yj08	smalldatetime NULL,
	yj09	smalldatetime NULL,
	yj10	smalldatetime NULL,
	yj11	smalldatetime NULL,
	yj12	smalldatetime NULL,
	nzjz	tinyint	NULL,
	ver	tinyint	NULL,
	dat1	tinyint	NULL,
	dat2	tinyint	NULL,
	dat3	tinyint	NULL,
	dat4	tinyint	NULL,
	dat5	tinyint	NULL,
	dat6	tinyint	NULL,
	dat7	tinyint	NULL,
	dat8	tinyint	NULL,
	dat9	tinyint	NULL,
	dat10	tinyint	NULL,
	dat11	tinyint	NULL,
	dat12	tinyint	NULL,
	dat13	tinyint	NULL,
	dat14	tinyint	NULL,
	dat15	tinyint	NULL,
	dat16	tinyint	NULL,
	dat17	tinyint	NULL,
	dat18	tinyint	NULL,
	dat19	tinyint	NULL,
	dat20	tinyint	NULL,
	CONSTRAINT z_jzbzid Primary KEY NONCLUSTERED (field1)
);
CREATE TABLE dbo.km
(
	kmdm	varchar(20) NOT NULL,
	kmmc	varchar(40) NOT NULL,
	kmlb	char(1) NULL,
	kmxz	char(1) NULL,
	yefx	char(1) NULL,
	sf		tinyint NULL,
	jm		varchar(6) NULL,
	bm		tinyint NULL,
	hb		char(1) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_int3	int NULL,
	def_str1	varchar(60) NULL,
	def_str2	varchar(60) NULL,
	def_str3	varchar(60) NULL,
	CONSTRAINT kmkmdm Primary KEY CLUSTERED (kmdm)
);
CREATE TABLE dbo.z_kmtemp
(
	kmdm	varchar(20) NOT NULL,
	kmmc	varchar(40) NULL,
	kmlb	char(1) NULL,
	kmxz	char(1) NULL,
	yefx	char(1) NULL,
	sf		tinyint NULL,
	ncye	money NULL,
	jlje	money NULL,
	dlje	money NULL,
	ye		money NULL,
	wbncye	money NULL,
	wbjlje	money NULL,
	wbdlje	money NULL,
	wbye		money NULL,
	jhd	char(1) NULL,
	ncjcsl	float NULL,
	sljsl	float NULL,
	fljsl	float NULL,
	lj_sl	float NULL,
	jm		varchar(6) NULL,
	bm		tinyint NULL,
	dw		varchar(8) NULL,
	gg		varchar(14) NULL,
	hb		char(1) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_int3	int NULL,
	def_str1	varchar(60) NULL,
	def_str2	varchar(60) NULL,
	def_str3	varchar(60) NULL,
	CONSTRAINT z_kmtempkmdm Primary KEY CLUSTERED (kmdm)
);
CREATE TABLE dbo.z_pz01
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz01id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz02
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz02id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz03
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz03id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz04
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz04id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz05
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz05id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz06
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz06id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz07
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz07id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz08
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz08id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz09
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz09id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz10
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz10id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz11
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz11id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pz12
(
	id		int NOT NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	cny	varchar(8) NULL,
	dzbz	char(1) NULL,
	lsh	varchar(6) NULL,
	def_str1	varchar(254) NULL,
	def_str2	varchar(254) NULL,
	CONSTRAINT z_pz12id Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.pzlx
(
	type		tinyint NOT NULL,
	selected	tinyint NULL,
	note		varchar(28) NULL,
	CONSTRAINT pzlxid Primary KEY NONCLUSTERED (type)
);
CREATE TABLE dbo.z_qx
(
	xm		varchar(8) NOT NULL,
	mm		varchar(254) NULL,
	bm		varchar(14) NULL,
	q0		tinyint NULL,
	q1_1	tinyint NULL,
	q1_2	tinyint NULL,
	q1_3	tinyint NULL,
	q1_4	tinyint NULL,
	q1_5	tinyint NULL,
	q2_1	tinyint NULL,
	q2_2	tinyint NULL,
	q2_3	tinyint NULL,
	q3_1	tinyint NULL,
	q3_2	tinyint NULL,
	q3_3	tinyint NULL,
	q4_1	tinyint NULL,
	q4_2	tinyint NULL,
	q4_3	tinyint NULL,
	q5_1	tinyint NULL,
	q5_2	tinyint NULL,
	q5_3	tinyint NULL,
	q61	tinyint NULL,
	q62	tinyint NULL,
	q63	tinyint NULL,
	q64	tinyint NULL,
	q65	tinyint NULL,
	q66	tinyint NULL,
	q67	tinyint NULL,
	q68	tinyint NULL,
	q69	tinyint NULL,
	q610	tinyint NULL,
	q71	tinyint NULL,
	q72	tinyint NULL,
	q73	tinyint NULL,
	q74	tinyint NULL,
	q75	tinyint NULL,
	q76	tinyint NULL,
	q77	tinyint NULL,
	q78	tinyint NULL,
	q79	tinyint NULL,
	q710	tinyint NULL,
	q81	tinyint NULL,
	q82	tinyint NULL,
	q83	tinyint NULL,
	q84	tinyint NULL,
	q85	tinyint NULL,
	q86	tinyint NULL,
	q87	tinyint NULL,
	q88	tinyint NULL,
	q89	tinyint NULL,
	q810	tinyint NULL,
	q90	tinyint NULL,
	q91	tinyint NULL,
	q92	tinyint NULL,
	q93	tinyint NULL,
	q94	tinyint NULL,
	q95	tinyint NULL,
	q96	tinyint NULL,
	q97	tinyint NULL,
	q98	tinyint NULL,
	q99	tinyint NULL,
	pzqx	varchar(200) NULL,
	CONSTRAINT z_qxxm Primary KEY CLUSTERED (xm)
);
CREATE TABLE dbo.slhz
(
	kmdm	varchar(20) NOT NULL,
	kmmc	varchar(40) NOT NULL,
	dw		varchar(8)	NULL,
	gg		varchar(14) NULL,
	sf		tinyint NULL,
	ncjcsl	float NULL,
	sljsl	float NULL,
	fljsl	float NULL,
	ssl01	float NULL,
	fsl01	float NULL,
	ssl02	float NULL,
	fsl02	float NULL,
	ssl03	float NULL,
	fsl03	float NULL,
	ssl04	float NULL,
	fsl04	float NULL,
	ssl05	float NULL,
	fsl05	float NULL,
	ssl06	float NULL,
	fsl06	float NULL,
	ssl07	float NULL,
	fsl07	float NULL,
	ssl08	float NULL,
	fsl08	float NULL,
	ssl09	float NULL,
	fsl09	float NULL,
	ssl10	float NULL,
	fsl10	float NULL,
	ssl11	float NULL,
	fsl11	float NULL,
	ssl12	float NULL,
	fsl12	float NULL,
	CONSTRAINT slhzkmdm Primary KEY CLUSTERED (kmdm)
);
CREATE TABLE dbo.zy
(
	jm		varchar(6) NOT NULL,
	zy		varchar(60) NULL,
	CONSTRAINT zyjm Primary KEY CLUSTERED (jm)
);
CREATE TABLE dbo.fbhz
(
	kmdm	varchar(20) NOT NULL,
	kmmc	varchar(40) NULL,
	yefx	varchar(1) NULL,
	jhd	char(1) NULL,
	fb		char(1) NULL,
	ncye	money NULL,
	jlje	money NULL,
	dlje	money NULL,
	jfe01	money NULL,
	dfe01	money NULL,
	jfe02	money NULL,
	dfe02	money NULL,
	jfe03	money NULL,
	dfe03	money NULL,
	jfe04	money NULL,
	dfe04	money NULL,
	jfe05	money NULL,
	dfe05	money NULL,
	jfe06	money NULL,
	dfe06	money NULL,
	jfe07	money NULL,
	dfe07	money NULL,
	jfe08	money NULL,
	dfe08	money NULL,
	jfe09	money NULL,
	dfe09	money NULL,
	jfe10	money NULL,
	dfe10	money NULL,
	jfe11	money NULL,
	dfe11	money NULL,
	jfe12	money NULL,
	dfe12	money NULL,
	CONSTRAINT fbhzkmdm Primary KEY NONCLUSTERED (kmdm)
);
CREATE TABLE dbo.z_auto
(
	id		int NOT NULL,
	num	smallint NULL,
	jhd	smallint NULL,
	kmdm	varchar(20) NULL,
	contain	smallint NULL,
	zy		varchar(60) NULL,
	pzlx	char(4) NULL,
	form	varchar(160) NULL,
	slform	varchar(160) NULL,
	bmry	varchar(8) NULL,
	mc		varchar(30) NULL,
	j	money NULL,
	d	money NULL,
	dj	money NULL,
	xmdm	varchar(128) NULL,
	wldw	varchar(12)	NULL,
	def_int1	smallint	NULL,
	def_str1	varchar(128)	NULL,
	def_str2	varchar(128)	NULL, 
	CONSTRAINT z_autoid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_dz
(
	kmdm	varchar(20) NULL,
	dzrq	smalldatetime NULL,
	qyye	money NULL,
	yhye	money NULL
);

CREATE TABLE dbo.z_qy
(
	id		int NOT NULL,
	kmdm	varchar(20) NULL,
	pzrq	smalldatetime NULL,
	pzlx	char(4) NULL,
	pzh	char(6) NULL,
	zy		varchar(60) NULL,
	zphjsdjh		varchar(5) NULL,
	j		money NULL,
	d		money NULL,
	yd		tinyint NULL,
	jsfs	tinyint NULL,
	dzrq	smalldatetime NULL,
	cause	varchar(250) NULL,
	def_str1	varchar(64) NULL,
	def_str2	varchar(250) NULL,
	CONSTRAINT z_qyid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_hl
(
	dt 	smalldatetime NULL,
	dm		char(1) NULL,
	hl		float	NULL
);
CREATE TABLE dbo.z_yh
(
	id		int NOT NULL,
	kmdm	varchar(20) NULL,
	dzrq	smalldatetime NULL,
	jsfs	smallint NULL,
	zphjsdjh	varchar(5) NULL,
	j		money NULL,
	d		money NULL,
	yd		smallint NULL,
	pzrq	smalldatetime NULL,
	pzlx	varchar(4) NULL,
	pzh	varchar(6) NULL,
	zy		varchar(60) NULL,
	cause	varchar(250) NULL,
	def_str1	varchar(64) NULL,
	def_str2	varchar(250) NULL,
	CONSTRAINT z_yhid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.jsfs
(
	bh		tinyint NOT NULL,
	jsfs	varchar(10) NULL,
	CONSTRAINT jsfsid Primary KEY NONCLUSTERED (bh)
);
CREATE TABLE dbo.z_flag
(
	id		smallint NOT NULL,
	tm		varchar(8) NULL,
	note	varchar(20) NULL,
	CONSTRAINT z_flagid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_corres
(	id		int 		NOT NULL,
	pzlx	tinyint	NULL,
	kmdm1	varchar(20)	NULL,
	kmdm2	varchar(20) NULL,
	flag	tinyint	NULL,
	dat1	int		NULL,
	dat2	int		NULL,
	CONSTRAINT z_corresid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pzxm
(
	id			int NOT NULL,
	mon		tinyint NULL,
	pzlx		char(4) NULL,
	pzh		char(6) NULL,
	id2		smallint NULL,
	kmdm		varchar(20) NULL,
	proj		varchar(60) NULL,
	je			money NULL,
	j			money NULL,
	d			money NULL,
	sl			float NULL,
	dj			float NULL,
	wb			money NULL,
	hl			float NULL,
	def_str1 varchar(40) NULL,
	def_int1	int NULL,
	def_num1	money NULL,
	def_num2	money NULL,
	def_num3 money NULL,
	bmdm		varchar(20) NULL,
	CONSTRAINT z_pzxmid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_cnz
(
	id		int NOT NULL,
	kmdm	char(20) NULL,
	pzrq	smalldatetime NULL,
	pzlx	char(4) NULL,
	pzh	char(6) NULL,
	zy		varchar(60) NULL,
	j		money NULL,
	d		money NULL,
	ye		money NULL,
	dfkm	varchar(20) NULL,
	jsfs	tinyint NULL,
	jfrq	smalldatetime NULL,
	zphjsdjh	char(5) NULL,
	rjbz	char(1) NULL,
	qzr	varchar(8) NULL,
	bmdm	varchar(8) NULL,
	CONSTRAINT z_cnzid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_ys
(
	id			int NOT NULL,
	kmdm		varchar(20) NULL,
	kmstyle	char(1) NULL,
	dm			varchar(60) NULL,
	jfe01		money NULL,
	jfe02		money NULL,
	jfe03		money NULL,
	jfe04		money NULL,
	jfe05		money NULL,
	jfe06		money NULL,
	jfe07		money NULL,
	jfe08		money NULL,
	jfe09		money NULL,
	jfe10		money NULL,
	jfe11		money NULL,
	jfe12		money NULL,
	dfe01		money NULL,
	dfe02		money NULL,
	dfe03		money NULL,
	dfe04		money NULL,
	dfe05		money NULL,
	dfe06		money NULL,
	dfe07		money NULL,
	dfe08		money NULL,
	dfe09		money NULL,
	dfe10		money NULL,
	dfe11		money NULL,
	dfe12		money NULL,
	s1			char(2) NULL,
	s2			char(2) NULL,
	model_1	varchar(40) NULL,
	model_2	varchar(40) NULL,
	model_3	varchar(40) NULL,
	def_str1	varchar(200) NULL,
	def_str2	varchar(200) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_num1	money NULL,
	def_num2	money NULL,
	CONSTRAINT z_ysid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.bmwbhz
(
	dm		char(8) NOT NULL,
	kmdm	varchar(20) NOT NULL,
	wbdm	char(2) NULL,
	jhd		char(1) NULL,
	wbncye	money NULL,
	wbjlje	money NULL,
	wbdlje	money NULL,
	wbjfe01	money NULL,
	wbjfe02	money NULL,
	wbjfe03	money NULL,
	wbjfe04	money NULL,
	wbjfe05	money NULL,
	wbjfe06	money NULL,
	wbjfe07	money NULL,
	wbjfe08	money NULL,
	wbjfe09	money NULL,
	wbjfe10	money NULL,
	wbjfe11	money NULL,
	wbjfe12	money NULL,
	wbdfe01	money NULL,
	wbdfe02	money NULL,
	wbdfe03	money NULL,
	wbdfe04	money NULL,
	wbdfe05	money NULL,
	wbdfe06	money NULL,
	wbdfe07	money NULL,
	wbdfe08	money NULL,
	wbdfe09	money NULL,
	wbdfe10	money NULL,
	wbdfe11	money NULL,
	wbdfe12	money NULL,
	CONSTRAINT bmwbhz_id Primary KEY NONCLUSTERED (dm,kmdm)
);
CREATE TABLE dbo.z_xmlx
(
	dm				varchar(2) NOT NULL,
	mc				varchar(30) NULL,
	def_str1		varchar(32) NULL,
	def_str2		varchar(32) NULL,
	def_str3		varchar(32) NULL,
	def_str4		varchar(32) NULL,
	def_str5		varchar(32) NULL,
	def_str6		varchar(32) NULL,
	def_str7		varchar(32) NULL,
	def_str8		varchar(32) NULL,
	def_str9		varchar(32) NULL,
	def_str10	varchar(32) NULL,
	def_str11	varchar(32) NULL,
	def_str12	varchar(32) NULL,
	def_str13	varchar(32) NULL,
	def_str14	varchar(32) NULL,
	def_str15	varchar(32) NULL,
	def_str16	varchar(32) NULL,
	def_str17	varchar(32) NULL,
	def_str18	varchar(32) NULL,
	def_str19	varchar(32) NULL,
	def_str20	varchar(32) NULL,
	CONSTRAINT z_xmlxid Primary KEY NONCLUSTERED (dm)
);
CREATE TABLE dbo.z_xmht
(
	dm			varchar(60) NOT NULL,
	htbh		varchar(20) NOT NULL,
	htmc		varchar(30) NULL,
	htmemo	varchar(100) NULL,
	dt			smalldatetime NULL,
	dqh		char(4) NULL,
	dwdm		char(4) NULL,
	lxr		varchar(8) NULL,
	je			money NULL,
	realje	money NULL,
	jsfs		tinyint NULL,
	jsr		varchar(8) NULL,
	notes		varchar(100) NULL,
	s1			varchar(12) NULL,
	s2			varchar(12) NULL,
	CONSTRAINT z_xmhtid Primary KEY NONCLUSTERED (dm,htbh)
);
CREATE TABLE dbo.z_xmhtjd
(
	id			int NOT NULL,
	dm			varchar(60) NOT NULL,
	htbh		varchar(20) NOT NULL,
	num		tinyint NULL,
	dt			smalldatetime NULL,
	je			money NULL,
	paydt		smalldatetime NULL,
	payed		money NULL,
	billje	money NULL,
	notes		varchar(60) NULL,
	jsr		varchar(8) NULL,
	jsfs		tinyint NULL,
	pzrq		smalldatetime NULL,
	pzlx		char(4) NULL,
	pzh		char(6) NULL,
	CONSTRAINT z_xmhtjdid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_xmskjd
(
	id			int NOT NULL,
	dm			varchar(60) NOT NULL,
	htbh		varchar(20) NOT NULL,
	num		tinyint NULL,
	dt			smalldatetime NULL,
	je			money NULL,
	paydt		smalldatetime NULL,
	payed		money NULL,
	billje	money NULL,
	notes		varchar(60) NULL,
	jsr		varchar(8) NULL,
	jsfs		tinyint NULL,
	pzrq		smalldatetime NULL,
	pzlx		char(4) NULL,
	pzh		char(6) NULL,
	CONSTRAINT z_xmskjdid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_xmsb
(
	id			int NOT NULL,
	dm			varchar(60)	NOT NULL,
	htbh		varchar(20)	NOT NULL,
	kph		varchar(20) NULL,
	mc			varchar(30) NULL,
	serial	varchar(15) NULL,
	gg			varchar(16) NULL,
	addr		varchar(20) NULL,
	bm			varchar(8) NULL,
	dw			varchar(6) NULL,
	prod		varchar(16) NULL,
	ly			varchar(10) NULL,
	num		int NULL,
	state		tinyint NULL,
	yz			money NULL,
	ljzj		money NULL,
	yjcz		money NULL,
	yzjl		money NULL,
	yzje		money NULL,
	czl		money NULL,
	yj_years	tinyint NULL,
	dt			smalldatetime NULL,
	dt1		smalldatetime NULL,
	dt2		smalldatetime NULL,
	yy_mons	smallint NULL,
	CONSTRAINT z_xmsbid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_tran
(
	id		int NOT NULL,
	kmdm	varchar(20) NULL,
	kmmc	varchar(40) NULL,
	style	char(1) NULL,
	dm		varchar(12) NULL,
	j		money NULL,
	d		money NULL,
	pzrq	smalldatetime NULL,
	pzlx	char(4) NULL,
	pzh	char(6) NULL,
	mon	tinyint NULL,
	dzbz	char(1) NULL,
	CONSTRAINT z_tranid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.z_pzdl
(
	id		int NOT NULL,
	mon	tinyint NULL,
	jzbz	tinyint NULL,
	pzrq	smalldatetime NULL,
	pzlx	char(4) NULL,
	pzh	char(6) NULL,
	fj		smallint NULL,
	zy		varchar(60) NULL,
	kmdm	varchar(20) NULL,
	j		money NULL,
	d		money NULL,
	zphjsdjh		varchar(20) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	money NULL,
	hl		float NULL,
	dqh	varchar(4) NULL,
	gg		varchar(30) NULL,
	sl		float NULL,
	dj		float NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	jzy	varchar(8) NULL,
	id1	int	NULL,
	id2	int	NULL,
	proj	varchar(60) NULL,
	hm		varchar(12) NULL,
	hm2	varchar(20) NULL,
	hbxx	varchar(10) NULL,
	htbh	varchar(20) NULL,
	htnum	tinyint NULL,
	scrq	smalldatetime NULL,
	scr	varchar(8) NULL,
	cny	varchar(8) NULL,
	def_str1	varchar(64) NULL,
	def_str2	varchar(64) NULL,
	CONSTRAINT z_pzdlid Primary KEY NONCLUSTERED (id)
);
CREATE TABLE dbo.pzlxzdy
(
	dm		char(4) NOT NULL ,
	mc		varchar(6) NOT NULL ,
	jfby	varchar(100) NULL ,
	dfby	varchar(100) NULL ,
	pzby	varchar(100) NULL ,
	jfbw	varchar(100) NULL ,
	dfbw	varchar(100) NULL ,
	pzbw	varchar(100) NULL ,
	CONSTRAINT pzlxzdyid Primary KEY NONCLUSTERED (dm)
);

CREATE TABLE dbo.z_lhdw
(
	dwdm		varchar(6) NOT NULL,
	dwmc		varchar(60) NULL,
	fzr		varchar(12) NULL,
	addr		varchar(60) NULL,
	lxr		varchar(12) NULL,
	tele		varchar(12) NULL,
	khh		varchar(50) NULL,
	zh			varchar(30) NULL,
	zth		varchar(4) NULL,
	ckkm		varchar(20) NULL,
	ztckkm	varchar(20) NULL,
	def_str1	varchar(30) NULL,
	def_str2	varchar(30) NULL,
	def_str3	varchar(30) NULL,
	def_str4	varchar(30) NULL,
	def_str5	varchar(30) NULL,
	def_str6	varchar(64) NULL,
	def_str7	varchar(64) NULL,
	def_str8	varchar(64) NULL,
	def_str9	varchar(64) NULL,
	def_str10	varchar(64) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_int3	int NULL,
	def_int4	int NULL,
	def_int5 int NULL,
	def_dt1	smalldatetime NULL,
	def_dt2	smalldatetime NULL,
	CONSTRAINT z_lhdwid Primary KEY NONCLUSTERED (dwdm)
);

CREATE TABLE dbo.z_zhcx
(
	id			int NOT NULL ,
	xmdm		varchar(20)	NULL,
	xmmc		varchar(50)	NULL,
	bz			varchar(50) NULL,
	dwdm		varchar(10)	NULL,
	kmdm		varchar(64)	NULL,
	def_str1	varchar(64)	NULL,
	def_str2	varchar(64) NULL,
	def_str3	varchar(64) NULL,
	def_int1	int NULL,
	def_int2	int NULL,
	def_int3	int NULL,
	def_num1	int NULL,
	def_num2	money NULL,
	def_num3	money NULL,
	def_date1	smalldatetime NULL ,
	def_date2	smalldatetime NULL ,
	CONSTRAINT z_zhcxid Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.z_jtysxx
(
    id          int               NOT NULL,
    unit_code   varchar(20)               NULL,
    item_code   varchar(20)               NULL,
    kind_code   varchar(10)               NULL,
    year_       int                   NULL,
    sign_       char(1)                   NULL,
    status_     varchar(14)               NULL,
    isflags     int                   NULL,
    remark      varchar(250)              NULL,
    do_time     smalldatetime                  NULL,
    do_man      varchar(20)               NULL,
    ok_man      varchar(20)               NULL,
    send_man    varchar(20)               NULL,
    debit01     money             NULL,
    debit02     money             NULL,
    debit03     money             NULL,
    debit04     money             NULL,
    debit05     money             NULL,
    debit06     money             NULL,
    debit07     money             NULL,
    debit08     money             NULL,
    debit09     money             NULL,
    debit10     money             NULL,
    debit11     money             NULL,
    debit12     money             NULL,
    debit13     money             NULL,
    debit14     money             NULL,
    credit01    money             NULL,
    credit02    money             NULL,
    credit03    money             NULL,
    credit04    money             NULL,
    credit05    money             NULL,
    credit06    money             NULL,
    credit07    money             NULL,
    credit08    money             NULL,
    credit09    money             NULL,
    credit10    money             NULL,
    credit11    money             NULL,
    credit12    money             NULL,
    credit13    money             NULL,
    credit14    money             NULL,
    ok_debit01  money             NULL,
    ok_debit02  money             NULL,
    ok_debit03  money             NULL,
    ok_debit04  money             NULL,
    ok_debit05  money             NULL,
    ok_debit06  money             NULL,
    ok_debit07  money             NULL,
    ok_debit08  money             NULL,
    ok_debit09  money             NULL,
    ok_debit10  money             NULL,
    ok_debit11  money             NULL,
    ok_debit12  money             NULL,
    ok_debit13  money             NULL,
    ok_debit14  money             NULL,
    ok_cred01   money             NULL,
    ok_cred02   money             NULL,
    ok_cred03   money             NULL,
    ok_cred04   money             NULL,
    ok_cred05   money             NULL,
    ok_cred06   money             NULL,
    ok_cred07   money             NULL,
    ok_cred08   money             NULL,
    ok_cred09   money             NULL,
    ok_cred10   money             NULL,
    ok_cred11   money             NULL,
    ok_cred12   money             NULL,
    ok_cred13   money             NULL,
    ok_cred14   money             NULL,
    def_str1    varchar(64)               NULL,
    def_str2    varchar(64)               NULL,
    def_str3    varchar(64)               NULL,
    def_num1    numeric(18,6)             NULL,
    def_num2    numeric(18,6)             NULL,
    def_num3    numeric(18,6)             NULL,
    def_date1   smalldatetime                  NULL,
    def_date2   smalldatetime                  NULL,
   CONSTRAINT z_jtysxxid Primary KEY NONCLUSTERED (id)
 );


CREATE TABLE dbo.z_jtyslx
(
    code_       varchar(10)           NOT NULL,
    name_       varchar(50)               NULL,
    remark      varchar(250)              NULL,
    CONSTRAINT z_jtyslxcode_ Primary KEY NONCLUSTERED (code_)
);


CREATE TABLE dbo.z_jtysxm
(
    item_code   varchar(20)           NOT NULL,
    item_name   varchar(50)               NULL,
    remark      varchar(250)              NULL,
    CONSTRAINT  z_jtysxmitem_code primary key NONCLUSTERED (item_code)
);


CREATE TABLE dbo.z_jtdb
(
    id          int               NOT NULL,
    servname    varchar(40)               NULL,
    unit_no     varchar(10)               NULL,
    dbms_       varchar(40)               NULL,
    ng_pass     varchar(40)               NULL,
    userid_     varchar(40)               NULL,
    dbpass_     varchar(40)               NULL,
    dbparm_     varchar(40)               NULL,
    unit_code   varchar(40)               NULL,
    def_str1    varchar(64)               NULL,
    def_str2    varchar(64)               NULL,
    def_str3    varchar(64)               NULL,
   CONSTRAINT z_jbdbid primary key NONCLUSTERED (id)
);

create table dbo.dz_init
(
    code         char(20)                     NOT NULL ,
    dz_name         varchar(50)                   NULL,
    a_km         varchar(50)                   NULL,
    a_direct     char(1)                       NULL,
    b_km         varchar(50)                   NULL,
    b_direct     char(1)                       NULL,
    abrelation  varchar(100)                  NULL,
    dz_ver       char(20)                      NULL,
    customer_1   varchar(50)                   NULL,
    customer_2   varchar(50)                   NULL,
    customer_3   varchar(50)                   NULL,
   CONSTRAINT  z_dzinit_code primary key NONCLUSTERED (code)
);

CREATE TABLE dbo.z_bbook
(id			int NOT NULL,
 p_dt			smalldatetime NULL,
 yhdm			varchar(4) NULL,
 yhmc			varchar(60) NULL,
 s_num		varchar(30) NULL,
 e_num		varchar(30) NULL,
 bills		int NULL,
 def_str1	varchar(60) NULL,
 def_str2	varchar(60) NULL,
 def_str3	varchar(60) NULL,
 def_str4	varchar(60) NULL,
 def_str5	varchar(60) NULL,
 def_int1	int NULL,
 def_int2	int NULL,
 def_int3	int NULL,
 def_int4	int NULL,
 def_int5	int NULL,
CONSTRAINT z_bbookid Primary KEY NONCLUSTERED (id)
);

CREATE TABLE dbo.z_wlhxkz
(hxid			int NOT NULL,
 dwwlid		int NOT NULL,
 j_hx			money NULL,
 d_hx			money  NULL,
 hxrq			smalldatetime  NULL,
 hxr			varchar(20) NULL,
 dqh			varchar(4) NULL,
 dwdm			varchar(4) NULL,
 kmdm			varchar(20) NULL,
 def_str1	varchar(64) NULL,
 def_str2	varchar(64) NULL,
 def_int1	int NULL,
 def_int2	int NULL,
 def_num1	money  NULL,
 def_num2	money	 NULL,
 def_dt1		smalldatetime NULL,
 def_dt2		smalldatetime NULL,
 CONSTRAINT z_wlhxkzid Primary KEY NONCLUSTERED (hxid,dwwlid)
);

[CREATE PROCEDURE]
drop procedure dbo.sp_selectpz;
create procedure dbo.sp_selectpz
 @mon int,@pzlx char(1),@pzh char(4)
 AS
 if @mon=1
 begin
 select z_pz01.pzrq,z_pz01.pzlx,z_pz01.pzh,z_pz01.fj,z_pz01.zy,
z_pz01.kmdm,km.kmmc,z_pz01.j,z_pz01.d,z_pz01.zphjsdjh,z_pz01.shy,
z_pz01.zdy,z_pz01.czy,z_pz01.shbz,z_pz01.wbje,z_pz01.hl,z_pz01.dqh,
z_pz01.gg,z_pz01.sl,z_pz01.dj,z_pz01.dwdm,z_pz01.lxr,z_pz01.jsr,
km.kmxz,z_pz01.jzbz,z_pz01.bmry,km.bm,z_pz01.id,km.kmlb,z_pz01.jzy,
z_pz01.hm,z_pz01.proj
 from z_pz01,km where pzlx=@pzlx and pzh=@pzh and z_pz01.kmdm=km.kmdm
 return
 end

 if @mon=2
 begin
 select z_pz02.pzrq,z_pz02.pzlx,z_pz02.pzh,z_pz02.fj,z_pz02.zy,
z_pz02.kmdm,km.kmmc,z_pz02.j,z_pz02.d,z_pz02.zphjsdjh,z_pz02.shy,
z_pz02.zdy,z_pz02.czy,z_pz02.shbz,z_pz02.wbje,z_pz02.hl,z_pz02.dqh,
z_pz02.gg,z_pz02.sl,z_pz02.dj,z_pz02.dwdm,z_pz02.lxr,z_pz02.jsr,
km.kmxz,z_pz02.jzbz,z_pz02.bmry,km.bm,z_pz02.id,km.kmlb,z_pz02.jzy,
z_pz02.hm,z_pz02.proj
 from z_pz02,km where pzlx=@pzlx and pzh=@pzh and z_pz02.kmdm=km.kmdm
 return
 end

 if @mon=3
 begin
 select z_pz03.pzrq,z_pz03.pzlx,z_pz03.pzh,z_pz03.fj,z_pz03.zy,
z_pz03.kmdm,km.kmmc,z_pz03.j,z_pz03.d,z_pz03.zphjsdjh,z_pz03.shy,
z_pz03.zdy,z_pz03.czy,z_pz03.shbz,z_pz03.wbje,z_pz03.hl,z_pz03.dqh,
z_pz03.gg,z_pz03.sl,z_pz03.dj,z_pz03.dwdm,z_pz03.lxr,z_pz03.jsr,
km.kmxz,z_pz03.jzbz,z_pz03.bmry,km.bm,z_pz03.id,km.kmlb,z_pz03.jzy,
z_pz03.hm,z_pz03.proj
 from z_pz03,km where pzlx=@pzlx and pzh=@pzh and z_pz03.kmdm=km.kmdm
 return
 end

 if @mon=4
 begin
 select z_pz04.pzrq,z_pz04.pzlx,z_pz04.pzh,z_pz04.fj,z_pz04.zy,
z_pz04.kmdm,km.kmmc,z_pz04.j,z_pz04.d,z_pz04.zphjsdjh,z_pz04.shy,
z_pz04.zdy,z_pz04.czy,z_pz04.shbz,z_pz04.wbje,z_pz04.hl,z_pz04.dqh,
z_pz04.gg,z_pz04.sl,z_pz04.dj,z_pz04.dwdm,z_pz04.lxr,z_pz04.jsr,
km.kmxz,z_pz04.jzbz,z_pz04.bmry,km.bm,z_pz04.id,km.kmlb,z_pz04.jzy,
z_pz04.hm,z_pz04.proj
 from z_pz04,km where pzlx=@pzlx and pzh=@pzh and z_pz04.kmdm=km.kmdm
 return
 end

 if @mon=5
 begin
 select z_pz05.pzrq,z_pz05.pzlx,z_pz05.pzh,z_pz05.fj,z_pz05.zy,
z_pz05.kmdm,km.kmmc,z_pz05.j,z_pz05.d,z_pz05.zphjsdjh,z_pz05.shy,
z_pz05.zdy,z_pz05.czy,z_pz05.shbz,z_pz05.wbje,z_pz05.hl,z_pz05.dqh,
z_pz05.gg,z_pz05.sl,z_pz05.dj,z_pz05.dwdm,z_pz05.lxr,z_pz05.jsr,
km.kmxz,z_pz05.jzbz,z_pz05.bmry,km.bm,z_pz05.id,km.kmlb,z_pz05.jzy,
z_pz05.hm,z_pz05.proj
 from z_pz05,km where pzlx=@pzlx and pzh=@pzh and z_pz05.kmdm=km.kmdm
 return
 end

 if @mon=6
 begin
 select z_pz06.pzrq,z_pz06.pzlx,z_pz06.pzh,z_pz06.fj,z_pz06.zy,
z_pz06.kmdm,km.kmmc,z_pz06.j,z_pz06.d,z_pz06.zphjsdjh,z_pz06.shy,
z_pz06.zdy,z_pz06.czy,z_pz06.shbz,z_pz06.wbje,z_pz06.hl,z_pz06.dqh,
z_pz06.gg,z_pz06.sl,z_pz06.dj,z_pz06.dwdm,z_pz06.lxr,z_pz06.jsr,
km.kmxz,z_pz06.jzbz,z_pz06.bmry,km.bm,z_pz06.id,km.kmlb,z_pz06.jzy,
z_pz06.hm,z_pz06.proj
 from z_pz06,km where pzlx=@pzlx and pzh=@pzh and z_pz06.kmdm=km.kmdm
 return
 end

 if @mon=7
 begin
 select z_pz07.pzrq,z_pz07.pzlx,z_pz07.pzh,z_pz07.fj,z_pz07.zy,
z_pz07.kmdm,km.kmmc,z_pz07.j,z_pz07.d,z_pz07.zphjsdjh,z_pz07.shy,
z_pz07.zdy,z_pz07.czy,z_pz07.shbz,z_pz07.wbje,z_pz07.hl,z_pz07.dqh,
z_pz07.gg,z_pz07.sl,z_pz07.dj,z_pz07.dwdm,z_pz07.lxr,z_pz07.jsr,
km.kmxz,z_pz07.jzbz,z_pz07.bmry,km.bm,z_pz07.id,km.kmlb,z_pz07.jzy,
z_pz07.hm,z_pz07.proj
 from z_pz07,km where pzlx=@pzlx and pzh=@pzh and z_pz07.kmdm=km.kmdm
 return
 end

 if @mon=8
 begin
 select z_pz08.pzrq,z_pz08.pzlx,z_pz08.pzh,z_pz08.fj,z_pz08.zy,
z_pz08.kmdm,km.kmmc,z_pz08.j,z_pz08.d,z_pz08.zphjsdjh,z_pz08.shy,
z_pz08.zdy,z_pz08.czy,z_pz08.shbz,z_pz08.wbje,z_pz08.hl,z_pz08.dqh,
z_pz08.gg,z_pz08.sl,z_pz08.dj,z_pz08.dwdm,z_pz08.lxr,z_pz08.jsr,
km.kmxz,z_pz08.jzbz,z_pz08.bmry,km.bm,z_pz08.id,km.kmlb,z_pz08.jzy,
z_pz08.hm,z_pz08.proj
 from z_pz08,km where pzlx=@pzlx and pzh=@pzh and z_pz08.kmdm=km.kmdm
 return
 end

 if @mon=9
 begin
 select z_pz09.pzrq,z_pz09.pzlx,z_pz09.pzh,z_pz09.fj,z_pz09.zy,
z_pz09.kmdm,km.kmmc,z_pz09.j,z_pz09.d,z_pz09.zphjsdjh,z_pz09.shy,
z_pz09.zdy,z_pz09.czy,z_pz09.shbz,z_pz09.wbje,z_pz09.hl,z_pz09.dqh,
z_pz09.gg,z_pz09.sl,z_pz09.dj,z_pz09.dwdm,z_pz09.lxr,z_pz09.jsr,
km.kmxz,z_pz09.jzbz,z_pz09.bmry,km.bm,z_pz09.id,km.kmlb,z_pz09.jzy,
z_pz09.hm,z_pz09.proj
 from z_pz09,km where pzlx=@pzlx and pzh=@pzh and z_pz09.kmdm=km.kmdm
 return
 end

 if @mon=10
 begin
 select z_pz10.pzrq,z_pz10.pzlx,z_pz10.pzh,z_pz10.fj,z_pz10.zy,
z_pz10.kmdm,km.kmmc,z_pz10.j,z_pz10.d,z_pz10.zphjsdjh,z_pz10.shy,
z_pz10.zdy,z_pz10.czy,z_pz10.shbz,z_pz10.wbje,z_pz10.hl,z_pz10.dqh,
z_pz10.gg,z_pz10.sl,z_pz10.dj,z_pz10.dwdm,z_pz10.lxr,z_pz10.jsr,
km.kmxz,z_pz10.jzbz,z_pz10.bmry,km.bm,z_pz10.id,km.kmlb,z_pz10.jzy,
z_pz10.hm,z_pz10.proj
 from z_pz10,km where pzlx=@pzlx and pzh=@pzh and z_pz10.kmdm=km.kmdm
 return
 end

 if @mon=11
 begin
 select z_pz11.pzrq,z_pz11.pzlx,z_pz11.pzh,z_pz11.fj,z_pz11.zy,
z_pz11.kmdm,km.kmmc,z_pz11.j,z_pz11.d,z_pz11.zphjsdjh,z_pz11.shy,
z_pz11.zdy,z_pz11.czy,z_pz11.shbz,z_pz11.wbje,z_pz11.hl,z_pz11.dqh,
z_pz11.gg,z_pz11.sl,z_pz11.dj,z_pz11.dwdm,z_pz11.lxr,z_pz11.jsr,
km.kmxz,z_pz11.jzbz,z_pz11.bmry,km.bm,z_pz11.id,km.kmlb,z_pz11.jzy,
z_pz11.hm,z_pz11.proj
 from z_pz11,km where pzlx=@pzlx and pzh=@pzh and z_pz11.kmdm=km.kmdm
 return
 end

 if @mon=12
 begin
 select z_pz12.pzrq,z_pz12.pzlx,z_pz12.pzh,z_pz12.fj,z_pz12.zy,
z_pz12.kmdm,km.kmmc,z_pz12.j,z_pz12.d,z_pz12.zphjsdjh,z_pz12.shy,
z_pz12.zdy,z_pz12.czy,z_pz12.shbz,z_pz12.wbje,z_pz12.hl,z_pz12.dqh,
z_pz12.gg,z_pz12.sl,z_pz12.dj,z_pz12.dwdm,z_pz12.lxr,z_pz12.jsr,
km.kmxz,z_pz12.jzbz,z_pz12.bmry,km.bm,z_pz12.id,km.kmlb,z_pz12.jzy,
z_pz12.hm,z_pz12.proj
 from z_pz12,km where pzlx=@pzlx and pzh=@pzh and z_pz12.kmdm=km.kmdm
 return
 end
;

[CREATE INDEX]
drop index z_bank.z_bankid;
drop index anyobj.objmsg;
DROP INDEX bmhz.bmhzkmdm;
DROP INDEX z_projkm.z_projkm;
DROP INDEX z_qxkm.z_qxkmxm;
DROP INDEX z_proj.z_projdm;
DROP INDEX z_yspz.z_yspzrq;
DROP INDEX z_qy.z_qy_kmdm;
DROP INDEX z_yh.z_yh_kmdm;
DROP INDEX dwtx.dwtx_dqh;
DROP INDEX dwtx.dwtx_dwdm;
DROP INDEX z_auto.z_auto_num;
DROP INDEX z_dwwl.z_dwwl_dd;
DROP INDEX z_grwl.z_grwl_bmxm;
DROP INDEX z_dwwl.z_dwwl_mon;
DROP INDEX z_dwwl.z_dwwl_kmdm;
DROP INDEX z_grwl.z_grwl_mon;
DROP INDEX z_grwl.z_grwl_kmdm;
DROP INDEX km.km_jm;
DROP INDEX z_kmtemp.z_kmtmp_xz;
DROP INDEX z_pz01.z_pz01pzrq;
DROP INDEX z_pz01.z_pz01kmdm;
DROP INDEX z_pz01.z_pz01comp;
DROP INDEX z_pz02.z_pz02pzrq;
DROP INDEX z_pz02.z_pz02kmdm;
DROP INDEX z_pz02.z_pz02comp;
DROP INDEX z_pz03.z_pz03pzrq;
DROP INDEX z_pz03.z_pz03kmdm;
DROP INDEX z_pz03.z_pz03comp;
DROP INDEX z_pz04.z_pz04pzrq;
DROP INDEX z_pz04.z_pz04kmdm;
DROP INDEX z_pz04.z_pz04comp;
DROP INDEX z_pz05.z_pz05pzrq;
DROP INDEX z_pz05.z_pz05kmdm;
DROP INDEX z_pz05.z_pz05comp;
DROP INDEX z_pz06.z_pz06pzrq;
DROP INDEX z_pz06.z_pz06kmdm;
DROP INDEX z_pz06.z_pz06comp;
DROP INDEX z_pz07.z_pz07pzrq;
DROP INDEX z_pz07.z_pz07kmdm;
DROP INDEX z_pz07.z_pz07comp;
DROP INDEX z_pz08.z_pz08pzrq;
DROP INDEX z_pz08.z_pz08kmdm;
DROP INDEX z_pz08.z_pz08comp;
DROP INDEX z_pz09.z_pz09pzrq;
DROP INDEX z_pz09.z_pz09kmdm;
DROP INDEX z_pz09.z_pz09comp;
DROP INDEX z_pz10.z_pz10pzrq;
DROP INDEX z_pz10.z_pz10kmdm;
DROP INDEX z_pz10.z_pz10comp;
DROP INDEX z_pz11.z_pz11pzrq;
DROP INDEX z_pz11.z_pz11kmdm;
DROP INDEX z_pz11.z_pz11comp;
DROP INDEX z_pz12.z_pz12pzrq;
DROP INDEX z_pz12.z_pz12kmdm;
DROP INDEX z_pz12.z_pz12comp;
DROP INDEX z_xmhtjd.z_xmhtjddm;
DROP INDEX z_xmskjd.z_xmskjddm;
DROP INDEX z_xmsb.z_xmsbdm;
DROP INDEX z_pz01.z_pz01pzh;
DROP INDEX z_pz02.z_pz02pzh;
DROP INDEX z_pz03.z_pz03pzh;
DROP INDEX z_pz04.z_pz04pzh;
DROP INDEX z_pz05.z_pz05pzh;
DROP INDEX z_pz06.z_pz06pzh;
DROP INDEX z_pz07.z_pz07pzh;
DROP INDEX z_pz08.z_pz08pzh;
DROP INDEX z_pz09.z_pz09pzh;
DROP INDEX z_pz10.z_pz10pzh;
DROP INDEX z_pz11.z_pz11pzh;
DROP INDEX z_pz12.z_pz12pzh;
DROP INDEX z_dz.z_dzid;

CREATE UNIQUE INDEX z_bankid	ON dbo.z_bank	( kmdm,bmry );
CREATE UNIQUE INDEX z_dzid	ON dbo.z_dz	( kmdm,dzrq );
CREATE INDEX bmhzkmdm	ON dbo.bmhz		( kmdm );
CREATE INDEX z_auto_num	ON dbo.z_auto	(	num );
CREATE INDEX z_dwwl_dd	ON dbo.z_dwwl	(	dqh ,	dwdm );
CREATE INDEX z_grwl_bmxm	ON dbo.z_grwl	(	bm  ,	xm );
CREATE INDEX z_pz01comp ON dbo.z_pz01	(	pzlx,pzh );
CREATE INDEX z_pz02comp ON dbo.z_pz02	(	pzlx,pzh );
CREATE INDEX z_pz03comp ON dbo.z_pz03	(	pzlx,pzh );
CREATE INDEX z_pz04comp ON dbo.z_pz04	(	pzlx,pzh );
CREATE INDEX z_pz05comp ON dbo.z_pz05	(	pzlx,pzh );
CREATE INDEX z_pz06comp ON dbo.z_pz06	(	pzlx,pzh );
CREATE INDEX z_pz07comp ON dbo.z_pz07	(	pzlx,pzh );
CREATE INDEX z_pz08comp ON dbo.z_pz08	(	pzlx,pzh );
CREATE INDEX z_pz09comp ON dbo.z_pz09	(	pzlx,pzh );
CREATE INDEX z_pz10comp ON dbo.z_pz10	(	pzlx,pzh );
CREATE INDEX z_pz11comp ON dbo.z_pz11	(	pzlx,pzh );
CREATE INDEX z_pz12comp ON dbo.z_pz12	(	pzlx,pzh );
create index objmsg 		on dbo.anyobj (anydwid);
CREATE INDEX z_projkm	ON dbo.z_projkm	( dm );
CREATE INDEX z_qxkmxm	ON dbo.z_qxkm	( xm );
CREATE INDEX z_projdm	ON dbo.z_proj	(	dm );
CREATE INDEX z_yspzrq	ON dbo.z_yspz	(	pzrq );
CREATE INDEX z_qy_kmdm	ON dbo.z_qy		(	kmdm );
CREATE INDEX z_yh_kmdm	ON dbo.z_yh		(	kmdm );
CREATE INDEX dwtx_dqh	ON dbo.dwtx		(	dqh );
CREATE INDEX dwtx_dwdm	ON dbo.dwtx		(	dwdm );
CREATE INDEX z_dwwl_mon	ON dbo.z_dwwl	(	mon );
CREATE INDEX z_dwwl_kmdm	ON dbo.z_dwwl	(	kmdm );
CREATE INDEX z_grwl_mon	ON dbo.z_grwl	(	mon );
CREATE INDEX z_grwl_kmdm	ON dbo.z_grwl	(	kmdm );
CREATE INDEX km_jm		ON dbo.km		(	jm );
CREATE INDEX z_kmtmp_xz ON dbo.z_kmtemp	(	kmxz );
CREATE INDEX z_pz01pzrq ON dbo.z_pz01	(	pzrq );
CREATE INDEX z_pz01kmdm ON dbo.z_pz01	(	kmdm );
CREATE INDEX z_pz02pzrq ON dbo.z_pz02	(	pzrq );
CREATE INDEX z_pz02kmdm ON dbo.z_pz02	(	kmdm );
CREATE INDEX z_pz03pzrq ON dbo.z_pz03	(	pzrq );
CREATE INDEX z_pz03kmdm ON dbo.z_pz03	(	kmdm );
CREATE INDEX z_pz04pzrq ON dbo.z_pz04	(	pzrq );
CREATE INDEX z_pz04kmdm ON dbo.z_pz04	(	kmdm );
CREATE INDEX z_pz05pzrq ON dbo.z_pz05	(	pzrq );
CREATE INDEX z_pz05kmdm ON dbo.z_pz05	(	kmdm );
CREATE INDEX z_pz06pzrq ON dbo.z_pz06	(	pzrq );
CREATE INDEX z_pz06kmdm ON dbo.z_pz06	(	kmdm );
CREATE INDEX z_pz07pzrq ON dbo.z_pz07	(	pzrq );
CREATE INDEX z_pz07kmdm ON dbo.z_pz07	(	kmdm );
CREATE INDEX z_pz08pzrq ON dbo.z_pz08	(	pzrq );
CREATE INDEX z_pz08kmdm ON dbo.z_pz08	(	kmdm );
CREATE INDEX z_pz09pzrq ON dbo.z_pz09	(	pzrq );
CREATE INDEX z_pz09kmdm ON dbo.z_pz09	(	kmdm );
CREATE INDEX z_pz10pzrq ON dbo.z_pz10	(	pzrq );
CREATE INDEX z_pz10kmdm ON dbo.z_pz10	(	kmdm );
CREATE INDEX z_pz11pzrq ON dbo.z_pz11	(	pzrq );
CREATE INDEX z_pz11kmdm ON dbo.z_pz11	(	kmdm );
CREATE INDEX z_pz12pzrq ON dbo.z_pz12	(	pzrq );
CREATE INDEX z_pz12kmdm ON dbo.z_pz12	(	kmdm );
CREATE INDEX z_xmhtjddm ON dbo.z_xmhtjd	(dm,htbh) ;
CREATE INDEX z_xmskjddm ON dbo.z_xmskjd	(dm,htbh) ;
CREATE INDEX z_xmsbdm	ON dbo.z_xmsb		(dm,htbh) ;
CREATE INDEX z_pz01pzh	ON dbo.z_pz01	( pzh ) ;
CREATE INDEX z_pz02pzh	ON dbo.z_pz02	( pzh ) ;
CREATE INDEX z_pz03pzh	ON dbo.z_pz03	( pzh ) ;
CREATE INDEX z_pz04pzh	ON dbo.z_pz04	( pzh ) ;
CREATE INDEX z_pz05pzh	ON dbo.z_pz05	( pzh ) ;
CREATE INDEX z_pz06pzh	ON dbo.z_pz06	( pzh ) ;
CREATE INDEX z_pz07pzh	ON dbo.z_pz07	( pzh ) ;
CREATE INDEX z_pz08pzh	ON dbo.z_pz08	( pzh ) ;
CREATE INDEX z_pz09pzh	ON dbo.z_pz09	( pzh ) ;
CREATE INDEX z_pz10pzh	ON dbo.z_pz10	( pzh ) ;
CREATE INDEX z_pz11pzh	ON dbo.z_pz11	( pzh ) ;
CREATE INDEX z_pz12pzh	ON dbo.z_pz12	( pzh ) ;
