[CREATE TABLE]
CREATE TABLE kc_def
(	id      INTEGER NOT NULL,
	title	VARCHAR(30),
	def	VARCHAR(100),
PRIMARY KEY (id)
);

CREATE TABLE kc_chlb
(	dm		INTEGER NOT NULL,
	mc		VARCHAR(12),
	bz		VARCHAR(1),
PRIMARY KEY (dm)
);

CREATE TABLE kc_yt
(	dm		VARCHAR(4) NOT NULL ,
	mc		VARCHAR(12),
	bz		VARCHAR(1),
	route VARCHAR(128),
	multiple NUMERIC(18,6),
PRIMARY KEY (dm)
);

CREATE TABLE kc_jsfs
(	dm		INTEGER NOT NULL,
	jsfs	        VARCHAR(12),
PRIMARY KEY (dm)
);

CREATE TABLE kc_ck
(	dm		VARCHAR(2) NOT NULL ,
	mc		VARCHAR(12),
   prop		  smallint,
   prio		  varchar(2),
   def_num1	  integer,
   def_str1	  varchar(8),
   PRIMARY KEY (dm)
);

CREATE TABLE kc_kw
(	ckdm	        VARCHAR(2) NOT NULL,
	dm		VARCHAR(30) NOT NULL,
	mc		VARCHAR(50),
PRIMARY KEY (ckdm,dm)
);

CREATE TABLE kc_bm
(	dm		VARCHAR(8) NOT NULL,
	mc		VARCHAR(16) ,
  def_str1   varchar(8),
 def_str2   varchar(30),
PRIMARY KEY (dm)
);

CREATE TABLE kc_ly
(	dm		VARCHAR(4) NOT NULL,
	mc		VARCHAR(12),
	bz		VARCHAR(1),
	route VARCHAR(128),
	multiple NUMERIC(18,6),
PRIMARY KEY (dm)
);

CREATE TABLE kc_ff
(	id	INTEGER NOT NULL,
	mc	VARCHAR(16) ,
PRIMARY KEY (id)
);

CREATE TABLE kc_xeset
(	id	VARCHAR(6) NOT NULL ,
	num	INTEGER NOT NULL,
	nums	VARCHAR(30),
	smon	VARCHAR(2) ,
	pzh	VARCHAR(4),
	ckpzh	VARCHAR(6),
	dm	VARCHAR(20) ,
	ytdm	VARCHAR(4) ,
	bmdm	VARCHAR(8) ,
	dfkm	VARCHAR(12) ,
	ckdm	VARCHAR(2) ,
	dt	DATE,
	zy	VARCHAR(30) ,
	sl	numeric(18,6),
	used	numeric(18,6),
	def_num1		numeric(18,6),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id,num)
);

CREATE TABLE kc_qx
(	xm VARCHAR(8) NOT NULL ,
	mm VARCHAR(254) ,
	bm VARCHAR(14) ,
	q0 SMALLINT ,
	q1 SMALLINT ,
	q2 SMALLINT ,
	q3 SMALLINT ,
	q4 SMALLINT ,
	q5 SMALLINT ,
	q6 SMALLINT ,
	q7 SMALLINT ,
	q8 SMALLINT ,
	q9 SMALLINT ,
	q10 SMALLINT ,
	q11 SMALLINT ,
	q12 SMALLINT ,
	q13 SMALLINT ,
	q14 SMALLINT ,
	q15 SMALLINT ,
	q16 SMALLINT ,
PRIMARY KEY (xm)
);

CREATE TABLE kc_ckqx
(	xm	VARCHAR(8) NOT NULL,
	ckqx	VARCHAR(2) NOT NULL,
PRIMARY KEY (xm,ckqx)
);

CREATE TABLE kc_pz
(	id	INTEGER NOT NULL,
	spp	VARCHAR(7) ,
	jzbz	SMALLINT ,
	pzrq	date ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	fj	INTEGER ,
	zy	VARCHAR(60) ,
	kmdm	VARCHAR(20) ,
	j	numeric(18,6) ,
	d	numeric(18,6) ,
	zphjsdjh VARCHAR(20) ,
	shy	VARCHAR(8) ,
	zdy	VARCHAR(8) ,
	czy	VARCHAR(8) ,
	shbz	SMALLINT ,
	wbje	numeric(18,6) ,
	hl	numeric(18,6) ,
	dqh	VARCHAR(4) ,
	gg	VARCHAR(50) ,
	sl	numeric(18,6),
	dj	numeric(18,6) ,
	dwdm	VARCHAR(4) ,
	lxr	VARCHAR(8) ,
	jsr	VARCHAR(8) ,
	bmry	VARCHAR(8) ,
	id1	INTEGER ,
	id2	INTEGER,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx01
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx02
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx03
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx04
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx05
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx06
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx07
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx08
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx09
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx10
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx11
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_mx12
(	id	VARCHAR(6) NOT NULL,
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	dm	VARCHAR(20) ,
	sl	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je	numeric(18,6) ,
	je_j	numeric(18,6) ,
	yzf	numeric(18,6) ,
	jzbz	SMALLINT ,
	mayuse  numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	xe_pzh	VARCHAR(4) ,
	xe_ckpzh VARCHAR(6),
	bz	VARCHAR(60),
	fhh	VARCHAR(16),
	usemony     numeric(18,2),
	saleprc		numeric(18,6),
	def_num1		numeric(18,6),
	mxid			integer,
	cg_head  	varchar(20),
	xs_head  	integer,
	syear   		varchar(4),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
PRIMARY KEY (id)
);

CREATE TABLE kc_jzbz
(	id	SMALLINT NOT NULL,
	ver	INTEGER ,
	inited SMALLINT ,
	len1 SMALLINT ,
	len2 SMALLINT ,
	len3 SMALLINT ,
	len4 SMALLINT ,
	len5 SMALLINT ,
	len6 SMALLINT ,
	len7 SMALLINT ,
	len8 SMALLINT ,
	mon1 SMALLINT ,
	mon2 SMALLINT ,
	mon3 SMALLINT ,
	mon4 SMALLINT ,
	mon5 SMALLINT ,
	mon6 SMALLINT ,
	mon7 SMALLINT ,
	mon8 SMALLINT ,
	mon9 SMALLINT ,
	mon10 SMALLINT ,
	mon11 SMALLINT ,
	mon12 SMALLINT ,
	dat1 numeric(18,6) ,
	dat2 numeric(18,6) ,
	dat3 numeric(18,6) ,
	dat4 numeric(18,6) ,
	dat5 numeric(18,6) ,
	str1 VARCHAR(30),
	str2 VARCHAR(30),
	str3 VARCHAR(30),
	str4 VARCHAR(30),
	str5 VARCHAR(30),
	def_int1	integer,
	def_int2	integer,
	def_int3	integer,
	def_int4	integer,
	def_int5	integer,
	def_str1	varchar(30),
	def_str2	varchar(30),
	def_str3	varchar(30),
	def_date1	date,
	def_date2	date,
PRIMARY KEY (id)
);

CREATE TABLE kc_dm
(	ckdm	VARCHAR(2) NOT NULL,
	dm	VARCHAR(20) NOT NULL,
	mc	VARCHAR(50) ,
	islb	SMALLINT ,
	chlb	smallint,
	ffid	SMALLINT ,
	dw	VARCHAR(6) ,
	gg	VARCHAR(50) ,
	txm	VARCHAR(30) ,
	kmdm	VARCHAR(20) ,
	cgkmdm	VARCHAR(20) ,
	maxsl	numeric(18,6) ,
	minsl	numeric(18,6) ,
	ncjcsl	numeric(18,6) ,
	sljsl	numeric(18,6) ,
	fljsl	numeric(18,6) ,
	ncye	numeric(18,6) ,
	ncye_j	numeric(18,6) ,
	dj	numeric(18,6) ,
	dj_j	numeric(18,6) ,
	jje	numeric(18,6) ,
	jje_j	numeric(18,6) ,
	dje	numeric(18,6) ,
	dje_j	numeric(18,6) ,
	ssl1    numeric(18,6) ,
	ssl2    numeric(18,6) ,
	ssl3    numeric(18,6) ,
	ssl4    numeric(18,6) ,
	ssl5    numeric(18,6) ,
	ssl6    numeric(18,6) ,
	ssl7    numeric(18,6) ,
	ssl8    numeric(18,6) ,
	ssl9    numeric(18,6) ,
	ssl10   numeric(18,6) ,
	ssl11   numeric(18,6) ,
	ssl12   numeric(18,6) ,
	fsl1    numeric(18,6) ,
	fsl2    numeric(18,6) ,
	fsl3    numeric(18,6) ,
	fsl4    numeric(18,6) ,
	fsl5    numeric(18,6) ,
	fsl6    numeric(18,6) ,
	fsl7    numeric(18,6) ,
	fsl8    numeric(18,6) ,
	fsl9    numeric(18,6) ,
	fsl10   numeric(18,6) ,
	fsl11   numeric(18,6) ,
	fsl12   numeric(18,6) ,
	jje1	numeric(18,6) ,
	jje2 	numeric(18,6) ,
	jje3	numeric(18,6) ,
	jje4	numeric(18,6) ,
	jje5 	numeric(18,6) ,
	jje6 	numeric(18,6) ,
	jje7 	numeric(18,6) ,
	jje8 	numeric(18,6) ,
	jje9 	numeric(18,6) ,
	jje10	numeric(18,6) ,
	jje11   numeric(18,6) ,
	jje12   numeric(18,6) ,
	jje_j1  numeric(18,6) ,
	jje_j2  numeric(18,6) ,
	jje_j3  numeric(18,6) ,
	jje_j4  numeric(18,6) ,
	jje_j5  numeric(18,6) ,
	jje_j6  numeric(18,6) ,
	jje_j7  numeric(18,6) ,
	jje_j8  numeric(18,6) ,
	jje_j9  numeric(18,6) ,
	jje_j10 numeric(18,6) ,
	jje_j11 numeric(18,6) ,
	jje_j12 numeric(18,6) ,
	dje1 numeric(18,6) ,
	dje2 numeric(18,6) ,
	dje3 numeric(18,6) ,
	dje4 numeric(18,6) ,
	dje5 numeric(18,6) ,
	dje6 numeric(18,6) ,
	dje7 numeric(18,6) ,
	dje8 numeric(18,6) ,
	dje9 numeric(18,6) ,
	dje10 numeric(18,6) ,
	dje11 numeric(18,6) ,
	dje12 numeric(18,6) ,
	dje_j1 numeric(18,6) ,
	dje_j2 numeric(18,6) ,
	dje_j3 numeric(18,6) ,
	dje_j4 numeric(18,6) ,
	dje_j5 numeric(18,6) ,
	dje_j6 numeric(18,6) ,
	dje_j7 numeric(18,6) ,
	dje_j8 numeric(18,6) ,
	dje_j9 numeric(18,6) ,
	dje_j10 numeric(18,6) ,
	dje_j11 numeric(18,6) ,
	dje_j12 numeric(18,6) ,
	dj0	numeric(18,6) ,
	dj1	numeric(18,6) ,
	dj2	numeric(18,6) ,
	dj3	numeric(18,6) ,
	dj4	numeric(18,6) ,
	dj5	numeric(18,6) ,
	dj6	numeric(18,6) ,
	dj7	numeric(18,6) ,
	dj8	numeric(18,6) ,
	dj9	numeric(18,6) ,
	dj10	numeric(18,6) ,
	dj11	numeric(18,6) ,
	dj12	numeric(18,6) ,
	tsl1	numeric(18,6),
	tsl2	numeric(18,6) ,
	xs_km	VARCHAR(20) ,
	xs_ncye	numeric(18,6) ,
        xs_dj   numeric(18,6) ,
        xs_dje  numeric(18,6) ,
	xs_dje1	numeric(18,6) ,
	xs_dje2	numeric(18,6) ,
	xs_dje3	numeric(18,6) ,
	xs_dje4	numeric(18,6) ,
	xs_dje5	numeric(18,6) ,
	xs_dje6	numeric(18,6) ,
	xs_dje7	numeric(18,6) ,
	xs_dje8	numeric(18,6) ,
	xs_dje9	numeric(18,6) ,
	xs_dje10 numeric(18,6) ,
	xs_dje11 numeric(18,6) ,
	xs_dje12 numeric(18,6) ,
	xscbkmdm VARCHAR(20) ,
	sccbkmdm VARCHAR(20),
	def_num1	numeric(18,6),
	def_num2	numeric(18,6),
	def_num3	numeric(18,6),
	def_num4	numeric(18,6),
	def_num5	numeric(18,6),
	def_str1	varchar(30),
	def_str2	varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1  integer,
	def_int2  integer,
PRIMARY KEY (ckdm,dm)
);

CREATE TABLE kc_dj
(	smon	VARCHAR(2) NOT NULL,
	pzlx	VARCHAR(1) NOT NULL,
	pzh	VARCHAR(4) NOT NULL,
	ckpzh	VARCHAR(6) ,
	pzrq	date ,
	hth	VARCHAR(20) ,
	fph	VARCHAR(20) ,
	dqh	VARCHAR(4) ,
	dwdm	VARCHAR(4) ,
	jsfs	INTEGER ,
	dfkm	VARCHAR(20) ,
	bmdm	VARCHAR(8) ,
	ckdm	VARCHAR(2) ,
	lydm	VARCHAR(4) ,
	ytdm	VARCHAR(4) ,
	lry	VARCHAR(8) ,
	lry2	VARCHAR(8) ,
	ysy	VARCHAR(8) ,
	shy	VARCHAR(8) ,
	jzy	VARCHAR(8) ,
	jsr	VARCHAR(8) ,
	ysbz	SMALLINT ,
	shbz	SMALLINT ,
	jzbz	SMALLINT ,
	yk_pzh	VARCHAR(20),
	note	VARCHAR(60) ,
	xe_num	INTEGER ,
	xe_pzh	VARCHAR(4),
	zfbz	SMALLINT ,
	zpzh	INTEGER,
	def_str1	varchar(30),
	def_str2	varchar(30),
	def_str3	varchar(30),
	def_str4	varchar(30),
	def_num1	numeric(18,6),
	def_num2	numeric(18,6),
	def_int1	integer,
	def_int2	integer,
	def_date1	date,
	def_date2	date,
PRIMARY KEY (smon,pzlx,pzh)
);

CREATE TABLE KC_PYPK
(	id	INTEGER NOT NULL,
	ckdm	VARCHAR(2),
	dm	VARCHAR(20),
	kh	VARCHAR(30),
	smon	VARCHAR(2) ,
	pzlx	VARCHAR(1) ,
	pzh	VARCHAR(4) ,
	rq	date,
	sl	numeric(18,6) ,
	je	numeric(18,6) ,
	ph	VARCHAR(20) ,
	kw	VARCHAR(30),
	slbak	numeric(18,6),
	jebak	numeric(18,6),
	ssl	numeric(18,6) ,
	sje	numeric(18,6) ,
	fsl	numeric(18,6),
	fje	numeric(18,6),
	note	VARCHAR(80), 
	sbzbak	VARCHAR(30),
	iykbz	SMALLINT,
	bz	SMALLINT,
	ibzbak	SMALLINT,
PRIMARY KEY (id)
);

CREATE TABLE kc_auto
(	id	INTEGER NOT NULL,
	num	INTEGER ,
	jhd	INTEGER ,
	kmdm	VARCHAR(20) ,
	contain	INTEGER ,
	zy	VARCHAR(30) ,
	pzlx	VARCHAR(1) ,
	form	VARCHAR(80),
PRIMARY KEY (id)
);

CREATE TABLE kc_bmyt
(	id	INTEGER NOT NULL, 
	bmdm	VARCHAR(8),
	ytdm	VARCHAR(4),
	bz	VARCHAR(30),
PRIMARY KEY (id)
);

CREATE TABLE kc_phyxq
( 	id	INTEGER NOT NULL,	
	ckdm	VARCHAR(2),
	kw	VARCHAR(30),
	ph	VARCHAR(20),
	dm	VARCHAR(20),
	lrrq	date,
	yxq	date,
	ncsl	numeric(18,6) ,
	ssl 	numeric(18,6) ,
	fsl	numeric(18,6) ,
	sl	numeric(18,6) ,
	je	numeric(18,6) ,	
	bq	VARCHAR(30),
	sbz	VARCHAR(50),
	ibz 	SMALLINT,
	ibz2	SMALLINT,
	def_date1	date,
	def_date2	date,
	def_date3	date,
	def_num1	numeric(18,6),
	def_num2	numeric(18,6),
	def_num3	numeric(18,6),
	def_num4	numeric(18,6),
	def_str1	varchar(30),
	def_str2	varchar(30),
PRIMARY KEY (id)
);

CREATE TABLE kc_mx00
(	id		varchar(6) NOT NULL,
	syear	varchar(4) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6) ,
	pzrq	DATE,
	dm		varchar(20) ,
	ph		varchar(20) ,
	kw		varchar(30)	,
	sl		numeric(18,6) ,
	mayuse numeric(18,6),
	sl_ycx numeric(18,6),
	dj		numeric(18,6) ,
	dj_j	numeric(18,6) ,
	je		numeric(18,2) ,
	je_j	numeric(18,2) ,
	yzf	numeric(18,2) ,
	usemony numeric(18,2),
	je_ycx  numeric(18,2),
	jzbz	smallint,
	status	varchar(4),
	bz		varchar(60) ,
	fhh	varchar(16) ,
	xe_ckpzh varchar(6),
	def_num2		numeric(18,6),
	def_num3		numeric(18,6),
	def_num4		numeric(18,6),
	def_num5		numeric(18,6),
	def_str1		varchar(30),
	def_str2		varchar(30),
	def_str3		varchar(30),
	def_date1	date,
	def_date2	date,
	def_int1		integer,
	def_int2		integer,
	primary key (id,syear,smon)
);

CREATE TABLE kc_dj00
(	syear	varchar(4) NOT NULL,
	smon	varchar(2) NOT NULL,
	pzlx	varchar(1) NOT NULL,
	pzh	varchar(4) NOT NULL,
	ckpzh	varchar(6),
	pzrq	date,
	hth	varchar(20),
	fph	varchar(20),
	dqh	varchar(4) ,
	dwdm	varchar(4) ,
	jsfs	SMALLINT,
	dfkm	varchar(20),
	bmdm	varchar(8) ,
	ckdm	char(2) ,
	lydm	varchar(4),
	ytdm	varchar(4),
	lry	varchar(8),
	lry2	varchar(8),
	ysy	varchar(8),
	shy	varchar(8),
	jzy	varchar(8),
	jsr	varchar(8),
	ysbz	SMALLINT,
	shbz	SMALLINT,
	jzbz	SMALLINT,
	note	varchar(60),
	yk_pzh	varchar(20),
	status	varchar(4),
	xe_ckpzh	varchar(6),
	zfbz		SMALLINT,
	zpzh		integer,
	Primary KEY (syear,smon,pzlx,pzh)
);

CREATE TABLE kc_jt
(	smon	varchar(2) NOT NULL,
	dm		varchar(20) NOT NULL,
	je		numeric(18,2),
	sl		numeric(18,6),
	mprice	numeric(18,6),
	cell_jt	numeric(18,6),
	cell_jt_yu	numeric(18,6),
	jt_yu		numeric(18,6),
	def_num1		numeric(18,6),
	def_num2		numeric(18,6),
	def_int1		smallint,
	def_int2		smallint,
	Primary KEY (smon,dm)
);

[CREATE INDEX]
DROP INDEX kc_auto_pk;
DROP INDEX kc_auto_num;
DROP INDEX kc_bm_pk;
DROP INDEX kc_bmyt_pk;
DROP INDEX kc_bmyt_bm;
DROP INDEX kc_bmyt_yt;
DROP INDEX kc_chlb_pk;
DROP INDEX kc_chlb_mc;
DROP INDEX kc_ck_pk;
DROP INDEX kc_ck_mc;
DROP INDEX kc_ckqx_pk;
DROP INDEX kc_ckqx_xm;
DROP INDEX kc_ckqx_ck;
DROP INDEX kc_def_pk;
DROP INDEX kc_dj_pk;
DROP INDEX kc_dj_bz;
DROP INDEX kc_dj_wldw;
DROP INDEX kc_dj_htfp;
DROP INDEX kc_dj_ck;
DROP INDEX kc_dj_bm;
DROP INDEX kc_dj_lyyt;
DROP INDEX kc_dj_zpzh;
DROP INDEX kc_dj00_pk;
DROP INDEX kc_dj00_ck;
DROP INDEX kc_dj00_zpzh;
DROP INDEX kc_dm_pk;
DROP INDEX kc_dm_ck;
DROP INDEX kc_dm_dm;
DROP INDEX kc_dm_islb;
DROP INDEX kc_dm_chlb;
DROP INDEX kc_dm_ffid;
DROP INDEX kc_dm_olddm;
DROP INDEX kc_ff_pk;
DROP INDEX kc_flag_pk;
DROP INDEX kc_jsfs_pk;
DROP INDEX kc_jzbz_pk;
DROP INDEX kc_kw_pk;
DROP INDEX kc_kw_ck;
DROP INDEX kc_kw_dm;
DROP INDEX kc_ly_pk;
DROP INDEX kc_mx_pk;
DROP INDEX kc_mx_x;
DROP INDEX kc_mx_dm;
DROP INDEX kc_mx_ckpzh;
DROP INDEX kc_mx_jk;
DROP INDEX kc_mx_phkw;
DROP INDEX kc_mx00_pk;
DROP INDEX kc_mx00_x;
DROP INDEX kc_mx00_dm;
DROP INDEX kc_mx01_pk;
DROP INDEX kc_mx01_x;
DROP INDEX kc_mx01_dm;
DROP INDEX kc_mx01_ckpzh;
DROP INDEX kc_mx01_jk;
DROP INDEX kc_mx01_phkw;
DROP INDEX kc_mx02_pk;
DROP INDEX kc_mx02_x;
DROP INDEX kc_mx02_dm;
DROP INDEX kc_mx02_ckpzh;
DROP INDEX kc_mx02_jk;
DROP INDEX kc_mx02_phkw;
DROP INDEX kc_mx03_pk;
DROP INDEX kc_mx03_x;
DROP INDEX kc_mx03_dm;
DROP INDEX kc_mx03_ckpzh;
DROP INDEX kc_mx03_jk;
DROP INDEX kc_mx03_phkw;
DROP INDEX kc_mx04_pk;
DROP INDEX kc_mx04_x;
DROP INDEX kc_mx04_dm;
DROP INDEX kc_mx04_ckpzh;
DROP INDEX kc_mx04_jk;
DROP INDEX kc_mx04_phkw;
DROP INDEX kc_mx05_pk;
DROP INDEX kc_mx05_x;
DROP INDEX kc_mx05_dm;
DROP INDEX kc_mx05_ckpzh;
DROP INDEX kc_mx05_jk;
DROP INDEX kc_mx05_phkw;
DROP INDEX kc_mx06_pk;
DROP INDEX kc_mx06_x;
DROP INDEX kc_mx06_dm;
DROP INDEX kc_mx06_ckpzh;
DROP INDEX kc_mx06_jk;
DROP INDEX kc_mx06_phkw;
DROP INDEX kc_mx07_pk;
DROP INDEX kc_mx07_x;
DROP INDEX kc_mx07_dm;
DROP INDEX kc_mx07_ckpzh;
DROP INDEX kc_mx07_jk;
DROP INDEX kc_mx07_phkw;
DROP INDEX kc_mx08_pk;
DROP INDEX kc_mx08_x;
DROP INDEX kc_mx08_dm;
DROP INDEX kc_mx08_ckpzh;
DROP INDEX kc_mx08_jk;
DROP INDEX kc_mx08_phkw;
DROP INDEX kc_mx09_pk;
DROP INDEX kc_mx09_x;
DROP INDEX kc_mx09_dm;
DROP INDEX kc_mx09_ckpzh;
DROP INDEX kc_mx09_jk;
DROP INDEX kc_mx09_phkw;
DROP INDEX kc_mx10_pk;
DROP INDEX kc_mx10_x;
DROP INDEX kc_mx10_dm;
DROP INDEX kc_mx10_ckpzh;
DROP INDEX kc_mx10_jk;
DROP INDEX kc_mx10_phkw;
DROP INDEX kc_mx11_pk;
DROP INDEX kc_mx11_x;
DROP INDEX kc_mx11_dm;
DROP INDEX kc_mx11_ckpzh;
DROP INDEX kc_mx11_jk;
DROP INDEX kc_mx11_phkw;
DROP INDEX kc_mx12_pk;
DROP INDEX kc_mx12_x;
DROP INDEX kc_mx12_dm;
DROP INDEX kc_mx12_ckpzh;
DROP INDEX kc_mx12_jk;
DROP INDEX kc_mx12_phkw;
DROP INDEX kc_phyxq_pk;
DROP INDEX kc_phyxq_ckdm;
DROP INDEX kc_phyxq_dm;
DROP INDEX kc_phyxq_kwph;
DROP INDEX kc_phyxq_ibz;
DROP INDEX kc_pypk_pk;
DROP INDEX kc_pypk_ckkh;
DROP INDEX kc_pypk_pzh;
DROP INDEX kc_pypk_dm;
DROP INDEX kc_pypk_bz;
DROP INDEX kc_pz_pk;
DROP INDEX kc_pz_zwpzh;
DROP INDEX kc_pz_pzh;
DROP INDEX kc_qx_pk;
DROP INDEX kc_xeset_pk;
DROP INDEX kc_xeset_xe;
DROP INDEX kc_xeset_pld;
DROP INDEX kc_xeset_num;
DROP INDEX kc_yt_pk;
DROP INDEX kc_jt_x;
DROP INDEX kc_jt_dm;

CREATE UNIQUE INDEX kc_auto_pk ON kc_auto(id);
CREATE INDEX kc_auto_num ON kc_auto(num);
CREATE UNIQUE INDEX kc_bm_pk ON kc_bm(dm);
CREATE UNIQUE INDEX kc_bmyt_pk ON kc_bmyt(id);
CREATE INDEX kc_bmyt_bm ON kc_bmyt(bmdm);
CREATE INDEX kc_bmyt_yt ON kc_bmyt(ytdm);
CREATE UNIQUE INDEX kc_chlb_pk ON kc_chlb(dm);
CREATE INDEX kc_chlb_mc ON kc_chlb(mc);
CREATE UNIQUE INDEX kc_ck_pk ON kc_ck(dm);
CREATE INDEX kc_ck_mc ON kc_ck(mc);
CREATE UNIQUE INDEX kc_ckqx_pk ON kc_ckqx(xm,ckqx);
CREATE INDEX kc_ckqx_xm ON kc_ckqx(xm);
CREATE INDEX kc_ckqx_ck ON kc_ckqx(ckqx);
CREATE UNIQUE INDEX kc_def_pk ON kc_def(id);
CREATE UNIQUE INDEX kc_dj_pk ON kc_dj(smon,pzlx,pzh);
CREATE INDEX kc_dj_ysbz ON kc_dj(ysbz,shbz,jzbz);
CREATE INDEX kc_dj_wldw ON kc_dj(dqh,dwdm);
CREATE INDEX kc_dj_htfp ON kc_dj(hth,fph);
CREATE INDEX kc_dj_ck ON kc_dj(ckdm,ckpzh);
CREATE INDEX kc_dj_bm ON kc_dj(bmdm);
CREATE INDEX kc_dj_lyyt ON kc_dj(lydm,ytdm); 
CREATE INDEX kc_dj_zpzh ON kc_dj(zpzh);
CREATE UNIQUE INDEX kc_dj00_pk ON kc_dj00(syear,smon,pzlx,pzh);
CREATE INDEX kc_dj00_ck ON kc_dj00(ckdm);
CREATE INDEX kc_dj00_zpzh ON kc_dj00(zpzh);
CREATE UNIQUE INDEX kc_dm_pk ON kc_dm(ckdm,dm);
CREATE INDEX kc_dm_ck ON kc_dm(ckdm);
CREATE INDEX kc_dm_dm ON kc_dm(dm);
CREATE INDEX kc_dm_islb ON kc_dm(islb);
CREATE INDEX kc_dm_chlb ON kc_dm(chlb);
CREATE INDEX kc_dm_ffid ON kc_dm(ffid);
CREATE INDEX kc_dm_olddm ON kc_dm(def_str1);
CREATE UNIQUE INDEX kc_ff_pk ON kc_ff(id);
CREATE UNIQUE INDEX kc_flag_pk ON kc_flag(id);
CREATE UNIQUE INDEX kc_jsfs_pk ON kc_jsfs(dm);
CREATE UNIQUE INDEX kc_jzbz_pk ON kc_jzbz(id);
CREATE UNIQUE INDEX kc_kw_pk ON kc_kw(ckdm,dm);
CREATE INDEX kc_kw_ck ON kc_kw(ckdm);
CREATE INDEX kc_kw_dm ON kc_kw(dm);
CREATE UNIQUE INDEX kc_ly_pk ON kc_ly(dm);
CREATE UNIQUE INDEX kc_mx_pk ON kc_mx(id);
CREATE INDEX kc_mx_x ON kc_mx(smon,pzlx,pzh);
CREATE INDEX kc_mx_dm ON kc_mx(dm);
CREATE INDEX kc_mx_ckpzh ON kc_mx(ckpzh);
CREATE INDEX kc_mx_jk ON kc_mx(fhh,mxid);
CREATE INDEX kc_mx_phkw ON kc_mx(kw,ph);
CREATE UNIQUE INDEX kc_mx00_pk ON kc_mx00(id,syear,smon);
CREATE INDEX kc_mx00_x ON kc_mx00(smon,pzlx,pzh);
CREATE INDEX kc_mx00_dm ON kc_mx00(dm);
CREATE UNIQUE INDEX kc_mx01_pk ON kc_mx01(id);
CREATE INDEX kc_mx01_x ON kc_mx01(smon,pzlx,pzh);
CREATE INDEX kc_mx01_dm ON kc_mx01(dm);
CREATE INDEX kc_mx01_ckpzh ON kc_mx01(ckpzh);
CREATE INDEX kc_mx01_jk ON kc_mx01(fhh,mxid);
CREATE INDEX kc_mx01_phkw ON kc_mx01(kw,ph);
CREATE UNIQUE INDEX kc_mx02_pk ON kc_mx02(id);
CREATE INDEX kc_mx02_x ON kc_mx02(smon,pzlx,pzh);
CREATE INDEX kc_mx02_dm ON kc_mx02(dm);
CREATE INDEX kc_mx02_ckpzh ON kc_mx02(ckpzh);
CREATE INDEX kc_mx02_jk ON kc_mx02(fhh,mxid);
CREATE INDEX kc_mx02_phkw ON kc_mx02(kw,ph);
CREATE UNIQUE INDEX kc_mx03_pk ON kc_mx03(id);
CREATE INDEX kc_mx03_x ON kc_mx03(smon,pzlx,pzh);
CREATE INDEX kc_mx03_dm ON kc_mx03(dm);
CREATE INDEX kc_mx03_ckpzh ON kc_mx03(ckpzh);
CREATE INDEX kc_mx03_jk ON kc_mx03(fhh,mxid);
CREATE INDEX kc_mx03_phkw ON kc_mx03(kw,ph);
CREATE UNIQUE INDEX kc_mx04_pk ON kc_mx04(id);
CREATE INDEX kc_mx04_x ON kc_mx04(smon,pzlx,pzh);
CREATE INDEX kc_mx04_dm ON kc_mx04(dm);
CREATE INDEX kc_mx04_ckpzh ON kc_mx04(ckpzh);
CREATE INDEX kc_mx04_jk ON kc_mx04(fhh,mxid);
CREATE INDEX kc_mx04_phkw ON kc_mx04(kw,ph);
CREATE UNIQUE INDEX kc_mx05_pk ON kc_mx05(id);
CREATE INDEX kc_mx05_x ON kc_mx05(smon,pzlx,pzh);
CREATE INDEX kc_mx05_dm ON kc_mx05(dm);
CREATE INDEX kc_mx05_ckpzh ON kc_mx05(ckpzh);
CREATE INDEX kc_mx05_jk ON kc_mx05(fhh,mxid);
CREATE INDEX kc_mx05_phkw ON kc_mx05(kw,ph);
CREATE UNIQUE INDEX kc_mx06_pk ON kc_mx06(id);
CREATE INDEX kc_mx06_x ON kc_mx06(smon,pzlx,pzh);
CREATE INDEX kc_mx06_dm ON kc_mx06(dm);
CREATE INDEX kc_mx06_ckpzh ON kc_mx06(ckpzh);
CREATE INDEX kc_mx06_jk ON kc_mx06(fhh,mxid);
CREATE INDEX kc_mx06_phkw ON kc_mx06(kw,ph);
CREATE UNIQUE INDEX kc_mx07_pk ON kc_mx07(id);
CREATE INDEX kc_mx07_x ON kc_mx07(smon,pzlx,pzh);
CREATE INDEX kc_mx07_dm ON kc_mx07(dm);
CREATE INDEX kc_mx07_ckpzh ON kc_mx07(ckpzh);
CREATE INDEX kc_mx07_jk ON kc_mx07(fhh,mxid);
CREATE INDEX kc_mx07_phkw ON kc_mx07(kw,ph);
CREATE UNIQUE INDEX kc_mx08_pk ON kc_mx08(id);
CREATE INDEX kc_mx08_x ON kc_mx08(smon,pzlx,pzh);
CREATE INDEX kc_mx08_dm ON kc_mx08(dm);
CREATE INDEX kc_mx08_ckpzh ON kc_mx08(ckpzh);
CREATE INDEX kc_mx08_jk ON kc_mx08(fhh,mxid);
CREATE INDEX kc_mx08_phkw ON kc_mx08(kw,ph);
CREATE UNIQUE INDEX kc_mx09_pk ON kc_mx09(id);
CREATE INDEX kc_mx09_x ON kc_mx09(smon,pzlx,pzh);
CREATE INDEX kc_mx09_dm ON kc_mx09(dm);
CREATE INDEX kc_mx09_ckpzh ON kc_mx09(ckpzh);
CREATE INDEX kc_mx09_jk ON kc_mx09(fhh,mxid);
CREATE INDEX kc_mx09_phkw ON kc_mx09(kw,ph);
CREATE UNIQUE INDEX kc_mx10_pk ON kc_mx10(id);
CREATE INDEX kc_mx10_x ON kc_mx10(smon,pzlx,pzh);
CREATE INDEX kc_mx10_dm ON kc_mx10(dm);
CREATE INDEX kc_mx10_ckpzh ON kc_mx10(ckpzh);
CREATE INDEX kc_mx10_jk ON kc_mx10(fhh,mxid);
CREATE INDEX kc_mx10_phkw ON kc_mx10(kw,ph);
CREATE UNIQUE INDEX kc_mx11_pk ON kc_mx11(id);
CREATE INDEX kc_mx11_x ON kc_mx11(smon,pzlx,pzh);
CREATE INDEX kc_mx11_dm ON kc_mx11(dm);
CREATE INDEX kc_mx11_ckpzh ON kc_mx11(ckpzh);
CREATE INDEX kc_mx11_jk ON kc_mx11(fhh,mxid);
CREATE INDEX kc_mx11_phkw ON kc_mx11(kw,ph);
CREATE UNIQUE INDEX kc_mx12_pk ON kc_mx12(id);
CREATE INDEX kc_mx12_x ON kc_mx12(smon,pzlx,pzh);
CREATE INDEX kc_mx12_dm ON kc_mx12(dm);
CREATE INDEX kc_mx12_ckpzh ON kc_mx12(ckpzh);
CREATE INDEX kc_mx12_jk ON kc_mx12(fhh,mxid);
CREATE INDEX kc_mx12_phkw ON kc_mx12(kw,ph);
CREATE UNIQUE INDEX kc_phyxq_pk ON kc_phyxq(id);
CREATE INDEX kc_phyxq_ckdm ON kc_phyxq(ckdm);
CREATE INDEX kc_phyxq_dm ON kc_phyxq(dm);
CREATE INDEX kc_phyxq_kwph ON kc_phyxq(kw,ph);
CREATE INDEX kc_phyxq_ibz ON kc_phyxq(ibz);
CREATE UNIQUE INDEX kc_pypk_pk ON kc_pypk(id);
CREATE INDEX kc_pypk_ckkh ON kc_pypk(ckdm,kh);
CREATE INDEX kc_pypk_pzh ON kc_pypk(smon,pzh,pzlx);
CREATE INDEX kc_pypk_dm ON kc_pypk(dm);
CREATE INDEX kc_pypk_bz ON kc_pypk(ibzbak,bz,iykbz);
CREATE UNIQUE INDEX kc_pz_pk ON kc_pz(id);
CREATE INDEX kc_pz_zwpzh ON kc_pz(spp);
CREATE INDEX kc_pz_pzh ON kc_pz(pzh);
CREATE UNIQUE INDEX kc_qx_pk ON kc_qx(xm);
CREATE UNIQUE INDEX kc_xeset_pk ON kc_xeset(id);
CREATE INDEX kc_xeset_xe ON kc_xeset(dm,smon,bmdm,ckdm);
CREATE INDEX kc_xeset_pld ON kc_xeset(dm,ckdm);
CREATE INDEX kc_xeset_num ON kc_xeset(num,nums);
CREATE UNIQUE INDEX kc_yt_pk ON kc_yt(dm);
CREATE UNIQUE INDEX kc_jt_x ON kc_jt(smon,dm);
CREATE INDEX kc_jt_dm ON kc_jt(dm);