[CREATE TABLE]
CREATE TABLE ca_ctr
(
	centerno	CHAR(20) NOT NULL,
	ctname	CHAR(64),
	lsign		NUMERIC(3,0),
	cttype	CHAR(4),
	iszy		NUMERIC(3,0),
	zybm		CHAR(20),
	allrate	NUMERIC(18,8)
);
CREATE TABLE ca_item
(
	itemcode	CHAR(20) NOT NULL,
	itemname	CHAR(64),
	lsign		NUMERIC(3,0),
	itemtype	CHAR(4),
	wlbm		CHAR(20),
	aord		NUMERIC(3,0),
	forv		NUMERIC(3,0),
	abc_type	CHAR(4),
	callno	CHAR(4),
	msable	NUMERIC(3,0),
	qtyadd	NUMERIC(3,0),
	munit		CHAR(4),
	nunit		CHAR(4),
	ismain	NUMERIC(3,0),
	lvtype	CHAR(4),
	lvnum		NUMERIC(3,0),
	planpri	NUMERIC(18,8),
	opri		NUMERIC(18,8),
	actno		CHAR(20),
	oactno	CHAR(20),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_uet
(
	id		   NUMERIC(10,0) NOT NULL,
	callno	CHAR(4),
	allname	CHAR(64),
	isign		NUMERIC(3,0),
	allnote	CHAR(64)
);
CREATE TABLE ca_uer
(
	centerno	CHAR(20) NOT NULL,
	itemcode	CHAR(20) NOT NULL,
	callno	CHAR(4)
);
CREATE TABLE ca_obj
(
	objectno	CHAR(20) NOT NULL,
	obname	CHAR(64),
	obtype	CHAR(4),
	lsign		NUMERIC(3,0),
	itemno	CHAR(20),
	subname	CHAR(40),
	munit		CHAR(4),
	nunit		CHAR(4),
	mallno	CHAR(4),
	allrate	NUMERIC(18,8),
	badrate	NUMERIC(18,8),
	salepri	NUMERIC(18,8),
	qtytotal	NUMERIC(18,8),
	amototal	NUMERIC(18,8),
	sfixcost	NUMERIC(18,8),
	ufixcost	NUMERIC(18,8),
	uvarcost	NUMERIC(18,8),
	uothcost	NUMERIC(18,8),
	itemcode	CHAR(20),
	flowno   CHAR(20),
	actno		CHAR(20),
	oactno	CHAR(20),
	obnote	CHAR(64),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_flow
(
	flowno	CHAR(20) NOT NULL,
	centerno	CHAR(20) NOT NULL,
	flowname	CHAR(64),
	ispri		NUMERIC(3,0),
	icourse	NUMERIC(3,0),
	descr		CHAR(64)	
);
CREATE TABLE ca_mdl
(
	flowno	CHAR(20) NOT NULL,
	objectno	CHAR(20) NOT NULL,
	centerno	CHAR(20) NOT NULL,
	itemcode	CHAR(20) NOT NULL,
	icourse	NUMERIC(3,0),
	mallper	NUMERIC(18,8),
	mallrate	NUMERIC(18,8),
	mallamo	NUMERIC(18,8),
	mdqua		NUMERIC(18,8),
	mdamo		NUMERIC(18,8),
	adqua		NUMERIC(18,8),
	adamo		NUMERIC(18,8),	
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_bth
(
	id		   NUMERIC(10,0) NOT NULL,
	batchno	CHAR(20),
	fcode		CHAR(20),
	ue_code	CHAR(20),
	batype	CHAR(4),
	deptno	CHAR(20),
	objectno	CHAR(20),
	flowno	CHAR(20),
	ca_mon	NUMERIC(10,0),
	bdate		date,
	edate		date,
	tsign		NUMERIC(3,0),
	chksign	NUMERIC(3,0),
	comsign	NUMERIC(3,0),
	ord		CHAR(20),
	chm		CHAR(20),
	inm		CHAR(20),
	banote	CHAR(64),
	qty_plan	NUMERIC(18,8),
	qty_font	NUMERIC(18,8),
	amo_font	NUMERIC(18,8),
	qty_outp	NUMERIC(18,8),
	amo_outp	NUMERIC(18,8),
	amo_sale	NUMERIC(18,8),
	amo_stad	NUMERIC(18,8),
	qty_next	NUMERIC(18,8),
	amo_next	NUMERIC(18,8),
	qty_tra	NUMERIC(18,8),
	qty_trb	NUMERIC(18,8),
	qty_trc	NUMERIC(18,8),
	qty_trd	NUMERIC(18,8),
	qty_tre	NUMERIC(18,8),
	qty_trf	NUMERIC(18,8),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_mtx
(
	batchno	CHAR(20) NOT NULL,
	centerno	CHAR(20) NOT NULL,
	itemcode	CHAR(20) NOT NULL,
	deptno	CHAR(20),
	ue_code	CHAR(20),
	objectno	CHAR(20),
	ca_mon	NUMERIC(10,0),
	aord		NUMERIC(3,0),
	msunit	CHAR(4),
	icourse	NUMERIC(3,0),
	qty_plan	NUMERIC(18,8),
	amo_plan	NUMERIC(18,8),
	qty_font	NUMERIC(18,8),
	amo_font	NUMERIC(18,8),
	per_font	NUMERIC(18,8),
	qty_cur	NUMERIC(18,8),
	amo_cur	NUMERIC(18,8),
	qty_outp	NUMERIC(18,8),
	amo_outp	NUMERIC(18,8),
	qty_next	NUMERIC(18,8),
	amo_next	NUMERIC(18,8),
	per_next	NUMERIC(18,8),
	allper   NUMERIC(18,8),
	dec_rpa	NUMERIC(18,8),
	dec_rpb	NUMERIC(18,8),
	dec_rpc	NUMERIC(18,8),
	dec_rpd	NUMERIC(18,8),
	dec_rpe	NUMERIC(18,8),
	dec_rpf	NUMERIC(18,8),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_jbt
(
	jobno		CHAR(4) NOT NULL,
	jobname	CHAR(64),
	abc_type	CHAR(4),
	msunit	CHAR(4),
	jotype	NUMERIC(3,0),
	descr		CHAR(64)
);
CREATE TABLE ca_rtn
(
	centerno	CHAR(20) NOT NULL,
	objectno	CHAR(20) NOT NULL,
	jobno		CHAR(4) NOT NULL,
	ra_qua	NUMERIC(18,8)
);
CREATE TABLE ca_jbq
(
	centerno	CHAR(20) NOT NULL,
	batchno	CHAR(20) NOT NULL,
	jobno		CHAR(4)  NOT NULL,
	deptno	CHAR(20),
	objectno	CHAR(20),
	ca_mon	NUMERIC(10,0),
	qty_rat	NUMERIC(18,8),
	qty_rea	NUMERIC(18,8)
);
CREATE TABLE ca_jbb
(
	id		   NUMERIC(10,0) NOT NULL,
	billno	CHAR(20),
	jobno		CHAR(4),
	deptno	CHAR(20),
	ca_mon	NUMERIC(10,0),
	chksign	NUMERIC(3,0),
	bdate		date,
	edate		date,
	inm		CHAR(20),
	chm		CHAR(20),
	zybm		CHAR(20),
	centerno	CHAR(20),
	batchno	CHAR(20),
	objectno	CHAR(20),
	qty		NUMERIC(18,8),
	unitcon	NUMERIC(18,8),
	totalqty	NUMERIC(18,8),
	js_numa	NUMERIC(18,8),
	js_numb	NUMERIC(18,8),
	js_numc	NUMERIC(18,8),
	jsnote	CHAR(64),
	js_infoa	CHAR(64),
	js_infob	CHAR(64),
	js_infoc	CHAR(64),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_dsf
(
	id			NUMERIC(10,0) NOT NULL,
	systp		NUMERIC(3,0),
	gettype	CHAR(4),
	centerno	CHAR(20),
	itemcode	CHAR(20),
	objectno	CHAR(20),
	callno	CHAR(4),
	allrate	NUMERIC(18,8),
	cacsign	NUMERIC(3,0)
);
CREATE TABLE ca_dsrd
(
	id			NUMERIC(10,0) NOT NULL,
	icourse	NUMERIC(3,0) NOT NULL,
	cactp		CHAR(4),
	lbracket	CHAR(12),
	listid	CHAR(12),
	matchtp	CHAR(4),
	rbracket	CHAR(12),
	svalue	CHAR(64)
);
CREATE TABLE ca_expb
(
	id			NUMERIC(10,0) NOT NULL,
	billno	CHAR(20),
	extype	CHAR(4),
	itemtype	CHAR(4),
	jobno		CHAR(4),
	origno	CHAR(20),
	chksign	NUMERIC(3,0),
	ca_mon	NUMERIC(10,0),
	rdate		date,
	whno		CHAR(20),
	deptno	CHAR(20),
	centerno	CHAR(20),
	objectno	CHAR(20),
	batchno	CHAR(20),
	chm		CHAR(20),
	inm		CHAR(20),
	iscacu	NUMERIC(3,0),
	sysmake	NUMERIC(3,0),
	t_dept	CHAR(20),
	t_center	CHAR(20),
	t_item	CHAR(20),
	t_itemno	CHAR(20),
	ranks		CHAR(2),
	t_object	CHAR(20),
	t_batch	CHAR(20),
	pri		NUMERIC(18,8),
	qua		NUMERIC(18,8),
	amo		NUMERIC(18,8),
	exnote	CHAR(64),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_rd
(
	id			NUMERIC(10,0) NOT NULL,
	billno	CHAR(20),
	extype	CHAR(4),
	itemtype	CHAR(4),
	ca_mon	NUMERIC(10,0),
	orgino	CHAR(20),
	deptno	CHAR(20),
	centerno	CHAR(20),
	itemcode	CHAR(20),
	msunit	CHAR(4),
	objectno	CHAR(20),
	batchno	CHAR(20),
	rdate		date,
	qty		NUMERIC(18,8),
	amo		NUMERIC(18,8),
	iscacu	NUMERIC(3,0),
	renote	CHAR(64),
	de_int	NUMERIC(10,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_mdc
(
	id			NUMERIC(10,0) NOT NULL,
	whid		CHAR(20),
	objectno	CHAR(20),
	itemcode	CHAR(20),
	itemno	CHAR(20),
	ca_mon	NUMERIC(10,0),
	ranks		CHAR(2),
	msunit	CHAR(4),
	qty_font	NUMERIC(18,8),
	amo_font	NUMERIC(18,8),
	qty_pur	NUMERIC(18,8),
	amo_pur	NUMERIC(18,8),
	qty_pro	NUMERIC(18,8),
	amo_pro	NUMERIC(18,8),
	chnote	CHAR(64)
);
CREATE TABLE ca_anm
(
	centerno	CHAR(20) NOT NULL,
	batchno	CHAR(20) NOT NULL,
	itemcode	CHAR(20) NOT NULL,
	callno	CHAR(4)  NOT NULL,
	objectno	CHAR(20),
	ca_mon	NUMERIC(10,0),
	qty_base	NUMERIC(18,8)
);
CREATE TABLE ca_aexp
(
	id			NUMERIC(10,0) NOT NULL,
	centerno	CHAR(20),
	itemcode	CHAR(20),
	ca_mon	NUMERIC(10,0),
	callno	CHAR(4),
	msunit	CHAR(4),
	isturn	NUMERIC(3,0),
	isall		NUMERIC(3,0),
	qty_add	NUMERIC(18,8),
	qty_all	NUMERIC(18,8),
	amo_all	NUMERIC(18,8)
);
CREATE TABLE ca_prop
(
	id			NUMERIC(10,0) NOT NULL,
	p01		NUMERIC(10,0),
	p02		NUMERIC(10,0),
	p03		NUMERIC(10,0),
	p04		NUMERIC(10,0),
	p05		NUMERIC(10,0),
	p06		NUMERIC(10,0),
	p07		NUMERIC(10,0),
	p08		NUMERIC(10,0),
	p09		NUMERIC(10,0),
	p10		NUMERIC(10,0),
	p11		NUMERIC(10,0),
	p12		NUMERIC(10,0)
);
CREATE TABLE ca_uch
(
	funit		CHAR(4) NOT NULL,
	nunit		CHAR(4) NOT NULL,
	relat		NUMERIC(18,8),
	msnote	CHAR(64)
);
CREATE TABLE ca_cdf
(
	id				CHAR(4) NOT NULL,
	sfname		CHAR(64),
	sftype		CHAR(4),
	maxcla		NUMERIC(10,0),
	maxlen		NUMERIC(10,0),
	sinlen		NUMERIC(10,0),
	ismanu		NUMERIC(3,0)
);
CREATE TABLE ca_cdrd
(
	id			CHAR(4) NOT NULL,
	cla		NUMERIC(10,0) NOT NULL,
	len		NUMERIC(10,0),
	val		CHAR(20),
	constr	CHAR(20),
	de_int1 	NUMERIC(10,0),
	de_int2  NUMERIC(10,0),
  	de_str1	CHAR(12),
  	de_str2 	CHAR(64)
);
CREATE TABLE ca_abctp
(
 	abc_type	CHAR(4) NOT NULL,
  	descr		CHAR(64),
  	de_str1 	CHAR(12),
  	de_str2 	CHAR(12),
  	de_str3 	CHAR(64)
);
CREATE TABLE ca_ma
(
	mallno	CHAR(4) NOT NULL,
	descr		CHAR(64)
);
CREATE TABLE ca_obtp
(
	obtype	CHAR(4) NOT NULL,
	descr		CHAR(64)
);
CREATE TABLE ca_batp
(
	batype	CHAR(4) NOT NULL,
	descr		CHAR(64)
);
CREATE TABLE ca_extp
(
	extype	CHAR(4) NOT NULL,
	descr		CHAR(64),
   isadd		NUMERIC(3,0),
	isamo		NUMERIC(3,0),
	de_str	CHAR(64)
);
CREATE TABLE ca_itp
(
	itemtype	CHAR(4) NOT NULL,
	descr		CHAR(64)
);
CREATE TABLE ca_unit
(
	unitno	CHAR(4) NOT NULL,
	descr		CHAR(64),
	defstr	CHAR(20),
	ismain	NUMERIC(3,0)
);
CREATE TABLE cb_qx
(
	 xm  		CHAR(20) NOT NULL ,		
	 mm  		CHAR(20),					
	 bm  		CHAR(20),				
	 cno 		CHAR(20),
	 q0  		NUMERIC(3,0),
    q1  		NUMERIC(3,0),
	 q1_1	 	NUMERIC(3,0), 
	 q1_2  	NUMERIC(3,0),
	 q1_3  	NUMERIC(3,0),    
	 q1_4  	NUMERIC(3,0),
	 q1_5  	NUMERIC(3,0),
	 q1_6  	NUMERIC(3,0),					
	 q1_7  	NUMERIC(3,0),					
	 q1_8  	NUMERIC(3,0),					
	 q1_9  	NUMERIC(3,0),					
	 q1_a 	NUMERIC(3,0),					
	 q1_b  	NUMERIC(3,0),					 
	 q1_c  	NUMERIC(3,0),					
	 q1_d  	NUMERIC(3,0),               
	 q1_e  	NUMERIC(3,0),					
	 q1_f  	NUMERIC(3,0),	 
	 q1_g  	NUMERIC(3,0),               
	 q1_h  	NUMERIC(3,0),					
	 q1_i  	NUMERIC(3,0),					
	 q2    	NUMERIC(3,0),					
	 q2_1  	NUMERIC(3,0), 
	 q2_2  	NUMERIC(3,0),
	 q2_3  	NUMERIC(3,0),    
	 q2_4  	NUMERIC(3,0),
	 q2_5  	NUMERIC(3,0),
	 q2_6  	NUMERIC(3,0),					
	 q2_7  	NUMERIC(3,0),
	 q2_8  	NUMERIC(3,0),
	 q3    	NUMERIC(3,0),					
	 q3_1  	NUMERIC(3,0), 
	 q3_2  	NUMERIC(3,0),
	 q3_3  	NUMERIC(3,0),    
	 q3_4  	NUMERIC(3,0),
	 q3_5  	NUMERIC(3,0),
	 q3_6  	NUMERIC(3,0),					
	 q3_7  	NUMERIC(3,0),					
	 q3_8  	NUMERIC(3,0),					
	 q3_9  	NUMERIC(3,0),
	 q3_a  	NUMERIC(3,0),
	 q3_b  	NUMERIC(3,0),					
	 q3_c  	NUMERIC(3,0),	
	 q4    	NUMERIC(3,0),					
	 q4_1  	NUMERIC(3,0), 
	 q4_2  	NUMERIC(3,0),
	 q4_3  	NUMERIC(3,0),    
	 q4_4  	NUMERIC(3,0),
	 q4_5  	NUMERIC(3,0),
	 q4_6  	NUMERIC(3,0),
	 q5    	NUMERIC(3,0),
	 q5_1  	NUMERIC(3,0), 
	 q5_2  	NUMERIC(3,0),
	 q5_3  	NUMERIC(3,0),    
	 q5_4  	NUMERIC(3,0),
	 q5_5  	NUMERIC(3,0),
	 q5_6 	NUMERIC(3,0),					
	 q5_7  	NUMERIC(3,0),					
	 q5_8  	NUMERIC(3,0),					
	 q5_9  	NUMERIC(3,0),
	 q5_a  	NUMERIC(3,0),					
	 q5_b  	NUMERIC(3,0),					 
	 q5_c 	NUMERIC(3,0),					
	 q5_d  	NUMERIC(3,0),
	 q6    	NUMERIC(3,0),
    q7		NUMERIC(3,0),
	 q7_1  	NUMERIC(3,0), 
	 q7_2  	NUMERIC(3,0),
	 q7_3  	NUMERIC(3,0),    
	 q7_4  	NUMERIC(3,0)
);

CREATE TABLE cb_pz
(
	 id	  	 NUMERIC(10,0) NOT NULL ,		
	 jzbz	  	 NUMERIC(3,0),
	 csign  	 NUMERIC(3,0),
	 pzrq   	 date,
	 pzlx   	 CHAR(1),
    pzh    	 CHAR(4),
	 fj	  	 NUMERIC(3,0),
	 zy     	 CHAR(30),
    kmdm	  	 CHAR(20),
	 bmry	  	 CHAR(8),
	 jord	  	 NUMERIC(3,0),
	 j	  		 NUMERIC(18,8),
	 d	  		 NUMERIC(18,8),
    shy	  	 CHAR(12),
    zdy	  	 CHAR(12),
	 czy	  	 CHAR(12),
    shbz   	 NUMERIC(3,0),
    sl     	 NUMERIC(18,8),
    dj     	 NUMERIC(18,8),
    proj   	 CHAR(20),
    amoform	 CHAR(248),
    qtyform	 CHAR(248),
	 scode	 CHAR(4),
    ca_mon 	 NUMERIC(10,0),
    zphjsdjh CHAR(20),
    wbje     NUMERIC(18,8),
    hl       NUMERIC(18,8),
    dqh      CHAR(4),
    gg       CHAR(14),
    dwdm     CHAR(4),
    lxr      CHAR(12),
    jsr      CHAR(12)					
);

CREATE TABLE ca_def
(
	id			NUMERIC(10,0) NOT NULL,
	title		CHAR(64),
	def		CHAR(128),
	def_int1	NUMERIC(10,0),
	def_int2	NUMERIC(10,0),
	def_str1	CHAR(64),
	def_date	date
);

DROP INDEX ca_ctr.ctrid;
DROP INDEX ca_item.itemid;
DROP INDEX ca_uet.uetid;
DROP INDEX ca_uer.uerid;
DROP INDEX ca_obj.objid;
DROP INDEX ca_flow.flowid;
DROP INDEX ca_mdl.mdlid;
DROP INDEX ca_bth.bthid;
DROP INDEX ca_mtx.mtxid;
DROP INDEX ca_jbt.jbtid;
DROP INDEX ca_rtn.rtnid;
DROP INDEX ca_jbq.jbqid;
DROP INDEX ca_jbb.jbbid;
DROP INDEX ca_dsf.dsfid;
DROP INDEX ca_dsrd.dsrdid;
DROP INDEX ca_expb.expbid;
DROP INDEX ca_rd.rdid;
DROP INDEX ca_mdc.mdcid;
DROP INDEX ca_anm.anmid;
DROP INDEX ca_aexp.aexpid;
DROP INDEX ca_prop.propid;
DROP INDEX ca_uch.uchid;
DROP INDEX ca_cdf.cdfid;
DROP INDEX ca_cdrd.cdrdid;
DROP INDEX ca_abctp.abctpid;
DROP INDEX ca_ma.maid;
DROP INDEX ca_obtp.obtpid;
DROP INDEX ca_batp.batpid;
DROP INDEX ca_extp.extpid;
DROP INDEX ca_itp.itpid;
DROP INDEX ca_unit.unitid;
DROP INDEX cb_qx.qxid;
DROP INDEX cb_pz.pzid;
DROP INDEX ca_def.defid;

CREATE UNIQUE INDEX ctrid  ON ca_ctr  (centerno);
CREATE UNIQUE INDEX itemid ON ca_item (itemcode);
CREATE UNIQUE INDEX uetid  ON ca_uet  (id);
CREATE UNIQUE INDEX uerid 	ON ca_uer  (centerno,itemcode);
CREATE UNIQUE INDEX objid 	ON ca_obj  (objectno);
CREATE UNIQUE INDEX flowid ON ca_flow  (flowno,centerno);
CREATE UNIQUE INDEX mdlid  ON ca_mdl   (flowno,objectno,centerno,itemcode);
CREATE UNIQUE INDEX bthid 	ON ca_bth   (id);
CREATE UNIQUE INDEX mtxid 	ON ca_mtx   (batchno,centerno,itemcode);
CREATE UNIQUE INDEX jbtid 	ON ca_jbt   (jobno);
CREATE UNIQUE INDEX rtnid 	ON ca_rtn   (centerno,objectno,jobno);
CREATE UNIQUE INDEX jbqid  ON ca_jbq   (centerno,batchno,jobno);
CREATE UNIQUE INDEX jbbid 	ON ca_jbb   (id);
CREATE UNIQUE INDEX dsfid  ON ca_dsf   (id);
CREATE UNIQUE INDEX dsrdid	ON ca_dsrd  (id,icourse);
CREATE UNIQUE INDEX expbid	ON ca_expb	(id);
CREATE UNIQUE INDEX rdid	ON ca_rd	   (id);
CREATE UNIQUE INDEX mdcid	ON  ca_mdc	(id);
CREATE UNIQUE INDEX anmid	ON  ca_anm	(centerno,batchno,itemcode,callno);
CREATE UNIQUE INDEX aexpid	ON  ca_aexp	(id);
CREATE UNIQUE INDEX propid	ON  ca_prop	(id);
CREATE UNIQUE INDEX uchid	ON  ca_uch	(funit,nunit);
CREATE UNIQUE INDEX cdfid	ON  ca_cdf	(id);
CREATE UNIQUE INDEX cdrdid	ON  ca_cdrd	(id,cla);
CREATE UNIQUE INDEX abctpid   ON  ca_abctp   (abc_type);
CREATE UNIQUE INDEX maid	ON  ca_ma	(mallno);
CREATE UNIQUE INDEX obtpid	ON  ca_obtp	(obtype);
CREATE UNIQUE INDEX batpid	ON  ca_batp	(batype);
CREATE UNIQUE INDEX extpid	ON  ca_extp	(extype);
CREATE UNIQUE INDEX itpid	ON  ca_itp (itemtype);
CREATE UNIQUE INDEX unitid	ON  ca_unit	(unitno);
CREATE UNIQUE INDEX qxid	ON  cb_qx (xm);
CREATE UNIQUE INDEX pzid	ON  cb_pz (id);
CREATE UNIQUE INDEX defid	ON  ca_def (id);

[CREATE INDEX]
DROP INDEX ca_bth.idx001;
DROP INDEX ca_bth.idx002;

DROP INDEX ca_mtx.idx005;

DROP INDEX ca_jbb.idx010;

DROP INDEX ca_expb.idx015;
DROP INDEX ca_expb.idx016;
DROP INDEX ca_expb.idx017;
DROP INDEX ca_expb.idx018;

DROP INDEX ca_rd.idx020;
DROP INDEX ca_rd.idx021;
DROP INDEX ca_rd.idx022;
DROP INDEX ca_rd.idx023;

DROP INDEX ca_aexp.idx030;

DROP INDEX cb_pz.idx035;

CREATE INDEX idx001 ON ca_bth(batchno DESC);
CREATE INDEX idx002 ON ca_bth(ca_mon DESC,ue_code,objectno);

CREATE INDEX idx005 ON ca_mtx(ca_mon DESC,ue_code,objectno,itemcode);

CREATE INDEX idx010 ON ca_jbb(ca_mon DESC,billno,jobno);

CREATE INDEX idx015 ON ca_expb(ca_mon DESC,billno);
CREATE INDEX idx016 ON ca_expb(ca_mon DESC,extype,billno);
CREATE INDEX idx017 ON ca_expb(ca_mon DESC,t_object,t_center,t_item);
CREATE INDEX idx018 ON ca_expb(ca_mon DESC,t_batch DESC,t_center,t_item);

CREATE INDEX idx020 ON ca_rd(ca_mon DESC,billno);
CREATE INDEX idx021 ON ca_rd(ca_mon DESC,extype,billno);
CREATE INDEX idx022 ON ca_rd(ca_mon DESC,objectno,centerno,itemcode);
CREATE INDEX idx023 ON ca_rd(ca_mon DESC,batchno DESC,centerno,itemcode);

CREATE INDEX idx030 ON ca_aexp(ca_mon DESC,centerno,itemcode,callno);

CREATE INDEX idx035 ON cb_pz(ca_mon DESC,pzh);
