[CREATE TABLE]
CREATE TABLE ca_ctr
(
	centerno	varchar(20) NOT NULL,
	ctname	varchar(64),
	lsign		tinyint,
	cttype	varchar(4),
	iszy		tinyint,
	zybm		varchar(20),
	allrate	double,	
	Primary key (centerno)
);
CREATE TABLE ca_item
(
	itemcode	varchar(20) NOT NULL,
	itemname	varchar(64),
	lsign		tinyint,
	itemtype	varchar(4),
	wlbm		varchar(20),
	aord		tinyint,
	forv		tinyint,
	abc_type	varchar(4),
	callno	varchar(4),
	msable	tinyint,
	qtyadd	tinyint,
	munit		varchar(4),
	nunit		varchar(4),
	ismain	tinyint,
	lvtype	varchar(4),
	lvnum		tinyint,
	planpri	double,
	opri		double,
	actno		varchar(20),
	oactno	varchar(20),
	de_int	integer,
	de_str	varchar(64),
	Primary key (itemcode)
);
CREATE TABLE ca_uet
(
	id		   integer NOT NULL,
	callno	varchar(4),
	allname	varchar(64),
	isign		tinyint,
	allnote	varchar(64),	
	PRIMARY KEY (id)
);
CREATE TABLE ca_uer
(
	centerno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	callno	varchar(4),
	PRIMARY KEY (centerno,itemcode)
);
CREATE TABLE ca_obj
(
	objectno	varchar(20) NOT NULL,
	obname	varchar(64),
	obtype	varchar(4),
	lsign		tinyint,
	itemno	varchar(20),
	subname	varchar(40),
	munit		varchar(4),
	nunit		varchar(4),
	mallno	varchar(4),
	allrate	double,
	badrate	double,
	salepri	double,
	qtytotal	double,
	amototal	double,
	sfixcost	double,
	ufixcost	double,
	uvarcost	double,
	uothcost	double,
	itemcode	varchar(20),
	flowno   varchar(20),
	actno		varchar(20),
	oactno	varchar(20),
	obnote	varchar(64),
	de_int	integer,
	de_str	varchar(64),
	PRIMARY KEY (objectno)
);
CREATE TABLE ca_flow
(
	flowno	varchar(20) NOT NULL,
	centerno	varchar(20) NOT NULL,
	flowname	varchar(64),
	ispri		tinyint,
	icourse	tinyint,
	descr		varchar(64),	
	PRIMARY KEY (flowno,centerno)
);
CREATE TABLE ca_mdl
(
	flowno	varchar(20) NOT NULL,
	objectno	varchar(20) NOT NULL,
	centerno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	icourse	tinyint,
	mallper	double,
	mallrate	double,
	mallamo	double,
	mdqua		double,
	mdamo		double,
	adqua		double,
	adamo		double,	
	de_int	integer,
	de_str	varchar(64),
	PRIMARY KEY (flowno,objectno,centerno,itemcode)
);
CREATE TABLE ca_bth
(
	id		   integer NOT NULL,
	batchno	varchar(20),
	fcode		varchar(20),
	ue_code	varchar(20),
	batype	varchar(4),
	deptno	varchar(20),
	objectno	varchar(20),
	flowno	varchar(20),
	ca_mon	integer,
	bdate		date,
	edate		date,
	tsign		tinyint,
	chksign	tinyint,
	comsign	tinyint,
	ord		varchar(20),
	chm		varchar(20),
	inm		varchar(20),
	banote	varchar(64),
	qty_plan	double,
	qty_font	double,
	amo_font	double,
	qty_outp	double,
	amo_outp	double,
	amo_sale	double,
	amo_stad	double,
	qty_next	double,
	amo_next	double,
	qty_tra	double,
	qty_trb	double,
	qty_trc	double,
	qty_trd	double,
	qty_tre	double,
	qty_trf	double,
	de_int	integer,
	de_str	varchar(64),
	Primary key (id)
);
CREATE TABLE ca_mtx
(
	batchno	varchar(20) NOT NULL,
	centerno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	deptno	varchar(20),
	ue_code	varchar(20),
	objectno	varchar(20),
	ca_mon	integer,
	aord		tinyint,
	msunit	varchar(4),
	icourse	tinyint,
	qty_plan	double,
	amo_plan	double,
	qty_font	double,
	amo_font	double,
	per_font	double,
	qty_cur	double,
	amo_cur	double,
	qty_outp	double,
	amo_outp	double,
	qty_next	double,
	amo_next	double,
	per_next	double,
	allper   double,
	dec_rpa	double,
	dec_rpb	double,
	dec_rpc	double,
	dec_rpd	double,
	dec_rpe	double,
	dec_rpf	double,
	de_int	integer,
	de_str	varchar(64),
	Primary key (batchno,centerno,itemcode)
);
CREATE TABLE ca_jbt
(
	jobno		varchar(4) NOT NULL,
	jobname	varchar(64),
	abc_type	varchar(4),
	msunit	varchar(4),
	jotype	tinyint,
	descr		varchar(64),	
	Primary key (jobno)
);
CREATE TABLE ca_rtn
(
	centerno	varchar(20) NOT NULL,
	objectno	varchar(20) NOT NULL,
	jobno		varchar(4) NOT NULL,
	ra_qua	double,
	Primary key (centerno,objectno,jobno)
);
CREATE TABLE ca_jbq
(
	centerno	varchar(20) NOT NULL,
	batchno	varchar(20) NOT NULL,
	jobno		varchar(4)  NOT NULL,
	deptno	varchar(20),
	objectno	varchar(20),
	ca_mon	integer,
	qty_rat	double,
	qty_rea	double,
	Primary key (centerno,batchno,jobno)
);
CREATE TABLE ca_jbb
(
	id		   integer NOT NULL,
	billno	varchar(20),
	jobno		varchar(4),
	deptno	varchar(20),
	ca_mon	integer,
	chksign	tinyint,
	bdate		date,
	edate		date,
	inm		varchar(20),
	chm		varchar(20),
	zybm		varchar(20),
	centerno	varchar(20),
	batchno	varchar(20),
	objectno	varchar(20),
	qty		double,
	unitcon	double,
	totalqty	double,
	js_numa	double,
	js_numb	double,
	js_numc	double,
	jsnote	varchar(64),
	js_infoa	varchar(64),
	js_infob	varchar(64),
	js_infoc	varchar(64),
	de_int	integer,
	de_str	varchar(64),
	Primary key (id)
);
CREATE TABLE ca_dsf
(
	id			integer NOT NULL,
	systp		tinyint,
	gettype	varchar(4),
	centerno	varchar(20),
	itemcode	varchar(20),
	objectno	varchar(20),
	callno	varchar(4),
	allrate	double,
	cacsign	tinyint,
	Primary key (id)
);
CREATE TABLE ca_dsrd
(
	id			integer NOT NULL,
	icourse	tinyint NOT NULL,
	cactp		varchar(4),
	lbracket	varchar(12),
	listid	varchar(12),
	matchtp	varchar(4),
	rbracket	varchar(12),
	svalue	varchar(64),
	Primary key (id,icourse)
);
CREATE TABLE ca_expb
(
	id			integer NOT NULL,
	billno	varchar(20),
	extype	varchar(4),
	itemtype	varchar(4),
	jobno		varchar(4),
	origno	varchar(20),
	chksign	tinyint,
	ca_mon	integer,
	rdate		date,
	whno		varchar(20),
	deptno	varchar(20),
	centerno	varchar(20),
	objectno	varchar(20),
	batchno	varchar(20),
	chm		varchar(20),
	inm		varchar(20),
	iscacu	tinyint,
	sysmake	tinyint,
	t_dept	varchar(20),
	t_center	varchar(20),
	t_item	varchar(20),
	t_itemno	varchar(20),
	ranks		char(2),
	t_object	varchar(20),
	t_batch	varchar(20),
	pri		double,
	qua		double,
	amo		double,
	exnote	varchar(64),
	de_int	integer,
	de_str	varchar(64),
	Primary key (id)
);
CREATE TABLE ca_rd
(
	id			integer NOT NULL,
	billno	varchar(20),
	extype	varchar(4),
	itemtype	varchar(4),
	ca_mon	integer,
	orgino	varchar(20),
	deptno	varchar(20),
	centerno	varchar(20),
	itemcode	varchar(20),
	msunit	varchar(4),
	objectno	varchar(20),
	batchno	varchar(20),
	rdate		date,
	qty		double,
	amo		double,
	iscacu	tinyint,
	renote	varchar(64),
	de_int	integer,
	de_str	varchar(64),
	Primary key (id)
);
CREATE TABLE ca_mdc
(
	id			integer NOT NULL,
	whid		varchar(20),
	objectno	varchar(20),
	itemcode	varchar(20),
	itemno	varchar(20),
	ca_mon	integer,
	ranks		char(2),
	msunit	varchar(4),
	qty_font	double,
	amo_font	double,
	qty_pur	double,
	amo_pur	double,
	qty_pro	double,
	amo_pro	double,
	chnote	varchar(64),	
	Primary key (id)
);
CREATE TABLE ca_anm
(
	centerno	varchar(20) NOT NULL,
	batchno	varchar(20) NOT NULL,
	itemcode	varchar(20) NOT NULL,
	callno	varchar(4)  NOT NULL,
	objectno	varchar(20),
	ca_mon	integer,
	qty_base	double,
	Primary key (centerno,batchno,itemcode,callno)
);
CREATE TABLE ca_aexp
(
	id			integer NOT NULL,
	centerno	varchar(20),
	itemcode	varchar(20),
	ca_mon	integer,
	callno	varchar(4),
	msunit	varchar(4),
	isturn	tinyint,
	isall		tinyint,
	qty_add	double,
	qty_all	double,
	amo_all	double,
	Primary key (id)
);
CREATE TABLE ca_prop
(
	id			integer NOT NULL,
	p01		integer,
	p02		integer,
	p03		integer,
	p04		integer,
	p05		integer,
	p06		integer,
	p07		integer,
	p08		integer,
	p09		integer,
	p10		integer,
	p11		integer,
	p12		integer,	
	Primary key (id)
);
CREATE TABLE ca_uch
(
	funit		varchar(4) NOT NULL,
	nunit		varchar(4) NOT NULL,
	relat		double,
	msnote		varchar(64),
	Primary key (funit,nunit)
);
CREATE TABLE ca_cdf
(
	id				varchar(4) NOT NULL,
	sfname		varchar(64),
	sftype		varchar(4),
	maxcla		integer,
	maxlen		integer,
	sinlen		integer,
	ismanu		tinyint,
	Primary key (id)
);
CREATE TABLE ca_cdrd
(
	id			varchar(4) NOT NULL,
	cla		integer NOT NULL,
	len		integer,
	val		varchar(20),
	constr	varchar(20),
	de_int1 	integer,
	de_int2  integer,
  	de_str1	varchar(12),
  	de_str2 	varchar(64),
	Primary key (id,cla)
);
CREATE TABLE ca_abctp
(
 	abc_type	varchar(4) NOT NULL,
  	descr		varchar(64),
  	de_str1 	varchar(12),
  	de_str2 	varchar(12),
  	de_str3 	varchar(64),
   Primary key (abc_type)
);
CREATE TABLE ca_ma
(
	mallno	varchar(4) NOT NULL,
	descr		varchar(64),
	Primary key (mallno)
);
CREATE TABLE ca_obtp
(
	obtype	varchar(4) NOT NULL,
	descr		varchar(64),
	Primary key (obtype)
);
CREATE TABLE ca_batp
(
	batype	varchar(4) NOT NULL,
	descr		varchar(64),
	Primary key (batype)
);
CREATE TABLE ca_extp
(
	extype	varchar(4) NOT NULL,
	descr		varchar(64),
   isadd		tinyint,
	isamo		tinyint,
	de_str	varchar(64),
	Primary key (extype)
);
CREATE TABLE ca_itp
(
	itemtype	varchar(4) NOT NULL,
	descr		varchar(64),
	Primary key (itemtype)
);
CREATE TABLE ca_unit
(
	unitno	varchar(4) NOT NULL,
	descr		varchar(64),
	defstr	varchar(20),
	ismain	tinyint,
	Primary key (unitno)
);
CREATE TABLE cb_qx
(
	 xm  		varchar(20) NOT NULL ,		
	 mm  		varchar(254),					
	 bm  		varchar(20),				
	 cno 		varchar(20),
	 q0  		tinyint,
    q1  		tinyint,
	 q1_1	 	tinyint, 
	 q1_2  	tinyint,
	 q1_3  	tinyint,    
	 q1_4  	tinyint,
	 q1_5  	tinyint,
	 q1_6  	tinyint,					
	 q1_7  	tinyint,					
	 q1_8  	tinyint,					
	 q1_9  	tinyint,					
	 q1_a 	tinyint,					
	 q1_b  	tinyint,					 
	 q1_c  	tinyint,					
	 q1_d  	tinyint,               
	 q1_e  	tinyint,					
	 q1_f  	tinyint,	 
	 q1_g  	tinyint,               
	 q1_h  	tinyint,					
	 q1_i  	tinyint,					
	 q2    	tinyint,					
	 q2_1  	tinyint, 
	 q2_2  	tinyint,
	 q2_3  	tinyint,    
	 q2_4  	tinyint,
	 q2_5  	tinyint,
	 q2_6  	tinyint,					
	 q2_7  	tinyint,
	 q2_8  	tinyint,
	 q3    	tinyint,					
	 q3_1  	tinyint, 
	 q3_2  	tinyint,
	 q3_3  	tinyint,    
	 q3_4  	tinyint,
	 q3_5  	tinyint,
	 q3_6  	tinyint,					
	 q3_7  	tinyint,					
	 q3_8  	tinyint,					
	 q3_9  	tinyint,
	 q3_a  	tinyint,
	 q3_b  	tinyint,					
	 q3_c  	tinyint,	
	 q4    	tinyint,					
	 q4_1  	tinyint, 
	 q4_2  	tinyint,
	 q4_3  	tinyint,    
	 q4_4  	tinyint,
	 q4_5  	tinyint,
	 q4_6  	tinyint,
	 q5    	tinyint,
	 q5_1  	tinyint, 
	 q5_2  	tinyint,
	 q5_3  	tinyint,    
	 q5_4  	tinyint,
	 q5_5  	tinyint,
	 q5_6 	tinyint,					
	 q5_7  	tinyint,					
	 q5_8  	tinyint,					
	 q5_9  	tinyint,
	 q5_a  	tinyint,					
	 q5_b  	tinyint,					 
	 q5_c 	tinyint,					
	 q5_d  	tinyint,
	 q6    	tinyint,
    q7		tinyint,
	 q7_1  	tinyint, 
	 q7_2  	tinyint,
	 q7_3  	tinyint,    
	 q7_4  	tinyint,	
	 PRIMARY KEY (xm)
);

CREATE TABLE cb_pz
(
	 id	  	 integer NOT NULL ,		
	 jzbz	  	 tinyint,
	 csign  	 tinyint,
	 pzrq   	 date,
	 pzlx   	 varchar(1),
    pzh    	 varchar(4),
	 fj	  	 tinyint,
	 zy     	 varchar(30),
    kmdm	  	 varchar(20),
	 bmry	  	 varchar(12),
	 jord	  	 tinyint,
	 j	  		 double,
	 d	  		 double,
    shy	  	 varchar(12),
    zdy	  	 varchar(12),
	 czy	  	 varchar(12),
    shbz   	 tinyint,
    sl     	 double,
    dj     	 double,
    proj   	 varchar(20),
    amoform	 varchar(248),
    qtyform	 varchar(248),
	 scode	 varchar(4),
    ca_mon 	 integer,	
    zphjsdjh varchar(20),
    wbje     double,
    hl       double,
    dqh      varchar(4),
    gg       varchar(14),
    dwdm     varchar(4),
    lxr      varchar(12),
    jsr      varchar(12),					
	 PRIMARY KEY (id)
);

CREATE TABLE ca_def
(
	id			integer NOT NULL,
	title		varchar(64),
	def		varchar(128),
	def_int1	integer,
	def_int2	integer,
	def_str1	varchar(64),
	def_date	date,
	Primary key (id)
);

[CREATE INDEX]
DROP INDEX idx001;
DROP INDEX idx002;

DROP INDEX idx005;

DROP INDEX idx010;

DROP INDEX idx015;
DROP INDEX idx016;
DROP INDEX idx017;
DROP INDEX idx018;

DROP INDEX idx020;
DROP INDEX idx021;
DROP INDEX idx022;
DROP INDEX idx023;

DROP INDEX idx030;

DROP INDEX idx035;

CREATE INDEX idx001 ON ca_bth(batchno DESC);
CREATE INDEX idx002 ON ca_bth(ca_mon DESC,ue_code,objectno);

CREATE INDEX idx005 ON ca_mtx(ca_mon DESC,ue_code,objectno,itemcode);

CREATE INDEX idx010 ON ca_jbb(ca_mon DESC,billno,jobno);

CREATE INDEX idx015 ON ca_expb(ca_mon DESC,billno);
CREATE INDEX idx016 ON ca_expb(ca_mon DESC,extype,billno);
CREATE INDEX idx017 ON ca_expb(ca_mon DESC,t_object,t_center,t_item);
CREATE INDEX idx018 ON ca_expb(ca_mon DESC,t_batch DESC,t_center,t_item);

CREATE INDEX idx020 ON ca_rd(ca_mon DESC,billno);
CREATE INDEX idx021 ON ca_rd(ca_mon DESC,extype,billno);
CREATE INDEX idx022 ON ca_rd(ca_mon DESC,objectno,centerno,itemcode);
CREATE INDEX idx023 ON ca_rd(ca_mon DESC,batchno DESC,centerno,itemcode);

CREATE INDEX idx030 ON ca_aexp(ca_mon DESC,centerno,itemcode,callno);

CREATE INDEX idx035 ON cb_pz(ca_mon DESC,pzh);
           