[CREATE TABLE]
CREATE TABLE fx_ver
(
	id		NUMERIC(4,0) ,
	ver	NUMERIC(6,0) ,
	dat	NUMERIC(6,0) ,
	dt		DATE ,
	str	CHAR(30) 
);
CREATE TABLE fx_qx
(
	xm		CHAR(8) ,
	mm		CHAR(254) ,
	bm		CHAR(14) ,
	q0		NUMERIC(1,0) ,
	q1		NUMERIC(1,0) ,
	q2		NUMERIC(1,0) ,
	q3		NUMERIC(1,0) ,
	q4		NUMERIC(1,0) ,
	q5		NUMERIC(1,0) 
);
CREATE TABLE fx_proj
(
	id			NUMERIC(4,0) ,
	note		CHAR(30),
	plantype	NUMERIC(3,0),
	iscum		NUMERIC(3,0),
	style1	NUMERIC(3,0),
	style2	NUMERIC(3,0),
	style3	NUMERIC(3,0),
	style4	NUMERIC(3,0),
	style5	NUMERIC(3,0),
	bmdm		CHAR(8)
);
CREATE TABLE fx_bm
(
	bmdm			CHAR(8),
	bmmc			CHAR(30)
);
CREATE TABLE fx_item
(
	id			NUMERIC(6,0) ,
	projid	NUMERIC(4,0) ,
	source	NUMERIC(1,0) ,
	lvl		NUMERIC(1,0) ,
	sequence	NUMERIC(4,0) ,
	note		CHAR(30) ,
	form		CHAR(160),
	plandata	NUMERIC(16,4)
);
CREATE TABLE fx_data
(
	id			NUMERIC(6,0) ,
	projid	NUMERIC(4,0) ,
	itemid	NUMERIC(6,0) ,
	mon		NUMERIC(2,0) ,
	dat		NUMERIC(16,4)
);
CREATE TABLE fx_plan
(
	id				NUMERIC(6,0),
	projid		NUMERIC(4,0),
	itemid		NUMERIC(6,0),
	plan01		NUMERIC(16,2),
	plan02		NUMERIC(16,2),
	plan03		NUMERIC(16,2),
	plan04		NUMERIC(16,2),
	plan05		NUMERIC(16,2),
	plan06		NUMERIC(16,2),
	plan07		NUMERIC(16,2),
	plan08		NUMERIC(16,2),
	plan09		NUMERIC(16,2),
	plan10		NUMERIC(16,2),
	plan11		NUMERIC(16,2),
	plan12		NUMERIC(16,2),
	mayuse01		NUMERIC(16,2),
	mayuse02		NUMERIC(16,2),
	mayuse03		NUMERIC(16,2),
	mayuse04		NUMERIC(16,2),
	mayuse05		NUMERIC(16,2),
	mayuse06		NUMERIC(16,2),
	mayuse07		NUMERIC(16,2),
	mayuse08		NUMERIC(16,2),
	mayuse09		NUMERIC(16,2),
	mayuse10		NUMERIC(16,2),
	mayuse11		NUMERIC(16,2),
	mayuse12		NUMERIC(16,2),
	comp01		NUMERIC(16,2),
	comp02		NUMERIC(16,2),
	comp03		NUMERIC(16,2),
	comp04		NUMERIC(16,2),
	comp05		NUMERIC(16,2),
	comp06		NUMERIC(16,2),
	comp07		NUMERIC(16,2),
	comp08		NUMERIC(16,2),
	comp09		NUMERIC(16,2),
	comp10		NUMERIC(16,2),
	comp11		NUMERIC(16,2),
	comp12		NUMERIC(16,2),
	lvl			NUMERIC(1,0),
	sequence		NUMERIC(4,0)
);
CREATE TABLE fx_query
(
    id        NUMERIC(6,0)     ,
    xmdm      CHAR(10)         ,
    xmmc      CHAR(50)         ,
    dwdm      CHAR(10)         ,
    dwmc      CHAR(50)         ,
    kmdm      CHAR(12)         ,
    kmmc      CHAR(20)         ,
    def_str1  CHAR(64)         ,
    def_str2  CHAR(64)         ,
    def_str3  CHAR(64)         ,
    def_int1  NUMERIC(10,0)    ,
    fef_int2  NUMERIC(10,0)    ,
    def_int3  NUMERIC(10,0)    ,
    def_num1  numeric(18,6)    ,
    def_num2  numeric(18,6)    ,
    def_num3  numeric(18,6)   
);

[CREATE INDEX]
DROP INDEX fx_bm.fx_bm;
DROP INDEX fx_plan.fx_plan;
DROP INDEX fx_qx.fx_qx;
DROP INDEX fx_proj.fx_proj;
DROP INDEX fx_item.fx_item;
DROP INDEX fx_data.fx_data;
DROP INDEX fx_item.fx_itemid;
DROP INDEX fx_data.fx_dataid;
DROP INDEX fx_query.fx_query;

CREATE UNIQUE INDEX fx_bm		ON fx_bm		(bmdm);
CREATE UNIQUE INDEX fx_plan	ON fx_plan	(id);
CREATE UNIQUE INDEX fx_qx		ON fx_qx		(	xm	);
CREATE UNIQUE INDEX fx_proj	ON fx_proj	(	id	);
CREATE UNIQUE INDEX fx_item	ON fx_item	(	id	);
CREATE UNIQUE INDEX fx_data	ON fx_data	(	id	);
CREATE UNIQUE INDEX fx_query  ON fx_query	(	id );
CREATE INDEX fx_itemid			ON fx_item	(	projid );
CREATE INDEX fx_dataid			ON fx_data	(	projid );
