[CREATE TABLE]
CREATE TABLE x_htcl
(
	id        	integer	NOT NULL	,
	jclass    	varchar(20)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_ht
(
	id        	integer	NOT NULL	,
	kpr       	varchar(10)	NULL	,
	isstop    	tinyint	NULL	,
	xfdqmc    	varchar(10)	NULL	,
	htdm      	varchar(30)	NULL	,
	xfdq      	varchar(4)	NULL	,
	xfdm      	varchar(4)	NULL	,
	xfmc      	varchar(60)	NULL	,
	xfdz      	varchar(60)	NULL	,
	xffr      	varchar(10)	NULL	,
	xfdlr     	varchar(10)	NULL	,
	xfdh      	varchar(20)	NULL	,
	xfkhyh    	varchar(60)	NULL	,
	xfkhym    	varchar(10)	NULL	,
	xfzh      	varchar(30)	NULL	,
	xfyb      	varchar(10)	NULL	,
	xfsh      	varchar(30)	NULL	,
	gfdm      	varchar(4)	NULL	,
	gfmc      	varchar(60)	NULL	,
	gfdz      	varchar(60)	NULL	,
	gffr      	varchar(10)	NULL	,
	gfdlr     	varchar(14)	NULL	,
	gfdh      	varchar(20)	NULL	,
	gfkhyh    	varchar(60)	NULL	,
	gfkhym    	varchar(10)	NULL	,
	gfzh      	varchar(30)	NULL	,
	gfyb      	varchar(10)	NULL	,
	gfsh      	varchar(30)	NULL	,
	qddd      	varchar(30)	NULL	,
	qdrq      	date	NULL	,
	bz        	varchar(254)	NULL	,
	sxrq      	date	NULL	,
	zzrq      	date	NULL	,
	zt        	tinyint	NULL	,
	jclass    	tinyint	NULL	,
	je        	numeric(19,6)	NULL	,
	skje      	numeric(19,6)	NULL	,
	wbje			numeric(19,6) NULL,
	wbfh			varchar(4) NULL,
	wbrate		numeric(19,6) NULL,
	zkje			numeric(19,6)	NULL	,
	hxje			numeric(19,6) NULL,
	bchx			numeric(19,6) NULL,
	hxbz			tinyint NULL,
	yearbz		varchar(4) NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_hthw
(
	id        	integer	NOT NULL	,
	sk_je     	numeric(19,6)	NULL	,
	fh_sl     	numeric(19,6)	NULL	,
	htdm      	varchar(30)	NULL	,
	htcl      	smallint	NULL	,
	htid      	integer	NULL	,
	rq        	date	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwsl      	numeric(19,6)	NULL	,
	hwdj      	numeric(19,6)	NULL	,
	je        	numeric(19,6)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	sldw      	varchar(10)	NULL	,
	fp_sl     	numeric(19,6)	NULL	,
	fp_je     	numeric(19,6)	NULL	,
	xs_dje1   	numeric(19,6)	NULL	,
	xs_dje2   	numeric(19,6)	NULL	,
	xs_dje3   	numeric(19,6)	NULL	,
	xs_dje4   	numeric(19,6)	NULL	,
	zkl       	numeric(19,6)	NULL	,
	zke       	numeric(19,6)	NULL	,
	ckdm      	varchar(4)	NULL	,
	kmdm      	varchar(20)	NULL	,
	wbje			numeric(19,6) NULL,
	slu	numeric(19,6)	null,
	hsdj	numeric(19,6)	null,
	fh_je	numeric(19,6)	null,
	th_sl	numeric(19,6)	null,
	th_je	numeric(19,6)	null,
	ch_sl	numeric(19,6)	null,
	ch_je	numeric(19,6)	null,
	sk_sl	numeric(19,6)	null,
	yhxje     	numeric(19,6)	NULL	,
	bchxje    	numeric(19,6)	NULL	,
	yhxsl     	numeric(19,6)	NULL	,
	bchxsl    	numeric(19,6)	NULL	,
	ishx      	tinyint	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_htzk
(
	htid      	integer	NOT NULL	,
	rq        	date	NULL	,
	je        	numeric(19,6)	NULL	,
	bz        	varchar(254)	NULL	,
	dt1       	date	NULL	,
	dt2       	date	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	PRIMARY KEY(htid)
);
CREATE TABLE x_fh
(
	id        	integer	NOT NULL	,
	wldw      	varchar(60)	NULL	,
	bmdm      	varchar(9)	NULL	,
	kpr       	varchar(10)	NULL	,
	zt        	smallint	NULL	,
	pwd       	varchar(10)	NULL	,
	thr       	varchar(10)	NULL	,
	ckdm      	char(2)	NULL	,
	startrq   	date	NULL	,
	endrq     	date	NULL	,
	dqh       	varchar(10)	NULL	,
	dqmc      	varchar(10)	NULL	,
	fph       	varchar(10)	NULL	,
	style     	smallint	NULL	,
	bz        	varchar(254)	NULL	,
	used      	smallint	NULL	,
	jcarry    	smallint	NULL	,
	user01    	varchar(20)	NULL	,
	pjh       	varchar(16)	NULL	,
	rq        	date	NULL	,
	htdm      	varchar(30)	NULL	,
	jclass    	tinyint	NULL	,
	dwdm      	varchar(10)	NULL	,
	iskp		smallint	NULL	,
	je numeric(19,6) NULL,
	zkje numeric(19,6) NULL,
	hxje numeric(19,6) NULL,
	bchx numeric(19,6) NULL,
	hxbz tinyint NULL,
	lx		tinyint NULL,
	iszf	tinyint NULL,
	htid	integer	null,
        fromxj  smallint NULL,
	yearbz			varchar(4) NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_fhhw
(
	id        	integer	NOT NULL	,
	fhid      	integer	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	sldw      	varchar(6)	NULL	,
	sl        	numeric(19,6)	NULL	,
	hwgg      	varchar(50)	NULL	,
	sfsl      	numeric(19,6)	NULL	,
	ckdm      	char(2)	NULL	,
	htdm      	varchar(30)	NULL	,
	kmdm      	varchar(20)	NULL	,
	dj        	numeric(19,6)	NULL	,
	xs_dj1    	numeric(19,6)	NULL	,
	xs_dj2    	numeric(19,6)	NULL	,
	xs_dj3    	numeric(19,6)	NULL	,
	xs_dj4    	numeric(19,6)	NULL	,
	ph        	varchar(40)	NULL	,
	yksl		numeric(19,6)		NUll	,
	ykje		numeric(19,6)		NULL	,
	zkl	numeric(19,6) 	null,
	zke numeric(19,6)		null,
	bz			varchar(254) null,
	slu	numeric(19,6)	null,
	hsdj	numeric(19,6)	null,
	fp_je	numeric(19,6)	null,
	fp_sl	numeric(19,6)	null,
	htid	integer	null,
	th_sl	numeric(19,6)	null,
	th_je	numeric(19,6)	null,
	yhxje     	numeric(19,6)	NULL	,
	bchxje    	numeric(19,6)	NULL	,
	yhxsl     	numeric(19,6)	NULL	,
	bchxsl    	numeric(19,6)	NULL	,
	ishx      	tinyint	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_fp
(
	id        	integer	NOT NULL	,
	fph       	varchar(16)	NULL	,
	rq        	date	NULL	,
	bank      	varchar(60)	NULL	,
	zh        	varchar(30)	NULL	,
	sz        	varchar(8)	NULL	,
	se        	numeric(19,6)	NULL	,
	je        	numeric(19,6)	NULL	,
	jsfs      	tinyint	NULL	,
	jspjh     	varchar(10)	NULL	,
	kpr       	varchar(14)	NULL	,
	shr       	varchar(14)	NULL	,
	skr       	varchar(14)	NULL	,
	bz        	varchar(254)	NULL	,
	fptype    	smallint	NULL	,
	kmdm      	varchar(20)	NULL	,
	htdm      	varchar(30)	NULL	,
	iszf      	smallint	NULL	,
	emp       	varchar(14)	NULL	,
	zt        	tinyint	NULL	,
	jzr       	varchar(14)	NULL	,
	dqh       	varchar(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwdm      	varchar(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	dwtel     	varchar(20)	NULL	,
	dwzp      	varchar(10)	NULL	,
	dwkhh     	varchar(60)	NULL	,
	dwzh      	varchar(30)	NULL	,
	dwsh      	varchar(30)	NULL	,
	dwaddr    	varchar(60)	NULL	,
	htid      	integer	NULL	,
	pzh       	varchar(10)	NULL	,
	pzrq      	date	NULL	,
	ddfy      	numeric(19,6)	NULL	,
	ddjs      	integer	NULL	,
	ddjsh     	varchar(10)	NULL	,
	iskp      	tinyint	NULL	,
	isok      	tinyint	NULL	,
	style     	tinyint	NULL	,
	fhd       	varchar(10)	NULL	,
	ischeck   	tinyint	NULL	,
	ishs      	tinyint	NULL	,
	hsje_s    	numeric(19,6)	NULL	,
	hxje numeric(19,6) NULL,
	bchx numeric(19,6) NULL,
	hxbz tinyint NULL,
	wbje			numeric(19,6) NULL,
	wbfh			varchar(4) NULL,
	wbrate		numeric(19,6) NULL,
	zkje numeric(19,6) NULL,
	chfpyj	varchar(20) NULL,
	zzsfph	varchar(20) NULL,
	chje		numeric(19,6) NULL,
	chse		numeric(19,6) NULL,
	istransout      	tinyint	NULL,
        fromxj  smallint NULL,
	yearbz			varchar(4) NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_fphw
(
	id        	integer	NOT NULL	,
	fpid      	integer	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	sldw      	varchar(6)	NULL	,
	sl        	numeric(19,6)	NULL	,
	dj        	numeric(19,6)	NULL	,
	je        	numeric(19,6)	NULL	,
	se        	numeric(19,6)	NULL	,
	slu       	numeric(19,6)	NULL	,
	htid      	integer	NULL	,
	htdm      	varchar(30)	NULL	,
	maoli     	numeric(19,6)	NULL	,
	yhxje     	numeric(19,6)	NULL	,
	bchxje    	numeric(19,6)	NULL	,
	yhxsl     	numeric(19,6)	NULL	,
	bchxsl    	numeric(19,6)	NULL	,
	xs_dje1   	numeric(19,6)	NULL	,
	xs_dje2   	numeric(19,6)	NULL	,
	xs_dje3   	numeric(19,6)	NULL	,
	xs_dje4   	numeric(19,6)	NULL	,
	ckdm      	varchar(4)	NULL	,
	kmdm      	varchar(20)	NULL	,
	ishx      	tinyint	NULL	,
	yksl		numeric(19,6)		NUll	,
	ykje		numeric(19,6)		NULL	,
	wbje			numeric(19,6) NULL,
	zkl numeric(19,6) NULL,
	zke numeric(19,6) NULL,
	hsdj	numeric(19,6)	null,
	chje	numeric(19,6)	NULL,
	chse	numeric(19,6)	NULL,
	chsl	numeric(19,6) 	NULL,
	fh_je	numeric(19,6)	null,
	fh_sl	numeric(19,6)	null,
	PRIMARY KEY(id)
);
CREATE TABLE x_fpty
(
	id integer NOT NULL,
	fptype    	varchar(30)	NULL	,
	jrows     	integer	NULL	,
	book      	int	NULL	,
	tpfile    	varchar(12)	NULL	,
	width     	numeric(19,6)	NULL	,
	height    	numeric(19,6)	NULL	,
	hmgrp     	numeric(19,6)	NULL	,
	limit     	numeric(19,6)	NULL	,
	hmnow     	varchar(16)	NULL	,
	hmlen     	integer	NULL	,
	sl        	numeric(19,6)	NULL	,
	issp      	smallint	NULL	,
	hmstart		varchar(16)	NULL	,
	hmend			varchar(16)	NULL	,
	zfs			INTEGER NULL,
	chs			INTEGER NULL,
	isend			SMALLINT NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_fpzt
(
	id        	tinyint	NOT NULL	,
	fpzt      	varchar(10)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_sk
(
	id integer NOT NULL,
	htdm      	varchar(30)	NULL	,
	dwdm      	varchar(10)	NULL	,
	wldw      	varchar(60)	NULL	,
	je        	numeric(19,6)	NULL	,
	jsfs      	integer	NULL	,
	jspjh     	varchar(10)	NULL	,
	skr       	varchar(10)	NULL	,
	shr       	varchar(10)	NULL	,
	bz        	varchar(254)	NULL	,
	fkr       	varchar(10)	NULL	,
	yhxje     	numeric(19,6)	NULL	,
	ishx      	integer	NULL	,
	fph       	varchar(20)	NULL	,
	je1       	numeric(19,6)	NULL	,
	je2       	numeric(19,6)	NULL	,
	je3       	numeric(19,6)	NULL	,
	je4       	numeric(19,6)	NULL	,
	je5       	numeric(19,6)	NULL	,
	je6       	numeric(19,6)	NULL	,
	je7       	numeric(19,6)	NULL	,
	je8       	numeric(19,6)	NULL	,
   je9       	numeric(19,6)	NULL	,
	je10       	numeric(19,6)	NULL	,
	je11       	numeric(19,6)	NULL	,
	je12       	numeric(19,6)	NULL	,
	je13       	numeric(19,6)	NULL	,
	je14       	numeric(19,6)	NULL	,
   je15       	numeric(19,6)	NULL	,
	conbh     	varchar(10)	NULL	,
	jhkm      	varchar(20)	NULL	,
	kmdm      	varchar(20)	NULL	,
	sl        	numeric(19,6)	NULL	,
	dj        	numeric(19,6)	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	zt        	smallint	NULL	,
	jclass    	smallint	NULL	,
	dqh       	varchar(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	emp       	varchar(14)	NULL	,
	ischeck   	tinyint	NULL	,
	zkl       	numeric(19,6)	NULL	,
	zke       	numeric(19,6)	NULL	,
	hxje      	numeric(19,6)	NULL	,
	pzh       	char(4)	NULL	,
	fhd       	char(20)	NULL	,
	ishs      	integer	NULL	,
	hsje_s    	numeric(19,6)	NULL	,
	pjh       	varchar(16)	NULL	,
	rq        	date	NULL	,
        shrq        	date	NULL	,
	wbje			numeric(19,6) NULL,
	wbfh			varchar(4) NULL,
	wbrate		numeric(19,6) NULL,
	tkje			numeric(19,6) NULL,
        fromdd      smallint NULL,
        fromxj  smallint NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_skcls
(
	id        	smallint	NOT NULL	,
	jclass    	varchar(10)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_skhx
(
	htid	integer NOT NULL,
	skid  integer	NOT NULL	,
	fpid  integer	NOT NULL	,
	hxje  numeric(19,6)	NULL	,
	bz    varchar(254)	NULL	,
	dt1   date	NULL	,
	dt2   date	NULL	,
	d1    numeric(19,6)	NULL	,
	d2    numeric(19,6)	NULL	,
	str1  varchar(40)	NULL	,
	str2  varchar(40)	NULL	,
	PRIMARY KEY(htid,skid,fpid)
);
CREATE TABLE x_skhxmx
(
	htid      	integer	NOT NULL	,
	fpid      	integer	NOT NULL	,
	hwdm      	varchar(20)	NOT NULL	,
	yhxje     	numeric(19,6)	NULL	,
	bchxje    	numeric(19,6)	NULL	,
	bz        	varchar(254)	NULL	,
	dt1       	date	NULL	,
	dt2       	date	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	PRIMARY KEY(htid,fpid,hwdm)
);
CREATE TABLE x_skpzmb
(
	id        	integer	NOT NULL	,
	zy        	varchar(40)	NULL	,
	kmdm      	varchar(20)	NULL	,
	j_d       	varchar(4)	NULL	,
	je        	varchar(40)	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	dt1       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_xsjh
(
	emp			varchar(20)	NOT NULL,
	islb			tinyint		NULL,
	ftbl			numeric(19,6)		NULL,
	njh			numeric(19,6)		NULL,
	nde			numeric(19,6)		NULL,
	jh1			numeric(19,6)		NULL,
	de1			numeric(19,6)		NULL,
	jh2			numeric(19,6)		NULL,
	de2			numeric(19,6)		NULL,
	jh3			numeric(19,6)		NULL,
	de3			numeric(19,6)		NULL,
	jh4			numeric(19,6)		NULL,
	de4			numeric(19,6)		NULL,
	jh5			numeric(19,6)		NULL,
	de5			numeric(19,6)		NULL,
	jh6			numeric(19,6)		NULL,
	de6			numeric(19,6)		NULL,
	jh7			numeric(19,6)		NULL,
	de7			numeric(19,6)		NULL,
	jh8			numeric(19,6)		NULL,
	de8			numeric(19,6)		NULL,
	jh9			numeric(19,6)		NULL,
	de9			numeric(19,6)		NULL,
	jh10			numeric(19,6)		NULL,
	de10			numeric(19,6)		NULL,
	jh11			numeric(19,6)		NULL,
	de11			numeric(19,6)		NULL,
	jh12			numeric(19,6)		NULL,
	de12			numeric(19,6)		NULL,
	PRIMARY KEY(emp)
);
CREATE TABLE x_hwxsjh
(
	id				integer		NOT NULL,
	emp			varchar(20)	NULL,
	hwdm			varchar(20)	NULL,
	hwgg			varchar(50)	NULL,
	jldw			varchar(6)	NULL,
	ftbl			numeric(19,6)		NULL,
	njh			numeric(19,6)		NULL,
	nde			numeric(19,6)		NULL,
	jh1			numeric(19,6)		NULL,
	de1			numeric(19,6)		NULL,
	jh2			numeric(19,6)		NULL,
	de2			numeric(19,6)		NULL,
	jh3			numeric(19,6)		NULL,
	de3			numeric(19,6)		NULL,
	jh4			numeric(19,6)		NULL,
	de4			numeric(19,6)		NULL,
	jh5			numeric(19,6)		NULL,
	de5			numeric(19,6)		NULL,
	jh6			numeric(19,6)		NULL,
	de6			numeric(19,6)		NULL,
	jh7			numeric(19,6)		NULL,
	de7			numeric(19,6)		NULL,
	jh8			numeric(19,6)		NULL,
	de8			numeric(19,6)		NULL,
	jh9			numeric(19,6)		NULL,
	de9			numeric(19,6)		NULL,
	jh10			numeric(19,6)		NULL,
	de10			numeric(19,6)		NULL,
	jh11			numeric(19,6)		NULL,
	de11			numeric(19,6)		NULL,
	jh12			numeric(19,6)		NULL,
	de12			numeric(19,6)		NULL,
	hwmc			varchar(50) NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_emp
(
	id        	integer	NOT NULL	,
	xsje1     	numeric(19,6)	NULL	,
	xsje2     	numeric(19,6)	NULL	,
	xsje3     	numeric(19,6)	NULL	,
	xsje4     	numeric(19,6)	NULL	,
	xsje5     	numeric(19,6)	NULL	,
	xsje6     	numeric(19,6)	NULL	,
	xsje7     	numeric(19,6)	NULL	,
	xsje8     	numeric(19,6)	NULL	,
	xsje9     	numeric(19,6)	NULL	,
	xsje10    	numeric(19,6)	NULL	,
	xsje11    	numeric(19,6)	NULL	,
	xsje12    	numeric(19,6)	NULL	,
	jtzz      	varchar(80)	NULL	,
	tel       	varchar(40)	NULL	,
	bz        	varchar(254)	NULL	,
	dt1       	date	NULL	,
	dt2       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	str3      	varchar(40)	NULL	,
	str4      	varchar(40)	NULL	,
	code      	varchar(12)	NULL	,
	name      	varchar(30)	NULL	,
	ncye_j    	numeric(19,6)	NULL	,
	ncye_s    	numeric(19,6)	NULL	,
	xsje      	numeric(19,6)	NULL	,
	xssl      	numeric(19,6)	NULL	,
	xssl1     	numeric(19,6)	NULL	,
	xssl2     	numeric(19,6)	NULL	,
	xssl3     	numeric(19,6)	NULL	,
	xssl4     	numeric(19,6)	NULL	,
	xssl5     	numeric(19,6)	NULL	,
	xssl6     	numeric(19,6)	NULL	,
	xssl7     	numeric(19,6)	NULL	,
	xssl8     	numeric(19,6)	NULL	,
	xssl9     	numeric(19,6)	NULL	,
	xssl10    	numeric(19,6)	NULL	,
	xssl11    	numeric(19,6)	NULL	,
	xssl12    	numeric(19,6)	NULL	,
	isend     	varchar(10)	NULL	,
	xb        	tinyint	NULL	,
	age       	tinyint	NULL	,
	nation    	varchar(20)	NULL	,
	whcd      	varchar(20)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_emphw
(
	id        	numeric(19,6)	   NOT NULL,
	empid     	numeric(19,6)	   NULl,
	hwcode    	varchar(20)	NULL	,
	hwname    	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	hwdw      	varchar(6)	NULL	,
	ncye_j    	numeric(19,6)	NULL	,
	ncye_s    	numeric(19,6)	NULL	,
	xsje      	numeric(19,6)	NULL	,
	xsje1     	numeric(19,6)	NULL	,
	xsje2     	numeric(19,6)	NULL	,
	xsje3     	numeric(19,6)	NULL	,
	xsje4     	numeric(19,6)	NULL	,
	xsje5     	numeric(19,6)	NULL	,
	xsje6     	numeric(19,6)	NULL	,
	xsje7     	numeric(19,6)	NULL	,
	xsje8     	numeric(19,6)	NULL	,
	xsje9     	numeric(19,6)	NULL	,
	xsje10    	numeric(19,6)	NULL	,
	xsje11    	numeric(19,6)	NULL	,
	xsje12    	numeric(19,6)	NULL	,
	xssl      	numeric(19,6)	NULL	,
	xssl1     	numeric(19,6)	NULL	,
	xssl2     	numeric(19,6)	NULL	,
	xssl3     	numeric(19,6)	NULL	,
	xssl4     	numeric(19,6)	NULL	,
	xssl5     	numeric(19,6)	NULL	,
	xssl6     	numeric(19,6)	NULL	,
	xssl7     	numeric(19,6)	NULL	,
	xssl8     	numeric(19,6)	NULL	,
	xssl9     	numeric(19,6)	NULL	,
	xssl10    	numeric(19,6)	NULL	,
	xssl11    	numeric(19,6)	NULL	,
	xssl12    	numeric(19,6)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_empn
(
	id        	integer	NOT NULL	,
	mon       	integer	NULL	,
	p_sl      	numeric(19,6)	NULL	,
	f_sl      	numeric(19,6)	NULL	,
	p_je      	numeric(19,6)	NULL	,
	f_je      	numeric(19,6)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_empdc
(
	id        	integer	NOT NULL	,
	use_      	integer	NULL	,
	emp       	varchar(20)	NULL	,
	czy       	integer	NULL	,
	czy_name  	varchar(20)	NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	dqmc      	varchar(20)	NULL	,
	dwmc      	varchar(60)	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	dt1       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE secuser
(
	id        	numeric(19,6)	NOT NULL	,
	name      	varchar(10)	NULL	,
	pwd       	varchar(254)	NULL	,
	grant_    	tinyint	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE secur
(
	id        	integer	NOT NULL	,
	userid    	integer	NULL	,
	rightid   	integer	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE secright
(
	id        	numeric(19,6)	NOT NULL	,
	label     	integer	NULL	,
	right_    	varchar(20)	NULL	,
	fun_text  	varchar(30)	NULL	,
	op        	varchar(10)	NULL	,
	op_text   	varchar(20)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE xs_pz 
(
	id	integer NOT NULL,
	jzbz	tinyint NULL,
	pzrq	date NULL,
	pzlx	char(1) NULL,
	pzh	char(4) NULL,
	fj	smallint NULL,
	zy	varchar(30) NULL,
	kmdm	varchar(20) NULL,
	j		numeric(19,6) NULL,
	d		numeric(19,6) NULL,
	zphjsdjh varchar(5) NULL,
	shy	varchar(8) NULL,
	zdy	varchar(8) NULL,
	czy	varchar(8) NULL,
	shbz	tinyint NULL,
	wbje	numeric(19,6)  NULL,
	hl	numeric(19,6) NULL,
	dqh	varchar(4) NULL,
	gg	varchar(30) NULL,
	sl	numeric(19,6) NULL,
	dj	numeric(19,6) NULL,
	dwdm	varchar(4) NULL,
	lxr	varchar(8) NULL,
	jsr	varchar(8) NULL,
	bmry	varchar(8) NULL,
	PRIMARY KEY (id)
);
CREATE TABLE xs_info
(
	jsection  	varchar(20)	NOT NULL	,
	jkey      	varchar(20)	NOT NULL	,
	jvalue    	varchar(128)	NULL	,
	PRIMARY KEY(jsection,jkey)
);
CREATE TABLE x_bz
(
	id        	numeric(19,6)	NOT NULL	,
	jtext     	varchar(254)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_xsfy
(
	id        	integer	NOT NULL	,
	pjh       	varchar(20)	NULL	,
	rq        	date	NULL	,
	emp       	varchar(20)	NULL	,
	djr       	varchar(20)	NULL	,
	htdm      	varchar(20)	NULL	,
	dqh       	varchar(4)	NULL	,
	dwdm      	varchar(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwmc      	varchar(60)	NULL	,
	ckdm      	varchar(10)	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(10)	NULL	,
	dfry      	varchar(10)	NULL	,
	dd        	varchar(80)	NULL	,
	start_rq  	date	NULL	,
	end_rq    	date	NULL	,
	aim       	varchar(100)	NULL	,
	zsf       	numeric(19,6)	NULL	,
	jtf       	numeric(19,6)	NULL	,
	tzjtf     	numeric(19,6)	NULL	,
	ddjtf     	numeric(19,6)	NULL	,
	txf       	numeric(19,6)	NULL	,
	ysf       	numeric(19,6)	NULL	,
	zfy       	numeric(19,6)	NULL	,
	bz        	varchar(254)	NULL	,
	zt        	integer	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	d3        	numeric(19,6)	NULL	,
	d4        	numeric(19,6)	NULL	,
	d5        	numeric(19,6)	NULL	,
	d6        	numeric(19,6)	NULL	,
	dt1       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_jsfs
(
	bh        	tinyint	NOT NULL	,
	jsfs      	varchar(10)	NULL	,
	PRIMARY KEY(bh)
);
CREATE TABLE x_hx
(
	id        	integer	NOT NULL	,
	hxh       	varchar(16)	NULL	,
	hxrq      	date	NULL	,
	lry       	varchar(12)	NULL	,
	fph       	varchar(16)	NULL	,
	fprq      	date	NULL	,
	fphwid    	integer	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(60)	NULL	,
	hwgg			varchar(50) NULL	,		
	skh       	varchar(16)	NULL	,
	skrq      	date	NULL	,
	emp       	varchar(16)	NULL	,
	dqh       	varchar(4)	NULL	,
	dwdm      	varchar(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	hxje      	numeric(19,6)	NULL	,
	hxsl      	numeric(19,6)	NULL	,
	jj_1      	numeric(19,6)	NULL	,
	jj_2      	numeric(19,6)	NULL	,
	jj_3      	numeric(19,6)	NULL	,
	zt        	integer	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_khyh
(
	id        	integer	NOT NULL	,
	yhdm			varchar(20) NULL	,
	khyh      	varchar(60)	NULL	,
	zh        	varchar(30)	NULL	,
	kmdm			varchar(20) NULL,
	PRIMARY KEY(id)
);
CREATE TABLE x_level
(
	id        	numeric(19,6)	NOT NULL	,
	itemid    	numeric(19,6)	NULL	,
	levelnum  	integer	NULL	,
	levelbytes	integer	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_lvbase
(
	id        	numeric(19,6)	NOT NULL	,
	item      	varchar(30)	NULL	,
	maxbytes  	integer	NULL	,
	maxlevel  	integer	NULL	,
	jcomment  	varchar(120)	NULL	,
	item_lab  	varchar(10)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_wlys
(
	emp       	varchar(14)	NOT NULL	,
	dqh       	varchar(4)	NOT NULL	,
	dwdm      	varchar(4)	NOT NULL	,
	dqmc      	varchar(10)	NULL	,
	dwmc      	varchar(60)	NULL	,
	ncysye    	numeric(19,6)	NULL	,
	ysje      	numeric(19,6)	NULL	,
	skje      	numeric(19,6)	NULL	,
	yhxje     	numeric(19,6)	NULL	,
	bchxje    	numeric(19,6)	NULL	,
	ysfhje numeric(19,6)	NULL	,
	yshtje	numeric(19,6)	NULL	,
	def_num1 numeric(19,6)	NULL	,
	def_num2 numeric(19,6)	NULL	,
	def_int1 integer null,
	def_int2 integer null,
	def_str1 varchar(30)	NULL	,
	def_str2 varchar(30)	NULL	,
	PRIMARY KEY(emp,dqh,dwdm)
);
CREATE TABLE x_wlysc
(
	id        	integer	NOT NULL	,
	dqh       	char(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwdm      	char(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	lastye    	numeric(19,6)	NULL	,
	ys        	numeric(19,6)	NULL	,
	sk        	numeric(19,6)	NULL	,
	mon       	smallint	NULL	,
	emp       	varchar(14)	NULL	,
	hwdm      	varchar(20)	NULL	,
	hwmc      	varchar(50)	NULL	,
	hwgg      	varchar(50)	NULL	,
	htdm      	varchar(30)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_wlysd
(
	id        	integer	NOT NULL	,
	mon       	integer	NULL	,
	ys        	numeric(19,6)	NULL	,
	sk        	numeric(19,6)	NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_wlysdw
(
	id        	integer	NOT NULL	,
	dqh       	char(4)	NULL	,
	dqmc      	varchar(10)	NULL	,
	dwdm      	char(4)	NULL	,
	dwmc      	varchar(60)	NULL	,
	lastye    	numeric(19,6)	NULL	,
	ys        	numeric(19,6)	NULL	,
	sk        	numeric(19,6)	NULL	,
	mon       	smallint	NULL	,
	emp       	varchar(14)	NULL	,
	htdm      	varchar(30)	NULL	,
	zke       	numeric(19,6)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_carry
(
	id        	smallint	NOT NULL	,
	jcarry    	varchar(15)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_khxydj
(
	id        	integer	NOT NULL	,
	class_    	integer	NULL	,
	dz1       	numeric(19,6)	NULL	,
	dz2       	numeric(19,6)	NULL	,
	xyts      	integer	NULL	,
	scroe     	numeric(19,6)	NULL	,
	sxl       	numeric(19,6)	NULL	,
	bz        	varchar(254)	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	dt1       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_khda
(
	dqh       	char(4)	NOT NULL	,
	dwdm      	char(4)	NOT NULL	,
	qyxz      	varchar(30)	NULL	,
	zczj      	numeric(19,6)	NULL	,
	jzc       	numeric(19,6)	NULL	,
	zzc       	numeric(19,6)	NULL	,
	ssslyye   	numeric(19,6)	NULL	,
	sslyye    	numeric(19,6)	NULL	,
	slyye     	numeric(19,6)	NULL	,
	ssslyysr  	numeric(19,6)	NULL	,
	sslyysr   	numeric(19,6)	NULL	,
	slyysr    	numeric(19,6)	NULL	,
	slyskzzl  	numeric(19,6)	NULL	,
	emp       	integer	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	dt1       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	fldm			smallint NULL,
	skkm 			varchar(20) NULL,
	fptype		smallint NULL,
	PRIMARY KEY(dqh,dwdm)
);
CREATE TABLE x_xydj
(
	id        	integer	NOT NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	rq        	date	NULL	,
	xydj      	integer	NULL	,
	sxje      	numeric(19,6)	NULL	,
	hzfx      	numeric(19,6)	NULL	,
	ljyszkl   	numeric(19,6)	NULL	,
	d1        	numeric(19,6)	NULL	,
	d2        	numeric(19,6)	NULL	,
	dt1       	date	NULL	,
	str1      	varchar(40)	NULL	,
	str2      	varchar(40)	NULL	,
	fldm		smallint	NULL	,
	htje			numeric(19,6),
	fpje			numeric(19,6),
	fhje			numeric(19,6),
	skje			numeric(19,6),
   qchtje			numeric(19,6),
	qcfpje			numeric(19,6),
	qcfhje			numeric(19,6),
	qcskje			numeric(19,6),
	PRIMARY KEY(id)
);
CREATE TABLE x_xjzk
(
	id        	integer	NOT NULL	,
	dqh       	char(4)	NULL	,
	dwdm      	char(4)	NULL	,
	hkts1     	integer	NULL	,
	hkts2     	integer	NULL	,
	zkl       	numeric(19,6)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_jjkx
(
	id        	integer	NOT NULL	,
	kxbh      	varchar(4)	NULL	,
	kxmc      	varchar(16)	NULL	,
	kxdesc    	varchar(255)	NULL	,
	kxsm      	varchar(255)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_dwdq
(
	dqh       	varchar(4)	NOT NULL	,
	dqmc      	varchar(10)	NULL	,
	PRIMARY KEY(dqh)
);
CREATE TABLE x_dwtx
(
	dqh       	char(4)	NOT NULL	,
	dqmc      	varchar(8)	NULL	,
	dwdm      	char(4)	NOT NULL	,
	dwmc      	varchar(60)	NULL	,
	addr      	varchar(60)	NULL	,
	zp        	varchar(6)	NULL	,
	tel       	varchar(20)	NULL	,
	fax       	varchar(20)	NULL	,
	frdb      	varchar(8)	NULL	,
	zh        	varchar(30)	NULL	,
	khh       	varchar(60)	NULL	,
	scbz      	tinyint	NULL	,
	nsrdjh    	varchar(30)	NULL	,
	pydm_     	varchar(10)	NULL	,
	PRIMARY KEY(dqh,dwdm)
);
CREATE TABLE x_ftdy
(
	id		integer		NOT NULL,
	fpid		integer		NULL	,
	thid		integer		NULL	,
	mxid		integer		NULL	,
	pjlx		tinyint		NULL	,
	hwdm		varchar(20)	NULL	,
	jldw		varchar(6)	NULL	,
	sl		numeric(19,6)		NULL	,
	je		numeric(19,6)		NULL	,
	sysl		numeric(19,6)		NULL	,
	syje		numeric(19,6)		NULL	,
	bz		char(1)		NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_khfl
(
	fldm		smallint 	NOT NULL,
	flmc		varchar(20) 	NULL	,
	sftj		char(1) 	NULL	,
	tjxh		smallint 	NULL	,
	ms		varchar(100) 	NULL	,
	PRIMARY KEY(fldm)
);
CREATE TABLE x_wb
(
	dm varchar(4) NOT NULL,
	mc varchar(20) NULL,
	rate numeric(19,6) NULL,
	PRIMARY KEY (dm)
);
CREATE TABLE x_slzk
(
	id		integer		NOT NULL,
	dqh	varchar(4)	NULL,
	dqmc	varchar(10)	NULL,
	dwdm	varchar(4)	NULL,
	dwmc	varchar(60)	NULL,
	hwdm	varchar(20)	NULL,
	hwmc	varchar(60)	NULL,
	sl		numeric(19,6)		NULL,	
	zkl	numeric(19,6)		NULL,
	style	smallint		NULL,
	primary	key(id)
);
CREATE TABLE x_skmx
(
	id		integer		NOT NULL,
	skid	integer		NULL,	
	dddm	varchar(30)	NULL,
	pjh	varchar(30)	NULL,
	hxje	numeric(19,6)		NULL,
	rq 	date			NULL,
	chlje numeric(19,6)		NULL,
	bchxje	numeric(19,6)	NULL,
	primary	key(id)
);
CREATE TABLE x_lsddcs
(
	id		integer		NOT NULL,
	lsddh	varchar(30)	NULL,
	emp   varchar(14)	NULL	,
	dqh   varchar(4)	NULL	,
	dwdm  varchar(4)	NULL	,
	dqmc  varchar(10)	NULL	,
	dwmc  varchar(60)	NULL	,
	ysje  numeric(19,6) NULL	,
	kpje  numeric(19,6) NULL	,
	skje  numeric(19,6) NULL	,
	hxje  numeric(19,6) NULL,
	bchx  numeric(19,6) NULL,
	hxbz  tinyint NULL,
	fpje  numeric(19,6) NULL	,
	fhje  numeric(19,6) NULL	,
	ysfpje  numeric(19,6) NULL	,
	ysfhje  numeric(19,6) NULL	,
	yshtje  numeric(19,6) NULL	,
	htbz  tinyint NULL,
	def_num1  numeric(19,6) NULL,
	def_num2  numeric(19,6) NULL,
	def_int1  integer NULL,
	def_int2  integer NULL,
	def_str1  varchar(30)	NULL	,
	def_str2  varchar(30)	NULL	,
	PRIMARY KEY(id)
);
CREATE TABLE x_yjbb
(
	id			integer NOT NULL,
	title		varchar(30),
	filetype	char(2),
	bmdm		varchar(14),
	mon		smallint,
	ownrtype	tinyint,
	owner		varchar(14),
	fmt		long binary,
	PRIMARY KEY (id)
);
CREATE TABLE x_temp
(
	thdh		varchar(16)		NOT NULL,
	fph		varchar(16)		NOT NULL,
	hwdm		varchar(20)		NOT NULL,
	mxid		integer			NULL,
	sl			numeric(19,6)			NULL,
	bz			tinyint			NULL,
	lx			tinyint			NULL,
	PRIMARY KEY (thdh,fph,hwdm)
);

CREATE TABLE x_tempcp
(
        id              integer   NOT NULL,
	thdh		varchar(16)		NOT NULL,
	fph		varchar(16)		NOT NULL,
	hwdm		varchar(20)		NOT NULL,
	mxid		integer			NULL,
	sl			numeric(19,6)			NULL,
	bz			tinyint			NULL,
	lx			tinyint			NULL,
	PRIMARY KEY (thdh,fph,hwdm,id)
);


create view x_fh_view
as select x_fh.id,x_fh.pjh,x_fh.rq,x_fhhw.hwdm,x_fhhw.hwmc,x_fhhw.sl 
from x_fh,x_fhhw 
where(x_fh.id=x_fhhw.fhid) and((x_fh.iszf=0));

CREATE TABLE x_fpch
(
	id integer NOT NULL,
	hzfpid integer NULL,
	hzfph varchar(16) NULL,
	lzfpid integer NULL,
	lzfph varchar(16) NULL,
	hwdm  varchar(20) NULL,
	sl numeric(19,6) NULL,
	je numeric(19,6) NULL,
	se numeric(19,6) NULL,
	PRIMARY KEY(ID)
);

CREATE TABLE x_qzhx
(
	skid1 integer NOT NULL,
	skid2 integer NOT NULL,
	je numeric(19,6) NULL,
	PRIMARY KEY(SKID1,SKID2)
);
CREATE TABLE x_dfcx
(
	id  integer NOT NULL,
	skid integer NULL,
	fpid integer NULL,
	fphwid integer NULL,
	je numeric(19,6) NULL,
	rq date NULL,
	PRIMARY KEY(ID)
);
CREATE TABLE x_disc
(
	id integer NOT NULL,
	dqh	char(4) NULL,
	dqmc varchar(8) NULL,
	dwdm char(4) NULL,
	dwmc varchar(60) NULL,
	cg_date date NULL,
	pre_disc numeric(19,6) NULL,
	cg_point numeric(19,6) NULL,
	cur_disc numeric(19,6) NULL,
	pf_flag tinyint NULL,
	marks varchar(60) NULL,
	PRIMARY KEY(ID)
);

DROP INDEX x_ht.x_ht_htdm;
DROP INDEX x_ht.x_ht_qdrq;
DROP INDEX x_ht.x_ht_dw;
DROP INDEX x_ht.x_ht_gfdlr;
CREATE INDEX x_ht_htdm ON x_ht(htdm);
CREATE INDEX x_ht_qdrq ON x_ht(qdrq);
CREATE INDEX x_ht_dw  ON x_ht(xfdq,xfdm);
CREATE INDEX x_ht_gfdlr ON x_ht(gfdlr);

DROP INDEX x_hthw.x_hthw_htid;
DROP INDEX x_hthw.x_hthw_hwdm;
CREATE INDEX x_hthw_htid ON x_hthw(htid);
CREATE INDEX x_hthw_hwdm ON x_hthw(hwdm);

DROP INDEX x_fh.x_fh_rq;
DROP INDEX x_fh.x_fh_dw;
DROP INDEX x_fh.x_fh_bmdm;
DROP INDEX x_fh.x_fh_htdm;
CREATE INDEX x_fh_rq ON x_fh(rq);
CREATE INDEX x_fh_dw ON x_fh(dqh,dwdm);
CREATE INDEX x_fh_bmdm ON x_fh(bmdm);
CREATE INDEX x_fh_htdm ON x_fh(htdm);

DROP INDEX x_fhhw.x_fhhw_fhid;
DROP INDEX x_fhhw.x_fhhw_hwdm;
CREATE INDEX x_fhhw_fhid ON x_fhhw(fhid);
CREATE INDEX x_fhhw_hwdm ON x_fhhw(hwdm);

DROP INDEX x_fp.x_fp_rq;
DROP INDEX x_fp.x_fp_dw;
DROP INDEX x_fp.x_fp_emp;
DROP INDEX x_fp.x_fp_htdm;
CREATE INDEX x_fp_rq ON x_fp(rq);
CREATE INDEX x_fp_dw ON x_fp(dqh,dwdm);
CREATE INDEX x_fp_emp ON x_fp(emp);
CREATE INDEX x_fp_htdm ON x_fp(htdm);

DROP INDEX x_fphw.x_fphw_fpid;
DROP INDEX x_fphw.x_fphw_hwdm;
CREATE INDEX x_fphw_fpid ON x_fphw(fpid);
CREATE INDEX x_fphw_hwdm ON x_fphw(hwdm);

DROP INDEX x_sk.x_sk_pjh;
DROP INDEX x_sk.x_sk_dw;
DROP INDEX x_sk.x_sk_emp;
DROP INDEX x_sk.x_sk_rq;
CREATE INDEX x_sk_pjh ON x_sk(pjh);
CREATE INDEX x_sk_dw ON x_sk(dqh,dwdm );
CREATE INDEX x_sk_emp ON x_sk(emp);
CREATE INDEX x_sk_rq ON x_sk(rq);

DROP INDEX x_hx.x_hx_fph;
CREATE INDEX x_hx_fph ON x_hx(fph);

DROP INDEX x_ftdy.x_ftdy_ft;
CREATE INDEX x_ftdy_ft ON x_ftdy(fpid,thid);

DROP INDEX x_skmx.x_skmx_pjh;
DROP INDEX x_skmx.x_skmx_skid;
DROP INDEX x_skmx.x_skmx_dddm;
CREATE INDEX x_skmx_pjh ON x_skmx(pjh);
CREATE INDEX x_skmx_skid ON x_skmx(skid);
CREATE INDEX x_skmx_dddm ON x_skmx(dddm);

DROP INDEX x_dfcx.x_dfcx_skid;
DROP INDEX x_dfcx.x_dfcx_fpid;
CREATE INDEX x_dfcx_skid ON x_dfcx(skid);
CREATE INDEX x_dfcx_fpid ON x_dfcx(fpid);

DROP INDEX x_disc.x_disc_dw;
DROP INDEX x_disc.x_disc_flag;
CREATE INDEX x_disc_dw ON x_disc (dqh,dwdm);
CREATE INDEX x_disc_flag ON x_disc (pf_flag);