[CREATE TABLE]

drop view kc_mxhz;

drop view kc_cs;

CREATE TABLE "kc_def"
(	"id"		integer NOT NULL,
	"title"	varchar(30),
	"def"		varchar(100),
	PRIMARY KEY (id)
);

CREATE TABLE "kc_chlb"
(	"dm"		smallint NOT NULL,
	"mc"		varchar(12),
	"bz"		varchar(1),
	PRIMARY KEY (dm)
);

CREATE TABLE "kc_yt"
(	"dm"		varchar(4) NOT NULL,
	"mc"		varchar(12),
   "bz"		varchar(1),
	"route"  varchar(128),
	"multiple" numeric(18,6),
	PRIMARY KEY (dm)
);

CREATE TABLE "kc_ly"
(	"dm"		varchar(4) NOT NULL,
	"mc"		varchar(12),
   "bz"		varchar(1),
	"route"  varchar(128),
	"multiple" numeric(18,6),
	PRIMARY KEY (dm)
);

CREATE TABLE "kc_jsfs"
(	"dm"    smallint NOT NULL,
	"jsfs"  varchar(12),
	PRIMARY KEY (dm)
);

CREATE TABLE "kc_ck"
(	"dm"    varchar(2) NOT NULL,
	"mc"    varchar(12),
   "prop"		  smallint,
   "prio"		  varchar(2),
   "def_num1"	  integer,
   "def_str1"	  varchar(8),
	PRIMARY KEY (dm)
);

CREATE TABLE "kc_kw"
(	"ckdm"  varchar(2) NOT NULL,
	"dm"    varchar(30) NOT NULL,
	"mc"    varchar(50),
	PRIMARY KEY (ckdm,dm)
);

CREATE TABLE "kc_bm"
(	"dm"    varchar(8) NOT NULL,
	"mc"    varchar(16),
   "def_str1"   varchar(8),
   "def_str2"   varchar(30),
	PRIMARY KEY (dm)
);

CREATE TABLE "kc_ff"
(	"id"    smallint NOT NULL,
	"mc"    varchar(16),
	PRIMARY KEY (id)
);

CREATE TABLE "kc_xeset"
(	"id"    varchar(6) NOT NULL,
	"num"		integer NOT NULL,
	"nums"	varchar(30),
	"smon"  varchar(2) ,
	"pzh"   varchar(4) ,
	"ckpzh" varchar(6) ,
	"dm"    varchar(20) ,
	"ytdm"  varchar(4) ,
	"bmdm"  varchar(8) ,
	"dfkm"  varchar(20) ,
	"ckdm"  varchar(2) ,
	"dt"    date ,
	"zy"    varchar(30) ,
	"sl"    numeric(18,6) ,
	"used"  numeric(18,6),
   "def_num1"		numeric(18,6),
   "def_num2"		numeric(18,6),
   "def_num3"		numeric(18,6),
   "def_num4"		numeric(18,6),
   "def_str1"		varchar(30),
   "def_str2"		varchar(30),
   "def_str3"		varchar(30),
   "def_date1"		date,
   "def_date2"		date,
   "def_int1"		integer,
   "def_int2"		integer,
	PRIMARY KEY (id)
);

CREATE TABLE "kc_ckqx"
(	"xm" 		varchar(8) NOT NULL,
	"ckqx"   varchar(2) NOT NULL,
	PRIMARY  KEY (xm,ckqx)
);

CREATE TABLE "kc_qx"
(	"xm" varchar(8) NOT NULL,
	"mm" varchar(254) ,
	"bm" varchar(14) ,
	"q0" numeric(1,0) ,
	"q1" numeric(1,0) ,
	"q2" numeric(1,0) ,
	"q3" numeric(1,0) ,
	"q4" numeric(1,0) ,
	"q5" numeric(1,0) ,
	"q6" numeric(1,0) ,
	"q7" numeric(1,0) ,
	"q8" numeric(1,0) ,
	"q9" numeric(1,0) ,
	"q10" numeric(1,0) ,
	"q11" numeric(1,0) ,
	"q12" numeric(1,0) ,
	"q13" numeric(1,0) ,
	"q14" numeric(1,0) ,
	"q15" numeric(1,0) ,
	"q16" numeric(1,0) ,
	PRIMARY KEY (xm)
);

CREATE TABLE "kc_pz"
(  "id"			integer NOT NULL,
	"spp"			varchar(7) ,
	"jzbz"		tinyint ,
	"pzrq"		date ,
	"pzlx"		char(1) ,
	"pzh"			varchar(4) ,
	"ckpzh"		varchar(6) ,
	"fj"			smallint ,
	"zy"			varchar(60) ,
	"kmdm"		varchar(20) ,
	"j"			numeric(18,6) ,
	"d"			numeric(18,6) ,
	"zphjsdjh"	varchar(20) ,
	"shy"			varchar(8) ,
	"zdy"			varchar(8) ,
	"czy"			varchar(8) ,
	"shbz"		numeric(1,0) ,
	"wbje"		numeric(18,6) ,
	"hl"			numeric(18,6) ,
	"dqh"			varchar(4) ,
	"gg"			varchar(14) ,
	"sl"			numeric(18,6) ,
	"dj"			numeric(18,6) ,
	"dwdm"		varchar(4) ,
	"lxr"			varchar(8) ,
	"jsr"			varchar(8) ,
   "bmry"		varchar(8), 
	"id1"			integer ,
	"id2"			integer ,
	PRIMARY KEY (id)
);

CREATE TABLE "kc_mx"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx01"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx02"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx03"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx04"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx05"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx06"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx07"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx08"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx09"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx10"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx11"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_mx12"
(	"id"     varchar(6) NOT NULL,
	"smon"   varchar(2) NOT NULL,
	"pzlx"   varchar(1) NOT NULL,
	"pzh"    varchar(4) NOT NULL,
	"ckpzh"  varchar(6) ,
	"pzrq"   date ,
	"dm"     varchar(20) ,
	"sl"     numeric(18,6) ,
	"dj"     numeric(18,6) ,
	"dj_j"   numeric(18,6) ,
	"je"     numeric(18,2) ,
	"je_j"   numeric(18,2) ,
	"yzf"    numeric(18,2) ,
	"jzbz"   smallint ,
	"mayuse" numeric(18,6) ,
	  "ph"     varchar(20), 
	"kw"		varchar(30),
	"xe_pzh" varchar(4),
	"xe_ckpzh" varchar(6),
	"bz"		varchar(60),
   "fhh"   varchar(16),
	  "usemony"     numeric(18,2),	
	 "saleprc"		numeric(18,6),
	 "def_num1"		numeric(18,6),
	 "mxid"			integer,
	  "cg_head"  	varchar(20),
	  "xs_head"  	integer,	
	  "syear"   		varchar(4),
	  "def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_jzbz"
(	"id"     smallint NOT NULL,
	"ver"    integer ,
	"inited" smallint ,
	"len1"   smallint ,
	"len2"   smallint ,
	"len3"   smallint ,
	"len4"   smallint ,
	"len5"   smallint ,
	"len6"   smallint ,
	"len7"   smallint ,
	"len8"   smallint ,
	"mon1"   smallint ,
	"mon2"   smallint ,
	"mon3"   smallint ,
	"mon4"   smallint ,
	"mon5"   smallint ,
	"mon6"   smallint ,
	"mon7"   smallint ,
	"mon8"   smallint ,
	"mon9"   smallint ,
	"mon10"  smallint ,
	"mon11"  smallint ,
	"mon12"  smallint ,
	"dat1"   numeric(18,6) ,
	"dat2"   numeric(18,6) ,
	"dat3"   numeric(18,6) ,
	"dat4"   numeric(18,6) ,
	"dat5"   numeric(18,6) ,
	"str1"   varchar(30) ,
	"str2"   varchar(30) ,
	"str3"   varchar(30) ,
	"str4"   varchar(30) ,
	"str5"   varchar(30) ,
	 "def_int1"	integer,
	 "def_int2"	integer,
	 "def_int3"	integer,
	 "def_int4"	integer,
	 "def_int5"	integer,
	 "def_str1"	varchar(30),
	 "def_str2"	varchar(30),
	 "def_str3"	varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	PRIMARY  KEY (id)
);

CREATE TABLE "kc_dm"
(
	"ckdm"  		varchar(2) NOT NULL,
	"dm"        varchar(20) NOT NULL,
	"mc"        varchar(50) ,
	"islb"  		tinyint ,
	"chlb"  		smallint ,
	"ffid"  		tinyint ,
	"dw"        varchar(6) ,
	"gg"        varchar(50) ,
	"txm"			varchar(30) ,
	"kmdm"  		varchar(20) ,
	"cgkmdm"    varchar(20) ,
	"maxsl" 		numeric(18,6) ,
	"minsl" 		numeric(18,6) ,
	"ncjcsl"    numeric(18,6) ,
	"sljsl" 		numeric(18,6) ,
	"fljsl" 		numeric(18,6) ,
	"ncye"  		numeric(18,2) ,
	"ncye_j"    numeric(18,2) ,
	"dj"        numeric(18,6) ,
	"dj_j"  		numeric(18,6) ,
	"jje"       numeric(18,2) ,
	"jje_j" 		numeric(18,2) ,
	"dje"       numeric(18,2) ,
	"dje_j" 		numeric(18,2) ,
	"ssl1"  		numeric(18,6) ,
	"ssl2"  		numeric(18,6) ,
	"ssl3"  		numeric(18,6) ,
	"ssl4"  		numeric(18,6) ,
	"ssl5"  		numeric(18,6) ,
	"ssl6"  		numeric(18,6) ,
	"ssl7"  		numeric(18,6) ,
	"ssl8"  		numeric(18,6) ,
	"ssl9"  		numeric(18,6) ,
	"ssl10" 		numeric(18,6) ,
	"ssl11" 		numeric(18,6) ,
	"ssl12" 		numeric(18,6) ,
	"fsl1"  		numeric(18,6) ,
	"fsl2"  		numeric(18,6) ,
	"fsl3"  		numeric(18,6) ,
	"fsl4"  		numeric(18,6) ,
	"fsl5"  		numeric(18,6) ,
	"fsl6"  		numeric(18,6) ,
	"fsl7"  		numeric(18,6) ,
	"fsl8"  		numeric(18,6) ,
	"fsl9"  		numeric(18,6) ,
	"fsl10" 		numeric(18,6) ,
	"fsl11" 		numeric(18,6) ,
	"fsl12" 		numeric(18,6) ,
	"jje1" 		numeric(18,2) ,
	"jje2" 		numeric(18,2) ,
	"jje3" 		numeric(18,2) ,
	"jje4" 		numeric(18,2) ,
	"jje5" 		numeric(18,2) ,
	"jje6" 		numeric(18,2) ,
	"jje7" 		numeric(18,2) ,
	"jje8" 		numeric(18,2) ,
	"jje9" 		numeric(18,2) ,
	"jje10" 		numeric(18,2) ,
	"jje11" 		numeric(18,2) ,
	"jje12" 		numeric(18,2) ,
	"jje_j1" 	numeric(18,2) ,
	"jje_j2" 	numeric(18,2) ,
	"jje_j3" 	numeric(18,2) ,
	"jje_j4" 	numeric(18,2) ,
	"jje_j5" 	numeric(18,2) ,
	"jje_j6" 	numeric(18,2) ,
	"jje_j7"		numeric(18,2) ,
	"jje_j8" 	numeric(18,2) ,
	"jje_j9" 	numeric(18,2) ,
	"jje_j10" 	numeric(18,2) ,
	"jje_j11" 	numeric(18,2) ,
	"jje_j12" 	numeric(18,2) ,
	"dje1" 		numeric(18,2) ,
	"dje2" 		numeric(18,2) ,
	"dje3" 		numeric(18,2) ,
	"dje4" 		numeric(18,2) ,
	"dje5" 		numeric(18,2) ,
	"dje6" 		numeric(18,2) ,
	"dje7" 		numeric(18,2) ,
	"dje8" 		numeric(18,2) ,
	"dje9" 		numeric(18,2) ,
	"dje10" 		numeric(18,2) ,
	"dje11" 		numeric(18,2) ,
	"dje12" 		numeric(18,2) ,
	"dje_j1" 	numeric(18,2) ,
	"dje_j2" 	numeric(18,2) ,
	"dje_j3" 	numeric(18,2) ,
	"dje_j4" 	numeric(18,2) ,
	"dje_j5" 	numeric(18,2) ,
	"dje_j6" 	numeric(18,2) ,
	"dje_j7" 	numeric(18,2) ,
	"dje_j8" 	numeric(18,2) ,
	"dje_j9" 	numeric(18,2) ,
	"dje_j10" 	numeric(18,2) ,
	"dje_j11" 	numeric(18,2) ,
	"dje_j12" 	numeric(18,2) ,
	"dj0" 		numeric(18,6) ,
	"dj1" 		numeric(18,6) ,
	"dj2" 		numeric(18,6) ,
	"dj3" 		numeric(18,6) ,
	"dj4" 		numeric(18,6) ,
	"dj5" 		numeric(18,6) ,
	"dj6" 		numeric(18,6) ,
	"dj7" 		numeric(18,6) ,
	"dj8" 		numeric(18,6) ,
	"dj9" 		numeric(18,6) ,
	"dj10" 		numeric(18,6) ,
	"dj11" 		numeric(18,6) ,
	"dj12" 		numeric(18,6) ,
	"tsl1" 		numeric(18,6) ,
	"tsl2"		numeric(18,6) ,
	"xs_km" 		varchar(20)  ,
	"xs_ncye"	numeric(18,6) ,
	"xs_dj"		numeric(18,6) ,
	"xs_dje" 	numeric(18,6) ,
	"xs_dje1" 	numeric(18,6) ,
	"xs_dje2" 	numeric(18,6) ,
	"xs_dje3" 	numeric(18,6) ,
	"xs_dje4" 	numeric(18,6) ,
	"xs_dje5" 	numeric(18,6) ,
	"xs_dje6" 	numeric(18,6) ,
	"xs_dje7" 	numeric(18,6) ,
	"xs_dje8" 	numeric(18,6) ,
	"xs_dje9" 	numeric(18,6) ,
	"xs_dje10" 	numeric(18,6) ,
	"xs_dje11" 	numeric(18,6) ,
	"xs_dje12" 	numeric(18,6) ,
   "xscbkmdm"  varchar(20),
   "sccbkmdm"  varchar(20),
   "def_num1"	numeric(18,6),
   "def_num2"	numeric(18,6),
   "def_num3"	numeric(18,6),
   "def_num4"	numeric(18,6),
   "def_num5"	numeric(18,6),
   "def_str1"	varchar(30),
   "def_str2"	varchar(30),
   "def_date1"	date,
   "def_date2"	date,
   "def_int1"  integer,
   "def_int2"  integer,
	PRIMARY KEY (ckdm,dm)
);

CREATE TABLE "kc_dj"
(	"smon"  varchar(2) NOT NULL,
	"pzlx"  varchar(1) NOT NULL,
	"pzh"   varchar(4) NOT NULL,
	"ckpzh" varchar(6) ,
	"pzrq"  date ,
	"hth"   varchar(20) ,
	"fph"   varchar(20) ,
	"dqh"   varchar(4) ,
	"dwdm"  varchar(4) ,
	"jsfs"  smallint ,
	"dfkm"  varchar(20) ,
	"bmdm"  varchar(8) ,
	"ckdm"  varchar(2) ,
	"lydm"  varchar(4) ,
	"ytdm"  varchar(4) ,
	"lry"   varchar(8) ,
	"lry2"  varchar(8) ,
	"ysy"   varchar(8) ,
	"shy"   varchar(8) ,
	"jzy"   varchar(8) ,
	"jsr"   varchar(8) ,
	"ysbz"  smallint ,
	"shbz"  smallint ,
	"jzbz"  smallint ,
	"yk_pzh" varchar(20) ,
	"note"  varchar(60) ,
	"xe_num" smallint ,
	"xe_pzh" varchar(4),
   "zfbz"  smallint,
   "zpzh"  integer,
   "def_str1"	varchar(30),
   "def_str2"	varchar(30),
   "def_str3"	varchar(30),
   "def_str4"	varchar(30),
   "def_num1"	numeric(18,6),
   "def_num2"	numeric(18,6),
   "def_int1"	integer,
   "def_int2"	integer,
   "def_date1"	date,
   "def_date2"	date,
	PRIMARY KEY (smon,pzlx,pzh)
);

CREATE TABLE "kc_auto"
(	"id"    		integer NOT NULL,
	"num"   		smallint ,
	"jhd"   		smallint ,
	"kmdm"      varchar(20) ,
	"contain"   smallint ,
	"zy"        varchar(30) ,
	"pzlx"  		char(1) ,
	"form"  		varchar(80),
	PRIMARY KEY (id)
);

CREATE TABLE "kc_pypk"
(	"id"		integer NOT NULL,
	"ckdm"  varchar(2) ,
	"dm"    varchar(20),
	"kh"		varchar(30),
	"smon"	varchar(2),
	"pzlx"	varchar(1),
	"pzh"	varchar(4),
	"rq"    date ,   
	"sl"    numeric(18,6),
	"je"    numeric(18,2),
	"ph"	  varchar(20),	
	"kw"	  varchar(30),
	"slbak"	numeric(18,6),
	"jebak"	numeric(18,2),
	"ssl"   numeric(18,6),
	"sje"   numeric(18,6) ,
	"fsl"	numeric(18,6),
	"fje"	numeric(18,6),
	"note"  varchar(80),
	"sbzbak"	varchar(30),
	"iykbz"	tinyint,
	"bz"    smallint ,
	"ibzbak"	tinyint,
	PRIMARY KEY ("id")
);

CREATE TABLE "kc_bmyt"
(	"id"      integer	  NOT NULL,	
	"bmdm"    varchar(8),
	"ytdm"    varchar(4),
	"bz"		  varchar(30)  ,
	PRIMARY KEY ("id")
);

CREATE TABLE "kc_phyxq"
(	"id"			integer	NOT NULL,	
   "ckdm"     varchar(2),
	"kw"			varchar(30),
	"ph"			varchar(20)	,
	"dm"     	varchar(20),
	"lrrq"		date,
	"yxq"	      date,
	"ncsl"		numeric(18,6),
	"ssl"       numeric(18,6),
	"fsl"		   numeric(18,6),
	"sl"			numeric(18,6),
	"je"			numeric(18,2),		
	"bq"			varchar(60),
	"sbz"		   varchar(50),
	"ibz"  		tinyint,
	"ibz2"		tinyint,
   "def_date1"	date,
   "def_date2"	date,
   "def_date3"	date,
   "def_num1"	numeric(18,6),
   "def_num2"	numeric(18,6),
   "def_num3"	numeric(18,6),
   "def_num4"	numeric(18,6),
   "def_str1"	varchar(30),
   "def_str2"	varchar(30),
	PRIMARY KEY ("id")
);

CREATE TABLE "kc_mx00"
(	"id"		varchar(6) NOT NULL,
	"syear"	varchar(4) NOT NULL,
	"smon"	varchar(2) NOT NULL,
	"pzlx"	varchar(1) NOT NULL,
	"pzh"	varchar(4) NOT NULL,
	"ckpzh"	varchar(6),
	"pzrq"	date ,
	"dm"		varchar(20) ,
	"ph"		varchar(20) ,
	"kw"	varchar(30)	,
	"sl"		numeric(18,6),
	"mayuse" numeric(18,6),
	"sl_ycx" numeric(18,6) ,
	"dj"		numeric(18,6) ,
	"dj_j"	numeric(18,6),
	"je"		numeric(18,2),
	"je_j"	numeric(18,2),
	"yzf"	numeric(18,2) ,
	"usemony" numeric(18,2) ,
	"je_ycx"  numeric(18,2) ,
	"jzbz"	smallint ,
	"status"	varchar(4),
	"bz"		varchar(60) ,
	"fhh"	varchar(16) ,
	"xe_ckpzh" varchar(6),
	"def_num2"		numeric(18,6),
	 "def_num3"		numeric(18,6),
	 "def_num4"		numeric(18,6),
	 "def_num5"		numeric(18,6),
	 "def_str1"		varchar(30),
	 "def_str2"		varchar(30),
	 "def_str3"		varchar(30),
	 "def_date1"	date,
	 "def_date2"	date,
	 "def_int1"		integer,
	 "def_int2"		integer,
	 PRIMARY KEY ("id","syear","smon")
);


CREATE TABLE "kc_dj00"
(	"SYEAR" VARCHAR(4) NOT NULL,
	"smon"  varchar(2) NOT NULL,
	"pzlx"  varchar(1) NOT NULL,
	"pzh"   varchar(4) NOT NULL,
	"ckpzh" varchar(6) ,
	"pzrq"  date ,
	"hth"   varchar(20) ,
	"fph"   varchar(20) ,
	"dqh"   varchar(4) ,
	"dwdm"  varchar(4) ,
	"jsfs"  smallint ,
	"dfkm"  varchar(20) ,
	"bmdm"  varchar(8) ,
	"ckdm"  varchar(2) ,
	"lydm"  varchar(4) ,
	"ytdm"  varchar(4) ,
	"lry"   varchar(8) ,
	"lry2"  varchar(8) ,
	"ysy"   varchar(8) ,
	"shy"   varchar(8) ,
	"jzy"   varchar(8) ,
	"jsr"   varchar(8) ,
	"ysbz"  smallint ,
	"shbz"  smallint ,
	"jzbz"  smallint ,
	"yk_pzh" varchar(20) ,
	"note"  varchar(60) ,
	"status" VARCHAR(4),
	"xe_ckpzh" varchar(6),
        "zfbz"  smallint,
        "zpzh"  integer,
	PRIMARY KEY ("syear","smon","pzlx","pzh")
);

CREATE TABLE "kc_jt"
(	"smon"		varchar(2)		NOT NULL,
	"dm"			varchar(20)		NOT NULL,
	"je"			numeric(18,2),
	"sl"			numeric(18,6),
	"mprice"		numeric(18,6),
	"cell_jt"	numeric(18,6),
	"cell_jt_yu"	numeric(18,6),
	"jt_yu"		numeric(18,6),
	"def_num1"	numeric(18,6),
	"def_num2"	numeric(18,6),
	"def_int1"	smallint,
	"def_int2"	smallint,
	PRIMARY KEY ("smon","dm")
);

CREATE TABLE "kc_rep"
(	"repno"		char(4) NOT NULL,
	"repname"	varchar(30) NULL,
	"fillinpsn"	varchar(10) NULL,
	"fillindate"	smalldatetime NULL,
	"repowner"	varchar(30) NULL,
	"def_num1"	numeric(18,6),
   	"def_num2"	numeric(18,6),
   	"def_num3"	numeric(18,6),
   	"def_num4"	numeric(18,6),
   	"def_str1"	varchar(30),
   	"def_str2"	varchar(30),
   	"def_str3"	varchar(30),
   	"def_date1"	date,
   	"def_date2"	date,
   	"def_int1"	integer,
   	"def_int2"	integer,
	PRIMARY KEY ("repno")
);

CREATE TABLE "kc_rep_design"
(	"repno"		char(4) NOT NULL,
	"repid"		integer NOT NULL,
	"idtype"	char(2) NULL,
	"content"	varchar(60) NULL,
	"repflg"	char(1) NULL,
	"describe"	varchar(60) NULL,
	"lyyt"		char(1) NULL,
	"def_num1"	numeric(18,6),
   	"def_num2"	numeric(18,6),
   	"def_num3"	numeric(18,6),
   	"def_num4"	numeric(18,6),
   	"def_str1"	varchar(30),
   	"def_str2"	varchar(30),
   	"def_str3"	varchar(30),
   	"def_date1"	date,
   	"def_date2"	date,
   	"def_int1"	integer,
   	"def_int2"	integer,
	PRIMARY KEY ("repno","repid")
);

CREATE TABLE "kc_repqx"
(	
   	"xm"       char(8)  Not Null,
	"repno"		char(4) NOT NULL,
	"def_num1"	numeric(18,6) NULL,
 	"def_num2"	numeric(18,6) NULL,
  	"def_num3"	numeric(18,6) NULL,
  	"def_num4"	numeric(18,6) NULL,
  	"def_str1"	varchar(30) NULL,
  	"def_str2"	varchar(30) NULL,
 	"def_str3"	varchar(30) NULL,
  	"def_date1"	date NULL,
  	"def_date2"	date NULL,
  	"def_int1"	integer NULL,
  	"def_int2"	integer NULL,
	PRIMARY KEY ("xm","repno")
);
create view kc_mxhz as 
  (
  select * from kc_mx01 union  
  select * from kc_mx02 union 
  select * from kc_mx03 union 
  select * from kc_mx04 union 
  select * from kc_mx05 union 
  select * from kc_mx06 union 
  select * from kc_mx07 union 
  select * from kc_mx08 union 
  select * from kc_mx09 union 
  select * from kc_mx10 union 
  select * from kc_mx11 union 
  select * from kc_mx12 
);

create view kc_cs as  
  (
  select kc_dm.ckdm as ckdm,
 	kc_dm.dm as dm,
	kc_dm.chlb as chlb,
	kc_dm.gg as gg,
	(kc_dm.ncjcsl + kc_dm.sljsl - kc_dm.fljsl) as dmncsl,
	(kc_dm.ncye + kc_dm.jje - kc_dm.dje) as dmncye,
	(kc_dm.ncye_j + kc_dm.jje_j - kc_dm.dje_j) as dmncye_j,
	kc_phyxq.kw as kw,
	kc_phyxq.ph as ph,
	kc_phyxq.ncsl as ncsl  
  from	kc_dm left outer join kc_phyxq on (kc_dm.ckdm = kc_phyxq.ckdm and kc_dm.dm = kc_phyxq.dm)  
  where kc_dm.ckdm <> '00' and kc_dm.islb = 0 
);	

[CREATE INDEX]
DROP INDEX "kc_auto_pk";
DROP INDEX "kc_auto_num";
DROP INDEX "kc_bm_pk";
DROP INDEX "kc_bmyt_pk";
DROP INDEX "kc_bmyt_bm";
DROP INDEX "kc_bmyt_yt";
DROP INDEX "kc_chlb_pk";
DROP INDEX "kc_chlb_mc";
DROP INDEX "kc_ck_pk";
DROP INDEX "kc_ck_mc";
DROP INDEX "kc_ckqx_pk";
DROP INDEX "kc_ckqx_xm";
DROP INDEX "kc_ckqx_ck";
DROP INDEX "kc_def_pk";
DROP INDEX "kc_dj_pk";
DROP INDEX "kc_dj_bz";
DROP INDEX "kc_dj_wldw";
DROP INDEX "kc_dj_htfp";
DROP INDEX "kc_dj_ck";
DROP INDEX "kc_dj_bm";
DROP INDEX "kc_dj_LYyt";
DROP INDEX "kc_dj_zpzh";
DROP INDEX "kc_dj00_pk";
DROP INDEX "kc_dj00_ck";
DROP INDEX "kc_dj00_zpzh";
DROP INDEX "kc_dm_pk";
DROP INDEX "kc_dm_ck";
DROP INDEX "kc_dm_dm";
DROP INDEX "kc_dm_islb";
DROP INDEX "kc_dm_chlb";
DROP INDEX "kc_dm_ffid";
DROP INDEX "kc_dm_olddm";
DROP INDEX "kc_ff_pk";
DROP INDEX "kc_flag_pk";
DROP INDEX "kc_jsfs_pk";
DROP INDEX "kc_jzbz_pk";
DROP INDEX "kc_kw_pk";
DROP INDEX "kc_kw_ck";
DROP INDEX "kc_kw_dm";
DROP INDEX "kc_ly_pk";
DROP INDEX "kc_mx_pk";
DROP INDEX "kc_mx_x";
DROP INDEX "kc_mx_dm";
DROP INDEX "kc_mx_ckpzh";
DROP INDEX "kc_mx_jk";
DROP INDEX "kc_mx_phkw";
DROP INDEX "kc_mx00_pk";
DROP INDEX "kc_mx00_x";
DROP INDEX "kc_mx00_dm";
DROP INDEX "kc_mx01_pk";
DROP INDEX "kc_mx01_x";
DROP INDEX "kc_mx01_dm";
DROP INDEX "kc_mx01_ckpzh";
DROP INDEX "kc_mx01_jk";
DROP INDEX "kc_mx01_phkw";
DROP INDEX "kc_mx02_pk";
DROP INDEX "kc_mx02_x";
DROP INDEX "kc_mx02_dm";
DROP INDEX "kc_mx02_ckpzh";
DROP INDEX "kc_mx02_jk";
DROP INDEX "kc_mx02_phkw";
DROP INDEX "kc_mx03_pk";
DROP INDEX "kc_mx03_x";
DROP INDEX "kc_mx03_dm";
DROP INDEX "kc_mx03_ckpzh";
DROP INDEX "kc_mx03_jk";
DROP INDEX "kc_mx03_phkw";
DROP INDEX "kc_mx04_pk";
DROP INDEX "kc_mx04_x";
DROP INDEX "kc_mx04_dm";
DROP INDEX "kc_mx04_ckpzh";
DROP INDEX "kc_mx04_jk";
DROP INDEX "kc_mx04_phkw";
DROP INDEX "kc_mx05_pk";
DROP INDEX "kc_mx05_x";
DROP INDEX "kc_mx05_dm";
DROP INDEX "kc_mx05_ckpzh";
DROP INDEX "kc_mx05_jk";
DROP INDEX "kc_mx05_phkw";
DROP INDEX "kc_mx06_pk";
DROP INDEX "kc_mx06_x";
DROP INDEX "kc_mx06_dm";
DROP INDEX "kc_mx06_ckpzh";
DROP INDEX "kc_mx06_jk";
DROP INDEX "kc_mx06_phkw";
DROP INDEX "kc_mx07_pk";
DROP INDEX "kc_mx07_x";
DROP INDEX "kc_mx07_dm";
DROP INDEX "kc_mx07_ckpzh";
DROP INDEX "kc_mx07_jk";
DROP INDEX "kc_mx07_phkw";
DROP INDEX "kc_mx08_pk";
DROP INDEX "kc_mx08_x";
DROP INDEX "kc_mx08_dm";
DROP INDEX "kc_mx08_ckpzh";
DROP INDEX "kc_mx08_jk";
DROP INDEX "kc_mx08_phkw";
DROP INDEX "kc_mx09_pk";
DROP INDEX "kc_mx09_x";
DROP INDEX "kc_mx09_dm";
DROP INDEX "kc_mx09_ckpzh";
DROP INDEX "kc_mx09_jk";
DROP INDEX "kc_mx09_phkw";
DROP INDEX "kc_mx10_pk";
DROP INDEX "kc_mx10_x";
DROP INDEX "kc_mx10_dm";
DROP INDEX "kc_mx10_ckpzh";
DROP INDEX "kc_mx10_jk";
DROP INDEX "kc_mx10_phkw";
DROP INDEX "kc_mx11_pk";
DROP INDEX "kc_mx11_x";
DROP INDEX "kc_mx11_dm";
DROP INDEX "kc_mx11_ckpzh";
DROP INDEX "kc_mx11_jk";
DROP INDEX "kc_mx11_phkw";
DROP INDEX "kc_mx12_pk";
DROP INDEX "kc_mx12_x";
DROP INDEX "kc_mx12_dm";
DROP INDEX "kc_mx12_ckpzh";
DROP INDEX "kc_mx12_jk";
DROP INDEX "kc_mx12_phkw";
DROP INDEX "kc_phyxq_pk";
DROP INDEX "kc_phyxq_ckdm";
DROP INDEX "kc_phyxq_dm";
DROP INDEX "kc_phyxq_kwph";
DROP INDEX "kc_phyxq_ibz";
DROP INDEX "kc_pypk_pk";
DROP INDEX "kc_pypk_ckkh";
DROP INDEX "kc_pypk_pzh";
DROP INDEX "kc_pypk_dm";
DROP INDEX "kc_pypk_bz";
DROP INDEX "kc_pz_pk";
DROP INDEX "kc_pz_zwpzh";
DROP INDEX "kc_pz_pzh";
DROP INDEX "kc_qx_pk";
DROP INDEX "kc_xeset_pk";
DROP INDEX "kc_xeset_xe";
DROP INDEX "kc_xeset_pld";
DROP INDEX "kc_xeset_num";
DROP INDEX "kc_yt_pk";
DROP INDEX "kc_jt_x";
DROP INDEX "kc_jt_dm";

CREATE INDEX "kc_auto_pk" ON "kc_auto"("id");
CREATE INDEX "kc_auto_num" ON "kc_auto"("num");
CREATE  INDEX "kc_bm_pk" ON "kc_bm"("dm");
CREATE  INDEX "kc_bmyt_pk" ON "kc_bmyt"("id");
CREATE INDEX "kc_bmyt_bm" ON "kc_bmyt"("bmdm");
CREATE INDEX "kc_bmyt_yt" ON "kc_bmyt"("ytdm");
CREATE  INDEX "kc_chlb_pk" ON "kc_chlb"("dm");
CREATE INDEX "kc_chlb_mc" ON "kc_chlb"("mc");
CREATE  INDEX "kc_ck_pk" ON "kc_ck"("dm");
CREATE INDEX "kc_ck_mc" ON "kc_ck"("mc");
CREATE  INDEX "kc_ckqx_pk" ON "kc_ckqx"("xm","ckqx");
CREATE INDEX "kc_ckqx_xm" ON "kc_ckqx"("xm");
CREATE INDEX "kc_ckqx_ck" ON "kc_ckqx"("ckqx");
CREATE INDEX "kc_def_pk" ON "kc_def"("id");
CREATE  INDEX "kc_dj_pk" ON "kc_dj"("smon","pzLx","pzh");
CREATE INDEX "kc_dj_ysbz" ON "kc_dj"("ysbz","shbz","jzbz");
CREATE INDEX "kc_dj_wldw" ON "kc_dj"("dqh","dwdm");
CREATE INDEX "kc_dj_htfp" ON "kc_dj"("hth","fph");
CREATE INDEX "kc_dj_ck" ON "kc_dj"("ckdm","ckpzh");
CREATE INDEX "kc_dj_bm" ON "kc_dj"("bmdm");
CREATE INDEX "kc_dj_lyyt" ON "kc_dj"("lydm","ytdm"); 
CREATE INDEX "kc_dj_zpzh" ON "kc_dj"("zpzh");
CREATE  INDEX "kc_dj00_pk" ON "kc_dj00"("syear","smon","pzLx","pzh");
CREATE INDEX "kc_dj00_ck" ON "kc_dj00"("ckdm");
CREATE INDEX "kc_dj00_zpzh" ON "kc_dj00"("zpzh");
CREATE  INDEX "kc_dm_pk" ON "kc_dm"("ckdm","dm");
CREATE INDEX "kc_dm_ck" ON "kc_dm"("ckdm");
CREATE INDEX "kc_dm_dm" ON "kc_dm"("dm");
CREATE INDEX "kc_dm_islb" ON "kc_dm"("islb");
CREATE INDEX "kc_dm_chlb" ON "kc_dm"("chlb");
CREATE INDEX "kc_dm_ffid" ON "kc_dm"("ffid");
CREATE INDEX "kc_dm_olddm" ON "kc_dm"("def_str1");
CREATE  INDEX "kc_ff_pk" ON "kc_ff"("id");
CREATE  INDEX "kc_flag_pk" ON "kc_flag"("id");
CREATE  INDEX "kc_jsfs_pk" ON "kc_jsfs"("dm");
CREATE  INDEX "kc_jzbz_pk" ON "kc_jzbz"("id");
CREATE  INDEX "kc_kw_pk" ON "kc_kw"("ckdm","dm");
CREATE INDEX "kc_kw_ck" ON "kc_kw"("ckdm");
CREATE INDEX "kc_kw_dm" ON "kc_kw"("dm");
CREATE  INDEX "kc_ly_pk" ON "kc_ly"("dm");
CREATE  INDEX "kc_mx_pk" ON "kc_mx"("id");
CREATE INDEX "kc_mx_x" ON "kc_mx"("smon","pzLx","pzh");
CREATE INDEX "kc_mx_dm" ON "kc_mx"("dm");
CREATE INDEX "kc_mx_ckpzh" ON "kc_mx"("ckpzh");
CREATE INDEX "kc_mx_jk" ON "kc_mx"("fhh","mxid");
CREATE INDEX "kc_mx_phkw" ON "kc_mx"("kw","Ph");
CREATE  INDEX "kc_mx00_pk" ON "kc_mx00"("id","syear","smon");
CREATE INDEX "kc_mx00_x" ON "kc_mx00"("smon","pzLx","pzh");
CREATE INDEX "kc_mx00_dm" ON "kc_mx00"("dm");
CREATE  INDEX "kc_mx01_pk" ON "kc_mx01"("id");
CREATE INDEX "kc_mx01_x" ON "kc_mx01"("smon","pzLx","pzh");
CREATE INDEX "kc_mx01_dm" ON "kc_mx01"("dm");
CREATE INDEX "kc_mx01_ckpzh" ON "kc_mx01"("ckpzh");
CREATE INDEX "kc_mx01_jk" ON "kc_mx01"("fhh","mxid");
CREATE INDEX "kc_mx01_phkw" ON "kc_mx01"("kw","Ph");
CREATE  INDEX "kc_mx02_pk" ON "kc_mx02"("id");
CREATE INDEX "kc_mx02_x" ON "kc_mx02"("smon","pzLx","pzh");
CREATE INDEX "kc_mx02_dm" ON "kc_mx02"("dm");
CREATE INDEX "kc_mx02_ckpzh" ON "kc_mx02"("ckpzh");
CREATE INDEX "kc_mx02_jk" ON "kc_mx02"("fhh","mxid");
CREATE INDEX "kc_mx02_phkw" ON "kc_mx02"("kw","Ph");
CREATE  INDEX "kc_mx03_pk" ON "kc_mx03"("id");
CREATE INDEX "kc_mx03_x" ON "kc_mx03"("smon","pzLx","pzh");
CREATE INDEX "kc_mx03_dm" ON "kc_mx03"("dm");
CREATE INDEX "kc_mx03_ckpzh" ON "kc_mx03"("ckpzh");
CREATE INDEX "kc_mx03_jk" ON "kc_mx03"("fhh","mxid");
CREATE INDEX "kc_mx03_phkw" ON "kc_mx03"("kw","Ph");
CREATE  INDEX "kc_mx04_pk" ON "kc_mx04"("id");
CREATE INDEX "kc_mx04_x" ON "kc_mx04"("smon","pzLx","pzh");
CREATE INDEX "kc_mx04_dm" ON "kc_mx04"("dm");
CREATE INDEX "kc_mx04_ckpzh" ON "kc_mx04"("ckpzh");
CREATE INDEX "kc_mx04_jk" ON "kc_mx04"("fhh","mxid");
CREATE INDEX "kc_mx04_phkw" ON "kc_mx04"("kw","Ph");
CREATE  INDEX "kc_mx05_pk" ON "kc_mx05"("id");
CREATE INDEX "kc_mx05_x" ON "kc_mx05"("smon","pzLx","pzh");
CREATE INDEX "kc_mx05_dm" ON "kc_mx05"("dm");
CREATE INDEX "kc_mx05_ckpzh" ON "kc_mx05"("ckpzh");
CREATE INDEX "kc_mx05_jk" ON "kc_mx05"("fhh","mxid");
CREATE INDEX "kc_mx05_phkw" ON "kc_mx05"("kw","Ph");
CREATE  INDEX "kc_mx06_pk" ON "kc_mx06"("id");
CREATE INDEX "kc_mx06_x" ON "kc_mx06"("smon","pzLx","pzh");
CREATE INDEX "kc_mx06_dm" ON "kc_mx06"("dm");
CREATE INDEX "kc_mx06_ckpzh" ON "kc_mx06"("ckpzh");
CREATE INDEX "kc_mx06_jk" ON "kc_mx06"("fhh","mxid");
CREATE INDEX "kc_mx06_phkw" ON "kc_mx06"("kw","Ph");
CREATE  INDEX "kc_mx07_pk" ON "kc_mx07"("id");
CREATE INDEX "kc_mx07_x" ON "kc_mx07"("smon","pzLx","pzh");
CREATE INDEX "kc_mx07_dm" ON "kc_mx07"("dm");
CREATE INDEX "kc_mx07_ckpzh" ON "kc_mx07"("ckpzh");
CREATE INDEX "kc_mx07_jk" ON "kc_mx07"("fhh","mxid");
CREATE INDEX "kc_mx07_phkw" ON "kc_mx07"("kw","Ph");
CREATE  INDEX "kc_mx08_pk" ON "kc_mx08"("id");
CREATE INDEX "kc_mx08_x" ON "kc_mx08"("smon","pzLx","pzh");
CREATE INDEX "kc_mx08_dm" ON "kc_mx08"("dm");
CREATE INDEX "kc_mx08_ckpzh" ON "kc_mx08"("ckpzh");
CREATE INDEX "kc_mx08_jk" ON "kc_mx08"("fhh","mxid");
CREATE INDEX "kc_mx08_phkw" ON "kc_mx08"("kw","Ph");
CREATE  INDEX "kc_mx09_pk" ON "kc_mx09"("id");
CREATE INDEX "kc_mx09_x" ON "kc_mx09"("smon","pzLx","pzh");
CREATE INDEX "kc_mx09_dm" ON "kc_mx09"("dm");
CREATE INDEX "kc_mx09_ckpzh" ON "kc_mx09"("ckpzh");
CREATE INDEX "kc_mx09_jk" ON "kc_mx09"("fhh","mxid");
CREATE INDEX "kc_mx09_phkw" ON "kc_mx09"("kw","Ph");
CREATE  INDEX "kc_mx10_pk" ON "kc_mx10"("id");
CREATE INDEX "kc_mx10_x" ON "kc_mx10"("smon","pzLx","pzh");
CREATE INDEX "kc_mx10_dm" ON "kc_mx10"("dm");
CREATE INDEX "kc_mx10_ckpzh" ON "kc_mx10"("ckpzh");
CREATE INDEX "kc_mx10_jk" ON "kc_mx10"("fhh","mxid");
CREATE INDEX "kc_mx10_phkw" ON "kc_mx10"("kw","Ph");
CREATE  INDEX "kc_mx11_pk" ON "kc_mx11"("id");
CREATE INDEX "kc_mx11_x" ON "kc_mx11"("smon","pzLx","pzh");
CREATE INDEX "kc_mx11_dm" ON "kc_mx11"("dm");
CREATE INDEX "kc_mx11_ckpzh" ON "kc_mx11"("ckpzh");
CREATE INDEX "kc_mx11_jk" ON "kc_mx11"("fhh","mxid");
CREATE INDEX "kc_mx11_phkw" ON "kc_mx11"("kw","Ph");
CREATE  INDEX "kc_mx12_pk" ON "kc_mx12"("id");
CREATE INDEX "kc_mx12_x" ON "kc_mx12"("smon","pzLx","pzh");
CREATE INDEX "kc_mx12_dm" ON "kc_mx12"("dm");
CREATE INDEX "kc_mx12_ckpzh" ON "kc_mx12"("ckpzh");
CREATE INDEX "kc_mx12_jk" ON "kc_mx12"("fhh","mxid");
CREATE INDEX "kc_mx12_phkw" ON "kc_mx12"("kw","Ph");
CREATE  INDEX "kc_phyxq_pk" ON "kc_phyxq"("id");
CREATE INDEX "kc_phyxq_ckdm" ON "kc_phyxq"("ckdm");
CREATE INDEX "kc_phyxq_dm" ON "kc_phyxq"("dm");
CREATE INDEX "kc_phyxq_kwph" ON "kc_phyxq"("kw","Ph");
CREATE INDEX "kc_phyxq_ibz" ON "kc_phyxq"("ibz");
CREATE  INDEX "kc_pypk_pk" ON "kc_pypk"("id");
CREATE INDEX "kc_pypk_ckkh" ON "kc_pypk"("ckdm","kh");
CREATE INDEX "kc_pypk_pzh" ON "kc_pypk"("smon","pzh","pzLx");
CREATE INDEX "kc_pypk_dm" ON "kc_pypk"("dm");
CREATE INDEX "kc_pypk_bz" ON "kc_pypk"("ibzbak","bz","iykbz");
CREATE  INDEX "kc_pz_pk" ON "kc_pz"("id");
CREATE INDEX "kc_pz_zwpzh" ON "kc_pz"("spp");
CREATE INDEX "kc_pz_pzh" ON "kc_pz"("pzh");
CREATE INDEX "kc_qx_pk" ON "kc_qx"("xm");
CREATE  INDEX "kc_xeset_pk" ON "kc_xeset"("id");
CREATE INDEX "kc_xeset_xe" ON "kc_xeset"("dm","smon","bmdm","ckdm");
CREATE INDEX "kc_xeset_pld" ON "kc_xeset"("dm","ckdm");
CREATE INDEX "kc_xeset_num" ON "kc_xeset"("num","nums");
CREATE INDEX "kc_yt_pk" ON "kc_yt"("dm");
CREATE INDEX "kc_jt_x" ON "kc_jt"("smon","dm");
CREATE INDEX "kc_jt_dm" ON "kc_jt"("dm");