/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.util.Date;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.cmc.BodyPartID;
import org.bouncycastle.asn1.cmc.CMCFailInfo;
import org.bouncycastle.asn1.cmc.CMCStatus;
import org.bouncycastle.asn1.cmc.CMCStatusInfo;
import org.bouncycastle.asn1.cmc.CMCStatusInfoBuilder;
import org.bouncycastle.asn1.cmc.PendInfo;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class CMCStatusInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        CMCStatusInfoTest.runTest(new CMCStatusInfoTest());
    }

    @Override
    public String getName() {
        return "CMCStatusInfoTest";
    }

    @Override
    public void performTest() throws Exception {
        CMCStatusInfoBuilder bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L));
        CMCStatusInfo cmsInfo = bldr.build();
        this.isTrue("Has statusString", cmsInfo.getStatusString() == null);
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        byte[] b = cmsInfo.getEncoded();
        CMCStatusInfo res = CMCStatusInfo.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats");
        cmsInfo = bldr.build();
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfo.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(new PendInfo(Strings.toByteArray("fish"), new DERGeneralizedTime(new Date())));
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, cmsInfo.getOtherInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfo.getInstance(b);
        this.isEquals("With optional info: PendInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, res.getOtherInfo().isFailInfo());
        bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(CMCFailInfo.authDataFail);
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is fail info", true, cmsInfo.getOtherInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfo.getInstance(b);
        this.isEquals("With optional info: CMCFailInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is fail info", true, res.getOtherInfo().isFailInfo());
    }
}

