/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class EqualsAndHashCodeTest
implements Test {
    @Override
    public TestResult perform() {
        byte[] byArray = new byte[7];
        byArray[1] = 1;
        byArray[3] = 1;
        byArray[6] = 1;
        byte[] data = byArray;
        ASN1Primitive[] values = new ASN1Primitive[]{new BERConstructedOctetString(data), new BERSequence(new DERPrintableString("hello world")), new BERSet(new DERPrintableString("hello world")), new BERTaggedObject(0, new DERPrintableString("hello world")), new DERApplicationSpecific(0, data), new DERBitString(data), new DERBMPString("hello world"), new ASN1Boolean(true), new ASN1Boolean(false), new ASN1Enumerated(100), new DERGeneralizedTime("20070315173729Z"), new DERGeneralString("hello world"), new DERIA5String("hello"), new ASN1Integer(1000L), new DERNull(), new DERNumericString("123456"), new ASN1ObjectIdentifier("1.1.1.10000.1"), new DEROctetString(data), new DERPrintableString("hello world"), new DERSequence(new DERPrintableString("hello world")), new DERSet(new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, new DERPrintableString("hello world")), new DERUniversalString(data), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world"), new DERGraphicString(Hex.decode("deadbeef")), new DERVideotexString(Strings.toByteArray("Hello World"))};
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            int i = 0;
            while (i != values.length) {
                aOut.writeObject(values[i]);
                ++i;
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            int i2 = 0;
            while (i2 != values.length) {
                ASN1Primitive o = aIn.readObject();
                if (!o.equals(values[i2])) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed equality test for " + o.getClass());
                }
                if (o.hashCode() != values[i2].hashCode()) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed hashCode test for " + o.getClass());
                }
                ++i2;
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + e.toString(), e);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    @Override
    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] args) {
        EqualsAndHashCodeTest test = new EqualsAndHashCodeTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

