/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.util.Random;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.icao.DataGroupHash;
import org.bouncycastle.asn1.icao.LDSSecurityObject;
import org.bouncycastle.asn1.icao.LDSVersionInfo;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.test.SimpleTest;

public class LDSSecurityObjectUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "LDSSecurityObject";
    }

    private byte[] generateHash() {
        Random rand = new Random();
        byte[] bytes = new byte[20];
        int i = 0;
        while (i != bytes.length) {
            bytes[i] = (byte)rand.nextInt();
            ++i;
        }
        return bytes;
    }

    @Override
    public void performTest() throws Exception {
        AlgorithmIdentifier algoId = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        DataGroupHash[] datas = new DataGroupHash[]{new DataGroupHash(1, new DEROctetString(this.generateHash())), new DataGroupHash(2, new DEROctetString(this.generateHash()))};
        LDSSecurityObject so = new LDSSecurityObject(algoId, datas);
        this.checkConstruction(so, algoId, datas);
        LDSVersionInfo versionInfo = new LDSVersionInfo("Hello", "world");
        so = new LDSSecurityObject(algoId, datas, versionInfo);
        this.checkConstruction(so, algoId, datas, versionInfo);
        try {
            LDSSecurityObject.getInstance(null);
        }
        catch (Exception e) {
            this.fail("getInstance() failed to handle null.");
        }
        try {
            LDSSecurityObject.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            LDSSecurityObject.getInstance(new DERSequence(v));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LDSSecurityObject(algoId, new DataGroupHash[1]);
            this.fail("constructor failed to detect small DataGroupHash array.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LDSSecurityObject(algoId, new DataGroupHash[17]);
            this.fail("constructor failed to out of bounds DataGroupHash array.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(LDSSecurityObject so, AlgorithmIdentifier digestAlgorithmIdentifier, DataGroupHash[] datagroupHash) throws IOException {
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash, null);
        so = LDSSecurityObject.getInstance(so);
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash, null);
        ASN1InputStream aIn = new ASN1InputStream(so.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        so = LDSSecurityObject.getInstance(seq);
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash, null);
    }

    private void checkConstruction(LDSSecurityObject so, AlgorithmIdentifier digestAlgorithmIdentifier, DataGroupHash[] datagroupHash, LDSVersionInfo versionInfo) throws IOException {
        if (so.getVersion() != 1) {
            this.fail("version number not 1");
        }
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash, versionInfo);
        so = LDSSecurityObject.getInstance(so);
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash, versionInfo);
        ASN1InputStream aIn = new ASN1InputStream(so.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        so = LDSSecurityObject.getInstance(seq);
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash, versionInfo);
    }

    private void checkStatement(LDSSecurityObject so, AlgorithmIdentifier digestAlgorithmIdentifier, DataGroupHash[] datagroupHash, LDSVersionInfo versionInfo) {
        if (digestAlgorithmIdentifier != null) {
            if (!so.getDigestAlgorithmIdentifier().equals(digestAlgorithmIdentifier)) {
                this.fail("ids don't match.");
            }
        } else if (so.getDigestAlgorithmIdentifier() != null) {
            this.fail("digest algorithm Id found when none expected.");
        }
        if (datagroupHash != null) {
            DataGroupHash[] datas = so.getDatagroupHash();
            int i = 0;
            while (i != datas.length) {
                if (!datagroupHash[i].equals(datas[i])) {
                    this.fail("name registration authorities don't match.");
                }
                ++i;
            }
        } else if (so.getDatagroupHash() != null) {
            this.fail("data hash groups found when none expected.");
        }
        if (versionInfo != null) {
            if (!versionInfo.equals(so.getVersionInfo())) {
                this.fail("versionInfo doesn't match");
            }
        } else if (so.getVersionInfo() != null) {
            this.fail("version info found when none expected.");
        }
    }

    public static void main(String[] args) {
        LDSSecurityObjectUnitTest.runTest(new LDSSecurityObjectUnitTest());
    }
}

