/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.x509.Extensions;

public class TimeStampReq
extends ASN1Object {
    ASN1Integer version;
    MessageImprint messageImprint;
    ASN1ObjectIdentifier tsaPolicy;
    ASN1Integer nonce;
    ASN1Boolean certReq;
    Extensions extensions;

    public static TimeStampReq getInstance(Object o) {
        if (o instanceof TimeStampReq) {
            return (TimeStampReq)o;
        }
        if (o != null) {
            return new TimeStampReq(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private TimeStampReq(ASN1Sequence seq) {
        int nbObjects = seq.size();
        int seqStart = 0;
        this.version = ASN1Integer.getInstance(seq.getObjectAt(seqStart));
        this.messageImprint = MessageImprint.getInstance(seq.getObjectAt(++seqStart));
        int opt = ++seqStart;
        while (opt < nbObjects) {
            ASN1TaggedObject tagged;
            if (seq.getObjectAt(opt) instanceof ASN1ObjectIdentifier) {
                this.tsaPolicy = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(opt));
            } else if (seq.getObjectAt(opt) instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance(seq.getObjectAt(opt));
            } else if (seq.getObjectAt(opt) instanceof ASN1Boolean) {
                this.certReq = ASN1Boolean.getInstance(seq.getObjectAt(opt));
            } else if (seq.getObjectAt(opt) instanceof ASN1TaggedObject && (tagged = (ASN1TaggedObject)seq.getObjectAt(opt)).getTagNo() == 0) {
                this.extensions = Extensions.getInstance(tagged, false);
            }
            ++opt;
        }
    }

    public TimeStampReq(MessageImprint messageImprint, ASN1ObjectIdentifier tsaPolicy, ASN1Integer nonce, ASN1Boolean certReq, Extensions extensions) {
        this.version = new ASN1Integer(1L);
        this.messageImprint = messageImprint;
        this.tsaPolicy = tsaPolicy;
        this.nonce = nonce;
        this.certReq = certReq;
        this.extensions = extensions;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        return this.tsaPolicy;
    }

    public ASN1Integer getNonce() {
        return this.nonce;
    }

    public ASN1Boolean getCertReq() {
        return this.certReq;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.messageImprint);
        if (this.tsaPolicy != null) {
            v.add(this.tsaPolicy);
        }
        if (this.nonce != null) {
            v.add(this.nonce);
        }
        if (this.certReq != null && this.certReq.isTrue()) {
            v.add(this.certReq);
        }
        if (this.extensions != null) {
            v.add(new DERTaggedObject(false, 0, this.extensions));
        }
        return new DERSequence(v);
    }
}

