/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.util.Arrays;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher cipher) {
        this(cipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash) {
        this(cipher, hash, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, byte[] encodingParams) {
        this(cipher, hash, hash, encodingParams);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, Digest mgf1Hash, byte[] encodingParams) {
        this.engine = cipher;
        this.mgf1Hash = mgf1Hash;
        this.defHash = new byte[hash.getDigestSize()];
        hash.reset();
        if (encodingParams != null) {
            hash.update(encodingParams, 0, encodingParams.length);
        }
        hash.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
        } else {
            this.random = new SecureRandom();
        }
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 1 - 2 * this.defHash.length;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (inLen > this.getInputBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] block = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        block[block.length - inLen - 1] = 1;
        System.arraycopy(this.defHash, 0, block, this.defHash.length, this.defHash.length);
        byte[] seed = new byte[this.defHash.length];
        this.random.nextBytes(seed);
        byte[] mask = this.maskGeneratorFunction1(seed, 0, seed.length, block.length - this.defHash.length);
        int i = this.defHash.length;
        while (i != block.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this.defHash.length]);
            ++i;
        }
        System.arraycopy(seed, 0, block, 0, this.defHash.length);
        mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        i = 0;
        while (i != this.defHash.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
            ++i;
        }
        return this.engine.processBlock(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] data = this.engine.processBlock(in, inOff, inLen);
        byte[] block = new byte[this.engine.getOutputBlockSize()];
        System.arraycopy(data, 0, block, block.length - data.length, data.length);
        boolean shortData = block.length < 2 * this.defHash.length + 1;
        byte[] mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        int i = 0;
        while (i != this.defHash.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
            ++i;
        }
        mask = this.maskGeneratorFunction1(block, 0, this.defHash.length, block.length - this.defHash.length);
        i = this.defHash.length;
        while (i != block.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this.defHash.length]);
            ++i;
        }
        boolean defHashWrong = false;
        int i2 = 0;
        while (i2 != this.defHash.length) {
            if (this.defHash[i2] != block[this.defHash.length + i2]) {
                defHashWrong = true;
            }
            ++i2;
        }
        int start = block.length;
        int index = 2 * this.defHash.length;
        while (index != block.length) {
            if (block[index] != 0 & start == block.length) {
                start = index;
            }
            ++index;
        }
        boolean dataStartWrong = start > block.length - 1 | block[start] != 1;
        ++start;
        if (defHashWrong | shortData | dataStartWrong) {
            Arrays.fill(block, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] output = new byte[block.length - start];
        System.arraycopy(block, start, output, 0, output.length);
        return output;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length) {
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.mgf1Hash.getDigestSize()];
        byte[] C2 = new byte[4];
        int counter = 0;
        this.mgf1Hash.reset();
        while (counter < length / hashBuf.length) {
            this.ItoOSP(counter, C2);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C2, 0, C2.length);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, hashBuf.length);
            ++counter;
        }
        if (counter * hashBuf.length < length) {
            this.ItoOSP(counter, C2);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C2, 0, C2.length);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, mask.length - counter * hashBuf.length);
        }
        return mask;
    }
}

