/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class BlockCipherMonteCarloTest
extends SimpleTest {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int id, int iterations, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.iterations = iterations;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    @Override
    public String getName() {
        return String.valueOf(this.engine.getAlgorithmName()) + " Monte Carlo Test " + this.id;
    }

    @Override
    public void performTest() throws Exception {
        int len1;
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        System.arraycopy(this.input, 0, out, 0, out.length);
        int i = 0;
        while (i != this.iterations) {
            len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
            ++i;
        }
        if (!this.areEqual(out, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        cipher.init(false, this.param);
        i = 0;
        while (i != this.iterations) {
            len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
            ++i;
        }
        if (!this.areEqual(this.input, out)) {
            this.fail("failed reversal");
        }
    }
}

