/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class HCFamilyVecTest
extends SimpleTest {
    @Override
    public String getName() {
        return "HC-128 and HC-256 (ecrypt)";
    }

    @Override
    public void performTest() throws Exception {
        this.runTests(new HC128Engine(), "ecrypt_HC-128.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_128K_128IV.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_256K_128IV.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_128K_256IV.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_256K_256IV.txt");
    }

    private void runTests(StreamCipher hc, String fileName) throws IOException {
        InputStreamReader resource = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        PeekableLineReader r = new PeekableLineReader(resource);
        this.runAllVectors(hc, fileName, r);
    }

    private void runAllVectors(StreamCipher hc, String fileName, PeekableLineReader r) throws IOException {
        String line;
        while ((line = r.readLine()) != null) {
            if (!(line = line.trim()).startsWith("Set ")) continue;
            this.runVector(hc, fileName, r, this.dellChar(line, ':'));
        }
    }

    private String dellChar(String s, char c) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i != s.length()) {
            if (s.charAt(i) != c) {
                b.append(s.charAt(i));
            }
            ++i;
        }
        return b.toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void runVector(StreamCipher hc, String fileName, PeekableLineReader r, String vectorName) throws IOException {
        hexKey = HCFamilyVecTest.readBlock(r);
        hexIV = HCFamilyVecTest.readBlock(r);
        cp /* !! */  = new KeyParameter(Hex.decode(hexKey));
        cp /* !! */  = new ParametersWithIV(cp /* !! */ , Hex.decode(hexIV));
        hc.init(true, cp /* !! */ );
        input = new byte[64];
        output = new byte[64];
        digest = new byte[64];
        pos = 0;
        while (true) {
            line1 = r.peekLine().trim();
            equalsPos = line1.indexOf(61);
            lead = line1.substring(0, equalsPos - 1);
            hexData = HCFamilyVecTest.readBlock(r);
            data = Hex.decode(hexData);
            if (lead.equals("xor-digest")) {
                if (Arrays.areEqual(data, digest)) break;
                this.fail("Failed in " + fileName + " for test vector: " + vectorName + " at " + lead);
                break;
            }
            posA = lead.indexOf(91);
            posB = lead.indexOf("..");
            posC = lead.indexOf(93);
            start = Integer.parseInt(lead.substring(posA + 1, posB));
            end = Integer.parseInt(lead.substring(posB + 2, posC));
            if (start % 64 == 0 && end - start == 63) ** GOTO lbl31
            throw new IllegalStateException(String.valueOf(vectorName) + ": " + lead + " not on 64 byte boundaries");
lbl-1000:
            // 1 sources

            {
                hc.processBytes(input, 0, input.length, output, 0);
                HCFamilyVecTest.xor(digest, output);
                pos += 64;
lbl31:
                // 2 sources

                ** while (pos < end)
            }
lbl32:
            // 1 sources

            if (Arrays.areEqual(data, output)) continue;
            this.fail("Failed in " + fileName + " for test vector: " + vectorName + " at " + lead);
        }
    }

    private static String readBlock(PeekableLineReader r) throws IOException {
        String peek;
        String first = r.readLine().trim();
        String result = first.substring(first.lastIndexOf(32) + 1);
        while ((peek = r.peekLine().trim()).length() >= 1 && peek.indexOf(61) < 0) {
            result = String.valueOf(result) + r.readLine().trim();
        }
        return result;
    }

    private static void xor(byte[] digest, byte[] block) {
        int i = 0;
        while (i < digest.length) {
            int n = i;
            digest[n] = (byte)(digest[n] ^ block[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        HCFamilyVecTest.runTest(new HCFamilyVecTest());
    }

    private static class PeekableLineReader
    extends BufferedReader {
        private String peek = super.readLine();

        public PeekableLineReader(Reader r) throws IOException {
            super(r);
        }

        public String peekLine() {
            return this.peek;
        }

        @Override
        public String readLine() throws IOException {
            String tmp = this.peek;
            this.peek = super.readLine();
            return tmp;
        }
    }
}

