/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.kems.RSAKeyEncapsulation;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.util.test.SimpleTest;

public class RSAKeyEncapsulationTest
extends SimpleTest {
    @Override
    public String getName() {
        return "RSAKeyEncapsulation";
    }

    @Override
    public void performTest() throws Exception {
        RSAKeyPairGenerator rsaGen = new RSAKeyPairGenerator();
        rsaGen.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 1024, 5));
        AsymmetricCipherKeyPair keys = rsaGen.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        byte[] out = new byte[128];
        RSAKeyEncapsulation kem = new RSAKeyEncapsulation(kdf, rnd);
        kem.init(keys.getPublic());
        KeyParameter key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        KeyParameter key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed test");
        }
    }

    public static void main(String[] args) {
        RSAKeyEncapsulationTest.runTest(new RSAKeyEncapsulationTest());
    }
}

