/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.tls.DTLSClientProtocol;
import org.bouncycastle.crypto.tls.DigitallySigned;
import org.bouncycastle.crypto.tls.test.TlsTestConfig;

class DTLSTestClientProtocol
extends DTLSClientProtocol {
    protected final TlsTestConfig config;

    public DTLSTestClientProtocol(SecureRandom secureRandom, TlsTestConfig config) {
        super(secureRandom);
        this.config = config;
    }

    @Override
    protected byte[] generateCertificateVerify(DTLSClientProtocol.ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        if (certificateVerify.getAlgorithm() != null && this.config.clientAuthSigAlgClaimed != null) {
            certificateVerify = new DigitallySigned(this.config.clientAuthSigAlgClaimed, certificateVerify.getSignature());
        }
        return super.generateCertificateVerify(state, certificateVerify);
    }
}

