/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.test.DTLSTestCase;
import org.bouncycastle.crypto.tls.test.TlsTestConfig;

public class DTLSTestSuite
extends TestSuite {
    public DTLSTestSuite() {
        super("DTLS");
    }

    public static Test suite() {
        DTLSTestSuite testSuite = new DTLSTestSuite();
        DTLSTestSuite.addFallbackTests(testSuite);
        DTLSTestSuite.addVersionTests(testSuite, ProtocolVersion.DTLSv10);
        DTLSTestSuite.addVersionTests(testSuite, ProtocolVersion.DTLSv12);
        return testSuite;
    }

    private static void addFallbackTests(TestSuite testSuite) {
        TlsTestConfig c = DTLSTestSuite.createDTLSTestConfig(ProtocolVersion.DTLSv12);
        c.clientFallback = true;
        DTLSTestSuite.addTestCase(testSuite, c, "FallbackGood");
        c = DTLSTestSuite.createDTLSTestConfig(ProtocolVersion.DTLSv12);
        c.clientOfferVersion = ProtocolVersion.DTLSv10;
        DTLSTestSuite.addTestCase(testSuite, c, "FallbackNone");
    }

    private static void addVersionTests(TestSuite testSuite, ProtocolVersion version) {
        String prefix = String.valueOf(version.toString().replaceAll("[ \\.]", "")) + "_";
        TlsTestConfig c = DTLSTestSuite.createDTLSTestConfig(version);
        DTLSTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "GoodDefault");
        c = DTLSTestSuite.createDTLSTestConfig(version);
        c.serverCertReq = 0;
        DTLSTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "GoodNoCertReq");
        c = DTLSTestSuite.createDTLSTestConfig(version);
        c.clientAuth = 0;
        DTLSTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "GoodOptionalCertReqDeclined");
    }

    private static void addTestCase(TestSuite testSuite, TlsTestConfig config, String name) {
        testSuite.addTest((Test)new DTLSTestCase(config, name));
    }

    private static TlsTestConfig createDTLSTestConfig(ProtocolVersion version) {
        TlsTestConfig c = new TlsTestConfig();
        c.clientMinimumVersion = ProtocolVersion.DTLSv10;
        c.clientOfferVersion = ProtocolVersion.DTLSv12;
        c.serverMaximumVersion = version;
        c.serverMinimumVersion = ProtocolVersion.DTLSv10;
        return c;
    }

    static abstract class C
    extends TlsTestConfig {
        C() {
        }
    }
}

