/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.AlertDescription;
import org.bouncycastle.crypto.tls.AlertLevel;
import org.bouncycastle.crypto.tls.BasicTlsPSKIdentity;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.PSKTlsClient;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.ServerOnlyTlsAuthentication;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsPSKIdentity;
import org.bouncycastle.crypto.tls.TlsSession;
import org.bouncycastle.crypto.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class MockPSKTlsClient
extends PSKTlsClient {
    TlsSession session;

    MockPSKTlsClient(TlsSession session) {
        this(session, (TlsPSKIdentity)new BasicTlsPSKIdentity("client", new byte[16]));
    }

    MockPSKTlsClient(TlsSession session, TlsPSKIdentity pskIdentity) {
        super(pskIdentity);
        this.session = session;
    }

    @Override
    public TlsSession getSessionToResume() {
        return this.session;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK client raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK client received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        TlsSession newSession = this.context.getResumableSession();
        if (newSession != null) {
            byte[] newSessionID = newSession.getSessionID();
            String hex = Hex.toHexString(newSessionID);
            if (this.session != null && Arrays.areEqual(this.session.getSessionID(), newSessionID)) {
                System.out.println("Resumed session: " + hex);
            } else {
                System.out.println("Established session: " + hex);
            }
            this.session = newSession;
        }
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49208, 179, 183, 141};
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
        return clientExtensions;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
        System.out.println("TLS-PSK client negotiated " + serverVersion);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new ServerOnlyTlsAuthentication(){

            @Override
            public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
                org.bouncycastle.asn1.x509.Certificate[] chain = serverCertificate.getCertificateList();
                System.out.println("TLS-PSK client received server certificate chain of length " + chain.length);
                int i = 0;
                while (i != chain.length) {
                    org.bouncycastle.asn1.x509.Certificate entry = chain[i];
                    System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
                    ++i;
                }
            }
        };
    }
}

